# Lumiere

Lumiere is a Leiningen template for setting up a skeleton full stack Clojure, ClojureScript, and Datomic application.  Since it is based on a subset of the [Luminus template](https://github.com/luminus-framework/luminus-template), almost all of the credit for this belongs to Dmitri Sotnikov, the creator of [Luminus](http://www.luminusweb.net).

## Requirements

Lumiere requires Leiningen version 2.5.3+

## Usage

Run the following command to create a new Lumiere project which uses the default profile template:

```
> lein new lumiere-app <your project name>
```

To start a web server for the application, in the project directory, run:

```
> lein run
> rlwrap lein figwheel
```

To build as a executable [Java ARchive (JAR)][jar] standalone, run the following command:

```
> lein uberjar
```

To run the resulting standalone executable `.jar` file, do as you would with any other:

```
> java -jar target/myapp.jar
```

## Performance Testing

The app can be stress tested by running the [Apache benchmark](https://httpd.apache.org/docs/2.2/programs/ab.html) command:

```
> ab -c 10 -n 1000 http://127.0.0.1:3000/
```

The memory and CPU usage can be inspected by running either `jconsole` or `jvisualvm` and attaching them to a running Luminus server.


## License

Copyright © 2017 Hans Royer

Distributed under the [MIT License](https://opensource.org/licenses/MIT).

[jar]: <http://en.wikipedia.org/wiki/Jar_file>
