(defproject {{name}} "0.1.0"

  :description "FIXME: write description"
  :url "http://example.com/FIXME"
  
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}

  :dependencies [[log4j-edn-config "0.1.1"]
                 [org.slf4j/slf4j-log4j12 "1.7.25"]
                 [org.apache.logging.log4j/log4j-core "2.10.0"]
                 [clj-time "0.14.2"]
                 [metosin/compojure-api "1.1.11"]
                 [cljs-ajax "0.7.3"]
                 [secretary "1.2.3"]
                 [reagent-utils "0.2.1"]
                 [reagent "0.7.0"]
                 [org.clojure/clojurescript "1.9.946" :scope "provided"]
                 [org.clojure/clojure "1.9.0"]
                 [org.clojure/core.async "0.4.474" :exclusions [org.clojure/tools.reader]]
                 [selmer "1.11.5"]
                 [markdown-clj "1.0.2"]
                 [ring-middleware-format "0.7.2"]
                 [metosin/ring-http-response "0.9.0"]
                 [funcool/struct "1.2.0"]
                 [org.webjars/pure "2.83"]
                 [org.clojure/tools.logging "0.4.0"]
                 [org.clojure/tools.nrepl "0.2.13"]
                 [org.clojure/tools.reader "1.1.2"]
                 [org.clojure/tools.cli "0.3.5"]
                 [compojure "1.6.0"]
                 [ring-webjars "0.2.0"]
                 [ring/ring-defaults "0.3.1"]
                 [ring/ring-core "1.6.3"]
                 [expiring-map "0.1.8"]
                 [mount "0.1.11"]
                 [cprop "0.1.11"]
                 [buddy "2.0.0"]
                 [datascript "0.16.3"]
                 [re-frame "0.10.2"]
                 [re-posh "0.1.5"]
                 [com.datomic/datomic-free "0.9.5656" :exclusions [com.google.guava/guava
                                                                   org.slf4j/log4j-over-slf4j
                                                                   org.slf4j/slf4j-nop]]
                 [http-kit "2.2.0"]]

  :min-lein-version "2.6.1"

  :source-paths ["src/clj" "src/cljc"]
  :test-paths ["test/clj"]
  :resource-paths ["resources" "target/cljsbuild"]
  :target-path "target/%s/"

  :main ^:skip-aot {{name}}.core

  :plugins [[lein-cljsbuild "1.1.5"]]
  
  :clean-targets ^{:protect false} [:target-path
                                    [:cljsbuild :builds :app :compiler :output-dir]
                                    [:cljsbuild :builds :app :compiler :output-to]]

  
  :cljsbuild {:builds {:app {:source-paths ["src/cljc" "src/cljs"]
                             :compiler {:output-to "target/cljsbuild/public/js/app.js"
                                        :output-dir "target/cljsbuild/public/js/out"
                                        :externs ["react/externs/react.js"]
                                        :pretty-print true}}}}

  :figwheel {:http-server-root "public"
             :nrepl-port 7002
             :css-dirs ["resources/public/css"]
             :nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}

  
  :profiles {:uberjar {:omit-source true
                       :prep-tasks ["compile" ["cljsbuild" "once" "min"]]
                       :cljsbuild {:builds {:min {:source-paths ["src/cljc" "src/cljs" "env/prod/cljs"]
                                                  :compiler {:output-dir "target/cljsbuild/public/js"
                                                             :output-to "target/cljsbuild/public/js/app.js"
                                                             :source-map
                                                             "target/cljsbuild/public/js/app.js.map"
                                                             :optimizations :advanced
                                                             :pretty-print false
                                                             :closure-warnings {:externs-validation :off
                                                                                :non-standard-jsdoc :off}
                                                             :externs ["react/externs/react.js"]}}}} 
                       :aot :all
                       :uberjar-name "{{name}}.jar"
                       :source-paths ["env/prod/clj"]
                       :resource-paths ["env/prod/resources"]}
             
             :dev           [:project/dev :profiles/dev]
             
             :test          [:project/test :profiles/test]
             
             :project/dev  {:jvm-opts ["-server" "-Dconf=dev-config.edn"]
                            :dependencies [[prone "1.2.0"]
                                           [ring/ring-mock "0.3.2"]
                                           [ring/ring-devel "1.6.3"]
                                           [pjstadig/humane-test-output "0.8.3"]
                                           [doo "0.1.8"]
                                           [figwheel-sidecar "0.5.14"]
                                           [com.cemerick/piggieback "0.2.2"]]
                            :plugins      [[com.jakemccrary/lein-test-refresh "0.19.0"]
                                           [lein-figwheel "0.5.14"]
                                           [lein-doo "0.1.8"]
                                           [org.clojure/clojurescript "1.9.946"]]
                  
                            :cljsbuild {:builds {:app {:source-paths ["src/cljs" "src/cljc" "env/dev/cljs"]
                                                       :figwheel {:on-jsload "{{name}}.core/mount-components"}
                                                       :compiler {:main "{{name}}.app"
                                                                  :asset-path "/js/out"
                                                                  :output-to
                                                                  "target/cljsbuild/public/js/app.js"
                                                                  :output-dir "target/cljsbuild/public/js/out"
                                                                  :optimizations :none
                                                                  :source-map true
                                                                  :pretty-print true}}
                                                 :test {:source-paths ["src/cljc" "src/cljs" "test/cljs"]
                                                        :compiler {:output-to "target/test.js"
                                                                   :main "{{name}}.doo-runner"
                                                                   :optimizations :whitespace
                                                                   :pretty-print true}}}} 
                         
                            :doo {:build "test"}
                            :source-paths ["env/dev/clj"]
                            :resource-paths ["env/dev/resources"]
                            :repl-options {:init-ns user}
                            :injections [(require 'pjstadig.humane-test-output)
                                         (pjstadig.humane-test-output/activate!)]}
             
             :project/test {:jvm-opts ["-server" "-Dconf=test-config.edn"]
                            :resource-paths ["env/test/resources"]
                            :cljsbuild {:builds {:test {:source-paths ["src/cljc" "src/cljs" "test/cljs"]
                                                        :compiler {:output-to "target/test.js"
                                                                   :main "{{name}}.doo-runner"
                                                                   :optimizations :whitespace
                                                                   :pretty-print true}}}}}

             :profiles/dev {}
             :profiles/test {}})
