(ns config.core
  (:require [clojure.java.io :as io]
            [clojure.edn :as edn]
            [environ.core :as environ])
  (:import java.io.PushbackReader))

(defn- read-config-file []
  (try
    (when-let [url (io/resource "config.edn")]
      (with-open [r (-> url io/reader PushbackReader.)]
        (edn/read r)))
    (catch Exception e
      (println (str "WARNING: failed to parse config.edn: " (.getLocalizedMessage e))))))

(defonce env (merge (read-config-file) environ/env))
