# ring-upload-progress

Middleware wrapping [Apache Commons FileUpload](https://commons.apache.org/proper/commons-fileupload/)
to provide upload progress data in ring session.

### usage

```clojure
(ns myapp.middleware
  (:require
    [ring.middleware.upload-progress :as upload]
    [ring.middleware.session :refer [wrap-session]]
    [ring.middleware.session.memory :refer [memory-store]]))
  
(defn wrap-upload-progress []
  (let [session-store (memory-store)]
    (-> hanlder
        (upload/wrap-upload-progress {:store session-store})
        (wrap-session {:store session-store}))))
```

The middleware accepts the handler and a configuration map as parameters. The map should contain the following keys:

* `:store` - session store (this is a required key)
* `:encoding` - character encoding to use for multipart parsing. If not
                specified, uses the request character encoding, or `"UTF-8"`
                if no request character encoding is set.
* `:cookie-name` - the name of the session cookie. defaults to `"ring-session"`

The middleware parses multipart parameters from the request and adds the
following keys to the request map:

* `:multipart-params` - a map of multipart parameters
* `:params`           - a merged map of all types of parameter
* `:read-session`     - a zero-argument function that returns the current content of the session
* `:swap-session!`    - like swap! on the current session

An `:upload-progress` key to the `session` to indicate the current state of any uploads.
