/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.parser;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.parser.FinalText;
import com.lowagie.text.pdf.parser.ParsedText;
import com.lowagie.text.pdf.parser.ParsedTextImpl;
import com.lowagie.text.pdf.parser.TextAssembler;
import com.lowagie.text.pdf.parser.TextAssemblyBuffer;
import com.lowagie.text.pdf.parser.Vector;
import com.lowagie.text.pdf.parser.Word;
import java.util.ArrayList;
import java.util.Collection;

public class MarkedUpTextAssembler
implements TextAssembler {
    private PdfReader _reader;
    private ParsedTextImpl _inProgress = null;
    int _page;
    private int word_id_counter = 1;
    private boolean _usePdfMarkupElements = false;
    Collection<FinalText> result = new ArrayList<FinalText>();
    Collection<TextAssemblyBuffer> partialWords = new ArrayList<TextAssemblyBuffer>();

    MarkedUpTextAssembler(PdfReader pdfReader) {
        this._reader = pdfReader;
    }

    MarkedUpTextAssembler(PdfReader pdfReader, boolean bl) {
        this._reader = pdfReader;
        this._usePdfMarkupElements = bl;
    }

    @Override
    public void process(ParsedText parsedText, String string) {
        this.partialWords.addAll(parsedText.getAsPartialWords());
    }

    @Override
    public void process(FinalText finalText, String string) {
        this.clearAccumulator();
        this.result.add(finalText);
    }

    @Override
    public void process(Word word, String string) {
        this.partialWords.add(word);
    }

    private void clearAccumulator() {
        for (TextAssemblyBuffer textAssemblyBuffer : this.partialWords) {
            textAssemblyBuffer.assemble(this);
        }
        this.partialWords.clear();
        if (this._inProgress != null) {
            this.result.add(this._inProgress.getFinalText(this._reader, this._page, this));
            this._inProgress = null;
        }
    }

    private FinalText concatenateResult(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this._usePdfMarkupElements) {
            stringBuffer.append('<').append(string).append('>');
        }
        for (FinalText finalText : this.result) {
            stringBuffer.append(finalText.getText());
        }
        this.result.clear();
        if (this._usePdfMarkupElements) {
            stringBuffer.append("</");
            int n = string.indexOf(32);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            stringBuffer.append(string).append('>');
        }
        return new FinalText(stringBuffer.toString());
    }

    private FinalText accumulate(Collection<TextAssemblyBuffer> collection) {
        StringBuffer stringBuffer = new StringBuffer();
        for (TextAssemblyBuffer textAssemblyBuffer : collection) {
            stringBuffer.append(textAssemblyBuffer.getText());
        }
        return new FinalText(stringBuffer.toString());
    }

    @Override
    public FinalText endParsingContext(String string) {
        this.clearAccumulator();
        return this.concatenateResult(string);
    }

    @Override
    public void reset() {
        this.result.clear();
        this.partialWords.clear();
        this._inProgress = null;
    }

    @Override
    public void renderText(FinalText finalText) {
        this.result.add(finalText);
    }

    @Override
    public void renderText(ParsedTextImpl parsedTextImpl) {
        float f;
        if (parsedTextImpl.getText().trim().isEmpty()) {
            return;
        }
        boolean bl = this._inProgress == null;
        boolean bl2 = false;
        if (bl) {
            this._inProgress = parsedTextImpl;
            return;
        }
        Vector vector = parsedTextImpl.getStartPoint();
        Vector vector2 = this._inProgress.getStartPoint();
        Vector vector3 = this._inProgress.getEndPoint();
        float f2 = vector3.subtract(vector2).cross(vector2.subtract(vector)).lengthSquared() / vector3.subtract(vector2).lengthSquared();
        if (f2 > (f = parsedTextImpl.getAscent() * 0.25f)) {
            bl2 = true;
        }
        float f3 = vector3.subtract(vector).length();
        if (bl2 || parsedTextImpl.getText().startsWith(" ")) {
            this.result.add(this._inProgress.getFinalText(this._reader, this._page, this));
            this.result.add(new FinalText("\n"));
            if (this._usePdfMarkupElements) {
                this.result.add(new FinalText("<br class='t-pdf' />"));
            }
            this._inProgress = parsedTextImpl;
        } else if ((double)f3 < (double)parsedTextImpl.getSingleSpaceWidth() / 2.5) {
            this._inProgress = new Word(this._inProgress.getText().trim() + parsedTextImpl.getText().trim(), parsedTextImpl.getAscent(), parsedTextImpl.getDescent(), vector2, parsedTextImpl.getEndPoint(), parsedTextImpl.getSingleSpaceWidth());
        } else {
            this.result.add(this._inProgress.getFinalText(this._reader, this._page, this));
            this._inProgress = parsedTextImpl;
        }
    }

    protected PdfReader getReader() {
        return this._reader;
    }

    @Override
    public void setPage(int n) {
        this._page = n;
    }

    @Override
    public String getWordId() {
        return "word" + this.word_id_counter++;
    }
}

