/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.parser;

import com.lowagie.text.pdf.CMapAwareDocumentFont;
import com.lowagie.text.pdf.DocumentFont;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.parser.FinalText;
import com.lowagie.text.pdf.parser.GraphicsState;
import com.lowagie.text.pdf.parser.Matrix;
import com.lowagie.text.pdf.parser.ParsedTextImpl;
import com.lowagie.text.pdf.parser.TextAssembler;
import com.lowagie.text.pdf.parser.Vector;
import com.lowagie.text.pdf.parser.Word;
import java.util.ArrayList;
import java.util.List;

public class ParsedText
extends ParsedTextImpl {
    protected final Matrix textToUserSpaceTransformMatrix;
    protected final GraphicsState gs;

    ParsedText(String string, GraphicsState graphicsState, Matrix matrix) {
        this(string, new GraphicsState(graphicsState), matrix, ParsedText.convertWidthToUser(ParsedText.getUnscaledFontSpaceWidth(graphicsState), matrix.multiply(graphicsState.ctm)));
    }

    ParsedText(String string, GraphicsState graphicsState, Matrix matrix, float f) {
        super(string, ParsedText.pointToUserSpace(0.0f, 0.0f, matrix.multiply(graphicsState.ctm)), ParsedText.pointToUserSpace(ParsedText.getStringWidth(string, graphicsState), 0.0f, matrix.multiply(graphicsState.ctm)), ParsedText.convertHeightToUser(graphicsState.font.getFontDescriptor(1, graphicsState.fontSize), matrix.multiply(graphicsState.ctm)), ParsedText.convertHeightToUser(graphicsState.font.getFontDescriptor(3, graphicsState.fontSize), matrix.multiply(graphicsState.ctm)), f);
        this.textToUserSpaceTransformMatrix = matrix.multiply(graphicsState.ctm);
        this.getStartPoint();
        this.gs = graphicsState;
    }

    private static Vector pointToUserSpace(float f, float f2, Matrix matrix) {
        Vector vector = new Vector(f, f2, 1.0f).cross(matrix);
        return vector;
    }

    private static float getUnscaledFontSpaceWidth(GraphicsState graphicsState) {
        char c = ' ';
        if (graphicsState.font.getWidth(c) == 0) {
            c = '\u00a0';
        }
        return ParsedText.getStringWidth(String.valueOf(c), graphicsState);
    }

    private static float getStringWidth(String string, GraphicsState graphicsState) {
        CMapAwareDocumentFont cMapAwareDocumentFont = graphicsState.font;
        char[] cArray = string.toCharArray();
        float f = 0.0f;
        for (char c : cArray) {
            float f2 = (float)((DocumentFont)cMapAwareDocumentFont).getWidth(c) / 1000.0f;
            float f3 = c == ' ' ? graphicsState.wordSpacing : 0.0f;
            f += (f2 * graphicsState.fontSize + graphicsState.characterSpacing + f3) * graphicsState.horizontalScaling;
        }
        return f;
    }

    public List<Word> getAsPartialWords() {
        ArrayList<Word> arrayList = new ArrayList<Word>();
        CMapAwareDocumentFont cMapAwareDocumentFont = this.gs.font;
        char[] cArray = this.getText().toCharArray();
        float f = 0.0f;
        StringBuffer stringBuffer = new StringBuffer(3);
        float f2 = 0.0f;
        for (char c : cArray) {
            float f3;
            float f4 = (float)((DocumentFont)cMapAwareDocumentFont).getWidth(c) / 1000.0f;
            if (Character.isSpaceChar(c) && stringBuffer.length() > 0) {
                arrayList.add(new Word(stringBuffer.toString(), this.getAscent(), this.getDescent(), ParsedText.pointToUserSpace(f2, 0.0f, this.textToUserSpaceTransformMatrix), ParsedText.pointToUserSpace(f, 0.0f, this.textToUserSpaceTransformMatrix), this.getSingleSpaceWidth()));
                stringBuffer = new StringBuffer();
                f3 = c == ' ' ? this.gs.wordSpacing : 0.0f;
                f2 = f += (f4 * this.gs.fontSize + this.gs.characterSpacing + f3) * this.gs.horizontalScaling;
                continue;
            }
            stringBuffer.append(c);
            f3 = c == ' ' ? this.gs.wordSpacing : 0.0f;
            f += (f4 * this.gs.fontSize + this.gs.characterSpacing + f3) * this.gs.horizontalScaling;
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(new Word(stringBuffer.toString(), this.getAscent(), this.getDescent(), ParsedText.pointToUserSpace(f2, 0.0f, this.textToUserSpaceTransformMatrix), ParsedText.pointToUserSpace(f, 0.0f, this.textToUserSpaceTransformMatrix), this.getSingleSpaceWidth()));
        }
        return arrayList;
    }

    public float getUnscaledWidth(GraphicsState graphicsState) {
        return ParsedText.getStringWidth(this.getText(), graphicsState);
    }

    private static float convertWidthToUser(float f, Matrix matrix) {
        Vector vector = ParsedText.pointToUserSpace(0.0f, 0.0f, matrix);
        Vector vector2 = ParsedText.pointToUserSpace(f, 0.0f, matrix);
        return ParsedText.distance(vector, vector2);
    }

    private static float distance(Vector vector, Vector vector2) {
        return vector2.subtract(vector).length();
    }

    private static float convertHeightToUser(float f, Matrix matrix) {
        Vector vector = ParsedText.pointToUserSpace(0.0f, 0.0f, matrix);
        Vector vector2 = ParsedText.pointToUserSpace(0.0f, f, matrix);
        return ParsedText.distance(vector2, vector);
    }

    @Override
    public void accumulate(TextAssembler textAssembler, String string) {
        textAssembler.process(this, string);
    }

    @Override
    public void assemble(TextAssembler textAssembler) {
        textAssembler.renderText(this);
    }

    @Override
    public FinalText getFinalText(PdfReader pdfReader, int n, TextAssembler textAssembler) {
        throw new RuntimeException("Final text should never be called on unprocessed word fragment.");
    }

    public String toString() {
        return "[ParsedText: [" + this.getText() + "] " + this.getStartPoint() + ", " + this.getEndPoint() + "] lead" + "]";
    }
}

