/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.parser;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.parser.FinalText;
import com.lowagie.text.pdf.parser.ParsedTextImpl;
import com.lowagie.text.pdf.parser.TextAssembler;
import com.lowagie.text.pdf.parser.Vector;

public class Word
extends ParsedTextImpl {
    Word(String string, float f, float f2, Vector vector, Vector vector2, float f3) {
        super(string, vector, vector2, f, f2, f3);
    }

    @Override
    public void accumulate(TextAssembler textAssembler, String string) {
        textAssembler.process(this, string);
    }

    @Override
    public void assemble(TextAssembler textAssembler) {
        textAssembler.renderText(this);
    }

    private String wordMarkup(String string, PdfReader pdfReader, int n, TextAssembler textAssembler) {
        Rectangle rectangle = pdfReader.getBoxSize(n, "media");
        Rectangle rectangle2 = pdfReader.getBoxSize(n, "clip");
        rectangle.normalize();
        if (rectangle2 != null) {
            rectangle2.normalize();
        } else {
            Rectangle rectangle3 = pdfReader.getBoxSize(n, "trim");
            if (rectangle3 != null) {
                rectangle3.normalize();
                rectangle2 = rectangle3;
            } else {
                rectangle2 = rectangle;
            }
        }
        float f = rectangle2.getLeft() - rectangle.getLeft();
        float f2 = rectangle2.getTop() - rectangle.getTop();
        Vector vector = this.getStartPoint();
        Vector vector2 = this.getEndPoint();
        float f3 = rectangle2.getWidth();
        float f4 = rectangle2.getHeight();
        float f5 = (float)((double)((vector.get(0) - f) / f3) * 100.0);
        float f6 = vector2.get(1) + f2 - this.getDescent();
        float f7 = f6 / f4 * 100.0f;
        StringBuilder stringBuilder = new StringBuilder();
        float f8 = this.getWidth();
        float f9 = f8 / f3 * 100.0f;
        float f10 = this.getAscent();
        float f11 = f10 / f4 * 100.0f;
        String string2 = textAssembler.getWordId();
        stringBuilder.append("<span class=\"t-word\" style=\"bottom: ").append(f7).append("%; left: ").append(f5).append("%; width: ").append(f9).append("%; height: ").append(f11).append("%;\"").append(" id=\"").append(string2).append("\">").append(Word.escapeHTML(string)).append(" ");
        stringBuilder.append("</span> ");
        return stringBuilder.toString();
    }

    private static String escapeHTML(String string) {
        return string.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    @Override
    public FinalText getFinalText(PdfReader pdfReader, int n, TextAssembler textAssembler) {
        return new FinalText(this.wordMarkup(this.getText().trim(), pdfReader, n, textAssembler));
    }

    public String toString() {
        return "[Word: [" + this.getText() + "] " + this.getStartPoint() + ", " + this.getEndPoint() + "] lead" + this.getAscent() + "]";
    }
}

