(ns {{project-ns}}.core
  (:require [cljs.nodejs]
            [hiccups.runtime :as hiccupsrt])
  (:require-macros [hiccups.core :as hiccups :refer [html]]))

(cljs.nodejs/enable-util-print!)

(defn handler [req res]
  (.send res (html
              [:html
               [:body
                [:h2 "Hello World!"]]])))

(defn main [& args]
  (let [express (js/require "express")
        app     (express)
        port    (or (.-PORT (.-env js/process)) 3000)]
  (.get app "/" handler)
    (.listen app
           port
           #(println "Example app listening on port:" port))))

(set! *main-cli-fn* main)
