(ns {{project-ns}}.core
  (:require
    [{{project-ns}}.routes :refer [routes]]
    [bidi.bidi :as bidi]
    [cljs.nodejs]
    [macchiato.http :refer [handler]]
    [mount.core :as mount :refer [defstate]]
    [taoensso.timbre :refer-macros [log trace debug info warn error fatal]]))

(mount/in-cljc-mode)

(cljs.nodejs/enable-util-print!)

(defstate http :start (js/require "http"))

(defn app []
  (let [host (or (.-HOST (.-env js/process)) "127.0.0.1")
        port (or (.-PORT (.-env js/process)) 3000)]
    (mount/start)
    (-> @http
        (.createServer (handler #(->> % :uri (bidi/match-route routes) :handler)))
        (.listen port host #(info "{{name}} started on" host ":" port)))))

(defn start-workers [os cluster]
  (dotimes [_ (-> os .cpus .-length)]
    (.fork cluster))
  (.on cluster "exit"
       (fn [worker code signal]
         (info "worker terminated" (-> worker .-process .-pid)))))

(defn main [& args]
  (let [os      (js/require "os")
        cluster (js/require "cluster")]
    (if (.-isMaster cluster)
      (start-workers os cluster)
      (app))))
