(ns {{project-ns}}.routes
  (:require
    [bidi.bidi :as bidi]
    [hiccups.runtime]
    [macchiato.response :as r])
  (:require-macros
    [hiccups.core :refer [html]]))

(defn home [req res]
  (-> (html
        [:html
         [:body
          [:h2 "Hello World!"]
          [:p
           "Your user-agent is: "
           (str (-> req :headers :user-agent))]]])
      (r/ok)
      (res)))

(defn not-found [req res]
  (-> (html
        [:html
         [:body
          [:h2 (:uri req) " was not found"]]])
      (r/not-found)
      (res)))

(def routes
  ["/"
   [["" home]
    [true not-found]]])

(defn router [req res]
  (let [route (->> req :uri (bidi/match-route routes) :handler)]
    (route req res)))
