(ns macchiato.migrations.core
  (:require [cljs.nodejs :as node]
            [macchiato.fs.path :as path]
            [taoensso.timbre :as timbre
             :refer-macros [info error]]
            ["postgrator" :as postgrator]))

(defn- translate-config [{:keys [migration-dir
                                 schema-table
                                 driver
                                 host
                                 port
                                 database
                                 username
                                 password
                                 connection-string
                                 request-timeout
                                 options]
                          :or   {migration-dir (str js/__dirname path/separator "migrations")
                                 schema-table  "schema_migrations"}}]
  (clj->js
    (merge
     {:migrationDirectory migration-dir
      :schemaTable        schema-table
      :driver             driver
      :host               host
      :database           database
      :username           username
      :password           password
      :connectionString   connection-string}
     (when request-timeout
       {:requestTimeout request-timeout})
     (when options
       {:options (clj->js options)}))))

(defn- on-end-migrations [cb]
  (fn [err migrations]
    (if err
      (error err)
      (info migrations))
    (.endConnection postgrator (or cb #(info "done")))))

(defn migrate
  ([config] (migrate config "max" nil))
  ([config version] (migrate config version nil))
  ([config version cb]
   (.setConfig postgrator (translate-config config))
   (.on postgrator "migration-started" #(info "starting migration:" %))
   (.on postgrator "migration-finished" #(info "ending migration:" %))
   (.migrate postgrator version (on-end-migrations cb))))
