// Compiled by ClojureScript 1.9.946 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__54565 = arguments.length;
switch (G__54565) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async54566 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async54566 = (function (f,blockable,meta54567){
this.f = f;
this.blockable = blockable;
this.meta54567 = meta54567;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async54566.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_54568,meta54567__$1){
var self__ = this;
var _54568__$1 = this;
return (new cljs.core.async.t_cljs$core$async54566(self__.f,self__.blockable,meta54567__$1));
});

cljs.core.async.t_cljs$core$async54566.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_54568){
var self__ = this;
var _54568__$1 = this;
return self__.meta54567;
});

cljs.core.async.t_cljs$core$async54566.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async54566.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async54566.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async54566.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async54566.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta54567","meta54567",1273159750,null)], null);
});

cljs.core.async.t_cljs$core$async54566.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async54566.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async54566";

cljs.core.async.t_cljs$core$async54566.cljs$lang$ctorPrWriter = (function (this__47746__auto__,writer__47747__auto__,opt__47748__auto__){
return cljs.core._write.call(null,writer__47747__auto__,"cljs.core.async/t_cljs$core$async54566");
});

cljs.core.async.__GT_t_cljs$core$async54566 = (function cljs$core$async$__GT_t_cljs$core$async54566(f__$1,blockable__$1,meta54567){
return (new cljs.core.async.t_cljs$core$async54566(f__$1,blockable__$1,meta54567));
});

}

return (new cljs.core.async.t_cljs$core$async54566(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__54611 = arguments.length;
switch (G__54611) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__54625 = arguments.length;
switch (G__54625) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__54635 = arguments.length;
switch (G__54635) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_54641 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_54641);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_54641,ret){
return (function (){
return fn1.call(null,val_54641);
});})(val_54641,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__54655 = arguments.length;
switch (G__54655) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5457__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5457__auto__)){
var ret = temp__5457__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5457__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5457__auto__)){
var retb = temp__5457__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5457__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5457__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__48120__auto___54695 = n;
var x_54696 = (0);
while(true){
if((x_54696 < n__48120__auto___54695)){
(a[x_54696] = (0));

var G__54697 = (x_54696 + (1));
x_54696 = G__54697;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__54701 = (i + (1));
i = G__54701;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async54707 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async54707 = (function (flag,meta54708){
this.flag = flag;
this.meta54708 = meta54708;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async54707.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_54709,meta54708__$1){
var self__ = this;
var _54709__$1 = this;
return (new cljs.core.async.t_cljs$core$async54707(self__.flag,meta54708__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async54707.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_54709){
var self__ = this;
var _54709__$1 = this;
return self__.meta54708;
});})(flag))
;

cljs.core.async.t_cljs$core$async54707.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async54707.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async54707.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async54707.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async54707.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta54708","meta54708",-472103179,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async54707.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async54707.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async54707";

cljs.core.async.t_cljs$core$async54707.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__47746__auto__,writer__47747__auto__,opt__47748__auto__){
return cljs.core._write.call(null,writer__47747__auto__,"cljs.core.async/t_cljs$core$async54707");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async54707 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async54707(flag__$1,meta54708){
return (new cljs.core.async.t_cljs$core$async54707(flag__$1,meta54708));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async54707(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async54758 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async54758 = (function (flag,cb,meta54759){
this.flag = flag;
this.cb = cb;
this.meta54759 = meta54759;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async54758.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_54760,meta54759__$1){
var self__ = this;
var _54760__$1 = this;
return (new cljs.core.async.t_cljs$core$async54758(self__.flag,self__.cb,meta54759__$1));
});

cljs.core.async.t_cljs$core$async54758.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_54760){
var self__ = this;
var _54760__$1 = this;
return self__.meta54759;
});

cljs.core.async.t_cljs$core$async54758.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async54758.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async54758.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async54758.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async54758.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta54759","meta54759",431126483,null)], null);
});

cljs.core.async.t_cljs$core$async54758.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async54758.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async54758";

cljs.core.async.t_cljs$core$async54758.cljs$lang$ctorPrWriter = (function (this__47746__auto__,writer__47747__auto__,opt__47748__auto__){
return cljs.core._write.call(null,writer__47747__auto__,"cljs.core.async/t_cljs$core$async54758");
});

cljs.core.async.__GT_t_cljs$core$async54758 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async54758(flag__$1,cb__$1,meta54759){
return (new cljs.core.async.t_cljs$core$async54758(flag__$1,cb__$1,meta54759));
});

}

return (new cljs.core.async.t_cljs$core$async54758(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__54779_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__54779_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__54780_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__54780_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__47075__auto__ = wport;
if(cljs.core.truth_(or__47075__auto__)){
return or__47075__auto__;
} else {
return port;
}
})()], null));
} else {
var G__54784 = (i + (1));
i = G__54784;
continue;
}
} else {
return null;
}
break;
}
})();
var or__47075__auto__ = ret;
if(cljs.core.truth_(or__47075__auto__)){
return or__47075__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5459__auto__ = (function (){var and__47063__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__47063__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__47063__auto__;
}
})();
if(cljs.core.truth_(temp__5459__auto__)){
var got = temp__5459__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__48361__auto__ = [];
var len__48354__auto___54791 = arguments.length;
var i__48355__auto___54792 = (0);
while(true){
if((i__48355__auto___54792 < len__48354__auto___54791)){
args__48361__auto__.push((arguments[i__48355__auto___54792]));

var G__54793 = (i__48355__auto___54792 + (1));
i__48355__auto___54792 = G__54793;
continue;
} else {
}
break;
}

var argseq__48362__auto__ = ((((1) < args__48361__auto__.length))?(new cljs.core.IndexedSeq(args__48361__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__48362__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__54788){
var map__54789 = p__54788;
var map__54789__$1 = ((((!((map__54789 == null)))?((((map__54789.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54789.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54789):map__54789);
var opts = map__54789__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq54786){
var G__54787 = cljs.core.first.call(null,seq54786);
var seq54786__$1 = cljs.core.next.call(null,seq54786);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__54787,seq54786__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__54795 = arguments.length;
switch (G__54795) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__50041__auto___54846 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto___54846){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto___54846){
return (function (state_54822){
var state_val_54823 = (state_54822[(1)]);
if((state_val_54823 === (7))){
var inst_54816 = (state_54822[(2)]);
var state_54822__$1 = state_54822;
var statearr_54824_54847 = state_54822__$1;
(statearr_54824_54847[(2)] = inst_54816);

(statearr_54824_54847[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (1))){
var state_54822__$1 = state_54822;
var statearr_54825_54848 = state_54822__$1;
(statearr_54825_54848[(2)] = null);

(statearr_54825_54848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (4))){
var inst_54799 = (state_54822[(7)]);
var inst_54799__$1 = (state_54822[(2)]);
var inst_54800 = (inst_54799__$1 == null);
var state_54822__$1 = (function (){var statearr_54826 = state_54822;
(statearr_54826[(7)] = inst_54799__$1);

return statearr_54826;
})();
if(cljs.core.truth_(inst_54800)){
var statearr_54827_54849 = state_54822__$1;
(statearr_54827_54849[(1)] = (5));

} else {
var statearr_54828_54850 = state_54822__$1;
(statearr_54828_54850[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (13))){
var state_54822__$1 = state_54822;
var statearr_54830_54851 = state_54822__$1;
(statearr_54830_54851[(2)] = null);

(statearr_54830_54851[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (6))){
var inst_54799 = (state_54822[(7)]);
var state_54822__$1 = state_54822;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54822__$1,(11),to,inst_54799);
} else {
if((state_val_54823 === (3))){
var inst_54819 = (state_54822[(2)]);
var state_54822__$1 = state_54822;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54822__$1,inst_54819);
} else {
if((state_val_54823 === (12))){
var state_54822__$1 = state_54822;
var statearr_54831_54852 = state_54822__$1;
(statearr_54831_54852[(2)] = null);

(statearr_54831_54852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (2))){
var state_54822__$1 = state_54822;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54822__$1,(4),from);
} else {
if((state_val_54823 === (11))){
var inst_54809 = (state_54822[(2)]);
var state_54822__$1 = state_54822;
if(cljs.core.truth_(inst_54809)){
var statearr_54832_54853 = state_54822__$1;
(statearr_54832_54853[(1)] = (12));

} else {
var statearr_54833_54854 = state_54822__$1;
(statearr_54833_54854[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (9))){
var state_54822__$1 = state_54822;
var statearr_54834_54855 = state_54822__$1;
(statearr_54834_54855[(2)] = null);

(statearr_54834_54855[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (5))){
var state_54822__$1 = state_54822;
if(cljs.core.truth_(close_QMARK_)){
var statearr_54835_54856 = state_54822__$1;
(statearr_54835_54856[(1)] = (8));

} else {
var statearr_54836_54857 = state_54822__$1;
(statearr_54836_54857[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (14))){
var inst_54814 = (state_54822[(2)]);
var state_54822__$1 = state_54822;
var statearr_54837_54858 = state_54822__$1;
(statearr_54837_54858[(2)] = inst_54814);

(statearr_54837_54858[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (10))){
var inst_54806 = (state_54822[(2)]);
var state_54822__$1 = state_54822;
var statearr_54838_54859 = state_54822__$1;
(statearr_54838_54859[(2)] = inst_54806);

(statearr_54838_54859[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (8))){
var inst_54803 = cljs.core.async.close_BANG_.call(null,to);
var state_54822__$1 = state_54822;
var statearr_54839_54860 = state_54822__$1;
(statearr_54839_54860[(2)] = inst_54803);

(statearr_54839_54860[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__50041__auto___54846))
;
return ((function (switch__50018__auto__,c__50041__auto___54846){
return (function() {
var cljs$core$async$state_machine__50019__auto__ = null;
var cljs$core$async$state_machine__50019__auto____0 = (function (){
var statearr_54840 = [null,null,null,null,null,null,null,null];
(statearr_54840[(0)] = cljs$core$async$state_machine__50019__auto__);

(statearr_54840[(1)] = (1));

return statearr_54840;
});
var cljs$core$async$state_machine__50019__auto____1 = (function (state_54822){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_54822);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e54841){if((e54841 instanceof Object)){
var ex__50022__auto__ = e54841;
var statearr_54842_54861 = state_54822;
(statearr_54842_54861[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54822);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54841;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54863 = state_54822;
state_54822 = G__54863;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
cljs$core$async$state_machine__50019__auto__ = function(state_54822){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__50019__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__50019__auto____1.call(this,state_54822);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__50019__auto____0;
cljs$core$async$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__50019__auto____1;
return cljs$core$async$state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto___54846))
})();
var state__50043__auto__ = (function (){var statearr_54844 = f__50042__auto__.call(null);
(statearr_54844[(6)] = c__50041__auto___54846);

return statearr_54844;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto___54846))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__54864){
var vec__54865 = p__54864;
var v = cljs.core.nth.call(null,vec__54865,(0),null);
var p = cljs.core.nth.call(null,vec__54865,(1),null);
var job = vec__54865;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__50041__auto___55062 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto___55062,res,vec__54865,v,p,job,jobs,results){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto___55062,res,vec__54865,v,p,job,jobs,results){
return (function (state_54873){
var state_val_54874 = (state_54873[(1)]);
if((state_val_54874 === (1))){
var state_54873__$1 = state_54873;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54873__$1,(2),res,v);
} else {
if((state_val_54874 === (2))){
var inst_54870 = (state_54873[(2)]);
var inst_54871 = cljs.core.async.close_BANG_.call(null,res);
var state_54873__$1 = (function (){var statearr_54875 = state_54873;
(statearr_54875[(7)] = inst_54870);

return statearr_54875;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54873__$1,inst_54871);
} else {
return null;
}
}
});})(c__50041__auto___55062,res,vec__54865,v,p,job,jobs,results))
;
return ((function (switch__50018__auto__,c__50041__auto___55062,res,vec__54865,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____0 = (function (){
var statearr_54876 = [null,null,null,null,null,null,null,null];
(statearr_54876[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__);

(statearr_54876[(1)] = (1));

return statearr_54876;
});
var cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____1 = (function (state_54873){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_54873);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e54877){if((e54877 instanceof Object)){
var ex__50022__auto__ = e54877;
var statearr_54878_55065 = state_54873;
(statearr_54878_55065[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54873);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54877;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55067 = state_54873;
state_54873 = G__55067;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__ = function(state_54873){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____1.call(this,state_54873);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto___55062,res,vec__54865,v,p,job,jobs,results))
})();
var state__50043__auto__ = (function (){var statearr_54879 = f__50042__auto__.call(null);
(statearr_54879[(6)] = c__50041__auto___55062);

return statearr_54879;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto___55062,res,vec__54865,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__54884){
var vec__54885 = p__54884;
var v = cljs.core.nth.call(null,vec__54885,(0),null);
var p = cljs.core.nth.call(null,vec__54885,(1),null);
var job = vec__54885;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__48120__auto___55068 = n;
var __55069 = (0);
while(true){
if((__55069 < n__48120__auto___55068)){
var G__54888_55071 = type;
var G__54888_55072__$1 = (((G__54888_55071 instanceof cljs.core.Keyword))?G__54888_55071.fqn:null);
switch (G__54888_55072__$1) {
case "compute":
var c__50041__auto___55075 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__55069,c__50041__auto___55075,G__54888_55071,G__54888_55072__$1,n__48120__auto___55068,jobs,results,process,async){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (__55069,c__50041__auto___55075,G__54888_55071,G__54888_55072__$1,n__48120__auto___55068,jobs,results,process,async){
return (function (state_54901){
var state_val_54902 = (state_54901[(1)]);
if((state_val_54902 === (1))){
var state_54901__$1 = state_54901;
var statearr_54903_55076 = state_54901__$1;
(statearr_54903_55076[(2)] = null);

(statearr_54903_55076[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54902 === (2))){
var state_54901__$1 = state_54901;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54901__$1,(4),jobs);
} else {
if((state_val_54902 === (3))){
var inst_54899 = (state_54901[(2)]);
var state_54901__$1 = state_54901;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54901__$1,inst_54899);
} else {
if((state_val_54902 === (4))){
var inst_54891 = (state_54901[(2)]);
var inst_54892 = process.call(null,inst_54891);
var state_54901__$1 = state_54901;
if(cljs.core.truth_(inst_54892)){
var statearr_54907_55078 = state_54901__$1;
(statearr_54907_55078[(1)] = (5));

} else {
var statearr_54908_55079 = state_54901__$1;
(statearr_54908_55079[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54902 === (5))){
var state_54901__$1 = state_54901;
var statearr_54910_55082 = state_54901__$1;
(statearr_54910_55082[(2)] = null);

(statearr_54910_55082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54902 === (6))){
var state_54901__$1 = state_54901;
var statearr_54911_55083 = state_54901__$1;
(statearr_54911_55083[(2)] = null);

(statearr_54911_55083[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54902 === (7))){
var inst_54897 = (state_54901[(2)]);
var state_54901__$1 = state_54901;
var statearr_54912_55084 = state_54901__$1;
(statearr_54912_55084[(2)] = inst_54897);

(statearr_54912_55084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__55069,c__50041__auto___55075,G__54888_55071,G__54888_55072__$1,n__48120__auto___55068,jobs,results,process,async))
;
return ((function (__55069,switch__50018__auto__,c__50041__auto___55075,G__54888_55071,G__54888_55072__$1,n__48120__auto___55068,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____0 = (function (){
var statearr_54914 = [null,null,null,null,null,null,null];
(statearr_54914[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__);

(statearr_54914[(1)] = (1));

return statearr_54914;
});
var cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____1 = (function (state_54901){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_54901);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e54915){if((e54915 instanceof Object)){
var ex__50022__auto__ = e54915;
var statearr_54916_55086 = state_54901;
(statearr_54916_55086[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54901);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54915;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55087 = state_54901;
state_54901 = G__55087;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__ = function(state_54901){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____1.call(this,state_54901);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__;
})()
;})(__55069,switch__50018__auto__,c__50041__auto___55075,G__54888_55071,G__54888_55072__$1,n__48120__auto___55068,jobs,results,process,async))
})();
var state__50043__auto__ = (function (){var statearr_54917 = f__50042__auto__.call(null);
(statearr_54917[(6)] = c__50041__auto___55075);

return statearr_54917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(__55069,c__50041__auto___55075,G__54888_55071,G__54888_55072__$1,n__48120__auto___55068,jobs,results,process,async))
);


break;
case "async":
var c__50041__auto___55088 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__55069,c__50041__auto___55088,G__54888_55071,G__54888_55072__$1,n__48120__auto___55068,jobs,results,process,async){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (__55069,c__50041__auto___55088,G__54888_55071,G__54888_55072__$1,n__48120__auto___55068,jobs,results,process,async){
return (function (state_54930){
var state_val_54931 = (state_54930[(1)]);
if((state_val_54931 === (1))){
var state_54930__$1 = state_54930;
var statearr_54932_55089 = state_54930__$1;
(statearr_54932_55089[(2)] = null);

(statearr_54932_55089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54931 === (2))){
var state_54930__$1 = state_54930;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54930__$1,(4),jobs);
} else {
if((state_val_54931 === (3))){
var inst_54928 = (state_54930[(2)]);
var state_54930__$1 = state_54930;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54930__$1,inst_54928);
} else {
if((state_val_54931 === (4))){
var inst_54920 = (state_54930[(2)]);
var inst_54921 = async.call(null,inst_54920);
var state_54930__$1 = state_54930;
if(cljs.core.truth_(inst_54921)){
var statearr_54935_55091 = state_54930__$1;
(statearr_54935_55091[(1)] = (5));

} else {
var statearr_54936_55093 = state_54930__$1;
(statearr_54936_55093[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54931 === (5))){
var state_54930__$1 = state_54930;
var statearr_54937_55094 = state_54930__$1;
(statearr_54937_55094[(2)] = null);

(statearr_54937_55094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54931 === (6))){
var state_54930__$1 = state_54930;
var statearr_54938_55095 = state_54930__$1;
(statearr_54938_55095[(2)] = null);

(statearr_54938_55095[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54931 === (7))){
var inst_54926 = (state_54930[(2)]);
var state_54930__$1 = state_54930;
var statearr_54939_55097 = state_54930__$1;
(statearr_54939_55097[(2)] = inst_54926);

(statearr_54939_55097[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__55069,c__50041__auto___55088,G__54888_55071,G__54888_55072__$1,n__48120__auto___55068,jobs,results,process,async))
;
return ((function (__55069,switch__50018__auto__,c__50041__auto___55088,G__54888_55071,G__54888_55072__$1,n__48120__auto___55068,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____0 = (function (){
var statearr_54941 = [null,null,null,null,null,null,null];
(statearr_54941[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__);

(statearr_54941[(1)] = (1));

return statearr_54941;
});
var cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____1 = (function (state_54930){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_54930);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e54942){if((e54942 instanceof Object)){
var ex__50022__auto__ = e54942;
var statearr_54943_55100 = state_54930;
(statearr_54943_55100[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54930);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54942;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55101 = state_54930;
state_54930 = G__55101;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__ = function(state_54930){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____1.call(this,state_54930);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__;
})()
;})(__55069,switch__50018__auto__,c__50041__auto___55088,G__54888_55071,G__54888_55072__$1,n__48120__auto___55068,jobs,results,process,async))
})();
var state__50043__auto__ = (function (){var statearr_54944 = f__50042__auto__.call(null);
(statearr_54944[(6)] = c__50041__auto___55088);

return statearr_54944;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(__55069,c__50041__auto___55088,G__54888_55071,G__54888_55072__$1,n__48120__auto___55068,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__54888_55072__$1)].join('')));

}

var G__55102 = (__55069 + (1));
__55069 = G__55102;
continue;
} else {
}
break;
}

var c__50041__auto___55103 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto___55103,jobs,results,process,async){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto___55103,jobs,results,process,async){
return (function (state_54969){
var state_val_54970 = (state_54969[(1)]);
if((state_val_54970 === (1))){
var state_54969__$1 = state_54969;
var statearr_54972_55105 = state_54969__$1;
(statearr_54972_55105[(2)] = null);

(statearr_54972_55105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54970 === (2))){
var state_54969__$1 = state_54969;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54969__$1,(4),from);
} else {
if((state_val_54970 === (3))){
var inst_54965 = (state_54969[(2)]);
var state_54969__$1 = state_54969;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54969__$1,inst_54965);
} else {
if((state_val_54970 === (4))){
var inst_54948 = (state_54969[(7)]);
var inst_54948__$1 = (state_54969[(2)]);
var inst_54949 = (inst_54948__$1 == null);
var state_54969__$1 = (function (){var statearr_54973 = state_54969;
(statearr_54973[(7)] = inst_54948__$1);

return statearr_54973;
})();
if(cljs.core.truth_(inst_54949)){
var statearr_54974_55106 = state_54969__$1;
(statearr_54974_55106[(1)] = (5));

} else {
var statearr_54975_55107 = state_54969__$1;
(statearr_54975_55107[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54970 === (5))){
var inst_54951 = cljs.core.async.close_BANG_.call(null,jobs);
var state_54969__$1 = state_54969;
var statearr_54976_55108 = state_54969__$1;
(statearr_54976_55108[(2)] = inst_54951);

(statearr_54976_55108[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54970 === (6))){
var inst_54953 = (state_54969[(8)]);
var inst_54948 = (state_54969[(7)]);
var inst_54953__$1 = cljs.core.async.chan.call(null,(1));
var inst_54954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54955 = [inst_54948,inst_54953__$1];
var inst_54956 = (new cljs.core.PersistentVector(null,2,(5),inst_54954,inst_54955,null));
var state_54969__$1 = (function (){var statearr_54977 = state_54969;
(statearr_54977[(8)] = inst_54953__$1);

return statearr_54977;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54969__$1,(8),jobs,inst_54956);
} else {
if((state_val_54970 === (7))){
var inst_54963 = (state_54969[(2)]);
var state_54969__$1 = state_54969;
var statearr_54980_55109 = state_54969__$1;
(statearr_54980_55109[(2)] = inst_54963);

(statearr_54980_55109[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54970 === (8))){
var inst_54953 = (state_54969[(8)]);
var inst_54958 = (state_54969[(2)]);
var state_54969__$1 = (function (){var statearr_54981 = state_54969;
(statearr_54981[(9)] = inst_54958);

return statearr_54981;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54969__$1,(9),results,inst_54953);
} else {
if((state_val_54970 === (9))){
var inst_54960 = (state_54969[(2)]);
var state_54969__$1 = (function (){var statearr_54982 = state_54969;
(statearr_54982[(10)] = inst_54960);

return statearr_54982;
})();
var statearr_54983_55112 = state_54969__$1;
(statearr_54983_55112[(2)] = null);

(statearr_54983_55112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__50041__auto___55103,jobs,results,process,async))
;
return ((function (switch__50018__auto__,c__50041__auto___55103,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____0 = (function (){
var statearr_54984 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54984[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__);

(statearr_54984[(1)] = (1));

return statearr_54984;
});
var cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____1 = (function (state_54969){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_54969);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e54986){if((e54986 instanceof Object)){
var ex__50022__auto__ = e54986;
var statearr_54987_55114 = state_54969;
(statearr_54987_55114[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54969);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54986;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55115 = state_54969;
state_54969 = G__55115;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__ = function(state_54969){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____1.call(this,state_54969);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto___55103,jobs,results,process,async))
})();
var state__50043__auto__ = (function (){var statearr_54988 = f__50042__auto__.call(null);
(statearr_54988[(6)] = c__50041__auto___55103);

return statearr_54988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto___55103,jobs,results,process,async))
);


var c__50041__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto__,jobs,results,process,async){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto__,jobs,results,process,async){
return (function (state_55028){
var state_val_55029 = (state_55028[(1)]);
if((state_val_55029 === (7))){
var inst_55024 = (state_55028[(2)]);
var state_55028__$1 = state_55028;
var statearr_55030_55118 = state_55028__$1;
(statearr_55030_55118[(2)] = inst_55024);

(statearr_55030_55118[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55029 === (20))){
var state_55028__$1 = state_55028;
var statearr_55031_55119 = state_55028__$1;
(statearr_55031_55119[(2)] = null);

(statearr_55031_55119[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55029 === (1))){
var state_55028__$1 = state_55028;
var statearr_55033_55121 = state_55028__$1;
(statearr_55033_55121[(2)] = null);

(statearr_55033_55121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55029 === (4))){
var inst_54991 = (state_55028[(7)]);
var inst_54991__$1 = (state_55028[(2)]);
var inst_54992 = (inst_54991__$1 == null);
var state_55028__$1 = (function (){var statearr_55034 = state_55028;
(statearr_55034[(7)] = inst_54991__$1);

return statearr_55034;
})();
if(cljs.core.truth_(inst_54992)){
var statearr_55035_55122 = state_55028__$1;
(statearr_55035_55122[(1)] = (5));

} else {
var statearr_55036_55123 = state_55028__$1;
(statearr_55036_55123[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55029 === (15))){
var inst_55004 = (state_55028[(8)]);
var state_55028__$1 = state_55028;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55028__$1,(18),to,inst_55004);
} else {
if((state_val_55029 === (21))){
var inst_55018 = (state_55028[(2)]);
var state_55028__$1 = state_55028;
var statearr_55037_55126 = state_55028__$1;
(statearr_55037_55126[(2)] = inst_55018);

(statearr_55037_55126[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55029 === (13))){
var inst_55021 = (state_55028[(2)]);
var state_55028__$1 = (function (){var statearr_55040 = state_55028;
(statearr_55040[(9)] = inst_55021);

return statearr_55040;
})();
var statearr_55041_55127 = state_55028__$1;
(statearr_55041_55127[(2)] = null);

(statearr_55041_55127[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55029 === (6))){
var inst_54991 = (state_55028[(7)]);
var state_55028__$1 = state_55028;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55028__$1,(11),inst_54991);
} else {
if((state_val_55029 === (17))){
var inst_55012 = (state_55028[(2)]);
var state_55028__$1 = state_55028;
if(cljs.core.truth_(inst_55012)){
var statearr_55042_55128 = state_55028__$1;
(statearr_55042_55128[(1)] = (19));

} else {
var statearr_55043_55129 = state_55028__$1;
(statearr_55043_55129[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55029 === (3))){
var inst_55026 = (state_55028[(2)]);
var state_55028__$1 = state_55028;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55028__$1,inst_55026);
} else {
if((state_val_55029 === (12))){
var inst_55001 = (state_55028[(10)]);
var state_55028__$1 = state_55028;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55028__$1,(14),inst_55001);
} else {
if((state_val_55029 === (2))){
var state_55028__$1 = state_55028;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55028__$1,(4),results);
} else {
if((state_val_55029 === (19))){
var state_55028__$1 = state_55028;
var statearr_55045_55131 = state_55028__$1;
(statearr_55045_55131[(2)] = null);

(statearr_55045_55131[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55029 === (11))){
var inst_55001 = (state_55028[(2)]);
var state_55028__$1 = (function (){var statearr_55046 = state_55028;
(statearr_55046[(10)] = inst_55001);

return statearr_55046;
})();
var statearr_55047_55132 = state_55028__$1;
(statearr_55047_55132[(2)] = null);

(statearr_55047_55132[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55029 === (9))){
var state_55028__$1 = state_55028;
var statearr_55048_55133 = state_55028__$1;
(statearr_55048_55133[(2)] = null);

(statearr_55048_55133[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55029 === (5))){
var state_55028__$1 = state_55028;
if(cljs.core.truth_(close_QMARK_)){
var statearr_55049_55134 = state_55028__$1;
(statearr_55049_55134[(1)] = (8));

} else {
var statearr_55050_55135 = state_55028__$1;
(statearr_55050_55135[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55029 === (14))){
var inst_55006 = (state_55028[(11)]);
var inst_55004 = (state_55028[(8)]);
var inst_55004__$1 = (state_55028[(2)]);
var inst_55005 = (inst_55004__$1 == null);
var inst_55006__$1 = cljs.core.not.call(null,inst_55005);
var state_55028__$1 = (function (){var statearr_55051 = state_55028;
(statearr_55051[(11)] = inst_55006__$1);

(statearr_55051[(8)] = inst_55004__$1);

return statearr_55051;
})();
if(inst_55006__$1){
var statearr_55052_55136 = state_55028__$1;
(statearr_55052_55136[(1)] = (15));

} else {
var statearr_55053_55137 = state_55028__$1;
(statearr_55053_55137[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55029 === (16))){
var inst_55006 = (state_55028[(11)]);
var state_55028__$1 = state_55028;
var statearr_55054_55138 = state_55028__$1;
(statearr_55054_55138[(2)] = inst_55006);

(statearr_55054_55138[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55029 === (10))){
var inst_54998 = (state_55028[(2)]);
var state_55028__$1 = state_55028;
var statearr_55055_55139 = state_55028__$1;
(statearr_55055_55139[(2)] = inst_54998);

(statearr_55055_55139[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55029 === (18))){
var inst_55009 = (state_55028[(2)]);
var state_55028__$1 = state_55028;
var statearr_55056_55140 = state_55028__$1;
(statearr_55056_55140[(2)] = inst_55009);

(statearr_55056_55140[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55029 === (8))){
var inst_54995 = cljs.core.async.close_BANG_.call(null,to);
var state_55028__$1 = state_55028;
var statearr_55057_55141 = state_55028__$1;
(statearr_55057_55141[(2)] = inst_54995);

(statearr_55057_55141[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__50041__auto__,jobs,results,process,async))
;
return ((function (switch__50018__auto__,c__50041__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____0 = (function (){
var statearr_55058 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55058[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__);

(statearr_55058[(1)] = (1));

return statearr_55058;
});
var cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____1 = (function (state_55028){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_55028);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e55059){if((e55059 instanceof Object)){
var ex__50022__auto__ = e55059;
var statearr_55060_55144 = state_55028;
(statearr_55060_55144[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55028);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55059;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55145 = state_55028;
state_55028 = G__55145;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__ = function(state_55028){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____1.call(this,state_55028);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__50019__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto__,jobs,results,process,async))
})();
var state__50043__auto__ = (function (){var statearr_55061 = f__50042__auto__.call(null);
(statearr_55061[(6)] = c__50041__auto__);

return statearr_55061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto__,jobs,results,process,async))
);

return c__50041__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__55148 = arguments.length;
switch (G__55148) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__55154 = arguments.length;
switch (G__55154) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__55160 = arguments.length;
switch (G__55160) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__50041__auto___55212 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto___55212,tc,fc){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto___55212,tc,fc){
return (function (state_55186){
var state_val_55187 = (state_55186[(1)]);
if((state_val_55187 === (7))){
var inst_55182 = (state_55186[(2)]);
var state_55186__$1 = state_55186;
var statearr_55188_55215 = state_55186__$1;
(statearr_55188_55215[(2)] = inst_55182);

(statearr_55188_55215[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55187 === (1))){
var state_55186__$1 = state_55186;
var statearr_55190_55224 = state_55186__$1;
(statearr_55190_55224[(2)] = null);

(statearr_55190_55224[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55187 === (4))){
var inst_55163 = (state_55186[(7)]);
var inst_55163__$1 = (state_55186[(2)]);
var inst_55164 = (inst_55163__$1 == null);
var state_55186__$1 = (function (){var statearr_55192 = state_55186;
(statearr_55192[(7)] = inst_55163__$1);

return statearr_55192;
})();
if(cljs.core.truth_(inst_55164)){
var statearr_55193_55233 = state_55186__$1;
(statearr_55193_55233[(1)] = (5));

} else {
var statearr_55194_55234 = state_55186__$1;
(statearr_55194_55234[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55187 === (13))){
var state_55186__$1 = state_55186;
var statearr_55195_55243 = state_55186__$1;
(statearr_55195_55243[(2)] = null);

(statearr_55195_55243[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55187 === (6))){
var inst_55163 = (state_55186[(7)]);
var inst_55169 = p.call(null,inst_55163);
var state_55186__$1 = state_55186;
if(cljs.core.truth_(inst_55169)){
var statearr_55196_55244 = state_55186__$1;
(statearr_55196_55244[(1)] = (9));

} else {
var statearr_55197_55245 = state_55186__$1;
(statearr_55197_55245[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55187 === (3))){
var inst_55184 = (state_55186[(2)]);
var state_55186__$1 = state_55186;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55186__$1,inst_55184);
} else {
if((state_val_55187 === (12))){
var state_55186__$1 = state_55186;
var statearr_55198_55247 = state_55186__$1;
(statearr_55198_55247[(2)] = null);

(statearr_55198_55247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55187 === (2))){
var state_55186__$1 = state_55186;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55186__$1,(4),ch);
} else {
if((state_val_55187 === (11))){
var inst_55163 = (state_55186[(7)]);
var inst_55173 = (state_55186[(2)]);
var state_55186__$1 = state_55186;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55186__$1,(8),inst_55173,inst_55163);
} else {
if((state_val_55187 === (9))){
var state_55186__$1 = state_55186;
var statearr_55199_55248 = state_55186__$1;
(statearr_55199_55248[(2)] = tc);

(statearr_55199_55248[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55187 === (5))){
var inst_55166 = cljs.core.async.close_BANG_.call(null,tc);
var inst_55167 = cljs.core.async.close_BANG_.call(null,fc);
var state_55186__$1 = (function (){var statearr_55200 = state_55186;
(statearr_55200[(8)] = inst_55166);

return statearr_55200;
})();
var statearr_55201_55249 = state_55186__$1;
(statearr_55201_55249[(2)] = inst_55167);

(statearr_55201_55249[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55187 === (14))){
var inst_55180 = (state_55186[(2)]);
var state_55186__$1 = state_55186;
var statearr_55203_55250 = state_55186__$1;
(statearr_55203_55250[(2)] = inst_55180);

(statearr_55203_55250[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55187 === (10))){
var state_55186__$1 = state_55186;
var statearr_55204_55251 = state_55186__$1;
(statearr_55204_55251[(2)] = fc);

(statearr_55204_55251[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55187 === (8))){
var inst_55175 = (state_55186[(2)]);
var state_55186__$1 = state_55186;
if(cljs.core.truth_(inst_55175)){
var statearr_55205_55252 = state_55186__$1;
(statearr_55205_55252[(1)] = (12));

} else {
var statearr_55206_55253 = state_55186__$1;
(statearr_55206_55253[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__50041__auto___55212,tc,fc))
;
return ((function (switch__50018__auto__,c__50041__auto___55212,tc,fc){
return (function() {
var cljs$core$async$state_machine__50019__auto__ = null;
var cljs$core$async$state_machine__50019__auto____0 = (function (){
var statearr_55207 = [null,null,null,null,null,null,null,null,null];
(statearr_55207[(0)] = cljs$core$async$state_machine__50019__auto__);

(statearr_55207[(1)] = (1));

return statearr_55207;
});
var cljs$core$async$state_machine__50019__auto____1 = (function (state_55186){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_55186);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e55208){if((e55208 instanceof Object)){
var ex__50022__auto__ = e55208;
var statearr_55209_55254 = state_55186;
(statearr_55209_55254[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55186);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55208;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55255 = state_55186;
state_55186 = G__55255;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
cljs$core$async$state_machine__50019__auto__ = function(state_55186){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__50019__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__50019__auto____1.call(this,state_55186);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__50019__auto____0;
cljs$core$async$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__50019__auto____1;
return cljs$core$async$state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto___55212,tc,fc))
})();
var state__50043__auto__ = (function (){var statearr_55210 = f__50042__auto__.call(null);
(statearr_55210[(6)] = c__50041__auto___55212);

return statearr_55210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto___55212,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__50041__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto__){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto__){
return (function (state_55278){
var state_val_55279 = (state_55278[(1)]);
if((state_val_55279 === (7))){
var inst_55274 = (state_55278[(2)]);
var state_55278__$1 = state_55278;
var statearr_55280_55302 = state_55278__$1;
(statearr_55280_55302[(2)] = inst_55274);

(statearr_55280_55302[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55279 === (1))){
var inst_55256 = init;
var state_55278__$1 = (function (){var statearr_55281 = state_55278;
(statearr_55281[(7)] = inst_55256);

return statearr_55281;
})();
var statearr_55282_55303 = state_55278__$1;
(statearr_55282_55303[(2)] = null);

(statearr_55282_55303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55279 === (4))){
var inst_55260 = (state_55278[(8)]);
var inst_55260__$1 = (state_55278[(2)]);
var inst_55262 = (inst_55260__$1 == null);
var state_55278__$1 = (function (){var statearr_55283 = state_55278;
(statearr_55283[(8)] = inst_55260__$1);

return statearr_55283;
})();
if(cljs.core.truth_(inst_55262)){
var statearr_55285_55304 = state_55278__$1;
(statearr_55285_55304[(1)] = (5));

} else {
var statearr_55286_55305 = state_55278__$1;
(statearr_55286_55305[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55279 === (6))){
var inst_55256 = (state_55278[(7)]);
var inst_55260 = (state_55278[(8)]);
var inst_55265 = (state_55278[(9)]);
var inst_55265__$1 = f.call(null,inst_55256,inst_55260);
var inst_55266 = cljs.core.reduced_QMARK_.call(null,inst_55265__$1);
var state_55278__$1 = (function (){var statearr_55287 = state_55278;
(statearr_55287[(9)] = inst_55265__$1);

return statearr_55287;
})();
if(inst_55266){
var statearr_55288_55306 = state_55278__$1;
(statearr_55288_55306[(1)] = (8));

} else {
var statearr_55289_55307 = state_55278__$1;
(statearr_55289_55307[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55279 === (3))){
var inst_55276 = (state_55278[(2)]);
var state_55278__$1 = state_55278;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55278__$1,inst_55276);
} else {
if((state_val_55279 === (2))){
var state_55278__$1 = state_55278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55278__$1,(4),ch);
} else {
if((state_val_55279 === (9))){
var inst_55265 = (state_55278[(9)]);
var inst_55256 = inst_55265;
var state_55278__$1 = (function (){var statearr_55290 = state_55278;
(statearr_55290[(7)] = inst_55256);

return statearr_55290;
})();
var statearr_55291_55308 = state_55278__$1;
(statearr_55291_55308[(2)] = null);

(statearr_55291_55308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55279 === (5))){
var inst_55256 = (state_55278[(7)]);
var state_55278__$1 = state_55278;
var statearr_55292_55311 = state_55278__$1;
(statearr_55292_55311[(2)] = inst_55256);

(statearr_55292_55311[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55279 === (10))){
var inst_55272 = (state_55278[(2)]);
var state_55278__$1 = state_55278;
var statearr_55293_55312 = state_55278__$1;
(statearr_55293_55312[(2)] = inst_55272);

(statearr_55293_55312[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55279 === (8))){
var inst_55265 = (state_55278[(9)]);
var inst_55268 = cljs.core.deref.call(null,inst_55265);
var state_55278__$1 = state_55278;
var statearr_55296_55314 = state_55278__$1;
(statearr_55296_55314[(2)] = inst_55268);

(statearr_55296_55314[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__50041__auto__))
;
return ((function (switch__50018__auto__,c__50041__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__50019__auto__ = null;
var cljs$core$async$reduce_$_state_machine__50019__auto____0 = (function (){
var statearr_55297 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55297[(0)] = cljs$core$async$reduce_$_state_machine__50019__auto__);

(statearr_55297[(1)] = (1));

return statearr_55297;
});
var cljs$core$async$reduce_$_state_machine__50019__auto____1 = (function (state_55278){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_55278);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e55298){if((e55298 instanceof Object)){
var ex__50022__auto__ = e55298;
var statearr_55299_55317 = state_55278;
(statearr_55299_55317[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55278);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55298;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55318 = state_55278;
state_55278 = G__55318;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__50019__auto__ = function(state_55278){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__50019__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__50019__auto____1.call(this,state_55278);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__50019__auto____0;
cljs$core$async$reduce_$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__50019__auto____1;
return cljs$core$async$reduce_$_state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto__))
})();
var state__50043__auto__ = (function (){var statearr_55300 = f__50042__auto__.call(null);
(statearr_55300[(6)] = c__50041__auto__);

return statearr_55300;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto__))
);

return c__50041__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__50041__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto__,f__$1){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto__,f__$1){
return (function (state_55325){
var state_val_55326 = (state_55325[(1)]);
if((state_val_55326 === (1))){
var inst_55320 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_55325__$1 = state_55325;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55325__$1,(2),inst_55320);
} else {
if((state_val_55326 === (2))){
var inst_55322 = (state_55325[(2)]);
var inst_55323 = f__$1.call(null,inst_55322);
var state_55325__$1 = state_55325;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55325__$1,inst_55323);
} else {
return null;
}
}
});})(c__50041__auto__,f__$1))
;
return ((function (switch__50018__auto__,c__50041__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__50019__auto__ = null;
var cljs$core$async$transduce_$_state_machine__50019__auto____0 = (function (){
var statearr_55329 = [null,null,null,null,null,null,null];
(statearr_55329[(0)] = cljs$core$async$transduce_$_state_machine__50019__auto__);

(statearr_55329[(1)] = (1));

return statearr_55329;
});
var cljs$core$async$transduce_$_state_machine__50019__auto____1 = (function (state_55325){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_55325);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e55330){if((e55330 instanceof Object)){
var ex__50022__auto__ = e55330;
var statearr_55331_55336 = state_55325;
(statearr_55331_55336[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55325);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55330;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55338 = state_55325;
state_55325 = G__55338;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__50019__auto__ = function(state_55325){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__50019__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__50019__auto____1.call(this,state_55325);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__50019__auto____0;
cljs$core$async$transduce_$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__50019__auto____1;
return cljs$core$async$transduce_$_state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto__,f__$1))
})();
var state__50043__auto__ = (function (){var statearr_55332 = f__50042__auto__.call(null);
(statearr_55332[(6)] = c__50041__auto__);

return statearr_55332;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto__,f__$1))
);

return c__50041__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__55343 = arguments.length;
switch (G__55343) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__50041__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto__){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto__){
return (function (state_55372){
var state_val_55373 = (state_55372[(1)]);
if((state_val_55373 === (7))){
var inst_55354 = (state_55372[(2)]);
var state_55372__$1 = state_55372;
var statearr_55378_55419 = state_55372__$1;
(statearr_55378_55419[(2)] = inst_55354);

(statearr_55378_55419[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55373 === (1))){
var inst_55345 = cljs.core.seq.call(null,coll);
var inst_55346 = inst_55345;
var state_55372__$1 = (function (){var statearr_55380 = state_55372;
(statearr_55380[(7)] = inst_55346);

return statearr_55380;
})();
var statearr_55381_55421 = state_55372__$1;
(statearr_55381_55421[(2)] = null);

(statearr_55381_55421[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55373 === (4))){
var inst_55346 = (state_55372[(7)]);
var inst_55352 = cljs.core.first.call(null,inst_55346);
var state_55372__$1 = state_55372;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55372__$1,(7),ch,inst_55352);
} else {
if((state_val_55373 === (13))){
var inst_55366 = (state_55372[(2)]);
var state_55372__$1 = state_55372;
var statearr_55384_55427 = state_55372__$1;
(statearr_55384_55427[(2)] = inst_55366);

(statearr_55384_55427[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55373 === (6))){
var inst_55357 = (state_55372[(2)]);
var state_55372__$1 = state_55372;
if(cljs.core.truth_(inst_55357)){
var statearr_55386_55432 = state_55372__$1;
(statearr_55386_55432[(1)] = (8));

} else {
var statearr_55387_55433 = state_55372__$1;
(statearr_55387_55433[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55373 === (3))){
var inst_55370 = (state_55372[(2)]);
var state_55372__$1 = state_55372;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55372__$1,inst_55370);
} else {
if((state_val_55373 === (12))){
var state_55372__$1 = state_55372;
var statearr_55389_55443 = state_55372__$1;
(statearr_55389_55443[(2)] = null);

(statearr_55389_55443[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55373 === (2))){
var inst_55346 = (state_55372[(7)]);
var state_55372__$1 = state_55372;
if(cljs.core.truth_(inst_55346)){
var statearr_55391_55449 = state_55372__$1;
(statearr_55391_55449[(1)] = (4));

} else {
var statearr_55392_55450 = state_55372__$1;
(statearr_55392_55450[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55373 === (11))){
var inst_55363 = cljs.core.async.close_BANG_.call(null,ch);
var state_55372__$1 = state_55372;
var statearr_55393_55452 = state_55372__$1;
(statearr_55393_55452[(2)] = inst_55363);

(statearr_55393_55452[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55373 === (9))){
var state_55372__$1 = state_55372;
if(cljs.core.truth_(close_QMARK_)){
var statearr_55394_55456 = state_55372__$1;
(statearr_55394_55456[(1)] = (11));

} else {
var statearr_55397_55459 = state_55372__$1;
(statearr_55397_55459[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55373 === (5))){
var inst_55346 = (state_55372[(7)]);
var state_55372__$1 = state_55372;
var statearr_55400_55468 = state_55372__$1;
(statearr_55400_55468[(2)] = inst_55346);

(statearr_55400_55468[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55373 === (10))){
var inst_55368 = (state_55372[(2)]);
var state_55372__$1 = state_55372;
var statearr_55401_55469 = state_55372__$1;
(statearr_55401_55469[(2)] = inst_55368);

(statearr_55401_55469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55373 === (8))){
var inst_55346 = (state_55372[(7)]);
var inst_55359 = cljs.core.next.call(null,inst_55346);
var inst_55346__$1 = inst_55359;
var state_55372__$1 = (function (){var statearr_55402 = state_55372;
(statearr_55402[(7)] = inst_55346__$1);

return statearr_55402;
})();
var statearr_55403_55480 = state_55372__$1;
(statearr_55403_55480[(2)] = null);

(statearr_55403_55480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__50041__auto__))
;
return ((function (switch__50018__auto__,c__50041__auto__){
return (function() {
var cljs$core$async$state_machine__50019__auto__ = null;
var cljs$core$async$state_machine__50019__auto____0 = (function (){
var statearr_55406 = [null,null,null,null,null,null,null,null];
(statearr_55406[(0)] = cljs$core$async$state_machine__50019__auto__);

(statearr_55406[(1)] = (1));

return statearr_55406;
});
var cljs$core$async$state_machine__50019__auto____1 = (function (state_55372){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_55372);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e55407){if((e55407 instanceof Object)){
var ex__50022__auto__ = e55407;
var statearr_55408_55488 = state_55372;
(statearr_55408_55488[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55372);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55407;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55489 = state_55372;
state_55372 = G__55489;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
cljs$core$async$state_machine__50019__auto__ = function(state_55372){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__50019__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__50019__auto____1.call(this,state_55372);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__50019__auto____0;
cljs$core$async$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__50019__auto____1;
return cljs$core$async$state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto__))
})();
var state__50043__auto__ = (function (){var statearr_55411 = f__50042__auto__.call(null);
(statearr_55411[(6)] = c__50041__auto__);

return statearr_55411;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto__))
);

return c__50041__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__47808__auto__ = (((_ == null))?null:_);
var m__47809__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,_);
} else {
var m__47809__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__47808__auto__ = (((m == null))?null:m);
var m__47809__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__47809__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__47808__auto__ = (((m == null))?null:m);
var m__47809__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,m,ch);
} else {
var m__47809__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__47808__auto__ = (((m == null))?null:m);
var m__47809__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,m);
} else {
var m__47809__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async55513 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async55513 = (function (ch,cs,meta55514){
this.ch = ch;
this.cs = cs;
this.meta55514 = meta55514;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async55513.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_55515,meta55514__$1){
var self__ = this;
var _55515__$1 = this;
return (new cljs.core.async.t_cljs$core$async55513(self__.ch,self__.cs,meta55514__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async55513.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_55515){
var self__ = this;
var _55515__$1 = this;
return self__.meta55514;
});})(cs))
;

cljs.core.async.t_cljs$core$async55513.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55513.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async55513.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55513.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async55513.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async55513.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async55513.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta55514","meta55514",-1615107487,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async55513.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async55513.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async55513";

cljs.core.async.t_cljs$core$async55513.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__47746__auto__,writer__47747__auto__,opt__47748__auto__){
return cljs.core._write.call(null,writer__47747__auto__,"cljs.core.async/t_cljs$core$async55513");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async55513 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async55513(ch__$1,cs__$1,meta55514){
return (new cljs.core.async.t_cljs$core$async55513(ch__$1,cs__$1,meta55514));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async55513(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__50041__auto___55820 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto___55820,cs,m,dchan,dctr,done){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto___55820,cs,m,dchan,dctr,done){
return (function (state_55665){
var state_val_55666 = (state_55665[(1)]);
if((state_val_55666 === (7))){
var inst_55660 = (state_55665[(2)]);
var state_55665__$1 = state_55665;
var statearr_55667_55826 = state_55665__$1;
(statearr_55667_55826[(2)] = inst_55660);

(statearr_55667_55826[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (20))){
var inst_55555 = (state_55665[(7)]);
var inst_55569 = cljs.core.first.call(null,inst_55555);
var inst_55571 = cljs.core.nth.call(null,inst_55569,(0),null);
var inst_55572 = cljs.core.nth.call(null,inst_55569,(1),null);
var state_55665__$1 = (function (){var statearr_55668 = state_55665;
(statearr_55668[(8)] = inst_55571);

return statearr_55668;
})();
if(cljs.core.truth_(inst_55572)){
var statearr_55669_55828 = state_55665__$1;
(statearr_55669_55828[(1)] = (22));

} else {
var statearr_55670_55832 = state_55665__$1;
(statearr_55670_55832[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (27))){
var inst_55602 = (state_55665[(9)]);
var inst_55607 = (state_55665[(10)]);
var inst_55600 = (state_55665[(11)]);
var inst_55524 = (state_55665[(12)]);
var inst_55607__$1 = cljs.core._nth.call(null,inst_55600,inst_55602);
var inst_55608 = cljs.core.async.put_BANG_.call(null,inst_55607__$1,inst_55524,done);
var state_55665__$1 = (function (){var statearr_55676 = state_55665;
(statearr_55676[(10)] = inst_55607__$1);

return statearr_55676;
})();
if(cljs.core.truth_(inst_55608)){
var statearr_55677_55835 = state_55665__$1;
(statearr_55677_55835[(1)] = (30));

} else {
var statearr_55678_55836 = state_55665__$1;
(statearr_55678_55836[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (1))){
var state_55665__$1 = state_55665;
var statearr_55679_55837 = state_55665__$1;
(statearr_55679_55837[(2)] = null);

(statearr_55679_55837[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (24))){
var inst_55555 = (state_55665[(7)]);
var inst_55577 = (state_55665[(2)]);
var inst_55578 = cljs.core.next.call(null,inst_55555);
var inst_55533 = inst_55578;
var inst_55534 = null;
var inst_55535 = (0);
var inst_55536 = (0);
var state_55665__$1 = (function (){var statearr_55680 = state_55665;
(statearr_55680[(13)] = inst_55577);

(statearr_55680[(14)] = inst_55535);

(statearr_55680[(15)] = inst_55533);

(statearr_55680[(16)] = inst_55536);

(statearr_55680[(17)] = inst_55534);

return statearr_55680;
})();
var statearr_55682_55839 = state_55665__$1;
(statearr_55682_55839[(2)] = null);

(statearr_55682_55839[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (39))){
var state_55665__$1 = state_55665;
var statearr_55696_55840 = state_55665__$1;
(statearr_55696_55840[(2)] = null);

(statearr_55696_55840[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (4))){
var inst_55524 = (state_55665[(12)]);
var inst_55524__$1 = (state_55665[(2)]);
var inst_55525 = (inst_55524__$1 == null);
var state_55665__$1 = (function (){var statearr_55697 = state_55665;
(statearr_55697[(12)] = inst_55524__$1);

return statearr_55697;
})();
if(cljs.core.truth_(inst_55525)){
var statearr_55698_55843 = state_55665__$1;
(statearr_55698_55843[(1)] = (5));

} else {
var statearr_55700_55844 = state_55665__$1;
(statearr_55700_55844[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (15))){
var inst_55535 = (state_55665[(14)]);
var inst_55533 = (state_55665[(15)]);
var inst_55536 = (state_55665[(16)]);
var inst_55534 = (state_55665[(17)]);
var inst_55551 = (state_55665[(2)]);
var inst_55552 = (inst_55536 + (1));
var tmp55689 = inst_55535;
var tmp55690 = inst_55533;
var tmp55691 = inst_55534;
var inst_55533__$1 = tmp55690;
var inst_55534__$1 = tmp55691;
var inst_55535__$1 = tmp55689;
var inst_55536__$1 = inst_55552;
var state_55665__$1 = (function (){var statearr_55704 = state_55665;
(statearr_55704[(14)] = inst_55535__$1);

(statearr_55704[(15)] = inst_55533__$1);

(statearr_55704[(18)] = inst_55551);

(statearr_55704[(16)] = inst_55536__$1);

(statearr_55704[(17)] = inst_55534__$1);

return statearr_55704;
})();
var statearr_55706_55846 = state_55665__$1;
(statearr_55706_55846[(2)] = null);

(statearr_55706_55846[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (21))){
var inst_55581 = (state_55665[(2)]);
var state_55665__$1 = state_55665;
var statearr_55711_55847 = state_55665__$1;
(statearr_55711_55847[(2)] = inst_55581);

(statearr_55711_55847[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (31))){
var inst_55607 = (state_55665[(10)]);
var inst_55611 = done.call(null,null);
var inst_55612 = cljs.core.async.untap_STAR_.call(null,m,inst_55607);
var state_55665__$1 = (function (){var statearr_55714 = state_55665;
(statearr_55714[(19)] = inst_55611);

return statearr_55714;
})();
var statearr_55715_55850 = state_55665__$1;
(statearr_55715_55850[(2)] = inst_55612);

(statearr_55715_55850[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (32))){
var inst_55602 = (state_55665[(9)]);
var inst_55600 = (state_55665[(11)]);
var inst_55599 = (state_55665[(20)]);
var inst_55601 = (state_55665[(21)]);
var inst_55614 = (state_55665[(2)]);
var inst_55615 = (inst_55602 + (1));
var tmp55708 = inst_55600;
var tmp55709 = inst_55599;
var tmp55710 = inst_55601;
var inst_55599__$1 = tmp55709;
var inst_55600__$1 = tmp55708;
var inst_55601__$1 = tmp55710;
var inst_55602__$1 = inst_55615;
var state_55665__$1 = (function (){var statearr_55716 = state_55665;
(statearr_55716[(9)] = inst_55602__$1);

(statearr_55716[(11)] = inst_55600__$1);

(statearr_55716[(20)] = inst_55599__$1);

(statearr_55716[(22)] = inst_55614);

(statearr_55716[(21)] = inst_55601__$1);

return statearr_55716;
})();
var statearr_55718_55852 = state_55665__$1;
(statearr_55718_55852[(2)] = null);

(statearr_55718_55852[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (40))){
var inst_55629 = (state_55665[(23)]);
var inst_55633 = done.call(null,null);
var inst_55635 = cljs.core.async.untap_STAR_.call(null,m,inst_55629);
var state_55665__$1 = (function (){var statearr_55721 = state_55665;
(statearr_55721[(24)] = inst_55633);

return statearr_55721;
})();
var statearr_55723_55857 = state_55665__$1;
(statearr_55723_55857[(2)] = inst_55635);

(statearr_55723_55857[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (33))){
var inst_55618 = (state_55665[(25)]);
var inst_55621 = cljs.core.chunked_seq_QMARK_.call(null,inst_55618);
var state_55665__$1 = state_55665;
if(inst_55621){
var statearr_55724_55858 = state_55665__$1;
(statearr_55724_55858[(1)] = (36));

} else {
var statearr_55725_55860 = state_55665__$1;
(statearr_55725_55860[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (13))){
var inst_55545 = (state_55665[(26)]);
var inst_55548 = cljs.core.async.close_BANG_.call(null,inst_55545);
var state_55665__$1 = state_55665;
var statearr_55727_55861 = state_55665__$1;
(statearr_55727_55861[(2)] = inst_55548);

(statearr_55727_55861[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (22))){
var inst_55571 = (state_55665[(8)]);
var inst_55574 = cljs.core.async.close_BANG_.call(null,inst_55571);
var state_55665__$1 = state_55665;
var statearr_55728_55863 = state_55665__$1;
(statearr_55728_55863[(2)] = inst_55574);

(statearr_55728_55863[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (36))){
var inst_55618 = (state_55665[(25)]);
var inst_55624 = cljs.core.chunk_first.call(null,inst_55618);
var inst_55625 = cljs.core.chunk_rest.call(null,inst_55618);
var inst_55626 = cljs.core.count.call(null,inst_55624);
var inst_55599 = inst_55625;
var inst_55600 = inst_55624;
var inst_55601 = inst_55626;
var inst_55602 = (0);
var state_55665__$1 = (function (){var statearr_55729 = state_55665;
(statearr_55729[(9)] = inst_55602);

(statearr_55729[(11)] = inst_55600);

(statearr_55729[(20)] = inst_55599);

(statearr_55729[(21)] = inst_55601);

return statearr_55729;
})();
var statearr_55730_55864 = state_55665__$1;
(statearr_55730_55864[(2)] = null);

(statearr_55730_55864[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (41))){
var inst_55618 = (state_55665[(25)]);
var inst_55637 = (state_55665[(2)]);
var inst_55638 = cljs.core.next.call(null,inst_55618);
var inst_55599 = inst_55638;
var inst_55600 = null;
var inst_55601 = (0);
var inst_55602 = (0);
var state_55665__$1 = (function (){var statearr_55732 = state_55665;
(statearr_55732[(9)] = inst_55602);

(statearr_55732[(11)] = inst_55600);

(statearr_55732[(27)] = inst_55637);

(statearr_55732[(20)] = inst_55599);

(statearr_55732[(21)] = inst_55601);

return statearr_55732;
})();
var statearr_55733_55865 = state_55665__$1;
(statearr_55733_55865[(2)] = null);

(statearr_55733_55865[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (43))){
var state_55665__$1 = state_55665;
var statearr_55734_55866 = state_55665__$1;
(statearr_55734_55866[(2)] = null);

(statearr_55734_55866[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (29))){
var inst_55646 = (state_55665[(2)]);
var state_55665__$1 = state_55665;
var statearr_55739_55869 = state_55665__$1;
(statearr_55739_55869[(2)] = inst_55646);

(statearr_55739_55869[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (44))){
var inst_55657 = (state_55665[(2)]);
var state_55665__$1 = (function (){var statearr_55742 = state_55665;
(statearr_55742[(28)] = inst_55657);

return statearr_55742;
})();
var statearr_55743_55870 = state_55665__$1;
(statearr_55743_55870[(2)] = null);

(statearr_55743_55870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (6))){
var inst_55591 = (state_55665[(29)]);
var inst_55590 = cljs.core.deref.call(null,cs);
var inst_55591__$1 = cljs.core.keys.call(null,inst_55590);
var inst_55592 = cljs.core.count.call(null,inst_55591__$1);
var inst_55593 = cljs.core.reset_BANG_.call(null,dctr,inst_55592);
var inst_55598 = cljs.core.seq.call(null,inst_55591__$1);
var inst_55599 = inst_55598;
var inst_55600 = null;
var inst_55601 = (0);
var inst_55602 = (0);
var state_55665__$1 = (function (){var statearr_55744 = state_55665;
(statearr_55744[(9)] = inst_55602);

(statearr_55744[(30)] = inst_55593);

(statearr_55744[(11)] = inst_55600);

(statearr_55744[(20)] = inst_55599);

(statearr_55744[(29)] = inst_55591__$1);

(statearr_55744[(21)] = inst_55601);

return statearr_55744;
})();
var statearr_55745_55872 = state_55665__$1;
(statearr_55745_55872[(2)] = null);

(statearr_55745_55872[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (28))){
var inst_55618 = (state_55665[(25)]);
var inst_55599 = (state_55665[(20)]);
var inst_55618__$1 = cljs.core.seq.call(null,inst_55599);
var state_55665__$1 = (function (){var statearr_55746 = state_55665;
(statearr_55746[(25)] = inst_55618__$1);

return statearr_55746;
})();
if(inst_55618__$1){
var statearr_55747_55874 = state_55665__$1;
(statearr_55747_55874[(1)] = (33));

} else {
var statearr_55748_55876 = state_55665__$1;
(statearr_55748_55876[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (25))){
var inst_55602 = (state_55665[(9)]);
var inst_55601 = (state_55665[(21)]);
var inst_55604 = (inst_55602 < inst_55601);
var inst_55605 = inst_55604;
var state_55665__$1 = state_55665;
if(cljs.core.truth_(inst_55605)){
var statearr_55749_55877 = state_55665__$1;
(statearr_55749_55877[(1)] = (27));

} else {
var statearr_55750_55878 = state_55665__$1;
(statearr_55750_55878[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (34))){
var state_55665__$1 = state_55665;
var statearr_55751_55880 = state_55665__$1;
(statearr_55751_55880[(2)] = null);

(statearr_55751_55880[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (17))){
var state_55665__$1 = state_55665;
var statearr_55752_55881 = state_55665__$1;
(statearr_55752_55881[(2)] = null);

(statearr_55752_55881[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (3))){
var inst_55662 = (state_55665[(2)]);
var state_55665__$1 = state_55665;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55665__$1,inst_55662);
} else {
if((state_val_55666 === (12))){
var inst_55586 = (state_55665[(2)]);
var state_55665__$1 = state_55665;
var statearr_55753_55882 = state_55665__$1;
(statearr_55753_55882[(2)] = inst_55586);

(statearr_55753_55882[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (2))){
var state_55665__$1 = state_55665;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55665__$1,(4),ch);
} else {
if((state_val_55666 === (23))){
var state_55665__$1 = state_55665;
var statearr_55759_55883 = state_55665__$1;
(statearr_55759_55883[(2)] = null);

(statearr_55759_55883[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (35))){
var inst_55644 = (state_55665[(2)]);
var state_55665__$1 = state_55665;
var statearr_55761_55884 = state_55665__$1;
(statearr_55761_55884[(2)] = inst_55644);

(statearr_55761_55884[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (19))){
var inst_55555 = (state_55665[(7)]);
var inst_55560 = cljs.core.chunk_first.call(null,inst_55555);
var inst_55561 = cljs.core.chunk_rest.call(null,inst_55555);
var inst_55562 = cljs.core.count.call(null,inst_55560);
var inst_55533 = inst_55561;
var inst_55534 = inst_55560;
var inst_55535 = inst_55562;
var inst_55536 = (0);
var state_55665__$1 = (function (){var statearr_55762 = state_55665;
(statearr_55762[(14)] = inst_55535);

(statearr_55762[(15)] = inst_55533);

(statearr_55762[(16)] = inst_55536);

(statearr_55762[(17)] = inst_55534);

return statearr_55762;
})();
var statearr_55763_55887 = state_55665__$1;
(statearr_55763_55887[(2)] = null);

(statearr_55763_55887[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (11))){
var inst_55533 = (state_55665[(15)]);
var inst_55555 = (state_55665[(7)]);
var inst_55555__$1 = cljs.core.seq.call(null,inst_55533);
var state_55665__$1 = (function (){var statearr_55765 = state_55665;
(statearr_55765[(7)] = inst_55555__$1);

return statearr_55765;
})();
if(inst_55555__$1){
var statearr_55766_55890 = state_55665__$1;
(statearr_55766_55890[(1)] = (16));

} else {
var statearr_55767_55891 = state_55665__$1;
(statearr_55767_55891[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (9))){
var inst_55588 = (state_55665[(2)]);
var state_55665__$1 = state_55665;
var statearr_55768_55895 = state_55665__$1;
(statearr_55768_55895[(2)] = inst_55588);

(statearr_55768_55895[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (5))){
var inst_55531 = cljs.core.deref.call(null,cs);
var inst_55532 = cljs.core.seq.call(null,inst_55531);
var inst_55533 = inst_55532;
var inst_55534 = null;
var inst_55535 = (0);
var inst_55536 = (0);
var state_55665__$1 = (function (){var statearr_55769 = state_55665;
(statearr_55769[(14)] = inst_55535);

(statearr_55769[(15)] = inst_55533);

(statearr_55769[(16)] = inst_55536);

(statearr_55769[(17)] = inst_55534);

return statearr_55769;
})();
var statearr_55771_55896 = state_55665__$1;
(statearr_55771_55896[(2)] = null);

(statearr_55771_55896[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (14))){
var state_55665__$1 = state_55665;
var statearr_55772_55897 = state_55665__$1;
(statearr_55772_55897[(2)] = null);

(statearr_55772_55897[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (45))){
var inst_55654 = (state_55665[(2)]);
var state_55665__$1 = state_55665;
var statearr_55773_55898 = state_55665__$1;
(statearr_55773_55898[(2)] = inst_55654);

(statearr_55773_55898[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (26))){
var inst_55591 = (state_55665[(29)]);
var inst_55648 = (state_55665[(2)]);
var inst_55651 = cljs.core.seq.call(null,inst_55591);
var state_55665__$1 = (function (){var statearr_55774 = state_55665;
(statearr_55774[(31)] = inst_55648);

return statearr_55774;
})();
if(inst_55651){
var statearr_55775_55910 = state_55665__$1;
(statearr_55775_55910[(1)] = (42));

} else {
var statearr_55776_55911 = state_55665__$1;
(statearr_55776_55911[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (16))){
var inst_55555 = (state_55665[(7)]);
var inst_55557 = cljs.core.chunked_seq_QMARK_.call(null,inst_55555);
var state_55665__$1 = state_55665;
if(inst_55557){
var statearr_55780_55915 = state_55665__$1;
(statearr_55780_55915[(1)] = (19));

} else {
var statearr_55781_55916 = state_55665__$1;
(statearr_55781_55916[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (38))){
var inst_55641 = (state_55665[(2)]);
var state_55665__$1 = state_55665;
var statearr_55782_55921 = state_55665__$1;
(statearr_55782_55921[(2)] = inst_55641);

(statearr_55782_55921[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (30))){
var state_55665__$1 = state_55665;
var statearr_55784_55923 = state_55665__$1;
(statearr_55784_55923[(2)] = null);

(statearr_55784_55923[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (10))){
var inst_55536 = (state_55665[(16)]);
var inst_55534 = (state_55665[(17)]);
var inst_55544 = cljs.core._nth.call(null,inst_55534,inst_55536);
var inst_55545 = cljs.core.nth.call(null,inst_55544,(0),null);
var inst_55546 = cljs.core.nth.call(null,inst_55544,(1),null);
var state_55665__$1 = (function (){var statearr_55792 = state_55665;
(statearr_55792[(26)] = inst_55545);

return statearr_55792;
})();
if(cljs.core.truth_(inst_55546)){
var statearr_55793_55928 = state_55665__$1;
(statearr_55793_55928[(1)] = (13));

} else {
var statearr_55794_55929 = state_55665__$1;
(statearr_55794_55929[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (18))){
var inst_55584 = (state_55665[(2)]);
var state_55665__$1 = state_55665;
var statearr_55795_55940 = state_55665__$1;
(statearr_55795_55940[(2)] = inst_55584);

(statearr_55795_55940[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (42))){
var state_55665__$1 = state_55665;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55665__$1,(45),dchan);
} else {
if((state_val_55666 === (37))){
var inst_55618 = (state_55665[(25)]);
var inst_55524 = (state_55665[(12)]);
var inst_55629 = (state_55665[(23)]);
var inst_55629__$1 = cljs.core.first.call(null,inst_55618);
var inst_55630 = cljs.core.async.put_BANG_.call(null,inst_55629__$1,inst_55524,done);
var state_55665__$1 = (function (){var statearr_55796 = state_55665;
(statearr_55796[(23)] = inst_55629__$1);

return statearr_55796;
})();
if(cljs.core.truth_(inst_55630)){
var statearr_55797_55949 = state_55665__$1;
(statearr_55797_55949[(1)] = (39));

} else {
var statearr_55798_55952 = state_55665__$1;
(statearr_55798_55952[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55666 === (8))){
var inst_55535 = (state_55665[(14)]);
var inst_55536 = (state_55665[(16)]);
var inst_55538 = (inst_55536 < inst_55535);
var inst_55539 = inst_55538;
var state_55665__$1 = state_55665;
if(cljs.core.truth_(inst_55539)){
var statearr_55800_55954 = state_55665__$1;
(statearr_55800_55954[(1)] = (10));

} else {
var statearr_55802_55961 = state_55665__$1;
(statearr_55802_55961[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__50041__auto___55820,cs,m,dchan,dctr,done))
;
return ((function (switch__50018__auto__,c__50041__auto___55820,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__50019__auto__ = null;
var cljs$core$async$mult_$_state_machine__50019__auto____0 = (function (){
var statearr_55804 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55804[(0)] = cljs$core$async$mult_$_state_machine__50019__auto__);

(statearr_55804[(1)] = (1));

return statearr_55804;
});
var cljs$core$async$mult_$_state_machine__50019__auto____1 = (function (state_55665){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_55665);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e55807){if((e55807 instanceof Object)){
var ex__50022__auto__ = e55807;
var statearr_55808_55963 = state_55665;
(statearr_55808_55963[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55665);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55807;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55966 = state_55665;
state_55665 = G__55966;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__50019__auto__ = function(state_55665){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__50019__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__50019__auto____1.call(this,state_55665);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__50019__auto____0;
cljs$core$async$mult_$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__50019__auto____1;
return cljs$core$async$mult_$_state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto___55820,cs,m,dchan,dctr,done))
})();
var state__50043__auto__ = (function (){var statearr_55813 = f__50042__auto__.call(null);
(statearr_55813[(6)] = c__50041__auto___55820);

return statearr_55813;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto___55820,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__55980 = arguments.length;
switch (G__55980) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__47808__auto__ = (((m == null))?null:m);
var m__47809__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,m,ch);
} else {
var m__47809__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__47808__auto__ = (((m == null))?null:m);
var m__47809__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,m,ch);
} else {
var m__47809__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__47808__auto__ = (((m == null))?null:m);
var m__47809__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,m);
} else {
var m__47809__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__47808__auto__ = (((m == null))?null:m);
var m__47809__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,m,state_map);
} else {
var m__47809__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__47808__auto__ = (((m == null))?null:m);
var m__47809__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,m,mode);
} else {
var m__47809__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__48361__auto__ = [];
var len__48354__auto___56091 = arguments.length;
var i__48355__auto___56092 = (0);
while(true){
if((i__48355__auto___56092 < len__48354__auto___56091)){
args__48361__auto__.push((arguments[i__48355__auto___56092]));

var G__56094 = (i__48355__auto___56092 + (1));
i__48355__auto___56092 = G__56094;
continue;
} else {
}
break;
}

var argseq__48362__auto__ = ((((3) < args__48361__auto__.length))?(new cljs.core.IndexedSeq(args__48361__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__48362__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__56080){
var map__56081 = p__56080;
var map__56081__$1 = ((((!((map__56081 == null)))?((((map__56081.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56081.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56081):map__56081);
var opts = map__56081__$1;
var statearr_56087_56096 = state;
(statearr_56087_56096[(1)] = cont_block);


var temp__5459__auto__ = cljs.core.async.do_alts.call(null,((function (map__56081,map__56081__$1,opts){
return (function (val){
var statearr_56089_56098 = state;
(statearr_56089_56098[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__56081,map__56081__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5459__auto__)){
var cb = temp__5459__auto__;
var statearr_56090_56099 = state;
(statearr_56090_56099[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq56076){
var G__56077 = cljs.core.first.call(null,seq56076);
var seq56076__$1 = cljs.core.next.call(null,seq56076);
var G__56078 = cljs.core.first.call(null,seq56076__$1);
var seq56076__$2 = cljs.core.next.call(null,seq56076__$1);
var G__56079 = cljs.core.first.call(null,seq56076__$2);
var seq56076__$3 = cljs.core.next.call(null,seq56076__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__56077,G__56078,G__56079,seq56076__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async56111 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async56111 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta56112){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta56112 = meta56112;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async56111.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_56113,meta56112__$1){
var self__ = this;
var _56113__$1 = this;
return (new cljs.core.async.t_cljs$core$async56111(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta56112__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async56111.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_56113){
var self__ = this;
var _56113__$1 = this;
return self__.meta56112;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async56111.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56111.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async56111.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56111.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async56111.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async56111.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async56111.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async56111.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async56111.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta56112","meta56112",-1412381443,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async56111.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async56111.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async56111";

cljs.core.async.t_cljs$core$async56111.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__47746__auto__,writer__47747__auto__,opt__47748__auto__){
return cljs.core._write.call(null,writer__47747__auto__,"cljs.core.async/t_cljs$core$async56111");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async56111 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async56111(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta56112){
return (new cljs.core.async.t_cljs$core$async56111(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta56112));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async56111(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__50041__auto___56300 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto___56300,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto___56300,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_56219){
var state_val_56220 = (state_56219[(1)]);
if((state_val_56220 === (7))){
var inst_56134 = (state_56219[(2)]);
var state_56219__$1 = state_56219;
var statearr_56221_56301 = state_56219__$1;
(statearr_56221_56301[(2)] = inst_56134);

(statearr_56221_56301[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (20))){
var inst_56146 = (state_56219[(7)]);
var state_56219__$1 = state_56219;
var statearr_56222_56302 = state_56219__$1;
(statearr_56222_56302[(2)] = inst_56146);

(statearr_56222_56302[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (27))){
var state_56219__$1 = state_56219;
var statearr_56223_56303 = state_56219__$1;
(statearr_56223_56303[(2)] = null);

(statearr_56223_56303[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (1))){
var inst_56121 = (state_56219[(8)]);
var inst_56121__$1 = calc_state.call(null);
var inst_56123 = (inst_56121__$1 == null);
var inst_56124 = cljs.core.not.call(null,inst_56123);
var state_56219__$1 = (function (){var statearr_56224 = state_56219;
(statearr_56224[(8)] = inst_56121__$1);

return statearr_56224;
})();
if(inst_56124){
var statearr_56225_56304 = state_56219__$1;
(statearr_56225_56304[(1)] = (2));

} else {
var statearr_56226_56305 = state_56219__$1;
(statearr_56226_56305[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (24))){
var inst_56179 = (state_56219[(9)]);
var inst_56193 = (state_56219[(10)]);
var inst_56170 = (state_56219[(11)]);
var inst_56193__$1 = inst_56170.call(null,inst_56179);
var state_56219__$1 = (function (){var statearr_56227 = state_56219;
(statearr_56227[(10)] = inst_56193__$1);

return statearr_56227;
})();
if(cljs.core.truth_(inst_56193__$1)){
var statearr_56228_56306 = state_56219__$1;
(statearr_56228_56306[(1)] = (29));

} else {
var statearr_56229_56307 = state_56219__$1;
(statearr_56229_56307[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (4))){
var inst_56137 = (state_56219[(2)]);
var state_56219__$1 = state_56219;
if(cljs.core.truth_(inst_56137)){
var statearr_56231_56308 = state_56219__$1;
(statearr_56231_56308[(1)] = (8));

} else {
var statearr_56233_56309 = state_56219__$1;
(statearr_56233_56309[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (15))){
var inst_56164 = (state_56219[(2)]);
var state_56219__$1 = state_56219;
if(cljs.core.truth_(inst_56164)){
var statearr_56234_56312 = state_56219__$1;
(statearr_56234_56312[(1)] = (19));

} else {
var statearr_56235_56313 = state_56219__$1;
(statearr_56235_56313[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (21))){
var inst_56169 = (state_56219[(12)]);
var inst_56169__$1 = (state_56219[(2)]);
var inst_56170 = cljs.core.get.call(null,inst_56169__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_56171 = cljs.core.get.call(null,inst_56169__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_56172 = cljs.core.get.call(null,inst_56169__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_56219__$1 = (function (){var statearr_56236 = state_56219;
(statearr_56236[(12)] = inst_56169__$1);

(statearr_56236[(13)] = inst_56171);

(statearr_56236[(11)] = inst_56170);

return statearr_56236;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_56219__$1,(22),inst_56172);
} else {
if((state_val_56220 === (31))){
var inst_56201 = (state_56219[(2)]);
var state_56219__$1 = state_56219;
if(cljs.core.truth_(inst_56201)){
var statearr_56237_56315 = state_56219__$1;
(statearr_56237_56315[(1)] = (32));

} else {
var statearr_56238_56318 = state_56219__$1;
(statearr_56238_56318[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (32))){
var inst_56178 = (state_56219[(14)]);
var state_56219__$1 = state_56219;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56219__$1,(35),out,inst_56178);
} else {
if((state_val_56220 === (33))){
var inst_56169 = (state_56219[(12)]);
var inst_56146 = inst_56169;
var state_56219__$1 = (function (){var statearr_56240 = state_56219;
(statearr_56240[(7)] = inst_56146);

return statearr_56240;
})();
var statearr_56241_56319 = state_56219__$1;
(statearr_56241_56319[(2)] = null);

(statearr_56241_56319[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (13))){
var inst_56146 = (state_56219[(7)]);
var inst_56153 = inst_56146.cljs$lang$protocol_mask$partition0$;
var inst_56154 = (inst_56153 & (64));
var inst_56155 = inst_56146.cljs$core$ISeq$;
var inst_56156 = (cljs.core.PROTOCOL_SENTINEL === inst_56155);
var inst_56157 = (inst_56154) || (inst_56156);
var state_56219__$1 = state_56219;
if(cljs.core.truth_(inst_56157)){
var statearr_56242_56321 = state_56219__$1;
(statearr_56242_56321[(1)] = (16));

} else {
var statearr_56243_56322 = state_56219__$1;
(statearr_56243_56322[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (22))){
var inst_56179 = (state_56219[(9)]);
var inst_56178 = (state_56219[(14)]);
var inst_56177 = (state_56219[(2)]);
var inst_56178__$1 = cljs.core.nth.call(null,inst_56177,(0),null);
var inst_56179__$1 = cljs.core.nth.call(null,inst_56177,(1),null);
var inst_56180 = (inst_56178__$1 == null);
var inst_56181 = cljs.core._EQ_.call(null,inst_56179__$1,change);
var inst_56182 = (inst_56180) || (inst_56181);
var state_56219__$1 = (function (){var statearr_56244 = state_56219;
(statearr_56244[(9)] = inst_56179__$1);

(statearr_56244[(14)] = inst_56178__$1);

return statearr_56244;
})();
if(cljs.core.truth_(inst_56182)){
var statearr_56245_56325 = state_56219__$1;
(statearr_56245_56325[(1)] = (23));

} else {
var statearr_56246_56326 = state_56219__$1;
(statearr_56246_56326[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (36))){
var inst_56169 = (state_56219[(12)]);
var inst_56146 = inst_56169;
var state_56219__$1 = (function (){var statearr_56247 = state_56219;
(statearr_56247[(7)] = inst_56146);

return statearr_56247;
})();
var statearr_56248_56328 = state_56219__$1;
(statearr_56248_56328[(2)] = null);

(statearr_56248_56328[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (29))){
var inst_56193 = (state_56219[(10)]);
var state_56219__$1 = state_56219;
var statearr_56249_56329 = state_56219__$1;
(statearr_56249_56329[(2)] = inst_56193);

(statearr_56249_56329[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (6))){
var state_56219__$1 = state_56219;
var statearr_56250_56330 = state_56219__$1;
(statearr_56250_56330[(2)] = false);

(statearr_56250_56330[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (28))){
var inst_56189 = (state_56219[(2)]);
var inst_56190 = calc_state.call(null);
var inst_56146 = inst_56190;
var state_56219__$1 = (function (){var statearr_56251 = state_56219;
(statearr_56251[(7)] = inst_56146);

(statearr_56251[(15)] = inst_56189);

return statearr_56251;
})();
var statearr_56252_56333 = state_56219__$1;
(statearr_56252_56333[(2)] = null);

(statearr_56252_56333[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (25))){
var inst_56215 = (state_56219[(2)]);
var state_56219__$1 = state_56219;
var statearr_56253_56337 = state_56219__$1;
(statearr_56253_56337[(2)] = inst_56215);

(statearr_56253_56337[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (34))){
var inst_56213 = (state_56219[(2)]);
var state_56219__$1 = state_56219;
var statearr_56254_56347 = state_56219__$1;
(statearr_56254_56347[(2)] = inst_56213);

(statearr_56254_56347[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (17))){
var state_56219__$1 = state_56219;
var statearr_56255_56348 = state_56219__$1;
(statearr_56255_56348[(2)] = false);

(statearr_56255_56348[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (3))){
var state_56219__$1 = state_56219;
var statearr_56256_56350 = state_56219__$1;
(statearr_56256_56350[(2)] = false);

(statearr_56256_56350[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (12))){
var inst_56217 = (state_56219[(2)]);
var state_56219__$1 = state_56219;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56219__$1,inst_56217);
} else {
if((state_val_56220 === (2))){
var inst_56121 = (state_56219[(8)]);
var inst_56126 = inst_56121.cljs$lang$protocol_mask$partition0$;
var inst_56127 = (inst_56126 & (64));
var inst_56128 = inst_56121.cljs$core$ISeq$;
var inst_56129 = (cljs.core.PROTOCOL_SENTINEL === inst_56128);
var inst_56130 = (inst_56127) || (inst_56129);
var state_56219__$1 = state_56219;
if(cljs.core.truth_(inst_56130)){
var statearr_56257_56351 = state_56219__$1;
(statearr_56257_56351[(1)] = (5));

} else {
var statearr_56258_56352 = state_56219__$1;
(statearr_56258_56352[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (23))){
var inst_56178 = (state_56219[(14)]);
var inst_56184 = (inst_56178 == null);
var state_56219__$1 = state_56219;
if(cljs.core.truth_(inst_56184)){
var statearr_56261_56353 = state_56219__$1;
(statearr_56261_56353[(1)] = (26));

} else {
var statearr_56262_56354 = state_56219__$1;
(statearr_56262_56354[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (35))){
var inst_56204 = (state_56219[(2)]);
var state_56219__$1 = state_56219;
if(cljs.core.truth_(inst_56204)){
var statearr_56263_56355 = state_56219__$1;
(statearr_56263_56355[(1)] = (36));

} else {
var statearr_56264_56356 = state_56219__$1;
(statearr_56264_56356[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (19))){
var inst_56146 = (state_56219[(7)]);
var inst_56166 = cljs.core.apply.call(null,cljs.core.hash_map,inst_56146);
var state_56219__$1 = state_56219;
var statearr_56265_56357 = state_56219__$1;
(statearr_56265_56357[(2)] = inst_56166);

(statearr_56265_56357[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (11))){
var inst_56146 = (state_56219[(7)]);
var inst_56150 = (inst_56146 == null);
var inst_56151 = cljs.core.not.call(null,inst_56150);
var state_56219__$1 = state_56219;
if(inst_56151){
var statearr_56267_56358 = state_56219__$1;
(statearr_56267_56358[(1)] = (13));

} else {
var statearr_56268_56359 = state_56219__$1;
(statearr_56268_56359[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (9))){
var inst_56121 = (state_56219[(8)]);
var state_56219__$1 = state_56219;
var statearr_56269_56360 = state_56219__$1;
(statearr_56269_56360[(2)] = inst_56121);

(statearr_56269_56360[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (5))){
var state_56219__$1 = state_56219;
var statearr_56270_56361 = state_56219__$1;
(statearr_56270_56361[(2)] = true);

(statearr_56270_56361[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (14))){
var state_56219__$1 = state_56219;
var statearr_56273_56364 = state_56219__$1;
(statearr_56273_56364[(2)] = false);

(statearr_56273_56364[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (26))){
var inst_56179 = (state_56219[(9)]);
var inst_56186 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_56179);
var state_56219__$1 = state_56219;
var statearr_56274_56365 = state_56219__$1;
(statearr_56274_56365[(2)] = inst_56186);

(statearr_56274_56365[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (16))){
var state_56219__$1 = state_56219;
var statearr_56275_56366 = state_56219__$1;
(statearr_56275_56366[(2)] = true);

(statearr_56275_56366[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (38))){
var inst_56209 = (state_56219[(2)]);
var state_56219__$1 = state_56219;
var statearr_56276_56368 = state_56219__$1;
(statearr_56276_56368[(2)] = inst_56209);

(statearr_56276_56368[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (30))){
var inst_56171 = (state_56219[(13)]);
var inst_56179 = (state_56219[(9)]);
var inst_56170 = (state_56219[(11)]);
var inst_56196 = cljs.core.empty_QMARK_.call(null,inst_56170);
var inst_56197 = inst_56171.call(null,inst_56179);
var inst_56198 = cljs.core.not.call(null,inst_56197);
var inst_56199 = (inst_56196) && (inst_56198);
var state_56219__$1 = state_56219;
var statearr_56277_56369 = state_56219__$1;
(statearr_56277_56369[(2)] = inst_56199);

(statearr_56277_56369[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (10))){
var inst_56121 = (state_56219[(8)]);
var inst_56142 = (state_56219[(2)]);
var inst_56143 = cljs.core.get.call(null,inst_56142,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_56144 = cljs.core.get.call(null,inst_56142,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_56145 = cljs.core.get.call(null,inst_56142,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_56146 = inst_56121;
var state_56219__$1 = (function (){var statearr_56279 = state_56219;
(statearr_56279[(16)] = inst_56144);

(statearr_56279[(17)] = inst_56145);

(statearr_56279[(7)] = inst_56146);

(statearr_56279[(18)] = inst_56143);

return statearr_56279;
})();
var statearr_56280_56372 = state_56219__$1;
(statearr_56280_56372[(2)] = null);

(statearr_56280_56372[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (18))){
var inst_56161 = (state_56219[(2)]);
var state_56219__$1 = state_56219;
var statearr_56281_56373 = state_56219__$1;
(statearr_56281_56373[(2)] = inst_56161);

(statearr_56281_56373[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (37))){
var state_56219__$1 = state_56219;
var statearr_56282_56375 = state_56219__$1;
(statearr_56282_56375[(2)] = null);

(statearr_56282_56375[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56220 === (8))){
var inst_56121 = (state_56219[(8)]);
var inst_56139 = cljs.core.apply.call(null,cljs.core.hash_map,inst_56121);
var state_56219__$1 = state_56219;
var statearr_56283_56376 = state_56219__$1;
(statearr_56283_56376[(2)] = inst_56139);

(statearr_56283_56376[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__50041__auto___56300,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__50018__auto__,c__50041__auto___56300,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__50019__auto__ = null;
var cljs$core$async$mix_$_state_machine__50019__auto____0 = (function (){
var statearr_56286 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56286[(0)] = cljs$core$async$mix_$_state_machine__50019__auto__);

(statearr_56286[(1)] = (1));

return statearr_56286;
});
var cljs$core$async$mix_$_state_machine__50019__auto____1 = (function (state_56219){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_56219);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e56287){if((e56287 instanceof Object)){
var ex__50022__auto__ = e56287;
var statearr_56288_56379 = state_56219;
(statearr_56288_56379[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56219);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56287;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56381 = state_56219;
state_56219 = G__56381;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__50019__auto__ = function(state_56219){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__50019__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__50019__auto____1.call(this,state_56219);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__50019__auto____0;
cljs$core$async$mix_$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__50019__auto____1;
return cljs$core$async$mix_$_state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto___56300,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__50043__auto__ = (function (){var statearr_56289 = f__50042__auto__.call(null);
(statearr_56289[(6)] = c__50041__auto___56300);

return statearr_56289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto___56300,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__47808__auto__ = (((p == null))?null:p);
var m__47809__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__47809__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__47808__auto__ = (((p == null))?null:p);
var m__47809__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,p,v,ch);
} else {
var m__47809__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__56383 = arguments.length;
switch (G__56383) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__47808__auto__ = (((p == null))?null:p);
var m__47809__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,p);
} else {
var m__47809__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__47808__auto__ = (((p == null))?null:p);
var m__47809__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,p,v);
} else {
var m__47809__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__56395 = arguments.length;
switch (G__56395) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__47075__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__47075__auto__)){
return or__47075__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__47075__auto__,mults){
return (function (p1__56393_SHARP_){
if(cljs.core.truth_(p1__56393_SHARP_.call(null,topic))){
return p1__56393_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__56393_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__47075__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async56397 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async56397 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta56398){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta56398 = meta56398;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async56397.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_56399,meta56398__$1){
var self__ = this;
var _56399__$1 = this;
return (new cljs.core.async.t_cljs$core$async56397(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta56398__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async56397.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_56399){
var self__ = this;
var _56399__$1 = this;
return self__.meta56398;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async56397.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56397.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async56397.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56397.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async56397.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5459__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5459__auto__)){
var m = temp__5459__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async56397.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async56397.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async56397.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta56398","meta56398",913188023,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async56397.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async56397.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async56397";

cljs.core.async.t_cljs$core$async56397.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__47746__auto__,writer__47747__auto__,opt__47748__auto__){
return cljs.core._write.call(null,writer__47747__auto__,"cljs.core.async/t_cljs$core$async56397");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async56397 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async56397(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta56398){
return (new cljs.core.async.t_cljs$core$async56397(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta56398));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async56397(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__50041__auto___56534 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto___56534,mults,ensure_mult,p){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto___56534,mults,ensure_mult,p){
return (function (state_56474){
var state_val_56475 = (state_56474[(1)]);
if((state_val_56475 === (7))){
var inst_56470 = (state_56474[(2)]);
var state_56474__$1 = state_56474;
var statearr_56476_56535 = state_56474__$1;
(statearr_56476_56535[(2)] = inst_56470);

(statearr_56476_56535[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (20))){
var state_56474__$1 = state_56474;
var statearr_56477_56537 = state_56474__$1;
(statearr_56477_56537[(2)] = null);

(statearr_56477_56537[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (1))){
var state_56474__$1 = state_56474;
var statearr_56479_56538 = state_56474__$1;
(statearr_56479_56538[(2)] = null);

(statearr_56479_56538[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (24))){
var inst_56453 = (state_56474[(7)]);
var inst_56462 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_56453);
var state_56474__$1 = state_56474;
var statearr_56481_56539 = state_56474__$1;
(statearr_56481_56539[(2)] = inst_56462);

(statearr_56481_56539[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (4))){
var inst_56404 = (state_56474[(8)]);
var inst_56404__$1 = (state_56474[(2)]);
var inst_56405 = (inst_56404__$1 == null);
var state_56474__$1 = (function (){var statearr_56482 = state_56474;
(statearr_56482[(8)] = inst_56404__$1);

return statearr_56482;
})();
if(cljs.core.truth_(inst_56405)){
var statearr_56483_56540 = state_56474__$1;
(statearr_56483_56540[(1)] = (5));

} else {
var statearr_56484_56541 = state_56474__$1;
(statearr_56484_56541[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (15))){
var inst_56447 = (state_56474[(2)]);
var state_56474__$1 = state_56474;
var statearr_56485_56542 = state_56474__$1;
(statearr_56485_56542[(2)] = inst_56447);

(statearr_56485_56542[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (21))){
var inst_56467 = (state_56474[(2)]);
var state_56474__$1 = (function (){var statearr_56487 = state_56474;
(statearr_56487[(9)] = inst_56467);

return statearr_56487;
})();
var statearr_56488_56543 = state_56474__$1;
(statearr_56488_56543[(2)] = null);

(statearr_56488_56543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (13))){
var inst_56429 = (state_56474[(10)]);
var inst_56431 = cljs.core.chunked_seq_QMARK_.call(null,inst_56429);
var state_56474__$1 = state_56474;
if(inst_56431){
var statearr_56489_56546 = state_56474__$1;
(statearr_56489_56546[(1)] = (16));

} else {
var statearr_56490_56547 = state_56474__$1;
(statearr_56490_56547[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (22))){
var inst_56459 = (state_56474[(2)]);
var state_56474__$1 = state_56474;
if(cljs.core.truth_(inst_56459)){
var statearr_56491_56548 = state_56474__$1;
(statearr_56491_56548[(1)] = (23));

} else {
var statearr_56492_56549 = state_56474__$1;
(statearr_56492_56549[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (6))){
var inst_56404 = (state_56474[(8)]);
var inst_56453 = (state_56474[(7)]);
var inst_56455 = (state_56474[(11)]);
var inst_56453__$1 = topic_fn.call(null,inst_56404);
var inst_56454 = cljs.core.deref.call(null,mults);
var inst_56455__$1 = cljs.core.get.call(null,inst_56454,inst_56453__$1);
var state_56474__$1 = (function (){var statearr_56493 = state_56474;
(statearr_56493[(7)] = inst_56453__$1);

(statearr_56493[(11)] = inst_56455__$1);

return statearr_56493;
})();
if(cljs.core.truth_(inst_56455__$1)){
var statearr_56494_56552 = state_56474__$1;
(statearr_56494_56552[(1)] = (19));

} else {
var statearr_56495_56554 = state_56474__$1;
(statearr_56495_56554[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (25))){
var inst_56464 = (state_56474[(2)]);
var state_56474__$1 = state_56474;
var statearr_56496_56555 = state_56474__$1;
(statearr_56496_56555[(2)] = inst_56464);

(statearr_56496_56555[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (17))){
var inst_56429 = (state_56474[(10)]);
var inst_56438 = cljs.core.first.call(null,inst_56429);
var inst_56439 = cljs.core.async.muxch_STAR_.call(null,inst_56438);
var inst_56440 = cljs.core.async.close_BANG_.call(null,inst_56439);
var inst_56441 = cljs.core.next.call(null,inst_56429);
var inst_56415 = inst_56441;
var inst_56416 = null;
var inst_56417 = (0);
var inst_56418 = (0);
var state_56474__$1 = (function (){var statearr_56497 = state_56474;
(statearr_56497[(12)] = inst_56416);

(statearr_56497[(13)] = inst_56440);

(statearr_56497[(14)] = inst_56418);

(statearr_56497[(15)] = inst_56415);

(statearr_56497[(16)] = inst_56417);

return statearr_56497;
})();
var statearr_56498_56558 = state_56474__$1;
(statearr_56498_56558[(2)] = null);

(statearr_56498_56558[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (3))){
var inst_56472 = (state_56474[(2)]);
var state_56474__$1 = state_56474;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56474__$1,inst_56472);
} else {
if((state_val_56475 === (12))){
var inst_56449 = (state_56474[(2)]);
var state_56474__$1 = state_56474;
var statearr_56499_56560 = state_56474__$1;
(statearr_56499_56560[(2)] = inst_56449);

(statearr_56499_56560[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (2))){
var state_56474__$1 = state_56474;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56474__$1,(4),ch);
} else {
if((state_val_56475 === (23))){
var state_56474__$1 = state_56474;
var statearr_56500_56561 = state_56474__$1;
(statearr_56500_56561[(2)] = null);

(statearr_56500_56561[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (19))){
var inst_56404 = (state_56474[(8)]);
var inst_56455 = (state_56474[(11)]);
var inst_56457 = cljs.core.async.muxch_STAR_.call(null,inst_56455);
var state_56474__$1 = state_56474;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56474__$1,(22),inst_56457,inst_56404);
} else {
if((state_val_56475 === (11))){
var inst_56415 = (state_56474[(15)]);
var inst_56429 = (state_56474[(10)]);
var inst_56429__$1 = cljs.core.seq.call(null,inst_56415);
var state_56474__$1 = (function (){var statearr_56501 = state_56474;
(statearr_56501[(10)] = inst_56429__$1);

return statearr_56501;
})();
if(inst_56429__$1){
var statearr_56502_56562 = state_56474__$1;
(statearr_56502_56562[(1)] = (13));

} else {
var statearr_56503_56563 = state_56474__$1;
(statearr_56503_56563[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (9))){
var inst_56451 = (state_56474[(2)]);
var state_56474__$1 = state_56474;
var statearr_56504_56564 = state_56474__$1;
(statearr_56504_56564[(2)] = inst_56451);

(statearr_56504_56564[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (5))){
var inst_56412 = cljs.core.deref.call(null,mults);
var inst_56413 = cljs.core.vals.call(null,inst_56412);
var inst_56414 = cljs.core.seq.call(null,inst_56413);
var inst_56415 = inst_56414;
var inst_56416 = null;
var inst_56417 = (0);
var inst_56418 = (0);
var state_56474__$1 = (function (){var statearr_56505 = state_56474;
(statearr_56505[(12)] = inst_56416);

(statearr_56505[(14)] = inst_56418);

(statearr_56505[(15)] = inst_56415);

(statearr_56505[(16)] = inst_56417);

return statearr_56505;
})();
var statearr_56506_56570 = state_56474__$1;
(statearr_56506_56570[(2)] = null);

(statearr_56506_56570[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (14))){
var state_56474__$1 = state_56474;
var statearr_56510_56571 = state_56474__$1;
(statearr_56510_56571[(2)] = null);

(statearr_56510_56571[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (16))){
var inst_56429 = (state_56474[(10)]);
var inst_56433 = cljs.core.chunk_first.call(null,inst_56429);
var inst_56434 = cljs.core.chunk_rest.call(null,inst_56429);
var inst_56435 = cljs.core.count.call(null,inst_56433);
var inst_56415 = inst_56434;
var inst_56416 = inst_56433;
var inst_56417 = inst_56435;
var inst_56418 = (0);
var state_56474__$1 = (function (){var statearr_56513 = state_56474;
(statearr_56513[(12)] = inst_56416);

(statearr_56513[(14)] = inst_56418);

(statearr_56513[(15)] = inst_56415);

(statearr_56513[(16)] = inst_56417);

return statearr_56513;
})();
var statearr_56514_56572 = state_56474__$1;
(statearr_56514_56572[(2)] = null);

(statearr_56514_56572[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (10))){
var inst_56416 = (state_56474[(12)]);
var inst_56418 = (state_56474[(14)]);
var inst_56415 = (state_56474[(15)]);
var inst_56417 = (state_56474[(16)]);
var inst_56423 = cljs.core._nth.call(null,inst_56416,inst_56418);
var inst_56424 = cljs.core.async.muxch_STAR_.call(null,inst_56423);
var inst_56425 = cljs.core.async.close_BANG_.call(null,inst_56424);
var inst_56426 = (inst_56418 + (1));
var tmp56507 = inst_56416;
var tmp56508 = inst_56415;
var tmp56509 = inst_56417;
var inst_56415__$1 = tmp56508;
var inst_56416__$1 = tmp56507;
var inst_56417__$1 = tmp56509;
var inst_56418__$1 = inst_56426;
var state_56474__$1 = (function (){var statearr_56515 = state_56474;
(statearr_56515[(12)] = inst_56416__$1);

(statearr_56515[(14)] = inst_56418__$1);

(statearr_56515[(15)] = inst_56415__$1);

(statearr_56515[(17)] = inst_56425);

(statearr_56515[(16)] = inst_56417__$1);

return statearr_56515;
})();
var statearr_56516_56573 = state_56474__$1;
(statearr_56516_56573[(2)] = null);

(statearr_56516_56573[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (18))){
var inst_56444 = (state_56474[(2)]);
var state_56474__$1 = state_56474;
var statearr_56517_56575 = state_56474__$1;
(statearr_56517_56575[(2)] = inst_56444);

(statearr_56517_56575[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56475 === (8))){
var inst_56418 = (state_56474[(14)]);
var inst_56417 = (state_56474[(16)]);
var inst_56420 = (inst_56418 < inst_56417);
var inst_56421 = inst_56420;
var state_56474__$1 = state_56474;
if(cljs.core.truth_(inst_56421)){
var statearr_56518_56579 = state_56474__$1;
(statearr_56518_56579[(1)] = (10));

} else {
var statearr_56519_56580 = state_56474__$1;
(statearr_56519_56580[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__50041__auto___56534,mults,ensure_mult,p))
;
return ((function (switch__50018__auto__,c__50041__auto___56534,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__50019__auto__ = null;
var cljs$core$async$state_machine__50019__auto____0 = (function (){
var statearr_56521 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56521[(0)] = cljs$core$async$state_machine__50019__auto__);

(statearr_56521[(1)] = (1));

return statearr_56521;
});
var cljs$core$async$state_machine__50019__auto____1 = (function (state_56474){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_56474);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e56522){if((e56522 instanceof Object)){
var ex__50022__auto__ = e56522;
var statearr_56523_56581 = state_56474;
(statearr_56523_56581[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56474);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56522;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56582 = state_56474;
state_56474 = G__56582;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
cljs$core$async$state_machine__50019__auto__ = function(state_56474){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__50019__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__50019__auto____1.call(this,state_56474);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__50019__auto____0;
cljs$core$async$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__50019__auto____1;
return cljs$core$async$state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto___56534,mults,ensure_mult,p))
})();
var state__50043__auto__ = (function (){var statearr_56524 = f__50042__auto__.call(null);
(statearr_56524[(6)] = c__50041__auto___56534);

return statearr_56524;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto___56534,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__56584 = arguments.length;
switch (G__56584) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__56592 = arguments.length;
switch (G__56592) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__56595 = arguments.length;
switch (G__56595) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__50041__auto___56674 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto___56674,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto___56674,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_56638){
var state_val_56639 = (state_56638[(1)]);
if((state_val_56639 === (7))){
var state_56638__$1 = state_56638;
var statearr_56640_56676 = state_56638__$1;
(statearr_56640_56676[(2)] = null);

(statearr_56640_56676[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56639 === (1))){
var state_56638__$1 = state_56638;
var statearr_56641_56677 = state_56638__$1;
(statearr_56641_56677[(2)] = null);

(statearr_56641_56677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56639 === (4))){
var inst_56599 = (state_56638[(7)]);
var inst_56601 = (inst_56599 < cnt);
var state_56638__$1 = state_56638;
if(cljs.core.truth_(inst_56601)){
var statearr_56642_56678 = state_56638__$1;
(statearr_56642_56678[(1)] = (6));

} else {
var statearr_56643_56679 = state_56638__$1;
(statearr_56643_56679[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56639 === (15))){
var inst_56634 = (state_56638[(2)]);
var state_56638__$1 = state_56638;
var statearr_56644_56680 = state_56638__$1;
(statearr_56644_56680[(2)] = inst_56634);

(statearr_56644_56680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56639 === (13))){
var inst_56627 = cljs.core.async.close_BANG_.call(null,out);
var state_56638__$1 = state_56638;
var statearr_56645_56681 = state_56638__$1;
(statearr_56645_56681[(2)] = inst_56627);

(statearr_56645_56681[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56639 === (6))){
var state_56638__$1 = state_56638;
var statearr_56646_56682 = state_56638__$1;
(statearr_56646_56682[(2)] = null);

(statearr_56646_56682[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56639 === (3))){
var inst_56636 = (state_56638[(2)]);
var state_56638__$1 = state_56638;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56638__$1,inst_56636);
} else {
if((state_val_56639 === (12))){
var inst_56624 = (state_56638[(8)]);
var inst_56624__$1 = (state_56638[(2)]);
var inst_56625 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_56624__$1);
var state_56638__$1 = (function (){var statearr_56652 = state_56638;
(statearr_56652[(8)] = inst_56624__$1);

return statearr_56652;
})();
if(cljs.core.truth_(inst_56625)){
var statearr_56653_56683 = state_56638__$1;
(statearr_56653_56683[(1)] = (13));

} else {
var statearr_56654_56684 = state_56638__$1;
(statearr_56654_56684[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56639 === (2))){
var inst_56598 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_56599 = (0);
var state_56638__$1 = (function (){var statearr_56655 = state_56638;
(statearr_56655[(7)] = inst_56599);

(statearr_56655[(9)] = inst_56598);

return statearr_56655;
})();
var statearr_56656_56686 = state_56638__$1;
(statearr_56656_56686[(2)] = null);

(statearr_56656_56686[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56639 === (11))){
var inst_56599 = (state_56638[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_56638,(10),Object,null,(9));
var inst_56611 = chs__$1.call(null,inst_56599);
var inst_56612 = done.call(null,inst_56599);
var inst_56613 = cljs.core.async.take_BANG_.call(null,inst_56611,inst_56612);
var state_56638__$1 = state_56638;
var statearr_56657_56691 = state_56638__$1;
(statearr_56657_56691[(2)] = inst_56613);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56638__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56639 === (9))){
var inst_56599 = (state_56638[(7)]);
var inst_56615 = (state_56638[(2)]);
var inst_56616 = (inst_56599 + (1));
var inst_56599__$1 = inst_56616;
var state_56638__$1 = (function (){var statearr_56658 = state_56638;
(statearr_56658[(7)] = inst_56599__$1);

(statearr_56658[(10)] = inst_56615);

return statearr_56658;
})();
var statearr_56659_56692 = state_56638__$1;
(statearr_56659_56692[(2)] = null);

(statearr_56659_56692[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56639 === (5))){
var inst_56622 = (state_56638[(2)]);
var state_56638__$1 = (function (){var statearr_56660 = state_56638;
(statearr_56660[(11)] = inst_56622);

return statearr_56660;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56638__$1,(12),dchan);
} else {
if((state_val_56639 === (14))){
var inst_56624 = (state_56638[(8)]);
var inst_56629 = cljs.core.apply.call(null,f,inst_56624);
var state_56638__$1 = state_56638;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56638__$1,(16),out,inst_56629);
} else {
if((state_val_56639 === (16))){
var inst_56631 = (state_56638[(2)]);
var state_56638__$1 = (function (){var statearr_56661 = state_56638;
(statearr_56661[(12)] = inst_56631);

return statearr_56661;
})();
var statearr_56662_56693 = state_56638__$1;
(statearr_56662_56693[(2)] = null);

(statearr_56662_56693[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56639 === (10))){
var inst_56606 = (state_56638[(2)]);
var inst_56607 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_56638__$1 = (function (){var statearr_56663 = state_56638;
(statearr_56663[(13)] = inst_56606);

return statearr_56663;
})();
var statearr_56664_56694 = state_56638__$1;
(statearr_56664_56694[(2)] = inst_56607);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56638__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56639 === (8))){
var inst_56620 = (state_56638[(2)]);
var state_56638__$1 = state_56638;
var statearr_56665_56695 = state_56638__$1;
(statearr_56665_56695[(2)] = inst_56620);

(statearr_56665_56695[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__50041__auto___56674,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__50018__auto__,c__50041__auto___56674,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__50019__auto__ = null;
var cljs$core$async$state_machine__50019__auto____0 = (function (){
var statearr_56666 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56666[(0)] = cljs$core$async$state_machine__50019__auto__);

(statearr_56666[(1)] = (1));

return statearr_56666;
});
var cljs$core$async$state_machine__50019__auto____1 = (function (state_56638){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_56638);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e56667){if((e56667 instanceof Object)){
var ex__50022__auto__ = e56667;
var statearr_56668_56696 = state_56638;
(statearr_56668_56696[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56638);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56667;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56697 = state_56638;
state_56638 = G__56697;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
cljs$core$async$state_machine__50019__auto__ = function(state_56638){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__50019__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__50019__auto____1.call(this,state_56638);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__50019__auto____0;
cljs$core$async$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__50019__auto____1;
return cljs$core$async$state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto___56674,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__50043__auto__ = (function (){var statearr_56669 = f__50042__auto__.call(null);
(statearr_56669[(6)] = c__50041__auto___56674);

return statearr_56669;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto___56674,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__56701 = arguments.length;
switch (G__56701) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__50041__auto___56763 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto___56763,out){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto___56763,out){
return (function (state_56736){
var state_val_56737 = (state_56736[(1)]);
if((state_val_56737 === (7))){
var inst_56715 = (state_56736[(7)]);
var inst_56716 = (state_56736[(8)]);
var inst_56715__$1 = (state_56736[(2)]);
var inst_56716__$1 = cljs.core.nth.call(null,inst_56715__$1,(0),null);
var inst_56717 = cljs.core.nth.call(null,inst_56715__$1,(1),null);
var inst_56718 = (inst_56716__$1 == null);
var state_56736__$1 = (function (){var statearr_56738 = state_56736;
(statearr_56738[(9)] = inst_56717);

(statearr_56738[(7)] = inst_56715__$1);

(statearr_56738[(8)] = inst_56716__$1);

return statearr_56738;
})();
if(cljs.core.truth_(inst_56718)){
var statearr_56739_56764 = state_56736__$1;
(statearr_56739_56764[(1)] = (8));

} else {
var statearr_56740_56765 = state_56736__$1;
(statearr_56740_56765[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56737 === (1))){
var inst_56705 = cljs.core.vec.call(null,chs);
var inst_56706 = inst_56705;
var state_56736__$1 = (function (){var statearr_56741 = state_56736;
(statearr_56741[(10)] = inst_56706);

return statearr_56741;
})();
var statearr_56742_56766 = state_56736__$1;
(statearr_56742_56766[(2)] = null);

(statearr_56742_56766[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56737 === (4))){
var inst_56706 = (state_56736[(10)]);
var state_56736__$1 = state_56736;
return cljs.core.async.ioc_alts_BANG_.call(null,state_56736__$1,(7),inst_56706);
} else {
if((state_val_56737 === (6))){
var inst_56732 = (state_56736[(2)]);
var state_56736__$1 = state_56736;
var statearr_56743_56767 = state_56736__$1;
(statearr_56743_56767[(2)] = inst_56732);

(statearr_56743_56767[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56737 === (3))){
var inst_56734 = (state_56736[(2)]);
var state_56736__$1 = state_56736;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56736__$1,inst_56734);
} else {
if((state_val_56737 === (2))){
var inst_56706 = (state_56736[(10)]);
var inst_56708 = cljs.core.count.call(null,inst_56706);
var inst_56709 = (inst_56708 > (0));
var state_56736__$1 = state_56736;
if(cljs.core.truth_(inst_56709)){
var statearr_56745_56771 = state_56736__$1;
(statearr_56745_56771[(1)] = (4));

} else {
var statearr_56746_56773 = state_56736__$1;
(statearr_56746_56773[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56737 === (11))){
var inst_56706 = (state_56736[(10)]);
var inst_56725 = (state_56736[(2)]);
var tmp56744 = inst_56706;
var inst_56706__$1 = tmp56744;
var state_56736__$1 = (function (){var statearr_56747 = state_56736;
(statearr_56747[(10)] = inst_56706__$1);

(statearr_56747[(11)] = inst_56725);

return statearr_56747;
})();
var statearr_56748_56774 = state_56736__$1;
(statearr_56748_56774[(2)] = null);

(statearr_56748_56774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56737 === (9))){
var inst_56716 = (state_56736[(8)]);
var state_56736__$1 = state_56736;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56736__$1,(11),out,inst_56716);
} else {
if((state_val_56737 === (5))){
var inst_56730 = cljs.core.async.close_BANG_.call(null,out);
var state_56736__$1 = state_56736;
var statearr_56750_56775 = state_56736__$1;
(statearr_56750_56775[(2)] = inst_56730);

(statearr_56750_56775[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56737 === (10))){
var inst_56728 = (state_56736[(2)]);
var state_56736__$1 = state_56736;
var statearr_56755_56776 = state_56736__$1;
(statearr_56755_56776[(2)] = inst_56728);

(statearr_56755_56776[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56737 === (8))){
var inst_56706 = (state_56736[(10)]);
var inst_56717 = (state_56736[(9)]);
var inst_56715 = (state_56736[(7)]);
var inst_56716 = (state_56736[(8)]);
var inst_56720 = (function (){var cs = inst_56706;
var vec__56711 = inst_56715;
var v = inst_56716;
var c = inst_56717;
return ((function (cs,vec__56711,v,c,inst_56706,inst_56717,inst_56715,inst_56716,state_val_56737,c__50041__auto___56763,out){
return (function (p1__56699_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__56699_SHARP_);
});
;})(cs,vec__56711,v,c,inst_56706,inst_56717,inst_56715,inst_56716,state_val_56737,c__50041__auto___56763,out))
})();
var inst_56721 = cljs.core.filterv.call(null,inst_56720,inst_56706);
var inst_56706__$1 = inst_56721;
var state_56736__$1 = (function (){var statearr_56756 = state_56736;
(statearr_56756[(10)] = inst_56706__$1);

return statearr_56756;
})();
var statearr_56757_56777 = state_56736__$1;
(statearr_56757_56777[(2)] = null);

(statearr_56757_56777[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__50041__auto___56763,out))
;
return ((function (switch__50018__auto__,c__50041__auto___56763,out){
return (function() {
var cljs$core$async$state_machine__50019__auto__ = null;
var cljs$core$async$state_machine__50019__auto____0 = (function (){
var statearr_56758 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56758[(0)] = cljs$core$async$state_machine__50019__auto__);

(statearr_56758[(1)] = (1));

return statearr_56758;
});
var cljs$core$async$state_machine__50019__auto____1 = (function (state_56736){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_56736);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e56759){if((e56759 instanceof Object)){
var ex__50022__auto__ = e56759;
var statearr_56760_56779 = state_56736;
(statearr_56760_56779[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56736);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56759;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56780 = state_56736;
state_56736 = G__56780;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
cljs$core$async$state_machine__50019__auto__ = function(state_56736){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__50019__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__50019__auto____1.call(this,state_56736);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__50019__auto____0;
cljs$core$async$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__50019__auto____1;
return cljs$core$async$state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto___56763,out))
})();
var state__50043__auto__ = (function (){var statearr_56761 = f__50042__auto__.call(null);
(statearr_56761[(6)] = c__50041__auto___56763);

return statearr_56761;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto___56763,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__56785 = arguments.length;
switch (G__56785) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__50041__auto___56838 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto___56838,out){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto___56838,out){
return (function (state_56813){
var state_val_56814 = (state_56813[(1)]);
if((state_val_56814 === (7))){
var inst_56795 = (state_56813[(7)]);
var inst_56795__$1 = (state_56813[(2)]);
var inst_56796 = (inst_56795__$1 == null);
var inst_56797 = cljs.core.not.call(null,inst_56796);
var state_56813__$1 = (function (){var statearr_56815 = state_56813;
(statearr_56815[(7)] = inst_56795__$1);

return statearr_56815;
})();
if(inst_56797){
var statearr_56816_56839 = state_56813__$1;
(statearr_56816_56839[(1)] = (8));

} else {
var statearr_56817_56840 = state_56813__$1;
(statearr_56817_56840[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56814 === (1))){
var inst_56790 = (0);
var state_56813__$1 = (function (){var statearr_56818 = state_56813;
(statearr_56818[(8)] = inst_56790);

return statearr_56818;
})();
var statearr_56819_56841 = state_56813__$1;
(statearr_56819_56841[(2)] = null);

(statearr_56819_56841[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56814 === (4))){
var state_56813__$1 = state_56813;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56813__$1,(7),ch);
} else {
if((state_val_56814 === (6))){
var inst_56808 = (state_56813[(2)]);
var state_56813__$1 = state_56813;
var statearr_56821_56843 = state_56813__$1;
(statearr_56821_56843[(2)] = inst_56808);

(statearr_56821_56843[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56814 === (3))){
var inst_56810 = (state_56813[(2)]);
var inst_56811 = cljs.core.async.close_BANG_.call(null,out);
var state_56813__$1 = (function (){var statearr_56822 = state_56813;
(statearr_56822[(9)] = inst_56810);

return statearr_56822;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56813__$1,inst_56811);
} else {
if((state_val_56814 === (2))){
var inst_56790 = (state_56813[(8)]);
var inst_56792 = (inst_56790 < n);
var state_56813__$1 = state_56813;
if(cljs.core.truth_(inst_56792)){
var statearr_56823_56844 = state_56813__$1;
(statearr_56823_56844[(1)] = (4));

} else {
var statearr_56824_56845 = state_56813__$1;
(statearr_56824_56845[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56814 === (11))){
var inst_56790 = (state_56813[(8)]);
var inst_56800 = (state_56813[(2)]);
var inst_56801 = (inst_56790 + (1));
var inst_56790__$1 = inst_56801;
var state_56813__$1 = (function (){var statearr_56825 = state_56813;
(statearr_56825[(8)] = inst_56790__$1);

(statearr_56825[(10)] = inst_56800);

return statearr_56825;
})();
var statearr_56826_56846 = state_56813__$1;
(statearr_56826_56846[(2)] = null);

(statearr_56826_56846[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56814 === (9))){
var state_56813__$1 = state_56813;
var statearr_56827_56847 = state_56813__$1;
(statearr_56827_56847[(2)] = null);

(statearr_56827_56847[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56814 === (5))){
var state_56813__$1 = state_56813;
var statearr_56828_56848 = state_56813__$1;
(statearr_56828_56848[(2)] = null);

(statearr_56828_56848[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56814 === (10))){
var inst_56805 = (state_56813[(2)]);
var state_56813__$1 = state_56813;
var statearr_56831_56849 = state_56813__$1;
(statearr_56831_56849[(2)] = inst_56805);

(statearr_56831_56849[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56814 === (8))){
var inst_56795 = (state_56813[(7)]);
var state_56813__$1 = state_56813;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56813__$1,(11),out,inst_56795);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__50041__auto___56838,out))
;
return ((function (switch__50018__auto__,c__50041__auto___56838,out){
return (function() {
var cljs$core$async$state_machine__50019__auto__ = null;
var cljs$core$async$state_machine__50019__auto____0 = (function (){
var statearr_56833 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_56833[(0)] = cljs$core$async$state_machine__50019__auto__);

(statearr_56833[(1)] = (1));

return statearr_56833;
});
var cljs$core$async$state_machine__50019__auto____1 = (function (state_56813){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_56813);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e56834){if((e56834 instanceof Object)){
var ex__50022__auto__ = e56834;
var statearr_56835_56850 = state_56813;
(statearr_56835_56850[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56813);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56834;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56851 = state_56813;
state_56813 = G__56851;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
cljs$core$async$state_machine__50019__auto__ = function(state_56813){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__50019__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__50019__auto____1.call(this,state_56813);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__50019__auto____0;
cljs$core$async$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__50019__auto____1;
return cljs$core$async$state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto___56838,out))
})();
var state__50043__auto__ = (function (){var statearr_56836 = f__50042__auto__.call(null);
(statearr_56836[(6)] = c__50041__auto___56838);

return statearr_56836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto___56838,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async56853 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async56853 = (function (f,ch,meta56854){
this.f = f;
this.ch = ch;
this.meta56854 = meta56854;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async56853.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_56855,meta56854__$1){
var self__ = this;
var _56855__$1 = this;
return (new cljs.core.async.t_cljs$core$async56853(self__.f,self__.ch,meta56854__$1));
});

cljs.core.async.t_cljs$core$async56853.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_56855){
var self__ = this;
var _56855__$1 = this;
return self__.meta56854;
});

cljs.core.async.t_cljs$core$async56853.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56853.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async56853.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async56853.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56853.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async56856 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async56856 = (function (f,ch,meta56854,_,fn1,meta56857){
this.f = f;
this.ch = ch;
this.meta56854 = meta56854;
this._ = _;
this.fn1 = fn1;
this.meta56857 = meta56857;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async56856.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_56858,meta56857__$1){
var self__ = this;
var _56858__$1 = this;
return (new cljs.core.async.t_cljs$core$async56856(self__.f,self__.ch,self__.meta56854,self__._,self__.fn1,meta56857__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async56856.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_56858){
var self__ = this;
var _56858__$1 = this;
return self__.meta56857;
});})(___$1))
;

cljs.core.async.t_cljs$core$async56856.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56856.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async56856.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async56856.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__56852_SHARP_){
return f1.call(null,(((p1__56852_SHARP_ == null))?null:self__.f.call(null,p1__56852_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async56856.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta56854","meta56854",270370261,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async56853","cljs.core.async/t_cljs$core$async56853",-1356977308,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta56857","meta56857",104857989,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async56856.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async56856.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async56856";

cljs.core.async.t_cljs$core$async56856.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__47746__auto__,writer__47747__auto__,opt__47748__auto__){
return cljs.core._write.call(null,writer__47747__auto__,"cljs.core.async/t_cljs$core$async56856");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async56856 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async56856(f__$1,ch__$1,meta56854__$1,___$2,fn1__$1,meta56857){
return (new cljs.core.async.t_cljs$core$async56856(f__$1,ch__$1,meta56854__$1,___$2,fn1__$1,meta56857));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async56856(self__.f,self__.ch,self__.meta56854,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__47063__auto__ = ret;
if(cljs.core.truth_(and__47063__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__47063__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async56853.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56853.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async56853.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta56854","meta56854",270370261,null)], null);
});

cljs.core.async.t_cljs$core$async56853.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async56853.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async56853";

cljs.core.async.t_cljs$core$async56853.cljs$lang$ctorPrWriter = (function (this__47746__auto__,writer__47747__auto__,opt__47748__auto__){
return cljs.core._write.call(null,writer__47747__auto__,"cljs.core.async/t_cljs$core$async56853");
});

cljs.core.async.__GT_t_cljs$core$async56853 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async56853(f__$1,ch__$1,meta56854){
return (new cljs.core.async.t_cljs$core$async56853(f__$1,ch__$1,meta56854));
});

}

return (new cljs.core.async.t_cljs$core$async56853(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async56859 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async56859 = (function (f,ch,meta56860){
this.f = f;
this.ch = ch;
this.meta56860 = meta56860;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async56859.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_56861,meta56860__$1){
var self__ = this;
var _56861__$1 = this;
return (new cljs.core.async.t_cljs$core$async56859(self__.f,self__.ch,meta56860__$1));
});

cljs.core.async.t_cljs$core$async56859.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_56861){
var self__ = this;
var _56861__$1 = this;
return self__.meta56860;
});

cljs.core.async.t_cljs$core$async56859.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56859.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async56859.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56859.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async56859.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56859.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async56859.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta56860","meta56860",129519262,null)], null);
});

cljs.core.async.t_cljs$core$async56859.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async56859.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async56859";

cljs.core.async.t_cljs$core$async56859.cljs$lang$ctorPrWriter = (function (this__47746__auto__,writer__47747__auto__,opt__47748__auto__){
return cljs.core._write.call(null,writer__47747__auto__,"cljs.core.async/t_cljs$core$async56859");
});

cljs.core.async.__GT_t_cljs$core$async56859 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async56859(f__$1,ch__$1,meta56860){
return (new cljs.core.async.t_cljs$core$async56859(f__$1,ch__$1,meta56860));
});

}

return (new cljs.core.async.t_cljs$core$async56859(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async56862 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async56862 = (function (p,ch,meta56863){
this.p = p;
this.ch = ch;
this.meta56863 = meta56863;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async56862.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_56864,meta56863__$1){
var self__ = this;
var _56864__$1 = this;
return (new cljs.core.async.t_cljs$core$async56862(self__.p,self__.ch,meta56863__$1));
});

cljs.core.async.t_cljs$core$async56862.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_56864){
var self__ = this;
var _56864__$1 = this;
return self__.meta56863;
});

cljs.core.async.t_cljs$core$async56862.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56862.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async56862.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async56862.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56862.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async56862.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async56862.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async56862.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta56863","meta56863",-819513672,null)], null);
});

cljs.core.async.t_cljs$core$async56862.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async56862.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async56862";

cljs.core.async.t_cljs$core$async56862.cljs$lang$ctorPrWriter = (function (this__47746__auto__,writer__47747__auto__,opt__47748__auto__){
return cljs.core._write.call(null,writer__47747__auto__,"cljs.core.async/t_cljs$core$async56862");
});

cljs.core.async.__GT_t_cljs$core$async56862 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async56862(p__$1,ch__$1,meta56863){
return (new cljs.core.async.t_cljs$core$async56862(p__$1,ch__$1,meta56863));
});

}

return (new cljs.core.async.t_cljs$core$async56862(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__56866 = arguments.length;
switch (G__56866) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__50041__auto___56906 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto___56906,out){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto___56906,out){
return (function (state_56887){
var state_val_56888 = (state_56887[(1)]);
if((state_val_56888 === (7))){
var inst_56883 = (state_56887[(2)]);
var state_56887__$1 = state_56887;
var statearr_56889_56907 = state_56887__$1;
(statearr_56889_56907[(2)] = inst_56883);

(statearr_56889_56907[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56888 === (1))){
var state_56887__$1 = state_56887;
var statearr_56890_56908 = state_56887__$1;
(statearr_56890_56908[(2)] = null);

(statearr_56890_56908[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56888 === (4))){
var inst_56869 = (state_56887[(7)]);
var inst_56869__$1 = (state_56887[(2)]);
var inst_56870 = (inst_56869__$1 == null);
var state_56887__$1 = (function (){var statearr_56891 = state_56887;
(statearr_56891[(7)] = inst_56869__$1);

return statearr_56891;
})();
if(cljs.core.truth_(inst_56870)){
var statearr_56892_56909 = state_56887__$1;
(statearr_56892_56909[(1)] = (5));

} else {
var statearr_56893_56910 = state_56887__$1;
(statearr_56893_56910[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56888 === (6))){
var inst_56869 = (state_56887[(7)]);
var inst_56874 = p.call(null,inst_56869);
var state_56887__$1 = state_56887;
if(cljs.core.truth_(inst_56874)){
var statearr_56894_56911 = state_56887__$1;
(statearr_56894_56911[(1)] = (8));

} else {
var statearr_56895_56912 = state_56887__$1;
(statearr_56895_56912[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56888 === (3))){
var inst_56885 = (state_56887[(2)]);
var state_56887__$1 = state_56887;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56887__$1,inst_56885);
} else {
if((state_val_56888 === (2))){
var state_56887__$1 = state_56887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56887__$1,(4),ch);
} else {
if((state_val_56888 === (11))){
var inst_56877 = (state_56887[(2)]);
var state_56887__$1 = state_56887;
var statearr_56896_56913 = state_56887__$1;
(statearr_56896_56913[(2)] = inst_56877);

(statearr_56896_56913[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56888 === (9))){
var state_56887__$1 = state_56887;
var statearr_56897_56914 = state_56887__$1;
(statearr_56897_56914[(2)] = null);

(statearr_56897_56914[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56888 === (5))){
var inst_56872 = cljs.core.async.close_BANG_.call(null,out);
var state_56887__$1 = state_56887;
var statearr_56898_56915 = state_56887__$1;
(statearr_56898_56915[(2)] = inst_56872);

(statearr_56898_56915[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56888 === (10))){
var inst_56880 = (state_56887[(2)]);
var state_56887__$1 = (function (){var statearr_56899 = state_56887;
(statearr_56899[(8)] = inst_56880);

return statearr_56899;
})();
var statearr_56900_56916 = state_56887__$1;
(statearr_56900_56916[(2)] = null);

(statearr_56900_56916[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56888 === (8))){
var inst_56869 = (state_56887[(7)]);
var state_56887__$1 = state_56887;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56887__$1,(11),out,inst_56869);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__50041__auto___56906,out))
;
return ((function (switch__50018__auto__,c__50041__auto___56906,out){
return (function() {
var cljs$core$async$state_machine__50019__auto__ = null;
var cljs$core$async$state_machine__50019__auto____0 = (function (){
var statearr_56901 = [null,null,null,null,null,null,null,null,null];
(statearr_56901[(0)] = cljs$core$async$state_machine__50019__auto__);

(statearr_56901[(1)] = (1));

return statearr_56901;
});
var cljs$core$async$state_machine__50019__auto____1 = (function (state_56887){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_56887);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e56902){if((e56902 instanceof Object)){
var ex__50022__auto__ = e56902;
var statearr_56903_56917 = state_56887;
(statearr_56903_56917[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56887);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56902;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56918 = state_56887;
state_56887 = G__56918;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
cljs$core$async$state_machine__50019__auto__ = function(state_56887){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__50019__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__50019__auto____1.call(this,state_56887);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__50019__auto____0;
cljs$core$async$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__50019__auto____1;
return cljs$core$async$state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto___56906,out))
})();
var state__50043__auto__ = (function (){var statearr_56904 = f__50042__auto__.call(null);
(statearr_56904[(6)] = c__50041__auto___56906);

return statearr_56904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto___56906,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__56920 = arguments.length;
switch (G__56920) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__50041__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto__){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto__){
return (function (state_56983){
var state_val_56984 = (state_56983[(1)]);
if((state_val_56984 === (7))){
var inst_56979 = (state_56983[(2)]);
var state_56983__$1 = state_56983;
var statearr_56985_57023 = state_56983__$1;
(statearr_56985_57023[(2)] = inst_56979);

(statearr_56985_57023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56984 === (20))){
var inst_56949 = (state_56983[(7)]);
var inst_56960 = (state_56983[(2)]);
var inst_56961 = cljs.core.next.call(null,inst_56949);
var inst_56935 = inst_56961;
var inst_56936 = null;
var inst_56937 = (0);
var inst_56938 = (0);
var state_56983__$1 = (function (){var statearr_56986 = state_56983;
(statearr_56986[(8)] = inst_56936);

(statearr_56986[(9)] = inst_56935);

(statearr_56986[(10)] = inst_56938);

(statearr_56986[(11)] = inst_56937);

(statearr_56986[(12)] = inst_56960);

return statearr_56986;
})();
var statearr_56987_57024 = state_56983__$1;
(statearr_56987_57024[(2)] = null);

(statearr_56987_57024[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56984 === (1))){
var state_56983__$1 = state_56983;
var statearr_56988_57025 = state_56983__$1;
(statearr_56988_57025[(2)] = null);

(statearr_56988_57025[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56984 === (4))){
var inst_56924 = (state_56983[(13)]);
var inst_56924__$1 = (state_56983[(2)]);
var inst_56925 = (inst_56924__$1 == null);
var state_56983__$1 = (function (){var statearr_56989 = state_56983;
(statearr_56989[(13)] = inst_56924__$1);

return statearr_56989;
})();
if(cljs.core.truth_(inst_56925)){
var statearr_56990_57026 = state_56983__$1;
(statearr_56990_57026[(1)] = (5));

} else {
var statearr_56991_57027 = state_56983__$1;
(statearr_56991_57027[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56984 === (15))){
var state_56983__$1 = state_56983;
var statearr_56995_57028 = state_56983__$1;
(statearr_56995_57028[(2)] = null);

(statearr_56995_57028[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56984 === (21))){
var state_56983__$1 = state_56983;
var statearr_56996_57029 = state_56983__$1;
(statearr_56996_57029[(2)] = null);

(statearr_56996_57029[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56984 === (13))){
var inst_56936 = (state_56983[(8)]);
var inst_56935 = (state_56983[(9)]);
var inst_56938 = (state_56983[(10)]);
var inst_56937 = (state_56983[(11)]);
var inst_56945 = (state_56983[(2)]);
var inst_56946 = (inst_56938 + (1));
var tmp56992 = inst_56936;
var tmp56993 = inst_56935;
var tmp56994 = inst_56937;
var inst_56935__$1 = tmp56993;
var inst_56936__$1 = tmp56992;
var inst_56937__$1 = tmp56994;
var inst_56938__$1 = inst_56946;
var state_56983__$1 = (function (){var statearr_56997 = state_56983;
(statearr_56997[(14)] = inst_56945);

(statearr_56997[(8)] = inst_56936__$1);

(statearr_56997[(9)] = inst_56935__$1);

(statearr_56997[(10)] = inst_56938__$1);

(statearr_56997[(11)] = inst_56937__$1);

return statearr_56997;
})();
var statearr_56998_57030 = state_56983__$1;
(statearr_56998_57030[(2)] = null);

(statearr_56998_57030[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56984 === (22))){
var state_56983__$1 = state_56983;
var statearr_56999_57031 = state_56983__$1;
(statearr_56999_57031[(2)] = null);

(statearr_56999_57031[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56984 === (6))){
var inst_56924 = (state_56983[(13)]);
var inst_56933 = f.call(null,inst_56924);
var inst_56934 = cljs.core.seq.call(null,inst_56933);
var inst_56935 = inst_56934;
var inst_56936 = null;
var inst_56937 = (0);
var inst_56938 = (0);
var state_56983__$1 = (function (){var statearr_57000 = state_56983;
(statearr_57000[(8)] = inst_56936);

(statearr_57000[(9)] = inst_56935);

(statearr_57000[(10)] = inst_56938);

(statearr_57000[(11)] = inst_56937);

return statearr_57000;
})();
var statearr_57001_57032 = state_56983__$1;
(statearr_57001_57032[(2)] = null);

(statearr_57001_57032[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56984 === (17))){
var inst_56949 = (state_56983[(7)]);
var inst_56953 = cljs.core.chunk_first.call(null,inst_56949);
var inst_56954 = cljs.core.chunk_rest.call(null,inst_56949);
var inst_56955 = cljs.core.count.call(null,inst_56953);
var inst_56935 = inst_56954;
var inst_56936 = inst_56953;
var inst_56937 = inst_56955;
var inst_56938 = (0);
var state_56983__$1 = (function (){var statearr_57002 = state_56983;
(statearr_57002[(8)] = inst_56936);

(statearr_57002[(9)] = inst_56935);

(statearr_57002[(10)] = inst_56938);

(statearr_57002[(11)] = inst_56937);

return statearr_57002;
})();
var statearr_57003_57033 = state_56983__$1;
(statearr_57003_57033[(2)] = null);

(statearr_57003_57033[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56984 === (3))){
var inst_56981 = (state_56983[(2)]);
var state_56983__$1 = state_56983;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56983__$1,inst_56981);
} else {
if((state_val_56984 === (12))){
var inst_56969 = (state_56983[(2)]);
var state_56983__$1 = state_56983;
var statearr_57004_57034 = state_56983__$1;
(statearr_57004_57034[(2)] = inst_56969);

(statearr_57004_57034[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56984 === (2))){
var state_56983__$1 = state_56983;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56983__$1,(4),in$);
} else {
if((state_val_56984 === (23))){
var inst_56977 = (state_56983[(2)]);
var state_56983__$1 = state_56983;
var statearr_57005_57035 = state_56983__$1;
(statearr_57005_57035[(2)] = inst_56977);

(statearr_57005_57035[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56984 === (19))){
var inst_56964 = (state_56983[(2)]);
var state_56983__$1 = state_56983;
var statearr_57006_57036 = state_56983__$1;
(statearr_57006_57036[(2)] = inst_56964);

(statearr_57006_57036[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56984 === (11))){
var inst_56935 = (state_56983[(9)]);
var inst_56949 = (state_56983[(7)]);
var inst_56949__$1 = cljs.core.seq.call(null,inst_56935);
var state_56983__$1 = (function (){var statearr_57007 = state_56983;
(statearr_57007[(7)] = inst_56949__$1);

return statearr_57007;
})();
if(inst_56949__$1){
var statearr_57008_57037 = state_56983__$1;
(statearr_57008_57037[(1)] = (14));

} else {
var statearr_57009_57038 = state_56983__$1;
(statearr_57009_57038[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56984 === (9))){
var inst_56971 = (state_56983[(2)]);
var inst_56972 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_56983__$1 = (function (){var statearr_57010 = state_56983;
(statearr_57010[(15)] = inst_56971);

return statearr_57010;
})();
if(cljs.core.truth_(inst_56972)){
var statearr_57011_57039 = state_56983__$1;
(statearr_57011_57039[(1)] = (21));

} else {
var statearr_57012_57040 = state_56983__$1;
(statearr_57012_57040[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56984 === (5))){
var inst_56927 = cljs.core.async.close_BANG_.call(null,out);
var state_56983__$1 = state_56983;
var statearr_57013_57041 = state_56983__$1;
(statearr_57013_57041[(2)] = inst_56927);

(statearr_57013_57041[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56984 === (14))){
var inst_56949 = (state_56983[(7)]);
var inst_56951 = cljs.core.chunked_seq_QMARK_.call(null,inst_56949);
var state_56983__$1 = state_56983;
if(inst_56951){
var statearr_57014_57042 = state_56983__$1;
(statearr_57014_57042[(1)] = (17));

} else {
var statearr_57015_57043 = state_56983__$1;
(statearr_57015_57043[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56984 === (16))){
var inst_56967 = (state_56983[(2)]);
var state_56983__$1 = state_56983;
var statearr_57016_57044 = state_56983__$1;
(statearr_57016_57044[(2)] = inst_56967);

(statearr_57016_57044[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56984 === (10))){
var inst_56936 = (state_56983[(8)]);
var inst_56938 = (state_56983[(10)]);
var inst_56943 = cljs.core._nth.call(null,inst_56936,inst_56938);
var state_56983__$1 = state_56983;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56983__$1,(13),out,inst_56943);
} else {
if((state_val_56984 === (18))){
var inst_56949 = (state_56983[(7)]);
var inst_56958 = cljs.core.first.call(null,inst_56949);
var state_56983__$1 = state_56983;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56983__$1,(20),out,inst_56958);
} else {
if((state_val_56984 === (8))){
var inst_56938 = (state_56983[(10)]);
var inst_56937 = (state_56983[(11)]);
var inst_56940 = (inst_56938 < inst_56937);
var inst_56941 = inst_56940;
var state_56983__$1 = state_56983;
if(cljs.core.truth_(inst_56941)){
var statearr_57017_57045 = state_56983__$1;
(statearr_57017_57045[(1)] = (10));

} else {
var statearr_57018_57046 = state_56983__$1;
(statearr_57018_57046[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__50041__auto__))
;
return ((function (switch__50018__auto__,c__50041__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__50019__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__50019__auto____0 = (function (){
var statearr_57019 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_57019[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__50019__auto__);

(statearr_57019[(1)] = (1));

return statearr_57019;
});
var cljs$core$async$mapcat_STAR__$_state_machine__50019__auto____1 = (function (state_56983){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_56983);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e57020){if((e57020 instanceof Object)){
var ex__50022__auto__ = e57020;
var statearr_57021_57047 = state_56983;
(statearr_57021_57047[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56983);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57020;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57048 = state_56983;
state_56983 = G__57048;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__50019__auto__ = function(state_56983){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__50019__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__50019__auto____1.call(this,state_56983);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__50019__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__50019__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto__))
})();
var state__50043__auto__ = (function (){var statearr_57022 = f__50042__auto__.call(null);
(statearr_57022[(6)] = c__50041__auto__);

return statearr_57022;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto__))
);

return c__50041__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__57050 = arguments.length;
switch (G__57050) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__57053 = arguments.length;
switch (G__57053) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__57056 = arguments.length;
switch (G__57056) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__50041__auto___57109 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto___57109,out){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto___57109,out){
return (function (state_57080){
var state_val_57081 = (state_57080[(1)]);
if((state_val_57081 === (7))){
var inst_57075 = (state_57080[(2)]);
var state_57080__$1 = state_57080;
var statearr_57082_57110 = state_57080__$1;
(statearr_57082_57110[(2)] = inst_57075);

(statearr_57082_57110[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57081 === (1))){
var inst_57057 = null;
var state_57080__$1 = (function (){var statearr_57083 = state_57080;
(statearr_57083[(7)] = inst_57057);

return statearr_57083;
})();
var statearr_57084_57113 = state_57080__$1;
(statearr_57084_57113[(2)] = null);

(statearr_57084_57113[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57081 === (4))){
var inst_57060 = (state_57080[(8)]);
var inst_57060__$1 = (state_57080[(2)]);
var inst_57061 = (inst_57060__$1 == null);
var inst_57062 = cljs.core.not.call(null,inst_57061);
var state_57080__$1 = (function (){var statearr_57085 = state_57080;
(statearr_57085[(8)] = inst_57060__$1);

return statearr_57085;
})();
if(inst_57062){
var statearr_57086_57115 = state_57080__$1;
(statearr_57086_57115[(1)] = (5));

} else {
var statearr_57087_57116 = state_57080__$1;
(statearr_57087_57116[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57081 === (6))){
var state_57080__$1 = state_57080;
var statearr_57088_57117 = state_57080__$1;
(statearr_57088_57117[(2)] = null);

(statearr_57088_57117[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57081 === (3))){
var inst_57077 = (state_57080[(2)]);
var inst_57078 = cljs.core.async.close_BANG_.call(null,out);
var state_57080__$1 = (function (){var statearr_57089 = state_57080;
(statearr_57089[(9)] = inst_57077);

return statearr_57089;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57080__$1,inst_57078);
} else {
if((state_val_57081 === (2))){
var state_57080__$1 = state_57080;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57080__$1,(4),ch);
} else {
if((state_val_57081 === (11))){
var inst_57060 = (state_57080[(8)]);
var inst_57069 = (state_57080[(2)]);
var inst_57057 = inst_57060;
var state_57080__$1 = (function (){var statearr_57092 = state_57080;
(statearr_57092[(10)] = inst_57069);

(statearr_57092[(7)] = inst_57057);

return statearr_57092;
})();
var statearr_57093_57119 = state_57080__$1;
(statearr_57093_57119[(2)] = null);

(statearr_57093_57119[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57081 === (9))){
var inst_57060 = (state_57080[(8)]);
var state_57080__$1 = state_57080;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_57080__$1,(11),out,inst_57060);
} else {
if((state_val_57081 === (5))){
var inst_57057 = (state_57080[(7)]);
var inst_57060 = (state_57080[(8)]);
var inst_57064 = cljs.core._EQ_.call(null,inst_57060,inst_57057);
var state_57080__$1 = state_57080;
if(inst_57064){
var statearr_57095_57120 = state_57080__$1;
(statearr_57095_57120[(1)] = (8));

} else {
var statearr_57096_57121 = state_57080__$1;
(statearr_57096_57121[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57081 === (10))){
var inst_57072 = (state_57080[(2)]);
var state_57080__$1 = state_57080;
var statearr_57097_57122 = state_57080__$1;
(statearr_57097_57122[(2)] = inst_57072);

(statearr_57097_57122[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57081 === (8))){
var inst_57057 = (state_57080[(7)]);
var tmp57094 = inst_57057;
var inst_57057__$1 = tmp57094;
var state_57080__$1 = (function (){var statearr_57098 = state_57080;
(statearr_57098[(7)] = inst_57057__$1);

return statearr_57098;
})();
var statearr_57099_57123 = state_57080__$1;
(statearr_57099_57123[(2)] = null);

(statearr_57099_57123[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__50041__auto___57109,out))
;
return ((function (switch__50018__auto__,c__50041__auto___57109,out){
return (function() {
var cljs$core$async$state_machine__50019__auto__ = null;
var cljs$core$async$state_machine__50019__auto____0 = (function (){
var statearr_57100 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_57100[(0)] = cljs$core$async$state_machine__50019__auto__);

(statearr_57100[(1)] = (1));

return statearr_57100;
});
var cljs$core$async$state_machine__50019__auto____1 = (function (state_57080){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_57080);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e57101){if((e57101 instanceof Object)){
var ex__50022__auto__ = e57101;
var statearr_57102_57134 = state_57080;
(statearr_57102_57134[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57080);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57101;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57135 = state_57080;
state_57080 = G__57135;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
cljs$core$async$state_machine__50019__auto__ = function(state_57080){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__50019__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__50019__auto____1.call(this,state_57080);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__50019__auto____0;
cljs$core$async$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__50019__auto____1;
return cljs$core$async$state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto___57109,out))
})();
var state__50043__auto__ = (function (){var statearr_57103 = f__50042__auto__.call(null);
(statearr_57103[(6)] = c__50041__auto___57109);

return statearr_57103;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto___57109,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__57139 = arguments.length;
switch (G__57139) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__50041__auto___57208 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto___57208,out){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto___57208,out){
return (function (state_57180){
var state_val_57181 = (state_57180[(1)]);
if((state_val_57181 === (7))){
var inst_57176 = (state_57180[(2)]);
var state_57180__$1 = state_57180;
var statearr_57182_57209 = state_57180__$1;
(statearr_57182_57209[(2)] = inst_57176);

(statearr_57182_57209[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57181 === (1))){
var inst_57143 = (new Array(n));
var inst_57144 = inst_57143;
var inst_57145 = (0);
var state_57180__$1 = (function (){var statearr_57183 = state_57180;
(statearr_57183[(7)] = inst_57145);

(statearr_57183[(8)] = inst_57144);

return statearr_57183;
})();
var statearr_57184_57210 = state_57180__$1;
(statearr_57184_57210[(2)] = null);

(statearr_57184_57210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57181 === (4))){
var inst_57148 = (state_57180[(9)]);
var inst_57148__$1 = (state_57180[(2)]);
var inst_57149 = (inst_57148__$1 == null);
var inst_57150 = cljs.core.not.call(null,inst_57149);
var state_57180__$1 = (function (){var statearr_57185 = state_57180;
(statearr_57185[(9)] = inst_57148__$1);

return statearr_57185;
})();
if(inst_57150){
var statearr_57186_57211 = state_57180__$1;
(statearr_57186_57211[(1)] = (5));

} else {
var statearr_57187_57212 = state_57180__$1;
(statearr_57187_57212[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57181 === (15))){
var inst_57170 = (state_57180[(2)]);
var state_57180__$1 = state_57180;
var statearr_57188_57213 = state_57180__$1;
(statearr_57188_57213[(2)] = inst_57170);

(statearr_57188_57213[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57181 === (13))){
var state_57180__$1 = state_57180;
var statearr_57189_57214 = state_57180__$1;
(statearr_57189_57214[(2)] = null);

(statearr_57189_57214[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57181 === (6))){
var inst_57145 = (state_57180[(7)]);
var inst_57166 = (inst_57145 > (0));
var state_57180__$1 = state_57180;
if(cljs.core.truth_(inst_57166)){
var statearr_57190_57215 = state_57180__$1;
(statearr_57190_57215[(1)] = (12));

} else {
var statearr_57191_57216 = state_57180__$1;
(statearr_57191_57216[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57181 === (3))){
var inst_57178 = (state_57180[(2)]);
var state_57180__$1 = state_57180;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57180__$1,inst_57178);
} else {
if((state_val_57181 === (12))){
var inst_57144 = (state_57180[(8)]);
var inst_57168 = cljs.core.vec.call(null,inst_57144);
var state_57180__$1 = state_57180;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_57180__$1,(15),out,inst_57168);
} else {
if((state_val_57181 === (2))){
var state_57180__$1 = state_57180;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57180__$1,(4),ch);
} else {
if((state_val_57181 === (11))){
var inst_57160 = (state_57180[(2)]);
var inst_57161 = (new Array(n));
var inst_57144 = inst_57161;
var inst_57145 = (0);
var state_57180__$1 = (function (){var statearr_57192 = state_57180;
(statearr_57192[(10)] = inst_57160);

(statearr_57192[(7)] = inst_57145);

(statearr_57192[(8)] = inst_57144);

return statearr_57192;
})();
var statearr_57193_57225 = state_57180__$1;
(statearr_57193_57225[(2)] = null);

(statearr_57193_57225[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57181 === (9))){
var inst_57144 = (state_57180[(8)]);
var inst_57158 = cljs.core.vec.call(null,inst_57144);
var state_57180__$1 = state_57180;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_57180__$1,(11),out,inst_57158);
} else {
if((state_val_57181 === (5))){
var inst_57153 = (state_57180[(11)]);
var inst_57148 = (state_57180[(9)]);
var inst_57145 = (state_57180[(7)]);
var inst_57144 = (state_57180[(8)]);
var inst_57152 = (inst_57144[inst_57145] = inst_57148);
var inst_57153__$1 = (inst_57145 + (1));
var inst_57154 = (inst_57153__$1 < n);
var state_57180__$1 = (function (){var statearr_57194 = state_57180;
(statearr_57194[(12)] = inst_57152);

(statearr_57194[(11)] = inst_57153__$1);

return statearr_57194;
})();
if(cljs.core.truth_(inst_57154)){
var statearr_57195_57226 = state_57180__$1;
(statearr_57195_57226[(1)] = (8));

} else {
var statearr_57196_57227 = state_57180__$1;
(statearr_57196_57227[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57181 === (14))){
var inst_57173 = (state_57180[(2)]);
var inst_57174 = cljs.core.async.close_BANG_.call(null,out);
var state_57180__$1 = (function (){var statearr_57198 = state_57180;
(statearr_57198[(13)] = inst_57173);

return statearr_57198;
})();
var statearr_57199_57228 = state_57180__$1;
(statearr_57199_57228[(2)] = inst_57174);

(statearr_57199_57228[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57181 === (10))){
var inst_57164 = (state_57180[(2)]);
var state_57180__$1 = state_57180;
var statearr_57200_57229 = state_57180__$1;
(statearr_57200_57229[(2)] = inst_57164);

(statearr_57200_57229[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57181 === (8))){
var inst_57153 = (state_57180[(11)]);
var inst_57144 = (state_57180[(8)]);
var tmp57197 = inst_57144;
var inst_57144__$1 = tmp57197;
var inst_57145 = inst_57153;
var state_57180__$1 = (function (){var statearr_57201 = state_57180;
(statearr_57201[(7)] = inst_57145);

(statearr_57201[(8)] = inst_57144__$1);

return statearr_57201;
})();
var statearr_57202_57231 = state_57180__$1;
(statearr_57202_57231[(2)] = null);

(statearr_57202_57231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__50041__auto___57208,out))
;
return ((function (switch__50018__auto__,c__50041__auto___57208,out){
return (function() {
var cljs$core$async$state_machine__50019__auto__ = null;
var cljs$core$async$state_machine__50019__auto____0 = (function (){
var statearr_57203 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_57203[(0)] = cljs$core$async$state_machine__50019__auto__);

(statearr_57203[(1)] = (1));

return statearr_57203;
});
var cljs$core$async$state_machine__50019__auto____1 = (function (state_57180){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_57180);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e57204){if((e57204 instanceof Object)){
var ex__50022__auto__ = e57204;
var statearr_57205_57233 = state_57180;
(statearr_57205_57233[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57180);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57204;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57234 = state_57180;
state_57180 = G__57234;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
cljs$core$async$state_machine__50019__auto__ = function(state_57180){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__50019__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__50019__auto____1.call(this,state_57180);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__50019__auto____0;
cljs$core$async$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__50019__auto____1;
return cljs$core$async$state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto___57208,out))
})();
var state__50043__auto__ = (function (){var statearr_57206 = f__50042__auto__.call(null);
(statearr_57206[(6)] = c__50041__auto___57208);

return statearr_57206;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto___57208,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__57237 = arguments.length;
switch (G__57237) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__50041__auto___57314 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto___57314,out){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto___57314,out){
return (function (state_57279){
var state_val_57280 = (state_57279[(1)]);
if((state_val_57280 === (7))){
var inst_57275 = (state_57279[(2)]);
var state_57279__$1 = state_57279;
var statearr_57281_57315 = state_57279__$1;
(statearr_57281_57315[(2)] = inst_57275);

(statearr_57281_57315[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57280 === (1))){
var inst_57238 = [];
var inst_57239 = inst_57238;
var inst_57240 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_57279__$1 = (function (){var statearr_57282 = state_57279;
(statearr_57282[(7)] = inst_57239);

(statearr_57282[(8)] = inst_57240);

return statearr_57282;
})();
var statearr_57283_57327 = state_57279__$1;
(statearr_57283_57327[(2)] = null);

(statearr_57283_57327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57280 === (4))){
var inst_57243 = (state_57279[(9)]);
var inst_57243__$1 = (state_57279[(2)]);
var inst_57244 = (inst_57243__$1 == null);
var inst_57245 = cljs.core.not.call(null,inst_57244);
var state_57279__$1 = (function (){var statearr_57286 = state_57279;
(statearr_57286[(9)] = inst_57243__$1);

return statearr_57286;
})();
if(inst_57245){
var statearr_57288_57328 = state_57279__$1;
(statearr_57288_57328[(1)] = (5));

} else {
var statearr_57289_57329 = state_57279__$1;
(statearr_57289_57329[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57280 === (15))){
var inst_57269 = (state_57279[(2)]);
var state_57279__$1 = state_57279;
var statearr_57290_57330 = state_57279__$1;
(statearr_57290_57330[(2)] = inst_57269);

(statearr_57290_57330[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57280 === (13))){
var state_57279__$1 = state_57279;
var statearr_57294_57331 = state_57279__$1;
(statearr_57294_57331[(2)] = null);

(statearr_57294_57331[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57280 === (6))){
var inst_57239 = (state_57279[(7)]);
var inst_57264 = inst_57239.length;
var inst_57265 = (inst_57264 > (0));
var state_57279__$1 = state_57279;
if(cljs.core.truth_(inst_57265)){
var statearr_57295_57332 = state_57279__$1;
(statearr_57295_57332[(1)] = (12));

} else {
var statearr_57296_57333 = state_57279__$1;
(statearr_57296_57333[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57280 === (3))){
var inst_57277 = (state_57279[(2)]);
var state_57279__$1 = state_57279;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57279__$1,inst_57277);
} else {
if((state_val_57280 === (12))){
var inst_57239 = (state_57279[(7)]);
var inst_57267 = cljs.core.vec.call(null,inst_57239);
var state_57279__$1 = state_57279;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_57279__$1,(15),out,inst_57267);
} else {
if((state_val_57280 === (2))){
var state_57279__$1 = state_57279;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57279__$1,(4),ch);
} else {
if((state_val_57280 === (11))){
var inst_57247 = (state_57279[(10)]);
var inst_57243 = (state_57279[(9)]);
var inst_57257 = (state_57279[(2)]);
var inst_57258 = [];
var inst_57259 = inst_57258.push(inst_57243);
var inst_57239 = inst_57258;
var inst_57240 = inst_57247;
var state_57279__$1 = (function (){var statearr_57297 = state_57279;
(statearr_57297[(7)] = inst_57239);

(statearr_57297[(11)] = inst_57259);

(statearr_57297[(8)] = inst_57240);

(statearr_57297[(12)] = inst_57257);

return statearr_57297;
})();
var statearr_57298_57348 = state_57279__$1;
(statearr_57298_57348[(2)] = null);

(statearr_57298_57348[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57280 === (9))){
var inst_57239 = (state_57279[(7)]);
var inst_57255 = cljs.core.vec.call(null,inst_57239);
var state_57279__$1 = state_57279;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_57279__$1,(11),out,inst_57255);
} else {
if((state_val_57280 === (5))){
var inst_57247 = (state_57279[(10)]);
var inst_57243 = (state_57279[(9)]);
var inst_57240 = (state_57279[(8)]);
var inst_57247__$1 = f.call(null,inst_57243);
var inst_57248 = cljs.core._EQ_.call(null,inst_57247__$1,inst_57240);
var inst_57249 = cljs.core.keyword_identical_QMARK_.call(null,inst_57240,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_57250 = (inst_57248) || (inst_57249);
var state_57279__$1 = (function (){var statearr_57299 = state_57279;
(statearr_57299[(10)] = inst_57247__$1);

return statearr_57299;
})();
if(cljs.core.truth_(inst_57250)){
var statearr_57300_57349 = state_57279__$1;
(statearr_57300_57349[(1)] = (8));

} else {
var statearr_57301_57350 = state_57279__$1;
(statearr_57301_57350[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57280 === (14))){
var inst_57272 = (state_57279[(2)]);
var inst_57273 = cljs.core.async.close_BANG_.call(null,out);
var state_57279__$1 = (function (){var statearr_57303 = state_57279;
(statearr_57303[(13)] = inst_57272);

return statearr_57303;
})();
var statearr_57304_57351 = state_57279__$1;
(statearr_57304_57351[(2)] = inst_57273);

(statearr_57304_57351[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57280 === (10))){
var inst_57262 = (state_57279[(2)]);
var state_57279__$1 = state_57279;
var statearr_57305_57352 = state_57279__$1;
(statearr_57305_57352[(2)] = inst_57262);

(statearr_57305_57352[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57280 === (8))){
var inst_57239 = (state_57279[(7)]);
var inst_57247 = (state_57279[(10)]);
var inst_57243 = (state_57279[(9)]);
var inst_57252 = inst_57239.push(inst_57243);
var tmp57302 = inst_57239;
var inst_57239__$1 = tmp57302;
var inst_57240 = inst_57247;
var state_57279__$1 = (function (){var statearr_57306 = state_57279;
(statearr_57306[(7)] = inst_57239__$1);

(statearr_57306[(14)] = inst_57252);

(statearr_57306[(8)] = inst_57240);

return statearr_57306;
})();
var statearr_57307_57353 = state_57279__$1;
(statearr_57307_57353[(2)] = null);

(statearr_57307_57353[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__50041__auto___57314,out))
;
return ((function (switch__50018__auto__,c__50041__auto___57314,out){
return (function() {
var cljs$core$async$state_machine__50019__auto__ = null;
var cljs$core$async$state_machine__50019__auto____0 = (function (){
var statearr_57308 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_57308[(0)] = cljs$core$async$state_machine__50019__auto__);

(statearr_57308[(1)] = (1));

return statearr_57308;
});
var cljs$core$async$state_machine__50019__auto____1 = (function (state_57279){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_57279);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e57309){if((e57309 instanceof Object)){
var ex__50022__auto__ = e57309;
var statearr_57310_57354 = state_57279;
(statearr_57310_57354[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57279);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57309;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57355 = state_57279;
state_57279 = G__57355;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
cljs$core$async$state_machine__50019__auto__ = function(state_57279){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__50019__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__50019__auto____1.call(this,state_57279);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__50019__auto____0;
cljs$core$async$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__50019__auto____1;
return cljs$core$async$state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto___57314,out))
})();
var state__50043__auto__ = (function (){var statearr_57312 = f__50042__auto__.call(null);
(statearr_57312[(6)] = c__50041__auto___57314);

return statearr_57312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto___57314,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1509203650484
