// Compiled by ClojureScript 1.9.946 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__47075__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__47075__auto__){
return or__47075__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__47075__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__47075__auto__)){
return or__47075__auto__;
} else {
var or__47075__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__47075__auto____$1)){
return or__47075__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__57404_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__57404_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__57431 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__57432 = null;
var count__57433 = (0);
var i__57434 = (0);
while(true){
if((i__57434 < count__57433)){
var n = cljs.core._nth.call(null,chunk__57432,i__57434);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__57439 = seq__57431;
var G__57440 = chunk__57432;
var G__57441 = count__57433;
var G__57442 = (i__57434 + (1));
seq__57431 = G__57439;
chunk__57432 = G__57440;
count__57433 = G__57441;
i__57434 = G__57442;
continue;
} else {
var temp__5459__auto__ = cljs.core.seq.call(null,seq__57431);
if(temp__5459__auto__){
var seq__57431__$1 = temp__5459__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57431__$1)){
var c__48006__auto__ = cljs.core.chunk_first.call(null,seq__57431__$1);
var G__57443 = cljs.core.chunk_rest.call(null,seq__57431__$1);
var G__57444 = c__48006__auto__;
var G__57445 = cljs.core.count.call(null,c__48006__auto__);
var G__57446 = (0);
seq__57431 = G__57443;
chunk__57432 = G__57444;
count__57433 = G__57445;
i__57434 = G__57446;
continue;
} else {
var n = cljs.core.first.call(null,seq__57431__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__57447 = cljs.core.next.call(null,seq__57431__$1);
var G__57448 = null;
var G__57449 = (0);
var G__57450 = (0);
seq__57431 = G__57447;
chunk__57432 = G__57448;
count__57433 = G__57449;
i__57434 = G__57450;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__57460_57469 = cljs.core.seq.call(null,deps);
var chunk__57461_57470 = null;
var count__57462_57471 = (0);
var i__57463_57472 = (0);
while(true){
if((i__57463_57472 < count__57462_57471)){
var dep_57473 = cljs.core._nth.call(null,chunk__57461_57470,i__57463_57472);
topo_sort_helper_STAR_.call(null,dep_57473,(depth + (1)),state);

var G__57474 = seq__57460_57469;
var G__57475 = chunk__57461_57470;
var G__57476 = count__57462_57471;
var G__57477 = (i__57463_57472 + (1));
seq__57460_57469 = G__57474;
chunk__57461_57470 = G__57475;
count__57462_57471 = G__57476;
i__57463_57472 = G__57477;
continue;
} else {
var temp__5459__auto___57478 = cljs.core.seq.call(null,seq__57460_57469);
if(temp__5459__auto___57478){
var seq__57460_57479__$1 = temp__5459__auto___57478;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57460_57479__$1)){
var c__48006__auto___57480 = cljs.core.chunk_first.call(null,seq__57460_57479__$1);
var G__57481 = cljs.core.chunk_rest.call(null,seq__57460_57479__$1);
var G__57482 = c__48006__auto___57480;
var G__57483 = cljs.core.count.call(null,c__48006__auto___57480);
var G__57484 = (0);
seq__57460_57469 = G__57481;
chunk__57461_57470 = G__57482;
count__57462_57471 = G__57483;
i__57463_57472 = G__57484;
continue;
} else {
var dep_57488 = cljs.core.first.call(null,seq__57460_57479__$1);
topo_sort_helper_STAR_.call(null,dep_57488,(depth + (1)),state);

var G__57490 = cljs.core.next.call(null,seq__57460_57479__$1);
var G__57491 = null;
var G__57492 = (0);
var G__57493 = (0);
seq__57460_57469 = G__57490;
chunk__57461_57470 = G__57491;
count__57462_57471 = G__57492;
i__57463_57472 = G__57493;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__57464){
var vec__57465 = p__57464;
var seq__57466 = cljs.core.seq.call(null,vec__57465);
var first__57467 = cljs.core.first.call(null,seq__57466);
var seq__57466__$1 = cljs.core.next.call(null,seq__57466);
var x = first__57467;
var xs = seq__57466__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__57465,seq__57466,first__57467,seq__57466__$1,x,xs,get_deps__$1){
return (function (p1__57451_SHARP_){
return clojure.set.difference.call(null,p1__57451_SHARP_,x);
});})(vec__57465,seq__57466,first__57467,seq__57466__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__57520 = cljs.core.seq.call(null,provides);
var chunk__57521 = null;
var count__57522 = (0);
var i__57523 = (0);
while(true){
if((i__57523 < count__57522)){
var prov = cljs.core._nth.call(null,chunk__57521,i__57523);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__57524_57538 = cljs.core.seq.call(null,requires);
var chunk__57525_57539 = null;
var count__57526_57540 = (0);
var i__57527_57541 = (0);
while(true){
if((i__57527_57541 < count__57526_57540)){
var req_57542 = cljs.core._nth.call(null,chunk__57525_57539,i__57527_57541);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_57542,prov);

var G__57543 = seq__57524_57538;
var G__57544 = chunk__57525_57539;
var G__57545 = count__57526_57540;
var G__57546 = (i__57527_57541 + (1));
seq__57524_57538 = G__57543;
chunk__57525_57539 = G__57544;
count__57526_57540 = G__57545;
i__57527_57541 = G__57546;
continue;
} else {
var temp__5459__auto___57547 = cljs.core.seq.call(null,seq__57524_57538);
if(temp__5459__auto___57547){
var seq__57524_57548__$1 = temp__5459__auto___57547;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57524_57548__$1)){
var c__48006__auto___57549 = cljs.core.chunk_first.call(null,seq__57524_57548__$1);
var G__57550 = cljs.core.chunk_rest.call(null,seq__57524_57548__$1);
var G__57551 = c__48006__auto___57549;
var G__57552 = cljs.core.count.call(null,c__48006__auto___57549);
var G__57553 = (0);
seq__57524_57538 = G__57550;
chunk__57525_57539 = G__57551;
count__57526_57540 = G__57552;
i__57527_57541 = G__57553;
continue;
} else {
var req_57554 = cljs.core.first.call(null,seq__57524_57548__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_57554,prov);

var G__57555 = cljs.core.next.call(null,seq__57524_57548__$1);
var G__57556 = null;
var G__57557 = (0);
var G__57558 = (0);
seq__57524_57538 = G__57555;
chunk__57525_57539 = G__57556;
count__57526_57540 = G__57557;
i__57527_57541 = G__57558;
continue;
}
} else {
}
}
break;
}

var G__57559 = seq__57520;
var G__57560 = chunk__57521;
var G__57561 = count__57522;
var G__57562 = (i__57523 + (1));
seq__57520 = G__57559;
chunk__57521 = G__57560;
count__57522 = G__57561;
i__57523 = G__57562;
continue;
} else {
var temp__5459__auto__ = cljs.core.seq.call(null,seq__57520);
if(temp__5459__auto__){
var seq__57520__$1 = temp__5459__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57520__$1)){
var c__48006__auto__ = cljs.core.chunk_first.call(null,seq__57520__$1);
var G__57563 = cljs.core.chunk_rest.call(null,seq__57520__$1);
var G__57564 = c__48006__auto__;
var G__57565 = cljs.core.count.call(null,c__48006__auto__);
var G__57566 = (0);
seq__57520 = G__57563;
chunk__57521 = G__57564;
count__57522 = G__57565;
i__57523 = G__57566;
continue;
} else {
var prov = cljs.core.first.call(null,seq__57520__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__57533_57569 = cljs.core.seq.call(null,requires);
var chunk__57534_57570 = null;
var count__57535_57571 = (0);
var i__57536_57572 = (0);
while(true){
if((i__57536_57572 < count__57535_57571)){
var req_57573 = cljs.core._nth.call(null,chunk__57534_57570,i__57536_57572);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_57573,prov);

var G__57574 = seq__57533_57569;
var G__57575 = chunk__57534_57570;
var G__57576 = count__57535_57571;
var G__57577 = (i__57536_57572 + (1));
seq__57533_57569 = G__57574;
chunk__57534_57570 = G__57575;
count__57535_57571 = G__57576;
i__57536_57572 = G__57577;
continue;
} else {
var temp__5459__auto___57578__$1 = cljs.core.seq.call(null,seq__57533_57569);
if(temp__5459__auto___57578__$1){
var seq__57533_57581__$1 = temp__5459__auto___57578__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57533_57581__$1)){
var c__48006__auto___57582 = cljs.core.chunk_first.call(null,seq__57533_57581__$1);
var G__57583 = cljs.core.chunk_rest.call(null,seq__57533_57581__$1);
var G__57584 = c__48006__auto___57582;
var G__57585 = cljs.core.count.call(null,c__48006__auto___57582);
var G__57586 = (0);
seq__57533_57569 = G__57583;
chunk__57534_57570 = G__57584;
count__57535_57571 = G__57585;
i__57536_57572 = G__57586;
continue;
} else {
var req_57587 = cljs.core.first.call(null,seq__57533_57581__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_57587,prov);

var G__57588 = cljs.core.next.call(null,seq__57533_57581__$1);
var G__57589 = null;
var G__57590 = (0);
var G__57591 = (0);
seq__57533_57569 = G__57588;
chunk__57534_57570 = G__57589;
count__57535_57571 = G__57590;
i__57536_57572 = G__57591;
continue;
}
} else {
}
}
break;
}

var G__57593 = cljs.core.next.call(null,seq__57520__$1);
var G__57594 = null;
var G__57595 = (0);
var G__57596 = (0);
seq__57520 = G__57593;
chunk__57521 = G__57594;
count__57522 = G__57595;
i__57523 = G__57596;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__57597_57604 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__57598_57605 = null;
var count__57599_57606 = (0);
var i__57600_57607 = (0);
while(true){
if((i__57600_57607 < count__57599_57606)){
var ns_57608 = cljs.core._nth.call(null,chunk__57598_57605,i__57600_57607);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_57608);

var G__57609 = seq__57597_57604;
var G__57610 = chunk__57598_57605;
var G__57611 = count__57599_57606;
var G__57612 = (i__57600_57607 + (1));
seq__57597_57604 = G__57609;
chunk__57598_57605 = G__57610;
count__57599_57606 = G__57611;
i__57600_57607 = G__57612;
continue;
} else {
var temp__5459__auto___57613 = cljs.core.seq.call(null,seq__57597_57604);
if(temp__5459__auto___57613){
var seq__57597_57614__$1 = temp__5459__auto___57613;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57597_57614__$1)){
var c__48006__auto___57615 = cljs.core.chunk_first.call(null,seq__57597_57614__$1);
var G__57616 = cljs.core.chunk_rest.call(null,seq__57597_57614__$1);
var G__57617 = c__48006__auto___57615;
var G__57618 = cljs.core.count.call(null,c__48006__auto___57615);
var G__57619 = (0);
seq__57597_57604 = G__57616;
chunk__57598_57605 = G__57617;
count__57599_57606 = G__57618;
i__57600_57607 = G__57619;
continue;
} else {
var ns_57620 = cljs.core.first.call(null,seq__57597_57614__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_57620);

var G__57621 = cljs.core.next.call(null,seq__57597_57614__$1);
var G__57622 = null;
var G__57623 = (0);
var G__57624 = (0);
seq__57597_57604 = G__57621;
chunk__57598_57605 = G__57622;
count__57599_57606 = G__57623;
i__57600_57607 = G__57624;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__47075__auto__ = goog.require__;
if(cljs.core.truth_(or__47075__auto__)){
return or__47075__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__57625__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__57625 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__57626__i = 0, G__57626__a = new Array(arguments.length -  0);
while (G__57626__i < G__57626__a.length) {G__57626__a[G__57626__i] = arguments[G__57626__i + 0]; ++G__57626__i;}
  args = new cljs.core.IndexedSeq(G__57626__a,0,null);
} 
return G__57625__delegate.call(this,args);};
G__57625.cljs$lang$maxFixedArity = 0;
G__57625.cljs$lang$applyTo = (function (arglist__57631){
var args = cljs.core.seq(arglist__57631);
return G__57625__delegate(args);
});
G__57625.cljs$core$IFn$_invoke$arity$variadic = G__57625__delegate;
return G__57625;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = ((typeof goog.net.jsloader.safeLoad !== 'undefined')?(function (p1__57635_SHARP_,p2__57636_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__57635_SHARP_)].join('')),p2__57636_SHARP_);
}):((typeof goog.net.jsloader.load !== 'undefined')?(function (p1__57637_SHARP_,p2__57638_SHARP_){
return goog.net.jsloader.load([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__57637_SHARP_)].join(''),p2__57638_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__57640 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__57640.addCallback(((function (G__57640){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__57640))
);

G__57640.addErrback(((function (G__57640){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__57640))
);

return G__57640;
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__57647 = cljs.core._EQ_;
var expr__57648 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__57647.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__57648))){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern,pred__57647,expr__57648){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern,pred__57647,expr__57648))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path,pred__57647,expr__57648){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e57650){if((e57650 instanceof Error)){
var e = e57650;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e57650;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path,pred__57647,expr__57648))
} else {
if(cljs.core.truth_(pred__57647.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__57648))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__57647.call(null,new cljs.core.Keyword(null,"react-native","react-native",-1543085138),expr__57648))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__57647.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__57648))){
return ((function (pred__57647,expr__57648){
return (function (request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e57651){if((e57651 instanceof Error)){
var e = e57651;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e57651;

}
}})());
});
;})(pred__57647,expr__57648))
} else {
return ((function (pred__57647,expr__57648){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__57647,expr__57648))
}
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__57652,callback){
var map__57653 = p__57652;
var map__57653__$1 = ((((!((map__57653 == null)))?((((map__57653.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57653.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57653):map__57653);
var file_msg = map__57653__$1;
var request_url = cljs.core.get.call(null,map__57653__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__57653,map__57653__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__57653,map__57653__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__50041__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto__){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto__){
return (function (state_57683){
var state_val_57684 = (state_57683[(1)]);
if((state_val_57684 === (7))){
var inst_57679 = (state_57683[(2)]);
var state_57683__$1 = state_57683;
var statearr_57685_57706 = state_57683__$1;
(statearr_57685_57706[(2)] = inst_57679);

(statearr_57685_57706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57684 === (1))){
var state_57683__$1 = state_57683;
var statearr_57686_57707 = state_57683__$1;
(statearr_57686_57707[(2)] = null);

(statearr_57686_57707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57684 === (4))){
var inst_57663 = (state_57683[(7)]);
var inst_57663__$1 = (state_57683[(2)]);
var state_57683__$1 = (function (){var statearr_57687 = state_57683;
(statearr_57687[(7)] = inst_57663__$1);

return statearr_57687;
})();
if(cljs.core.truth_(inst_57663__$1)){
var statearr_57688_57708 = state_57683__$1;
(statearr_57688_57708[(1)] = (5));

} else {
var statearr_57689_57709 = state_57683__$1;
(statearr_57689_57709[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57684 === (6))){
var state_57683__$1 = state_57683;
var statearr_57690_57710 = state_57683__$1;
(statearr_57690_57710[(2)] = null);

(statearr_57690_57710[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57684 === (3))){
var inst_57681 = (state_57683[(2)]);
var state_57683__$1 = state_57683;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57683__$1,inst_57681);
} else {
if((state_val_57684 === (2))){
var state_57683__$1 = state_57683;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57683__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_57684 === (11))){
var inst_57675 = (state_57683[(2)]);
var state_57683__$1 = (function (){var statearr_57691 = state_57683;
(statearr_57691[(8)] = inst_57675);

return statearr_57691;
})();
var statearr_57692_57712 = state_57683__$1;
(statearr_57692_57712[(2)] = null);

(statearr_57692_57712[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57684 === (9))){
var inst_57667 = (state_57683[(9)]);
var inst_57669 = (state_57683[(10)]);
var inst_57671 = inst_57669.call(null,inst_57667);
var state_57683__$1 = state_57683;
var statearr_57696_57714 = state_57683__$1;
(statearr_57696_57714[(2)] = inst_57671);

(statearr_57696_57714[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57684 === (5))){
var inst_57663 = (state_57683[(7)]);
var inst_57665 = figwheel.client.file_reloading.blocking_load.call(null,inst_57663);
var state_57683__$1 = state_57683;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57683__$1,(8),inst_57665);
} else {
if((state_val_57684 === (10))){
var inst_57667 = (state_57683[(9)]);
var inst_57673 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_57667);
var state_57683__$1 = state_57683;
var statearr_57698_57715 = state_57683__$1;
(statearr_57698_57715[(2)] = inst_57673);

(statearr_57698_57715[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57684 === (8))){
var inst_57663 = (state_57683[(7)]);
var inst_57669 = (state_57683[(10)]);
var inst_57667 = (state_57683[(2)]);
var inst_57668 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_57669__$1 = cljs.core.get.call(null,inst_57668,inst_57663);
var state_57683__$1 = (function (){var statearr_57699 = state_57683;
(statearr_57699[(9)] = inst_57667);

(statearr_57699[(10)] = inst_57669__$1);

return statearr_57699;
})();
if(cljs.core.truth_(inst_57669__$1)){
var statearr_57700_57716 = state_57683__$1;
(statearr_57700_57716[(1)] = (9));

} else {
var statearr_57701_57717 = state_57683__$1;
(statearr_57701_57717[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__50041__auto__))
;
return ((function (switch__50018__auto__,c__50041__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__50019__auto__ = null;
var figwheel$client$file_reloading$state_machine__50019__auto____0 = (function (){
var statearr_57702 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_57702[(0)] = figwheel$client$file_reloading$state_machine__50019__auto__);

(statearr_57702[(1)] = (1));

return statearr_57702;
});
var figwheel$client$file_reloading$state_machine__50019__auto____1 = (function (state_57683){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_57683);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e57703){if((e57703 instanceof Object)){
var ex__50022__auto__ = e57703;
var statearr_57704_57722 = state_57683;
(statearr_57704_57722[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57683);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57703;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57723 = state_57683;
state_57683 = G__57723;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__50019__auto__ = function(state_57683){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__50019__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__50019__auto____1.call(this,state_57683);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__50019__auto____0;
figwheel$client$file_reloading$state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__50019__auto____1;
return figwheel$client$file_reloading$state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto__))
})();
var state__50043__auto__ = (function (){var statearr_57705 = f__50042__auto__.call(null);
(statearr_57705[(6)] = c__50041__auto__);

return statearr_57705;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto__))
);

return c__50041__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__57724,callback){
var map__57725 = p__57724;
var map__57725__$1 = ((((!((map__57725 == null)))?((((map__57725.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57725.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57725):map__57725);
var file_msg = map__57725__$1;
var namespace = cljs.core.get.call(null,map__57725__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__57725,map__57725__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__57725,map__57725__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__57732){
var map__57733 = p__57732;
var map__57733__$1 = ((((!((map__57733 == null)))?((((map__57733.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57733.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57733):map__57733);
var file_msg = map__57733__$1;
var namespace = cljs.core.get.call(null,map__57733__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__57735){
var map__57736 = p__57735;
var map__57736__$1 = ((((!((map__57736 == null)))?((((map__57736.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57736.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57736):map__57736);
var file_msg = map__57736__$1;
var namespace = cljs.core.get.call(null,map__57736__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__47063__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__47063__auto__){
var or__47075__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__47075__auto__)){
return or__47075__auto__;
} else {
var or__47075__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__47075__auto____$1)){
return or__47075__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__47063__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__57759,callback){
var map__57760 = p__57759;
var map__57760__$1 = ((((!((map__57760 == null)))?((((map__57760.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57760.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57760):map__57760);
var file_msg = map__57760__$1;
var request_url = cljs.core.get.call(null,map__57760__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__57760__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__50041__auto___57829 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto___57829,out){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto___57829,out){
return (function (state_57800){
var state_val_57801 = (state_57800[(1)]);
if((state_val_57801 === (1))){
var inst_57774 = cljs.core.seq.call(null,files);
var inst_57775 = cljs.core.first.call(null,inst_57774);
var inst_57776 = cljs.core.next.call(null,inst_57774);
var inst_57777 = files;
var state_57800__$1 = (function (){var statearr_57802 = state_57800;
(statearr_57802[(7)] = inst_57775);

(statearr_57802[(8)] = inst_57777);

(statearr_57802[(9)] = inst_57776);

return statearr_57802;
})();
var statearr_57803_57834 = state_57800__$1;
(statearr_57803_57834[(2)] = null);

(statearr_57803_57834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57801 === (2))){
var inst_57777 = (state_57800[(8)]);
var inst_57783 = (state_57800[(10)]);
var inst_57782 = cljs.core.seq.call(null,inst_57777);
var inst_57783__$1 = cljs.core.first.call(null,inst_57782);
var inst_57784 = cljs.core.next.call(null,inst_57782);
var inst_57785 = (inst_57783__$1 == null);
var inst_57786 = cljs.core.not.call(null,inst_57785);
var state_57800__$1 = (function (){var statearr_57804 = state_57800;
(statearr_57804[(11)] = inst_57784);

(statearr_57804[(10)] = inst_57783__$1);

return statearr_57804;
})();
if(inst_57786){
var statearr_57805_57837 = state_57800__$1;
(statearr_57805_57837[(1)] = (4));

} else {
var statearr_57806_57838 = state_57800__$1;
(statearr_57806_57838[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57801 === (3))){
var inst_57798 = (state_57800[(2)]);
var state_57800__$1 = state_57800;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57800__$1,inst_57798);
} else {
if((state_val_57801 === (4))){
var inst_57783 = (state_57800[(10)]);
var inst_57788 = figwheel.client.file_reloading.reload_js_file.call(null,inst_57783);
var state_57800__$1 = state_57800;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57800__$1,(7),inst_57788);
} else {
if((state_val_57801 === (5))){
var inst_57794 = cljs.core.async.close_BANG_.call(null,out);
var state_57800__$1 = state_57800;
var statearr_57808_57839 = state_57800__$1;
(statearr_57808_57839[(2)] = inst_57794);

(statearr_57808_57839[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57801 === (6))){
var inst_57796 = (state_57800[(2)]);
var state_57800__$1 = state_57800;
var statearr_57810_57840 = state_57800__$1;
(statearr_57810_57840[(2)] = inst_57796);

(statearr_57810_57840[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57801 === (7))){
var inst_57784 = (state_57800[(11)]);
var inst_57790 = (state_57800[(2)]);
var inst_57791 = cljs.core.async.put_BANG_.call(null,out,inst_57790);
var inst_57777 = inst_57784;
var state_57800__$1 = (function (){var statearr_57811 = state_57800;
(statearr_57811[(8)] = inst_57777);

(statearr_57811[(12)] = inst_57791);

return statearr_57811;
})();
var statearr_57812_57841 = state_57800__$1;
(statearr_57812_57841[(2)] = null);

(statearr_57812_57841[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__50041__auto___57829,out))
;
return ((function (switch__50018__auto__,c__50041__auto___57829,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__50019__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__50019__auto____0 = (function (){
var statearr_57813 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_57813[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__50019__auto__);

(statearr_57813[(1)] = (1));

return statearr_57813;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__50019__auto____1 = (function (state_57800){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_57800);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e57814){if((e57814 instanceof Object)){
var ex__50022__auto__ = e57814;
var statearr_57815_57844 = state_57800;
(statearr_57815_57844[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57800);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57814;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57845 = state_57800;
state_57800 = G__57845;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__50019__auto__ = function(state_57800){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__50019__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__50019__auto____1.call(this,state_57800);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__50019__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__50019__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto___57829,out))
})();
var state__50043__auto__ = (function (){var statearr_57816 = f__50042__auto__.call(null);
(statearr_57816[(6)] = c__50041__auto___57829);

return statearr_57816;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto___57829,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__57846,opts){
var map__57847 = p__57846;
var map__57847__$1 = ((((!((map__57847 == null)))?((((map__57847.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57847.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57847):map__57847);
var eval_body = cljs.core.get.call(null,map__57847__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__57847__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__47063__auto__ = eval_body;
if(cljs.core.truth_(and__47063__auto__)){
return typeof eval_body === 'string';
} else {
return and__47063__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e57849){var e = e57849;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__5457__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__57850_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__57850_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__5457__auto__)){
var file_msg = temp__5457__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__57851){
var vec__57852 = p__57851;
var k = cljs.core.nth.call(null,vec__57852,(0),null);
var v = cljs.core.nth.call(null,vec__57852,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__57855){
var vec__57856 = p__57855;
var k = cljs.core.nth.call(null,vec__57856,(0),null);
var v = cljs.core.nth.call(null,vec__57856,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__57862,p__57863){
var map__57864 = p__57862;
var map__57864__$1 = ((((!((map__57864 == null)))?((((map__57864.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57864.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57864):map__57864);
var opts = map__57864__$1;
var before_jsload = cljs.core.get.call(null,map__57864__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__57864__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__57864__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__57865 = p__57863;
var map__57865__$1 = ((((!((map__57865 == null)))?((((map__57865.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57865.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57865):map__57865);
var msg = map__57865__$1;
var files = cljs.core.get.call(null,map__57865__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__57865__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__57865__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__50041__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto__,map__57864,map__57864__$1,opts,before_jsload,on_jsload,reload_dependents,map__57865,map__57865__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto__,map__57864,map__57864__$1,opts,before_jsload,on_jsload,reload_dependents,map__57865,map__57865__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_58019){
var state_val_58020 = (state_58019[(1)]);
if((state_val_58020 === (7))){
var inst_57881 = (state_58019[(7)]);
var inst_57880 = (state_58019[(8)]);
var inst_57879 = (state_58019[(9)]);
var inst_57882 = (state_58019[(10)]);
var inst_57887 = cljs.core._nth.call(null,inst_57880,inst_57882);
var inst_57888 = figwheel.client.file_reloading.eval_body.call(null,inst_57887,opts);
var inst_57889 = (inst_57882 + (1));
var tmp58021 = inst_57881;
var tmp58022 = inst_57880;
var tmp58023 = inst_57879;
var inst_57879__$1 = tmp58023;
var inst_57880__$1 = tmp58022;
var inst_57881__$1 = tmp58021;
var inst_57882__$1 = inst_57889;
var state_58019__$1 = (function (){var statearr_58024 = state_58019;
(statearr_58024[(7)] = inst_57881__$1);

(statearr_58024[(8)] = inst_57880__$1);

(statearr_58024[(9)] = inst_57879__$1);

(statearr_58024[(10)] = inst_57882__$1);

(statearr_58024[(11)] = inst_57888);

return statearr_58024;
})();
var statearr_58025_58108 = state_58019__$1;
(statearr_58025_58108[(2)] = null);

(statearr_58025_58108[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (20))){
var inst_57922 = (state_58019[(12)]);
var inst_57930 = figwheel.client.file_reloading.sort_files.call(null,inst_57922);
var state_58019__$1 = state_58019;
var statearr_58026_58109 = state_58019__$1;
(statearr_58026_58109[(2)] = inst_57930);

(statearr_58026_58109[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (27))){
var state_58019__$1 = state_58019;
var statearr_58027_58110 = state_58019__$1;
(statearr_58027_58110[(2)] = null);

(statearr_58027_58110[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (1))){
var inst_57871 = (state_58019[(13)]);
var inst_57868 = before_jsload.call(null,files);
var inst_57869 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_57870 = (function (){return ((function (inst_57871,inst_57868,inst_57869,state_val_58020,c__50041__auto__,map__57864,map__57864__$1,opts,before_jsload,on_jsload,reload_dependents,map__57865,map__57865__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__57859_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__57859_SHARP_);
});
;})(inst_57871,inst_57868,inst_57869,state_val_58020,c__50041__auto__,map__57864,map__57864__$1,opts,before_jsload,on_jsload,reload_dependents,map__57865,map__57865__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_57871__$1 = cljs.core.filter.call(null,inst_57870,files);
var inst_57872 = cljs.core.not_empty.call(null,inst_57871__$1);
var state_58019__$1 = (function (){var statearr_58028 = state_58019;
(statearr_58028[(13)] = inst_57871__$1);

(statearr_58028[(14)] = inst_57869);

(statearr_58028[(15)] = inst_57868);

return statearr_58028;
})();
if(cljs.core.truth_(inst_57872)){
var statearr_58029_58111 = state_58019__$1;
(statearr_58029_58111[(1)] = (2));

} else {
var statearr_58030_58112 = state_58019__$1;
(statearr_58030_58112[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (24))){
var state_58019__$1 = state_58019;
var statearr_58031_58113 = state_58019__$1;
(statearr_58031_58113[(2)] = null);

(statearr_58031_58113[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (39))){
var inst_57972 = (state_58019[(16)]);
var state_58019__$1 = state_58019;
var statearr_58032_58114 = state_58019__$1;
(statearr_58032_58114[(2)] = inst_57972);

(statearr_58032_58114[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (46))){
var inst_58014 = (state_58019[(2)]);
var state_58019__$1 = state_58019;
var statearr_58033_58115 = state_58019__$1;
(statearr_58033_58115[(2)] = inst_58014);

(statearr_58033_58115[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (4))){
var inst_57916 = (state_58019[(2)]);
var inst_57917 = cljs.core.List.EMPTY;
var inst_57918 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_57917);
var inst_57919 = (function (){return ((function (inst_57916,inst_57917,inst_57918,state_val_58020,c__50041__auto__,map__57864,map__57864__$1,opts,before_jsload,on_jsload,reload_dependents,map__57865,map__57865__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__57860_SHARP_){
var and__47063__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__57860_SHARP_);
if(cljs.core.truth_(and__47063__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__57860_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__57860_SHARP_)));
} else {
return and__47063__auto__;
}
});
;})(inst_57916,inst_57917,inst_57918,state_val_58020,c__50041__auto__,map__57864,map__57864__$1,opts,before_jsload,on_jsload,reload_dependents,map__57865,map__57865__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_57920 = cljs.core.filter.call(null,inst_57919,files);
var inst_57921 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_57922 = cljs.core.concat.call(null,inst_57920,inst_57921);
var state_58019__$1 = (function (){var statearr_58034 = state_58019;
(statearr_58034[(12)] = inst_57922);

(statearr_58034[(17)] = inst_57916);

(statearr_58034[(18)] = inst_57918);

return statearr_58034;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_58035_58116 = state_58019__$1;
(statearr_58035_58116[(1)] = (16));

} else {
var statearr_58036_58117 = state_58019__$1;
(statearr_58036_58117[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (15))){
var inst_57906 = (state_58019[(2)]);
var state_58019__$1 = state_58019;
var statearr_58037_58118 = state_58019__$1;
(statearr_58037_58118[(2)] = inst_57906);

(statearr_58037_58118[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (21))){
var inst_57932 = (state_58019[(19)]);
var inst_57932__$1 = (state_58019[(2)]);
var inst_57933 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_57932__$1);
var state_58019__$1 = (function (){var statearr_58038 = state_58019;
(statearr_58038[(19)] = inst_57932__$1);

return statearr_58038;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58019__$1,(22),inst_57933);
} else {
if((state_val_58020 === (31))){
var inst_58017 = (state_58019[(2)]);
var state_58019__$1 = state_58019;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58019__$1,inst_58017);
} else {
if((state_val_58020 === (32))){
var inst_57972 = (state_58019[(16)]);
var inst_57977 = inst_57972.cljs$lang$protocol_mask$partition0$;
var inst_57978 = (inst_57977 & (64));
var inst_57979 = inst_57972.cljs$core$ISeq$;
var inst_57980 = (cljs.core.PROTOCOL_SENTINEL === inst_57979);
var inst_57981 = (inst_57978) || (inst_57980);
var state_58019__$1 = state_58019;
if(cljs.core.truth_(inst_57981)){
var statearr_58039_58119 = state_58019__$1;
(statearr_58039_58119[(1)] = (35));

} else {
var statearr_58040_58120 = state_58019__$1;
(statearr_58040_58120[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (40))){
var inst_57994 = (state_58019[(20)]);
var inst_57993 = (state_58019[(2)]);
var inst_57994__$1 = cljs.core.get.call(null,inst_57993,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_57995 = cljs.core.get.call(null,inst_57993,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_57996 = cljs.core.not_empty.call(null,inst_57994__$1);
var state_58019__$1 = (function (){var statearr_58041 = state_58019;
(statearr_58041[(20)] = inst_57994__$1);

(statearr_58041[(21)] = inst_57995);

return statearr_58041;
})();
if(cljs.core.truth_(inst_57996)){
var statearr_58042_58121 = state_58019__$1;
(statearr_58042_58121[(1)] = (41));

} else {
var statearr_58043_58122 = state_58019__$1;
(statearr_58043_58122[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (33))){
var state_58019__$1 = state_58019;
var statearr_58044_58123 = state_58019__$1;
(statearr_58044_58123[(2)] = false);

(statearr_58044_58123[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (13))){
var inst_57892 = (state_58019[(22)]);
var inst_57896 = cljs.core.chunk_first.call(null,inst_57892);
var inst_57897 = cljs.core.chunk_rest.call(null,inst_57892);
var inst_57898 = cljs.core.count.call(null,inst_57896);
var inst_57879 = inst_57897;
var inst_57880 = inst_57896;
var inst_57881 = inst_57898;
var inst_57882 = (0);
var state_58019__$1 = (function (){var statearr_58045 = state_58019;
(statearr_58045[(7)] = inst_57881);

(statearr_58045[(8)] = inst_57880);

(statearr_58045[(9)] = inst_57879);

(statearr_58045[(10)] = inst_57882);

return statearr_58045;
})();
var statearr_58046_58124 = state_58019__$1;
(statearr_58046_58124[(2)] = null);

(statearr_58046_58124[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (22))){
var inst_57935 = (state_58019[(23)]);
var inst_57932 = (state_58019[(19)]);
var inst_57940 = (state_58019[(24)]);
var inst_57936 = (state_58019[(25)]);
var inst_57935__$1 = (state_58019[(2)]);
var inst_57936__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_57935__$1);
var inst_57937 = (function (){var all_files = inst_57932;
var res_SINGLEQUOTE_ = inst_57935__$1;
var res = inst_57936__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_57935,inst_57932,inst_57940,inst_57936,inst_57935__$1,inst_57936__$1,state_val_58020,c__50041__auto__,map__57864,map__57864__$1,opts,before_jsload,on_jsload,reload_dependents,map__57865,map__57865__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__57861_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__57861_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_57935,inst_57932,inst_57940,inst_57936,inst_57935__$1,inst_57936__$1,state_val_58020,c__50041__auto__,map__57864,map__57864__$1,opts,before_jsload,on_jsload,reload_dependents,map__57865,map__57865__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_57938 = cljs.core.filter.call(null,inst_57937,inst_57935__$1);
var inst_57939 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_57940__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_57939);
var inst_57941 = cljs.core.not_empty.call(null,inst_57940__$1);
var state_58019__$1 = (function (){var statearr_58047 = state_58019;
(statearr_58047[(23)] = inst_57935__$1);

(statearr_58047[(24)] = inst_57940__$1);

(statearr_58047[(25)] = inst_57936__$1);

(statearr_58047[(26)] = inst_57938);

return statearr_58047;
})();
if(cljs.core.truth_(inst_57941)){
var statearr_58048_58125 = state_58019__$1;
(statearr_58048_58125[(1)] = (23));

} else {
var statearr_58049_58126 = state_58019__$1;
(statearr_58049_58126[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (36))){
var state_58019__$1 = state_58019;
var statearr_58050_58127 = state_58019__$1;
(statearr_58050_58127[(2)] = false);

(statearr_58050_58127[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (41))){
var inst_57994 = (state_58019[(20)]);
var inst_57998 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_57999 = cljs.core.map.call(null,inst_57998,inst_57994);
var inst_58000 = cljs.core.pr_str.call(null,inst_57999);
var inst_58001 = ["figwheel-no-load meta-data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_58000)].join('');
var inst_58002 = figwheel.client.utils.log.call(null,inst_58001);
var state_58019__$1 = state_58019;
var statearr_58051_58128 = state_58019__$1;
(statearr_58051_58128[(2)] = inst_58002);

(statearr_58051_58128[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (43))){
var inst_57995 = (state_58019[(21)]);
var inst_58005 = (state_58019[(2)]);
var inst_58006 = cljs.core.not_empty.call(null,inst_57995);
var state_58019__$1 = (function (){var statearr_58052 = state_58019;
(statearr_58052[(27)] = inst_58005);

return statearr_58052;
})();
if(cljs.core.truth_(inst_58006)){
var statearr_58053_58129 = state_58019__$1;
(statearr_58053_58129[(1)] = (44));

} else {
var statearr_58054_58130 = state_58019__$1;
(statearr_58054_58130[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (29))){
var inst_57972 = (state_58019[(16)]);
var inst_57935 = (state_58019[(23)]);
var inst_57932 = (state_58019[(19)]);
var inst_57940 = (state_58019[(24)]);
var inst_57936 = (state_58019[(25)]);
var inst_57938 = (state_58019[(26)]);
var inst_57968 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_57971 = (function (){var all_files = inst_57932;
var res_SINGLEQUOTE_ = inst_57935;
var res = inst_57936;
var files_not_loaded = inst_57938;
var dependencies_that_loaded = inst_57940;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_57972,inst_57935,inst_57932,inst_57940,inst_57936,inst_57938,inst_57968,state_val_58020,c__50041__auto__,map__57864,map__57864__$1,opts,before_jsload,on_jsload,reload_dependents,map__57865,map__57865__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__57970){
var map__58055 = p__57970;
var map__58055__$1 = ((((!((map__58055 == null)))?((((map__58055.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58055.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58055):map__58055);
var namespace = cljs.core.get.call(null,map__58055__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_57972,inst_57935,inst_57932,inst_57940,inst_57936,inst_57938,inst_57968,state_val_58020,c__50041__auto__,map__57864,map__57864__$1,opts,before_jsload,on_jsload,reload_dependents,map__57865,map__57865__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_57972__$1 = cljs.core.group_by.call(null,inst_57971,inst_57938);
var inst_57974 = (inst_57972__$1 == null);
var inst_57975 = cljs.core.not.call(null,inst_57974);
var state_58019__$1 = (function (){var statearr_58057 = state_58019;
(statearr_58057[(16)] = inst_57972__$1);

(statearr_58057[(28)] = inst_57968);

return statearr_58057;
})();
if(inst_57975){
var statearr_58058_58131 = state_58019__$1;
(statearr_58058_58131[(1)] = (32));

} else {
var statearr_58059_58132 = state_58019__$1;
(statearr_58059_58132[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (44))){
var inst_57995 = (state_58019[(21)]);
var inst_58008 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_57995);
var inst_58009 = cljs.core.pr_str.call(null,inst_58008);
var inst_58010 = ["not required: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_58009)].join('');
var inst_58011 = figwheel.client.utils.log.call(null,inst_58010);
var state_58019__$1 = state_58019;
var statearr_58060_58133 = state_58019__$1;
(statearr_58060_58133[(2)] = inst_58011);

(statearr_58060_58133[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (6))){
var inst_57913 = (state_58019[(2)]);
var state_58019__$1 = state_58019;
var statearr_58061_58134 = state_58019__$1;
(statearr_58061_58134[(2)] = inst_57913);

(statearr_58061_58134[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (28))){
var inst_57938 = (state_58019[(26)]);
var inst_57965 = (state_58019[(2)]);
var inst_57966 = cljs.core.not_empty.call(null,inst_57938);
var state_58019__$1 = (function (){var statearr_58062 = state_58019;
(statearr_58062[(29)] = inst_57965);

return statearr_58062;
})();
if(cljs.core.truth_(inst_57966)){
var statearr_58063_58135 = state_58019__$1;
(statearr_58063_58135[(1)] = (29));

} else {
var statearr_58064_58136 = state_58019__$1;
(statearr_58064_58136[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (25))){
var inst_57936 = (state_58019[(25)]);
var inst_57952 = (state_58019[(2)]);
var inst_57953 = cljs.core.not_empty.call(null,inst_57936);
var state_58019__$1 = (function (){var statearr_58065 = state_58019;
(statearr_58065[(30)] = inst_57952);

return statearr_58065;
})();
if(cljs.core.truth_(inst_57953)){
var statearr_58066_58137 = state_58019__$1;
(statearr_58066_58137[(1)] = (26));

} else {
var statearr_58067_58138 = state_58019__$1;
(statearr_58067_58138[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (34))){
var inst_57988 = (state_58019[(2)]);
var state_58019__$1 = state_58019;
if(cljs.core.truth_(inst_57988)){
var statearr_58068_58139 = state_58019__$1;
(statearr_58068_58139[(1)] = (38));

} else {
var statearr_58069_58140 = state_58019__$1;
(statearr_58069_58140[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (17))){
var state_58019__$1 = state_58019;
var statearr_58070_58141 = state_58019__$1;
(statearr_58070_58141[(2)] = recompile_dependents);

(statearr_58070_58141[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (3))){
var state_58019__$1 = state_58019;
var statearr_58071_58142 = state_58019__$1;
(statearr_58071_58142[(2)] = null);

(statearr_58071_58142[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (12))){
var inst_57909 = (state_58019[(2)]);
var state_58019__$1 = state_58019;
var statearr_58072_58143 = state_58019__$1;
(statearr_58072_58143[(2)] = inst_57909);

(statearr_58072_58143[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (2))){
var inst_57871 = (state_58019[(13)]);
var inst_57878 = cljs.core.seq.call(null,inst_57871);
var inst_57879 = inst_57878;
var inst_57880 = null;
var inst_57881 = (0);
var inst_57882 = (0);
var state_58019__$1 = (function (){var statearr_58073 = state_58019;
(statearr_58073[(7)] = inst_57881);

(statearr_58073[(8)] = inst_57880);

(statearr_58073[(9)] = inst_57879);

(statearr_58073[(10)] = inst_57882);

return statearr_58073;
})();
var statearr_58074_58144 = state_58019__$1;
(statearr_58074_58144[(2)] = null);

(statearr_58074_58144[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (23))){
var inst_57935 = (state_58019[(23)]);
var inst_57932 = (state_58019[(19)]);
var inst_57940 = (state_58019[(24)]);
var inst_57936 = (state_58019[(25)]);
var inst_57938 = (state_58019[(26)]);
var inst_57943 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_57945 = (function (){var all_files = inst_57932;
var res_SINGLEQUOTE_ = inst_57935;
var res = inst_57936;
var files_not_loaded = inst_57938;
var dependencies_that_loaded = inst_57940;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_57935,inst_57932,inst_57940,inst_57936,inst_57938,inst_57943,state_val_58020,c__50041__auto__,map__57864,map__57864__$1,opts,before_jsload,on_jsload,reload_dependents,map__57865,map__57865__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__57944){
var map__58075 = p__57944;
var map__58075__$1 = ((((!((map__58075 == null)))?((((map__58075.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58075.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58075):map__58075);
var request_url = cljs.core.get.call(null,map__58075__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_57935,inst_57932,inst_57940,inst_57936,inst_57938,inst_57943,state_val_58020,c__50041__auto__,map__57864,map__57864__$1,opts,before_jsload,on_jsload,reload_dependents,map__57865,map__57865__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_57946 = cljs.core.reverse.call(null,inst_57940);
var inst_57947 = cljs.core.map.call(null,inst_57945,inst_57946);
var inst_57948 = cljs.core.pr_str.call(null,inst_57947);
var inst_57949 = figwheel.client.utils.log.call(null,inst_57948);
var state_58019__$1 = (function (){var statearr_58077 = state_58019;
(statearr_58077[(31)] = inst_57943);

return statearr_58077;
})();
var statearr_58078_58145 = state_58019__$1;
(statearr_58078_58145[(2)] = inst_57949);

(statearr_58078_58145[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (35))){
var state_58019__$1 = state_58019;
var statearr_58079_58146 = state_58019__$1;
(statearr_58079_58146[(2)] = true);

(statearr_58079_58146[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (19))){
var inst_57922 = (state_58019[(12)]);
var inst_57928 = figwheel.client.file_reloading.expand_files.call(null,inst_57922);
var state_58019__$1 = state_58019;
var statearr_58080_58147 = state_58019__$1;
(statearr_58080_58147[(2)] = inst_57928);

(statearr_58080_58147[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (11))){
var state_58019__$1 = state_58019;
var statearr_58081_58148 = state_58019__$1;
(statearr_58081_58148[(2)] = null);

(statearr_58081_58148[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (9))){
var inst_57911 = (state_58019[(2)]);
var state_58019__$1 = state_58019;
var statearr_58082_58149 = state_58019__$1;
(statearr_58082_58149[(2)] = inst_57911);

(statearr_58082_58149[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (5))){
var inst_57881 = (state_58019[(7)]);
var inst_57882 = (state_58019[(10)]);
var inst_57884 = (inst_57882 < inst_57881);
var inst_57885 = inst_57884;
var state_58019__$1 = state_58019;
if(cljs.core.truth_(inst_57885)){
var statearr_58083_58150 = state_58019__$1;
(statearr_58083_58150[(1)] = (7));

} else {
var statearr_58084_58151 = state_58019__$1;
(statearr_58084_58151[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (14))){
var inst_57892 = (state_58019[(22)]);
var inst_57901 = cljs.core.first.call(null,inst_57892);
var inst_57902 = figwheel.client.file_reloading.eval_body.call(null,inst_57901,opts);
var inst_57903 = cljs.core.next.call(null,inst_57892);
var inst_57879 = inst_57903;
var inst_57880 = null;
var inst_57881 = (0);
var inst_57882 = (0);
var state_58019__$1 = (function (){var statearr_58085 = state_58019;
(statearr_58085[(32)] = inst_57902);

(statearr_58085[(7)] = inst_57881);

(statearr_58085[(8)] = inst_57880);

(statearr_58085[(9)] = inst_57879);

(statearr_58085[(10)] = inst_57882);

return statearr_58085;
})();
var statearr_58086_58152 = state_58019__$1;
(statearr_58086_58152[(2)] = null);

(statearr_58086_58152[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (45))){
var state_58019__$1 = state_58019;
var statearr_58087_58153 = state_58019__$1;
(statearr_58087_58153[(2)] = null);

(statearr_58087_58153[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (26))){
var inst_57935 = (state_58019[(23)]);
var inst_57932 = (state_58019[(19)]);
var inst_57940 = (state_58019[(24)]);
var inst_57936 = (state_58019[(25)]);
var inst_57938 = (state_58019[(26)]);
var inst_57955 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_57957 = (function (){var all_files = inst_57932;
var res_SINGLEQUOTE_ = inst_57935;
var res = inst_57936;
var files_not_loaded = inst_57938;
var dependencies_that_loaded = inst_57940;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_57935,inst_57932,inst_57940,inst_57936,inst_57938,inst_57955,state_val_58020,c__50041__auto__,map__57864,map__57864__$1,opts,before_jsload,on_jsload,reload_dependents,map__57865,map__57865__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__57956){
var map__58088 = p__57956;
var map__58088__$1 = ((((!((map__58088 == null)))?((((map__58088.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58088.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58088):map__58088);
var namespace = cljs.core.get.call(null,map__58088__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__58088__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_57935,inst_57932,inst_57940,inst_57936,inst_57938,inst_57955,state_val_58020,c__50041__auto__,map__57864,map__57864__$1,opts,before_jsload,on_jsload,reload_dependents,map__57865,map__57865__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_57958 = cljs.core.map.call(null,inst_57957,inst_57936);
var inst_57959 = cljs.core.pr_str.call(null,inst_57958);
var inst_57960 = figwheel.client.utils.log.call(null,inst_57959);
var inst_57961 = (function (){var all_files = inst_57932;
var res_SINGLEQUOTE_ = inst_57935;
var res = inst_57936;
var files_not_loaded = inst_57938;
var dependencies_that_loaded = inst_57940;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_57935,inst_57932,inst_57940,inst_57936,inst_57938,inst_57955,inst_57957,inst_57958,inst_57959,inst_57960,state_val_58020,c__50041__auto__,map__57864,map__57864__$1,opts,before_jsload,on_jsload,reload_dependents,map__57865,map__57865__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_57935,inst_57932,inst_57940,inst_57936,inst_57938,inst_57955,inst_57957,inst_57958,inst_57959,inst_57960,state_val_58020,c__50041__auto__,map__57864,map__57864__$1,opts,before_jsload,on_jsload,reload_dependents,map__57865,map__57865__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_57962 = setTimeout(inst_57961,(10));
var state_58019__$1 = (function (){var statearr_58090 = state_58019;
(statearr_58090[(33)] = inst_57960);

(statearr_58090[(34)] = inst_57955);

return statearr_58090;
})();
var statearr_58091_58154 = state_58019__$1;
(statearr_58091_58154[(2)] = inst_57962);

(statearr_58091_58154[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (16))){
var state_58019__$1 = state_58019;
var statearr_58092_58155 = state_58019__$1;
(statearr_58092_58155[(2)] = reload_dependents);

(statearr_58092_58155[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (38))){
var inst_57972 = (state_58019[(16)]);
var inst_57990 = cljs.core.apply.call(null,cljs.core.hash_map,inst_57972);
var state_58019__$1 = state_58019;
var statearr_58093_58156 = state_58019__$1;
(statearr_58093_58156[(2)] = inst_57990);

(statearr_58093_58156[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (30))){
var state_58019__$1 = state_58019;
var statearr_58094_58157 = state_58019__$1;
(statearr_58094_58157[(2)] = null);

(statearr_58094_58157[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (10))){
var inst_57892 = (state_58019[(22)]);
var inst_57894 = cljs.core.chunked_seq_QMARK_.call(null,inst_57892);
var state_58019__$1 = state_58019;
if(inst_57894){
var statearr_58095_58158 = state_58019__$1;
(statearr_58095_58158[(1)] = (13));

} else {
var statearr_58096_58159 = state_58019__$1;
(statearr_58096_58159[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (18))){
var inst_57926 = (state_58019[(2)]);
var state_58019__$1 = state_58019;
if(cljs.core.truth_(inst_57926)){
var statearr_58097_58160 = state_58019__$1;
(statearr_58097_58160[(1)] = (19));

} else {
var statearr_58098_58161 = state_58019__$1;
(statearr_58098_58161[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (42))){
var state_58019__$1 = state_58019;
var statearr_58099_58162 = state_58019__$1;
(statearr_58099_58162[(2)] = null);

(statearr_58099_58162[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (37))){
var inst_57985 = (state_58019[(2)]);
var state_58019__$1 = state_58019;
var statearr_58100_58163 = state_58019__$1;
(statearr_58100_58163[(2)] = inst_57985);

(statearr_58100_58163[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58020 === (8))){
var inst_57892 = (state_58019[(22)]);
var inst_57879 = (state_58019[(9)]);
var inst_57892__$1 = cljs.core.seq.call(null,inst_57879);
var state_58019__$1 = (function (){var statearr_58101 = state_58019;
(statearr_58101[(22)] = inst_57892__$1);

return statearr_58101;
})();
if(inst_57892__$1){
var statearr_58102_58164 = state_58019__$1;
(statearr_58102_58164[(1)] = (10));

} else {
var statearr_58103_58165 = state_58019__$1;
(statearr_58103_58165[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__50041__auto__,map__57864,map__57864__$1,opts,before_jsload,on_jsload,reload_dependents,map__57865,map__57865__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__50018__auto__,c__50041__auto__,map__57864,map__57864__$1,opts,before_jsload,on_jsload,reload_dependents,map__57865,map__57865__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__50019__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__50019__auto____0 = (function (){
var statearr_58104 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58104[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__50019__auto__);

(statearr_58104[(1)] = (1));

return statearr_58104;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__50019__auto____1 = (function (state_58019){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_58019);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e58105){if((e58105 instanceof Object)){
var ex__50022__auto__ = e58105;
var statearr_58106_58166 = state_58019;
(statearr_58106_58166[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58019);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58105;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58167 = state_58019;
state_58019 = G__58167;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__50019__auto__ = function(state_58019){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__50019__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__50019__auto____1.call(this,state_58019);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__50019__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__50019__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto__,map__57864,map__57864__$1,opts,before_jsload,on_jsload,reload_dependents,map__57865,map__57865__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__50043__auto__ = (function (){var statearr_58107 = f__50042__auto__.call(null);
(statearr_58107[(6)] = c__50041__auto__);

return statearr_58107;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto__,map__57864,map__57864__$1,opts,before_jsload,on_jsload,reload_dependents,map__57865,map__57865__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__50041__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__58170,link){
var map__58171 = p__58170;
var map__58171__$1 = ((((!((map__58171 == null)))?((((map__58171.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58171.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58171):map__58171);
var file = cljs.core.get.call(null,map__58171__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__5459__auto__ = link.href;
if(cljs.core.truth_(temp__5459__auto__)){
var link_href = temp__5459__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__5459__auto__,map__58171,map__58171__$1,file){
return (function (p1__58168_SHARP_,p2__58169_SHARP_){
if(cljs.core._EQ_.call(null,p1__58168_SHARP_,p2__58169_SHARP_)){
return p1__58168_SHARP_;
} else {
return false;
}
});})(link_href,temp__5459__auto__,map__58171,map__58171__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__5459__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__58174){
var map__58175 = p__58174;
var map__58175__$1 = ((((!((map__58175 == null)))?((((map__58175.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58175.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58175):map__58175);
var match_length = cljs.core.get.call(null,map__58175__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__58175__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__58173_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__58173_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__5459__auto__)){
var res = temp__5459__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__58177_SHARP_,p2__58178_SHARP_){
return cljs.core.assoc.call(null,p1__58177_SHARP_,cljs.core.get.call(null,p2__58178_SHARP_,key),p2__58178_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__5457__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__5457__auto__)){
var link = temp__5457__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__5457__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__5457__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_58179 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_58179);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_58179);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__58180,p__58181){
var map__58182 = p__58180;
var map__58182__$1 = ((((!((map__58182 == null)))?((((map__58182.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58182.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58182):map__58182);
var on_cssload = cljs.core.get.call(null,map__58182__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__58183 = p__58181;
var map__58183__$1 = ((((!((map__58183 == null)))?((((map__58183.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58183.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58183):map__58183);
var files_msg = map__58183__$1;
var files = cljs.core.get.call(null,map__58183__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__5459__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__5459__auto__)){
var f_datas = temp__5459__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1509203651227
