// Compiled by ClojureScript 1.9.946 {}
goog.provide('lemonade.core');
goog.require('cljs.core');
goog.require('cljs.pprint');
goog.require('lemonade.geometry');
if(typeof lemonade.core.template_expand !== 'undefined'){
} else {
lemonade.core.template_expand = (function (){var method_table__48130__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__48131__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__48132__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__48133__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__48134__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"lemonade.core","template-expand"),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__48134__auto__,method_table__48130__auto__,prefer_table__48131__auto__,method_cache__48132__auto__,cached_hierarchy__48133__auto__));
})();
}
lemonade.core.line = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("lemonade.core","line","lemonade.core/line",-1874428367),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),new cljs.core.Keyword(null,"to","to",192099007),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(1)], null)], null);
/**
 * Bezier cubic to be precise.
 */
lemonade.core.bezier = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("lemonade.core","bezier","lemonade.core/bezier",-2092021081),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),new cljs.core.Keyword(null,"c1","c1",1132530803),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),new cljs.core.Keyword(null,"c2","c2",-1561880371),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(1)], null),new cljs.core.Keyword(null,"to","to",192099007),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(1)], null)], null);
lemonade.core.path = (function lemonade$core$path(var_args){
var G__55622 = arguments.length;
switch (G__55622) {
case 1:
return lemonade.core.path.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return lemonade.core.path.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

lemonade.core.path.cljs$core$IFn$_invoke$arity$1 = (function (segments){
return lemonade.core.path.call(null,cljs.core.PersistentArrayMap.EMPTY,segments);
});

lemonade.core.path.cljs$core$IFn$_invoke$arity$2 = (function (style,segments){
var closed_QMARK_ = (function (){var or__47075__auto__ = new cljs.core.Keyword(null,"closed","closed",-919675359).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,segments));
if(cljs.core.truth_(or__47075__auto__)){
return or__47075__auto__;
} else {
return lemonade.geometry.closed_QMARK_.call(null,segments);
}
})();
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("lemonade.core","path","lemonade.core/path",-2005021990),new cljs.core.Keyword(null,"closed?","closed?",-1408769040),closed_QMARK_,new cljs.core.Keyword(null,"style","style",-496642736),style,new cljs.core.Keyword(null,"contents","contents",-1567174023),segments], null);
});

lemonade.core.path.cljs$lang$maxFixedArity = 2;

lemonade.core.conj_path = (function lemonade$core$conj_path(p__55671,segment){
var map__55672 = p__55671;
var map__55672__$1 = ((((!((map__55672 == null)))?((((map__55672.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55672.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55672):map__55672);
var style = cljs.core.get.call(null,map__55672__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var contents = cljs.core.get.call(null,map__55672__$1,new cljs.core.Keyword(null,"contents","contents",-1567174023));
return lemonade.core.path.call(null,style,cljs.core.conj.call(null,contents,segment));
});
lemonade.core.composite = (function lemonade$core$composite(var_args){
var G__55694 = arguments.length;
switch (G__55694) {
case 1:
return lemonade.core.composite.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return lemonade.core.composite.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

lemonade.core.composite.cljs$core$IFn$_invoke$arity$1 = (function (shapes){
return lemonade.core.composite.call(null,cljs.core.PersistentArrayMap.EMPTY,shapes);
});

lemonade.core.composite.cljs$core$IFn$_invoke$arity$2 = (function (style,shapes){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("lemonade.core","composite","lemonade.core/composite",-1929458844),new cljs.core.Keyword(null,"style","style",-496642736),style,new cljs.core.Keyword(null,"contents","contents",-1567174023),shapes], null);
});

lemonade.core.composite.cljs$lang$maxFixedArity = 2;

lemonade.core.with_style = (function lemonade$core$with_style(var_args){
var args__48361__auto__ = [];
var len__48354__auto___55717 = arguments.length;
var i__48355__auto___55719 = (0);
while(true){
if((i__48355__auto___55719 < len__48354__auto___55717)){
args__48361__auto__.push((arguments[i__48355__auto___55719]));

var G__55720 = (i__48355__auto___55719 + (1));
i__48355__auto___55719 = G__55720;
continue;
} else {
}
break;
}

var argseq__48362__auto__ = ((((1) < args__48361__auto__.length))?(new cljs.core.IndexedSeq(args__48361__auto__.slice((1)),(0),null)):null);
return lemonade.core.with_style.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__48362__auto__);
});

lemonade.core.with_style.cljs$core$IFn$_invoke$arity$variadic = (function (style,shapes){
return lemonade.core.composite.call(null,style,shapes);
});

lemonade.core.with_style.cljs$lang$maxFixedArity = (1);

lemonade.core.with_style.cljs$lang$applyTo = (function (seq55712){
var G__55713 = cljs.core.first.call(null,seq55712);
var seq55712__$1 = cljs.core.next.call(null,seq55712);
return lemonade.core.with_style.cljs$core$IFn$_invoke$arity$variadic(G__55713,seq55712__$1);
});

lemonade.core.radians = (function lemonade$core$radians(r){
return ((r * (180)) / lemonade.geometry.pi);
});
lemonade.core.full_arc = (function lemonade$core$full_arc(c,r){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("lemonade.core","arc","lemonade.core/arc",1918704395),new cljs.core.Keyword(null,"centre","centre",-948091970),c,new cljs.core.Keyword(null,"radius","radius",-2073122258),r,new cljs.core.Keyword(null,"from","from",1815293044),(0),new cljs.core.Keyword(null,"to","to",192099007),((2) * lemonade.geometry.pi)], null);
});
lemonade.core.circle = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"radius","radius",-2073122258),(1),new cljs.core.Keyword(null,"centre","centre",-948091970),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("lemonade.core","circle","lemonade.core/circle",1439094760)], null);

cljs.core._add_method.call(null,lemonade.core.template_expand,new cljs.core.Keyword("lemonade.core","circle","lemonade.core/circle",1439094760),(function (p__55735){
var map__55736 = p__55735;
var map__55736__$1 = ((((!((map__55736 == null)))?((((map__55736.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55736.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55736):map__55736);
var in__55385__auto__ = map__55736__$1;
var centre = cljs.core.get.call(null,map__55736__$1,new cljs.core.Keyword(null,"centre","centre",-948091970));
var radius = cljs.core.get.call(null,map__55736__$1,new cljs.core.Keyword(null,"radius","radius",-2073122258));
var style = cljs.core.get.call(null,map__55736__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var style__$1 = (function (){var or__47075__auto__ = style;
if(cljs.core.truth_(or__47075__auto__)){
return or__47075__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return lemonade.core.path.call(null,style__$1,cljs.core.with_meta(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [lemonade.core.full_arc.call(null,centre,radius)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"closed","closed",-919675359),true], null)));
}));
lemonade.core.annulus = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"inner-radius","inner-radius",-681823510),(1),new cljs.core.Keyword(null,"outer-radius","outer-radius",1715267468),(2),new cljs.core.Keyword(null,"centre","centre",-948091970),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("lemonade.core","annulus","lemonade.core/annulus",851212095)], null);

cljs.core._add_method.call(null,lemonade.core.template_expand,new cljs.core.Keyword("lemonade.core","annulus","lemonade.core/annulus",851212095),(function (p__55754){
var map__55755 = p__55754;
var map__55755__$1 = ((((!((map__55755 == null)))?((((map__55755.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55755.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55755):map__55755);
var in__55385__auto__ = map__55755__$1;
var centre = cljs.core.get.call(null,map__55755__$1,new cljs.core.Keyword(null,"centre","centre",-948091970));
var inner_radius = cljs.core.get.call(null,map__55755__$1,new cljs.core.Keyword(null,"inner-radius","inner-radius",-681823510));
var outer_radius = cljs.core.get.call(null,map__55755__$1,new cljs.core.Keyword(null,"outer-radius","outer-radius",1715267468));
var style = cljs.core.get.call(null,map__55755__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var style__$1 = (function (){var or__47075__auto__ = style;
if(cljs.core.truth_(or__47075__auto__)){
return or__47075__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return lemonade.core.composite.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lemonade.core.path.call(null,style__$1,cljs.core.with_meta(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [lemonade.core.full_arc.call(null,centre,outer_radius)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"closed","closed",-919675359),true], null))),lemonade.core.path.call(null,(function (){var G__55760 = style__$1;
if(cljs.core.contains_QMARK_.call(null,style__$1,new cljs.core.Keyword(null,"fill","fill",883462889))){
return cljs.core.assoc.call(null,G__55760,new cljs.core.Keyword(null,"negative","negative",-1562068438),true);
} else {
return G__55760;
}
})(),cljs.core.with_meta(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [lemonade.core.full_arc.call(null,centre,inner_radius)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"closed","closed",-919675359),true], null)))], null));
}));
lemonade.core.polyline = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"points","points",-1486596883),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("lemonade.core","polyline","lemonade.core/polyline",878509078)], null);

cljs.core._add_method.call(null,lemonade.core.template_expand,new cljs.core.Keyword("lemonade.core","polyline","lemonade.core/polyline",878509078),(function (p__55777){
var map__55778 = p__55777;
var map__55778__$1 = ((((!((map__55778 == null)))?((((map__55778.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55778.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55778):map__55778);
var in__55385__auto__ = map__55778__$1;
var points = cljs.core.get.call(null,map__55778__$1,new cljs.core.Keyword(null,"points","points",-1486596883));
var style = cljs.core.get.call(null,map__55778__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var style__$1 = (function (){var or__47075__auto__ = style;
if(cljs.core.truth_(or__47075__auto__)){
return or__47075__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return lemonade.core.path.call(null,style__$1,cljs.core.mapv.call(null,((function (style__$1,map__55778,map__55778__$1,in__55385__auto__,points,style){
return (function (p__55783){
var vec__55785 = p__55783;
var x = cljs.core.nth.call(null,vec__55785,(0),null);
var y = cljs.core.nth.call(null,vec__55785,(1),null);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("lemonade.core","line","lemonade.core/line",-1874428367),new cljs.core.Keyword(null,"from","from",1815293044),x,new cljs.core.Keyword(null,"to","to",192099007),y], null);
});})(style__$1,map__55778,map__55778__$1,in__55385__auto__,points,style))
,cljs.core.partition.call(null,(2),cljs.core.interleave.call(null,points,cljs.core.rest.call(null,points)))));
}));
lemonade.core.rectangle = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"corner","corner",1296717125),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),new cljs.core.Keyword(null,"height","height",1025178622),(1),new cljs.core.Keyword(null,"width","width",-384071477),(1),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("lemonade.core","rectangle","lemonade.core/rectangle",1833640800)], null);

cljs.core._add_method.call(null,lemonade.core.template_expand,new cljs.core.Keyword("lemonade.core","rectangle","lemonade.core/rectangle",1833640800),(function (p__55810){
var map__55811 = p__55810;
var map__55811__$1 = ((((!((map__55811 == null)))?((((map__55811.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55811.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55811):map__55811);
var in__55385__auto__ = map__55811__$1;
var height = cljs.core.get.call(null,map__55811__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var corner = cljs.core.get.call(null,map__55811__$1,new cljs.core.Keyword(null,"corner","corner",1296717125));
var width = cljs.core.get.call(null,map__55811__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var style = cljs.core.get.call(null,map__55811__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var style__$1 = (function (){var or__47075__auto__ = style;
if(cljs.core.truth_(or__47075__auto__)){
return or__47075__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
var vec__55814 = corner;
var x1 = cljs.core.nth.call(null,vec__55814,(0),null);
var y1 = cljs.core.nth.call(null,vec__55814,(1),null);
var x2 = (x1 + width);
var y2 = (y1 + height);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("lemonade.core","polyline","lemonade.core/polyline",878509078),new cljs.core.Keyword(null,"points","points",-1486596883),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x1,y1], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x2,y1], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x2,y2], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x1,y2], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x1,y1], null)], null)], null);
}));
/**
 * Returns an affine transformation corresponding to translation by b
 */
lemonade.core.translation = (function lemonade$core$translation(b){
return lemonade.geometry.atx.call(null,lemonade.geometry.idm,b);
});
/**
 * Returns a counterclockwise rotation about the origin by angle (linear).
 *   Note: angle in degrees.
 */
lemonade.core.rotation = (function lemonade$core$rotation(angle){
var r = lemonade.geometry.deg__GT_rad.call(null,angle);
var c = lemonade.geometry.cos.call(null,r);
var s = lemonade.geometry.sin.call(null,r);
return lemonade.geometry.atx.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [c,(- s),s,c], null));
});
/**
 * Returns a linear map which scales by [x y] in the x and y directions
 */
lemonade.core.scaling = (function lemonade$core$scaling(p__55822){
var vec__55823 = p__55822;
var x = cljs.core.nth.call(null,vec__55823,(0),null);
var y = cljs.core.nth.call(null,vec__55823,(1),null);
return lemonade.geometry.atx.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,(0),(0),y], null));
});
/**
 * Returns a reflection about vector v (linear)
 */
lemonade.core.reflection = (function lemonade$core$reflection(p__55827){
var vec__55829 = p__55827;
var x = cljs.core.nth.call(null,vec__55829,(0),null);
var y = cljs.core.nth.call(null,vec__55829,(1),null);
if(cljs.core._EQ_.call(null,(0),x)){
return lemonade.geometry.atx.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-1),(0),(0),(1)], null));
} else {
var m = (y / x);
var m2 = (m * m);
var m2_PLUS_1 = (m2 + (1));
var diag = (((1) - m2) / m2_PLUS_1);
var off = (((2) * m) / m2_PLUS_1);
return lemonade.geometry.atx.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [diag,off,off,(- diag)], null));
}
});
/**
 * Given a linear transformation and a point, return an affine transformation
 *   corresponding to the transformation about the point.
 */
lemonade.core.recentre = (function lemonade$core$recentre(origin,atx){
return lemonade.geometry.comp_atx.call(null,lemonade.core.translation.call(null,origin),atx,lemonade.core.translation.call(null,cljs.core.map.call(null,cljs.core._,origin)));
});
/**
 * Returns a new shape which is the given affine map applies to the base shape.
 */
lemonade.core.transform = (function lemonade$core$transform(base,atx){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("lemonade.core","atx","lemonade.core/atx",2089934527),new cljs.core.Keyword(null,"base-shape","base-shape",1242460301),base,new cljs.core.Keyword(null,"atx","atx",6306393),atx], null);
});
/**
 * Returns a copy of shape translated by [x y],
 */
lemonade.core.translate = (function lemonade$core$translate(b,shape){
return lemonade.core.transform.call(null,shape,lemonade.core.translation.call(null,b));
});
/**
 * Returns a copy of shape rotated by angle around the given centre of
 *   rotation.
 */
lemonade.core.rotate = (function lemonade$core$rotate(var_args){
var G__55842 = arguments.length;
switch (G__55842) {
case 2:
return lemonade.core.rotate.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return lemonade.core.rotate.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

lemonade.core.rotate.cljs$core$IFn$_invoke$arity$2 = (function (angle,shape){
return lemonade.core.rotate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),angle,shape);
});

lemonade.core.rotate.cljs$core$IFn$_invoke$arity$3 = (function (centre,angle,shape){
return lemonade.core.transform.call(null,shape,lemonade.core.recentre.call(null,centre,lemonade.core.rotation.call(null,angle)));
});

lemonade.core.rotate.cljs$lang$maxFixedArity = 3;

/**
 * Returns a copy of shape scaled horizontally by a and verticaly by b. Centre
 *   is the origin (fixed point) of the transform.
 */
lemonade.core.scale = (function lemonade$core$scale(var_args){
var G__55849 = arguments.length;
switch (G__55849) {
case 2:
return lemonade.core.scale.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return lemonade.core.scale.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

lemonade.core.scale.cljs$core$IFn$_invoke$arity$2 = (function (a,shape){
return lemonade.core.scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),a,shape);
});

lemonade.core.scale.cljs$core$IFn$_invoke$arity$3 = (function (centre,a,shape){
var extent = ((cljs.core.vector_QMARK_.call(null,a))?a:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,a], null));
return lemonade.core.transform.call(null,shape,lemonade.core.recentre.call(null,centre,lemonade.core.scaling.call(null,extent)));
});

lemonade.core.scale.cljs$lang$maxFixedArity = 3;

/**
 * Returns a copy of shaped reflected around the line with direction dir through
 *   centre.
 */
lemonade.core.reflect = (function lemonade$core$reflect(var_args){
var G__55854 = arguments.length;
switch (G__55854) {
case 2:
return lemonade.core.reflect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return lemonade.core.reflect.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

lemonade.core.reflect.cljs$core$IFn$_invoke$arity$2 = (function (dir,shape){
return lemonade.core.reflect.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),dir,shape);
});

lemonade.core.reflect.cljs$core$IFn$_invoke$arity$3 = (function (centre,dir,shape){
return lemonade.core.transform.call(null,shape,lemonade.core.recentre.call(null,centre,lemonade.core.reflection.call(null,dir)));
});

lemonade.core.reflect.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=core.js.map?rel=1509203649573
