// Compiled by ClojureScript 1.9.946 {}
goog.provide('lemonade.geometry');
goog.require('cljs.core');
lemonade.geometry.π = Math.PI;
/**
 * Ratio of circumference to diameter of a circle.
 *   For those who don't like programming with unicode.
 */
lemonade.geometry.pi = lemonade.geometry.π;
/**
 * Converts degrees to radians
 */
lemonade.geometry.deg__GT_rad = (function lemonade$geometry$deg__GT_rad(d){
return (lemonade.geometry.π * (d / (180)));
});
lemonade.geometry.sin = (function lemonade$geometry$sin(x){
return Math.sin(x);
});
lemonade.geometry.cos = (function lemonade$geometry$cos(x){
return Math.cos(x);
});
lemonade.geometry.abs = (function lemonade$geometry$abs(x){
if((x < (0))){
return (- x);
} else {
return x;
}
});
/**
 * Returns true if the sequential of paths passed in are pairwise connected.
 */
lemonade.geometry.connected_QMARK_ = (function lemonade$geometry$connected_QMARK_(p__51704){
while(true){
var vec__51705 = p__51704;
var seq__51706 = cljs.core.seq.call(null,vec__51705);
var first__51707 = cljs.core.first.call(null,seq__51706);
var seq__51706__$1 = cljs.core.next.call(null,seq__51706);
var x = first__51707;
var more = seq__51706__$1;
if(cljs.core.empty_QMARK_.call(null,more)){
return true;
} else {
var y = cljs.core.first.call(null,more);
var and__47063__auto__ = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"to","to",192099007).cljs$core$IFn$_invoke$arity$1(x),new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(y));
if(and__47063__auto__){
var G__51712 = more;
p__51704 = G__51712;
continue;
} else {
return and__47063__auto__;
}
}
break;
}
});
lemonade.geometry.closed_segment_QMARK_ = (function lemonade$geometry$closed_segment_QMARK_(path){
return (cljs.core._EQ_.call(null,new cljs.core.Keyword("lemonade.core","arc","lemonade.core/arc",1918704395),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(path))) && ((((2) * lemonade.geometry.π) < lemonade.geometry.abs.call(null,(new cljs.core.Keyword(null,"to","to",192099007).cljs$core$IFn$_invoke$arity$1(path) - new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(path)))));
});
/**
 * Returns true if paths form the boundary of a connected surface.
 *   Technically I'm requiring a connecting bridge of non-zero measure. Not sure if
 *   that's a good call...
 *   Simply connected not necessary, just no point connections.
 */
lemonade.geometry.closed_path_QMARK_ = (function lemonade$geometry$closed_path_QMARK_(paths){
var and__47063__auto__ = lemonade.geometry.connected_QMARK_.call(null,paths);
if(cljs.core.truth_(and__47063__auto__)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,paths)),new cljs.core.Keyword(null,"to","to",192099007).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,paths)));
} else {
return and__47063__auto__;
}
});
lemonade.geometry.closed_QMARK_ = (function lemonade$geometry$closed_QMARK_(paths){
var or__47075__auto__ = lemonade.geometry.closed_path_QMARK_.call(null,paths);
if(cljs.core.truth_(or__47075__auto__)){
return or__47075__auto__;
} else {
return cljs.core.every_QMARK_.call(null,lemonade.geometry.closed_segment_QMARK_,paths);
}
});
/**
 * Temporary workaround for spec and big arithmetic
 */
lemonade.geometry._STAR__STAR_ = cljs.core._STAR_;
/**
 * The 2x2 identity matrix
 */
lemonade.geometry.idm = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [1.0,0.0,0.0,1.0], null);
/**
 * Returns the determinant of a 2x2 matrix
 */
lemonade.geometry.det = (function lemonade$geometry$det(a,b,c,d){
return (lemonade.geometry._STAR__STAR_.call(null,a,d) - lemonade.geometry._STAR__STAR_.call(null,b,c));
});
/**
 * Convenience fn for building atx maps
 */
lemonade.geometry.atx = (function lemonade$geometry$atx(var_args){
var G__51726 = arguments.length;
switch (G__51726) {
case 1:
return lemonade.geometry.atx.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return lemonade.geometry.atx.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

lemonade.geometry.atx.cljs$core$IFn$_invoke$arity$1 = (function (m){
return lemonade.geometry.atx.call(null,m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null));
});

lemonade.geometry.atx.cljs$core$IFn$_invoke$arity$2 = (function (m,b){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"matrix","matrix",803137200),m,new cljs.core.Keyword(null,"translation","translation",-701621547),b], null);
});

lemonade.geometry.atx.cljs$lang$maxFixedArity = 2;

lemonade.geometry.id = lemonade.geometry.atx.call(null,lemonade.geometry.idm,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [0.0,0.0], null));
/**
 * Returns matrix corresponding to the inverse affine transform.
 */
lemonade.geometry.invert_atx = (function lemonade$geometry$invert_atx(p__51733){
var map__51734 = p__51733;
var map__51734__$1 = ((((!((map__51734 == null)))?((((map__51734.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51734.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51734):map__51734);
var vec__51735 = cljs.core.get.call(null,map__51734__$1,new cljs.core.Keyword(null,"matrix","matrix",803137200));
var a = cljs.core.nth.call(null,vec__51735,(0),null);
var b = cljs.core.nth.call(null,vec__51735,(1),null);
var c = cljs.core.nth.call(null,vec__51735,(2),null);
var d = cljs.core.nth.call(null,vec__51735,(3),null);
var vec__51738 = cljs.core.get.call(null,map__51734__$1,new cljs.core.Keyword(null,"translation","translation",-701621547));
var x = cljs.core.nth.call(null,vec__51738,(0),null);
var y = cljs.core.nth.call(null,vec__51738,(1),null);
var abs = lemonade.geometry.det.call(null,a,b,c,d);
var vec__51742 = cljs.core.map.call(null,((function (abs,map__51734,map__51734__$1,vec__51735,a,b,c,d,vec__51738,x,y){
return (function (p1__51731_SHARP_){
return (p1__51731_SHARP_ / abs);
});})(abs,map__51734,map__51734__$1,vec__51735,a,b,c,d,vec__51738,x,y))
,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [d,(- b),(- c),a], null));
var a_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__51742,(0),null);
var b_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__51742,(1),null);
var c_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__51742,(2),null);
var d_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__51742,(3),null);
var x_SINGLEQUOTE_ = (- (lemonade.geometry._STAR__STAR_.call(null,a_SINGLEQUOTE_,x) + lemonade.geometry._STAR__STAR_.call(null,b_SINGLEQUOTE_,y)));
var y_SINGLEQUOTE_ = (- (lemonade.geometry._STAR__STAR_.call(null,c_SINGLEQUOTE_,x) + lemonade.geometry._STAR__STAR_.call(null,d_SINGLEQUOTE_,y)));
return lemonade.geometry.atx.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [a_SINGLEQUOTE_,b_SINGLEQUOTE_,c_SINGLEQUOTE_,d_SINGLEQUOTE_], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_SINGLEQUOTE_,y_SINGLEQUOTE_], null));
});
/**
 * Returns the composition of affine transformations
 */
lemonade.geometry.comp_atx = (function lemonade$geometry$comp_atx(var_args){
var G__51758 = arguments.length;
switch (G__51758) {
case 1:
return lemonade.geometry.comp_atx.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return lemonade.geometry.comp_atx.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__48377__auto__ = [];
var len__48354__auto___51781 = arguments.length;
var i__48355__auto___51782 = (0);
while(true){
if((i__48355__auto___51782 < len__48354__auto___51781)){
args_arr__48377__auto__.push((arguments[i__48355__auto___51782]));

var G__51783 = (i__48355__auto___51782 + (1));
i__48355__auto___51782 = G__51783;
continue;
} else {
}
break;
}

var argseq__48378__auto__ = (new cljs.core.IndexedSeq(args_arr__48377__auto__.slice((2)),(0),null));
return lemonade.geometry.comp_atx.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__48378__auto__);

}
});

lemonade.geometry.comp_atx.cljs$core$IFn$_invoke$arity$1 = (function (a){
return a;
});

lemonade.geometry.comp_atx.cljs$core$IFn$_invoke$arity$2 = (function (p__51759,p__51760){
var map__51761 = p__51759;
var map__51761__$1 = ((((!((map__51761 == null)))?((((map__51761.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51761.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51761):map__51761);
var vec__51762 = cljs.core.get.call(null,map__51761__$1,new cljs.core.Keyword(null,"matrix","matrix",803137200));
var a = cljs.core.nth.call(null,vec__51762,(0),null);
var b = cljs.core.nth.call(null,vec__51762,(1),null);
var c = cljs.core.nth.call(null,vec__51762,(2),null);
var d = cljs.core.nth.call(null,vec__51762,(3),null);
var vec__51765 = cljs.core.get.call(null,map__51761__$1,new cljs.core.Keyword(null,"translation","translation",-701621547));
var x = cljs.core.nth.call(null,vec__51765,(0),null);
var y = cljs.core.nth.call(null,vec__51765,(1),null);
var map__51768 = p__51760;
var map__51768__$1 = ((((!((map__51768 == null)))?((((map__51768.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51768.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51768):map__51768);
var vec__51769 = cljs.core.get.call(null,map__51768__$1,new cljs.core.Keyword(null,"matrix","matrix",803137200));
var a_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__51769,(0),null);
var b_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__51769,(1),null);
var c_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__51769,(2),null);
var d_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__51769,(3),null);
var vec__51772 = cljs.core.get.call(null,map__51768__$1,new cljs.core.Keyword(null,"translation","translation",-701621547));
var x_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__51772,(0),null);
var y_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__51772,(1),null);
return lemonade.geometry.atx.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [((a * a_SINGLEQUOTE_) + (b * c_SINGLEQUOTE_)),((a * b_SINGLEQUOTE_) + (b * d_SINGLEQUOTE_)),((c * a_SINGLEQUOTE_) + (d * c_SINGLEQUOTE_)),((c * b_SINGLEQUOTE_) + (d * d_SINGLEQUOTE_))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((x + (a * x_SINGLEQUOTE_)) + (b * y_SINGLEQUOTE_)),((y + (c * x_SINGLEQUOTE_)) + (d * y_SINGLEQUOTE_))], null));
});

lemonade.geometry.comp_atx.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,more){
return cljs.core.reduce.call(null,lemonade.geometry.comp_atx,lemonade.geometry.comp_atx.call(null,a,b),more);
});

lemonade.geometry.comp_atx.cljs$lang$applyTo = (function (seq51752){
var G__51753 = cljs.core.first.call(null,seq51752);
var seq51752__$1 = cljs.core.next.call(null,seq51752);
var G__51757 = cljs.core.first.call(null,seq51752__$1);
var seq51752__$2 = cljs.core.next.call(null,seq51752__$1);
return lemonade.geometry.comp_atx.cljs$core$IFn$_invoke$arity$variadic(G__51753,G__51757,seq51752__$2);
});

lemonade.geometry.comp_atx.cljs$lang$maxFixedArity = (2);


//# sourceMappingURL=geometry.js.map?rel=1509203646504
