// Compiled by ClojureScript 1.9.946 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__54545 = arguments.length;
switch (G__54545) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async54546 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async54546 = (function (f,blockable,meta54547){
this.f = f;
this.blockable = blockable;
this.meta54547 = meta54547;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async54546.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_54548,meta54547__$1){
var self__ = this;
var _54548__$1 = this;
return (new cljs.core.async.t_cljs$core$async54546(self__.f,self__.blockable,meta54547__$1));
});

cljs.core.async.t_cljs$core$async54546.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_54548){
var self__ = this;
var _54548__$1 = this;
return self__.meta54547;
});

cljs.core.async.t_cljs$core$async54546.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async54546.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async54546.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async54546.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async54546.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta54547","meta54547",-31123218,null)], null);
});

cljs.core.async.t_cljs$core$async54546.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async54546.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async54546";

cljs.core.async.t_cljs$core$async54546.cljs$lang$ctorPrWriter = (function (this__47746__auto__,writer__47747__auto__,opt__47748__auto__){
return cljs.core._write.call(null,writer__47747__auto__,"cljs.core.async/t_cljs$core$async54546");
});

cljs.core.async.__GT_t_cljs$core$async54546 = (function cljs$core$async$__GT_t_cljs$core$async54546(f__$1,blockable__$1,meta54547){
return (new cljs.core.async.t_cljs$core$async54546(f__$1,blockable__$1,meta54547));
});

}

return (new cljs.core.async.t_cljs$core$async54546(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__54552 = arguments.length;
switch (G__54552) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__54558 = arguments.length;
switch (G__54558) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__54561 = arguments.length;
switch (G__54561) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_54566 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_54566);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_54566,ret){
return (function (){
return fn1.call(null,val_54566);
});})(val_54566,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__54568 = arguments.length;
switch (G__54568) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5457__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5457__auto__)){
var ret = temp__5457__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5457__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5457__auto__)){
var retb = temp__5457__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5457__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5457__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__48120__auto___54570 = n;
var x_54571 = (0);
while(true){
if((x_54571 < n__48120__auto___54570)){
(a[x_54571] = (0));

var G__54572 = (x_54571 + (1));
x_54571 = G__54572;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__54573 = (i + (1));
i = G__54573;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async54574 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async54574 = (function (flag,meta54575){
this.flag = flag;
this.meta54575 = meta54575;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async54574.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_54576,meta54575__$1){
var self__ = this;
var _54576__$1 = this;
return (new cljs.core.async.t_cljs$core$async54574(self__.flag,meta54575__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async54574.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_54576){
var self__ = this;
var _54576__$1 = this;
return self__.meta54575;
});})(flag))
;

cljs.core.async.t_cljs$core$async54574.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async54574.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async54574.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async54574.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async54574.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta54575","meta54575",308867156,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async54574.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async54574.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async54574";

cljs.core.async.t_cljs$core$async54574.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__47746__auto__,writer__47747__auto__,opt__47748__auto__){
return cljs.core._write.call(null,writer__47747__auto__,"cljs.core.async/t_cljs$core$async54574");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async54574 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async54574(flag__$1,meta54575){
return (new cljs.core.async.t_cljs$core$async54574(flag__$1,meta54575));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async54574(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async54577 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async54577 = (function (flag,cb,meta54578){
this.flag = flag;
this.cb = cb;
this.meta54578 = meta54578;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async54577.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_54579,meta54578__$1){
var self__ = this;
var _54579__$1 = this;
return (new cljs.core.async.t_cljs$core$async54577(self__.flag,self__.cb,meta54578__$1));
});

cljs.core.async.t_cljs$core$async54577.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_54579){
var self__ = this;
var _54579__$1 = this;
return self__.meta54578;
});

cljs.core.async.t_cljs$core$async54577.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async54577.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async54577.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async54577.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async54577.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta54578","meta54578",1756675903,null)], null);
});

cljs.core.async.t_cljs$core$async54577.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async54577.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async54577";

cljs.core.async.t_cljs$core$async54577.cljs$lang$ctorPrWriter = (function (this__47746__auto__,writer__47747__auto__,opt__47748__auto__){
return cljs.core._write.call(null,writer__47747__auto__,"cljs.core.async/t_cljs$core$async54577");
});

cljs.core.async.__GT_t_cljs$core$async54577 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async54577(flag__$1,cb__$1,meta54578){
return (new cljs.core.async.t_cljs$core$async54577(flag__$1,cb__$1,meta54578));
});

}

return (new cljs.core.async.t_cljs$core$async54577(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__54580_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__54580_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__54581_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__54581_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__47075__auto__ = wport;
if(cljs.core.truth_(or__47075__auto__)){
return or__47075__auto__;
} else {
return port;
}
})()], null));
} else {
var G__54582 = (i + (1));
i = G__54582;
continue;
}
} else {
return null;
}
break;
}
})();
var or__47075__auto__ = ret;
if(cljs.core.truth_(or__47075__auto__)){
return or__47075__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5459__auto__ = (function (){var and__47063__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__47063__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__47063__auto__;
}
})();
if(cljs.core.truth_(temp__5459__auto__)){
var got = temp__5459__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__48361__auto__ = [];
var len__48354__auto___54588 = arguments.length;
var i__48355__auto___54589 = (0);
while(true){
if((i__48355__auto___54589 < len__48354__auto___54588)){
args__48361__auto__.push((arguments[i__48355__auto___54589]));

var G__54590 = (i__48355__auto___54589 + (1));
i__48355__auto___54589 = G__54590;
continue;
} else {
}
break;
}

var argseq__48362__auto__ = ((((1) < args__48361__auto__.length))?(new cljs.core.IndexedSeq(args__48361__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__48362__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__54585){
var map__54586 = p__54585;
var map__54586__$1 = ((((!((map__54586 == null)))?((((map__54586.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54586.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54586):map__54586);
var opts = map__54586__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq54583){
var G__54584 = cljs.core.first.call(null,seq54583);
var seq54583__$1 = cljs.core.next.call(null,seq54583);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__54584,seq54583__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__54592 = arguments.length;
switch (G__54592) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__54472__auto___54638 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto___54638){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto___54638){
return (function (state_54616){
var state_val_54617 = (state_54616[(1)]);
if((state_val_54617 === (7))){
var inst_54612 = (state_54616[(2)]);
var state_54616__$1 = state_54616;
var statearr_54618_54639 = state_54616__$1;
(statearr_54618_54639[(2)] = inst_54612);

(statearr_54618_54639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54617 === (1))){
var state_54616__$1 = state_54616;
var statearr_54619_54640 = state_54616__$1;
(statearr_54619_54640[(2)] = null);

(statearr_54619_54640[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54617 === (4))){
var inst_54595 = (state_54616[(7)]);
var inst_54595__$1 = (state_54616[(2)]);
var inst_54596 = (inst_54595__$1 == null);
var state_54616__$1 = (function (){var statearr_54620 = state_54616;
(statearr_54620[(7)] = inst_54595__$1);

return statearr_54620;
})();
if(cljs.core.truth_(inst_54596)){
var statearr_54621_54641 = state_54616__$1;
(statearr_54621_54641[(1)] = (5));

} else {
var statearr_54622_54642 = state_54616__$1;
(statearr_54622_54642[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54617 === (13))){
var state_54616__$1 = state_54616;
var statearr_54623_54643 = state_54616__$1;
(statearr_54623_54643[(2)] = null);

(statearr_54623_54643[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54617 === (6))){
var inst_54595 = (state_54616[(7)]);
var state_54616__$1 = state_54616;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54616__$1,(11),to,inst_54595);
} else {
if((state_val_54617 === (3))){
var inst_54614 = (state_54616[(2)]);
var state_54616__$1 = state_54616;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54616__$1,inst_54614);
} else {
if((state_val_54617 === (12))){
var state_54616__$1 = state_54616;
var statearr_54624_54644 = state_54616__$1;
(statearr_54624_54644[(2)] = null);

(statearr_54624_54644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54617 === (2))){
var state_54616__$1 = state_54616;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54616__$1,(4),from);
} else {
if((state_val_54617 === (11))){
var inst_54605 = (state_54616[(2)]);
var state_54616__$1 = state_54616;
if(cljs.core.truth_(inst_54605)){
var statearr_54625_54645 = state_54616__$1;
(statearr_54625_54645[(1)] = (12));

} else {
var statearr_54626_54646 = state_54616__$1;
(statearr_54626_54646[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54617 === (9))){
var state_54616__$1 = state_54616;
var statearr_54627_54647 = state_54616__$1;
(statearr_54627_54647[(2)] = null);

(statearr_54627_54647[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54617 === (5))){
var state_54616__$1 = state_54616;
if(cljs.core.truth_(close_QMARK_)){
var statearr_54628_54648 = state_54616__$1;
(statearr_54628_54648[(1)] = (8));

} else {
var statearr_54629_54649 = state_54616__$1;
(statearr_54629_54649[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54617 === (14))){
var inst_54610 = (state_54616[(2)]);
var state_54616__$1 = state_54616;
var statearr_54630_54650 = state_54616__$1;
(statearr_54630_54650[(2)] = inst_54610);

(statearr_54630_54650[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54617 === (10))){
var inst_54602 = (state_54616[(2)]);
var state_54616__$1 = state_54616;
var statearr_54631_54651 = state_54616__$1;
(statearr_54631_54651[(2)] = inst_54602);

(statearr_54631_54651[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54617 === (8))){
var inst_54599 = cljs.core.async.close_BANG_.call(null,to);
var state_54616__$1 = state_54616;
var statearr_54632_54652 = state_54616__$1;
(statearr_54632_54652[(2)] = inst_54599);

(statearr_54632_54652[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54472__auto___54638))
;
return ((function (switch__54129__auto__,c__54472__auto___54638){
return (function() {
var cljs$core$async$state_machine__54130__auto__ = null;
var cljs$core$async$state_machine__54130__auto____0 = (function (){
var statearr_54633 = [null,null,null,null,null,null,null,null];
(statearr_54633[(0)] = cljs$core$async$state_machine__54130__auto__);

(statearr_54633[(1)] = (1));

return statearr_54633;
});
var cljs$core$async$state_machine__54130__auto____1 = (function (state_54616){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_54616);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e54634){if((e54634 instanceof Object)){
var ex__54133__auto__ = e54634;
var statearr_54635_54653 = state_54616;
(statearr_54635_54653[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54616);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54634;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54654 = state_54616;
state_54616 = G__54654;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
cljs$core$async$state_machine__54130__auto__ = function(state_54616){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__54130__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__54130__auto____1.call(this,state_54616);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__54130__auto____0;
cljs$core$async$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__54130__auto____1;
return cljs$core$async$state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto___54638))
})();
var state__54474__auto__ = (function (){var statearr_54636 = f__54473__auto__.call(null);
(statearr_54636[(6)] = c__54472__auto___54638);

return statearr_54636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto___54638))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__54655){
var vec__54656 = p__54655;
var v = cljs.core.nth.call(null,vec__54656,(0),null);
var p = cljs.core.nth.call(null,vec__54656,(1),null);
var job = vec__54656;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__54472__auto___54827 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto___54827,res,vec__54656,v,p,job,jobs,results){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto___54827,res,vec__54656,v,p,job,jobs,results){
return (function (state_54663){
var state_val_54664 = (state_54663[(1)]);
if((state_val_54664 === (1))){
var state_54663__$1 = state_54663;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54663__$1,(2),res,v);
} else {
if((state_val_54664 === (2))){
var inst_54660 = (state_54663[(2)]);
var inst_54661 = cljs.core.async.close_BANG_.call(null,res);
var state_54663__$1 = (function (){var statearr_54665 = state_54663;
(statearr_54665[(7)] = inst_54660);

return statearr_54665;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54663__$1,inst_54661);
} else {
return null;
}
}
});})(c__54472__auto___54827,res,vec__54656,v,p,job,jobs,results))
;
return ((function (switch__54129__auto__,c__54472__auto___54827,res,vec__54656,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____0 = (function (){
var statearr_54666 = [null,null,null,null,null,null,null,null];
(statearr_54666[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__);

(statearr_54666[(1)] = (1));

return statearr_54666;
});
var cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____1 = (function (state_54663){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_54663);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e54667){if((e54667 instanceof Object)){
var ex__54133__auto__ = e54667;
var statearr_54668_54828 = state_54663;
(statearr_54668_54828[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54663);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54667;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54829 = state_54663;
state_54663 = G__54829;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__ = function(state_54663){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____1.call(this,state_54663);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto___54827,res,vec__54656,v,p,job,jobs,results))
})();
var state__54474__auto__ = (function (){var statearr_54669 = f__54473__auto__.call(null);
(statearr_54669[(6)] = c__54472__auto___54827);

return statearr_54669;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto___54827,res,vec__54656,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__54670){
var vec__54671 = p__54670;
var v = cljs.core.nth.call(null,vec__54671,(0),null);
var p = cljs.core.nth.call(null,vec__54671,(1),null);
var job = vec__54671;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__48120__auto___54830 = n;
var __54831 = (0);
while(true){
if((__54831 < n__48120__auto___54830)){
var G__54674_54832 = type;
var G__54674_54833__$1 = (((G__54674_54832 instanceof cljs.core.Keyword))?G__54674_54832.fqn:null);
switch (G__54674_54833__$1) {
case "compute":
var c__54472__auto___54835 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__54831,c__54472__auto___54835,G__54674_54832,G__54674_54833__$1,n__48120__auto___54830,jobs,results,process,async){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (__54831,c__54472__auto___54835,G__54674_54832,G__54674_54833__$1,n__48120__auto___54830,jobs,results,process,async){
return (function (state_54687){
var state_val_54688 = (state_54687[(1)]);
if((state_val_54688 === (1))){
var state_54687__$1 = state_54687;
var statearr_54689_54836 = state_54687__$1;
(statearr_54689_54836[(2)] = null);

(statearr_54689_54836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (2))){
var state_54687__$1 = state_54687;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54687__$1,(4),jobs);
} else {
if((state_val_54688 === (3))){
var inst_54685 = (state_54687[(2)]);
var state_54687__$1 = state_54687;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54687__$1,inst_54685);
} else {
if((state_val_54688 === (4))){
var inst_54677 = (state_54687[(2)]);
var inst_54678 = process.call(null,inst_54677);
var state_54687__$1 = state_54687;
if(cljs.core.truth_(inst_54678)){
var statearr_54690_54837 = state_54687__$1;
(statearr_54690_54837[(1)] = (5));

} else {
var statearr_54691_54838 = state_54687__$1;
(statearr_54691_54838[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (5))){
var state_54687__$1 = state_54687;
var statearr_54692_54839 = state_54687__$1;
(statearr_54692_54839[(2)] = null);

(statearr_54692_54839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (6))){
var state_54687__$1 = state_54687;
var statearr_54693_54840 = state_54687__$1;
(statearr_54693_54840[(2)] = null);

(statearr_54693_54840[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54688 === (7))){
var inst_54683 = (state_54687[(2)]);
var state_54687__$1 = state_54687;
var statearr_54694_54841 = state_54687__$1;
(statearr_54694_54841[(2)] = inst_54683);

(statearr_54694_54841[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__54831,c__54472__auto___54835,G__54674_54832,G__54674_54833__$1,n__48120__auto___54830,jobs,results,process,async))
;
return ((function (__54831,switch__54129__auto__,c__54472__auto___54835,G__54674_54832,G__54674_54833__$1,n__48120__auto___54830,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____0 = (function (){
var statearr_54695 = [null,null,null,null,null,null,null];
(statearr_54695[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__);

(statearr_54695[(1)] = (1));

return statearr_54695;
});
var cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____1 = (function (state_54687){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_54687);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e54696){if((e54696 instanceof Object)){
var ex__54133__auto__ = e54696;
var statearr_54697_54842 = state_54687;
(statearr_54697_54842[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54687);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54696;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54843 = state_54687;
state_54687 = G__54843;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__ = function(state_54687){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____1.call(this,state_54687);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__;
})()
;})(__54831,switch__54129__auto__,c__54472__auto___54835,G__54674_54832,G__54674_54833__$1,n__48120__auto___54830,jobs,results,process,async))
})();
var state__54474__auto__ = (function (){var statearr_54698 = f__54473__auto__.call(null);
(statearr_54698[(6)] = c__54472__auto___54835);

return statearr_54698;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(__54831,c__54472__auto___54835,G__54674_54832,G__54674_54833__$1,n__48120__auto___54830,jobs,results,process,async))
);


break;
case "async":
var c__54472__auto___54844 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__54831,c__54472__auto___54844,G__54674_54832,G__54674_54833__$1,n__48120__auto___54830,jobs,results,process,async){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (__54831,c__54472__auto___54844,G__54674_54832,G__54674_54833__$1,n__48120__auto___54830,jobs,results,process,async){
return (function (state_54711){
var state_val_54712 = (state_54711[(1)]);
if((state_val_54712 === (1))){
var state_54711__$1 = state_54711;
var statearr_54713_54845 = state_54711__$1;
(statearr_54713_54845[(2)] = null);

(statearr_54713_54845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54712 === (2))){
var state_54711__$1 = state_54711;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54711__$1,(4),jobs);
} else {
if((state_val_54712 === (3))){
var inst_54709 = (state_54711[(2)]);
var state_54711__$1 = state_54711;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54711__$1,inst_54709);
} else {
if((state_val_54712 === (4))){
var inst_54701 = (state_54711[(2)]);
var inst_54702 = async.call(null,inst_54701);
var state_54711__$1 = state_54711;
if(cljs.core.truth_(inst_54702)){
var statearr_54714_54846 = state_54711__$1;
(statearr_54714_54846[(1)] = (5));

} else {
var statearr_54715_54847 = state_54711__$1;
(statearr_54715_54847[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54712 === (5))){
var state_54711__$1 = state_54711;
var statearr_54716_54848 = state_54711__$1;
(statearr_54716_54848[(2)] = null);

(statearr_54716_54848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54712 === (6))){
var state_54711__$1 = state_54711;
var statearr_54717_54849 = state_54711__$1;
(statearr_54717_54849[(2)] = null);

(statearr_54717_54849[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54712 === (7))){
var inst_54707 = (state_54711[(2)]);
var state_54711__$1 = state_54711;
var statearr_54718_54850 = state_54711__$1;
(statearr_54718_54850[(2)] = inst_54707);

(statearr_54718_54850[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__54831,c__54472__auto___54844,G__54674_54832,G__54674_54833__$1,n__48120__auto___54830,jobs,results,process,async))
;
return ((function (__54831,switch__54129__auto__,c__54472__auto___54844,G__54674_54832,G__54674_54833__$1,n__48120__auto___54830,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____0 = (function (){
var statearr_54719 = [null,null,null,null,null,null,null];
(statearr_54719[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__);

(statearr_54719[(1)] = (1));

return statearr_54719;
});
var cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____1 = (function (state_54711){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_54711);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e54720){if((e54720 instanceof Object)){
var ex__54133__auto__ = e54720;
var statearr_54721_54851 = state_54711;
(statearr_54721_54851[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54711);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54720;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54852 = state_54711;
state_54711 = G__54852;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__ = function(state_54711){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____1.call(this,state_54711);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__;
})()
;})(__54831,switch__54129__auto__,c__54472__auto___54844,G__54674_54832,G__54674_54833__$1,n__48120__auto___54830,jobs,results,process,async))
})();
var state__54474__auto__ = (function (){var statearr_54722 = f__54473__auto__.call(null);
(statearr_54722[(6)] = c__54472__auto___54844);

return statearr_54722;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(__54831,c__54472__auto___54844,G__54674_54832,G__54674_54833__$1,n__48120__auto___54830,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__54674_54833__$1)].join('')));

}

var G__54853 = (__54831 + (1));
__54831 = G__54853;
continue;
} else {
}
break;
}

var c__54472__auto___54854 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto___54854,jobs,results,process,async){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto___54854,jobs,results,process,async){
return (function (state_54744){
var state_val_54745 = (state_54744[(1)]);
if((state_val_54745 === (1))){
var state_54744__$1 = state_54744;
var statearr_54746_54855 = state_54744__$1;
(statearr_54746_54855[(2)] = null);

(statearr_54746_54855[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54745 === (2))){
var state_54744__$1 = state_54744;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54744__$1,(4),from);
} else {
if((state_val_54745 === (3))){
var inst_54742 = (state_54744[(2)]);
var state_54744__$1 = state_54744;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54744__$1,inst_54742);
} else {
if((state_val_54745 === (4))){
var inst_54725 = (state_54744[(7)]);
var inst_54725__$1 = (state_54744[(2)]);
var inst_54726 = (inst_54725__$1 == null);
var state_54744__$1 = (function (){var statearr_54747 = state_54744;
(statearr_54747[(7)] = inst_54725__$1);

return statearr_54747;
})();
if(cljs.core.truth_(inst_54726)){
var statearr_54748_54856 = state_54744__$1;
(statearr_54748_54856[(1)] = (5));

} else {
var statearr_54749_54857 = state_54744__$1;
(statearr_54749_54857[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54745 === (5))){
var inst_54728 = cljs.core.async.close_BANG_.call(null,jobs);
var state_54744__$1 = state_54744;
var statearr_54750_54858 = state_54744__$1;
(statearr_54750_54858[(2)] = inst_54728);

(statearr_54750_54858[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54745 === (6))){
var inst_54730 = (state_54744[(8)]);
var inst_54725 = (state_54744[(7)]);
var inst_54730__$1 = cljs.core.async.chan.call(null,(1));
var inst_54731 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54732 = [inst_54725,inst_54730__$1];
var inst_54733 = (new cljs.core.PersistentVector(null,2,(5),inst_54731,inst_54732,null));
var state_54744__$1 = (function (){var statearr_54751 = state_54744;
(statearr_54751[(8)] = inst_54730__$1);

return statearr_54751;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54744__$1,(8),jobs,inst_54733);
} else {
if((state_val_54745 === (7))){
var inst_54740 = (state_54744[(2)]);
var state_54744__$1 = state_54744;
var statearr_54752_54859 = state_54744__$1;
(statearr_54752_54859[(2)] = inst_54740);

(statearr_54752_54859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54745 === (8))){
var inst_54730 = (state_54744[(8)]);
var inst_54735 = (state_54744[(2)]);
var state_54744__$1 = (function (){var statearr_54753 = state_54744;
(statearr_54753[(9)] = inst_54735);

return statearr_54753;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54744__$1,(9),results,inst_54730);
} else {
if((state_val_54745 === (9))){
var inst_54737 = (state_54744[(2)]);
var state_54744__$1 = (function (){var statearr_54754 = state_54744;
(statearr_54754[(10)] = inst_54737);

return statearr_54754;
})();
var statearr_54755_54860 = state_54744__$1;
(statearr_54755_54860[(2)] = null);

(statearr_54755_54860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__54472__auto___54854,jobs,results,process,async))
;
return ((function (switch__54129__auto__,c__54472__auto___54854,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____0 = (function (){
var statearr_54756 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54756[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__);

(statearr_54756[(1)] = (1));

return statearr_54756;
});
var cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____1 = (function (state_54744){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_54744);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e54757){if((e54757 instanceof Object)){
var ex__54133__auto__ = e54757;
var statearr_54758_54861 = state_54744;
(statearr_54758_54861[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54744);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54757;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54862 = state_54744;
state_54744 = G__54862;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__ = function(state_54744){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____1.call(this,state_54744);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto___54854,jobs,results,process,async))
})();
var state__54474__auto__ = (function (){var statearr_54759 = f__54473__auto__.call(null);
(statearr_54759[(6)] = c__54472__auto___54854);

return statearr_54759;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto___54854,jobs,results,process,async))
);


var c__54472__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto__,jobs,results,process,async){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto__,jobs,results,process,async){
return (function (state_54797){
var state_val_54798 = (state_54797[(1)]);
if((state_val_54798 === (7))){
var inst_54793 = (state_54797[(2)]);
var state_54797__$1 = state_54797;
var statearr_54799_54863 = state_54797__$1;
(statearr_54799_54863[(2)] = inst_54793);

(statearr_54799_54863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54798 === (20))){
var state_54797__$1 = state_54797;
var statearr_54800_54864 = state_54797__$1;
(statearr_54800_54864[(2)] = null);

(statearr_54800_54864[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54798 === (1))){
var state_54797__$1 = state_54797;
var statearr_54801_54865 = state_54797__$1;
(statearr_54801_54865[(2)] = null);

(statearr_54801_54865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54798 === (4))){
var inst_54762 = (state_54797[(7)]);
var inst_54762__$1 = (state_54797[(2)]);
var inst_54763 = (inst_54762__$1 == null);
var state_54797__$1 = (function (){var statearr_54802 = state_54797;
(statearr_54802[(7)] = inst_54762__$1);

return statearr_54802;
})();
if(cljs.core.truth_(inst_54763)){
var statearr_54803_54866 = state_54797__$1;
(statearr_54803_54866[(1)] = (5));

} else {
var statearr_54804_54867 = state_54797__$1;
(statearr_54804_54867[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54798 === (15))){
var inst_54775 = (state_54797[(8)]);
var state_54797__$1 = state_54797;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54797__$1,(18),to,inst_54775);
} else {
if((state_val_54798 === (21))){
var inst_54788 = (state_54797[(2)]);
var state_54797__$1 = state_54797;
var statearr_54805_54868 = state_54797__$1;
(statearr_54805_54868[(2)] = inst_54788);

(statearr_54805_54868[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54798 === (13))){
var inst_54790 = (state_54797[(2)]);
var state_54797__$1 = (function (){var statearr_54806 = state_54797;
(statearr_54806[(9)] = inst_54790);

return statearr_54806;
})();
var statearr_54807_54869 = state_54797__$1;
(statearr_54807_54869[(2)] = null);

(statearr_54807_54869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54798 === (6))){
var inst_54762 = (state_54797[(7)]);
var state_54797__$1 = state_54797;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54797__$1,(11),inst_54762);
} else {
if((state_val_54798 === (17))){
var inst_54783 = (state_54797[(2)]);
var state_54797__$1 = state_54797;
if(cljs.core.truth_(inst_54783)){
var statearr_54808_54870 = state_54797__$1;
(statearr_54808_54870[(1)] = (19));

} else {
var statearr_54809_54871 = state_54797__$1;
(statearr_54809_54871[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54798 === (3))){
var inst_54795 = (state_54797[(2)]);
var state_54797__$1 = state_54797;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54797__$1,inst_54795);
} else {
if((state_val_54798 === (12))){
var inst_54772 = (state_54797[(10)]);
var state_54797__$1 = state_54797;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54797__$1,(14),inst_54772);
} else {
if((state_val_54798 === (2))){
var state_54797__$1 = state_54797;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54797__$1,(4),results);
} else {
if((state_val_54798 === (19))){
var state_54797__$1 = state_54797;
var statearr_54810_54872 = state_54797__$1;
(statearr_54810_54872[(2)] = null);

(statearr_54810_54872[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54798 === (11))){
var inst_54772 = (state_54797[(2)]);
var state_54797__$1 = (function (){var statearr_54811 = state_54797;
(statearr_54811[(10)] = inst_54772);

return statearr_54811;
})();
var statearr_54812_54873 = state_54797__$1;
(statearr_54812_54873[(2)] = null);

(statearr_54812_54873[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54798 === (9))){
var state_54797__$1 = state_54797;
var statearr_54813_54874 = state_54797__$1;
(statearr_54813_54874[(2)] = null);

(statearr_54813_54874[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54798 === (5))){
var state_54797__$1 = state_54797;
if(cljs.core.truth_(close_QMARK_)){
var statearr_54814_54875 = state_54797__$1;
(statearr_54814_54875[(1)] = (8));

} else {
var statearr_54815_54876 = state_54797__$1;
(statearr_54815_54876[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54798 === (14))){
var inst_54775 = (state_54797[(8)]);
var inst_54777 = (state_54797[(11)]);
var inst_54775__$1 = (state_54797[(2)]);
var inst_54776 = (inst_54775__$1 == null);
var inst_54777__$1 = cljs.core.not.call(null,inst_54776);
var state_54797__$1 = (function (){var statearr_54816 = state_54797;
(statearr_54816[(8)] = inst_54775__$1);

(statearr_54816[(11)] = inst_54777__$1);

return statearr_54816;
})();
if(inst_54777__$1){
var statearr_54817_54877 = state_54797__$1;
(statearr_54817_54877[(1)] = (15));

} else {
var statearr_54818_54878 = state_54797__$1;
(statearr_54818_54878[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54798 === (16))){
var inst_54777 = (state_54797[(11)]);
var state_54797__$1 = state_54797;
var statearr_54819_54879 = state_54797__$1;
(statearr_54819_54879[(2)] = inst_54777);

(statearr_54819_54879[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54798 === (10))){
var inst_54769 = (state_54797[(2)]);
var state_54797__$1 = state_54797;
var statearr_54820_54880 = state_54797__$1;
(statearr_54820_54880[(2)] = inst_54769);

(statearr_54820_54880[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54798 === (18))){
var inst_54780 = (state_54797[(2)]);
var state_54797__$1 = state_54797;
var statearr_54821_54881 = state_54797__$1;
(statearr_54821_54881[(2)] = inst_54780);

(statearr_54821_54881[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54798 === (8))){
var inst_54766 = cljs.core.async.close_BANG_.call(null,to);
var state_54797__$1 = state_54797;
var statearr_54822_54882 = state_54797__$1;
(statearr_54822_54882[(2)] = inst_54766);

(statearr_54822_54882[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54472__auto__,jobs,results,process,async))
;
return ((function (switch__54129__auto__,c__54472__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____0 = (function (){
var statearr_54823 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54823[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__);

(statearr_54823[(1)] = (1));

return statearr_54823;
});
var cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____1 = (function (state_54797){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_54797);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e54824){if((e54824 instanceof Object)){
var ex__54133__auto__ = e54824;
var statearr_54825_54883 = state_54797;
(statearr_54825_54883[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54797);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54824;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54884 = state_54797;
state_54797 = G__54884;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__ = function(state_54797){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____1.call(this,state_54797);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__54130__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto__,jobs,results,process,async))
})();
var state__54474__auto__ = (function (){var statearr_54826 = f__54473__auto__.call(null);
(statearr_54826[(6)] = c__54472__auto__);

return statearr_54826;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto__,jobs,results,process,async))
);

return c__54472__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__54886 = arguments.length;
switch (G__54886) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__54889 = arguments.length;
switch (G__54889) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__54892 = arguments.length;
switch (G__54892) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__54472__auto___54941 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto___54941,tc,fc){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto___54941,tc,fc){
return (function (state_54918){
var state_val_54919 = (state_54918[(1)]);
if((state_val_54919 === (7))){
var inst_54914 = (state_54918[(2)]);
var state_54918__$1 = state_54918;
var statearr_54920_54942 = state_54918__$1;
(statearr_54920_54942[(2)] = inst_54914);

(statearr_54920_54942[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54919 === (1))){
var state_54918__$1 = state_54918;
var statearr_54921_54943 = state_54918__$1;
(statearr_54921_54943[(2)] = null);

(statearr_54921_54943[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54919 === (4))){
var inst_54895 = (state_54918[(7)]);
var inst_54895__$1 = (state_54918[(2)]);
var inst_54896 = (inst_54895__$1 == null);
var state_54918__$1 = (function (){var statearr_54922 = state_54918;
(statearr_54922[(7)] = inst_54895__$1);

return statearr_54922;
})();
if(cljs.core.truth_(inst_54896)){
var statearr_54923_54944 = state_54918__$1;
(statearr_54923_54944[(1)] = (5));

} else {
var statearr_54924_54945 = state_54918__$1;
(statearr_54924_54945[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54919 === (13))){
var state_54918__$1 = state_54918;
var statearr_54925_54946 = state_54918__$1;
(statearr_54925_54946[(2)] = null);

(statearr_54925_54946[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54919 === (6))){
var inst_54895 = (state_54918[(7)]);
var inst_54901 = p.call(null,inst_54895);
var state_54918__$1 = state_54918;
if(cljs.core.truth_(inst_54901)){
var statearr_54926_54947 = state_54918__$1;
(statearr_54926_54947[(1)] = (9));

} else {
var statearr_54927_54948 = state_54918__$1;
(statearr_54927_54948[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54919 === (3))){
var inst_54916 = (state_54918[(2)]);
var state_54918__$1 = state_54918;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54918__$1,inst_54916);
} else {
if((state_val_54919 === (12))){
var state_54918__$1 = state_54918;
var statearr_54928_54949 = state_54918__$1;
(statearr_54928_54949[(2)] = null);

(statearr_54928_54949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54919 === (2))){
var state_54918__$1 = state_54918;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54918__$1,(4),ch);
} else {
if((state_val_54919 === (11))){
var inst_54895 = (state_54918[(7)]);
var inst_54905 = (state_54918[(2)]);
var state_54918__$1 = state_54918;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54918__$1,(8),inst_54905,inst_54895);
} else {
if((state_val_54919 === (9))){
var state_54918__$1 = state_54918;
var statearr_54929_54950 = state_54918__$1;
(statearr_54929_54950[(2)] = tc);

(statearr_54929_54950[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54919 === (5))){
var inst_54898 = cljs.core.async.close_BANG_.call(null,tc);
var inst_54899 = cljs.core.async.close_BANG_.call(null,fc);
var state_54918__$1 = (function (){var statearr_54930 = state_54918;
(statearr_54930[(8)] = inst_54898);

return statearr_54930;
})();
var statearr_54931_54951 = state_54918__$1;
(statearr_54931_54951[(2)] = inst_54899);

(statearr_54931_54951[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54919 === (14))){
var inst_54912 = (state_54918[(2)]);
var state_54918__$1 = state_54918;
var statearr_54932_54952 = state_54918__$1;
(statearr_54932_54952[(2)] = inst_54912);

(statearr_54932_54952[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54919 === (10))){
var state_54918__$1 = state_54918;
var statearr_54933_54953 = state_54918__$1;
(statearr_54933_54953[(2)] = fc);

(statearr_54933_54953[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54919 === (8))){
var inst_54907 = (state_54918[(2)]);
var state_54918__$1 = state_54918;
if(cljs.core.truth_(inst_54907)){
var statearr_54934_54954 = state_54918__$1;
(statearr_54934_54954[(1)] = (12));

} else {
var statearr_54935_54955 = state_54918__$1;
(statearr_54935_54955[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54472__auto___54941,tc,fc))
;
return ((function (switch__54129__auto__,c__54472__auto___54941,tc,fc){
return (function() {
var cljs$core$async$state_machine__54130__auto__ = null;
var cljs$core$async$state_machine__54130__auto____0 = (function (){
var statearr_54936 = [null,null,null,null,null,null,null,null,null];
(statearr_54936[(0)] = cljs$core$async$state_machine__54130__auto__);

(statearr_54936[(1)] = (1));

return statearr_54936;
});
var cljs$core$async$state_machine__54130__auto____1 = (function (state_54918){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_54918);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e54937){if((e54937 instanceof Object)){
var ex__54133__auto__ = e54937;
var statearr_54938_54956 = state_54918;
(statearr_54938_54956[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54918);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54937;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54957 = state_54918;
state_54918 = G__54957;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
cljs$core$async$state_machine__54130__auto__ = function(state_54918){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__54130__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__54130__auto____1.call(this,state_54918);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__54130__auto____0;
cljs$core$async$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__54130__auto____1;
return cljs$core$async$state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto___54941,tc,fc))
})();
var state__54474__auto__ = (function (){var statearr_54939 = f__54473__auto__.call(null);
(statearr_54939[(6)] = c__54472__auto___54941);

return statearr_54939;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto___54941,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__54472__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto__){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto__){
return (function (state_54978){
var state_val_54979 = (state_54978[(1)]);
if((state_val_54979 === (7))){
var inst_54974 = (state_54978[(2)]);
var state_54978__$1 = state_54978;
var statearr_54980_54998 = state_54978__$1;
(statearr_54980_54998[(2)] = inst_54974);

(statearr_54980_54998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54979 === (1))){
var inst_54958 = init;
var state_54978__$1 = (function (){var statearr_54981 = state_54978;
(statearr_54981[(7)] = inst_54958);

return statearr_54981;
})();
var statearr_54982_54999 = state_54978__$1;
(statearr_54982_54999[(2)] = null);

(statearr_54982_54999[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54979 === (4))){
var inst_54961 = (state_54978[(8)]);
var inst_54961__$1 = (state_54978[(2)]);
var inst_54962 = (inst_54961__$1 == null);
var state_54978__$1 = (function (){var statearr_54983 = state_54978;
(statearr_54983[(8)] = inst_54961__$1);

return statearr_54983;
})();
if(cljs.core.truth_(inst_54962)){
var statearr_54984_55000 = state_54978__$1;
(statearr_54984_55000[(1)] = (5));

} else {
var statearr_54985_55001 = state_54978__$1;
(statearr_54985_55001[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54979 === (6))){
var inst_54961 = (state_54978[(8)]);
var inst_54958 = (state_54978[(7)]);
var inst_54965 = (state_54978[(9)]);
var inst_54965__$1 = f.call(null,inst_54958,inst_54961);
var inst_54966 = cljs.core.reduced_QMARK_.call(null,inst_54965__$1);
var state_54978__$1 = (function (){var statearr_54986 = state_54978;
(statearr_54986[(9)] = inst_54965__$1);

return statearr_54986;
})();
if(inst_54966){
var statearr_54987_55002 = state_54978__$1;
(statearr_54987_55002[(1)] = (8));

} else {
var statearr_54988_55003 = state_54978__$1;
(statearr_54988_55003[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54979 === (3))){
var inst_54976 = (state_54978[(2)]);
var state_54978__$1 = state_54978;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54978__$1,inst_54976);
} else {
if((state_val_54979 === (2))){
var state_54978__$1 = state_54978;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54978__$1,(4),ch);
} else {
if((state_val_54979 === (9))){
var inst_54965 = (state_54978[(9)]);
var inst_54958 = inst_54965;
var state_54978__$1 = (function (){var statearr_54989 = state_54978;
(statearr_54989[(7)] = inst_54958);

return statearr_54989;
})();
var statearr_54990_55004 = state_54978__$1;
(statearr_54990_55004[(2)] = null);

(statearr_54990_55004[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54979 === (5))){
var inst_54958 = (state_54978[(7)]);
var state_54978__$1 = state_54978;
var statearr_54991_55005 = state_54978__$1;
(statearr_54991_55005[(2)] = inst_54958);

(statearr_54991_55005[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54979 === (10))){
var inst_54972 = (state_54978[(2)]);
var state_54978__$1 = state_54978;
var statearr_54992_55006 = state_54978__$1;
(statearr_54992_55006[(2)] = inst_54972);

(statearr_54992_55006[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54979 === (8))){
var inst_54965 = (state_54978[(9)]);
var inst_54968 = cljs.core.deref.call(null,inst_54965);
var state_54978__$1 = state_54978;
var statearr_54993_55007 = state_54978__$1;
(statearr_54993_55007[(2)] = inst_54968);

(statearr_54993_55007[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__54472__auto__))
;
return ((function (switch__54129__auto__,c__54472__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__54130__auto__ = null;
var cljs$core$async$reduce_$_state_machine__54130__auto____0 = (function (){
var statearr_54994 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54994[(0)] = cljs$core$async$reduce_$_state_machine__54130__auto__);

(statearr_54994[(1)] = (1));

return statearr_54994;
});
var cljs$core$async$reduce_$_state_machine__54130__auto____1 = (function (state_54978){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_54978);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e54995){if((e54995 instanceof Object)){
var ex__54133__auto__ = e54995;
var statearr_54996_55008 = state_54978;
(statearr_54996_55008[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54978);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54995;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55009 = state_54978;
state_54978 = G__55009;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__54130__auto__ = function(state_54978){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__54130__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__54130__auto____1.call(this,state_54978);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__54130__auto____0;
cljs$core$async$reduce_$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__54130__auto____1;
return cljs$core$async$reduce_$_state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto__))
})();
var state__54474__auto__ = (function (){var statearr_54997 = f__54473__auto__.call(null);
(statearr_54997[(6)] = c__54472__auto__);

return statearr_54997;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto__))
);

return c__54472__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__54472__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto__,f__$1){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto__,f__$1){
return (function (state_55015){
var state_val_55016 = (state_55015[(1)]);
if((state_val_55016 === (1))){
var inst_55010 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_55015__$1 = state_55015;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55015__$1,(2),inst_55010);
} else {
if((state_val_55016 === (2))){
var inst_55012 = (state_55015[(2)]);
var inst_55013 = f__$1.call(null,inst_55012);
var state_55015__$1 = state_55015;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55015__$1,inst_55013);
} else {
return null;
}
}
});})(c__54472__auto__,f__$1))
;
return ((function (switch__54129__auto__,c__54472__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__54130__auto__ = null;
var cljs$core$async$transduce_$_state_machine__54130__auto____0 = (function (){
var statearr_55017 = [null,null,null,null,null,null,null];
(statearr_55017[(0)] = cljs$core$async$transduce_$_state_machine__54130__auto__);

(statearr_55017[(1)] = (1));

return statearr_55017;
});
var cljs$core$async$transduce_$_state_machine__54130__auto____1 = (function (state_55015){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_55015);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e55018){if((e55018 instanceof Object)){
var ex__54133__auto__ = e55018;
var statearr_55019_55021 = state_55015;
(statearr_55019_55021[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55015);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55018;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55022 = state_55015;
state_55015 = G__55022;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__54130__auto__ = function(state_55015){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__54130__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__54130__auto____1.call(this,state_55015);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__54130__auto____0;
cljs$core$async$transduce_$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__54130__auto____1;
return cljs$core$async$transduce_$_state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto__,f__$1))
})();
var state__54474__auto__ = (function (){var statearr_55020 = f__54473__auto__.call(null);
(statearr_55020[(6)] = c__54472__auto__);

return statearr_55020;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto__,f__$1))
);

return c__54472__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__55024 = arguments.length;
switch (G__55024) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__54472__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto__){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto__){
return (function (state_55049){
var state_val_55050 = (state_55049[(1)]);
if((state_val_55050 === (7))){
var inst_55031 = (state_55049[(2)]);
var state_55049__$1 = state_55049;
var statearr_55051_55072 = state_55049__$1;
(statearr_55051_55072[(2)] = inst_55031);

(statearr_55051_55072[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55050 === (1))){
var inst_55025 = cljs.core.seq.call(null,coll);
var inst_55026 = inst_55025;
var state_55049__$1 = (function (){var statearr_55052 = state_55049;
(statearr_55052[(7)] = inst_55026);

return statearr_55052;
})();
var statearr_55053_55073 = state_55049__$1;
(statearr_55053_55073[(2)] = null);

(statearr_55053_55073[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55050 === (4))){
var inst_55026 = (state_55049[(7)]);
var inst_55029 = cljs.core.first.call(null,inst_55026);
var state_55049__$1 = state_55049;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55049__$1,(7),ch,inst_55029);
} else {
if((state_val_55050 === (13))){
var inst_55043 = (state_55049[(2)]);
var state_55049__$1 = state_55049;
var statearr_55054_55074 = state_55049__$1;
(statearr_55054_55074[(2)] = inst_55043);

(statearr_55054_55074[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55050 === (6))){
var inst_55034 = (state_55049[(2)]);
var state_55049__$1 = state_55049;
if(cljs.core.truth_(inst_55034)){
var statearr_55055_55075 = state_55049__$1;
(statearr_55055_55075[(1)] = (8));

} else {
var statearr_55056_55076 = state_55049__$1;
(statearr_55056_55076[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55050 === (3))){
var inst_55047 = (state_55049[(2)]);
var state_55049__$1 = state_55049;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55049__$1,inst_55047);
} else {
if((state_val_55050 === (12))){
var state_55049__$1 = state_55049;
var statearr_55057_55077 = state_55049__$1;
(statearr_55057_55077[(2)] = null);

(statearr_55057_55077[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55050 === (2))){
var inst_55026 = (state_55049[(7)]);
var state_55049__$1 = state_55049;
if(cljs.core.truth_(inst_55026)){
var statearr_55058_55078 = state_55049__$1;
(statearr_55058_55078[(1)] = (4));

} else {
var statearr_55059_55079 = state_55049__$1;
(statearr_55059_55079[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55050 === (11))){
var inst_55040 = cljs.core.async.close_BANG_.call(null,ch);
var state_55049__$1 = state_55049;
var statearr_55060_55080 = state_55049__$1;
(statearr_55060_55080[(2)] = inst_55040);

(statearr_55060_55080[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55050 === (9))){
var state_55049__$1 = state_55049;
if(cljs.core.truth_(close_QMARK_)){
var statearr_55061_55081 = state_55049__$1;
(statearr_55061_55081[(1)] = (11));

} else {
var statearr_55062_55082 = state_55049__$1;
(statearr_55062_55082[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55050 === (5))){
var inst_55026 = (state_55049[(7)]);
var state_55049__$1 = state_55049;
var statearr_55063_55083 = state_55049__$1;
(statearr_55063_55083[(2)] = inst_55026);

(statearr_55063_55083[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55050 === (10))){
var inst_55045 = (state_55049[(2)]);
var state_55049__$1 = state_55049;
var statearr_55064_55084 = state_55049__$1;
(statearr_55064_55084[(2)] = inst_55045);

(statearr_55064_55084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55050 === (8))){
var inst_55026 = (state_55049[(7)]);
var inst_55036 = cljs.core.next.call(null,inst_55026);
var inst_55026__$1 = inst_55036;
var state_55049__$1 = (function (){var statearr_55065 = state_55049;
(statearr_55065[(7)] = inst_55026__$1);

return statearr_55065;
})();
var statearr_55066_55085 = state_55049__$1;
(statearr_55066_55085[(2)] = null);

(statearr_55066_55085[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54472__auto__))
;
return ((function (switch__54129__auto__,c__54472__auto__){
return (function() {
var cljs$core$async$state_machine__54130__auto__ = null;
var cljs$core$async$state_machine__54130__auto____0 = (function (){
var statearr_55067 = [null,null,null,null,null,null,null,null];
(statearr_55067[(0)] = cljs$core$async$state_machine__54130__auto__);

(statearr_55067[(1)] = (1));

return statearr_55067;
});
var cljs$core$async$state_machine__54130__auto____1 = (function (state_55049){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_55049);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e55068){if((e55068 instanceof Object)){
var ex__54133__auto__ = e55068;
var statearr_55069_55086 = state_55049;
(statearr_55069_55086[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55049);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55068;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55087 = state_55049;
state_55049 = G__55087;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
cljs$core$async$state_machine__54130__auto__ = function(state_55049){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__54130__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__54130__auto____1.call(this,state_55049);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__54130__auto____0;
cljs$core$async$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__54130__auto____1;
return cljs$core$async$state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto__))
})();
var state__54474__auto__ = (function (){var statearr_55070 = f__54473__auto__.call(null);
(statearr_55070[(6)] = c__54472__auto__);

return statearr_55070;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto__))
);

return c__54472__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__47808__auto__ = (((_ == null))?null:_);
var m__47809__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,_);
} else {
var m__47809__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__47808__auto__ = (((m == null))?null:m);
var m__47809__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__47809__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__47808__auto__ = (((m == null))?null:m);
var m__47809__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,m,ch);
} else {
var m__47809__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__47808__auto__ = (((m == null))?null:m);
var m__47809__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,m);
} else {
var m__47809__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async55088 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async55088 = (function (ch,cs,meta55089){
this.ch = ch;
this.cs = cs;
this.meta55089 = meta55089;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async55088.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_55090,meta55089__$1){
var self__ = this;
var _55090__$1 = this;
return (new cljs.core.async.t_cljs$core$async55088(self__.ch,self__.cs,meta55089__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async55088.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_55090){
var self__ = this;
var _55090__$1 = this;
return self__.meta55089;
});})(cs))
;

cljs.core.async.t_cljs$core$async55088.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55088.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async55088.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55088.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async55088.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async55088.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async55088.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta55089","meta55089",-1559460425,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async55088.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async55088.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async55088";

cljs.core.async.t_cljs$core$async55088.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__47746__auto__,writer__47747__auto__,opt__47748__auto__){
return cljs.core._write.call(null,writer__47747__auto__,"cljs.core.async/t_cljs$core$async55088");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async55088 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async55088(ch__$1,cs__$1,meta55089){
return (new cljs.core.async.t_cljs$core$async55088(ch__$1,cs__$1,meta55089));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async55088(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__54472__auto___55310 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto___55310,cs,m,dchan,dctr,done){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto___55310,cs,m,dchan,dctr,done){
return (function (state_55225){
var state_val_55226 = (state_55225[(1)]);
if((state_val_55226 === (7))){
var inst_55221 = (state_55225[(2)]);
var state_55225__$1 = state_55225;
var statearr_55227_55311 = state_55225__$1;
(statearr_55227_55311[(2)] = inst_55221);

(statearr_55227_55311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (20))){
var inst_55124 = (state_55225[(7)]);
var inst_55136 = cljs.core.first.call(null,inst_55124);
var inst_55137 = cljs.core.nth.call(null,inst_55136,(0),null);
var inst_55138 = cljs.core.nth.call(null,inst_55136,(1),null);
var state_55225__$1 = (function (){var statearr_55228 = state_55225;
(statearr_55228[(8)] = inst_55137);

return statearr_55228;
})();
if(cljs.core.truth_(inst_55138)){
var statearr_55229_55312 = state_55225__$1;
(statearr_55229_55312[(1)] = (22));

} else {
var statearr_55230_55313 = state_55225__$1;
(statearr_55230_55313[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (27))){
var inst_55093 = (state_55225[(9)]);
var inst_55168 = (state_55225[(10)]);
var inst_55166 = (state_55225[(11)]);
var inst_55173 = (state_55225[(12)]);
var inst_55173__$1 = cljs.core._nth.call(null,inst_55166,inst_55168);
var inst_55174 = cljs.core.async.put_BANG_.call(null,inst_55173__$1,inst_55093,done);
var state_55225__$1 = (function (){var statearr_55231 = state_55225;
(statearr_55231[(12)] = inst_55173__$1);

return statearr_55231;
})();
if(cljs.core.truth_(inst_55174)){
var statearr_55232_55314 = state_55225__$1;
(statearr_55232_55314[(1)] = (30));

} else {
var statearr_55233_55315 = state_55225__$1;
(statearr_55233_55315[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (1))){
var state_55225__$1 = state_55225;
var statearr_55234_55316 = state_55225__$1;
(statearr_55234_55316[(2)] = null);

(statearr_55234_55316[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (24))){
var inst_55124 = (state_55225[(7)]);
var inst_55143 = (state_55225[(2)]);
var inst_55144 = cljs.core.next.call(null,inst_55124);
var inst_55102 = inst_55144;
var inst_55103 = null;
var inst_55104 = (0);
var inst_55105 = (0);
var state_55225__$1 = (function (){var statearr_55235 = state_55225;
(statearr_55235[(13)] = inst_55103);

(statearr_55235[(14)] = inst_55143);

(statearr_55235[(15)] = inst_55104);

(statearr_55235[(16)] = inst_55102);

(statearr_55235[(17)] = inst_55105);

return statearr_55235;
})();
var statearr_55236_55317 = state_55225__$1;
(statearr_55236_55317[(2)] = null);

(statearr_55236_55317[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (39))){
var state_55225__$1 = state_55225;
var statearr_55240_55318 = state_55225__$1;
(statearr_55240_55318[(2)] = null);

(statearr_55240_55318[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (4))){
var inst_55093 = (state_55225[(9)]);
var inst_55093__$1 = (state_55225[(2)]);
var inst_55094 = (inst_55093__$1 == null);
var state_55225__$1 = (function (){var statearr_55241 = state_55225;
(statearr_55241[(9)] = inst_55093__$1);

return statearr_55241;
})();
if(cljs.core.truth_(inst_55094)){
var statearr_55242_55319 = state_55225__$1;
(statearr_55242_55319[(1)] = (5));

} else {
var statearr_55243_55320 = state_55225__$1;
(statearr_55243_55320[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (15))){
var inst_55103 = (state_55225[(13)]);
var inst_55104 = (state_55225[(15)]);
var inst_55102 = (state_55225[(16)]);
var inst_55105 = (state_55225[(17)]);
var inst_55120 = (state_55225[(2)]);
var inst_55121 = (inst_55105 + (1));
var tmp55237 = inst_55103;
var tmp55238 = inst_55104;
var tmp55239 = inst_55102;
var inst_55102__$1 = tmp55239;
var inst_55103__$1 = tmp55237;
var inst_55104__$1 = tmp55238;
var inst_55105__$1 = inst_55121;
var state_55225__$1 = (function (){var statearr_55244 = state_55225;
(statearr_55244[(13)] = inst_55103__$1);

(statearr_55244[(15)] = inst_55104__$1);

(statearr_55244[(16)] = inst_55102__$1);

(statearr_55244[(17)] = inst_55105__$1);

(statearr_55244[(18)] = inst_55120);

return statearr_55244;
})();
var statearr_55245_55321 = state_55225__$1;
(statearr_55245_55321[(2)] = null);

(statearr_55245_55321[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (21))){
var inst_55147 = (state_55225[(2)]);
var state_55225__$1 = state_55225;
var statearr_55249_55322 = state_55225__$1;
(statearr_55249_55322[(2)] = inst_55147);

(statearr_55249_55322[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (31))){
var inst_55173 = (state_55225[(12)]);
var inst_55177 = done.call(null,null);
var inst_55178 = cljs.core.async.untap_STAR_.call(null,m,inst_55173);
var state_55225__$1 = (function (){var statearr_55250 = state_55225;
(statearr_55250[(19)] = inst_55177);

return statearr_55250;
})();
var statearr_55251_55323 = state_55225__$1;
(statearr_55251_55323[(2)] = inst_55178);

(statearr_55251_55323[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (32))){
var inst_55167 = (state_55225[(20)]);
var inst_55168 = (state_55225[(10)]);
var inst_55166 = (state_55225[(11)]);
var inst_55165 = (state_55225[(21)]);
var inst_55180 = (state_55225[(2)]);
var inst_55181 = (inst_55168 + (1));
var tmp55246 = inst_55167;
var tmp55247 = inst_55166;
var tmp55248 = inst_55165;
var inst_55165__$1 = tmp55248;
var inst_55166__$1 = tmp55247;
var inst_55167__$1 = tmp55246;
var inst_55168__$1 = inst_55181;
var state_55225__$1 = (function (){var statearr_55252 = state_55225;
(statearr_55252[(20)] = inst_55167__$1);

(statearr_55252[(22)] = inst_55180);

(statearr_55252[(10)] = inst_55168__$1);

(statearr_55252[(11)] = inst_55166__$1);

(statearr_55252[(21)] = inst_55165__$1);

return statearr_55252;
})();
var statearr_55253_55324 = state_55225__$1;
(statearr_55253_55324[(2)] = null);

(statearr_55253_55324[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (40))){
var inst_55193 = (state_55225[(23)]);
var inst_55197 = done.call(null,null);
var inst_55198 = cljs.core.async.untap_STAR_.call(null,m,inst_55193);
var state_55225__$1 = (function (){var statearr_55254 = state_55225;
(statearr_55254[(24)] = inst_55197);

return statearr_55254;
})();
var statearr_55255_55325 = state_55225__$1;
(statearr_55255_55325[(2)] = inst_55198);

(statearr_55255_55325[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (33))){
var inst_55184 = (state_55225[(25)]);
var inst_55186 = cljs.core.chunked_seq_QMARK_.call(null,inst_55184);
var state_55225__$1 = state_55225;
if(inst_55186){
var statearr_55256_55326 = state_55225__$1;
(statearr_55256_55326[(1)] = (36));

} else {
var statearr_55257_55327 = state_55225__$1;
(statearr_55257_55327[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (13))){
var inst_55114 = (state_55225[(26)]);
var inst_55117 = cljs.core.async.close_BANG_.call(null,inst_55114);
var state_55225__$1 = state_55225;
var statearr_55258_55328 = state_55225__$1;
(statearr_55258_55328[(2)] = inst_55117);

(statearr_55258_55328[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (22))){
var inst_55137 = (state_55225[(8)]);
var inst_55140 = cljs.core.async.close_BANG_.call(null,inst_55137);
var state_55225__$1 = state_55225;
var statearr_55259_55329 = state_55225__$1;
(statearr_55259_55329[(2)] = inst_55140);

(statearr_55259_55329[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (36))){
var inst_55184 = (state_55225[(25)]);
var inst_55188 = cljs.core.chunk_first.call(null,inst_55184);
var inst_55189 = cljs.core.chunk_rest.call(null,inst_55184);
var inst_55190 = cljs.core.count.call(null,inst_55188);
var inst_55165 = inst_55189;
var inst_55166 = inst_55188;
var inst_55167 = inst_55190;
var inst_55168 = (0);
var state_55225__$1 = (function (){var statearr_55260 = state_55225;
(statearr_55260[(20)] = inst_55167);

(statearr_55260[(10)] = inst_55168);

(statearr_55260[(11)] = inst_55166);

(statearr_55260[(21)] = inst_55165);

return statearr_55260;
})();
var statearr_55261_55330 = state_55225__$1;
(statearr_55261_55330[(2)] = null);

(statearr_55261_55330[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (41))){
var inst_55184 = (state_55225[(25)]);
var inst_55200 = (state_55225[(2)]);
var inst_55201 = cljs.core.next.call(null,inst_55184);
var inst_55165 = inst_55201;
var inst_55166 = null;
var inst_55167 = (0);
var inst_55168 = (0);
var state_55225__$1 = (function (){var statearr_55262 = state_55225;
(statearr_55262[(20)] = inst_55167);

(statearr_55262[(10)] = inst_55168);

(statearr_55262[(27)] = inst_55200);

(statearr_55262[(11)] = inst_55166);

(statearr_55262[(21)] = inst_55165);

return statearr_55262;
})();
var statearr_55263_55331 = state_55225__$1;
(statearr_55263_55331[(2)] = null);

(statearr_55263_55331[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (43))){
var state_55225__$1 = state_55225;
var statearr_55264_55332 = state_55225__$1;
(statearr_55264_55332[(2)] = null);

(statearr_55264_55332[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (29))){
var inst_55209 = (state_55225[(2)]);
var state_55225__$1 = state_55225;
var statearr_55265_55333 = state_55225__$1;
(statearr_55265_55333[(2)] = inst_55209);

(statearr_55265_55333[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (44))){
var inst_55218 = (state_55225[(2)]);
var state_55225__$1 = (function (){var statearr_55266 = state_55225;
(statearr_55266[(28)] = inst_55218);

return statearr_55266;
})();
var statearr_55267_55334 = state_55225__$1;
(statearr_55267_55334[(2)] = null);

(statearr_55267_55334[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (6))){
var inst_55157 = (state_55225[(29)]);
var inst_55156 = cljs.core.deref.call(null,cs);
var inst_55157__$1 = cljs.core.keys.call(null,inst_55156);
var inst_55158 = cljs.core.count.call(null,inst_55157__$1);
var inst_55159 = cljs.core.reset_BANG_.call(null,dctr,inst_55158);
var inst_55164 = cljs.core.seq.call(null,inst_55157__$1);
var inst_55165 = inst_55164;
var inst_55166 = null;
var inst_55167 = (0);
var inst_55168 = (0);
var state_55225__$1 = (function (){var statearr_55268 = state_55225;
(statearr_55268[(20)] = inst_55167);

(statearr_55268[(29)] = inst_55157__$1);

(statearr_55268[(30)] = inst_55159);

(statearr_55268[(10)] = inst_55168);

(statearr_55268[(11)] = inst_55166);

(statearr_55268[(21)] = inst_55165);

return statearr_55268;
})();
var statearr_55269_55335 = state_55225__$1;
(statearr_55269_55335[(2)] = null);

(statearr_55269_55335[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (28))){
var inst_55165 = (state_55225[(21)]);
var inst_55184 = (state_55225[(25)]);
var inst_55184__$1 = cljs.core.seq.call(null,inst_55165);
var state_55225__$1 = (function (){var statearr_55270 = state_55225;
(statearr_55270[(25)] = inst_55184__$1);

return statearr_55270;
})();
if(inst_55184__$1){
var statearr_55271_55336 = state_55225__$1;
(statearr_55271_55336[(1)] = (33));

} else {
var statearr_55272_55337 = state_55225__$1;
(statearr_55272_55337[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (25))){
var inst_55167 = (state_55225[(20)]);
var inst_55168 = (state_55225[(10)]);
var inst_55170 = (inst_55168 < inst_55167);
var inst_55171 = inst_55170;
var state_55225__$1 = state_55225;
if(cljs.core.truth_(inst_55171)){
var statearr_55273_55338 = state_55225__$1;
(statearr_55273_55338[(1)] = (27));

} else {
var statearr_55274_55339 = state_55225__$1;
(statearr_55274_55339[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (34))){
var state_55225__$1 = state_55225;
var statearr_55275_55340 = state_55225__$1;
(statearr_55275_55340[(2)] = null);

(statearr_55275_55340[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (17))){
var state_55225__$1 = state_55225;
var statearr_55276_55341 = state_55225__$1;
(statearr_55276_55341[(2)] = null);

(statearr_55276_55341[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (3))){
var inst_55223 = (state_55225[(2)]);
var state_55225__$1 = state_55225;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55225__$1,inst_55223);
} else {
if((state_val_55226 === (12))){
var inst_55152 = (state_55225[(2)]);
var state_55225__$1 = state_55225;
var statearr_55277_55342 = state_55225__$1;
(statearr_55277_55342[(2)] = inst_55152);

(statearr_55277_55342[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (2))){
var state_55225__$1 = state_55225;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55225__$1,(4),ch);
} else {
if((state_val_55226 === (23))){
var state_55225__$1 = state_55225;
var statearr_55278_55343 = state_55225__$1;
(statearr_55278_55343[(2)] = null);

(statearr_55278_55343[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (35))){
var inst_55207 = (state_55225[(2)]);
var state_55225__$1 = state_55225;
var statearr_55279_55344 = state_55225__$1;
(statearr_55279_55344[(2)] = inst_55207);

(statearr_55279_55344[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (19))){
var inst_55124 = (state_55225[(7)]);
var inst_55128 = cljs.core.chunk_first.call(null,inst_55124);
var inst_55129 = cljs.core.chunk_rest.call(null,inst_55124);
var inst_55130 = cljs.core.count.call(null,inst_55128);
var inst_55102 = inst_55129;
var inst_55103 = inst_55128;
var inst_55104 = inst_55130;
var inst_55105 = (0);
var state_55225__$1 = (function (){var statearr_55280 = state_55225;
(statearr_55280[(13)] = inst_55103);

(statearr_55280[(15)] = inst_55104);

(statearr_55280[(16)] = inst_55102);

(statearr_55280[(17)] = inst_55105);

return statearr_55280;
})();
var statearr_55281_55345 = state_55225__$1;
(statearr_55281_55345[(2)] = null);

(statearr_55281_55345[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (11))){
var inst_55124 = (state_55225[(7)]);
var inst_55102 = (state_55225[(16)]);
var inst_55124__$1 = cljs.core.seq.call(null,inst_55102);
var state_55225__$1 = (function (){var statearr_55282 = state_55225;
(statearr_55282[(7)] = inst_55124__$1);

return statearr_55282;
})();
if(inst_55124__$1){
var statearr_55283_55346 = state_55225__$1;
(statearr_55283_55346[(1)] = (16));

} else {
var statearr_55284_55347 = state_55225__$1;
(statearr_55284_55347[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (9))){
var inst_55154 = (state_55225[(2)]);
var state_55225__$1 = state_55225;
var statearr_55285_55348 = state_55225__$1;
(statearr_55285_55348[(2)] = inst_55154);

(statearr_55285_55348[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (5))){
var inst_55100 = cljs.core.deref.call(null,cs);
var inst_55101 = cljs.core.seq.call(null,inst_55100);
var inst_55102 = inst_55101;
var inst_55103 = null;
var inst_55104 = (0);
var inst_55105 = (0);
var state_55225__$1 = (function (){var statearr_55286 = state_55225;
(statearr_55286[(13)] = inst_55103);

(statearr_55286[(15)] = inst_55104);

(statearr_55286[(16)] = inst_55102);

(statearr_55286[(17)] = inst_55105);

return statearr_55286;
})();
var statearr_55287_55349 = state_55225__$1;
(statearr_55287_55349[(2)] = null);

(statearr_55287_55349[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (14))){
var state_55225__$1 = state_55225;
var statearr_55288_55350 = state_55225__$1;
(statearr_55288_55350[(2)] = null);

(statearr_55288_55350[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (45))){
var inst_55215 = (state_55225[(2)]);
var state_55225__$1 = state_55225;
var statearr_55289_55351 = state_55225__$1;
(statearr_55289_55351[(2)] = inst_55215);

(statearr_55289_55351[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (26))){
var inst_55157 = (state_55225[(29)]);
var inst_55211 = (state_55225[(2)]);
var inst_55212 = cljs.core.seq.call(null,inst_55157);
var state_55225__$1 = (function (){var statearr_55290 = state_55225;
(statearr_55290[(31)] = inst_55211);

return statearr_55290;
})();
if(inst_55212){
var statearr_55291_55352 = state_55225__$1;
(statearr_55291_55352[(1)] = (42));

} else {
var statearr_55292_55353 = state_55225__$1;
(statearr_55292_55353[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (16))){
var inst_55124 = (state_55225[(7)]);
var inst_55126 = cljs.core.chunked_seq_QMARK_.call(null,inst_55124);
var state_55225__$1 = state_55225;
if(inst_55126){
var statearr_55293_55354 = state_55225__$1;
(statearr_55293_55354[(1)] = (19));

} else {
var statearr_55294_55355 = state_55225__$1;
(statearr_55294_55355[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (38))){
var inst_55204 = (state_55225[(2)]);
var state_55225__$1 = state_55225;
var statearr_55295_55356 = state_55225__$1;
(statearr_55295_55356[(2)] = inst_55204);

(statearr_55295_55356[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (30))){
var state_55225__$1 = state_55225;
var statearr_55296_55357 = state_55225__$1;
(statearr_55296_55357[(2)] = null);

(statearr_55296_55357[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (10))){
var inst_55103 = (state_55225[(13)]);
var inst_55105 = (state_55225[(17)]);
var inst_55113 = cljs.core._nth.call(null,inst_55103,inst_55105);
var inst_55114 = cljs.core.nth.call(null,inst_55113,(0),null);
var inst_55115 = cljs.core.nth.call(null,inst_55113,(1),null);
var state_55225__$1 = (function (){var statearr_55297 = state_55225;
(statearr_55297[(26)] = inst_55114);

return statearr_55297;
})();
if(cljs.core.truth_(inst_55115)){
var statearr_55298_55358 = state_55225__$1;
(statearr_55298_55358[(1)] = (13));

} else {
var statearr_55299_55359 = state_55225__$1;
(statearr_55299_55359[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (18))){
var inst_55150 = (state_55225[(2)]);
var state_55225__$1 = state_55225;
var statearr_55300_55360 = state_55225__$1;
(statearr_55300_55360[(2)] = inst_55150);

(statearr_55300_55360[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (42))){
var state_55225__$1 = state_55225;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55225__$1,(45),dchan);
} else {
if((state_val_55226 === (37))){
var inst_55193 = (state_55225[(23)]);
var inst_55093 = (state_55225[(9)]);
var inst_55184 = (state_55225[(25)]);
var inst_55193__$1 = cljs.core.first.call(null,inst_55184);
var inst_55194 = cljs.core.async.put_BANG_.call(null,inst_55193__$1,inst_55093,done);
var state_55225__$1 = (function (){var statearr_55301 = state_55225;
(statearr_55301[(23)] = inst_55193__$1);

return statearr_55301;
})();
if(cljs.core.truth_(inst_55194)){
var statearr_55302_55361 = state_55225__$1;
(statearr_55302_55361[(1)] = (39));

} else {
var statearr_55303_55362 = state_55225__$1;
(statearr_55303_55362[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55226 === (8))){
var inst_55104 = (state_55225[(15)]);
var inst_55105 = (state_55225[(17)]);
var inst_55107 = (inst_55105 < inst_55104);
var inst_55108 = inst_55107;
var state_55225__$1 = state_55225;
if(cljs.core.truth_(inst_55108)){
var statearr_55304_55363 = state_55225__$1;
(statearr_55304_55363[(1)] = (10));

} else {
var statearr_55305_55364 = state_55225__$1;
(statearr_55305_55364[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54472__auto___55310,cs,m,dchan,dctr,done))
;
return ((function (switch__54129__auto__,c__54472__auto___55310,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__54130__auto__ = null;
var cljs$core$async$mult_$_state_machine__54130__auto____0 = (function (){
var statearr_55306 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55306[(0)] = cljs$core$async$mult_$_state_machine__54130__auto__);

(statearr_55306[(1)] = (1));

return statearr_55306;
});
var cljs$core$async$mult_$_state_machine__54130__auto____1 = (function (state_55225){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_55225);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e55307){if((e55307 instanceof Object)){
var ex__54133__auto__ = e55307;
var statearr_55308_55365 = state_55225;
(statearr_55308_55365[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55225);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55307;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55366 = state_55225;
state_55225 = G__55366;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__54130__auto__ = function(state_55225){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__54130__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__54130__auto____1.call(this,state_55225);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__54130__auto____0;
cljs$core$async$mult_$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__54130__auto____1;
return cljs$core$async$mult_$_state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto___55310,cs,m,dchan,dctr,done))
})();
var state__54474__auto__ = (function (){var statearr_55309 = f__54473__auto__.call(null);
(statearr_55309[(6)] = c__54472__auto___55310);

return statearr_55309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto___55310,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__55368 = arguments.length;
switch (G__55368) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__47808__auto__ = (((m == null))?null:m);
var m__47809__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,m,ch);
} else {
var m__47809__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__47808__auto__ = (((m == null))?null:m);
var m__47809__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,m,ch);
} else {
var m__47809__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__47808__auto__ = (((m == null))?null:m);
var m__47809__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,m);
} else {
var m__47809__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__47808__auto__ = (((m == null))?null:m);
var m__47809__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,m,state_map);
} else {
var m__47809__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__47808__auto__ = (((m == null))?null:m);
var m__47809__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,m,mode);
} else {
var m__47809__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__48361__auto__ = [];
var len__48354__auto___55380 = arguments.length;
var i__48355__auto___55381 = (0);
while(true){
if((i__48355__auto___55381 < len__48354__auto___55380)){
args__48361__auto__.push((arguments[i__48355__auto___55381]));

var G__55382 = (i__48355__auto___55381 + (1));
i__48355__auto___55381 = G__55382;
continue;
} else {
}
break;
}

var argseq__48362__auto__ = ((((3) < args__48361__auto__.length))?(new cljs.core.IndexedSeq(args__48361__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__48362__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__55374){
var map__55375 = p__55374;
var map__55375__$1 = ((((!((map__55375 == null)))?((((map__55375.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55375.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55375):map__55375);
var opts = map__55375__$1;
var statearr_55377_55383 = state;
(statearr_55377_55383[(1)] = cont_block);


var temp__5459__auto__ = cljs.core.async.do_alts.call(null,((function (map__55375,map__55375__$1,opts){
return (function (val){
var statearr_55378_55384 = state;
(statearr_55378_55384[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__55375,map__55375__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5459__auto__)){
var cb = temp__5459__auto__;
var statearr_55379_55385 = state;
(statearr_55379_55385[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq55370){
var G__55371 = cljs.core.first.call(null,seq55370);
var seq55370__$1 = cljs.core.next.call(null,seq55370);
var G__55372 = cljs.core.first.call(null,seq55370__$1);
var seq55370__$2 = cljs.core.next.call(null,seq55370__$1);
var G__55373 = cljs.core.first.call(null,seq55370__$2);
var seq55370__$3 = cljs.core.next.call(null,seq55370__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__55371,G__55372,G__55373,seq55370__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async55386 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async55386 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta55387){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta55387 = meta55387;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async55386.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_55388,meta55387__$1){
var self__ = this;
var _55388__$1 = this;
return (new cljs.core.async.t_cljs$core$async55386(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta55387__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async55386.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_55388){
var self__ = this;
var _55388__$1 = this;
return self__.meta55387;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async55386.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55386.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async55386.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55386.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async55386.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async55386.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async55386.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async55386.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async55386.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta55387","meta55387",-603639275,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async55386.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async55386.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async55386";

cljs.core.async.t_cljs$core$async55386.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__47746__auto__,writer__47747__auto__,opt__47748__auto__){
return cljs.core._write.call(null,writer__47747__auto__,"cljs.core.async/t_cljs$core$async55386");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async55386 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async55386(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta55387){
return (new cljs.core.async.t_cljs$core$async55386(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta55387));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async55386(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__54472__auto___55550 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto___55550,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto___55550,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_55490){
var state_val_55491 = (state_55490[(1)]);
if((state_val_55491 === (7))){
var inst_55405 = (state_55490[(2)]);
var state_55490__$1 = state_55490;
var statearr_55492_55551 = state_55490__$1;
(statearr_55492_55551[(2)] = inst_55405);

(statearr_55492_55551[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (20))){
var inst_55417 = (state_55490[(7)]);
var state_55490__$1 = state_55490;
var statearr_55493_55552 = state_55490__$1;
(statearr_55493_55552[(2)] = inst_55417);

(statearr_55493_55552[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (27))){
var state_55490__$1 = state_55490;
var statearr_55494_55553 = state_55490__$1;
(statearr_55494_55553[(2)] = null);

(statearr_55494_55553[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (1))){
var inst_55392 = (state_55490[(8)]);
var inst_55392__$1 = calc_state.call(null);
var inst_55394 = (inst_55392__$1 == null);
var inst_55395 = cljs.core.not.call(null,inst_55394);
var state_55490__$1 = (function (){var statearr_55495 = state_55490;
(statearr_55495[(8)] = inst_55392__$1);

return statearr_55495;
})();
if(inst_55395){
var statearr_55496_55554 = state_55490__$1;
(statearr_55496_55554[(1)] = (2));

} else {
var statearr_55497_55555 = state_55490__$1;
(statearr_55497_55555[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (24))){
var inst_55441 = (state_55490[(9)]);
var inst_55450 = (state_55490[(10)]);
var inst_55464 = (state_55490[(11)]);
var inst_55464__$1 = inst_55441.call(null,inst_55450);
var state_55490__$1 = (function (){var statearr_55498 = state_55490;
(statearr_55498[(11)] = inst_55464__$1);

return statearr_55498;
})();
if(cljs.core.truth_(inst_55464__$1)){
var statearr_55499_55556 = state_55490__$1;
(statearr_55499_55556[(1)] = (29));

} else {
var statearr_55500_55557 = state_55490__$1;
(statearr_55500_55557[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (4))){
var inst_55408 = (state_55490[(2)]);
var state_55490__$1 = state_55490;
if(cljs.core.truth_(inst_55408)){
var statearr_55501_55558 = state_55490__$1;
(statearr_55501_55558[(1)] = (8));

} else {
var statearr_55502_55559 = state_55490__$1;
(statearr_55502_55559[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (15))){
var inst_55435 = (state_55490[(2)]);
var state_55490__$1 = state_55490;
if(cljs.core.truth_(inst_55435)){
var statearr_55503_55560 = state_55490__$1;
(statearr_55503_55560[(1)] = (19));

} else {
var statearr_55504_55561 = state_55490__$1;
(statearr_55504_55561[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (21))){
var inst_55440 = (state_55490[(12)]);
var inst_55440__$1 = (state_55490[(2)]);
var inst_55441 = cljs.core.get.call(null,inst_55440__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_55442 = cljs.core.get.call(null,inst_55440__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_55443 = cljs.core.get.call(null,inst_55440__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_55490__$1 = (function (){var statearr_55505 = state_55490;
(statearr_55505[(9)] = inst_55441);

(statearr_55505[(13)] = inst_55442);

(statearr_55505[(12)] = inst_55440__$1);

return statearr_55505;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_55490__$1,(22),inst_55443);
} else {
if((state_val_55491 === (31))){
var inst_55472 = (state_55490[(2)]);
var state_55490__$1 = state_55490;
if(cljs.core.truth_(inst_55472)){
var statearr_55506_55562 = state_55490__$1;
(statearr_55506_55562[(1)] = (32));

} else {
var statearr_55507_55563 = state_55490__$1;
(statearr_55507_55563[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (32))){
var inst_55449 = (state_55490[(14)]);
var state_55490__$1 = state_55490;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55490__$1,(35),out,inst_55449);
} else {
if((state_val_55491 === (33))){
var inst_55440 = (state_55490[(12)]);
var inst_55417 = inst_55440;
var state_55490__$1 = (function (){var statearr_55508 = state_55490;
(statearr_55508[(7)] = inst_55417);

return statearr_55508;
})();
var statearr_55509_55564 = state_55490__$1;
(statearr_55509_55564[(2)] = null);

(statearr_55509_55564[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (13))){
var inst_55417 = (state_55490[(7)]);
var inst_55424 = inst_55417.cljs$lang$protocol_mask$partition0$;
var inst_55425 = (inst_55424 & (64));
var inst_55426 = inst_55417.cljs$core$ISeq$;
var inst_55427 = (cljs.core.PROTOCOL_SENTINEL === inst_55426);
var inst_55428 = (inst_55425) || (inst_55427);
var state_55490__$1 = state_55490;
if(cljs.core.truth_(inst_55428)){
var statearr_55510_55565 = state_55490__$1;
(statearr_55510_55565[(1)] = (16));

} else {
var statearr_55511_55566 = state_55490__$1;
(statearr_55511_55566[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (22))){
var inst_55450 = (state_55490[(10)]);
var inst_55449 = (state_55490[(14)]);
var inst_55448 = (state_55490[(2)]);
var inst_55449__$1 = cljs.core.nth.call(null,inst_55448,(0),null);
var inst_55450__$1 = cljs.core.nth.call(null,inst_55448,(1),null);
var inst_55451 = (inst_55449__$1 == null);
var inst_55452 = cljs.core._EQ_.call(null,inst_55450__$1,change);
var inst_55453 = (inst_55451) || (inst_55452);
var state_55490__$1 = (function (){var statearr_55512 = state_55490;
(statearr_55512[(10)] = inst_55450__$1);

(statearr_55512[(14)] = inst_55449__$1);

return statearr_55512;
})();
if(cljs.core.truth_(inst_55453)){
var statearr_55513_55567 = state_55490__$1;
(statearr_55513_55567[(1)] = (23));

} else {
var statearr_55514_55568 = state_55490__$1;
(statearr_55514_55568[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (36))){
var inst_55440 = (state_55490[(12)]);
var inst_55417 = inst_55440;
var state_55490__$1 = (function (){var statearr_55515 = state_55490;
(statearr_55515[(7)] = inst_55417);

return statearr_55515;
})();
var statearr_55516_55569 = state_55490__$1;
(statearr_55516_55569[(2)] = null);

(statearr_55516_55569[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (29))){
var inst_55464 = (state_55490[(11)]);
var state_55490__$1 = state_55490;
var statearr_55517_55570 = state_55490__$1;
(statearr_55517_55570[(2)] = inst_55464);

(statearr_55517_55570[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (6))){
var state_55490__$1 = state_55490;
var statearr_55518_55571 = state_55490__$1;
(statearr_55518_55571[(2)] = false);

(statearr_55518_55571[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (28))){
var inst_55460 = (state_55490[(2)]);
var inst_55461 = calc_state.call(null);
var inst_55417 = inst_55461;
var state_55490__$1 = (function (){var statearr_55519 = state_55490;
(statearr_55519[(15)] = inst_55460);

(statearr_55519[(7)] = inst_55417);

return statearr_55519;
})();
var statearr_55520_55572 = state_55490__$1;
(statearr_55520_55572[(2)] = null);

(statearr_55520_55572[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (25))){
var inst_55486 = (state_55490[(2)]);
var state_55490__$1 = state_55490;
var statearr_55521_55573 = state_55490__$1;
(statearr_55521_55573[(2)] = inst_55486);

(statearr_55521_55573[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (34))){
var inst_55484 = (state_55490[(2)]);
var state_55490__$1 = state_55490;
var statearr_55522_55574 = state_55490__$1;
(statearr_55522_55574[(2)] = inst_55484);

(statearr_55522_55574[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (17))){
var state_55490__$1 = state_55490;
var statearr_55523_55575 = state_55490__$1;
(statearr_55523_55575[(2)] = false);

(statearr_55523_55575[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (3))){
var state_55490__$1 = state_55490;
var statearr_55524_55576 = state_55490__$1;
(statearr_55524_55576[(2)] = false);

(statearr_55524_55576[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (12))){
var inst_55488 = (state_55490[(2)]);
var state_55490__$1 = state_55490;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55490__$1,inst_55488);
} else {
if((state_val_55491 === (2))){
var inst_55392 = (state_55490[(8)]);
var inst_55397 = inst_55392.cljs$lang$protocol_mask$partition0$;
var inst_55398 = (inst_55397 & (64));
var inst_55399 = inst_55392.cljs$core$ISeq$;
var inst_55400 = (cljs.core.PROTOCOL_SENTINEL === inst_55399);
var inst_55401 = (inst_55398) || (inst_55400);
var state_55490__$1 = state_55490;
if(cljs.core.truth_(inst_55401)){
var statearr_55525_55577 = state_55490__$1;
(statearr_55525_55577[(1)] = (5));

} else {
var statearr_55526_55578 = state_55490__$1;
(statearr_55526_55578[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (23))){
var inst_55449 = (state_55490[(14)]);
var inst_55455 = (inst_55449 == null);
var state_55490__$1 = state_55490;
if(cljs.core.truth_(inst_55455)){
var statearr_55527_55579 = state_55490__$1;
(statearr_55527_55579[(1)] = (26));

} else {
var statearr_55528_55580 = state_55490__$1;
(statearr_55528_55580[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (35))){
var inst_55475 = (state_55490[(2)]);
var state_55490__$1 = state_55490;
if(cljs.core.truth_(inst_55475)){
var statearr_55529_55581 = state_55490__$1;
(statearr_55529_55581[(1)] = (36));

} else {
var statearr_55530_55582 = state_55490__$1;
(statearr_55530_55582[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (19))){
var inst_55417 = (state_55490[(7)]);
var inst_55437 = cljs.core.apply.call(null,cljs.core.hash_map,inst_55417);
var state_55490__$1 = state_55490;
var statearr_55531_55583 = state_55490__$1;
(statearr_55531_55583[(2)] = inst_55437);

(statearr_55531_55583[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (11))){
var inst_55417 = (state_55490[(7)]);
var inst_55421 = (inst_55417 == null);
var inst_55422 = cljs.core.not.call(null,inst_55421);
var state_55490__$1 = state_55490;
if(inst_55422){
var statearr_55532_55584 = state_55490__$1;
(statearr_55532_55584[(1)] = (13));

} else {
var statearr_55533_55585 = state_55490__$1;
(statearr_55533_55585[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (9))){
var inst_55392 = (state_55490[(8)]);
var state_55490__$1 = state_55490;
var statearr_55534_55586 = state_55490__$1;
(statearr_55534_55586[(2)] = inst_55392);

(statearr_55534_55586[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (5))){
var state_55490__$1 = state_55490;
var statearr_55535_55587 = state_55490__$1;
(statearr_55535_55587[(2)] = true);

(statearr_55535_55587[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (14))){
var state_55490__$1 = state_55490;
var statearr_55536_55588 = state_55490__$1;
(statearr_55536_55588[(2)] = false);

(statearr_55536_55588[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (26))){
var inst_55450 = (state_55490[(10)]);
var inst_55457 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_55450);
var state_55490__$1 = state_55490;
var statearr_55537_55589 = state_55490__$1;
(statearr_55537_55589[(2)] = inst_55457);

(statearr_55537_55589[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (16))){
var state_55490__$1 = state_55490;
var statearr_55538_55590 = state_55490__$1;
(statearr_55538_55590[(2)] = true);

(statearr_55538_55590[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (38))){
var inst_55480 = (state_55490[(2)]);
var state_55490__$1 = state_55490;
var statearr_55539_55591 = state_55490__$1;
(statearr_55539_55591[(2)] = inst_55480);

(statearr_55539_55591[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (30))){
var inst_55441 = (state_55490[(9)]);
var inst_55450 = (state_55490[(10)]);
var inst_55442 = (state_55490[(13)]);
var inst_55467 = cljs.core.empty_QMARK_.call(null,inst_55441);
var inst_55468 = inst_55442.call(null,inst_55450);
var inst_55469 = cljs.core.not.call(null,inst_55468);
var inst_55470 = (inst_55467) && (inst_55469);
var state_55490__$1 = state_55490;
var statearr_55540_55592 = state_55490__$1;
(statearr_55540_55592[(2)] = inst_55470);

(statearr_55540_55592[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (10))){
var inst_55392 = (state_55490[(8)]);
var inst_55413 = (state_55490[(2)]);
var inst_55414 = cljs.core.get.call(null,inst_55413,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_55415 = cljs.core.get.call(null,inst_55413,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_55416 = cljs.core.get.call(null,inst_55413,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_55417 = inst_55392;
var state_55490__$1 = (function (){var statearr_55541 = state_55490;
(statearr_55541[(16)] = inst_55416);

(statearr_55541[(7)] = inst_55417);

(statearr_55541[(17)] = inst_55414);

(statearr_55541[(18)] = inst_55415);

return statearr_55541;
})();
var statearr_55542_55593 = state_55490__$1;
(statearr_55542_55593[(2)] = null);

(statearr_55542_55593[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (18))){
var inst_55432 = (state_55490[(2)]);
var state_55490__$1 = state_55490;
var statearr_55543_55594 = state_55490__$1;
(statearr_55543_55594[(2)] = inst_55432);

(statearr_55543_55594[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (37))){
var state_55490__$1 = state_55490;
var statearr_55544_55595 = state_55490__$1;
(statearr_55544_55595[(2)] = null);

(statearr_55544_55595[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (8))){
var inst_55392 = (state_55490[(8)]);
var inst_55410 = cljs.core.apply.call(null,cljs.core.hash_map,inst_55392);
var state_55490__$1 = state_55490;
var statearr_55545_55596 = state_55490__$1;
(statearr_55545_55596[(2)] = inst_55410);

(statearr_55545_55596[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54472__auto___55550,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__54129__auto__,c__54472__auto___55550,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__54130__auto__ = null;
var cljs$core$async$mix_$_state_machine__54130__auto____0 = (function (){
var statearr_55546 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55546[(0)] = cljs$core$async$mix_$_state_machine__54130__auto__);

(statearr_55546[(1)] = (1));

return statearr_55546;
});
var cljs$core$async$mix_$_state_machine__54130__auto____1 = (function (state_55490){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_55490);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e55547){if((e55547 instanceof Object)){
var ex__54133__auto__ = e55547;
var statearr_55548_55597 = state_55490;
(statearr_55548_55597[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55490);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55547;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55598 = state_55490;
state_55490 = G__55598;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__54130__auto__ = function(state_55490){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__54130__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__54130__auto____1.call(this,state_55490);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__54130__auto____0;
cljs$core$async$mix_$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__54130__auto____1;
return cljs$core$async$mix_$_state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto___55550,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__54474__auto__ = (function (){var statearr_55549 = f__54473__auto__.call(null);
(statearr_55549[(6)] = c__54472__auto___55550);

return statearr_55549;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto___55550,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__47808__auto__ = (((p == null))?null:p);
var m__47809__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__47809__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__47808__auto__ = (((p == null))?null:p);
var m__47809__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,p,v,ch);
} else {
var m__47809__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__55600 = arguments.length;
switch (G__55600) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__47808__auto__ = (((p == null))?null:p);
var m__47809__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,p);
} else {
var m__47809__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__47808__auto__ = (((p == null))?null:p);
var m__47809__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__47808__auto__)]);
if(!((m__47809__auto__ == null))){
return m__47809__auto__.call(null,p,v);
} else {
var m__47809__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__47809__auto____$1 == null))){
return m__47809__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__55604 = arguments.length;
switch (G__55604) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__47075__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__47075__auto__)){
return or__47075__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__47075__auto__,mults){
return (function (p1__55602_SHARP_){
if(cljs.core.truth_(p1__55602_SHARP_.call(null,topic))){
return p1__55602_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__55602_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__47075__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async55605 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async55605 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta55606){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta55606 = meta55606;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async55605.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_55607,meta55606__$1){
var self__ = this;
var _55607__$1 = this;
return (new cljs.core.async.t_cljs$core$async55605(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta55606__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async55605.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_55607){
var self__ = this;
var _55607__$1 = this;
return self__.meta55606;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async55605.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55605.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async55605.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55605.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async55605.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5459__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5459__auto__)){
var m = temp__5459__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async55605.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async55605.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async55605.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta55606","meta55606",2084368613,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async55605.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async55605.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async55605";

cljs.core.async.t_cljs$core$async55605.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__47746__auto__,writer__47747__auto__,opt__47748__auto__){
return cljs.core._write.call(null,writer__47747__auto__,"cljs.core.async/t_cljs$core$async55605");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async55605 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async55605(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta55606){
return (new cljs.core.async.t_cljs$core$async55605(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta55606));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async55605(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__54472__auto___55725 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto___55725,mults,ensure_mult,p){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto___55725,mults,ensure_mult,p){
return (function (state_55679){
var state_val_55680 = (state_55679[(1)]);
if((state_val_55680 === (7))){
var inst_55675 = (state_55679[(2)]);
var state_55679__$1 = state_55679;
var statearr_55681_55726 = state_55679__$1;
(statearr_55681_55726[(2)] = inst_55675);

(statearr_55681_55726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55680 === (20))){
var state_55679__$1 = state_55679;
var statearr_55682_55727 = state_55679__$1;
(statearr_55682_55727[(2)] = null);

(statearr_55682_55727[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55680 === (1))){
var state_55679__$1 = state_55679;
var statearr_55683_55728 = state_55679__$1;
(statearr_55683_55728[(2)] = null);

(statearr_55683_55728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55680 === (24))){
var inst_55658 = (state_55679[(7)]);
var inst_55667 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_55658);
var state_55679__$1 = state_55679;
var statearr_55684_55729 = state_55679__$1;
(statearr_55684_55729[(2)] = inst_55667);

(statearr_55684_55729[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55680 === (4))){
var inst_55610 = (state_55679[(8)]);
var inst_55610__$1 = (state_55679[(2)]);
var inst_55611 = (inst_55610__$1 == null);
var state_55679__$1 = (function (){var statearr_55685 = state_55679;
(statearr_55685[(8)] = inst_55610__$1);

return statearr_55685;
})();
if(cljs.core.truth_(inst_55611)){
var statearr_55686_55730 = state_55679__$1;
(statearr_55686_55730[(1)] = (5));

} else {
var statearr_55687_55731 = state_55679__$1;
(statearr_55687_55731[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55680 === (15))){
var inst_55652 = (state_55679[(2)]);
var state_55679__$1 = state_55679;
var statearr_55688_55732 = state_55679__$1;
(statearr_55688_55732[(2)] = inst_55652);

(statearr_55688_55732[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55680 === (21))){
var inst_55672 = (state_55679[(2)]);
var state_55679__$1 = (function (){var statearr_55689 = state_55679;
(statearr_55689[(9)] = inst_55672);

return statearr_55689;
})();
var statearr_55690_55733 = state_55679__$1;
(statearr_55690_55733[(2)] = null);

(statearr_55690_55733[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55680 === (13))){
var inst_55634 = (state_55679[(10)]);
var inst_55636 = cljs.core.chunked_seq_QMARK_.call(null,inst_55634);
var state_55679__$1 = state_55679;
if(inst_55636){
var statearr_55691_55734 = state_55679__$1;
(statearr_55691_55734[(1)] = (16));

} else {
var statearr_55692_55735 = state_55679__$1;
(statearr_55692_55735[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55680 === (22))){
var inst_55664 = (state_55679[(2)]);
var state_55679__$1 = state_55679;
if(cljs.core.truth_(inst_55664)){
var statearr_55693_55736 = state_55679__$1;
(statearr_55693_55736[(1)] = (23));

} else {
var statearr_55694_55737 = state_55679__$1;
(statearr_55694_55737[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55680 === (6))){
var inst_55658 = (state_55679[(7)]);
var inst_55660 = (state_55679[(11)]);
var inst_55610 = (state_55679[(8)]);
var inst_55658__$1 = topic_fn.call(null,inst_55610);
var inst_55659 = cljs.core.deref.call(null,mults);
var inst_55660__$1 = cljs.core.get.call(null,inst_55659,inst_55658__$1);
var state_55679__$1 = (function (){var statearr_55695 = state_55679;
(statearr_55695[(7)] = inst_55658__$1);

(statearr_55695[(11)] = inst_55660__$1);

return statearr_55695;
})();
if(cljs.core.truth_(inst_55660__$1)){
var statearr_55696_55738 = state_55679__$1;
(statearr_55696_55738[(1)] = (19));

} else {
var statearr_55697_55739 = state_55679__$1;
(statearr_55697_55739[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55680 === (25))){
var inst_55669 = (state_55679[(2)]);
var state_55679__$1 = state_55679;
var statearr_55698_55740 = state_55679__$1;
(statearr_55698_55740[(2)] = inst_55669);

(statearr_55698_55740[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55680 === (17))){
var inst_55634 = (state_55679[(10)]);
var inst_55643 = cljs.core.first.call(null,inst_55634);
var inst_55644 = cljs.core.async.muxch_STAR_.call(null,inst_55643);
var inst_55645 = cljs.core.async.close_BANG_.call(null,inst_55644);
var inst_55646 = cljs.core.next.call(null,inst_55634);
var inst_55620 = inst_55646;
var inst_55621 = null;
var inst_55622 = (0);
var inst_55623 = (0);
var state_55679__$1 = (function (){var statearr_55699 = state_55679;
(statearr_55699[(12)] = inst_55620);

(statearr_55699[(13)] = inst_55623);

(statearr_55699[(14)] = inst_55621);

(statearr_55699[(15)] = inst_55622);

(statearr_55699[(16)] = inst_55645);

return statearr_55699;
})();
var statearr_55700_55741 = state_55679__$1;
(statearr_55700_55741[(2)] = null);

(statearr_55700_55741[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55680 === (3))){
var inst_55677 = (state_55679[(2)]);
var state_55679__$1 = state_55679;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55679__$1,inst_55677);
} else {
if((state_val_55680 === (12))){
var inst_55654 = (state_55679[(2)]);
var state_55679__$1 = state_55679;
var statearr_55701_55742 = state_55679__$1;
(statearr_55701_55742[(2)] = inst_55654);

(statearr_55701_55742[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55680 === (2))){
var state_55679__$1 = state_55679;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55679__$1,(4),ch);
} else {
if((state_val_55680 === (23))){
var state_55679__$1 = state_55679;
var statearr_55702_55743 = state_55679__$1;
(statearr_55702_55743[(2)] = null);

(statearr_55702_55743[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55680 === (19))){
var inst_55660 = (state_55679[(11)]);
var inst_55610 = (state_55679[(8)]);
var inst_55662 = cljs.core.async.muxch_STAR_.call(null,inst_55660);
var state_55679__$1 = state_55679;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55679__$1,(22),inst_55662,inst_55610);
} else {
if((state_val_55680 === (11))){
var inst_55620 = (state_55679[(12)]);
var inst_55634 = (state_55679[(10)]);
var inst_55634__$1 = cljs.core.seq.call(null,inst_55620);
var state_55679__$1 = (function (){var statearr_55703 = state_55679;
(statearr_55703[(10)] = inst_55634__$1);

return statearr_55703;
})();
if(inst_55634__$1){
var statearr_55704_55744 = state_55679__$1;
(statearr_55704_55744[(1)] = (13));

} else {
var statearr_55705_55745 = state_55679__$1;
(statearr_55705_55745[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55680 === (9))){
var inst_55656 = (state_55679[(2)]);
var state_55679__$1 = state_55679;
var statearr_55706_55746 = state_55679__$1;
(statearr_55706_55746[(2)] = inst_55656);

(statearr_55706_55746[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55680 === (5))){
var inst_55617 = cljs.core.deref.call(null,mults);
var inst_55618 = cljs.core.vals.call(null,inst_55617);
var inst_55619 = cljs.core.seq.call(null,inst_55618);
var inst_55620 = inst_55619;
var inst_55621 = null;
var inst_55622 = (0);
var inst_55623 = (0);
var state_55679__$1 = (function (){var statearr_55707 = state_55679;
(statearr_55707[(12)] = inst_55620);

(statearr_55707[(13)] = inst_55623);

(statearr_55707[(14)] = inst_55621);

(statearr_55707[(15)] = inst_55622);

return statearr_55707;
})();
var statearr_55708_55747 = state_55679__$1;
(statearr_55708_55747[(2)] = null);

(statearr_55708_55747[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55680 === (14))){
var state_55679__$1 = state_55679;
var statearr_55712_55748 = state_55679__$1;
(statearr_55712_55748[(2)] = null);

(statearr_55712_55748[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55680 === (16))){
var inst_55634 = (state_55679[(10)]);
var inst_55638 = cljs.core.chunk_first.call(null,inst_55634);
var inst_55639 = cljs.core.chunk_rest.call(null,inst_55634);
var inst_55640 = cljs.core.count.call(null,inst_55638);
var inst_55620 = inst_55639;
var inst_55621 = inst_55638;
var inst_55622 = inst_55640;
var inst_55623 = (0);
var state_55679__$1 = (function (){var statearr_55713 = state_55679;
(statearr_55713[(12)] = inst_55620);

(statearr_55713[(13)] = inst_55623);

(statearr_55713[(14)] = inst_55621);

(statearr_55713[(15)] = inst_55622);

return statearr_55713;
})();
var statearr_55714_55749 = state_55679__$1;
(statearr_55714_55749[(2)] = null);

(statearr_55714_55749[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55680 === (10))){
var inst_55620 = (state_55679[(12)]);
var inst_55623 = (state_55679[(13)]);
var inst_55621 = (state_55679[(14)]);
var inst_55622 = (state_55679[(15)]);
var inst_55628 = cljs.core._nth.call(null,inst_55621,inst_55623);
var inst_55629 = cljs.core.async.muxch_STAR_.call(null,inst_55628);
var inst_55630 = cljs.core.async.close_BANG_.call(null,inst_55629);
var inst_55631 = (inst_55623 + (1));
var tmp55709 = inst_55620;
var tmp55710 = inst_55621;
var tmp55711 = inst_55622;
var inst_55620__$1 = tmp55709;
var inst_55621__$1 = tmp55710;
var inst_55622__$1 = tmp55711;
var inst_55623__$1 = inst_55631;
var state_55679__$1 = (function (){var statearr_55715 = state_55679;
(statearr_55715[(12)] = inst_55620__$1);

(statearr_55715[(13)] = inst_55623__$1);

(statearr_55715[(14)] = inst_55621__$1);

(statearr_55715[(15)] = inst_55622__$1);

(statearr_55715[(17)] = inst_55630);

return statearr_55715;
})();
var statearr_55716_55750 = state_55679__$1;
(statearr_55716_55750[(2)] = null);

(statearr_55716_55750[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55680 === (18))){
var inst_55649 = (state_55679[(2)]);
var state_55679__$1 = state_55679;
var statearr_55717_55751 = state_55679__$1;
(statearr_55717_55751[(2)] = inst_55649);

(statearr_55717_55751[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55680 === (8))){
var inst_55623 = (state_55679[(13)]);
var inst_55622 = (state_55679[(15)]);
var inst_55625 = (inst_55623 < inst_55622);
var inst_55626 = inst_55625;
var state_55679__$1 = state_55679;
if(cljs.core.truth_(inst_55626)){
var statearr_55718_55752 = state_55679__$1;
(statearr_55718_55752[(1)] = (10));

} else {
var statearr_55719_55753 = state_55679__$1;
(statearr_55719_55753[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54472__auto___55725,mults,ensure_mult,p))
;
return ((function (switch__54129__auto__,c__54472__auto___55725,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__54130__auto__ = null;
var cljs$core$async$state_machine__54130__auto____0 = (function (){
var statearr_55720 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55720[(0)] = cljs$core$async$state_machine__54130__auto__);

(statearr_55720[(1)] = (1));

return statearr_55720;
});
var cljs$core$async$state_machine__54130__auto____1 = (function (state_55679){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_55679);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e55721){if((e55721 instanceof Object)){
var ex__54133__auto__ = e55721;
var statearr_55722_55754 = state_55679;
(statearr_55722_55754[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55679);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55721;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55755 = state_55679;
state_55679 = G__55755;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
cljs$core$async$state_machine__54130__auto__ = function(state_55679){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__54130__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__54130__auto____1.call(this,state_55679);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__54130__auto____0;
cljs$core$async$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__54130__auto____1;
return cljs$core$async$state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto___55725,mults,ensure_mult,p))
})();
var state__54474__auto__ = (function (){var statearr_55723 = f__54473__auto__.call(null);
(statearr_55723[(6)] = c__54472__auto___55725);

return statearr_55723;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto___55725,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__55757 = arguments.length;
switch (G__55757) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__55760 = arguments.length;
switch (G__55760) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__55763 = arguments.length;
switch (G__55763) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__54472__auto___55830 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto___55830,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto___55830,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_55802){
var state_val_55803 = (state_55802[(1)]);
if((state_val_55803 === (7))){
var state_55802__$1 = state_55802;
var statearr_55804_55831 = state_55802__$1;
(statearr_55804_55831[(2)] = null);

(statearr_55804_55831[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55803 === (1))){
var state_55802__$1 = state_55802;
var statearr_55805_55832 = state_55802__$1;
(statearr_55805_55832[(2)] = null);

(statearr_55805_55832[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55803 === (4))){
var inst_55766 = (state_55802[(7)]);
var inst_55768 = (inst_55766 < cnt);
var state_55802__$1 = state_55802;
if(cljs.core.truth_(inst_55768)){
var statearr_55806_55833 = state_55802__$1;
(statearr_55806_55833[(1)] = (6));

} else {
var statearr_55807_55834 = state_55802__$1;
(statearr_55807_55834[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55803 === (15))){
var inst_55798 = (state_55802[(2)]);
var state_55802__$1 = state_55802;
var statearr_55808_55835 = state_55802__$1;
(statearr_55808_55835[(2)] = inst_55798);

(statearr_55808_55835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55803 === (13))){
var inst_55791 = cljs.core.async.close_BANG_.call(null,out);
var state_55802__$1 = state_55802;
var statearr_55809_55836 = state_55802__$1;
(statearr_55809_55836[(2)] = inst_55791);

(statearr_55809_55836[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55803 === (6))){
var state_55802__$1 = state_55802;
var statearr_55810_55837 = state_55802__$1;
(statearr_55810_55837[(2)] = null);

(statearr_55810_55837[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55803 === (3))){
var inst_55800 = (state_55802[(2)]);
var state_55802__$1 = state_55802;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55802__$1,inst_55800);
} else {
if((state_val_55803 === (12))){
var inst_55788 = (state_55802[(8)]);
var inst_55788__$1 = (state_55802[(2)]);
var inst_55789 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_55788__$1);
var state_55802__$1 = (function (){var statearr_55811 = state_55802;
(statearr_55811[(8)] = inst_55788__$1);

return statearr_55811;
})();
if(cljs.core.truth_(inst_55789)){
var statearr_55812_55838 = state_55802__$1;
(statearr_55812_55838[(1)] = (13));

} else {
var statearr_55813_55839 = state_55802__$1;
(statearr_55813_55839[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55803 === (2))){
var inst_55765 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_55766 = (0);
var state_55802__$1 = (function (){var statearr_55814 = state_55802;
(statearr_55814[(7)] = inst_55766);

(statearr_55814[(9)] = inst_55765);

return statearr_55814;
})();
var statearr_55815_55840 = state_55802__$1;
(statearr_55815_55840[(2)] = null);

(statearr_55815_55840[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55803 === (11))){
var inst_55766 = (state_55802[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_55802,(10),Object,null,(9));
var inst_55775 = chs__$1.call(null,inst_55766);
var inst_55776 = done.call(null,inst_55766);
var inst_55777 = cljs.core.async.take_BANG_.call(null,inst_55775,inst_55776);
var state_55802__$1 = state_55802;
var statearr_55816_55841 = state_55802__$1;
(statearr_55816_55841[(2)] = inst_55777);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55802__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55803 === (9))){
var inst_55766 = (state_55802[(7)]);
var inst_55779 = (state_55802[(2)]);
var inst_55780 = (inst_55766 + (1));
var inst_55766__$1 = inst_55780;
var state_55802__$1 = (function (){var statearr_55817 = state_55802;
(statearr_55817[(7)] = inst_55766__$1);

(statearr_55817[(10)] = inst_55779);

return statearr_55817;
})();
var statearr_55818_55842 = state_55802__$1;
(statearr_55818_55842[(2)] = null);

(statearr_55818_55842[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55803 === (5))){
var inst_55786 = (state_55802[(2)]);
var state_55802__$1 = (function (){var statearr_55819 = state_55802;
(statearr_55819[(11)] = inst_55786);

return statearr_55819;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55802__$1,(12),dchan);
} else {
if((state_val_55803 === (14))){
var inst_55788 = (state_55802[(8)]);
var inst_55793 = cljs.core.apply.call(null,f,inst_55788);
var state_55802__$1 = state_55802;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55802__$1,(16),out,inst_55793);
} else {
if((state_val_55803 === (16))){
var inst_55795 = (state_55802[(2)]);
var state_55802__$1 = (function (){var statearr_55820 = state_55802;
(statearr_55820[(12)] = inst_55795);

return statearr_55820;
})();
var statearr_55821_55843 = state_55802__$1;
(statearr_55821_55843[(2)] = null);

(statearr_55821_55843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55803 === (10))){
var inst_55770 = (state_55802[(2)]);
var inst_55771 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_55802__$1 = (function (){var statearr_55822 = state_55802;
(statearr_55822[(13)] = inst_55770);

return statearr_55822;
})();
var statearr_55823_55844 = state_55802__$1;
(statearr_55823_55844[(2)] = inst_55771);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55802__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55803 === (8))){
var inst_55784 = (state_55802[(2)]);
var state_55802__$1 = state_55802;
var statearr_55824_55845 = state_55802__$1;
(statearr_55824_55845[(2)] = inst_55784);

(statearr_55824_55845[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54472__auto___55830,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__54129__auto__,c__54472__auto___55830,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__54130__auto__ = null;
var cljs$core$async$state_machine__54130__auto____0 = (function (){
var statearr_55825 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55825[(0)] = cljs$core$async$state_machine__54130__auto__);

(statearr_55825[(1)] = (1));

return statearr_55825;
});
var cljs$core$async$state_machine__54130__auto____1 = (function (state_55802){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_55802);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e55826){if((e55826 instanceof Object)){
var ex__54133__auto__ = e55826;
var statearr_55827_55846 = state_55802;
(statearr_55827_55846[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55802);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55826;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55847 = state_55802;
state_55802 = G__55847;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
cljs$core$async$state_machine__54130__auto__ = function(state_55802){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__54130__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__54130__auto____1.call(this,state_55802);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__54130__auto____0;
cljs$core$async$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__54130__auto____1;
return cljs$core$async$state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto___55830,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__54474__auto__ = (function (){var statearr_55828 = f__54473__auto__.call(null);
(statearr_55828[(6)] = c__54472__auto___55830);

return statearr_55828;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto___55830,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__55850 = arguments.length;
switch (G__55850) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__54472__auto___55904 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto___55904,out){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto___55904,out){
return (function (state_55882){
var state_val_55883 = (state_55882[(1)]);
if((state_val_55883 === (7))){
var inst_55862 = (state_55882[(7)]);
var inst_55861 = (state_55882[(8)]);
var inst_55861__$1 = (state_55882[(2)]);
var inst_55862__$1 = cljs.core.nth.call(null,inst_55861__$1,(0),null);
var inst_55863 = cljs.core.nth.call(null,inst_55861__$1,(1),null);
var inst_55864 = (inst_55862__$1 == null);
var state_55882__$1 = (function (){var statearr_55884 = state_55882;
(statearr_55884[(7)] = inst_55862__$1);

(statearr_55884[(8)] = inst_55861__$1);

(statearr_55884[(9)] = inst_55863);

return statearr_55884;
})();
if(cljs.core.truth_(inst_55864)){
var statearr_55885_55905 = state_55882__$1;
(statearr_55885_55905[(1)] = (8));

} else {
var statearr_55886_55906 = state_55882__$1;
(statearr_55886_55906[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55883 === (1))){
var inst_55851 = cljs.core.vec.call(null,chs);
var inst_55852 = inst_55851;
var state_55882__$1 = (function (){var statearr_55887 = state_55882;
(statearr_55887[(10)] = inst_55852);

return statearr_55887;
})();
var statearr_55888_55907 = state_55882__$1;
(statearr_55888_55907[(2)] = null);

(statearr_55888_55907[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55883 === (4))){
var inst_55852 = (state_55882[(10)]);
var state_55882__$1 = state_55882;
return cljs.core.async.ioc_alts_BANG_.call(null,state_55882__$1,(7),inst_55852);
} else {
if((state_val_55883 === (6))){
var inst_55878 = (state_55882[(2)]);
var state_55882__$1 = state_55882;
var statearr_55889_55908 = state_55882__$1;
(statearr_55889_55908[(2)] = inst_55878);

(statearr_55889_55908[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55883 === (3))){
var inst_55880 = (state_55882[(2)]);
var state_55882__$1 = state_55882;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55882__$1,inst_55880);
} else {
if((state_val_55883 === (2))){
var inst_55852 = (state_55882[(10)]);
var inst_55854 = cljs.core.count.call(null,inst_55852);
var inst_55855 = (inst_55854 > (0));
var state_55882__$1 = state_55882;
if(cljs.core.truth_(inst_55855)){
var statearr_55891_55909 = state_55882__$1;
(statearr_55891_55909[(1)] = (4));

} else {
var statearr_55892_55910 = state_55882__$1;
(statearr_55892_55910[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55883 === (11))){
var inst_55852 = (state_55882[(10)]);
var inst_55871 = (state_55882[(2)]);
var tmp55890 = inst_55852;
var inst_55852__$1 = tmp55890;
var state_55882__$1 = (function (){var statearr_55893 = state_55882;
(statearr_55893[(10)] = inst_55852__$1);

(statearr_55893[(11)] = inst_55871);

return statearr_55893;
})();
var statearr_55894_55911 = state_55882__$1;
(statearr_55894_55911[(2)] = null);

(statearr_55894_55911[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55883 === (9))){
var inst_55862 = (state_55882[(7)]);
var state_55882__$1 = state_55882;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55882__$1,(11),out,inst_55862);
} else {
if((state_val_55883 === (5))){
var inst_55876 = cljs.core.async.close_BANG_.call(null,out);
var state_55882__$1 = state_55882;
var statearr_55895_55912 = state_55882__$1;
(statearr_55895_55912[(2)] = inst_55876);

(statearr_55895_55912[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55883 === (10))){
var inst_55874 = (state_55882[(2)]);
var state_55882__$1 = state_55882;
var statearr_55896_55913 = state_55882__$1;
(statearr_55896_55913[(2)] = inst_55874);

(statearr_55896_55913[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55883 === (8))){
var inst_55852 = (state_55882[(10)]);
var inst_55862 = (state_55882[(7)]);
var inst_55861 = (state_55882[(8)]);
var inst_55863 = (state_55882[(9)]);
var inst_55866 = (function (){var cs = inst_55852;
var vec__55857 = inst_55861;
var v = inst_55862;
var c = inst_55863;
return ((function (cs,vec__55857,v,c,inst_55852,inst_55862,inst_55861,inst_55863,state_val_55883,c__54472__auto___55904,out){
return (function (p1__55848_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__55848_SHARP_);
});
;})(cs,vec__55857,v,c,inst_55852,inst_55862,inst_55861,inst_55863,state_val_55883,c__54472__auto___55904,out))
})();
var inst_55867 = cljs.core.filterv.call(null,inst_55866,inst_55852);
var inst_55852__$1 = inst_55867;
var state_55882__$1 = (function (){var statearr_55897 = state_55882;
(statearr_55897[(10)] = inst_55852__$1);

return statearr_55897;
})();
var statearr_55898_55914 = state_55882__$1;
(statearr_55898_55914[(2)] = null);

(statearr_55898_55914[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__54472__auto___55904,out))
;
return ((function (switch__54129__auto__,c__54472__auto___55904,out){
return (function() {
var cljs$core$async$state_machine__54130__auto__ = null;
var cljs$core$async$state_machine__54130__auto____0 = (function (){
var statearr_55899 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55899[(0)] = cljs$core$async$state_machine__54130__auto__);

(statearr_55899[(1)] = (1));

return statearr_55899;
});
var cljs$core$async$state_machine__54130__auto____1 = (function (state_55882){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_55882);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e55900){if((e55900 instanceof Object)){
var ex__54133__auto__ = e55900;
var statearr_55901_55915 = state_55882;
(statearr_55901_55915[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55882);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55900;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55916 = state_55882;
state_55882 = G__55916;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
cljs$core$async$state_machine__54130__auto__ = function(state_55882){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__54130__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__54130__auto____1.call(this,state_55882);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__54130__auto____0;
cljs$core$async$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__54130__auto____1;
return cljs$core$async$state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto___55904,out))
})();
var state__54474__auto__ = (function (){var statearr_55902 = f__54473__auto__.call(null);
(statearr_55902[(6)] = c__54472__auto___55904);

return statearr_55902;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto___55904,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__55918 = arguments.length;
switch (G__55918) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__54472__auto___55963 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto___55963,out){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto___55963,out){
return (function (state_55942){
var state_val_55943 = (state_55942[(1)]);
if((state_val_55943 === (7))){
var inst_55924 = (state_55942[(7)]);
var inst_55924__$1 = (state_55942[(2)]);
var inst_55925 = (inst_55924__$1 == null);
var inst_55926 = cljs.core.not.call(null,inst_55925);
var state_55942__$1 = (function (){var statearr_55944 = state_55942;
(statearr_55944[(7)] = inst_55924__$1);

return statearr_55944;
})();
if(inst_55926){
var statearr_55945_55964 = state_55942__$1;
(statearr_55945_55964[(1)] = (8));

} else {
var statearr_55946_55965 = state_55942__$1;
(statearr_55946_55965[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55943 === (1))){
var inst_55919 = (0);
var state_55942__$1 = (function (){var statearr_55947 = state_55942;
(statearr_55947[(8)] = inst_55919);

return statearr_55947;
})();
var statearr_55948_55966 = state_55942__$1;
(statearr_55948_55966[(2)] = null);

(statearr_55948_55966[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55943 === (4))){
var state_55942__$1 = state_55942;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55942__$1,(7),ch);
} else {
if((state_val_55943 === (6))){
var inst_55937 = (state_55942[(2)]);
var state_55942__$1 = state_55942;
var statearr_55949_55967 = state_55942__$1;
(statearr_55949_55967[(2)] = inst_55937);

(statearr_55949_55967[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55943 === (3))){
var inst_55939 = (state_55942[(2)]);
var inst_55940 = cljs.core.async.close_BANG_.call(null,out);
var state_55942__$1 = (function (){var statearr_55950 = state_55942;
(statearr_55950[(9)] = inst_55939);

return statearr_55950;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55942__$1,inst_55940);
} else {
if((state_val_55943 === (2))){
var inst_55919 = (state_55942[(8)]);
var inst_55921 = (inst_55919 < n);
var state_55942__$1 = state_55942;
if(cljs.core.truth_(inst_55921)){
var statearr_55951_55968 = state_55942__$1;
(statearr_55951_55968[(1)] = (4));

} else {
var statearr_55952_55969 = state_55942__$1;
(statearr_55952_55969[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55943 === (11))){
var inst_55919 = (state_55942[(8)]);
var inst_55929 = (state_55942[(2)]);
var inst_55930 = (inst_55919 + (1));
var inst_55919__$1 = inst_55930;
var state_55942__$1 = (function (){var statearr_55953 = state_55942;
(statearr_55953[(8)] = inst_55919__$1);

(statearr_55953[(10)] = inst_55929);

return statearr_55953;
})();
var statearr_55954_55970 = state_55942__$1;
(statearr_55954_55970[(2)] = null);

(statearr_55954_55970[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55943 === (9))){
var state_55942__$1 = state_55942;
var statearr_55955_55971 = state_55942__$1;
(statearr_55955_55971[(2)] = null);

(statearr_55955_55971[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55943 === (5))){
var state_55942__$1 = state_55942;
var statearr_55956_55972 = state_55942__$1;
(statearr_55956_55972[(2)] = null);

(statearr_55956_55972[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55943 === (10))){
var inst_55934 = (state_55942[(2)]);
var state_55942__$1 = state_55942;
var statearr_55957_55973 = state_55942__$1;
(statearr_55957_55973[(2)] = inst_55934);

(statearr_55957_55973[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55943 === (8))){
var inst_55924 = (state_55942[(7)]);
var state_55942__$1 = state_55942;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55942__$1,(11),out,inst_55924);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__54472__auto___55963,out))
;
return ((function (switch__54129__auto__,c__54472__auto___55963,out){
return (function() {
var cljs$core$async$state_machine__54130__auto__ = null;
var cljs$core$async$state_machine__54130__auto____0 = (function (){
var statearr_55958 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_55958[(0)] = cljs$core$async$state_machine__54130__auto__);

(statearr_55958[(1)] = (1));

return statearr_55958;
});
var cljs$core$async$state_machine__54130__auto____1 = (function (state_55942){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_55942);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e55959){if((e55959 instanceof Object)){
var ex__54133__auto__ = e55959;
var statearr_55960_55974 = state_55942;
(statearr_55960_55974[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55942);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55959;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55975 = state_55942;
state_55942 = G__55975;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
cljs$core$async$state_machine__54130__auto__ = function(state_55942){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__54130__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__54130__auto____1.call(this,state_55942);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__54130__auto____0;
cljs$core$async$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__54130__auto____1;
return cljs$core$async$state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto___55963,out))
})();
var state__54474__auto__ = (function (){var statearr_55961 = f__54473__auto__.call(null);
(statearr_55961[(6)] = c__54472__auto___55963);

return statearr_55961;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto___55963,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async55977 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async55977 = (function (f,ch,meta55978){
this.f = f;
this.ch = ch;
this.meta55978 = meta55978;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async55977.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_55979,meta55978__$1){
var self__ = this;
var _55979__$1 = this;
return (new cljs.core.async.t_cljs$core$async55977(self__.f,self__.ch,meta55978__$1));
});

cljs.core.async.t_cljs$core$async55977.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_55979){
var self__ = this;
var _55979__$1 = this;
return self__.meta55978;
});

cljs.core.async.t_cljs$core$async55977.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55977.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async55977.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async55977.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55977.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async55980 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async55980 = (function (f,ch,meta55978,_,fn1,meta55981){
this.f = f;
this.ch = ch;
this.meta55978 = meta55978;
this._ = _;
this.fn1 = fn1;
this.meta55981 = meta55981;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async55980.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_55982,meta55981__$1){
var self__ = this;
var _55982__$1 = this;
return (new cljs.core.async.t_cljs$core$async55980(self__.f,self__.ch,self__.meta55978,self__._,self__.fn1,meta55981__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async55980.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_55982){
var self__ = this;
var _55982__$1 = this;
return self__.meta55981;
});})(___$1))
;

cljs.core.async.t_cljs$core$async55980.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55980.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async55980.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async55980.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__55976_SHARP_){
return f1.call(null,(((p1__55976_SHARP_ == null))?null:self__.f.call(null,p1__55976_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async55980.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta55978","meta55978",-599404866,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async55977","cljs.core.async/t_cljs$core$async55977",1006997992,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta55981","meta55981",316413553,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async55980.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async55980.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async55980";

cljs.core.async.t_cljs$core$async55980.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__47746__auto__,writer__47747__auto__,opt__47748__auto__){
return cljs.core._write.call(null,writer__47747__auto__,"cljs.core.async/t_cljs$core$async55980");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async55980 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async55980(f__$1,ch__$1,meta55978__$1,___$2,fn1__$1,meta55981){
return (new cljs.core.async.t_cljs$core$async55980(f__$1,ch__$1,meta55978__$1,___$2,fn1__$1,meta55981));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async55980(self__.f,self__.ch,self__.meta55978,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__47063__auto__ = ret;
if(cljs.core.truth_(and__47063__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__47063__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async55977.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55977.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async55977.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta55978","meta55978",-599404866,null)], null);
});

cljs.core.async.t_cljs$core$async55977.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async55977.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async55977";

cljs.core.async.t_cljs$core$async55977.cljs$lang$ctorPrWriter = (function (this__47746__auto__,writer__47747__auto__,opt__47748__auto__){
return cljs.core._write.call(null,writer__47747__auto__,"cljs.core.async/t_cljs$core$async55977");
});

cljs.core.async.__GT_t_cljs$core$async55977 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async55977(f__$1,ch__$1,meta55978){
return (new cljs.core.async.t_cljs$core$async55977(f__$1,ch__$1,meta55978));
});

}

return (new cljs.core.async.t_cljs$core$async55977(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async55983 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async55983 = (function (f,ch,meta55984){
this.f = f;
this.ch = ch;
this.meta55984 = meta55984;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async55983.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_55985,meta55984__$1){
var self__ = this;
var _55985__$1 = this;
return (new cljs.core.async.t_cljs$core$async55983(self__.f,self__.ch,meta55984__$1));
});

cljs.core.async.t_cljs$core$async55983.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_55985){
var self__ = this;
var _55985__$1 = this;
return self__.meta55984;
});

cljs.core.async.t_cljs$core$async55983.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55983.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async55983.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55983.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async55983.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55983.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async55983.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta55984","meta55984",-1032808278,null)], null);
});

cljs.core.async.t_cljs$core$async55983.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async55983.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async55983";

cljs.core.async.t_cljs$core$async55983.cljs$lang$ctorPrWriter = (function (this__47746__auto__,writer__47747__auto__,opt__47748__auto__){
return cljs.core._write.call(null,writer__47747__auto__,"cljs.core.async/t_cljs$core$async55983");
});

cljs.core.async.__GT_t_cljs$core$async55983 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async55983(f__$1,ch__$1,meta55984){
return (new cljs.core.async.t_cljs$core$async55983(f__$1,ch__$1,meta55984));
});

}

return (new cljs.core.async.t_cljs$core$async55983(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async55986 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async55986 = (function (p,ch,meta55987){
this.p = p;
this.ch = ch;
this.meta55987 = meta55987;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async55986.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_55988,meta55987__$1){
var self__ = this;
var _55988__$1 = this;
return (new cljs.core.async.t_cljs$core$async55986(self__.p,self__.ch,meta55987__$1));
});

cljs.core.async.t_cljs$core$async55986.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_55988){
var self__ = this;
var _55988__$1 = this;
return self__.meta55987;
});

cljs.core.async.t_cljs$core$async55986.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55986.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async55986.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async55986.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55986.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async55986.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55986.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async55986.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta55987","meta55987",1943379652,null)], null);
});

cljs.core.async.t_cljs$core$async55986.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async55986.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async55986";

cljs.core.async.t_cljs$core$async55986.cljs$lang$ctorPrWriter = (function (this__47746__auto__,writer__47747__auto__,opt__47748__auto__){
return cljs.core._write.call(null,writer__47747__auto__,"cljs.core.async/t_cljs$core$async55986");
});

cljs.core.async.__GT_t_cljs$core$async55986 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async55986(p__$1,ch__$1,meta55987){
return (new cljs.core.async.t_cljs$core$async55986(p__$1,ch__$1,meta55987));
});

}

return (new cljs.core.async.t_cljs$core$async55986(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__55990 = arguments.length;
switch (G__55990) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__54472__auto___56030 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto___56030,out){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto___56030,out){
return (function (state_56011){
var state_val_56012 = (state_56011[(1)]);
if((state_val_56012 === (7))){
var inst_56007 = (state_56011[(2)]);
var state_56011__$1 = state_56011;
var statearr_56013_56031 = state_56011__$1;
(statearr_56013_56031[(2)] = inst_56007);

(statearr_56013_56031[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56012 === (1))){
var state_56011__$1 = state_56011;
var statearr_56014_56032 = state_56011__$1;
(statearr_56014_56032[(2)] = null);

(statearr_56014_56032[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56012 === (4))){
var inst_55993 = (state_56011[(7)]);
var inst_55993__$1 = (state_56011[(2)]);
var inst_55994 = (inst_55993__$1 == null);
var state_56011__$1 = (function (){var statearr_56015 = state_56011;
(statearr_56015[(7)] = inst_55993__$1);

return statearr_56015;
})();
if(cljs.core.truth_(inst_55994)){
var statearr_56016_56033 = state_56011__$1;
(statearr_56016_56033[(1)] = (5));

} else {
var statearr_56017_56034 = state_56011__$1;
(statearr_56017_56034[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56012 === (6))){
var inst_55993 = (state_56011[(7)]);
var inst_55998 = p.call(null,inst_55993);
var state_56011__$1 = state_56011;
if(cljs.core.truth_(inst_55998)){
var statearr_56018_56035 = state_56011__$1;
(statearr_56018_56035[(1)] = (8));

} else {
var statearr_56019_56036 = state_56011__$1;
(statearr_56019_56036[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56012 === (3))){
var inst_56009 = (state_56011[(2)]);
var state_56011__$1 = state_56011;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56011__$1,inst_56009);
} else {
if((state_val_56012 === (2))){
var state_56011__$1 = state_56011;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56011__$1,(4),ch);
} else {
if((state_val_56012 === (11))){
var inst_56001 = (state_56011[(2)]);
var state_56011__$1 = state_56011;
var statearr_56020_56037 = state_56011__$1;
(statearr_56020_56037[(2)] = inst_56001);

(statearr_56020_56037[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56012 === (9))){
var state_56011__$1 = state_56011;
var statearr_56021_56038 = state_56011__$1;
(statearr_56021_56038[(2)] = null);

(statearr_56021_56038[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56012 === (5))){
var inst_55996 = cljs.core.async.close_BANG_.call(null,out);
var state_56011__$1 = state_56011;
var statearr_56022_56039 = state_56011__$1;
(statearr_56022_56039[(2)] = inst_55996);

(statearr_56022_56039[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56012 === (10))){
var inst_56004 = (state_56011[(2)]);
var state_56011__$1 = (function (){var statearr_56023 = state_56011;
(statearr_56023[(8)] = inst_56004);

return statearr_56023;
})();
var statearr_56024_56040 = state_56011__$1;
(statearr_56024_56040[(2)] = null);

(statearr_56024_56040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56012 === (8))){
var inst_55993 = (state_56011[(7)]);
var state_56011__$1 = state_56011;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56011__$1,(11),out,inst_55993);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__54472__auto___56030,out))
;
return ((function (switch__54129__auto__,c__54472__auto___56030,out){
return (function() {
var cljs$core$async$state_machine__54130__auto__ = null;
var cljs$core$async$state_machine__54130__auto____0 = (function (){
var statearr_56025 = [null,null,null,null,null,null,null,null,null];
(statearr_56025[(0)] = cljs$core$async$state_machine__54130__auto__);

(statearr_56025[(1)] = (1));

return statearr_56025;
});
var cljs$core$async$state_machine__54130__auto____1 = (function (state_56011){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_56011);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e56026){if((e56026 instanceof Object)){
var ex__54133__auto__ = e56026;
var statearr_56027_56041 = state_56011;
(statearr_56027_56041[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56011);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56026;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56042 = state_56011;
state_56011 = G__56042;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
cljs$core$async$state_machine__54130__auto__ = function(state_56011){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__54130__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__54130__auto____1.call(this,state_56011);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__54130__auto____0;
cljs$core$async$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__54130__auto____1;
return cljs$core$async$state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto___56030,out))
})();
var state__54474__auto__ = (function (){var statearr_56028 = f__54473__auto__.call(null);
(statearr_56028[(6)] = c__54472__auto___56030);

return statearr_56028;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto___56030,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__56044 = arguments.length;
switch (G__56044) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__54472__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto__){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto__){
return (function (state_56107){
var state_val_56108 = (state_56107[(1)]);
if((state_val_56108 === (7))){
var inst_56103 = (state_56107[(2)]);
var state_56107__$1 = state_56107;
var statearr_56109_56147 = state_56107__$1;
(statearr_56109_56147[(2)] = inst_56103);

(statearr_56109_56147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56108 === (20))){
var inst_56073 = (state_56107[(7)]);
var inst_56084 = (state_56107[(2)]);
var inst_56085 = cljs.core.next.call(null,inst_56073);
var inst_56059 = inst_56085;
var inst_56060 = null;
var inst_56061 = (0);
var inst_56062 = (0);
var state_56107__$1 = (function (){var statearr_56110 = state_56107;
(statearr_56110[(8)] = inst_56060);

(statearr_56110[(9)] = inst_56061);

(statearr_56110[(10)] = inst_56059);

(statearr_56110[(11)] = inst_56062);

(statearr_56110[(12)] = inst_56084);

return statearr_56110;
})();
var statearr_56111_56148 = state_56107__$1;
(statearr_56111_56148[(2)] = null);

(statearr_56111_56148[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56108 === (1))){
var state_56107__$1 = state_56107;
var statearr_56112_56149 = state_56107__$1;
(statearr_56112_56149[(2)] = null);

(statearr_56112_56149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56108 === (4))){
var inst_56048 = (state_56107[(13)]);
var inst_56048__$1 = (state_56107[(2)]);
var inst_56049 = (inst_56048__$1 == null);
var state_56107__$1 = (function (){var statearr_56113 = state_56107;
(statearr_56113[(13)] = inst_56048__$1);

return statearr_56113;
})();
if(cljs.core.truth_(inst_56049)){
var statearr_56114_56150 = state_56107__$1;
(statearr_56114_56150[(1)] = (5));

} else {
var statearr_56115_56151 = state_56107__$1;
(statearr_56115_56151[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56108 === (15))){
var state_56107__$1 = state_56107;
var statearr_56119_56152 = state_56107__$1;
(statearr_56119_56152[(2)] = null);

(statearr_56119_56152[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56108 === (21))){
var state_56107__$1 = state_56107;
var statearr_56120_56153 = state_56107__$1;
(statearr_56120_56153[(2)] = null);

(statearr_56120_56153[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56108 === (13))){
var inst_56060 = (state_56107[(8)]);
var inst_56061 = (state_56107[(9)]);
var inst_56059 = (state_56107[(10)]);
var inst_56062 = (state_56107[(11)]);
var inst_56069 = (state_56107[(2)]);
var inst_56070 = (inst_56062 + (1));
var tmp56116 = inst_56060;
var tmp56117 = inst_56061;
var tmp56118 = inst_56059;
var inst_56059__$1 = tmp56118;
var inst_56060__$1 = tmp56116;
var inst_56061__$1 = tmp56117;
var inst_56062__$1 = inst_56070;
var state_56107__$1 = (function (){var statearr_56121 = state_56107;
(statearr_56121[(14)] = inst_56069);

(statearr_56121[(8)] = inst_56060__$1);

(statearr_56121[(9)] = inst_56061__$1);

(statearr_56121[(10)] = inst_56059__$1);

(statearr_56121[(11)] = inst_56062__$1);

return statearr_56121;
})();
var statearr_56122_56154 = state_56107__$1;
(statearr_56122_56154[(2)] = null);

(statearr_56122_56154[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56108 === (22))){
var state_56107__$1 = state_56107;
var statearr_56123_56155 = state_56107__$1;
(statearr_56123_56155[(2)] = null);

(statearr_56123_56155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56108 === (6))){
var inst_56048 = (state_56107[(13)]);
var inst_56057 = f.call(null,inst_56048);
var inst_56058 = cljs.core.seq.call(null,inst_56057);
var inst_56059 = inst_56058;
var inst_56060 = null;
var inst_56061 = (0);
var inst_56062 = (0);
var state_56107__$1 = (function (){var statearr_56124 = state_56107;
(statearr_56124[(8)] = inst_56060);

(statearr_56124[(9)] = inst_56061);

(statearr_56124[(10)] = inst_56059);

(statearr_56124[(11)] = inst_56062);

return statearr_56124;
})();
var statearr_56125_56156 = state_56107__$1;
(statearr_56125_56156[(2)] = null);

(statearr_56125_56156[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56108 === (17))){
var inst_56073 = (state_56107[(7)]);
var inst_56077 = cljs.core.chunk_first.call(null,inst_56073);
var inst_56078 = cljs.core.chunk_rest.call(null,inst_56073);
var inst_56079 = cljs.core.count.call(null,inst_56077);
var inst_56059 = inst_56078;
var inst_56060 = inst_56077;
var inst_56061 = inst_56079;
var inst_56062 = (0);
var state_56107__$1 = (function (){var statearr_56126 = state_56107;
(statearr_56126[(8)] = inst_56060);

(statearr_56126[(9)] = inst_56061);

(statearr_56126[(10)] = inst_56059);

(statearr_56126[(11)] = inst_56062);

return statearr_56126;
})();
var statearr_56127_56157 = state_56107__$1;
(statearr_56127_56157[(2)] = null);

(statearr_56127_56157[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56108 === (3))){
var inst_56105 = (state_56107[(2)]);
var state_56107__$1 = state_56107;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56107__$1,inst_56105);
} else {
if((state_val_56108 === (12))){
var inst_56093 = (state_56107[(2)]);
var state_56107__$1 = state_56107;
var statearr_56128_56158 = state_56107__$1;
(statearr_56128_56158[(2)] = inst_56093);

(statearr_56128_56158[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56108 === (2))){
var state_56107__$1 = state_56107;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56107__$1,(4),in$);
} else {
if((state_val_56108 === (23))){
var inst_56101 = (state_56107[(2)]);
var state_56107__$1 = state_56107;
var statearr_56129_56159 = state_56107__$1;
(statearr_56129_56159[(2)] = inst_56101);

(statearr_56129_56159[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56108 === (19))){
var inst_56088 = (state_56107[(2)]);
var state_56107__$1 = state_56107;
var statearr_56130_56160 = state_56107__$1;
(statearr_56130_56160[(2)] = inst_56088);

(statearr_56130_56160[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56108 === (11))){
var inst_56059 = (state_56107[(10)]);
var inst_56073 = (state_56107[(7)]);
var inst_56073__$1 = cljs.core.seq.call(null,inst_56059);
var state_56107__$1 = (function (){var statearr_56131 = state_56107;
(statearr_56131[(7)] = inst_56073__$1);

return statearr_56131;
})();
if(inst_56073__$1){
var statearr_56132_56161 = state_56107__$1;
(statearr_56132_56161[(1)] = (14));

} else {
var statearr_56133_56162 = state_56107__$1;
(statearr_56133_56162[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56108 === (9))){
var inst_56095 = (state_56107[(2)]);
var inst_56096 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_56107__$1 = (function (){var statearr_56134 = state_56107;
(statearr_56134[(15)] = inst_56095);

return statearr_56134;
})();
if(cljs.core.truth_(inst_56096)){
var statearr_56135_56163 = state_56107__$1;
(statearr_56135_56163[(1)] = (21));

} else {
var statearr_56136_56164 = state_56107__$1;
(statearr_56136_56164[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56108 === (5))){
var inst_56051 = cljs.core.async.close_BANG_.call(null,out);
var state_56107__$1 = state_56107;
var statearr_56137_56165 = state_56107__$1;
(statearr_56137_56165[(2)] = inst_56051);

(statearr_56137_56165[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56108 === (14))){
var inst_56073 = (state_56107[(7)]);
var inst_56075 = cljs.core.chunked_seq_QMARK_.call(null,inst_56073);
var state_56107__$1 = state_56107;
if(inst_56075){
var statearr_56138_56166 = state_56107__$1;
(statearr_56138_56166[(1)] = (17));

} else {
var statearr_56139_56167 = state_56107__$1;
(statearr_56139_56167[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56108 === (16))){
var inst_56091 = (state_56107[(2)]);
var state_56107__$1 = state_56107;
var statearr_56140_56168 = state_56107__$1;
(statearr_56140_56168[(2)] = inst_56091);

(statearr_56140_56168[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56108 === (10))){
var inst_56060 = (state_56107[(8)]);
var inst_56062 = (state_56107[(11)]);
var inst_56067 = cljs.core._nth.call(null,inst_56060,inst_56062);
var state_56107__$1 = state_56107;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56107__$1,(13),out,inst_56067);
} else {
if((state_val_56108 === (18))){
var inst_56073 = (state_56107[(7)]);
var inst_56082 = cljs.core.first.call(null,inst_56073);
var state_56107__$1 = state_56107;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56107__$1,(20),out,inst_56082);
} else {
if((state_val_56108 === (8))){
var inst_56061 = (state_56107[(9)]);
var inst_56062 = (state_56107[(11)]);
var inst_56064 = (inst_56062 < inst_56061);
var inst_56065 = inst_56064;
var state_56107__$1 = state_56107;
if(cljs.core.truth_(inst_56065)){
var statearr_56141_56169 = state_56107__$1;
(statearr_56141_56169[(1)] = (10));

} else {
var statearr_56142_56170 = state_56107__$1;
(statearr_56142_56170[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54472__auto__))
;
return ((function (switch__54129__auto__,c__54472__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__54130__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__54130__auto____0 = (function (){
var statearr_56143 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56143[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__54130__auto__);

(statearr_56143[(1)] = (1));

return statearr_56143;
});
var cljs$core$async$mapcat_STAR__$_state_machine__54130__auto____1 = (function (state_56107){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_56107);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e56144){if((e56144 instanceof Object)){
var ex__54133__auto__ = e56144;
var statearr_56145_56171 = state_56107;
(statearr_56145_56171[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56107);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56144;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56172 = state_56107;
state_56107 = G__56172;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__54130__auto__ = function(state_56107){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__54130__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__54130__auto____1.call(this,state_56107);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__54130__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__54130__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto__))
})();
var state__54474__auto__ = (function (){var statearr_56146 = f__54473__auto__.call(null);
(statearr_56146[(6)] = c__54472__auto__);

return statearr_56146;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto__))
);

return c__54472__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__56174 = arguments.length;
switch (G__56174) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__56177 = arguments.length;
switch (G__56177) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__56180 = arguments.length;
switch (G__56180) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__54472__auto___56227 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto___56227,out){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto___56227,out){
return (function (state_56204){
var state_val_56205 = (state_56204[(1)]);
if((state_val_56205 === (7))){
var inst_56199 = (state_56204[(2)]);
var state_56204__$1 = state_56204;
var statearr_56206_56228 = state_56204__$1;
(statearr_56206_56228[(2)] = inst_56199);

(statearr_56206_56228[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56205 === (1))){
var inst_56181 = null;
var state_56204__$1 = (function (){var statearr_56207 = state_56204;
(statearr_56207[(7)] = inst_56181);

return statearr_56207;
})();
var statearr_56208_56229 = state_56204__$1;
(statearr_56208_56229[(2)] = null);

(statearr_56208_56229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56205 === (4))){
var inst_56184 = (state_56204[(8)]);
var inst_56184__$1 = (state_56204[(2)]);
var inst_56185 = (inst_56184__$1 == null);
var inst_56186 = cljs.core.not.call(null,inst_56185);
var state_56204__$1 = (function (){var statearr_56209 = state_56204;
(statearr_56209[(8)] = inst_56184__$1);

return statearr_56209;
})();
if(inst_56186){
var statearr_56210_56230 = state_56204__$1;
(statearr_56210_56230[(1)] = (5));

} else {
var statearr_56211_56231 = state_56204__$1;
(statearr_56211_56231[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56205 === (6))){
var state_56204__$1 = state_56204;
var statearr_56212_56232 = state_56204__$1;
(statearr_56212_56232[(2)] = null);

(statearr_56212_56232[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56205 === (3))){
var inst_56201 = (state_56204[(2)]);
var inst_56202 = cljs.core.async.close_BANG_.call(null,out);
var state_56204__$1 = (function (){var statearr_56213 = state_56204;
(statearr_56213[(9)] = inst_56201);

return statearr_56213;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56204__$1,inst_56202);
} else {
if((state_val_56205 === (2))){
var state_56204__$1 = state_56204;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56204__$1,(4),ch);
} else {
if((state_val_56205 === (11))){
var inst_56184 = (state_56204[(8)]);
var inst_56193 = (state_56204[(2)]);
var inst_56181 = inst_56184;
var state_56204__$1 = (function (){var statearr_56214 = state_56204;
(statearr_56214[(10)] = inst_56193);

(statearr_56214[(7)] = inst_56181);

return statearr_56214;
})();
var statearr_56215_56233 = state_56204__$1;
(statearr_56215_56233[(2)] = null);

(statearr_56215_56233[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56205 === (9))){
var inst_56184 = (state_56204[(8)]);
var state_56204__$1 = state_56204;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56204__$1,(11),out,inst_56184);
} else {
if((state_val_56205 === (5))){
var inst_56184 = (state_56204[(8)]);
var inst_56181 = (state_56204[(7)]);
var inst_56188 = cljs.core._EQ_.call(null,inst_56184,inst_56181);
var state_56204__$1 = state_56204;
if(inst_56188){
var statearr_56217_56234 = state_56204__$1;
(statearr_56217_56234[(1)] = (8));

} else {
var statearr_56218_56235 = state_56204__$1;
(statearr_56218_56235[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56205 === (10))){
var inst_56196 = (state_56204[(2)]);
var state_56204__$1 = state_56204;
var statearr_56219_56236 = state_56204__$1;
(statearr_56219_56236[(2)] = inst_56196);

(statearr_56219_56236[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56205 === (8))){
var inst_56181 = (state_56204[(7)]);
var tmp56216 = inst_56181;
var inst_56181__$1 = tmp56216;
var state_56204__$1 = (function (){var statearr_56220 = state_56204;
(statearr_56220[(7)] = inst_56181__$1);

return statearr_56220;
})();
var statearr_56221_56237 = state_56204__$1;
(statearr_56221_56237[(2)] = null);

(statearr_56221_56237[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__54472__auto___56227,out))
;
return ((function (switch__54129__auto__,c__54472__auto___56227,out){
return (function() {
var cljs$core$async$state_machine__54130__auto__ = null;
var cljs$core$async$state_machine__54130__auto____0 = (function (){
var statearr_56222 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_56222[(0)] = cljs$core$async$state_machine__54130__auto__);

(statearr_56222[(1)] = (1));

return statearr_56222;
});
var cljs$core$async$state_machine__54130__auto____1 = (function (state_56204){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_56204);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e56223){if((e56223 instanceof Object)){
var ex__54133__auto__ = e56223;
var statearr_56224_56238 = state_56204;
(statearr_56224_56238[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56204);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56223;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56239 = state_56204;
state_56204 = G__56239;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
cljs$core$async$state_machine__54130__auto__ = function(state_56204){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__54130__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__54130__auto____1.call(this,state_56204);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__54130__auto____0;
cljs$core$async$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__54130__auto____1;
return cljs$core$async$state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto___56227,out))
})();
var state__54474__auto__ = (function (){var statearr_56225 = f__54473__auto__.call(null);
(statearr_56225[(6)] = c__54472__auto___56227);

return statearr_56225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto___56227,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__56241 = arguments.length;
switch (G__56241) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__54472__auto___56307 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto___56307,out){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto___56307,out){
return (function (state_56279){
var state_val_56280 = (state_56279[(1)]);
if((state_val_56280 === (7))){
var inst_56275 = (state_56279[(2)]);
var state_56279__$1 = state_56279;
var statearr_56281_56308 = state_56279__$1;
(statearr_56281_56308[(2)] = inst_56275);

(statearr_56281_56308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56280 === (1))){
var inst_56242 = (new Array(n));
var inst_56243 = inst_56242;
var inst_56244 = (0);
var state_56279__$1 = (function (){var statearr_56282 = state_56279;
(statearr_56282[(7)] = inst_56244);

(statearr_56282[(8)] = inst_56243);

return statearr_56282;
})();
var statearr_56283_56309 = state_56279__$1;
(statearr_56283_56309[(2)] = null);

(statearr_56283_56309[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56280 === (4))){
var inst_56247 = (state_56279[(9)]);
var inst_56247__$1 = (state_56279[(2)]);
var inst_56248 = (inst_56247__$1 == null);
var inst_56249 = cljs.core.not.call(null,inst_56248);
var state_56279__$1 = (function (){var statearr_56284 = state_56279;
(statearr_56284[(9)] = inst_56247__$1);

return statearr_56284;
})();
if(inst_56249){
var statearr_56285_56310 = state_56279__$1;
(statearr_56285_56310[(1)] = (5));

} else {
var statearr_56286_56311 = state_56279__$1;
(statearr_56286_56311[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56280 === (15))){
var inst_56269 = (state_56279[(2)]);
var state_56279__$1 = state_56279;
var statearr_56287_56312 = state_56279__$1;
(statearr_56287_56312[(2)] = inst_56269);

(statearr_56287_56312[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56280 === (13))){
var state_56279__$1 = state_56279;
var statearr_56288_56313 = state_56279__$1;
(statearr_56288_56313[(2)] = null);

(statearr_56288_56313[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56280 === (6))){
var inst_56244 = (state_56279[(7)]);
var inst_56265 = (inst_56244 > (0));
var state_56279__$1 = state_56279;
if(cljs.core.truth_(inst_56265)){
var statearr_56289_56314 = state_56279__$1;
(statearr_56289_56314[(1)] = (12));

} else {
var statearr_56290_56315 = state_56279__$1;
(statearr_56290_56315[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56280 === (3))){
var inst_56277 = (state_56279[(2)]);
var state_56279__$1 = state_56279;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56279__$1,inst_56277);
} else {
if((state_val_56280 === (12))){
var inst_56243 = (state_56279[(8)]);
var inst_56267 = cljs.core.vec.call(null,inst_56243);
var state_56279__$1 = state_56279;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56279__$1,(15),out,inst_56267);
} else {
if((state_val_56280 === (2))){
var state_56279__$1 = state_56279;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56279__$1,(4),ch);
} else {
if((state_val_56280 === (11))){
var inst_56259 = (state_56279[(2)]);
var inst_56260 = (new Array(n));
var inst_56243 = inst_56260;
var inst_56244 = (0);
var state_56279__$1 = (function (){var statearr_56291 = state_56279;
(statearr_56291[(10)] = inst_56259);

(statearr_56291[(7)] = inst_56244);

(statearr_56291[(8)] = inst_56243);

return statearr_56291;
})();
var statearr_56292_56316 = state_56279__$1;
(statearr_56292_56316[(2)] = null);

(statearr_56292_56316[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56280 === (9))){
var inst_56243 = (state_56279[(8)]);
var inst_56257 = cljs.core.vec.call(null,inst_56243);
var state_56279__$1 = state_56279;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56279__$1,(11),out,inst_56257);
} else {
if((state_val_56280 === (5))){
var inst_56252 = (state_56279[(11)]);
var inst_56244 = (state_56279[(7)]);
var inst_56247 = (state_56279[(9)]);
var inst_56243 = (state_56279[(8)]);
var inst_56251 = (inst_56243[inst_56244] = inst_56247);
var inst_56252__$1 = (inst_56244 + (1));
var inst_56253 = (inst_56252__$1 < n);
var state_56279__$1 = (function (){var statearr_56293 = state_56279;
(statearr_56293[(12)] = inst_56251);

(statearr_56293[(11)] = inst_56252__$1);

return statearr_56293;
})();
if(cljs.core.truth_(inst_56253)){
var statearr_56294_56317 = state_56279__$1;
(statearr_56294_56317[(1)] = (8));

} else {
var statearr_56295_56318 = state_56279__$1;
(statearr_56295_56318[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56280 === (14))){
var inst_56272 = (state_56279[(2)]);
var inst_56273 = cljs.core.async.close_BANG_.call(null,out);
var state_56279__$1 = (function (){var statearr_56297 = state_56279;
(statearr_56297[(13)] = inst_56272);

return statearr_56297;
})();
var statearr_56298_56319 = state_56279__$1;
(statearr_56298_56319[(2)] = inst_56273);

(statearr_56298_56319[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56280 === (10))){
var inst_56263 = (state_56279[(2)]);
var state_56279__$1 = state_56279;
var statearr_56299_56320 = state_56279__$1;
(statearr_56299_56320[(2)] = inst_56263);

(statearr_56299_56320[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56280 === (8))){
var inst_56252 = (state_56279[(11)]);
var inst_56243 = (state_56279[(8)]);
var tmp56296 = inst_56243;
var inst_56243__$1 = tmp56296;
var inst_56244 = inst_56252;
var state_56279__$1 = (function (){var statearr_56300 = state_56279;
(statearr_56300[(7)] = inst_56244);

(statearr_56300[(8)] = inst_56243__$1);

return statearr_56300;
})();
var statearr_56301_56321 = state_56279__$1;
(statearr_56301_56321[(2)] = null);

(statearr_56301_56321[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54472__auto___56307,out))
;
return ((function (switch__54129__auto__,c__54472__auto___56307,out){
return (function() {
var cljs$core$async$state_machine__54130__auto__ = null;
var cljs$core$async$state_machine__54130__auto____0 = (function (){
var statearr_56302 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56302[(0)] = cljs$core$async$state_machine__54130__auto__);

(statearr_56302[(1)] = (1));

return statearr_56302;
});
var cljs$core$async$state_machine__54130__auto____1 = (function (state_56279){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_56279);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e56303){if((e56303 instanceof Object)){
var ex__54133__auto__ = e56303;
var statearr_56304_56322 = state_56279;
(statearr_56304_56322[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56279);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56303;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56323 = state_56279;
state_56279 = G__56323;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
cljs$core$async$state_machine__54130__auto__ = function(state_56279){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__54130__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__54130__auto____1.call(this,state_56279);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__54130__auto____0;
cljs$core$async$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__54130__auto____1;
return cljs$core$async$state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto___56307,out))
})();
var state__54474__auto__ = (function (){var statearr_56305 = f__54473__auto__.call(null);
(statearr_56305[(6)] = c__54472__auto___56307);

return statearr_56305;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto___56307,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__56325 = arguments.length;
switch (G__56325) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__54472__auto___56395 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto___56395,out){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto___56395,out){
return (function (state_56367){
var state_val_56368 = (state_56367[(1)]);
if((state_val_56368 === (7))){
var inst_56363 = (state_56367[(2)]);
var state_56367__$1 = state_56367;
var statearr_56369_56396 = state_56367__$1;
(statearr_56369_56396[(2)] = inst_56363);

(statearr_56369_56396[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56368 === (1))){
var inst_56326 = [];
var inst_56327 = inst_56326;
var inst_56328 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_56367__$1 = (function (){var statearr_56370 = state_56367;
(statearr_56370[(7)] = inst_56327);

(statearr_56370[(8)] = inst_56328);

return statearr_56370;
})();
var statearr_56371_56397 = state_56367__$1;
(statearr_56371_56397[(2)] = null);

(statearr_56371_56397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56368 === (4))){
var inst_56331 = (state_56367[(9)]);
var inst_56331__$1 = (state_56367[(2)]);
var inst_56332 = (inst_56331__$1 == null);
var inst_56333 = cljs.core.not.call(null,inst_56332);
var state_56367__$1 = (function (){var statearr_56372 = state_56367;
(statearr_56372[(9)] = inst_56331__$1);

return statearr_56372;
})();
if(inst_56333){
var statearr_56373_56398 = state_56367__$1;
(statearr_56373_56398[(1)] = (5));

} else {
var statearr_56374_56399 = state_56367__$1;
(statearr_56374_56399[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56368 === (15))){
var inst_56357 = (state_56367[(2)]);
var state_56367__$1 = state_56367;
var statearr_56375_56400 = state_56367__$1;
(statearr_56375_56400[(2)] = inst_56357);

(statearr_56375_56400[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56368 === (13))){
var state_56367__$1 = state_56367;
var statearr_56376_56401 = state_56367__$1;
(statearr_56376_56401[(2)] = null);

(statearr_56376_56401[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56368 === (6))){
var inst_56327 = (state_56367[(7)]);
var inst_56352 = inst_56327.length;
var inst_56353 = (inst_56352 > (0));
var state_56367__$1 = state_56367;
if(cljs.core.truth_(inst_56353)){
var statearr_56377_56402 = state_56367__$1;
(statearr_56377_56402[(1)] = (12));

} else {
var statearr_56378_56403 = state_56367__$1;
(statearr_56378_56403[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56368 === (3))){
var inst_56365 = (state_56367[(2)]);
var state_56367__$1 = state_56367;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56367__$1,inst_56365);
} else {
if((state_val_56368 === (12))){
var inst_56327 = (state_56367[(7)]);
var inst_56355 = cljs.core.vec.call(null,inst_56327);
var state_56367__$1 = state_56367;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56367__$1,(15),out,inst_56355);
} else {
if((state_val_56368 === (2))){
var state_56367__$1 = state_56367;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56367__$1,(4),ch);
} else {
if((state_val_56368 === (11))){
var inst_56335 = (state_56367[(10)]);
var inst_56331 = (state_56367[(9)]);
var inst_56345 = (state_56367[(2)]);
var inst_56346 = [];
var inst_56347 = inst_56346.push(inst_56331);
var inst_56327 = inst_56346;
var inst_56328 = inst_56335;
var state_56367__$1 = (function (){var statearr_56379 = state_56367;
(statearr_56379[(7)] = inst_56327);

(statearr_56379[(8)] = inst_56328);

(statearr_56379[(11)] = inst_56345);

(statearr_56379[(12)] = inst_56347);

return statearr_56379;
})();
var statearr_56380_56404 = state_56367__$1;
(statearr_56380_56404[(2)] = null);

(statearr_56380_56404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56368 === (9))){
var inst_56327 = (state_56367[(7)]);
var inst_56343 = cljs.core.vec.call(null,inst_56327);
var state_56367__$1 = state_56367;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_56367__$1,(11),out,inst_56343);
} else {
if((state_val_56368 === (5))){
var inst_56335 = (state_56367[(10)]);
var inst_56331 = (state_56367[(9)]);
var inst_56328 = (state_56367[(8)]);
var inst_56335__$1 = f.call(null,inst_56331);
var inst_56336 = cljs.core._EQ_.call(null,inst_56335__$1,inst_56328);
var inst_56337 = cljs.core.keyword_identical_QMARK_.call(null,inst_56328,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_56338 = (inst_56336) || (inst_56337);
var state_56367__$1 = (function (){var statearr_56381 = state_56367;
(statearr_56381[(10)] = inst_56335__$1);

return statearr_56381;
})();
if(cljs.core.truth_(inst_56338)){
var statearr_56382_56405 = state_56367__$1;
(statearr_56382_56405[(1)] = (8));

} else {
var statearr_56383_56406 = state_56367__$1;
(statearr_56383_56406[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56368 === (14))){
var inst_56360 = (state_56367[(2)]);
var inst_56361 = cljs.core.async.close_BANG_.call(null,out);
var state_56367__$1 = (function (){var statearr_56385 = state_56367;
(statearr_56385[(13)] = inst_56360);

return statearr_56385;
})();
var statearr_56386_56407 = state_56367__$1;
(statearr_56386_56407[(2)] = inst_56361);

(statearr_56386_56407[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56368 === (10))){
var inst_56350 = (state_56367[(2)]);
var state_56367__$1 = state_56367;
var statearr_56387_56408 = state_56367__$1;
(statearr_56387_56408[(2)] = inst_56350);

(statearr_56387_56408[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56368 === (8))){
var inst_56335 = (state_56367[(10)]);
var inst_56331 = (state_56367[(9)]);
var inst_56327 = (state_56367[(7)]);
var inst_56340 = inst_56327.push(inst_56331);
var tmp56384 = inst_56327;
var inst_56327__$1 = tmp56384;
var inst_56328 = inst_56335;
var state_56367__$1 = (function (){var statearr_56388 = state_56367;
(statearr_56388[(14)] = inst_56340);

(statearr_56388[(7)] = inst_56327__$1);

(statearr_56388[(8)] = inst_56328);

return statearr_56388;
})();
var statearr_56389_56409 = state_56367__$1;
(statearr_56389_56409[(2)] = null);

(statearr_56389_56409[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54472__auto___56395,out))
;
return ((function (switch__54129__auto__,c__54472__auto___56395,out){
return (function() {
var cljs$core$async$state_machine__54130__auto__ = null;
var cljs$core$async$state_machine__54130__auto____0 = (function (){
var statearr_56390 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56390[(0)] = cljs$core$async$state_machine__54130__auto__);

(statearr_56390[(1)] = (1));

return statearr_56390;
});
var cljs$core$async$state_machine__54130__auto____1 = (function (state_56367){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_56367);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e56391){if((e56391 instanceof Object)){
var ex__54133__auto__ = e56391;
var statearr_56392_56410 = state_56367;
(statearr_56392_56410[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56367);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56391;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56411 = state_56367;
state_56367 = G__56411;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
cljs$core$async$state_machine__54130__auto__ = function(state_56367){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__54130__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__54130__auto____1.call(this,state_56367);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__54130__auto____0;
cljs$core$async$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__54130__auto____1;
return cljs$core$async$state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto___56395,out))
})();
var state__54474__auto__ = (function (){var statearr_56393 = f__54473__auto__.call(null);
(statearr_56393[(6)] = c__54472__auto___56395);

return statearr_56393;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto___56395,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1509156895871
