// Compiled by ClojureScript 1.9.946 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.13";
figwheel.client.js_stringify = (((typeof JSON !== 'undefined') && (!((JSON.stringify == null))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}catch (e57260){if((e57260 instanceof Error)){
var e = e57260;
return "Error: Unable to stringify";
} else {
throw e57260;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__57263 = arguments.length;
switch (G__57263) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__57261_SHARP_){
if(typeof p1__57261_SHARP_ === 'string'){
return p1__57261_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__57261_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__48361__auto__ = [];
var len__48354__auto___57266 = arguments.length;
var i__48355__auto___57267 = (0);
while(true){
if((i__48355__auto___57267 < len__48354__auto___57266)){
args__48361__auto__.push((arguments[i__48355__auto___57267]));

var G__57268 = (i__48355__auto___57267 + (1));
i__48355__auto___57267 = G__57268;
continue;
} else {
}
break;
}

var argseq__48362__auto__ = ((((0) < args__48361__auto__.length))?(new cljs.core.IndexedSeq(args__48361__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__48362__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq57265){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq57265));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__48361__auto__ = [];
var len__48354__auto___57270 = arguments.length;
var i__48355__auto___57271 = (0);
while(true){
if((i__48355__auto___57271 < len__48354__auto___57270)){
args__48361__auto__.push((arguments[i__48355__auto___57271]));

var G__57272 = (i__48355__auto___57271 + (1));
i__48355__auto___57271 = G__57272;
continue;
} else {
}
break;
}

var argseq__48362__auto__ = ((((0) < args__48361__auto__.length))?(new cljs.core.IndexedSeq(args__48361__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__48362__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq57269){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq57269));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)"].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__57273){
var map__57274 = p__57273;
var map__57274__$1 = ((((!((map__57274 == null)))?((((map__57274.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57274.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57274):map__57274);
var message = cljs.core.get.call(null,map__57274__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__57274__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__47075__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__47075__auto__)){
return or__47075__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__47063__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__47063__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__47063__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__54472__auto___57353 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto___57353,ch){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto___57353,ch){
return (function (state_57325){
var state_val_57326 = (state_57325[(1)]);
if((state_val_57326 === (7))){
var inst_57321 = (state_57325[(2)]);
var state_57325__$1 = state_57325;
var statearr_57327_57354 = state_57325__$1;
(statearr_57327_57354[(2)] = inst_57321);

(statearr_57327_57354[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57326 === (1))){
var state_57325__$1 = state_57325;
var statearr_57328_57355 = state_57325__$1;
(statearr_57328_57355[(2)] = null);

(statearr_57328_57355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57326 === (4))){
var inst_57278 = (state_57325[(7)]);
var inst_57278__$1 = (state_57325[(2)]);
var state_57325__$1 = (function (){var statearr_57329 = state_57325;
(statearr_57329[(7)] = inst_57278__$1);

return statearr_57329;
})();
if(cljs.core.truth_(inst_57278__$1)){
var statearr_57330_57356 = state_57325__$1;
(statearr_57330_57356[(1)] = (5));

} else {
var statearr_57331_57357 = state_57325__$1;
(statearr_57331_57357[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57326 === (15))){
var inst_57285 = (state_57325[(8)]);
var inst_57300 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_57285);
var inst_57301 = cljs.core.first.call(null,inst_57300);
var inst_57302 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_57301);
var inst_57303 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57302)].join('');
var inst_57304 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_57303);
var state_57325__$1 = state_57325;
var statearr_57332_57358 = state_57325__$1;
(statearr_57332_57358[(2)] = inst_57304);

(statearr_57332_57358[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57326 === (13))){
var inst_57309 = (state_57325[(2)]);
var state_57325__$1 = state_57325;
var statearr_57333_57359 = state_57325__$1;
(statearr_57333_57359[(2)] = inst_57309);

(statearr_57333_57359[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57326 === (6))){
var state_57325__$1 = state_57325;
var statearr_57334_57360 = state_57325__$1;
(statearr_57334_57360[(2)] = null);

(statearr_57334_57360[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57326 === (17))){
var inst_57307 = (state_57325[(2)]);
var state_57325__$1 = state_57325;
var statearr_57335_57361 = state_57325__$1;
(statearr_57335_57361[(2)] = inst_57307);

(statearr_57335_57361[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57326 === (3))){
var inst_57323 = (state_57325[(2)]);
var state_57325__$1 = state_57325;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57325__$1,inst_57323);
} else {
if((state_val_57326 === (12))){
var inst_57284 = (state_57325[(9)]);
var inst_57298 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_57284,opts);
var state_57325__$1 = state_57325;
if(cljs.core.truth_(inst_57298)){
var statearr_57336_57362 = state_57325__$1;
(statearr_57336_57362[(1)] = (15));

} else {
var statearr_57337_57363 = state_57325__$1;
(statearr_57337_57363[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57326 === (2))){
var state_57325__$1 = state_57325;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57325__$1,(4),ch);
} else {
if((state_val_57326 === (11))){
var inst_57285 = (state_57325[(8)]);
var inst_57290 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57291 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_57285);
var inst_57292 = cljs.core.async.timeout.call(null,(1000));
var inst_57293 = [inst_57291,inst_57292];
var inst_57294 = (new cljs.core.PersistentVector(null,2,(5),inst_57290,inst_57293,null));
var state_57325__$1 = state_57325;
return cljs.core.async.ioc_alts_BANG_.call(null,state_57325__$1,(14),inst_57294);
} else {
if((state_val_57326 === (9))){
var inst_57285 = (state_57325[(8)]);
var inst_57311 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_57312 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_57285);
var inst_57313 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_57312);
var inst_57314 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57313)].join('');
var inst_57315 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_57314);
var state_57325__$1 = (function (){var statearr_57338 = state_57325;
(statearr_57338[(10)] = inst_57311);

return statearr_57338;
})();
var statearr_57339_57364 = state_57325__$1;
(statearr_57339_57364[(2)] = inst_57315);

(statearr_57339_57364[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57326 === (5))){
var inst_57278 = (state_57325[(7)]);
var inst_57280 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_57281 = (new cljs.core.PersistentArrayMap(null,2,inst_57280,null));
var inst_57282 = (new cljs.core.PersistentHashSet(null,inst_57281,null));
var inst_57283 = figwheel.client.focus_msgs.call(null,inst_57282,inst_57278);
var inst_57284 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_57283);
var inst_57285 = cljs.core.first.call(null,inst_57283);
var inst_57286 = figwheel.client.autoload_QMARK_.call(null);
var state_57325__$1 = (function (){var statearr_57340 = state_57325;
(statearr_57340[(9)] = inst_57284);

(statearr_57340[(8)] = inst_57285);

return statearr_57340;
})();
if(cljs.core.truth_(inst_57286)){
var statearr_57341_57365 = state_57325__$1;
(statearr_57341_57365[(1)] = (8));

} else {
var statearr_57342_57366 = state_57325__$1;
(statearr_57342_57366[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57326 === (14))){
var inst_57296 = (state_57325[(2)]);
var state_57325__$1 = state_57325;
var statearr_57343_57367 = state_57325__$1;
(statearr_57343_57367[(2)] = inst_57296);

(statearr_57343_57367[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57326 === (16))){
var state_57325__$1 = state_57325;
var statearr_57344_57368 = state_57325__$1;
(statearr_57344_57368[(2)] = null);

(statearr_57344_57368[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57326 === (10))){
var inst_57317 = (state_57325[(2)]);
var state_57325__$1 = (function (){var statearr_57345 = state_57325;
(statearr_57345[(11)] = inst_57317);

return statearr_57345;
})();
var statearr_57346_57369 = state_57325__$1;
(statearr_57346_57369[(2)] = null);

(statearr_57346_57369[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57326 === (8))){
var inst_57284 = (state_57325[(9)]);
var inst_57288 = figwheel.client.reload_file_state_QMARK_.call(null,inst_57284,opts);
var state_57325__$1 = state_57325;
if(cljs.core.truth_(inst_57288)){
var statearr_57347_57370 = state_57325__$1;
(statearr_57347_57370[(1)] = (11));

} else {
var statearr_57348_57371 = state_57325__$1;
(statearr_57348_57371[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54472__auto___57353,ch))
;
return ((function (switch__54129__auto__,c__54472__auto___57353,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__54130__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__54130__auto____0 = (function (){
var statearr_57349 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_57349[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__54130__auto__);

(statearr_57349[(1)] = (1));

return statearr_57349;
});
var figwheel$client$file_reloader_plugin_$_state_machine__54130__auto____1 = (function (state_57325){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_57325);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e57350){if((e57350 instanceof Object)){
var ex__54133__auto__ = e57350;
var statearr_57351_57372 = state_57325;
(statearr_57351_57372[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57325);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57350;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57373 = state_57325;
state_57325 = G__57373;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__54130__auto__ = function(state_57325){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__54130__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__54130__auto____1.call(this,state_57325);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloader_plugin_$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__54130__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__54130__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto___57353,ch))
})();
var state__54474__auto__ = (function (){var statearr_57352 = f__54473__auto__.call(null);
(statearr_57352[(6)] = c__54472__auto___57353);

return statearr_57352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto___57353,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__57374_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__57374_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_57376 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_57376){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e57375){if((e57375 instanceof Error)){
var e = e57375;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_57376], null));
} else {
var e = e57375;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_57376))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__57377){
var map__57378 = p__57377;
var map__57378__$1 = ((((!((map__57378 == null)))?((((map__57378.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57378.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57378):map__57378);
var opts = map__57378__$1;
var build_id = cljs.core.get.call(null,map__57378__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__57378,map__57378__$1,opts,build_id){
return (function (p__57380){
var vec__57381 = p__57380;
var seq__57382 = cljs.core.seq.call(null,vec__57381);
var first__57383 = cljs.core.first.call(null,seq__57382);
var seq__57382__$1 = cljs.core.next.call(null,seq__57382);
var map__57384 = first__57383;
var map__57384__$1 = ((((!((map__57384 == null)))?((((map__57384.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57384.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57384):map__57384);
var msg = map__57384__$1;
var msg_name = cljs.core.get.call(null,map__57384__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__57382__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__57381,seq__57382,first__57383,seq__57382__$1,map__57384,map__57384__$1,msg,msg_name,_,map__57378,map__57378__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__57381,seq__57382,first__57383,seq__57382__$1,map__57384,map__57384__$1,msg,msg_name,_,map__57378,map__57378__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__57378,map__57378__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__57386){
var vec__57387 = p__57386;
var seq__57388 = cljs.core.seq.call(null,vec__57387);
var first__57389 = cljs.core.first.call(null,seq__57388);
var seq__57388__$1 = cljs.core.next.call(null,seq__57388);
var map__57390 = first__57389;
var map__57390__$1 = ((((!((map__57390 == null)))?((((map__57390.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57390.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57390):map__57390);
var msg = map__57390__$1;
var msg_name = cljs.core.get.call(null,map__57390__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__57388__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__57392){
var map__57393 = p__57392;
var map__57393__$1 = ((((!((map__57393 == null)))?((((map__57393.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57393.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57393):map__57393);
var on_compile_warning = cljs.core.get.call(null,map__57393__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__57393__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__57393,map__57393__$1,on_compile_warning,on_compile_fail){
return (function (p__57395){
var vec__57396 = p__57395;
var seq__57397 = cljs.core.seq.call(null,vec__57396);
var first__57398 = cljs.core.first.call(null,seq__57397);
var seq__57397__$1 = cljs.core.next.call(null,seq__57397);
var map__57399 = first__57398;
var map__57399__$1 = ((((!((map__57399 == null)))?((((map__57399.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57399.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57399):map__57399);
var msg = map__57399__$1;
var msg_name = cljs.core.get.call(null,map__57399__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__57397__$1;
var pred__57401 = cljs.core._EQ_;
var expr__57402 = msg_name;
if(cljs.core.truth_(pred__57401.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__57402))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__57401.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__57402))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__57393,map__57393__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__54472__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto__,msg_hist,msg_names,msg){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto__,msg_hist,msg_names,msg){
return (function (state_57491){
var state_val_57492 = (state_57491[(1)]);
if((state_val_57492 === (7))){
var inst_57411 = (state_57491[(2)]);
var state_57491__$1 = state_57491;
if(cljs.core.truth_(inst_57411)){
var statearr_57493_57540 = state_57491__$1;
(statearr_57493_57540[(1)] = (8));

} else {
var statearr_57494_57541 = state_57491__$1;
(statearr_57494_57541[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (20))){
var inst_57485 = (state_57491[(2)]);
var state_57491__$1 = state_57491;
var statearr_57495_57542 = state_57491__$1;
(statearr_57495_57542[(2)] = inst_57485);

(statearr_57495_57542[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (27))){
var inst_57481 = (state_57491[(2)]);
var state_57491__$1 = state_57491;
var statearr_57496_57543 = state_57491__$1;
(statearr_57496_57543[(2)] = inst_57481);

(statearr_57496_57543[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (1))){
var inst_57404 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_57491__$1 = state_57491;
if(cljs.core.truth_(inst_57404)){
var statearr_57497_57544 = state_57491__$1;
(statearr_57497_57544[(1)] = (2));

} else {
var statearr_57498_57545 = state_57491__$1;
(statearr_57498_57545[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (24))){
var inst_57483 = (state_57491[(2)]);
var state_57491__$1 = state_57491;
var statearr_57499_57546 = state_57491__$1;
(statearr_57499_57546[(2)] = inst_57483);

(statearr_57499_57546[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (4))){
var inst_57489 = (state_57491[(2)]);
var state_57491__$1 = state_57491;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57491__$1,inst_57489);
} else {
if((state_val_57492 === (15))){
var inst_57487 = (state_57491[(2)]);
var state_57491__$1 = state_57491;
var statearr_57500_57547 = state_57491__$1;
(statearr_57500_57547[(2)] = inst_57487);

(statearr_57500_57547[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (21))){
var inst_57440 = (state_57491[(2)]);
var inst_57441 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_57442 = figwheel.client.auto_jump_to_error.call(null,opts,inst_57441);
var state_57491__$1 = (function (){var statearr_57501 = state_57491;
(statearr_57501[(7)] = inst_57440);

return statearr_57501;
})();
var statearr_57502_57548 = state_57491__$1;
(statearr_57502_57548[(2)] = inst_57442);

(statearr_57502_57548[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (31))){
var inst_57470 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_57491__$1 = state_57491;
if(cljs.core.truth_(inst_57470)){
var statearr_57503_57549 = state_57491__$1;
(statearr_57503_57549[(1)] = (34));

} else {
var statearr_57504_57550 = state_57491__$1;
(statearr_57504_57550[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (32))){
var inst_57479 = (state_57491[(2)]);
var state_57491__$1 = state_57491;
var statearr_57505_57551 = state_57491__$1;
(statearr_57505_57551[(2)] = inst_57479);

(statearr_57505_57551[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (33))){
var inst_57466 = (state_57491[(2)]);
var inst_57467 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_57468 = figwheel.client.auto_jump_to_error.call(null,opts,inst_57467);
var state_57491__$1 = (function (){var statearr_57506 = state_57491;
(statearr_57506[(8)] = inst_57466);

return statearr_57506;
})();
var statearr_57507_57552 = state_57491__$1;
(statearr_57507_57552[(2)] = inst_57468);

(statearr_57507_57552[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (13))){
var inst_57425 = figwheel.client.heads_up.clear.call(null);
var state_57491__$1 = state_57491;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57491__$1,(16),inst_57425);
} else {
if((state_val_57492 === (22))){
var inst_57446 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_57447 = figwheel.client.heads_up.append_warning_message.call(null,inst_57446);
var state_57491__$1 = state_57491;
var statearr_57508_57553 = state_57491__$1;
(statearr_57508_57553[(2)] = inst_57447);

(statearr_57508_57553[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (36))){
var inst_57477 = (state_57491[(2)]);
var state_57491__$1 = state_57491;
var statearr_57509_57554 = state_57491__$1;
(statearr_57509_57554[(2)] = inst_57477);

(statearr_57509_57554[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (29))){
var inst_57457 = (state_57491[(2)]);
var inst_57458 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_57459 = figwheel.client.auto_jump_to_error.call(null,opts,inst_57458);
var state_57491__$1 = (function (){var statearr_57510 = state_57491;
(statearr_57510[(9)] = inst_57457);

return statearr_57510;
})();
var statearr_57511_57555 = state_57491__$1;
(statearr_57511_57555[(2)] = inst_57459);

(statearr_57511_57555[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (6))){
var inst_57406 = (state_57491[(10)]);
var state_57491__$1 = state_57491;
var statearr_57512_57556 = state_57491__$1;
(statearr_57512_57556[(2)] = inst_57406);

(statearr_57512_57556[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (28))){
var inst_57453 = (state_57491[(2)]);
var inst_57454 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_57455 = figwheel.client.heads_up.display_warning.call(null,inst_57454);
var state_57491__$1 = (function (){var statearr_57513 = state_57491;
(statearr_57513[(11)] = inst_57453);

return statearr_57513;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57491__$1,(29),inst_57455);
} else {
if((state_val_57492 === (25))){
var inst_57451 = figwheel.client.heads_up.clear.call(null);
var state_57491__$1 = state_57491;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57491__$1,(28),inst_57451);
} else {
if((state_val_57492 === (34))){
var inst_57472 = figwheel.client.heads_up.flash_loaded.call(null);
var state_57491__$1 = state_57491;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57491__$1,(37),inst_57472);
} else {
if((state_val_57492 === (17))){
var inst_57431 = (state_57491[(2)]);
var inst_57432 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_57433 = figwheel.client.auto_jump_to_error.call(null,opts,inst_57432);
var state_57491__$1 = (function (){var statearr_57514 = state_57491;
(statearr_57514[(12)] = inst_57431);

return statearr_57514;
})();
var statearr_57515_57557 = state_57491__$1;
(statearr_57515_57557[(2)] = inst_57433);

(statearr_57515_57557[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (3))){
var inst_57423 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_57491__$1 = state_57491;
if(cljs.core.truth_(inst_57423)){
var statearr_57516_57558 = state_57491__$1;
(statearr_57516_57558[(1)] = (13));

} else {
var statearr_57517_57559 = state_57491__$1;
(statearr_57517_57559[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (12))){
var inst_57419 = (state_57491[(2)]);
var state_57491__$1 = state_57491;
var statearr_57518_57560 = state_57491__$1;
(statearr_57518_57560[(2)] = inst_57419);

(statearr_57518_57560[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (2))){
var inst_57406 = (state_57491[(10)]);
var inst_57406__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_57491__$1 = (function (){var statearr_57519 = state_57491;
(statearr_57519[(10)] = inst_57406__$1);

return statearr_57519;
})();
if(cljs.core.truth_(inst_57406__$1)){
var statearr_57520_57561 = state_57491__$1;
(statearr_57520_57561[(1)] = (5));

} else {
var statearr_57521_57562 = state_57491__$1;
(statearr_57521_57562[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (23))){
var inst_57449 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_57491__$1 = state_57491;
if(cljs.core.truth_(inst_57449)){
var statearr_57522_57563 = state_57491__$1;
(statearr_57522_57563[(1)] = (25));

} else {
var statearr_57523_57564 = state_57491__$1;
(statearr_57523_57564[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (35))){
var state_57491__$1 = state_57491;
var statearr_57524_57565 = state_57491__$1;
(statearr_57524_57565[(2)] = null);

(statearr_57524_57565[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (19))){
var inst_57444 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_57491__$1 = state_57491;
if(cljs.core.truth_(inst_57444)){
var statearr_57525_57566 = state_57491__$1;
(statearr_57525_57566[(1)] = (22));

} else {
var statearr_57526_57567 = state_57491__$1;
(statearr_57526_57567[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (11))){
var inst_57415 = (state_57491[(2)]);
var state_57491__$1 = state_57491;
var statearr_57527_57568 = state_57491__$1;
(statearr_57527_57568[(2)] = inst_57415);

(statearr_57527_57568[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (9))){
var inst_57417 = figwheel.client.heads_up.clear.call(null);
var state_57491__$1 = state_57491;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57491__$1,(12),inst_57417);
} else {
if((state_val_57492 === (5))){
var inst_57408 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_57491__$1 = state_57491;
var statearr_57528_57569 = state_57491__$1;
(statearr_57528_57569[(2)] = inst_57408);

(statearr_57528_57569[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (14))){
var inst_57435 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_57491__$1 = state_57491;
if(cljs.core.truth_(inst_57435)){
var statearr_57529_57570 = state_57491__$1;
(statearr_57529_57570[(1)] = (18));

} else {
var statearr_57530_57571 = state_57491__$1;
(statearr_57530_57571[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (26))){
var inst_57461 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_57491__$1 = state_57491;
if(cljs.core.truth_(inst_57461)){
var statearr_57531_57572 = state_57491__$1;
(statearr_57531_57572[(1)] = (30));

} else {
var statearr_57532_57573 = state_57491__$1;
(statearr_57532_57573[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (16))){
var inst_57427 = (state_57491[(2)]);
var inst_57428 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_57429 = figwheel.client.heads_up.display_exception.call(null,inst_57428);
var state_57491__$1 = (function (){var statearr_57533 = state_57491;
(statearr_57533[(13)] = inst_57427);

return statearr_57533;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57491__$1,(17),inst_57429);
} else {
if((state_val_57492 === (30))){
var inst_57463 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_57464 = figwheel.client.heads_up.display_warning.call(null,inst_57463);
var state_57491__$1 = state_57491;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57491__$1,(33),inst_57464);
} else {
if((state_val_57492 === (10))){
var inst_57421 = (state_57491[(2)]);
var state_57491__$1 = state_57491;
var statearr_57534_57574 = state_57491__$1;
(statearr_57534_57574[(2)] = inst_57421);

(statearr_57534_57574[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (18))){
var inst_57437 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_57438 = figwheel.client.heads_up.display_exception.call(null,inst_57437);
var state_57491__$1 = state_57491;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57491__$1,(21),inst_57438);
} else {
if((state_val_57492 === (37))){
var inst_57474 = (state_57491[(2)]);
var state_57491__$1 = state_57491;
var statearr_57535_57575 = state_57491__$1;
(statearr_57535_57575[(2)] = inst_57474);

(statearr_57535_57575[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57492 === (8))){
var inst_57413 = figwheel.client.heads_up.flash_loaded.call(null);
var state_57491__$1 = state_57491;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57491__$1,(11),inst_57413);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54472__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__54129__auto__,c__54472__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__54130__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__54130__auto____0 = (function (){
var statearr_57536 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_57536[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__54130__auto__);

(statearr_57536[(1)] = (1));

return statearr_57536;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__54130__auto____1 = (function (state_57491){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_57491);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e57537){if((e57537 instanceof Object)){
var ex__54133__auto__ = e57537;
var statearr_57538_57576 = state_57491;
(statearr_57538_57576[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57491);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57537;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57577 = state_57491;
state_57491 = G__57577;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__54130__auto__ = function(state_57491){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__54130__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__54130__auto____1.call(this,state_57491);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__54130__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__54130__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto__,msg_hist,msg_names,msg))
})();
var state__54474__auto__ = (function (){var statearr_57539 = f__54473__auto__.call(null);
(statearr_57539[(6)] = c__54472__auto__);

return statearr_57539;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto__,msg_hist,msg_names,msg))
);

return c__54472__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__54472__auto___57606 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto___57606,ch){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto___57606,ch){
return (function (state_57592){
var state_val_57593 = (state_57592[(1)]);
if((state_val_57593 === (1))){
var state_57592__$1 = state_57592;
var statearr_57594_57607 = state_57592__$1;
(statearr_57594_57607[(2)] = null);

(statearr_57594_57607[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57593 === (2))){
var state_57592__$1 = state_57592;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57592__$1,(4),ch);
} else {
if((state_val_57593 === (3))){
var inst_57590 = (state_57592[(2)]);
var state_57592__$1 = state_57592;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57592__$1,inst_57590);
} else {
if((state_val_57593 === (4))){
var inst_57580 = (state_57592[(7)]);
var inst_57580__$1 = (state_57592[(2)]);
var state_57592__$1 = (function (){var statearr_57595 = state_57592;
(statearr_57595[(7)] = inst_57580__$1);

return statearr_57595;
})();
if(cljs.core.truth_(inst_57580__$1)){
var statearr_57596_57608 = state_57592__$1;
(statearr_57596_57608[(1)] = (5));

} else {
var statearr_57597_57609 = state_57592__$1;
(statearr_57597_57609[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57593 === (5))){
var inst_57580 = (state_57592[(7)]);
var inst_57582 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_57580);
var state_57592__$1 = state_57592;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57592__$1,(8),inst_57582);
} else {
if((state_val_57593 === (6))){
var state_57592__$1 = state_57592;
var statearr_57598_57610 = state_57592__$1;
(statearr_57598_57610[(2)] = null);

(statearr_57598_57610[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57593 === (7))){
var inst_57588 = (state_57592[(2)]);
var state_57592__$1 = state_57592;
var statearr_57599_57611 = state_57592__$1;
(statearr_57599_57611[(2)] = inst_57588);

(statearr_57599_57611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57593 === (8))){
var inst_57584 = (state_57592[(2)]);
var state_57592__$1 = (function (){var statearr_57600 = state_57592;
(statearr_57600[(8)] = inst_57584);

return statearr_57600;
})();
var statearr_57601_57612 = state_57592__$1;
(statearr_57601_57612[(2)] = null);

(statearr_57601_57612[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__54472__auto___57606,ch))
;
return ((function (switch__54129__auto__,c__54472__auto___57606,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__54130__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__54130__auto____0 = (function (){
var statearr_57602 = [null,null,null,null,null,null,null,null,null];
(statearr_57602[(0)] = figwheel$client$heads_up_plugin_$_state_machine__54130__auto__);

(statearr_57602[(1)] = (1));

return statearr_57602;
});
var figwheel$client$heads_up_plugin_$_state_machine__54130__auto____1 = (function (state_57592){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_57592);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e57603){if((e57603 instanceof Object)){
var ex__54133__auto__ = e57603;
var statearr_57604_57613 = state_57592;
(statearr_57604_57613[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57592);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57603;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57614 = state_57592;
state_57592 = G__57614;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__54130__auto__ = function(state_57592){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__54130__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__54130__auto____1.call(this,state_57592);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__54130__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__54130__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto___57606,ch))
})();
var state__54474__auto__ = (function (){var statearr_57605 = f__54473__auto__.call(null);
(statearr_57605[(6)] = c__54472__auto___57606);

return statearr_57605;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto___57606,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__54472__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto__){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto__){
return (function (state_57620){
var state_val_57621 = (state_57620[(1)]);
if((state_val_57621 === (1))){
var inst_57615 = cljs.core.async.timeout.call(null,(3000));
var state_57620__$1 = state_57620;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57620__$1,(2),inst_57615);
} else {
if((state_val_57621 === (2))){
var inst_57617 = (state_57620[(2)]);
var inst_57618 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_57620__$1 = (function (){var statearr_57622 = state_57620;
(statearr_57622[(7)] = inst_57617);

return statearr_57622;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57620__$1,inst_57618);
} else {
return null;
}
}
});})(c__54472__auto__))
;
return ((function (switch__54129__auto__,c__54472__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__54130__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__54130__auto____0 = (function (){
var statearr_57623 = [null,null,null,null,null,null,null,null];
(statearr_57623[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__54130__auto__);

(statearr_57623[(1)] = (1));

return statearr_57623;
});
var figwheel$client$enforce_project_plugin_$_state_machine__54130__auto____1 = (function (state_57620){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_57620);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e57624){if((e57624 instanceof Object)){
var ex__54133__auto__ = e57624;
var statearr_57625_57627 = state_57620;
(statearr_57625_57627[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57620);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57624;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57628 = state_57620;
state_57620 = G__57628;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__54130__auto__ = function(state_57620){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__54130__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__54130__auto____1.call(this,state_57620);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_project_plugin_$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__54130__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__54130__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto__))
})();
var state__54474__auto__ = (function (){var statearr_57626 = f__54473__auto__.call(null);
(statearr_57626[(6)] = c__54472__auto__);

return statearr_57626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto__))
);

return c__54472__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__5459__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__5459__auto__)){
var figwheel_version = temp__5459__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__54472__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto__,figwheel_version,temp__5459__auto__){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto__,figwheel_version,temp__5459__auto__){
return (function (state_57635){
var state_val_57636 = (state_57635[(1)]);
if((state_val_57636 === (1))){
var inst_57629 = cljs.core.async.timeout.call(null,(2000));
var state_57635__$1 = state_57635;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57635__$1,(2),inst_57629);
} else {
if((state_val_57636 === (2))){
var inst_57631 = (state_57635[(2)]);
var inst_57632 = ["Figwheel Client Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_57633 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_57632);
var state_57635__$1 = (function (){var statearr_57637 = state_57635;
(statearr_57637[(7)] = inst_57631);

return statearr_57637;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57635__$1,inst_57633);
} else {
return null;
}
}
});})(c__54472__auto__,figwheel_version,temp__5459__auto__))
;
return ((function (switch__54129__auto__,c__54472__auto__,figwheel_version,temp__5459__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__54130__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__54130__auto____0 = (function (){
var statearr_57638 = [null,null,null,null,null,null,null,null];
(statearr_57638[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__54130__auto__);

(statearr_57638[(1)] = (1));

return statearr_57638;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__54130__auto____1 = (function (state_57635){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_57635);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e57639){if((e57639 instanceof Object)){
var ex__54133__auto__ = e57639;
var statearr_57640_57642 = state_57635;
(statearr_57640_57642[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57635);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57639;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57643 = state_57635;
state_57635 = G__57643;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__54130__auto__ = function(state_57635){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__54130__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__54130__auto____1.call(this,state_57635);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__54130__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__54130__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto__,figwheel_version,temp__5459__auto__))
})();
var state__54474__auto__ = (function (){var statearr_57641 = f__54473__auto__.call(null);
(statearr_57641[(6)] = c__54472__auto__);

return statearr_57641;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto__,figwheel_version,temp__5459__auto__))
);

return c__54472__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__57644){
var map__57645 = p__57644;
var map__57645__$1 = ((((!((map__57645 == null)))?((((map__57645.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57645.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57645):map__57645);
var file = cljs.core.get.call(null,map__57645__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__57645__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__57645__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__57647 = "";
var G__57647__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__57647),"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__57647);
var G__57647__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__57647__$1)," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__57647__$1);
if(cljs.core.truth_((function (){var and__47063__auto__ = line;
if(cljs.core.truth_(and__47063__auto__)){
return column;
} else {
return and__47063__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__57647__$2),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__57647__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__57648){
var map__57649 = p__57648;
var map__57649__$1 = ((((!((map__57649 == null)))?((((map__57649.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57649.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57649):map__57649);
var ed = map__57649__$1;
var formatted_exception = cljs.core.get.call(null,map__57649__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__57649__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__57649__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__57651_57655 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__57652_57656 = null;
var count__57653_57657 = (0);
var i__57654_57658 = (0);
while(true){
if((i__57654_57658 < count__57653_57657)){
var msg_57659 = cljs.core._nth.call(null,chunk__57652_57656,i__57654_57658);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_57659);

var G__57660 = seq__57651_57655;
var G__57661 = chunk__57652_57656;
var G__57662 = count__57653_57657;
var G__57663 = (i__57654_57658 + (1));
seq__57651_57655 = G__57660;
chunk__57652_57656 = G__57661;
count__57653_57657 = G__57662;
i__57654_57658 = G__57663;
continue;
} else {
var temp__5459__auto___57664 = cljs.core.seq.call(null,seq__57651_57655);
if(temp__5459__auto___57664){
var seq__57651_57665__$1 = temp__5459__auto___57664;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57651_57665__$1)){
var c__48006__auto___57666 = cljs.core.chunk_first.call(null,seq__57651_57665__$1);
var G__57667 = cljs.core.chunk_rest.call(null,seq__57651_57665__$1);
var G__57668 = c__48006__auto___57666;
var G__57669 = cljs.core.count.call(null,c__48006__auto___57666);
var G__57670 = (0);
seq__57651_57655 = G__57667;
chunk__57652_57656 = G__57668;
count__57653_57657 = G__57669;
i__57654_57658 = G__57670;
continue;
} else {
var msg_57671 = cljs.core.first.call(null,seq__57651_57665__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_57671);

var G__57672 = cljs.core.next.call(null,seq__57651_57665__$1);
var G__57673 = null;
var G__57674 = (0);
var G__57675 = (0);
seq__57651_57655 = G__57672;
chunk__57652_57656 = G__57673;
count__57653_57657 = G__57674;
i__57654_57658 = G__57675;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Error on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__57676){
var map__57677 = p__57676;
var map__57677__$1 = ((((!((map__57677 == null)))?((((map__57677.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57677.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57677):map__57677);
var w = map__57677__$1;
var message = cljs.core.get.call(null,map__57677__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/quil/out/figwheel/client.cljs",33,1,363,363,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/quil/out/figwheel/client.cljs",30,1,355,355,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__47063__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__47063__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__47063__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__57679 = cljs.core.seq.call(null,plugins);
var chunk__57680 = null;
var count__57681 = (0);
var i__57682 = (0);
while(true){
if((i__57682 < count__57681)){
var vec__57683 = cljs.core._nth.call(null,chunk__57680,i__57682);
var k = cljs.core.nth.call(null,vec__57683,(0),null);
var plugin = cljs.core.nth.call(null,vec__57683,(1),null);
if(cljs.core.truth_(plugin)){
var pl_57689 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__57679,chunk__57680,count__57681,i__57682,pl_57689,vec__57683,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_57689.call(null,msg_hist);
});})(seq__57679,chunk__57680,count__57681,i__57682,pl_57689,vec__57683,k,plugin))
);
} else {
}

var G__57690 = seq__57679;
var G__57691 = chunk__57680;
var G__57692 = count__57681;
var G__57693 = (i__57682 + (1));
seq__57679 = G__57690;
chunk__57680 = G__57691;
count__57681 = G__57692;
i__57682 = G__57693;
continue;
} else {
var temp__5459__auto__ = cljs.core.seq.call(null,seq__57679);
if(temp__5459__auto__){
var seq__57679__$1 = temp__5459__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57679__$1)){
var c__48006__auto__ = cljs.core.chunk_first.call(null,seq__57679__$1);
var G__57694 = cljs.core.chunk_rest.call(null,seq__57679__$1);
var G__57695 = c__48006__auto__;
var G__57696 = cljs.core.count.call(null,c__48006__auto__);
var G__57697 = (0);
seq__57679 = G__57694;
chunk__57680 = G__57695;
count__57681 = G__57696;
i__57682 = G__57697;
continue;
} else {
var vec__57686 = cljs.core.first.call(null,seq__57679__$1);
var k = cljs.core.nth.call(null,vec__57686,(0),null);
var plugin = cljs.core.nth.call(null,vec__57686,(1),null);
if(cljs.core.truth_(plugin)){
var pl_57698 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__57679,chunk__57680,count__57681,i__57682,pl_57698,vec__57686,k,plugin,seq__57679__$1,temp__5459__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_57698.call(null,msg_hist);
});})(seq__57679,chunk__57680,count__57681,i__57682,pl_57698,vec__57686,k,plugin,seq__57679__$1,temp__5459__auto__))
);
} else {
}

var G__57699 = cljs.core.next.call(null,seq__57679__$1);
var G__57700 = null;
var G__57701 = (0);
var G__57702 = (0);
seq__57679 = G__57699;
chunk__57680 = G__57700;
count__57681 = G__57701;
i__57682 = G__57702;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__57704 = arguments.length;
switch (G__57704) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__57705_57710 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__57706_57711 = null;
var count__57707_57712 = (0);
var i__57708_57713 = (0);
while(true){
if((i__57708_57713 < count__57707_57712)){
var msg_57714 = cljs.core._nth.call(null,chunk__57706_57711,i__57708_57713);
figwheel.client.socket.handle_incoming_message.call(null,msg_57714);

var G__57715 = seq__57705_57710;
var G__57716 = chunk__57706_57711;
var G__57717 = count__57707_57712;
var G__57718 = (i__57708_57713 + (1));
seq__57705_57710 = G__57715;
chunk__57706_57711 = G__57716;
count__57707_57712 = G__57717;
i__57708_57713 = G__57718;
continue;
} else {
var temp__5459__auto___57719 = cljs.core.seq.call(null,seq__57705_57710);
if(temp__5459__auto___57719){
var seq__57705_57720__$1 = temp__5459__auto___57719;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57705_57720__$1)){
var c__48006__auto___57721 = cljs.core.chunk_first.call(null,seq__57705_57720__$1);
var G__57722 = cljs.core.chunk_rest.call(null,seq__57705_57720__$1);
var G__57723 = c__48006__auto___57721;
var G__57724 = cljs.core.count.call(null,c__48006__auto___57721);
var G__57725 = (0);
seq__57705_57710 = G__57722;
chunk__57706_57711 = G__57723;
count__57707_57712 = G__57724;
i__57708_57713 = G__57725;
continue;
} else {
var msg_57726 = cljs.core.first.call(null,seq__57705_57720__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_57726);

var G__57727 = cljs.core.next.call(null,seq__57705_57720__$1);
var G__57728 = null;
var G__57729 = (0);
var G__57730 = (0);
seq__57705_57710 = G__57727;
chunk__57706_57711 = G__57728;
count__57707_57712 = G__57729;
i__57708_57713 = G__57730;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__48361__auto__ = [];
var len__48354__auto___57735 = arguments.length;
var i__48355__auto___57736 = (0);
while(true){
if((i__48355__auto___57736 < len__48354__auto___57735)){
args__48361__auto__.push((arguments[i__48355__auto___57736]));

var G__57737 = (i__48355__auto___57736 + (1));
i__48355__auto___57736 = G__57737;
continue;
} else {
}
break;
}

var argseq__48362__auto__ = ((((0) < args__48361__auto__.length))?(new cljs.core.IndexedSeq(args__48361__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__48362__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__57732){
var map__57733 = p__57732;
var map__57733__$1 = ((((!((map__57733 == null)))?((((map__57733.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57733.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57733):map__57733);
var opts = map__57733__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq57731){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq57731));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e57738){if((e57738 instanceof Error)){
var e = e57738;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e57738;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__57739){
var map__57740 = p__57739;
var map__57740__$1 = ((((!((map__57740 == null)))?((((map__57740.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57740.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57740):map__57740);
var msg_name = cljs.core.get.call(null,map__57740__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1509156897093
