// Compiled by ClojureScript 1.9.946 {}
goog.provide('lemonade.geometry');
goog.require('cljs.core');
lemonade.geometry.π = Math.PI;
/**
 * Ratio of circumference to diameter of a circle.
 *   For those who don't like programming with unicode.
 */
lemonade.geometry.pi = lemonade.geometry.π;
/**
 * Converts degrees to radians
 */
lemonade.geometry.deg__GT_rad = (function lemonade$geometry$deg__GT_rad(d){
return (lemonade.geometry.π * (d / (180)));
});
lemonade.geometry.sin = (function lemonade$geometry$sin(x){
return Math.sin(x);
});
lemonade.geometry.cos = (function lemonade$geometry$cos(x){
return Math.cos(x);
});
lemonade.geometry.abs = (function lemonade$geometry$abs(x){
if((x < (0))){
return (- x);
} else {
return x;
}
});
/**
 * Returns true if the sequential of paths passed in are pairwise connected.
 */
lemonade.geometry.connected_QMARK_ = (function lemonade$geometry$connected_QMARK_(p__48793){
while(true){
var vec__48794 = p__48793;
var seq__48795 = cljs.core.seq.call(null,vec__48794);
var first__48796 = cljs.core.first.call(null,seq__48795);
var seq__48795__$1 = cljs.core.next.call(null,seq__48795);
var x = first__48796;
var more = seq__48795__$1;
if(cljs.core.empty_QMARK_.call(null,more)){
return true;
} else {
var y = cljs.core.first.call(null,more);
var and__47063__auto__ = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"to","to",192099007).cljs$core$IFn$_invoke$arity$1(x),new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(y));
if(and__47063__auto__){
var G__48797 = more;
p__48793 = G__48797;
continue;
} else {
return and__47063__auto__;
}
}
break;
}
});
lemonade.geometry.closed_segment_QMARK_ = (function lemonade$geometry$closed_segment_QMARK_(path){
return (cljs.core._EQ_.call(null,new cljs.core.Keyword("lemonade.core","arc","lemonade.core/arc",1918704395),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(path))) && ((((2) * lemonade.geometry.π) < lemonade.geometry.abs.call(null,(new cljs.core.Keyword(null,"to","to",192099007).cljs$core$IFn$_invoke$arity$1(path) - new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(path)))));
});
/**
 * Returns true if paths form the boundary of a connected surface.
 *   Technically I'm requiring a connecting bridge of non-zero measure. Not sure if
 *   that's a good call...
 *   Simply connected not necessary, just no point connections.
 */
lemonade.geometry.closed_path_QMARK_ = (function lemonade$geometry$closed_path_QMARK_(paths){
var and__47063__auto__ = lemonade.geometry.connected_QMARK_.call(null,paths);
if(cljs.core.truth_(and__47063__auto__)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,paths)),new cljs.core.Keyword(null,"to","to",192099007).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,paths)));
} else {
return and__47063__auto__;
}
});
lemonade.geometry.closed_QMARK_ = (function lemonade$geometry$closed_QMARK_(paths){
var or__47075__auto__ = lemonade.geometry.closed_path_QMARK_.call(null,paths);
if(cljs.core.truth_(or__47075__auto__)){
return or__47075__auto__;
} else {
return cljs.core.every_QMARK_.call(null,lemonade.geometry.closed_segment_QMARK_,paths);
}
});
/**
 * Temporary workaround for spec and big arithmetic
 */
lemonade.geometry._STAR__STAR_ = cljs.core._STAR_;
/**
 * The 2x2 identity matrix
 */
lemonade.geometry.idm = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [1.0,0.0,0.0,1.0], null);
/**
 * Returns the determinant of a 2x2 matrix
 */
lemonade.geometry.det = (function lemonade$geometry$det(a,b,c,d){
return (lemonade.geometry._STAR__STAR_.call(null,a,d) - lemonade.geometry._STAR__STAR_.call(null,b,c));
});
/**
 * Convenience fn for building atx maps
 */
lemonade.geometry.atx = (function lemonade$geometry$atx(var_args){
var G__48815 = arguments.length;
switch (G__48815) {
case 1:
return lemonade.geometry.atx.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return lemonade.geometry.atx.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

lemonade.geometry.atx.cljs$core$IFn$_invoke$arity$1 = (function (m){
return lemonade.geometry.atx.call(null,m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null));
});

lemonade.geometry.atx.cljs$core$IFn$_invoke$arity$2 = (function (m,b){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"matrix","matrix",803137200),m,new cljs.core.Keyword(null,"translation","translation",-701621547),b], null);
});

lemonade.geometry.atx.cljs$lang$maxFixedArity = 2;

lemonade.geometry.id = lemonade.geometry.atx.call(null,lemonade.geometry.idm,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [0.0,0.0], null));
/**
 * Returns matrix corresponding to the inverse affine transform.
 */
lemonade.geometry.invert_atx = (function lemonade$geometry$invert_atx(p__48827){
var map__48828 = p__48827;
var map__48828__$1 = ((((!((map__48828 == null)))?((((map__48828.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48828.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48828):map__48828);
var vec__48831 = cljs.core.get.call(null,map__48828__$1,new cljs.core.Keyword(null,"matrix","matrix",803137200));
var a = cljs.core.nth.call(null,vec__48831,(0),null);
var b = cljs.core.nth.call(null,vec__48831,(1),null);
var c = cljs.core.nth.call(null,vec__48831,(2),null);
var d = cljs.core.nth.call(null,vec__48831,(3),null);
var vec__48834 = cljs.core.get.call(null,map__48828__$1,new cljs.core.Keyword(null,"translation","translation",-701621547));
var x = cljs.core.nth.call(null,vec__48834,(0),null);
var y = cljs.core.nth.call(null,vec__48834,(1),null);
var abs = lemonade.geometry.det.call(null,a,b,c,d);
var vec__48843 = cljs.core.map.call(null,((function (abs,map__48828,map__48828__$1,vec__48831,a,b,c,d,vec__48834,x,y){
return (function (p1__48826_SHARP_){
return (p1__48826_SHARP_ / abs);
});})(abs,map__48828,map__48828__$1,vec__48831,a,b,c,d,vec__48834,x,y))
,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [d,(- b),(- c),a], null));
var a_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__48843,(0),null);
var b_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__48843,(1),null);
var c_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__48843,(2),null);
var d_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__48843,(3),null);
var x_SINGLEQUOTE_ = (- (lemonade.geometry._STAR__STAR_.call(null,a_SINGLEQUOTE_,x) + lemonade.geometry._STAR__STAR_.call(null,b_SINGLEQUOTE_,y)));
var y_SINGLEQUOTE_ = (- (lemonade.geometry._STAR__STAR_.call(null,c_SINGLEQUOTE_,x) + lemonade.geometry._STAR__STAR_.call(null,d_SINGLEQUOTE_,y)));
return lemonade.geometry.atx.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [a_SINGLEQUOTE_,b_SINGLEQUOTE_,c_SINGLEQUOTE_,d_SINGLEQUOTE_], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_SINGLEQUOTE_,y_SINGLEQUOTE_], null));
});
/**
 * Returns the composition of affine transformations
 */
lemonade.geometry.comp_atx = (function lemonade$geometry$comp_atx(var_args){
var G__48857 = arguments.length;
switch (G__48857) {
case 1:
return lemonade.geometry.comp_atx.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return lemonade.geometry.comp_atx.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__48377__auto__ = [];
var len__48354__auto___48891 = arguments.length;
var i__48355__auto___48892 = (0);
while(true){
if((i__48355__auto___48892 < len__48354__auto___48891)){
args_arr__48377__auto__.push((arguments[i__48355__auto___48892]));

var G__48893 = (i__48355__auto___48892 + (1));
i__48355__auto___48892 = G__48893;
continue;
} else {
}
break;
}

var argseq__48378__auto__ = (new cljs.core.IndexedSeq(args_arr__48377__auto__.slice((2)),(0),null));
return lemonade.geometry.comp_atx.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__48378__auto__);

}
});

lemonade.geometry.comp_atx.cljs$core$IFn$_invoke$arity$1 = (function (a){
return a;
});

lemonade.geometry.comp_atx.cljs$core$IFn$_invoke$arity$2 = (function (p__48864,p__48865){
var map__48866 = p__48864;
var map__48866__$1 = ((((!((map__48866 == null)))?((((map__48866.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48866.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48866):map__48866);
var vec__48867 = cljs.core.get.call(null,map__48866__$1,new cljs.core.Keyword(null,"matrix","matrix",803137200));
var a = cljs.core.nth.call(null,vec__48867,(0),null);
var b = cljs.core.nth.call(null,vec__48867,(1),null);
var c = cljs.core.nth.call(null,vec__48867,(2),null);
var d = cljs.core.nth.call(null,vec__48867,(3),null);
var vec__48870 = cljs.core.get.call(null,map__48866__$1,new cljs.core.Keyword(null,"translation","translation",-701621547));
var x = cljs.core.nth.call(null,vec__48870,(0),null);
var y = cljs.core.nth.call(null,vec__48870,(1),null);
var map__48873 = p__48865;
var map__48873__$1 = ((((!((map__48873 == null)))?((((map__48873.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48873.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48873):map__48873);
var vec__48874 = cljs.core.get.call(null,map__48873__$1,new cljs.core.Keyword(null,"matrix","matrix",803137200));
var a_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__48874,(0),null);
var b_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__48874,(1),null);
var c_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__48874,(2),null);
var d_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__48874,(3),null);
var vec__48877 = cljs.core.get.call(null,map__48873__$1,new cljs.core.Keyword(null,"translation","translation",-701621547));
var x_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__48877,(0),null);
var y_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__48877,(1),null);
return lemonade.geometry.atx.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [((a * a_SINGLEQUOTE_) + (b * c_SINGLEQUOTE_)),((a * b_SINGLEQUOTE_) + (b * d_SINGLEQUOTE_)),((c * a_SINGLEQUOTE_) + (d * c_SINGLEQUOTE_)),((c * b_SINGLEQUOTE_) + (d * d_SINGLEQUOTE_))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((x + (a * x_SINGLEQUOTE_)) + (b * y_SINGLEQUOTE_)),((y + (c * x_SINGLEQUOTE_)) + (d * y_SINGLEQUOTE_))], null));
});

lemonade.geometry.comp_atx.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,more){
return cljs.core.reduce.call(null,lemonade.geometry.comp_atx,lemonade.geometry.comp_atx.call(null,a,b),more);
});

lemonade.geometry.comp_atx.cljs$lang$applyTo = (function (seq48852){
var G__48854 = cljs.core.first.call(null,seq48852);
var seq48852__$1 = cljs.core.next.call(null,seq48852);
var G__48856 = cljs.core.first.call(null,seq48852__$1);
var seq48852__$2 = cljs.core.next.call(null,seq48852__$1);
return lemonade.geometry.comp_atx.cljs$core$IFn$_invoke$arity$variadic(G__48854,G__48856,seq48852__$2);
});

lemonade.geometry.comp_atx.cljs$lang$maxFixedArity = (2);


//# sourceMappingURL=geometry.js.map?rel=1509156890075
