// Compiled by ClojureScript 1.9.946 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.13";
figwheel.client.js_stringify = (((typeof JSON !== 'undefined') && (!((JSON.stringify == null))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}catch (e58188){if((e58188 instanceof Error)){
var e = e58188;
return "Error: Unable to stringify";
} else {
throw e58188;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__58191 = arguments.length;
switch (G__58191) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__58189_SHARP_){
if(typeof p1__58189_SHARP_ === 'string'){
return p1__58189_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__58189_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__48361__auto__ = [];
var len__48354__auto___58194 = arguments.length;
var i__48355__auto___58195 = (0);
while(true){
if((i__48355__auto___58195 < len__48354__auto___58194)){
args__48361__auto__.push((arguments[i__48355__auto___58195]));

var G__58196 = (i__48355__auto___58195 + (1));
i__48355__auto___58195 = G__58196;
continue;
} else {
}
break;
}

var argseq__48362__auto__ = ((((0) < args__48361__auto__.length))?(new cljs.core.IndexedSeq(args__48361__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__48362__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq58193){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq58193));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__48361__auto__ = [];
var len__48354__auto___58198 = arguments.length;
var i__48355__auto___58199 = (0);
while(true){
if((i__48355__auto___58199 < len__48354__auto___58198)){
args__48361__auto__.push((arguments[i__48355__auto___58199]));

var G__58200 = (i__48355__auto___58199 + (1));
i__48355__auto___58199 = G__58200;
continue;
} else {
}
break;
}

var argseq__48362__auto__ = ((((0) < args__48361__auto__.length))?(new cljs.core.IndexedSeq(args__48361__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__48362__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq58197){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq58197));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)"].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__58201){
var map__58202 = p__58201;
var map__58202__$1 = ((((!((map__58202 == null)))?((((map__58202.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58202.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58202):map__58202);
var message = cljs.core.get.call(null,map__58202__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__58202__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__47075__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__47075__auto__)){
return or__47075__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__47063__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__47063__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__47063__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__50041__auto___58281 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto___58281,ch){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto___58281,ch){
return (function (state_58253){
var state_val_58254 = (state_58253[(1)]);
if((state_val_58254 === (7))){
var inst_58249 = (state_58253[(2)]);
var state_58253__$1 = state_58253;
var statearr_58255_58282 = state_58253__$1;
(statearr_58255_58282[(2)] = inst_58249);

(statearr_58255_58282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58254 === (1))){
var state_58253__$1 = state_58253;
var statearr_58256_58283 = state_58253__$1;
(statearr_58256_58283[(2)] = null);

(statearr_58256_58283[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58254 === (4))){
var inst_58206 = (state_58253[(7)]);
var inst_58206__$1 = (state_58253[(2)]);
var state_58253__$1 = (function (){var statearr_58257 = state_58253;
(statearr_58257[(7)] = inst_58206__$1);

return statearr_58257;
})();
if(cljs.core.truth_(inst_58206__$1)){
var statearr_58258_58284 = state_58253__$1;
(statearr_58258_58284[(1)] = (5));

} else {
var statearr_58259_58285 = state_58253__$1;
(statearr_58259_58285[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58254 === (15))){
var inst_58213 = (state_58253[(8)]);
var inst_58228 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_58213);
var inst_58229 = cljs.core.first.call(null,inst_58228);
var inst_58230 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_58229);
var inst_58231 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_58230)].join('');
var inst_58232 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_58231);
var state_58253__$1 = state_58253;
var statearr_58260_58286 = state_58253__$1;
(statearr_58260_58286[(2)] = inst_58232);

(statearr_58260_58286[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58254 === (13))){
var inst_58237 = (state_58253[(2)]);
var state_58253__$1 = state_58253;
var statearr_58261_58287 = state_58253__$1;
(statearr_58261_58287[(2)] = inst_58237);

(statearr_58261_58287[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58254 === (6))){
var state_58253__$1 = state_58253;
var statearr_58262_58288 = state_58253__$1;
(statearr_58262_58288[(2)] = null);

(statearr_58262_58288[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58254 === (17))){
var inst_58235 = (state_58253[(2)]);
var state_58253__$1 = state_58253;
var statearr_58263_58289 = state_58253__$1;
(statearr_58263_58289[(2)] = inst_58235);

(statearr_58263_58289[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58254 === (3))){
var inst_58251 = (state_58253[(2)]);
var state_58253__$1 = state_58253;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58253__$1,inst_58251);
} else {
if((state_val_58254 === (12))){
var inst_58212 = (state_58253[(9)]);
var inst_58226 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_58212,opts);
var state_58253__$1 = state_58253;
if(cljs.core.truth_(inst_58226)){
var statearr_58264_58290 = state_58253__$1;
(statearr_58264_58290[(1)] = (15));

} else {
var statearr_58265_58291 = state_58253__$1;
(statearr_58265_58291[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58254 === (2))){
var state_58253__$1 = state_58253;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58253__$1,(4),ch);
} else {
if((state_val_58254 === (11))){
var inst_58213 = (state_58253[(8)]);
var inst_58218 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58219 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_58213);
var inst_58220 = cljs.core.async.timeout.call(null,(1000));
var inst_58221 = [inst_58219,inst_58220];
var inst_58222 = (new cljs.core.PersistentVector(null,2,(5),inst_58218,inst_58221,null));
var state_58253__$1 = state_58253;
return cljs.core.async.ioc_alts_BANG_.call(null,state_58253__$1,(14),inst_58222);
} else {
if((state_val_58254 === (9))){
var inst_58213 = (state_58253[(8)]);
var inst_58239 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_58240 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_58213);
var inst_58241 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_58240);
var inst_58242 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_58241)].join('');
var inst_58243 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_58242);
var state_58253__$1 = (function (){var statearr_58266 = state_58253;
(statearr_58266[(10)] = inst_58239);

return statearr_58266;
})();
var statearr_58267_58292 = state_58253__$1;
(statearr_58267_58292[(2)] = inst_58243);

(statearr_58267_58292[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58254 === (5))){
var inst_58206 = (state_58253[(7)]);
var inst_58208 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_58209 = (new cljs.core.PersistentArrayMap(null,2,inst_58208,null));
var inst_58210 = (new cljs.core.PersistentHashSet(null,inst_58209,null));
var inst_58211 = figwheel.client.focus_msgs.call(null,inst_58210,inst_58206);
var inst_58212 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_58211);
var inst_58213 = cljs.core.first.call(null,inst_58211);
var inst_58214 = figwheel.client.autoload_QMARK_.call(null);
var state_58253__$1 = (function (){var statearr_58268 = state_58253;
(statearr_58268[(9)] = inst_58212);

(statearr_58268[(8)] = inst_58213);

return statearr_58268;
})();
if(cljs.core.truth_(inst_58214)){
var statearr_58269_58293 = state_58253__$1;
(statearr_58269_58293[(1)] = (8));

} else {
var statearr_58270_58294 = state_58253__$1;
(statearr_58270_58294[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58254 === (14))){
var inst_58224 = (state_58253[(2)]);
var state_58253__$1 = state_58253;
var statearr_58271_58295 = state_58253__$1;
(statearr_58271_58295[(2)] = inst_58224);

(statearr_58271_58295[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58254 === (16))){
var state_58253__$1 = state_58253;
var statearr_58272_58296 = state_58253__$1;
(statearr_58272_58296[(2)] = null);

(statearr_58272_58296[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58254 === (10))){
var inst_58245 = (state_58253[(2)]);
var state_58253__$1 = (function (){var statearr_58273 = state_58253;
(statearr_58273[(11)] = inst_58245);

return statearr_58273;
})();
var statearr_58274_58297 = state_58253__$1;
(statearr_58274_58297[(2)] = null);

(statearr_58274_58297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58254 === (8))){
var inst_58212 = (state_58253[(9)]);
var inst_58216 = figwheel.client.reload_file_state_QMARK_.call(null,inst_58212,opts);
var state_58253__$1 = state_58253;
if(cljs.core.truth_(inst_58216)){
var statearr_58275_58298 = state_58253__$1;
(statearr_58275_58298[(1)] = (11));

} else {
var statearr_58276_58299 = state_58253__$1;
(statearr_58276_58299[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__50041__auto___58281,ch))
;
return ((function (switch__50018__auto__,c__50041__auto___58281,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__50019__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__50019__auto____0 = (function (){
var statearr_58277 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58277[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__50019__auto__);

(statearr_58277[(1)] = (1));

return statearr_58277;
});
var figwheel$client$file_reloader_plugin_$_state_machine__50019__auto____1 = (function (state_58253){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_58253);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e58278){if((e58278 instanceof Object)){
var ex__50022__auto__ = e58278;
var statearr_58279_58300 = state_58253;
(statearr_58279_58300[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58253);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58278;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58301 = state_58253;
state_58253 = G__58301;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__50019__auto__ = function(state_58253){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__50019__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__50019__auto____1.call(this,state_58253);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloader_plugin_$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__50019__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__50019__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto___58281,ch))
})();
var state__50043__auto__ = (function (){var statearr_58280 = f__50042__auto__.call(null);
(statearr_58280[(6)] = c__50041__auto___58281);

return statearr_58280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto___58281,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__58302_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__58302_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_58304 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_58304){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e58303){if((e58303 instanceof Error)){
var e = e58303;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_58304], null));
} else {
var e = e58303;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_58304))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__58305){
var map__58306 = p__58305;
var map__58306__$1 = ((((!((map__58306 == null)))?((((map__58306.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58306.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58306):map__58306);
var opts = map__58306__$1;
var build_id = cljs.core.get.call(null,map__58306__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__58306,map__58306__$1,opts,build_id){
return (function (p__58308){
var vec__58309 = p__58308;
var seq__58310 = cljs.core.seq.call(null,vec__58309);
var first__58311 = cljs.core.first.call(null,seq__58310);
var seq__58310__$1 = cljs.core.next.call(null,seq__58310);
var map__58312 = first__58311;
var map__58312__$1 = ((((!((map__58312 == null)))?((((map__58312.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58312.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58312):map__58312);
var msg = map__58312__$1;
var msg_name = cljs.core.get.call(null,map__58312__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__58310__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__58309,seq__58310,first__58311,seq__58310__$1,map__58312,map__58312__$1,msg,msg_name,_,map__58306,map__58306__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__58309,seq__58310,first__58311,seq__58310__$1,map__58312,map__58312__$1,msg,msg_name,_,map__58306,map__58306__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__58306,map__58306__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__58314){
var vec__58315 = p__58314;
var seq__58316 = cljs.core.seq.call(null,vec__58315);
var first__58317 = cljs.core.first.call(null,seq__58316);
var seq__58316__$1 = cljs.core.next.call(null,seq__58316);
var map__58318 = first__58317;
var map__58318__$1 = ((((!((map__58318 == null)))?((((map__58318.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58318.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58318):map__58318);
var msg = map__58318__$1;
var msg_name = cljs.core.get.call(null,map__58318__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__58316__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__58320){
var map__58321 = p__58320;
var map__58321__$1 = ((((!((map__58321 == null)))?((((map__58321.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58321.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58321):map__58321);
var on_compile_warning = cljs.core.get.call(null,map__58321__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__58321__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__58321,map__58321__$1,on_compile_warning,on_compile_fail){
return (function (p__58323){
var vec__58324 = p__58323;
var seq__58325 = cljs.core.seq.call(null,vec__58324);
var first__58326 = cljs.core.first.call(null,seq__58325);
var seq__58325__$1 = cljs.core.next.call(null,seq__58325);
var map__58327 = first__58326;
var map__58327__$1 = ((((!((map__58327 == null)))?((((map__58327.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58327.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58327):map__58327);
var msg = map__58327__$1;
var msg_name = cljs.core.get.call(null,map__58327__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__58325__$1;
var pred__58329 = cljs.core._EQ_;
var expr__58330 = msg_name;
if(cljs.core.truth_(pred__58329.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__58330))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__58329.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__58330))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__58321,map__58321__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__50041__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto__,msg_hist,msg_names,msg){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto__,msg_hist,msg_names,msg){
return (function (state_58419){
var state_val_58420 = (state_58419[(1)]);
if((state_val_58420 === (7))){
var inst_58339 = (state_58419[(2)]);
var state_58419__$1 = state_58419;
if(cljs.core.truth_(inst_58339)){
var statearr_58421_58468 = state_58419__$1;
(statearr_58421_58468[(1)] = (8));

} else {
var statearr_58422_58469 = state_58419__$1;
(statearr_58422_58469[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (20))){
var inst_58413 = (state_58419[(2)]);
var state_58419__$1 = state_58419;
var statearr_58423_58470 = state_58419__$1;
(statearr_58423_58470[(2)] = inst_58413);

(statearr_58423_58470[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (27))){
var inst_58409 = (state_58419[(2)]);
var state_58419__$1 = state_58419;
var statearr_58424_58471 = state_58419__$1;
(statearr_58424_58471[(2)] = inst_58409);

(statearr_58424_58471[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (1))){
var inst_58332 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_58419__$1 = state_58419;
if(cljs.core.truth_(inst_58332)){
var statearr_58425_58472 = state_58419__$1;
(statearr_58425_58472[(1)] = (2));

} else {
var statearr_58426_58473 = state_58419__$1;
(statearr_58426_58473[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (24))){
var inst_58411 = (state_58419[(2)]);
var state_58419__$1 = state_58419;
var statearr_58427_58474 = state_58419__$1;
(statearr_58427_58474[(2)] = inst_58411);

(statearr_58427_58474[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (4))){
var inst_58417 = (state_58419[(2)]);
var state_58419__$1 = state_58419;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58419__$1,inst_58417);
} else {
if((state_val_58420 === (15))){
var inst_58415 = (state_58419[(2)]);
var state_58419__$1 = state_58419;
var statearr_58428_58475 = state_58419__$1;
(statearr_58428_58475[(2)] = inst_58415);

(statearr_58428_58475[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (21))){
var inst_58368 = (state_58419[(2)]);
var inst_58369 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_58370 = figwheel.client.auto_jump_to_error.call(null,opts,inst_58369);
var state_58419__$1 = (function (){var statearr_58429 = state_58419;
(statearr_58429[(7)] = inst_58368);

return statearr_58429;
})();
var statearr_58430_58476 = state_58419__$1;
(statearr_58430_58476[(2)] = inst_58370);

(statearr_58430_58476[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (31))){
var inst_58398 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_58419__$1 = state_58419;
if(cljs.core.truth_(inst_58398)){
var statearr_58431_58477 = state_58419__$1;
(statearr_58431_58477[(1)] = (34));

} else {
var statearr_58432_58478 = state_58419__$1;
(statearr_58432_58478[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (32))){
var inst_58407 = (state_58419[(2)]);
var state_58419__$1 = state_58419;
var statearr_58433_58479 = state_58419__$1;
(statearr_58433_58479[(2)] = inst_58407);

(statearr_58433_58479[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (33))){
var inst_58394 = (state_58419[(2)]);
var inst_58395 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_58396 = figwheel.client.auto_jump_to_error.call(null,opts,inst_58395);
var state_58419__$1 = (function (){var statearr_58434 = state_58419;
(statearr_58434[(8)] = inst_58394);

return statearr_58434;
})();
var statearr_58435_58480 = state_58419__$1;
(statearr_58435_58480[(2)] = inst_58396);

(statearr_58435_58480[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (13))){
var inst_58353 = figwheel.client.heads_up.clear.call(null);
var state_58419__$1 = state_58419;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58419__$1,(16),inst_58353);
} else {
if((state_val_58420 === (22))){
var inst_58374 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_58375 = figwheel.client.heads_up.append_warning_message.call(null,inst_58374);
var state_58419__$1 = state_58419;
var statearr_58436_58481 = state_58419__$1;
(statearr_58436_58481[(2)] = inst_58375);

(statearr_58436_58481[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (36))){
var inst_58405 = (state_58419[(2)]);
var state_58419__$1 = state_58419;
var statearr_58437_58482 = state_58419__$1;
(statearr_58437_58482[(2)] = inst_58405);

(statearr_58437_58482[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (29))){
var inst_58385 = (state_58419[(2)]);
var inst_58386 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_58387 = figwheel.client.auto_jump_to_error.call(null,opts,inst_58386);
var state_58419__$1 = (function (){var statearr_58438 = state_58419;
(statearr_58438[(9)] = inst_58385);

return statearr_58438;
})();
var statearr_58439_58483 = state_58419__$1;
(statearr_58439_58483[(2)] = inst_58387);

(statearr_58439_58483[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (6))){
var inst_58334 = (state_58419[(10)]);
var state_58419__$1 = state_58419;
var statearr_58440_58484 = state_58419__$1;
(statearr_58440_58484[(2)] = inst_58334);

(statearr_58440_58484[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (28))){
var inst_58381 = (state_58419[(2)]);
var inst_58382 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_58383 = figwheel.client.heads_up.display_warning.call(null,inst_58382);
var state_58419__$1 = (function (){var statearr_58441 = state_58419;
(statearr_58441[(11)] = inst_58381);

return statearr_58441;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58419__$1,(29),inst_58383);
} else {
if((state_val_58420 === (25))){
var inst_58379 = figwheel.client.heads_up.clear.call(null);
var state_58419__$1 = state_58419;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58419__$1,(28),inst_58379);
} else {
if((state_val_58420 === (34))){
var inst_58400 = figwheel.client.heads_up.flash_loaded.call(null);
var state_58419__$1 = state_58419;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58419__$1,(37),inst_58400);
} else {
if((state_val_58420 === (17))){
var inst_58359 = (state_58419[(2)]);
var inst_58360 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_58361 = figwheel.client.auto_jump_to_error.call(null,opts,inst_58360);
var state_58419__$1 = (function (){var statearr_58442 = state_58419;
(statearr_58442[(12)] = inst_58359);

return statearr_58442;
})();
var statearr_58443_58485 = state_58419__$1;
(statearr_58443_58485[(2)] = inst_58361);

(statearr_58443_58485[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (3))){
var inst_58351 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_58419__$1 = state_58419;
if(cljs.core.truth_(inst_58351)){
var statearr_58444_58486 = state_58419__$1;
(statearr_58444_58486[(1)] = (13));

} else {
var statearr_58445_58487 = state_58419__$1;
(statearr_58445_58487[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (12))){
var inst_58347 = (state_58419[(2)]);
var state_58419__$1 = state_58419;
var statearr_58446_58488 = state_58419__$1;
(statearr_58446_58488[(2)] = inst_58347);

(statearr_58446_58488[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (2))){
var inst_58334 = (state_58419[(10)]);
var inst_58334__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_58419__$1 = (function (){var statearr_58447 = state_58419;
(statearr_58447[(10)] = inst_58334__$1);

return statearr_58447;
})();
if(cljs.core.truth_(inst_58334__$1)){
var statearr_58448_58489 = state_58419__$1;
(statearr_58448_58489[(1)] = (5));

} else {
var statearr_58449_58490 = state_58419__$1;
(statearr_58449_58490[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (23))){
var inst_58377 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_58419__$1 = state_58419;
if(cljs.core.truth_(inst_58377)){
var statearr_58450_58491 = state_58419__$1;
(statearr_58450_58491[(1)] = (25));

} else {
var statearr_58451_58492 = state_58419__$1;
(statearr_58451_58492[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (35))){
var state_58419__$1 = state_58419;
var statearr_58452_58493 = state_58419__$1;
(statearr_58452_58493[(2)] = null);

(statearr_58452_58493[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (19))){
var inst_58372 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_58419__$1 = state_58419;
if(cljs.core.truth_(inst_58372)){
var statearr_58453_58494 = state_58419__$1;
(statearr_58453_58494[(1)] = (22));

} else {
var statearr_58454_58495 = state_58419__$1;
(statearr_58454_58495[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (11))){
var inst_58343 = (state_58419[(2)]);
var state_58419__$1 = state_58419;
var statearr_58455_58496 = state_58419__$1;
(statearr_58455_58496[(2)] = inst_58343);

(statearr_58455_58496[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (9))){
var inst_58345 = figwheel.client.heads_up.clear.call(null);
var state_58419__$1 = state_58419;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58419__$1,(12),inst_58345);
} else {
if((state_val_58420 === (5))){
var inst_58336 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_58419__$1 = state_58419;
var statearr_58456_58497 = state_58419__$1;
(statearr_58456_58497[(2)] = inst_58336);

(statearr_58456_58497[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (14))){
var inst_58363 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_58419__$1 = state_58419;
if(cljs.core.truth_(inst_58363)){
var statearr_58457_58498 = state_58419__$1;
(statearr_58457_58498[(1)] = (18));

} else {
var statearr_58458_58499 = state_58419__$1;
(statearr_58458_58499[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (26))){
var inst_58389 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_58419__$1 = state_58419;
if(cljs.core.truth_(inst_58389)){
var statearr_58459_58500 = state_58419__$1;
(statearr_58459_58500[(1)] = (30));

} else {
var statearr_58460_58501 = state_58419__$1;
(statearr_58460_58501[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (16))){
var inst_58355 = (state_58419[(2)]);
var inst_58356 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_58357 = figwheel.client.heads_up.display_exception.call(null,inst_58356);
var state_58419__$1 = (function (){var statearr_58461 = state_58419;
(statearr_58461[(13)] = inst_58355);

return statearr_58461;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58419__$1,(17),inst_58357);
} else {
if((state_val_58420 === (30))){
var inst_58391 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_58392 = figwheel.client.heads_up.display_warning.call(null,inst_58391);
var state_58419__$1 = state_58419;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58419__$1,(33),inst_58392);
} else {
if((state_val_58420 === (10))){
var inst_58349 = (state_58419[(2)]);
var state_58419__$1 = state_58419;
var statearr_58462_58502 = state_58419__$1;
(statearr_58462_58502[(2)] = inst_58349);

(statearr_58462_58502[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (18))){
var inst_58365 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_58366 = figwheel.client.heads_up.display_exception.call(null,inst_58365);
var state_58419__$1 = state_58419;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58419__$1,(21),inst_58366);
} else {
if((state_val_58420 === (37))){
var inst_58402 = (state_58419[(2)]);
var state_58419__$1 = state_58419;
var statearr_58463_58503 = state_58419__$1;
(statearr_58463_58503[(2)] = inst_58402);

(statearr_58463_58503[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58420 === (8))){
var inst_58341 = figwheel.client.heads_up.flash_loaded.call(null);
var state_58419__$1 = state_58419;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58419__$1,(11),inst_58341);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__50041__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__50018__auto__,c__50041__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__50019__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__50019__auto____0 = (function (){
var statearr_58464 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58464[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__50019__auto__);

(statearr_58464[(1)] = (1));

return statearr_58464;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__50019__auto____1 = (function (state_58419){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_58419);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e58465){if((e58465 instanceof Object)){
var ex__50022__auto__ = e58465;
var statearr_58466_58504 = state_58419;
(statearr_58466_58504[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58419);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58465;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58505 = state_58419;
state_58419 = G__58505;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__50019__auto__ = function(state_58419){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__50019__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__50019__auto____1.call(this,state_58419);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__50019__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__50019__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto__,msg_hist,msg_names,msg))
})();
var state__50043__auto__ = (function (){var statearr_58467 = f__50042__auto__.call(null);
(statearr_58467[(6)] = c__50041__auto__);

return statearr_58467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto__,msg_hist,msg_names,msg))
);

return c__50041__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__50041__auto___58534 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto___58534,ch){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto___58534,ch){
return (function (state_58520){
var state_val_58521 = (state_58520[(1)]);
if((state_val_58521 === (1))){
var state_58520__$1 = state_58520;
var statearr_58522_58535 = state_58520__$1;
(statearr_58522_58535[(2)] = null);

(statearr_58522_58535[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58521 === (2))){
var state_58520__$1 = state_58520;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58520__$1,(4),ch);
} else {
if((state_val_58521 === (3))){
var inst_58518 = (state_58520[(2)]);
var state_58520__$1 = state_58520;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58520__$1,inst_58518);
} else {
if((state_val_58521 === (4))){
var inst_58508 = (state_58520[(7)]);
var inst_58508__$1 = (state_58520[(2)]);
var state_58520__$1 = (function (){var statearr_58523 = state_58520;
(statearr_58523[(7)] = inst_58508__$1);

return statearr_58523;
})();
if(cljs.core.truth_(inst_58508__$1)){
var statearr_58524_58536 = state_58520__$1;
(statearr_58524_58536[(1)] = (5));

} else {
var statearr_58525_58537 = state_58520__$1;
(statearr_58525_58537[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58521 === (5))){
var inst_58508 = (state_58520[(7)]);
var inst_58510 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_58508);
var state_58520__$1 = state_58520;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58520__$1,(8),inst_58510);
} else {
if((state_val_58521 === (6))){
var state_58520__$1 = state_58520;
var statearr_58526_58538 = state_58520__$1;
(statearr_58526_58538[(2)] = null);

(statearr_58526_58538[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58521 === (7))){
var inst_58516 = (state_58520[(2)]);
var state_58520__$1 = state_58520;
var statearr_58527_58539 = state_58520__$1;
(statearr_58527_58539[(2)] = inst_58516);

(statearr_58527_58539[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58521 === (8))){
var inst_58512 = (state_58520[(2)]);
var state_58520__$1 = (function (){var statearr_58528 = state_58520;
(statearr_58528[(8)] = inst_58512);

return statearr_58528;
})();
var statearr_58529_58540 = state_58520__$1;
(statearr_58529_58540[(2)] = null);

(statearr_58529_58540[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__50041__auto___58534,ch))
;
return ((function (switch__50018__auto__,c__50041__auto___58534,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__50019__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__50019__auto____0 = (function (){
var statearr_58530 = [null,null,null,null,null,null,null,null,null];
(statearr_58530[(0)] = figwheel$client$heads_up_plugin_$_state_machine__50019__auto__);

(statearr_58530[(1)] = (1));

return statearr_58530;
});
var figwheel$client$heads_up_plugin_$_state_machine__50019__auto____1 = (function (state_58520){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_58520);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e58531){if((e58531 instanceof Object)){
var ex__50022__auto__ = e58531;
var statearr_58532_58541 = state_58520;
(statearr_58532_58541[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58520);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58531;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58542 = state_58520;
state_58520 = G__58542;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__50019__auto__ = function(state_58520){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__50019__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__50019__auto____1.call(this,state_58520);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__50019__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__50019__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto___58534,ch))
})();
var state__50043__auto__ = (function (){var statearr_58533 = f__50042__auto__.call(null);
(statearr_58533[(6)] = c__50041__auto___58534);

return statearr_58533;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto___58534,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__50041__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto__){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto__){
return (function (state_58548){
var state_val_58549 = (state_58548[(1)]);
if((state_val_58549 === (1))){
var inst_58543 = cljs.core.async.timeout.call(null,(3000));
var state_58548__$1 = state_58548;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58548__$1,(2),inst_58543);
} else {
if((state_val_58549 === (2))){
var inst_58545 = (state_58548[(2)]);
var inst_58546 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_58548__$1 = (function (){var statearr_58550 = state_58548;
(statearr_58550[(7)] = inst_58545);

return statearr_58550;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58548__$1,inst_58546);
} else {
return null;
}
}
});})(c__50041__auto__))
;
return ((function (switch__50018__auto__,c__50041__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__50019__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__50019__auto____0 = (function (){
var statearr_58551 = [null,null,null,null,null,null,null,null];
(statearr_58551[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__50019__auto__);

(statearr_58551[(1)] = (1));

return statearr_58551;
});
var figwheel$client$enforce_project_plugin_$_state_machine__50019__auto____1 = (function (state_58548){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_58548);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e58552){if((e58552 instanceof Object)){
var ex__50022__auto__ = e58552;
var statearr_58553_58555 = state_58548;
(statearr_58553_58555[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58548);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58552;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58556 = state_58548;
state_58548 = G__58556;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__50019__auto__ = function(state_58548){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__50019__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__50019__auto____1.call(this,state_58548);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_project_plugin_$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__50019__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__50019__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto__))
})();
var state__50043__auto__ = (function (){var statearr_58554 = f__50042__auto__.call(null);
(statearr_58554[(6)] = c__50041__auto__);

return statearr_58554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto__))
);

return c__50041__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__5459__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__5459__auto__)){
var figwheel_version = temp__5459__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__50041__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50041__auto__,figwheel_version,temp__5459__auto__){
return (function (){
var f__50042__auto__ = (function (){var switch__50018__auto__ = ((function (c__50041__auto__,figwheel_version,temp__5459__auto__){
return (function (state_58563){
var state_val_58564 = (state_58563[(1)]);
if((state_val_58564 === (1))){
var inst_58557 = cljs.core.async.timeout.call(null,(2000));
var state_58563__$1 = state_58563;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58563__$1,(2),inst_58557);
} else {
if((state_val_58564 === (2))){
var inst_58559 = (state_58563[(2)]);
var inst_58560 = ["Figwheel Client Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_58561 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_58560);
var state_58563__$1 = (function (){var statearr_58565 = state_58563;
(statearr_58565[(7)] = inst_58559);

return statearr_58565;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58563__$1,inst_58561);
} else {
return null;
}
}
});})(c__50041__auto__,figwheel_version,temp__5459__auto__))
;
return ((function (switch__50018__auto__,c__50041__auto__,figwheel_version,temp__5459__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__50019__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__50019__auto____0 = (function (){
var statearr_58566 = [null,null,null,null,null,null,null,null];
(statearr_58566[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__50019__auto__);

(statearr_58566[(1)] = (1));

return statearr_58566;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__50019__auto____1 = (function (state_58563){
while(true){
var ret_value__50020__auto__ = (function (){try{while(true){
var result__50021__auto__ = switch__50018__auto__.call(null,state_58563);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50021__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50021__auto__;
}
break;
}
}catch (e58567){if((e58567 instanceof Object)){
var ex__50022__auto__ = e58567;
var statearr_58568_58570 = state_58563;
(statearr_58568_58570[(5)] = ex__50022__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58563);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58567;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50020__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58571 = state_58563;
state_58563 = G__58571;
continue;
} else {
return ret_value__50020__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__50019__auto__ = function(state_58563){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__50019__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__50019__auto____1.call(this,state_58563);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__50019__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__50019__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__50019__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__50019__auto__;
})()
;})(switch__50018__auto__,c__50041__auto__,figwheel_version,temp__5459__auto__))
})();
var state__50043__auto__ = (function (){var statearr_58569 = f__50042__auto__.call(null);
(statearr_58569[(6)] = c__50041__auto__);

return statearr_58569;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50043__auto__);
});})(c__50041__auto__,figwheel_version,temp__5459__auto__))
);

return c__50041__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__58572){
var map__58573 = p__58572;
var map__58573__$1 = ((((!((map__58573 == null)))?((((map__58573.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58573.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58573):map__58573);
var file = cljs.core.get.call(null,map__58573__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__58573__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__58573__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__58575 = "";
var G__58575__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__58575),"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__58575);
var G__58575__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__58575__$1)," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__58575__$1);
if(cljs.core.truth_((function (){var and__47063__auto__ = line;
if(cljs.core.truth_(and__47063__auto__)){
return column;
} else {
return and__47063__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__58575__$2),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__58575__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__58576){
var map__58577 = p__58576;
var map__58577__$1 = ((((!((map__58577 == null)))?((((map__58577.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58577.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58577):map__58577);
var ed = map__58577__$1;
var formatted_exception = cljs.core.get.call(null,map__58577__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__58577__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__58577__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__58579_58583 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__58580_58584 = null;
var count__58581_58585 = (0);
var i__58582_58586 = (0);
while(true){
if((i__58582_58586 < count__58581_58585)){
var msg_58587 = cljs.core._nth.call(null,chunk__58580_58584,i__58582_58586);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_58587);

var G__58588 = seq__58579_58583;
var G__58589 = chunk__58580_58584;
var G__58590 = count__58581_58585;
var G__58591 = (i__58582_58586 + (1));
seq__58579_58583 = G__58588;
chunk__58580_58584 = G__58589;
count__58581_58585 = G__58590;
i__58582_58586 = G__58591;
continue;
} else {
var temp__5459__auto___58592 = cljs.core.seq.call(null,seq__58579_58583);
if(temp__5459__auto___58592){
var seq__58579_58593__$1 = temp__5459__auto___58592;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__58579_58593__$1)){
var c__48006__auto___58594 = cljs.core.chunk_first.call(null,seq__58579_58593__$1);
var G__58595 = cljs.core.chunk_rest.call(null,seq__58579_58593__$1);
var G__58596 = c__48006__auto___58594;
var G__58597 = cljs.core.count.call(null,c__48006__auto___58594);
var G__58598 = (0);
seq__58579_58583 = G__58595;
chunk__58580_58584 = G__58596;
count__58581_58585 = G__58597;
i__58582_58586 = G__58598;
continue;
} else {
var msg_58599 = cljs.core.first.call(null,seq__58579_58593__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_58599);

var G__58600 = cljs.core.next.call(null,seq__58579_58593__$1);
var G__58601 = null;
var G__58602 = (0);
var G__58603 = (0);
seq__58579_58583 = G__58600;
chunk__58580_58584 = G__58601;
count__58581_58585 = G__58602;
i__58582_58586 = G__58603;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Error on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__58604){
var map__58605 = p__58604;
var map__58605__$1 = ((((!((map__58605 == null)))?((((map__58605.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58605.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58605):map__58605);
var w = map__58605__$1;
var message = cljs.core.get.call(null,map__58605__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/canvas/out/figwheel/client.cljs",33,1,363,363,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/canvas/out/figwheel/client.cljs",30,1,355,355,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__47063__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__47063__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__47063__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__58607 = cljs.core.seq.call(null,plugins);
var chunk__58608 = null;
var count__58609 = (0);
var i__58610 = (0);
while(true){
if((i__58610 < count__58609)){
var vec__58611 = cljs.core._nth.call(null,chunk__58608,i__58610);
var k = cljs.core.nth.call(null,vec__58611,(0),null);
var plugin = cljs.core.nth.call(null,vec__58611,(1),null);
if(cljs.core.truth_(plugin)){
var pl_58617 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__58607,chunk__58608,count__58609,i__58610,pl_58617,vec__58611,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_58617.call(null,msg_hist);
});})(seq__58607,chunk__58608,count__58609,i__58610,pl_58617,vec__58611,k,plugin))
);
} else {
}

var G__58618 = seq__58607;
var G__58619 = chunk__58608;
var G__58620 = count__58609;
var G__58621 = (i__58610 + (1));
seq__58607 = G__58618;
chunk__58608 = G__58619;
count__58609 = G__58620;
i__58610 = G__58621;
continue;
} else {
var temp__5459__auto__ = cljs.core.seq.call(null,seq__58607);
if(temp__5459__auto__){
var seq__58607__$1 = temp__5459__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__58607__$1)){
var c__48006__auto__ = cljs.core.chunk_first.call(null,seq__58607__$1);
var G__58622 = cljs.core.chunk_rest.call(null,seq__58607__$1);
var G__58623 = c__48006__auto__;
var G__58624 = cljs.core.count.call(null,c__48006__auto__);
var G__58625 = (0);
seq__58607 = G__58622;
chunk__58608 = G__58623;
count__58609 = G__58624;
i__58610 = G__58625;
continue;
} else {
var vec__58614 = cljs.core.first.call(null,seq__58607__$1);
var k = cljs.core.nth.call(null,vec__58614,(0),null);
var plugin = cljs.core.nth.call(null,vec__58614,(1),null);
if(cljs.core.truth_(plugin)){
var pl_58626 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__58607,chunk__58608,count__58609,i__58610,pl_58626,vec__58614,k,plugin,seq__58607__$1,temp__5459__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_58626.call(null,msg_hist);
});})(seq__58607,chunk__58608,count__58609,i__58610,pl_58626,vec__58614,k,plugin,seq__58607__$1,temp__5459__auto__))
);
} else {
}

var G__58627 = cljs.core.next.call(null,seq__58607__$1);
var G__58628 = null;
var G__58629 = (0);
var G__58630 = (0);
seq__58607 = G__58627;
chunk__58608 = G__58628;
count__58609 = G__58629;
i__58610 = G__58630;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__58632 = arguments.length;
switch (G__58632) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__58633_58638 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__58634_58639 = null;
var count__58635_58640 = (0);
var i__58636_58641 = (0);
while(true){
if((i__58636_58641 < count__58635_58640)){
var msg_58642 = cljs.core._nth.call(null,chunk__58634_58639,i__58636_58641);
figwheel.client.socket.handle_incoming_message.call(null,msg_58642);

var G__58643 = seq__58633_58638;
var G__58644 = chunk__58634_58639;
var G__58645 = count__58635_58640;
var G__58646 = (i__58636_58641 + (1));
seq__58633_58638 = G__58643;
chunk__58634_58639 = G__58644;
count__58635_58640 = G__58645;
i__58636_58641 = G__58646;
continue;
} else {
var temp__5459__auto___58647 = cljs.core.seq.call(null,seq__58633_58638);
if(temp__5459__auto___58647){
var seq__58633_58648__$1 = temp__5459__auto___58647;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__58633_58648__$1)){
var c__48006__auto___58649 = cljs.core.chunk_first.call(null,seq__58633_58648__$1);
var G__58650 = cljs.core.chunk_rest.call(null,seq__58633_58648__$1);
var G__58651 = c__48006__auto___58649;
var G__58652 = cljs.core.count.call(null,c__48006__auto___58649);
var G__58653 = (0);
seq__58633_58638 = G__58650;
chunk__58634_58639 = G__58651;
count__58635_58640 = G__58652;
i__58636_58641 = G__58653;
continue;
} else {
var msg_58654 = cljs.core.first.call(null,seq__58633_58648__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_58654);

var G__58655 = cljs.core.next.call(null,seq__58633_58648__$1);
var G__58656 = null;
var G__58657 = (0);
var G__58658 = (0);
seq__58633_58638 = G__58655;
chunk__58634_58639 = G__58656;
count__58635_58640 = G__58657;
i__58636_58641 = G__58658;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__48361__auto__ = [];
var len__48354__auto___58663 = arguments.length;
var i__48355__auto___58664 = (0);
while(true){
if((i__48355__auto___58664 < len__48354__auto___58663)){
args__48361__auto__.push((arguments[i__48355__auto___58664]));

var G__58665 = (i__48355__auto___58664 + (1));
i__48355__auto___58664 = G__58665;
continue;
} else {
}
break;
}

var argseq__48362__auto__ = ((((0) < args__48361__auto__.length))?(new cljs.core.IndexedSeq(args__48361__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__48362__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__58660){
var map__58661 = p__58660;
var map__58661__$1 = ((((!((map__58661 == null)))?((((map__58661.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58661.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58661):map__58661);
var opts = map__58661__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq58659){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq58659));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e58666){if((e58666 instanceof Error)){
var e = e58666;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e58666;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__58667){
var map__58668 = p__58667;
var map__58668__$1 = ((((!((map__58668 == null)))?((((map__58668.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58668.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58668):map__58668);
var msg_name = cljs.core.get.call(null,map__58668__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1509203651750
