// Compiled by ClojureScript 1.9.946 {}
goog.provide('lemonade.demos.canvas');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('cljs.spec.gen.alpha');
goog.require('lemonade.core');
goog.require('lemonade.examples.basic');
goog.require('lemonade.geometry');
goog.require('lemonade.renderers.canvas');
cljs.core.enable_console_print_BANG_.call(null);
lemonade.demos.canvas.canvas_elem = (function lemonade$demos$canvas$canvas_elem(){
return document.getElementById("canvas");
});
lemonade.demos.canvas.canvas_container = (function lemonade$demos$canvas$canvas_container(){
return document.getElementById("canvas-container");
});
lemonade.demos.canvas.canvas_container_dimensions = (function lemonade$demos$canvas$canvas_container_dimensions(){
var cc = lemonade.demos.canvas.canvas_container.call(null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cc.clientWidth,cc.clientHeight], null);
});
lemonade.demos.canvas.set_canvas_size_BANG_ = (function lemonade$demos$canvas$set_canvas_size_BANG_(canvas,p__53799){
var vec__53800 = p__53799;
var width = cljs.core.nth.call(null,vec__53800,(0),null);
var height = cljs.core.nth.call(null,vec__53800,(1),null);
canvas.width = width;

return canvas.height = height;
});
lemonade.demos.canvas.canvas_container_offset = (function lemonade$demos$canvas$canvas_container_offset(){
var c = lemonade.demos.canvas.canvas_container.call(null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [c.offsetLeft,c.offsetTop], null);
});
lemonade.demos.canvas.fullscreen_canvas_BANG_ = (function lemonade$demos$canvas$fullscreen_canvas_BANG_(){
var vec__53803 = lemonade.demos.canvas.canvas_container_dimensions.call(null);
var w = cljs.core.nth.call(null,vec__53803,(0),null);
var h = cljs.core.nth.call(null,vec__53803,(1),null);
var dim = vec__53803;
return lemonade.demos.canvas.set_canvas_size_BANG_.call(null,lemonade.demos.canvas.canvas_elem.call(null),dim);
});
lemonade.demos.canvas.context = (function lemonade$demos$canvas$context(){
return lemonade.demos.canvas.canvas_elem.call(null).getContext("2d");
});
lemonade.demos.canvas.clear_screen_BANG_ = (function lemonade$demos$canvas$clear_screen_BANG_(){
var vec__53806 = lemonade.demos.canvas.canvas_container_dimensions.call(null);
var w = cljs.core.nth.call(null,vec__53806,(0),null);
var h = cljs.core.nth.call(null,vec__53806,(1),null);
return lemonade.demos.canvas.context.call(null).clearRect((0),(0),w,h);
});
lemonade.demos.canvas.get_coord_inversion = (function lemonade$demos$canvas$get_coord_inversion(){
var vec__53809 = lemonade.demos.canvas.canvas_container_dimensions.call(null);
var _ = cljs.core.nth.call(null,vec__53809,(0),null);
var h = cljs.core.nth.call(null,vec__53809,(1),null);
return lemonade.geometry.atx.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(0),(0),(-1)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),h], null));
});
lemonade.demos.canvas.draw_BANG_ = (function lemonade$demos$canvas$draw_BANG_(shape){
var shape_STAR_ = lemonade.core.transform.call(null,shape,lemonade.demos.canvas.get_coord_inversion.call(null));
var render = lemonade.renderers.canvas.renderer.call(null,shape_STAR_);
lemonade.demos.canvas.clear_screen_BANG_.call(null);

return render.call(null,lemonade.demos.canvas.context.call(null));
});
lemonade.demos.canvas.draw_rand = (function lemonade$demos$canvas$draw_rand(){
var shape = cljs.spec.gen.alpha.generate.call(null,cljs.spec.alpha.gen.call(null,new cljs.core.Keyword("lemonade.core","primitive-shape","lemonade.core/primitive-shape",1001516842)));
cljs.spec.alpha.explain.call(null,new cljs.core.Keyword("lemonade.core","shape","lemonade.core/shape",-758634024),shape);

return lemonade.demos.canvas.draw_BANG_.call(null,shape);
});
lemonade.demos.canvas.init = (function lemonade$demos$canvas$init(){
lemonade.demos.canvas.fullscreen_canvas_BANG_.call(null);

return lemonade.demos.canvas.draw_BANG_.call(null,lemonade.examples.basic.ex);
});
goog.exportSymbol('lemonade.demos.canvas.init', lemonade.demos.canvas.init);
lemonade.demos.canvas.on_js_reload = (function lemonade$demos$canvas$on_js_reload(){
return lemonade.demos.canvas.init.call(null);
});

//# sourceMappingURL=canvas.js.map?rel=1509401073717
