(ns madstap.comfy.walk-scratch
  (:require
   [clojure.walk :as core.walk]
   [madstap.comfy.walk :as walk]))

(defn reducer->transducer [reducer]
  (fn transducer
    ([xform rf form]
     (transducer rf (rf) form))
    ([xform rf init form]
     )))


(comment

  (walk/pre-transduce (filter number?) conj [] [1 2 [3 4]])


  )

;; https://en.wikipedia.org/wiki/Tree_traversal

;; post-walk reduce

;; Does the easiest possible thing, piggybacks on clojure.core/walk.
;; Creates an intermediate collection of all possible steps before
;; reducing/transducing over it which might be ... less than optimal, perf-wise.

;; If switched with another implementation
;; keep these as a reference for use in a generative test.


(comment

  (run-all-tests)

  )

(comment

  ;; The clojure.walk implementation of walking
  ;; Just need to re-engineer it to use reduce instead of map.

  (defn depth-first-reduce
    "rf (reducing-function) is "
    {:no-doc "Change the name?"
     :added ""}
    [rf init coll]
    (reduce (fn [acc x]
              (let [new-acc (rf acc x)]
                (if (seqable? x) (depth-first-reduce rf new-acc x) new-acc)))
            init coll))

  )

(comment


  (post-reduce conj [] [1 2 [3 4]])

  (walk/post-transduce identity conj [] [1 2 [3 4]])

  (walk/post-transduce (filter number?) conj [] [1 2 [[3] 4]])

  (postwalk-transduce identity conj [] [1 2 [3 4]])


  )
