/*
 * Decompiled with CFR 0.152.
 */
package magicgen;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@SupportedAnnotationTypes(value={"com.magic.client.annotation.Name"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class ModelProcessor
extends AbstractProcessor {
    static final String PACKAGE = "com.magic.";
    private Filer filer;
    private Elements elementsUtil;
    private Types typeUtils;
    private static String LINE_SEPARATOR = System.getProperty("line.separator");

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ProcessingEnvironment env = this.processingEnv;
        this.elementsUtil = env.getElementUtils();
        this.filer = env.getFiler();
        this.typeUtils = env.getTypeUtils();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                if (!element.getKind().equals((Object)ElementKind.CLASS)) continue;
                try {
                    TypeElement d = (TypeElement)element;
                    PackageElement pack = this.elementsUtil.getPackageOf(d);
                    String packageName = pack.getQualifiedName().toString();
                    int modelIndex = packageName.lastIndexOf(".model");
                    if (modelIndex == -1) {
                        System.out.println(d.getQualifiedName() + " does not qualified for a model type");
                        continue;
                    }
                    this.makeMeta(d);
                    this.makePlace(d);
                    this.makeServiceInterface(d);
                    this.makeServiceServiceBase(d);
                    this.makeDefaultTemplate(d);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void makeMeta(TypeElement d) {
        PrintWriter writer;
        PackageElement pack = this.elementsUtil.getPackageOf(d);
        String packageName = pack.getQualifiedName().toString();
        String simpleName = d.getSimpleName().toString();
        String name = String.valueOf(simpleName) + "Meta";
        String qualifiedName = String.valueOf(packageName) + "." + name;
        try {
            writer = new PrintWriter(this.filer.createSourceFile(qualifiedName, new Element[0]).openWriter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        writer.println("package " + packageName + ";");
        writer.println();
        writer.println("import " + HashMap.class.getCanonicalName() + ";");
        writer.println("import com.magic.client.Commons;");
        writer.println("import com.guit.client.dom.Form;");
        writer.println("import com.magic.client.Crud;");
        writer.println("import com.magic.client.CrudConfiguration;");
        writer.println("import com.magic.client.CrudServiceAsync;");
        writer.println("import com.google.inject.Inject;");
        writer.println("import com.guit.client.command.Async;");
        writer.println();
        writer.println("public class " + name + " implements CrudConfiguration<" + simpleName + "> {");
        StringBuilder titles = new StringBuilder();
        StringBuilder get = new StringBuilder();
        StringBuilder set = new StringBuilder();
        StringBuilder form = new StringBuilder();
        StringBuilder allFields = new StringBuilder();
        set.append(String.valueOf(LINE_SEPARATOR) + "      form.setFieldValue(\"id\", Commons.string(value.getId()));");
        get.append(String.valueOf(LINE_SEPARATOR) + "    val = element.getFieldValue(\"id\");");
        get.append(String.valueOf(LINE_SEPARATOR) + "    Long idVal = Commons.tolong(val);");
        get.append(String.valueOf(LINE_SEPARATOR) + "    if (val != null) value.setId(idVal == null ? 0 : idVal);");
        writer.println();
        writer.println("  @Inject");
        writer.println("  public Crud<" + simpleName + "> crud;");
        writer.println();
        writer.println("  public " + simpleName + " create() {");
        writer.println("    return new " + simpleName + "();");
        writer.println("  }");
        writer.println();
        writer.println("  @Inject");
        String servicePackage = packageName.substring(0, packageName.lastIndexOf(".model"));
        writer.println("  " + servicePackage + "." + simpleName + "ServiceAsync service;");
        writer.println();
        writer.println("  public void init(Class<?> template) {");
        String provider = d.getQualifiedName() + "DefaultTemplate.instance";
        List templates = null;
        String table = d.getSimpleName().toString();
        List<? extends AnnotationMirror> mirrors = d.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : mirrors) {
            String sn;
            String qn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
            if (qn.equals("com.magic.client.annotation.Template")) {
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    sn = entry.getKey().getSimpleName().toString();
                    if (sn.equals("provider")) {
                        provider = "new " + ((TypeMirror)entry.getValue().getValue()).toString() + "()";
                        continue;
                    }
                    if (!sn.equals("templates")) continue;
                    templates = (List)entry.getValue().getValue();
                }
                continue;
            }
            if (!qn.equals("javax.persistence.Entity")) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                sn = entry.getKey().getSimpleName().toString();
                if (!sn.equals("name")) continue;
                table = (String)entry.getValue().getValue();
            }
        }
        writer.println("    com.magic.client.TemplateProvider templateInstance = " + provider + ";");
        writer.println("    crud.setDefaultTemplate(templateInstance);");
        if (templates != null) {
            writer.println("    if (template != null) {");
            for (AnnotationMirror annotationMirror : templates) {
                String canonical = annotationMirror.toString();
                if (canonical.endsWith(".class")) {
                    canonical = canonical.substring(0, canonical.length() - 6);
                }
                writer.println("      if (template.equals(" + canonical + ".class)) templateInstance = new " + canonical + "();");
            }
            writer.println("    }");
        }
        writer.println("    crud.setTemplate(templateInstance);");
        writer.println("    crud.setCrudConfiguration(this);");
        writer.println("  }");
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<VariableElement> fields = new ArrayList<VariableElement>(ElementFilter.fieldsIn(this.elementsUtil.getAllMembers(d)));
        if (this.typeUtils.isAssignable(d.asType(), this.elementsUtil.getTypeElement("com.magic.client.model.OwnedModel").asType())) {
            titles.append(String.valueOf(LINE_SEPARATOR) + "    titles.put(\"mainRecord\", \"Principal\");");
            get.append(String.valueOf(LINE_SEPARATOR) + "    val = element.getFieldValue(\"mainRecord\");");
            get.append(String.valueOf(LINE_SEPARATOR) + "    if (val != null) value.setMainRecord(Commons.toboolean(val));");
            set.append(String.valueOf(LINE_SEPARATOR) + "      form.setFieldValue(\"mainRecord\", Commons.string(value.getMainRecord()));");
            writer.println();
            writer.print("  public final static String mainRecord =  \"");
            writer.print("<input style='width:30px' type='checkbox' ");
            writer.print("name='mainRecord'></input>");
            writer.println("\";");
            form.append("mainRecord");
            allFields.append("mainRecord");
        }
        for (VariableElement f : fields) {
            String qn;
            void var22_31;
            Object var22_30 = null;
            String relationType = null;
            Integer popupx = null;
            Integer popupy = null;
            Integer popupwidth = null;
            Integer popupheight = null;
            TypeMirror templateProvider = null;
            boolean isPassword = false;
            boolean isLob = false;
            boolean ignore = false;
            TypeMirror fieldType = f.asType();
            TypeElement fieldTypeElement = (TypeElement)this.typeUtils.asElement(fieldType);
            List<? extends AnnotationMirror> annotations = f.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : annotations) {
                TypeElement aElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
                String annotationType = aElement.getQualifiedName().toString();
                if (annotationType.equals("com.magic.client.annotation.IgnoreField")) {
                    ignore = true;
                    continue;
                }
                if (annotationType.equals("com.magic.client.annotation.Password")) {
                    isPassword = true;
                    continue;
                }
                if (annotationType.equals("javax.persistence.Lob")) {
                    isLob = true;
                    continue;
                }
                if (annotationType.equals("com.magic.client.annotation.Name")) {
                    String string = (String)annotationMirror.getElementValues().entrySet().iterator().next().getValue().getValue();
                    continue;
                }
                if (!annotationType.equals("com.magic.client.annotation.Relation")) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror.getElementValues().entrySet()) {
                    String valueName = e.getKey().getSimpleName().toString();
                    Object value = e.getValue().getValue();
                    if (valueName.equals("type")) {
                        TypeElement typeElement = (TypeElement)this.typeUtils.asElement((TypeMirror)value);
                        relationType = String.valueOf(typeElement.getQualifiedName().toString()) + "Meta";
                        continue;
                    }
                    if (valueName.equals("x")) {
                        popupx = (Integer)value;
                        continue;
                    }
                    if (valueName.equals("y")) {
                        popupy = (Integer)value;
                        continue;
                    }
                    if (valueName.equals("w")) {
                        popupwidth = (Integer)value;
                        continue;
                    }
                    if (valueName.equals("h")) {
                        popupheight = (Integer)value;
                        continue;
                    }
                    if (!valueName.equals("provider")) continue;
                    templateProvider = (TypeMirror)value;
                }
            }
            if (ignore) continue;
            boolean bl = relationType != null && fieldTypeElement.getQualifiedName().toString().equals("java.lang.Boolean");
            String fieldName = f.getSimpleName().toString();
            if (var22_31 == null) continue;
            if (!bl) {
                titles.append(String.valueOf(LINE_SEPARATOR) + "    titles.put(\"" + fieldName + "\", \"" + (String)var22_31 + "\");");
            }
            if (form.length() > 0) {
                form.append(" + ");
            }
            form.append(fieldName);
            if (allFields.length() > 0) {
                allFields.append(", ");
            }
            allFields.append(fieldName);
            if (relationType != null) {
                writer.println();
                writer.println("  @Inject");
                writer.println("  public com.guit.client.gin.Lazy<" + relationType + "> " + fieldName + "Program;");
                stringBuilder.append(String.valueOf(LINE_SEPARATOR) + "    if (action.equals(\"" + fieldName + "\"))");
                stringBuilder.append(String.valueOf(LINE_SEPARATOR) + "      " + fieldName + "Program.get().popup(callback, entityId, \"" + table + "\", " + (popupx == null ? "null" : popupx + ".0") + ", " + (popupy == null ? "null" : popupy + ".0") + ", " + (popupwidth == null ? "null" : popupwidth + ".0") + ", " + (popupheight == null ? "null" : popupheight + ".0") + ", " + (templateProvider == null ? "null" : String.valueOf(templateProvider.toString()) + ".class") + "," + (bl ? "true" : "false") + ");");
            }
            String type = "text";
            String extra = "";
            String placeholder = null;
            int width = 100;
            String convertion = null;
            List<? extends AnnotationMirror> mirr = f.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : mirr) {
                qn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
                if (!qn.equals("com.magic.client.annotation.Width")) continue;
                width = (Integer)annotationMirror.getElementValues().entrySet().iterator().next().getValue().getValue();
            }
            if (f.getModifiers().contains((Object)Modifier.TRANSIENT)) {
                writer.println("  public final static String " + fieldName + " = \"<input style='width:" + width + "px' name='" + fieldName + "' alwaysreadonly='' placeholder='" + (String)var22_31 + "'></input>\";");
                TypeElement typeElement = (TypeElement)this.typeUtils.asElement(f.asType());
                String cQualifiedName = typeElement.getQualifiedName().toString();
                writer.println();
                writer.println("  @Inject");
                writer.println("  public com.guit.client.gin.Lazy<" + cQualifiedName + "Meta> " + fieldName + "Program;");
                stringBuilder.append(String.valueOf(LINE_SEPARATOR) + "    if (action.equals(\"" + fieldName + "\"))");
                stringBuilder.append(String.valueOf(LINE_SEPARATOR) + "      " + fieldName + "Program.get().popup(callback, entityId, \"" + table + "\", " + (popupx == null ? "null" : popupx + ".0") + ", " + (popupy == null ? "null" : popupy + ".0") + ", " + (popupwidth == null ? "null" : popupwidth + ".0") + ", " + (popupheight == null ? "null" : popupheight + ".0") + ", " + (templateProvider == null ? "null" : String.valueOf(templateProvider.toString()) + ".class") + ", false" + ");");
                continue;
            }
            writer.println();
            writer.print("  public final static String " + fieldName + " =  \"");
            String string = String.valueOf(fieldName.substring(0, 1).toUpperCase()) + fieldName.substring(1);
            ElementKind kind = fieldTypeElement.getKind();
            switch (kind) {
                case ENUM: {
                    convertion = "enum";
                    extra = "select";
                    get.append(String.valueOf(LINE_SEPARATOR) + "    value.set" + string + "(Commons.to" + convertion + "(" + fieldTypeElement.getQualifiedName().toString() + ".class, element.getFieldValue(\"" + fieldName + "\")));");
                    break;
                }
                case CLASS: {
                    qn = fieldTypeElement.getQualifiedName().toString();
                    if (qn.equals(String.class.getCanonicalName())) {
                        if (isPassword) {
                            type = "password";
                        }
                        if (isLob) {
                            extra = "lob";
                        }
                        convertion = "string";
                    } else if (qn.equals(Date.class.getCanonicalName())) {
                        placeholder = "DD/MM/YYYY";
                        convertion = "date";
                    } else if (qn.equals(Boolean.class.getCanonicalName())) {
                        convertion = "boolean";
                        type = "checkbox";
                    } else if (qn.equals(Double.class.getCanonicalName())) {
                        convertion = "double";
                        type = "number";
                    } else if (qn.equals(Integer.class.getCanonicalName())) {
                        convertion = "integer";
                        type = "number";
                    } else if (qn.equals(Long.class.getCanonicalName())) {
                        convertion = "long";
                        type = "number";
                    }
                    get.append(String.valueOf(LINE_SEPARATOR) + "    val = element.getFieldValue(\"" + fieldName + "\");");
                    get.append(String.valueOf(LINE_SEPARATOR) + "    if (val != null) value.set" + string + "(Commons.to" + convertion + "(val));");
                }
            }
            set.append(String.valueOf(LINE_SEPARATOR) + "      form.setFieldValue(\"" + fieldName + "\", Commons.string(value.get" + string + "()));");
            if (relationType != null && width == 100) {
                width = !bl ? 30 : 15;
            }
            writer.print("<input style='width:" + width + "px' type='" + type + "' ");
            writer.print(String.valueOf(extra) + " ");
            if (placeholder != null) {
                writer.print("placeholder='" + placeholder + "' ");
            } else {
                writer.print("placeholder='" + (String)var22_31 + "' ");
            }
            if (bl) {
                writer.print("onetoone='true' ");
            }
            writer.print("name='" + fieldName + "'></input>");
            if (relationType != null && !bl) {
                writer.print("<label forrelation='' for='" + fieldName + "' style='width:70px'></label>");
            }
            if (type.equals("checkbox")) {
                writer.print("<label forcheckbox='' for='" + fieldName + "' style='width:65px'>" + (String)var22_31 + "</label>");
            }
            writer.println("\";");
        }
        writer.println();
        writer.println("  public final static String form = " + form + ";");
        writer.println("  public final static String[] allFields = new String[]{" + allFields + "};");
        writer.println();
        String title = d.getSimpleName().toString();
        List<? extends AnnotationMirror> am = d.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : am) {
            String qn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
            if (!qn.equals("com.magic.client.annotation.Name")) continue;
            title = (String)annotationMirror.getElementValues().entrySet().iterator().next().getValue().getValue();
        }
        writer.println("  public String title() {");
        writer.println("    return \"" + title + "\";");
        writer.println("  }");
        writer.println();
        writer.println("  public " + simpleName + " get(Form element) {");
        writer.println("    " + simpleName + " value = new " + simpleName + "();");
        writer.println("    String val;");
        writer.println("    " + get);
        writer.println("    return value;");
        writer.println("  }");
        writer.println();
        writer.println("  public void set(Form form, " + simpleName + " value) {");
        writer.println("    " + set);
        writer.println("  }");
        writer.println();
        writer.println("  public HashMap<String, String> titles() {");
        writer.println("    HashMap<String, String> titles = new HashMap<String, String>();");
        writer.println("    " + titles.toString());
        writer.println("    return titles;");
        writer.println("  }");
        writer.println();
        writer.println("  public void onAction(String action, long entityId, final Async<Long> callback) {");
        writer.println(stringBuilder);
        writer.println("  }");
        writer.println();
        writer.println("  public CrudServiceAsync<" + simpleName + "> getService() {");
        writer.println("    return service;");
        writer.println("  }");
        writer.println();
        writer.println("  public void exit() {");
        writer.println("    crud.exit();");
        writer.println("  }");
        writer.println();
        writer.println("  public void popup(Async<Long> callback, long entityId, String entityName, Double x, Double y, Double w, Double h, Class<?> provider, boolean oneToOne) {");
        writer.println("    crud.popup(callback, entityId, entityName, x, y, w, h, oneToOne);");
        writer.println("    init(provider);");
        writer.println("  }");
        writer.println();
        writer.println("  public void setViewTo(com.google.gwt.user.client.ui.AcceptsOneWidget panel) {");
        writer.println("    crud.setViewTo(panel);");
        writer.println("  }");
        writer.println("}");
        writer.close();
    }

    public void makePlace(TypeElement d) {
        PrintWriter writer;
        PackageElement pack = this.elementsUtil.getPackageOf(d);
        String packageName = pack.getQualifiedName().toString();
        String simpleName = d.getSimpleName().toString();
        String name = String.valueOf(simpleName) + "Place";
        String qualifiedName = String.valueOf(packageName) + "." + name;
        try {
            writer = new PrintWriter(this.filer.createSourceFile(qualifiedName, new Element[0]).openWriter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        writer.println("package " + packageName + ";");
        writer.println();
        writer.println("import com.google.gwt.user.client.ui.AcceptsOneWidget;");
        writer.println("import com.google.inject.Inject;");
        writer.println("import com.guit.client.place.LeavePlace;");
        writer.println("import com.magic.client.Center;");
        writer.println();
        writer.println("public class " + name + " implements LeavePlace<Void> {");
        writer.println();
        writer.println("  @Inject");
        writer.println("  public " + simpleName + "Meta meta;");
        writer.println();
        writer.println("  @Inject");
        writer.println("  @Center");
        writer.println("  AcceptsOneWidget display;");
        writer.println();
        writer.println("  @Override");
        writer.println("  public void go(Void data) {");
        writer.println("    meta.init(null);");
        writer.println("    meta.setViewTo(display);");
        writer.println("  }");
        writer.println();
        writer.println("  @Override");
        writer.println("  public void leave() {");
        writer.println("    meta.exit();");
        writer.println("  }");
        writer.println("}");
        writer.close();
    }

    private void makeServiceInterface(TypeElement d) {
        PrintWriter writer;
        PackageElement pack = this.elementsUtil.getPackageOf(d);
        String packageName = pack.getQualifiedName().toString();
        packageName = String.valueOf(packageName.substring(0, packageName.indexOf(".client"))) + ".server";
        String simpleName = d.getSimpleName().toString();
        String name = String.valueOf(simpleName) + "Service";
        String qualifiedName = String.valueOf(packageName) + "." + name;
        try {
            writer = new PrintWriter(this.filer.createSourceFile(qualifiedName, new Element[0]).openWriter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        writer.println("package " + packageName + ";");
        writer.println();
        writer.println("import com.google.inject.ImplementedBy;");
        writer.println("import com.guit.client.apt.GuitService;");
        writer.println("import com.magic.client.EntityWithRelations;");
        writer.println("import com.magic.client.ModelQuery;");
        writer.println("import " + d.getQualifiedName() + ";");
        writer.println();
        writer.println("@GuitService(implement = \"com.magic.client.CrudServiceAsync<" + d.getQualifiedName() + ">\")");
        writer.println("@ImplementedBy(" + simpleName + "ServiceImpl.class)");
        writer.println("public interface " + name + " {");
        writer.println("  long allocId();");
        writer.println("  EntityWithRelations<" + simpleName + "> save(" + simpleName + " entity, Long dependantId, String dependantEntity);");
        writer.println("  ModelQuery<" + simpleName + "> list(int offset, " + simpleName + " localize, " + simpleName + " range, Long dependantId, String dependantEntity);");
        writer.println("  String getRelation(long relationId, String relation);");
        writer.println("  String getRelation(" + simpleName + " e, Long relationId, String relation);");
        writer.println("  void delete(long id);");
        writer.println("  String information(long id);");
        writer.println("  boolean updateId(long oldId, long newId);");
        writer.println("  EntityWithRelations<" + simpleName + "> find(long id);");
        writer.println("}");
        writer.close();
    }

    private void makeServiceServiceBase(TypeElement d) {
        PrintWriter writer;
        PackageElement pack = this.elementsUtil.getPackageOf(d);
        String packageName = pack.getQualifiedName().toString();
        packageName = String.valueOf(packageName.substring(0, packageName.indexOf(".client"))) + ".server";
        String simpleName = d.getSimpleName().toString();
        String name = String.valueOf(simpleName) + "ServiceImpl";
        String qualifiedName = String.valueOf(packageName) + "." + name;
        try {
            writer = new PrintWriter(this.filer.createSourceFile(qualifiedName, new Element[0]).openWriter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        writer.println("package " + packageName + ";");
        writer.println();
        writer.println("import " + d.getQualifiedName() + ";");
        writer.println("import com.magic.server.ModelService;");
        writer.println();
        writer.println("public class " + name + " extends ModelService<" + simpleName + "> implements " + simpleName + "Service {");
        writer.println();
        writer.println("  public " + name + "() {");
        writer.println("    super(" + simpleName + ".class);");
        writer.println("  }");
        writer.println("}");
        writer.close();
    }

    private void makeDefaultTemplate(TypeElement d) {
        PrintWriter writer;
        PackageElement pack = this.elementsUtil.getPackageOf(d);
        String packageName = pack.getQualifiedName().toString();
        String simpleName = d.getSimpleName().toString();
        String name = String.valueOf(simpleName) + "DefaultTemplate";
        String qualifiedName = String.valueOf(packageName) + "." + name;
        try {
            writer = new PrintWriter(this.filer.createSourceFile(qualifiedName, new Element[0]).openWriter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        writer.println("package " + packageName + ";");
        writer.println();
        writer.println("import static " + d.getQualifiedName() + "Meta.*;");
        writer.println("import com.magic.client.TemplateProvider;");
        writer.println();
        writer.println("public class " + name + " implements TemplateProvider {");
        writer.println();
        writer.println("  public static " + name + " instance = new " + name + "();");
        writer.println();
        writer.println("  public String build() {");
        writer.println("    return form;");
        writer.println("  }");
        writer.println();
        writer.println("  public int width() {");
        writer.println("    return 0;");
        writer.println("  }");
        writer.println();
        writer.println("  public boolean hasHeader() {");
        writer.println("    return true;");
        writer.println("  }");
        writer.println();
        writer.println("  public boolean hasInformation() {");
        writer.println("    return false;");
        writer.println("  }");
        writer.println();
        writer.println("  public boolean idVisible() {");
        writer.println("    return true;");
        writer.println("  }");
        writer.println("}");
        writer.close();
    }
}

