(ns biscuit.tables)

(def crc5
  [0x00 0x70 0xe0 0x90 0x88 0xf8 0x68 0x18 0x58 0x28 0xb8 0xc8 0xd0 0xa0 0x30 0x40 0xb0 0xc0 0x50 0x20 0x38 0x48 0xd8 0xa8 0xe8 0x98 0x08 0x78 0x60 0x10 0x80 0xf0 0x28 0x58 0xc8 0xb8 0xa0 0xd0 0x40 0x30 0x70 0x00 0x90 0xe0 0xf8 0x88 0x18 0x68 0x98 0xe8 0x78 0x08 0x10 0x60 0xf0 0x80 0xc0 0xb0 0x20 0x50 0x48 0x38 0xa8 0xd8 0x50 0x20 0xb0 0xc0 0xd8 0xa8 0x38 0x48 0x08 0x78 0xe8 0x98 0x80 0xf0 0x60 0x10 0xe0 0x90 0x00 0x70 0x68 0x18 0x88 0xf8 0xb8 0xc8 0x58 0x28 0x30 0x40 0xd0 0xa0 0x78 0x08 0x98 0xe8 0xf0 0x80 0x10 0x60 0x20 0x50 0xc0 0xb0 0xa8 0xd8 0x48 0x38 0xc8 0xb8 0x28 0x58 0x40 0x30 0xa0 0xd0 0x90 0xe0 0x70 0x00 0x18 0x68 0xf8 0x88 0xa0 0xd0 0x40 0x30 0x28 0x58 0xc8 0xb8 0xf8 0x88 0x18 0x68 0x70 0x00 0x90 0xe0 0x10 0x60 0xf0 0x80 0x98 0xe8 0x78 0x08 0x48 0x38 0xa8 0xd8 0xc0 0xb0 0x20 0x50 0x88 0xf8 0x68 0x18 0x00 0x70 0xe0 0x90 0xd0 0xa0 0x30 0x40 0x58 0x28 0xb8 0xc8 0x38 0x48 0xd8 0xa8 0xb0 0xc0 0x50 0x20 0x60 0x10 0x80 0xf0 0xe8 0x98 0x08 0x78 0xf0 0x80 0x10 0x60 0x78 0x08 0x98 0xe8 0xa8 0xd8 0x48 0x38 0x20 0x50 0xc0 0xb0 0x40 0x30 0xa0 0xd0 0xc8 0xb8 0x28 0x58 0x18 0x68 0xf8 0x88 0x90 0xe0 0x70 0x00 0xd8 0xa8 0x38 0x48 0x50 0x20 0xb0 0xc0 0x80 0xf0 0x60 0x10 0x08 0x78 0xe8 0x98 0x68 0x18 0x88 0xf8 0xe0 0x90 0x00 0x70 0x30 0x40 0xd0 0xa0 0xb8 0xc8 0x58 0x28])

(def crc8-1wire
  [0x00 0x5e 0xbc 0xe2 0x61 0x3f 0xdd 0x83 0xc2 0x9c 0x7e 0x20 0xa3 0xfd 0x1f 0x41 0x9d 0xc3 0x21 0x7f 0xfc 0xa2 0x40 0x1e 0x5f 0x01 0xe3 0xbd 0x3e 0x60 0x82 0xdc 0x23 0x7d 0x9f 0xc1 0x42 0x1c 0xfe 0xa0 0xe1 0xbf 0x5d 0x03 0x80 0xde 0x3c 0x62 0xbe 0xe0 0x02 0x5c 0xdf 0x81 0x63 0x3d 0x7c 0x22 0xc0 0x9e 0x1d 0x43 0xa1 0xff 0x46 0x18 0xfa 0xa4 0x27 0x79 0x9b 0xc5 0x84 0xda 0x38 0x66 0xe5 0xbb 0x59 0x07 0xdb 0x85 0x67 0x39 0xba 0xe4 0x06 0x58 0x19 0x47 0xa5 0xfb 0x78 0x26 0xc4 0x9a 0x65 0x3b 0xd9 0x87 0x04 0x5a 0xb8 0xe6 0xa7 0xf9 0x1b 0x45 0xc6 0x98 0x7a 0x24 0xf8 0xa6 0x44 0x1a 0x99 0xc7 0x25 0x7b 0x3a 0x64 0x86 0xd8 0x5b 0x05 0xe7 0xb9 0x8c 0xd2 0x30 0x6e 0xed 0xb3 0x51 0x0f 0x4e 0x10 0xf2 0xac 0x2f 0x71 0x93 0xcd 0x11 0x4f 0xad 0xf3 0x70 0x2e 0xcc 0x92 0xd3 0x8d 0x6f 0x31 0xb2 0xec 0x0e 0x50 0xaf 0xf1 0x13 0x4d 0xce 0x90 0x72 0x2c 0x6d 0x33 0xd1 0x8f 0x0c 0x52 0xb0 0xee 0x32 0x6c 0x8e 0xd0 0x53 0x0d 0xef 0xb1 0xf0 0xae 0x4c 0x12 0x91 0xcf 0x2d 0x73 0xca 0x94 0x76 0x28 0xab 0xf5 0x17 0x49 0x08 0x56 0xb4 0xea 0x69 0x37 0xd5 0x8b 0x57 0x09 0xeb 0xb5 0x36 0x68 0x8a 0xd4 0x95 0xcb 0x29 0x77 0xf4 0xaa 0x48 0x16 0xe9 0xb7 0x55 0x0b 0x88 0xd6 0x34 0x6a 0x2b 0x75 0x97 0xc9 0x4a 0x14 0xf6 0xa8 0x74 0x2a 0xc8 0x96 0x15 0x4b 0xa9 0xf7 0xb6 0xe8 0x0a 0x54 0xd7 0x89 0x6b 0x35])

(def crc8
  [0x00 0x07 0x0e 0x09 0x1c 0x1b 0x12 0x15 0x38 0x3f 0x36 0x31 0x24 0x23 0x2a 0x2d 0x70 0x77 0x7e 0x79 0x6c 0x6b 0x62 0x65 0x48 0x4f 0x46 0x41 0x54 0x53 0x5a 0x5d 0xe0 0xe7 0xee 0xe9 0xfc 0xfb 0xf2 0xf5 0xd8 0xdf 0xd6 0xd1 0xc4 0xc3 0xca 0xcd 0x90 0x97 0x9e 0x99 0x8c 0x8b 0x82 0x85 0xa8 0xaf 0xa6 0xa1 0xb4 0xb3 0xba 0xbd 0xc7 0xc0 0xc9 0xce 0xdb 0xdc 0xd5 0xd2 0xff 0xf8 0xf1 0xf6 0xe3 0xe4 0xed 0xea 0xb7 0xb0 0xb9 0xbe 0xab 0xac 0xa5 0xa2 0x8f 0x88 0x81 0x86 0x93 0x94 0x9d 0x9a 0x27 0x20 0x29 0x2e 0x3b 0x3c 0x35 0x32 0x1f 0x18 0x11 0x16 0x03 0x04 0x0d 0x0a 0x57 0x50 0x59 0x5e 0x4b 0x4c 0x45 0x42 0x6f 0x68 0x61 0x66 0x73 0x74 0x7d 0x7a 0x89 0x8e 0x87 0x80 0x95 0x92 0x9b 0x9c 0xb1 0xb6 0xbf 0xb8 0xad 0xaa 0xa3 0xa4 0xf9 0xfe 0xf7 0xf0 0xe5 0xe2 0xeb 0xec 0xc1 0xc6 0xcf 0xc8 0xdd 0xda 0xd3 0xd4 0x69 0x6e 0x67 0x60 0x75 0x72 0x7b 0x7c 0x51 0x56 0x5f 0x58 0x4d 0x4a 0x43 0x44 0x19 0x1e 0x17 0x10 0x05 0x02 0x0b 0x0c 0x21 0x26 0x2f 0x28 0x3d 0x3a 0x33 0x34 0x4e 0x49 0x40 0x47 0x52 0x55 0x5c 0x5b 0x76 0x71 0x78 0x7f 0x6a 0x6d 0x64 0x63 0x3e 0x39 0x30 0x37 0x22 0x25 0x2c 0x2b 0x06 0x01 0x08 0x0f 0x1a 0x1d 0x14 0x13 0xae 0xa9 0xa0 0xa7 0xb2 0xb5 0xbc 0xbb 0x96 0x91 0x98 0x9f 0x8a 0x8d 0x84 0x83 0xde 0xd9 0xd0 0xd7 0xc2 0xc5 0xcc 0xcb 0xe6 0xe1 0xe8 0xef 0xfa 0xfd 0xf4 0xf3])

(def crc16
  [0x0000 0xc0c1 0xc181 0x0140 0xc301 0x03c0 0x0280 0xc241 0xc601 0x06c0 0x0780 0xc741 0x0500 0xc5c1 0xc481 0x0440 0xcc01 0x0cc0 0x0d80 0xcd41 0x0f00 0xcfc1 0xce81 0x0e40 0x0a00 0xcac1 0xcb81 0x0b40 0xc901 0x09c0 0x0880 0xc841 0xd801 0x18c0 0x1980 0xd941 0x1b00 0xdbc1 0xda81 0x1a40 0x1e00 0xdec1 0xdf81 0x1f40 0xdd01 0x1dc0 0x1c80 0xdc41 0x1400 0xd4c1 0xd581 0x1540 0xd701 0x17c0 0x1680 0xd641 0xd201 0x12c0 0x1380 0xd341 0x1100 0xd1c1 0xd081 0x1040 0xf001 0x30c0 0x3180 0xf141 0x3300 0xf3c1 0xf281 0x3240 0x3600 0xf6c1 0xf781 0x3740 0xf501 0x35c0 0x3480 0xf441 0x3c00 0xfcc1 0xfd81 0x3d40 0xff01 0x3fc0 0x3e80 0xfe41 0xfa01 0x3ac0 0x3b80 0xfb41 0x3900 0xf9c1 0xf881 0x3840 0x2800 0xe8c1 0xe981 0x2940 0xeb01 0x2bc0 0x2a80 0xea41 0xee01 0x2ec0 0x2f80 0xef41 0x2d00 0xedc1 0xec81 0x2c40 0xe401 0x24c0 0x2580 0xe541 0x2700 0xe7c1 0xe681 0x2640 0x2200 0xe2c1 0xe381 0x2340 0xe101 0x21c0 0x2080 0xe041 0xa001 0x60c0 0x6180 0xa141 0x6300 0xa3c1 0xa281 0x6240 0x6600 0xa6c1 0xa781 0x6740 0xa501 0x65c0 0x6480 0xa441 0x6c00 0xacc1 0xad81 0x6d40 0xaf01 0x6fc0 0x6e80 0xae41 0xaa01 0x6ac0 0x6b80 0xab41 0x6900 0xa9c1 0xa881 0x6840 0x7800 0xb8c1 0xb981 0x7940 0xbb01 0x7bc0 0x7a80 0xba41 0xbe01 0x7ec0 0x7f80 0xbf41 0x7d00 0xbdc1 0xbc81 0x7c40 0xb401 0x74c0 0x7580 0xb541 0x7700 0xb7c1 0xb681 0x7640 0x7200 0xb2c1 0xb381 0x7340 0xb101 0x71c0 0x7080 0xb041 0x5000 0x90c1 0x9181 0x5140 0x9301 0x53c0 0x5280 0x9241 0x9601 0x56c0 0x5780 0x9741 0x5500 0x95c1 0x9481 0x5440 0x9c01 0x5cc0 0x5d80 0x9d41 0x5f00 0x9fc1 0x9e81 0x5e40 0x5a00 0x9ac1 0x9b81 0x5b40 0x9901 0x59c0 0x5880 0x9841 0x8801 0x48c0 0x4980 0x8941 0x4b00 0x8bc1 0x8a81 0x4a40 0x4e00 0x8ec1 0x8f81 0x4f40 0x8d01 0x4dc0 0x4c80 0x8c41 0x4400 0x84c1 0x8581 0x4540 0x8701 0x47c0 0x4680 0x8641 0x8201 0x42c0 0x4380 0x8341 0x4100 0x81c1 0x8081 0x4040])

(def crc24
  [0x000000 0x864cfb 0x8ad50d 0x0c99f6 0x93e6e1 0x15aa1a 0x1933ec 0x9f7f17 0xa18139 0x27cdc2 0x2b5434 0xad18cf 0x3267d8 0xb42b23 0xb8b2d5 0x3efe2e 0xc54e89 0x430272 0x4f9b84 0xc9d77f 0x56a868 0xd0e493 0xdc7d65 0x5a319e 0x64cfb0 0xe2834b 0xee1abd 0x685646 0xf72951 0x7165aa 0x7dfc5c 0xfbb0a7 0x0cd1e9 0x8a9d12 0x8604e4 0x00481f 0x9f3708 0x197bf3 0x15e205 0x93aefe 0xad50d0 0x2b1c2b 0x2785dd 0xa1c926 0x3eb631 0xb8faca 0xb4633c 0x322fc7 0xc99f60 0x4fd39b 0x434a6d 0xc50696 0x5a7981 0xdc357a 0xd0ac8c 0x56e077 0x681e59 0xee52a2 0xe2cb54 0x6487af 0xfbf8b8 0x7db443 0x712db5 0xf7614e 0x19a3d2 0x9fef29 0x9376df 0x153a24 0x8a4533 0x0c09c8 0x00903e 0x86dcc5 0xb822eb 0x3e6e10 0x32f7e6 0xb4bb1d 0x2bc40a 0xad88f1 0xa11107 0x275dfc 0xdced5b 0x5aa1a0 0x563856 0xd074ad 0x4f0bba 0xc94741 0xc5deb7 0x43924c 0x7d6c62 0xfb2099 0xf7b96f 0x71f594 0xee8a83 0x68c678 0x645f8e 0xe21375 0x15723b 0x933ec0 0x9fa736 0x19ebcd 0x8694da 0x00d821 0x0c41d7 0x8a0d2c 0xb4f302 0x32bff9 0x3e260f 0xb86af4 0x2715e3 0xa15918 0xadc0ee 0x2b8c15 0xd03cb2 0x567049 0x5ae9bf 0xdca544 0x43da53 0xc596a8 0xc90f5e 0x4f43a5 0x71bd8b 0xf7f170 0xfb6886 0x7d247d 0xe25b6a 0x641791 0x688e67 0xeec29c 0x3347a4 0xb50b5f 0xb992a9 0x3fde52 0xa0a145 0x26edbe 0x2a7448 0xac38b3 0x92c69d 0x148a66 0x181390 0x9e5f6b 0x01207c 0x876c87 0x8bf571 0x0db98a 0xf6092d 0x7045d6 0x7cdc20 0xfa90db 0x65efcc 0xe3a337 0xef3ac1 0x69763a 0x578814 0xd1c4ef 0xdd5d19 0x5b11e2 0xc46ef5 0x42220e 0x4ebbf8 0xc8f703 0x3f964d 0xb9dab6 0xb54340 0x330fbb 0xac70ac 0x2a3c57 0x26a5a1 0xa0e95a 0x9e1774 0x185b8f 0x14c279 0x928e82 0x0df195 0x8bbd6e 0x872498 0x016863 0xfad8c4 0x7c943f 0x700dc9 0xf64132 0x693e25 0xef72de 0xe3eb28 0x65a7d3 0x5b59fd 0xdd1506 0xd18cf0 0x57c00b 0xc8bf1c 0x4ef3e7 0x426a11 0xc426ea 0x2ae476 0xaca88d 0xa0317b 0x267d80 0xb90297 0x3f4e6c 0x33d79a 0xb59b61 0x8b654f 0x0d29b4 0x01b042 0x87fcb9 0x1883ae 0x9ecf55 0x9256a3 0x141a58 0xefaaff 0x69e604 0x657ff2 0xe33309 0x7c4c1e 0xfa00e5 0xf69913 0x70d5e8 0x4e2bc6 0xc8673d 0xc4fecb 0x42b230 0xddcd27 0x5b81dc 0x57182a 0xd154d1 0x26359f 0xa07964 0xace092 0x2aac69 0xb5d37e 0x339f85 0x3f0673 0xb94a88 0x87b4a6 0x01f85d 0x0d61ab 0x8b2d50 0x145247 0x921ebc 0x9e874a 0x18cbb1 0xe37b16 0x6537ed 0x69ae1b 0xefe2e0 0x709df7 0xf6d10c 0xfa48fa 0x7c0401 0x42fa2f 0xc4b6d4 0xc82f22 0x4e63d9 0xd11cce 0x575035 0x5bc9c3 0xdd8538])

(def crc32
  [0x00000000 0x77073096 0xee0e612c 0x990951ba 0x076dc419 0x706af48f 0xe963a535 0x9e6495a3 0x0edb8832 0x79dcb8a4 0xe0d5e91e 0x97d2d988 0x09b64c2b 0x7eb17cbd 0xe7b82d07 0x90bf1d91 0x1db71064 0x6ab020f2 0xf3b97148 0x84be41de 0x1adad47d 0x6ddde4eb 0xf4d4b551 0x83d385c7 0x136c9856 0x646ba8c0 0xfd62f97a 0x8a65c9ec 0x14015c4f 0x63066cd9 0xfa0f3d63 0x8d080df5 0x3b6e20c8 0x4c69105e 0xd56041e4 0xa2677172 0x3c03e4d1 0x4b04d447 0xd20d85fd 0xa50ab56b 0x35b5a8fa 0x42b2986c 0xdbbbc9d6 0xacbcf940 0x32d86ce3 0x45df5c75 0xdcd60dcf 0xabd13d59 0x26d930ac 0x51de003a 0xc8d75180 0xbfd06116 0x21b4f4b5 0x56b3c423 0xcfba9599 0xb8bda50f 0x2802b89e 0x5f058808 0xc60cd9b2 0xb10be924 0x2f6f7c87 0x58684c11 0xc1611dab 0xb6662d3d 0x76dc4190 0x01db7106 0x98d220bc 0xefd5102a 0x71b18589 0x06b6b51f 0x9fbfe4a5 0xe8b8d433 0x7807c9a2 0x0f00f934 0x9609a88e 0xe10e9818 0x7f6a0dbb 0x086d3d2d 0x91646c97 0xe6635c01 0x6b6b51f4 0x1c6c6162 0x856530d8 0xf262004e 0x6c0695ed 0x1b01a57b 0x8208f4c1 0xf50fc457 0x65b0d9c6 0x12b7e950 0x8bbeb8ea 0xfcb9887c 0x62dd1ddf 0x15da2d49 0x8cd37cf3 0xfbd44c65 0x4db26158 0x3ab551ce 0xa3bc0074 0xd4bb30e2 0x4adfa541 0x3dd895d7 0xa4d1c46d 0xd3d6f4fb 0x4369e96a 0x346ed9fc 0xad678846 0xda60b8d0 0x44042d73 0x33031de5 0xaa0a4c5f 0xdd0d7cc9 0x5005713c 0x270241aa 0xbe0b1010 0xc90c2086 0x5768b525 0x206f85b3 0xb966d409 0xce61e49f 0x5edef90e 0x29d9c998 0xb0d09822 0xc7d7a8b4 0x59b33d17 0x2eb40d81 0xb7bd5c3b 0xc0ba6cad 0xedb88320 0x9abfb3b6 0x03b6e20c 0x74b1d29a 0xead54739 0x9dd277af 0x04db2615 0x73dc1683 0xe3630b12 0x94643b84 0x0d6d6a3e 0x7a6a5aa8 0xe40ecf0b 0x9309ff9d 0x0a00ae27 0x7d079eb1 0xf00f9344 0x8708a3d2 0x1e01f268 0x6906c2fe 0xf762575d 0x806567cb 0x196c3671 0x6e6b06e7 0xfed41b76 0x89d32be0 0x10da7a5a 0x67dd4acc 0xf9b9df6f 0x8ebeeff9 0x17b7be43 0x60b08ed5 0xd6d6a3e8 0xa1d1937e 0x38d8c2c4 0x4fdff252 0xd1bb67f1 0xa6bc5767 0x3fb506dd 0x48b2364b 0xd80d2bda 0xaf0a1b4c 0x36034af6 0x41047a60 0xdf60efc3 0xa867df55 0x316e8eef 0x4669be79 0xcb61b38c 0xbc66831a 0x256fd2a0 0x5268e236 0xcc0c7795 0xbb0b4703 0x220216b9 0x5505262f 0xc5ba3bbe 0xb2bd0b28 0x2bb45a92 0x5cb36a04 0xc2d7ffa7 0xb5d0cf31 0x2cd99e8b 0x5bdeae1d 0x9b64c2b0 0xec63f226 0x756aa39c 0x026d930a 0x9c0906a9 0xeb0e363f 0x72076785 0x05005713 0x95bf4a82 0xe2b87a14 0x7bb12bae 0x0cb61b38 0x92d28e9b 0xe5d5be0d 0x7cdcefb7 0x0bdbdf21 0x86d3d2d4 0xf1d4e242 0x68ddb3f8 0x1fda836e 0x81be16cd 0xf6b9265b 0x6fb077e1 0x18b74777 0x88085ae6 0xff0f6a70 0x66063bca 0x11010b5c 0x8f659eff 0xf862ae69 0x616bffd3 0x166ccf45 0xa00ae278 0xd70dd2ee 0x4e048354 0x3903b3c2 0xa7672661 0xd06016f7 0x4969474d 0x3e6e77db 0xaed16a4a 0xd9d65adc 0x40df0b66 0x37d83bf0 0xa9bcae53 0xdebb9ec5 0x47b2cf7f 0x30b5ffe9 0xbdbdf21c 0xcabac28a 0x53b39330 0x24b4a3a6 0xbad03605 0xcdd70693 0x54de5729 0x23d967bf 0xb3667a2e 0xc4614ab8 0x5d681b02 0x2a6f2b94 0xb40bbe37 0xc30c8ea1 0x5a05df1b 0x2d02ef8d])

(def crc32c
  [0x00000000 0xf26b8303 0xe13b70f7 0x1350f3f4 0xc79a971f 0x35f1141c 0x26a1e7e8 0xd4ca64eb 0x8ad958cf 0x78b2dbcc 0x6be22838 0x9989ab3b 0x4d43cfd0 0xbf284cd3 0xac78bf27 0x5e133c24 0x105ec76f 0xe235446c 0xf165b798 0x030e349b 0xd7c45070 0x25afd373 0x36ff2087 0xc494a384 0x9a879fa0 0x68ec1ca3 0x7bbcef57 0x89d76c54 0x5d1d08bf 0xaf768bbc 0xbc267848 0x4e4dfb4b 0x20bd8ede 0xd2d60ddd 0xc186fe29 0x33ed7d2a 0xe72719c1 0x154c9ac2 0x061c6936 0xf477ea35 0xaa64d611 0x580f5512 0x4b5fa6e6 0xb93425e5 0x6dfe410e 0x9f95c20d 0x8cc531f9 0x7eaeb2fa 0x30e349b1 0xc288cab2 0xd1d83946 0x23b3ba45 0xf779deae 0x05125dad 0x1642ae59 0xe4292d5a 0xba3a117e 0x4851927d 0x5b016189 0xa96ae28a 0x7da08661 0x8fcb0562 0x9c9bf696 0x6ef07595 0x417b1dbc 0xb3109ebf 0xa0406d4b 0x522bee48 0x86e18aa3 0x748a09a0 0x67dafa54 0x95b17957 0xcba24573 0x39c9c670 0x2a993584 0xd8f2b687 0x0c38d26c 0xfe53516f 0xed03a29b 0x1f682198 0x5125dad3 0xa34e59d0 0xb01eaa24 0x42752927 0x96bf4dcc 0x64d4cecf 0x77843d3b 0x85efbe38 0xdbfc821c 0x2997011f 0x3ac7f2eb 0xc8ac71e8 0x1c661503 0xee0d9600 0xfd5d65f4 0x0f36e6f7 0x61c69362 0x93ad1061 0x80fde395 0x72966096 0xa65c047d 0x5437877e 0x4767748a 0xb50cf789 0xeb1fcbad 0x197448ae 0x0a24bb5a 0xf84f3859 0x2c855cb2 0xdeeedfb1 0xcdbe2c45 0x3fd5af46 0x7198540d 0x83f3d70e 0x90a324fa 0x62c8a7f9 0xb602c312 0x44694011 0x5739b3e5 0xa55230e6 0xfb410cc2 0x092a8fc1 0x1a7a7c35 0xe811ff36 0x3cdb9bdd 0xceb018de 0xdde0eb2a 0x2f8b6829 0x82f63b78 0x709db87b 0x63cd4b8f 0x91a6c88c 0x456cac67 0xb7072f64 0xa457dc90 0x563c5f93 0x082f63b7 0xfa44e0b4 0xe9141340 0x1b7f9043 0xcfb5f4a8 0x3dde77ab 0x2e8e845f 0xdce5075c 0x92a8fc17 0x60c37f14 0x73938ce0 0x81f80fe3 0x55326b08 0xa759e80b 0xb4091bff 0x466298fc 0x1871a4d8 0xea1a27db 0xf94ad42f 0x0b21572c 0xdfeb33c7 0x2d80b0c4 0x3ed04330 0xccbbc033 0xa24bb5a6 0x502036a5 0x4370c551 0xb11b4652 0x65d122b9 0x97baa1ba 0x84ea524e 0x7681d14d 0x2892ed69 0xdaf96e6a 0xc9a99d9e 0x3bc21e9d 0xef087a76 0x1d63f975 0x0e330a81 0xfc588982 0xb21572c9 0x407ef1ca 0x532e023e 0xa145813d 0x758fe5d6 0x87e466d5 0x94b49521 0x66df1622 0x38cc2a06 0xcaa7a905 0xd9f75af1 0x2b9cd9f2 0xff56bd19 0x0d3d3e1a 0x1e6dcdee 0xec064eed 0xc38d26c4 0x31e6a5c7 0x22b65633 0xd0ddd530 0x0417b1db 0xf67c32d8 0xe52cc12c 0x1747422f 0x49547e0b 0xbb3ffd08 0xa86f0efc 0x5a048dff 0x8ecee914 0x7ca56a17 0x6ff599e3 0x9d9e1ae0 0xd3d3e1ab 0x21b862a8 0x32e8915c 0xc083125f 0x144976b4 0xe622f5b7 0xf5720643 0x07198540 0x590ab964 0xab613a67 0xb831c993 0x4a5a4a90 0x9e902e7b 0x6cfbad78 0x7fab5e8c 0x8dc0dd8f 0xe330a81a 0x115b2b19 0x020bd8ed 0xf0605bee 0x24aa3f05 0xd6c1bc06 0xc5914ff2 0x37faccf1 0x69e9f0d5 0x9b8273d6 0x88d28022 0x7ab90321 0xae7367ca 0x5c18e4c9 0x4f48173d 0xbd23943e 0xf36e6f75 0x0105ec76 0x12551f82 0xe03e9c81 0x34f4f86a 0xc69f7b69 0xd5cf889d 0x27a40b9e 0x79b737ba 0x8bdcb4b9 0x988c474d 0x6ae7c44e 0xbe2da0a5 0x4c4623a6 0x5f16d052 0xad7d5351])

(def crc16-ccitt
  [0x0000 0x1021 0x2042 0x3063 0x4084 0x50a5 0x60c6 0x70e7 0x8108 0x9129 0xa14a 0xb16b 0xc18c 0xd1ad 0xe1ce 0xf1ef 0x1231 0x0210 0x3273 0x2252 0x52b5 0x4294 0x72f7 0x62d6 0x9339 0x8318 0xb37b 0xa35a 0xd3bd 0xc39c 0xf3ff 0xe3de 0x2462 0x3443 0x0420 0x1401 0x64e6 0x74c7 0x44a4 0x5485 0xa56a 0xb54b 0x8528 0x9509 0xe5ee 0xf5cf 0xc5ac 0xd58d 0x3653 0x2672 0x1611 0x0630 0x76d7 0x66f6 0x5695 0x46b4 0xb75b 0xa77a 0x9719 0x8738 0xf7df 0xe7fe 0xd79d 0xc7bc 0x48c4 0x58e5 0x6886 0x78a7 0x0840 0x1861 0x2802 0x3823 0xc9cc 0xd9ed 0xe98e 0xf9af 0x8948 0x9969 0xa90a 0xb92b 0x5af5 0x4ad4 0x7ab7 0x6a96 0x1a71 0x0a50 0x3a33 0x2a12 0xdbfd 0xcbdc 0xfbbf 0xeb9e 0x9b79 0x8b58 0xbb3b 0xab1a 0x6ca6 0x7c87 0x4ce4 0x5cc5 0x2c22 0x3c03 0x0c60 0x1c41 0xedae 0xfd8f 0xcdec 0xddcd 0xad2a 0xbd0b 0x8d68 0x9d49 0x7e97 0x6eb6 0x5ed5 0x4ef4 0x3e13 0x2e32 0x1e51 0x0e70 0xff9f 0xefbe 0xdfdd 0xcffc 0xbf1b 0xaf3a 0x9f59 0x8f78 0x9188 0x81a9 0xb1ca 0xa1eb 0xd10c 0xc12d 0xf14e 0xe16f 0x1080 0x00a1 0x30c2 0x20e3 0x5004 0x4025 0x7046 0x6067 0x83b9 0x9398 0xa3fb 0xb3da 0xc33d 0xd31c 0xe37f 0xf35e 0x02b1 0x1290 0x22f3 0x32d2 0x4235 0x5214 0x6277 0x7256 0xb5ea 0xa5cb 0x95a8 0x8589 0xf56e 0xe54f 0xd52c 0xc50d 0x34e2 0x24c3 0x14a0 0x0481 0x7466 0x6447 0x5424 0x4405 0xa7db 0xb7fa 0x8799 0x97b8 0xe75f 0xf77e 0xc71d 0xd73c 0x26d3 0x36f2 0x0691 0x16b0 0x6657 0x7676 0x4615 0x5634 0xd94c 0xc96d 0xf90e 0xe92f 0x99c8 0x89e9 0xb98a 0xa9ab 0x5844 0x4865 0x7806 0x6827 0x18c0 0x08e1 0x3882 0x28a3 0xcb7d 0xdb5c 0xeb3f 0xfb1e 0x8bf9 0x9bd8 0xabbb 0xbb9a 0x4a75 0x5a54 0x6a37 0x7a16 0x0af1 0x1ad0 0x2ab3 0x3a92 0xfd2e 0xed0f 0xdd6c 0xcd4d 0xbdaa 0xad8b 0x9de8 0x8dc9 0x7c26 0x6c07 0x5c64 0x4c45 0x3ca2 0x2c83 0x1ce0 0x0cc1 0xef1f 0xff3e 0xcf5d 0xdf7c 0xaf9b 0xbfba 0x8fd9 0x9ff8 0x6e17 0x7e36 0x4e55 0x5e74 0x2e93 0x3eb2 0x0ed1 0x1ef0])

(def crc16-dnp
  [0x0000 0x365e 0x6cbc 0x5ae2 0xd978 0xef26 0xb5c4 0x839a 0xff89 0xc9d7 0x9335 0xa56b 0x26f1 0x10af 0x4a4d 0x7c13 0xb26b 0x8435 0xded7 0xe889 0x6b13 0x5d4d 0x07af 0x31f1 0x4de2 0x7bbc 0x215e 0x1700 0x949a 0xa2c4 0xf826 0xce78 0x29af 0x1ff1 0x4513 0x734d 0xf0d7 0xc689 0x9c6b 0xaa35 0xd626 0xe078 0xba9a 0x8cc4 0x0f5e 0x3900 0x63e2 0x55bc 0x9bc4 0xad9a 0xf778 0xc126 0x42bc 0x74e2 0x2e00 0x185e 0x644d 0x5213 0x08f1 0x3eaf 0xbd35 0x8b6b 0xd189 0xe7d7 0x535e 0x6500 0x3fe2 0x09bc 0x8a26 0xbc78 0xe69a 0xd0c4 0xacd7 0x9a89 0xc06b 0xf635 0x75af 0x43f1 0x1913 0x2f4d 0xe135 0xd76b 0x8d89 0xbbd7 0x384d 0x0e13 0x54f1 0x62af 0x1ebc 0x28e2 0x7200 0x445e 0xc7c4 0xf19a 0xab78 0x9d26 0x7af1 0x4caf 0x164d 0x2013 0xa389 0x95d7 0xcf35 0xf96b 0x8578 0xb326 0xe9c4 0xdf9a 0x5c00 0x6a5e 0x30bc 0x06e2 0xc89a 0xfec4 0xa426 0x9278 0x11e2 0x27bc 0x7d5e 0x4b00 0x3713 0x014d 0x5baf 0x6df1 0xee6b 0xd835 0x82d7 0xb489 0xa6bc 0x90e2 0xca00 0xfc5e 0x7fc4 0x499a 0x1378 0x2526 0x5935 0x6f6b 0x3589 0x03d7 0x804d 0xb613 0xecf1 0xdaaf 0x14d7 0x2289 0x786b 0x4e35 0xcdaf 0xfbf1 0xa113 0x974d 0xeb5e 0xdd00 0x87e2 0xb1bc 0x3226 0x0478 0x5e9a 0x68c4 0x8f13 0xb94d 0xe3af 0xd5f1 0x566b 0x6035 0x3ad7 0x0c89 0x709a 0x46c4 0x1c26 0x2a78 0xa9e2 0x9fbc 0xc55e 0xf300 0x3d78 0x0b26 0x51c4 0x679a 0xe400 0xd25e 0x88bc 0xbee2 0xc2f1 0xf4af 0xae4d 0x9813 0x1b89 0x2dd7 0x7735 0x416b 0xf5e2 0xc3bc 0x995e 0xaf00 0x2c9a 0x1ac4 0x4026 0x7678 0x0a6b 0x3c35 0x66d7 0x5089 0xd313 0xe54d 0xbfaf 0x89f1 0x4789 0x71d7 0x2b35 0x1d6b 0x9ef1 0xa8af 0xf24d 0xc413 0xb800 0x8e5e 0xd4bc 0xe2e2 0x6178 0x5726 0x0dc4 0x3b9a 0xdc4d 0xea13 0xb0f1 0x86af 0x0535 0x336b 0x6989 0x5fd7 0x23c4 0x159a 0x4f78 0x7926 0xfabc 0xcce2 0x9600 0xa05e 0x6e26 0x5878 0x029a 0x34c4 0xb75e 0x8100 0xdbe2 0xedbc 0x91af 0xa7f1 0xfd13 0xcb4d 0x48d7 0x7e89 0x246b 0x1235])

(def crc16-modbus
  [0x0000 0xc0c1 0xc181 0x0140 0xc301 0x03c0 0x0280 0xc241 0xc601 0x06c0 0x0780 0xc741 0x0500 0xc5c1 0xc481 0x0440 0xcc01 0x0cc0 0x0d80 0xcd41 0x0f00 0xcfc1 0xce81 0x0e40 0x0a00 0xcac1 0xcb81 0x0b40 0xc901 0x09c0 0x0880 0xc841 0xd801 0x18c0 0x1980 0xd941 0x1b00 0xdbc1 0xda81 0x1a40 0x1e00 0xdec1 0xdf81 0x1f40 0xdd01 0x1dc0 0x1c80 0xdc41 0x1400 0xd4c1 0xd581 0x1540 0xd701 0x17c0 0x1680 0xd641 0xd201 0x12c0 0x1380 0xd341 0x1100 0xd1c1 0xd081 0x1040 0xf001 0x30c0 0x3180 0xf141 0x3300 0xf3c1 0xf281 0x3240 0x3600 0xf6c1 0xf781 0x3740 0xf501 0x35c0 0x3480 0xf441 0x3c00 0xfcc1 0xfd81 0x3d40 0xff01 0x3fc0 0x3e80 0xfe41 0xfa01 0x3ac0 0x3b80 0xfb41 0x3900 0xf9c1 0xf881 0x3840 0x2800 0xe8c1 0xe981 0x2940 0xeb01 0x2bc0 0x2a80 0xea41 0xee01 0x2ec0 0x2f80 0xef41 0x2d00 0xedc1 0xec81 0x2c40 0xe401 0x24c0 0x2580 0xe541 0x2700 0xe7c1 0xe681 0x2640 0x2200 0xe2c1 0xe381 0x2340 0xe101 0x21c0 0x2080 0xe041 0xa001 0x60c0 0x6180 0xa141 0x6300 0xa3c1 0xa281 0x6240 0x6600 0xa6c1 0xa781 0x6740 0xa501 0x65c0 0x6480 0xa441 0x6c00 0xacc1 0xad81 0x6d40 0xaf01 0x6fc0 0x6e80 0xae41 0xaa01 0x6ac0 0x6b80 0xab41 0x6900 0xa9c1 0xa881 0x6840 0x7800 0xb8c1 0xb981 0x7940 0xbb01 0x7bc0 0x7a80 0xba41 0xbe01 0x7ec0 0x7f80 0xbf41 0x7d00 0xbdc1 0xbc81 0x7c40 0xb401 0x74c0 0x7580 0xb541 0x7700 0xb7c1 0xb681 0x7640 0x7200 0xb2c1 0xb381 0x7340 0xb101 0x71c0 0x7080 0xb041 0x5000 0x90c1 0x9181 0x5140 0x9301 0x53c0 0x5280 0x9241 0x9601 0x56c0 0x5780 0x9741 0x5500 0x95c1 0x9481 0x5440 0x9c01 0x5cc0 0x5d80 0x9d41 0x5f00 0x9fc1 0x9e81 0x5e40 0x5a00 0x9ac1 0x9b81 0x5b40 0x9901 0x59c0 0x5880 0x9841 0x8801 0x48c0 0x4980 0x8941 0x4b00 0x8bc1 0x8a81 0x4a40 0x4e00 0x8ec1 0x8f81 0x4f40 0x8d01 0x4dc0 0x4c80 0x8c41 0x4400 0x84c1 0x8581 0x4540 0x8701 0x47c0 0x4680 0x8641 0x8201 0x42c0 0x4380 0x8341 0x4100 0x81c1 0x8081 0x4040])

(def crc16-xmodem
  [0x0000 0x1021 0x2042 0x3063 0x4084 0x50a5 0x60c6 0x70e7 0x8108 0x9129 0xa14a 0xb16b 0xc18c 0xd1ad 0xe1ce 0xf1ef 0x1231 0x0210 0x3273 0x2252 0x52b5 0x4294 0x72f7 0x62d6 0x9339 0x8318 0xb37b 0xa35a 0xd3bd 0xc39c 0xf3ff 0xe3de 0x2462 0x3443 0x0420 0x1401 0x64e6 0x74c7 0x44a4 0x5485 0xa56a 0xb54b 0x8528 0x9509 0xe5ee 0xf5cf 0xc5ac 0xd58d 0x3653 0x2672 0x1611 0x0630 0x76d7 0x66f6 0x5695 0x46b4 0xb75b 0xa77a 0x9719 0x8738 0xf7df 0xe7fe 0xd79d 0xc7bc 0x48c4 0x58e5 0x6886 0x78a7 0x0840 0x1861 0x2802 0x3823 0xc9cc 0xd9ed 0xe98e 0xf9af 0x8948 0x9969 0xa90a 0xb92b 0x5af5 0x4ad4 0x7ab7 0x6a96 0x1a71 0x0a50 0x3a33 0x2a12 0xdbfd 0xcbdc 0xfbbf 0xeb9e 0x9b79 0x8b58 0xbb3b 0xab1a 0x6ca6 0x7c87 0x4ce4 0x5cc5 0x2c22 0x3c03 0x0c60 0x1c41 0xedae 0xfd8f 0xcdec 0xddcd 0xad2a 0xbd0b 0x8d68 0x9d49 0x7e97 0x6eb6 0x5ed5 0x4ef4 0x3e13 0x2e32 0x1e51 0x0e70 0xff9f 0xefbe 0xdfdd 0xcffc 0xbf1b 0xaf3a 0x9f59 0x8f78 0x9188 0x81a9 0xb1ca 0xa1eb 0xd10c 0xc12d 0xf14e 0xe16f 0x1080 0x00a1 0x30c2 0x20e3 0x5004 0x4025 0x7046 0x6067 0x83b9 0x9398 0xa3fb 0xb3da 0xc33d 0xd31c 0xe37f 0xf35e 0x02b1 0x1290 0x22f3 0x32d2 0x4235 0x5214 0x6277 0x7256 0xb5ea 0xa5cb 0x95a8 0x8589 0xf56e 0xe54f 0xd52c 0xc50d 0x34e2 0x24c3 0x14a0 0x0481 0x7466 0x6447 0x5424 0x4405 0xa7db 0xb7fa 0x8799 0x97b8 0xe75f 0xf77e 0xc71d 0xd73c 0x26d3 0x36f2 0x0691 0x16b0 0x6657 0x7676 0x4615 0x5634 0xd94c 0xc96d 0xf90e 0xe92f 0x99c8 0x89e9 0xb98a 0xa9ab 0x5844 0x4865 0x7806 0x6827 0x18c0 0x08e1 0x3882 0x28a3 0xcb7d 0xdb5c 0xeb3f 0xfb1e 0x8bf9 0x9bd8 0xabbb 0xbb9a 0x4a75 0x5a54 0x6a37 0x7a16 0x0af1 0x1ad0 0x2ab3 0x3a92 0xfd2e 0xed0f 0xdd6c 0xcd4d 0xbdaa 0xad8b 0x9de8 0x8dc9 0x7c26 0x6c07 0x5c64 0x4c45 0x3ca2 0x2c83 0x1ce0 0x0cc1 0xef1f 0xff3e 0xcf5d 0xdf7c 0xaf9b 0xbfba 0x8fd9 0x9ff8 0x6e17 0x7e36 0x4e55 0x5e74 0x2e93 0x3eb2 0x0ed1 0x1ef0])

(def crc16-zmodem
  [0x0000 0x1021 0x2042 0x3063 0x4084 0x50a5 0x60c6 0x70e7 0x8108 0x9129 0xa14a 0xb16b 0xc18c 0xd1ad 0xe1ce 0xf1ef 0x1231 0x0210 0x3273 0x2252 0x52b5 0x4294 0x72f7 0x62d6 0x9339 0x8318 0xb37b 0xa35a 0xd3bd 0xc39c 0xf3ff 0xe3de 0x2462 0x3443 0x0420 0x1401 0x64e6 0x74c7 0x44a4 0x5485 0xa56a 0xb54b 0x8528 0x9509 0xe5ee 0xf5cf 0xc5ac 0xd58d 0x3653 0x2672 0x1611 0x0630 0x76d7 0x66f6 0x5695 0x46b4 0xb75b 0xa77a 0x9719 0x8738 0xf7df 0xe7fe 0xd79d 0xc7bc 0x48c4 0x58e5 0x6886 0x78a7 0x0840 0x1861 0x2802 0x3823 0xc9cc 0xd9ed 0xe98e 0xf9af 0x8948 0x9969 0xa90a 0xb92b 0x5af5 0x4ad4 0x7ab7 0x6a96 0x1a71 0x0a50 0x3a33 0x2a12 0xdbfd 0xcbdc 0xfbbf 0xeb9e 0x9b79 0x8b58 0xbb3b 0xab1a 0x6ca6 0x7c87 0x4ce4 0x5cc5 0x2c22 0x3c03 0x0c60 0x1c41 0xedae 0xfd8f 0xcdec 0xddcd 0xad2a 0xbd0b 0x8d68 0x9d49 0x7e97 0x6eb6 0x5ed5 0x4ef4 0x3e13 0x2e32 0x1e51 0x0e70 0xff9f 0xefbe 0xdfdd 0xcffc 0xbf1b 0xaf3a 0x9f59 0x8f78 0x9188 0x81a9 0xb1ca 0xa1eb 0xd10c 0xc12d 0xf14e 0xe16f 0x1080 0x00a1 0x30c2 0x20e3 0x5004 0x4025 0x7046 0x6067 0x83b9 0x9398 0xa3fb 0xb3da 0xc33d 0xd31c 0xe37f 0xf35e 0x02b1 0x1290 0x22f3 0x32d2 0x4235 0x5214 0x6277 0x7256 0xb5ea 0xa5cb 0x95a8 0x8589 0xf56e 0xe54f 0xd52c 0xc50d 0x34e2 0x24c3 0x14a0 0x0481 0x7466 0x6447 0x5424 0x4405 0xa7db 0xb7fa 0x8799 0x97b8 0xe75f 0xf77e 0xc71d 0xd73c 0x26d3 0x36f2 0x0691 0x16b0 0x6657 0x7676 0x4615 0x5634 0xd94c 0xc96d 0xf90e 0xe92f 0x99c8 0x89e9 0xb98a 0xa9ab 0x5844 0x4865 0x7806 0x6827 0x18c0 0x08e1 0x3882 0x28a3 0xcb7d 0xdb5c 0xeb3f 0xfb1e 0x8bf9 0x9bd8 0xabbb 0xbb9a 0x4a75 0x5a54 0x6a37 0x7a16 0x0af1 0x1ad0 0x2ab3 0x3a92 0xfd2e 0xed0f 0xdd6c 0xcd4d 0xbdaa 0xad8b 0x9de8 0x8dc9 0x7c26 0x6c07 0x5c64 0x4c45 0x3ca2 0x2c83 0x1ce0 0x0cc1 0xef1f 0xff3e 0xcf5d 0xdf7c 0xaf9b 0xbfba 0x8fd9 0x9ff8 0x6e17 0x7e36 0x4e55 0x5e74 0x2e93 0x3eb2 0x0ed1 0x1ef0])

(def crc32-mpeg
  [0x00000000 0x04c11db7 0x09823b6e 0x0d4326d9 0x130476dc 0x17c56b6b 0x1a864db2 0x1e475005 0x2608edb8 0x22c9f00f 0x2f8ad6d6 0x2b4bcb61 0x350c9b64 0x31cd86d3 0x3c8ea00a 0x384fbdbd 0x4c11db70 0x48d0c6c7 0x4593e01e 0x4152fda9 0x5f15adac 0x5bd4b01b 0x569796c2 0x52568b75 0x6a1936c8 0x6ed82b7f 0x639b0da6 0x675a1011 0x791d4014 0x7ddc5da3 0x709f7b7a 0x745e66cd 0x9823b6e0 0x9ce2ab57 0x91a18d8e 0x95609039 0x8b27c03c 0x8fe6dd8b 0x82a5fb52 0x8664e6e5 0xbe2b5b58 0xbaea46ef 0xb7a96036 0xb3687d81 0xad2f2d84 0xa9ee3033 0xa4ad16ea 0xa06c0b5d 0xd4326d90 0xd0f37027 0xddb056fe 0xd9714b49 0xc7361b4c 0xc3f706fb 0xceb42022 0xca753d95 0xf23a8028 0xf6fb9d9f 0xfbb8bb46 0xff79a6f1 0xe13ef6f4 0xe5ffeb43 0xe8bccd9a 0xec7dd02d 0x34867077 0x30476dc0 0x3d044b19 0x39c556ae 0x278206ab 0x23431b1c 0x2e003dc5 0x2ac12072 0x128e9dcf 0x164f8078 0x1b0ca6a1 0x1fcdbb16 0x018aeb13 0x054bf6a4 0x0808d07d 0x0cc9cdca 0x7897ab07 0x7c56b6b0 0x71159069 0x75d48dde 0x6b93dddb 0x6f52c06c 0x6211e6b5 0x66d0fb02 0x5e9f46bf 0x5a5e5b08 0x571d7dd1 0x53dc6066 0x4d9b3063 0x495a2dd4 0x44190b0d 0x40d816ba 0xaca5c697 0xa864db20 0xa527fdf9 0xa1e6e04e 0xbfa1b04b 0xbb60adfc 0xb6238b25 0xb2e29692 0x8aad2b2f 0x8e6c3698 0x832f1041 0x87ee0df6 0x99a95df3 0x9d684044 0x902b669d 0x94ea7b2a 0xe0b41de7 0xe4750050 0xe9362689 0xedf73b3e 0xf3b06b3b 0xf771768c 0xfa325055 0xfef34de2 0xc6bcf05f 0xc27dede8 0xcf3ecb31 0xcbffd686 0xd5b88683 0xd1799b34 0xdc3abded 0xd8fba05a 0x690ce0ee 0x6dcdfd59 0x608edb80 0x644fc637 0x7a089632 0x7ec98b85 0x738aad5c 0x774bb0eb 0x4f040d56 0x4bc510e1 0x46863638 0x42472b8f 0x5c007b8a 0x58c1663d 0x558240e4 0x51435d53 0x251d3b9e 0x21dc2629 0x2c9f00f0 0x285e1d47 0x36194d42 0x32d850f5 0x3f9b762c 0x3b5a6b9b 0x0315d626 0x07d4cb91 0x0a97ed48 0x0e56f0ff 0x1011a0fa 0x14d0bd4d 0x19939b94 0x1d528623 0xf12f560e 0xf5ee4bb9 0xf8ad6d60 0xfc6c70d7 0xe22b20d2 0xe6ea3d65 0xeba91bbc 0xef68060b 0xd727bbb6 0xd3e6a601 0xdea580d8 0xda649d6f 0xc423cd6a 0xc0e2d0dd 0xcda1f604 0xc960ebb3 0xbd3e8d7e 0xb9ff90c9 0xb4bcb610 0xb07daba7 0xae3afba2 0xaafbe615 0xa7b8c0cc 0xa379dd7b 0x9b3660c6 0x9ff77d71 0x92b45ba8 0x9675461f 0x8832161a 0x8cf30bad 0x81b02d74 0x857130c3 0x5d8a9099 0x594b8d2e 0x5408abf7 0x50c9b640 0x4e8ee645 0x4a4ffbf2 0x470cdd2b 0x43cdc09c 0x7b827d21 0x7f436096 0x7200464f 0x76c15bf8 0x68860bfd 0x6c47164a 0x61043093 0x65c52d24 0x119b4be9 0x155a565e 0x18197087 0x1cd86d30 0x029f3d35 0x065e2082 0x0b1d065b 0x0fdc1bec 0x3793a651 0x3352bbe6 0x3e119d3f 0x3ad08088 0x2497d08d 0x2056cd3a 0x2d15ebe3 0x29d4f654 0xc5a92679 0xc1683bce 0xcc2b1d17 0xc8ea00a0 0xd6ad50a5 0xd26c4d12 0xdf2f6bcb 0xdbee767c 0xe3a1cbc1 0xe760d676 0xea23f0af 0xeee2ed18 0xf0a5bd1d 0xf464a0aa 0xf9278673 0xfde69bc4 0x89b8fd09 0x8d79e0be 0x803ac667 0x84fbdbd0 0x9abc8bd5 0x9e7d9662 0x933eb0bb 0x97ffad0c 0xafb010b1 0xab710d06 0xa6322bdf 0xa2f33668 0xbcb4666d 0xb8757bda 0xb5365d03 0xb1f740b4])

(def crc64
  [0x0000000000000000 0x01b0000000000000 0x0360000000000000 0x02d0000000000000 0x06c0000000000000 0x0770000000000000 0x05a0000000000000 0x0410000000000000 0x0d80000000000000 0x0c30000000000000 0x0ee0000000000000 0x0f50000000000000 0x0b40000000000000 0x0af0000000000000 0x0820000000000000 0x0990000000000000 0x1b00000000000000 0x1ab0000000000000 0x1860000000000000 0x19d0000000000000 0x1dc0000000000000 0x1c70000000000000 0x1ea0000000000000 0x1f10000000000000 0x1680000000000000 0x1730000000000000 0x15e0000000000000 0x1450000000000000 0x1040000000000000 0x11f0000000000000 0x1320000000000000 0x1290000000000000 0x3600000000000000 0x37b0000000000000 0x3560000000000000 0x34d0000000000000 0x30c0000000000000 0x3170000000000000 0x33a0000000000000 0x3210000000000000 0x3b80000000000000 0x3a30000000000000 0x38e0000000000000 0x3950000000000000 0x3d40000000000000 0x3cf0000000000000 0x3e20000000000000 0x3f90000000000000 0x2d00000000000000 0x2cb0000000000000 0x2e60000000000000 0x2fd0000000000000 0x2bc0000000000000 0x2a70000000000000 0x28a0000000000000 0x2910000000000000 0x2080000000000000 0x2130000000000000 0x23e0000000000000 0x2250000000000000 0x2640000000000000 0x27f0000000000000 0x2520000000000000 0x2490000000000000 0x6c00000000000000 0x6db0000000000000 0x6f60000000000000 0x6ed0000000000000 0x6ac0000000000000 0x6b70000000000000 0x69a0000000000000 0x6810000000000000 0x6180000000000000 0x6030000000000000 0x62e0000000000000 0x6350000000000000 0x6740000000000000 0x66f0000000000000 0x6420000000000000 0x6590000000000000 0x7700000000000000 0x76b0000000000000 0x7460000000000000 0x75d0000000000000 0x71c0000000000000 0x7070000000000000 0x72a0000000000000 0x7310000000000000 0x7a80000000000000 0x7b30000000000000 0x79e0000000000000 0x7850000000000000 0x7c40000000000000 0x7df0000000000000 0x7f20000000000000 0x7e90000000000000 0x5a00000000000000 0x5bb0000000000000 0x5960000000000000 0x58d0000000000000 0x5cc0000000000000 0x5d70000000000000 0x5fa0000000000000 0x5e10000000000000 0x5780000000000000 0x5630000000000000 0x54e0000000000000 0x5550000000000000 0x5140000000000000 0x50f0000000000000 0x5220000000000000 0x5390000000000000 0x4100000000000000 0x40b0000000000000 0x4260000000000000 0x43d0000000000000 0x47c0000000000000 0x4670000000000000 0x44a0000000000000 0x4510000000000000 0x4c80000000000000 0x4d30000000000000 0x4fe0000000000000 0x4e50000000000000 0x4a40000000000000 0x4bf0000000000000 0x4920000000000000 0x4890000000000000 0xd800000000000000 0xd9b0000000000000 0xdb60000000000000 0xdad0000000000000 0xdec0000000000000 0xdf70000000000000 0xdda0000000000000 0xdc10000000000000 0xd580000000000000 0xd430000000000000 0xd6e0000000000000 0xd750000000000000 0xd340000000000000 0xd2f0000000000000 0xd020000000000000 0xd190000000000000 0xc300000000000000 0xc2b0000000000000 0xc060000000000000 0xc1d0000000000000 0xc5c0000000000000 0xc470000000000000 0xc6a0000000000000 0xc710000000000000 0xce80000000000000 0xcf30000000000000 0xcde0000000000000 0xcc50000000000000 0xc840000000000000 0xc9f0000000000000 0xcb20000000000000 0xca90000000000000 0xee00000000000000 0xefb0000000000000 0xed60000000000000 0xecd0000000000000 0xe8c0000000000000 0xe970000000000000 0xeba0000000000000 0xea10000000000000 0xe380000000000000 0xe230000000000000 0xe0e0000000000000 0xe150000000000000 0xe540000000000000 0xe4f0000000000000 0xe620000000000000 0xe790000000000000 0xf500000000000000 0xf4b0000000000000 0xf660000000000000 0xf7d0000000000000 0xf3c0000000000000 0xf270000000000000 0xf0a0000000000000 0xf110000000000000 0xf880000000000000 0xf930000000000000 0xfbe0000000000000 0xfa50000000000000 0xfe40000000000000 0xfff0000000000000 0xfd20000000000000 0xfc90000000000000 0xb400000000000000 0xb5b0000000000000 0xb760000000000000 0xb6d0000000000000 0xb2c0000000000000 0xb370000000000000 0xb1a0000000000000 0xb010000000000000 0xb980000000000000 0xb830000000000000 0xbae0000000000000 0xbb50000000000000 0xbf40000000000000 0xbef0000000000000 0xbc20000000000000 0xbd90000000000000 0xaf00000000000000 0xaeb0000000000000 0xac60000000000000 0xadd0000000000000 0xa9c0000000000000 0xa870000000000000 0xaaa0000000000000 0xab10000000000000 0xa280000000000000 0xa330000000000000 0xa1e0000000000000 0xa050000000000000 0xa440000000000000 0xa5f0000000000000 0xa720000000000000 0xa690000000000000 0x8200000000000000 0x83b0000000000000 0x8160000000000000 0x80d0000000000000 0x84c0000000000000 0x8570000000000000 0x87a0000000000000 0x8610000000000000 0x8f80000000000000 0x8e30000000000000 0x8ce0000000000000 0x8d50000000000000 0x8940000000000000 0x88f0000000000000 0x8a20000000000000 0x8b90000000000000 0x9900000000000000 0x98b0000000000000 0x9a60000000000000 0x9bd0000000000000 0x9fc0000000000000 0x9e70000000000000 0x9ca0000000000000 0x9d10000000000000 0x9480000000000000 0x9530000000000000 0x97e0000000000000 0x9650000000000000 0x9240000000000000 0x93f0000000000000 0x9120000000000000 0x9090000000000000])
