(ns cljs.http.crosspages
  (:require [cljs.reader :as reader]
            [goog.net.XhrIo :as xhr]
            [clojure.string :as string]
            [goog.events :as events]
            [goog.Uri.QueryData :as query-data]
            [goog.structs :as structs]
            [goog.dom :as dom]
            [goog.json :as gson]
            [goog.Uri :as uri]
            [goog.net.EventType :as gnet-event-type]
            [goog.net.xpc.CfgFields :as gxpc-config-fields]
            [goog.net.xpc.CrossPageChannel :as xpc] ))


(defn create-channel [inner-page]
  (let [ownUri (goog.Uri. (.-href (.-location js/window)))
        peerDomain (or (.getParameterValue ownUri "peerDomain") (.getDomain ownUri) )
        peerPort (if (nil? (.getParameterValue ownUri "peerDomain")) (.getPort ownUri) )
        peerUri (doto (.clone ownUri)
                  (.setDomain peerDomain)
                  (.setPort peerPort))

        localRelayUri (.resolve ownUri (goog.Uri. "relay.html"))
        peerRelayUri (.resolve peerUri (goog.Uri. "relay.html") )
        localPollUri (.resolve ownUri (goog.Uri. "blank.html"))
        peerPollUri (.resolve peerUri (goog.Uri. "blank.html"))

        cfg (doto (js-obj)
              (aset gxpc-config-fields/LOCAL_RELAY_URI (.toString localRelayUri))
              (aset gxpc-config-fields/PEER_RELAY_URI (.toString peerRelayUri))
              (aset gxpc-config-fields/LOCAL_POLL_URI (.toString localPollUri))
              (aset gxpc-config-fields/PEER_POLL_URI (.toString peerPollUri)))

        peerUri (.resolve ownUri
                          (doto (goog.Uri. inner-page)
                            (.setDomain peerDomain)
                            (.setPort peerPort)))
        _ (aset cfg gxpc-config-fields/PEER_URI peerUri)
        iframeContainer (dom/createElement "div")
        _ (dom/appendChild (.-body js/document) iframeContainer)
        channel (doto (goog.net.xpc.CrossPageChannel. cfg)
                  (.createPeerIframe iframeContainer
                                     (fn [iframe] (set! (.-display (.-style iframe)) "none" )))
                  (.connect (fn []
                              (.log js/console "Outer Channel connected.")
                              )))]
    channel))


(defn create-peer-channel []
  (let [ownUri (goog.Uri. (.-href (.-location js/window)))
        cfg (gson/parse (.getParameterValue ownUri "xpc"))
        channel (doto (goog.net.xpc.CrossPageChannel. cfg)
                  (.connect (fn []
                              (.log js/console "Inner Channel connected")
                              )))]
    channel))
