(ns cljs.net.remote.service)

(def remotes (atom {}))

(defn get-remote [remote]
  (get @remotes remote))

(defn add-remote [remote func]
  (swap! remotes assoc remote func))

(defn safe-read [s]
  (binding [*read-eval* false]
    (read-string s)))

(defn call-remote [remote params & [opt]]
  (if-let [func (get-remote remote)]
    (apply func params opt)))


(defn apply-remote [{{:keys [remote params]} :params} & opt]
  (if-let [result (call-remote (keyword remote) (safe-read params) opt )]
    {:status 202
     :headers {"Content-Type" "application/clojure; charset=utf-8"}
     :body (pr-str result)}
    {:status 404}))


(defmacro defremote [remote params & body]
  `(do
     (defn ~remote ~params ~@body)
     (add-remote ~(keyword (name remote)) ~remote)))


(defmacro REMOTE [method path request f]
  `(~method ~path ~request (if (fn? ~f) (~f apply-remote) ~f)))
