(ns cljs.net.xhr
  (:require [cljs.reader :as reader]
            [goog.net.XhrIo :as xhr]
            [clojure.string :as string]
            [goog.events :as events]
            [goog.Uri.QueryData :as query-data]
            [goog.structs :as structs]
            [goog.json :as gson]
            [goog.Uri :as uri]
            [goog.net.EventType :as gnet-event-type]
            [goog.net.xpc.CfgFields :as gxpc-config-fields]
            [goog.net.xpc.CrossPageChannel :as xpc] ))

(defmulti response
  (fn [xhr]
    (.log js/console "respone format")
    (if (.isSuccess xhr)
      (let [ct (.getResponseHeader xhr "Content-Type")
            ft (if (and ct (>= (.indexOf ct "json") 0))
                 "json"
                 "edn")]
        ft)
      "error")))

(defmethod response "json" [xhr]
  (let [json (.getResponseJson xhr)
        resp (js->clj json :keywordize-keys true)]
    {:xhr xhr
     :response resp }))


(defmethod response "edn" [xhr]
  (let [data (.getResponseText xhr)
        resp (reader/read-string  (if (= data "") "nil" data))]
    {:xhr xhr
     :response resp }))

(defmethod response "error" [xhr]
  {:xhr xhr
   :response nil})

(defn parse-route [route]
  (cond
   (string? route) ["GET" route]
   (vector? route) (let [[m u] route]
                     [(string/upper-case (name m))  u])
   :else ["GET" route]))


(defn query-str [d]
  (let [cur (clj->js d)
        query (query-data/createFromMap (structs/Map. cur))]
    (str query)))


(defn xhr [route content callback & [opts]]
  (let [xhrio (new goog.net.XhrIo)
        [method uri] (parse-route route)
        data (query-str content)]
    (when callback
      (events/listen xhrio goog.net.EventType/COMPLETE
                     (fn [e] (callback (response (.-target e))))))
    (.send xhrio uri method data (when opts (clj->js opts)))))


(defn GET [uri callback]
  (let [headers {:Content-Type "application/edn"
                 :Accept "application/edn" }
        content nil]
    (xhr [:get uri] content callback headers)))


(defn POST [uri content callback]
  (let [headers {:Accept "application/edn" }]
    (xhr [:post uri] content callback headers)))


(defn uri-with-params [uri params]
  (if params
    (str uri "?" (query-str params))
    uri))
