/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.asm.Attribute;
import clojure.asm.ByteVector;
import clojure.asm.ClassVisitor;
import clojure.asm.ClassWriter;
import clojure.asm.FieldVisitor;
import clojure.asm.Label;
import clojure.asm.Opcodes;
import clojure.asm.Type;
import clojure.asm.commons.GeneratorAdapter;
import clojure.lang.AFn;
import clojure.lang.AFunction;
import clojure.lang.DynamicClassLoader;
import clojure.lang.IFn;
import clojure.lang.ILookup;
import clojure.lang.ILookupHost;
import clojure.lang.ILookupSite;
import clojure.lang.ILookupThunk;
import clojure.lang.IMapEntry;
import clojure.lang.IMeta;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentList;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.KeywordLookupSite;
import clojure.lang.LazySeq;
import clojure.lang.LineNumberingPushbackReader;
import clojure.lang.LispReader;
import clojure.lang.MapEntry;
import clojure.lang.Namespace;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentHashSet;
import clojure.lang.PersistentList;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.Reflector;
import clojure.lang.RestFn;
import clojure.lang.Symbol;
import clojure.lang.Util;
import clojure.lang.Var;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compiler
implements Opcodes {
    static final Symbol DEF = Symbol.create("def");
    static final Symbol LOOP = Symbol.create("loop*");
    static final Symbol RECUR = Symbol.create("recur");
    static final Symbol IF = Symbol.create("if");
    static final Symbol LET = Symbol.create("let*");
    static final Symbol LETFN = Symbol.create("letfn*");
    static final Symbol DO = Symbol.create("do");
    static final Symbol FN = Symbol.create("fn*");
    static final Symbol QUOTE = Symbol.create("quote");
    static final Symbol THE_VAR = Symbol.create("var");
    static final Symbol DOT = Symbol.create(".");
    static final Symbol ASSIGN = Symbol.create("set!");
    static final Symbol TRY = Symbol.create("try");
    static final Symbol CATCH = Symbol.create("catch");
    static final Symbol FINALLY = Symbol.create("finally");
    static final Symbol THROW = Symbol.create("throw");
    static final Symbol MONITOR_ENTER = Symbol.create("monitor-enter");
    static final Symbol MONITOR_EXIT = Symbol.create("monitor-exit");
    static final Symbol IMPORT = Symbol.create("clojure.core", "import*");
    static final Symbol DEFTYPE = Symbol.create("deftype*");
    static final Symbol CASE = Symbol.create("case*");
    static final Symbol CLASS = Symbol.create("Class");
    static final Symbol NEW = Symbol.create("new");
    static final Symbol THIS = Symbol.create("this");
    static final Symbol REIFY = Symbol.create("reify*");
    static final Symbol LIST = Symbol.create("clojure.core", "list");
    static final Symbol HASHMAP = Symbol.create("clojure.core", "hash-map");
    static final Symbol VECTOR = Symbol.create("clojure.core", "vector");
    static final Symbol IDENTITY = Symbol.create("clojure.core", "identity");
    static final Symbol _AMP_ = Symbol.create("&");
    static final Symbol ISEQ = Symbol.create("clojure.lang.ISeq");
    static final Keyword inlineKey = Keyword.intern(null, "inline");
    static final Keyword inlineAritiesKey = Keyword.intern(null, "inline-arities");
    static final Keyword volatileKey = Keyword.intern(null, "volatile");
    static final Keyword implementsKey = Keyword.intern(null, "implements");
    static final String COMPILE_STUB_PREFIX = "compile__stub";
    static final Keyword protocolKey = Keyword.intern(null, "protocol");
    static final Keyword onKey = Keyword.intern(null, "on");
    static final Symbol NS = Symbol.create("ns");
    static final Symbol IN_NS = Symbol.create("in-ns");
    public static final IPersistentMap specials = PersistentHashMap.create(DEF, new DefExpr.Parser(), LOOP, new LetExpr.Parser(), RECUR, new RecurExpr.Parser(), IF, new IfExpr.Parser(), CASE, new CaseExpr.Parser(), LET, new LetExpr.Parser(), LETFN, new LetFnExpr.Parser(), DO, new BodyExpr.Parser(), FN, null, QUOTE, new ConstantExpr.Parser(), THE_VAR, new TheVarExpr.Parser(), IMPORT, new ImportExpr.Parser(), DOT, new HostExpr.Parser(), ASSIGN, new AssignExpr.Parser(), DEFTYPE, new NewInstanceExpr.DeftypeParser(), REIFY, new NewInstanceExpr.ReifyParser(), TRY, new TryExpr.Parser(), THROW, new ThrowExpr.Parser(), MONITOR_ENTER, new MonitorEnterExpr.Parser(), MONITOR_EXIT, new MonitorExitExpr.Parser(), CATCH, null, FINALLY, null, NEW, new NewExpr.Parser(), _AMP_, null);
    private static final int MAX_POSITIONAL_ARITY = 20;
    private static final Type OBJECT_TYPE;
    private static final Type KEYWORD_TYPE;
    private static final Type VAR_TYPE;
    private static final Type SYMBOL_TYPE;
    private static final Type IFN_TYPE;
    private static final Type AFUNCTION_TYPE;
    private static final Type RT_TYPE;
    static final Type CLASS_TYPE;
    static final Type NS_TYPE;
    static final Type UTIL_TYPE;
    static final Type REFLECTOR_TYPE;
    static final Type THROWABLE_TYPE;
    static final Type BOOLEAN_OBJECT_TYPE;
    static final Type IPERSISTENTMAP_TYPE;
    static final Type IOBJ_TYPE;
    private static final Type[][] ARG_TYPES;
    private static final Type[] EXCEPTION_TYPES;
    public static final Var LOCAL_ENV;
    public static final Var LOOP_LOCALS;
    public static final Var LOOP_LABEL;
    public static final Var CONSTANTS;
    public static final Var CONSTANT_IDS;
    public static final Var KEYWORD_CALLSITES;
    public static final Var PROTOCOL_CALLSITES;
    public static final Var VAR_CALLSITES;
    public static final Var KEYWORDS;
    public static final Var VARS;
    public static final Var METHOD;
    public static final Var IN_CATCH_FINALLY;
    public static final Var LOADER;
    public static final Var SOURCE;
    public static final Var SOURCE_PATH;
    public static final Var COMPILE_PATH;
    public static final Var COMPILE_FILES;
    public static final Var INSTANCE;
    public static final Var ADD_ANNOTATIONS;
    public static final Var LINE;
    public static final Var LINE_BEFORE;
    public static final Var LINE_AFTER;
    public static final Var NEXT_LOCAL_NUM;
    public static final Var RET_LOCAL_NUM;
    public static final Var COMPILE_STUB_SYM;
    public static final Var COMPILE_STUB_CLASS;
    public static final Var CLEAR_PATH;
    public static final Var CLEAR_ROOT;
    public static final Var CLEAR_SITES;
    static final NilExpr NIL_EXPR;
    static final BooleanExpr TRUE_EXPR;
    static final BooleanExpr FALSE_EXPR;
    public static final IPersistentMap CHAR_MAP;

    static boolean isSpecial(Object sym) {
        return specials.containsKey(sym);
    }

    static Symbol resolveSymbol(Symbol sym) {
        if (sym.name.indexOf(46) > 0) {
            return sym;
        }
        if (sym.ns != null) {
            Namespace ns2 = Compiler.namespaceFor(sym);
            if (ns2 == null || ns2.name.name == sym.ns) {
                return sym;
            }
            return Symbol.create(ns2.name.name, sym.name);
        }
        Object o = Compiler.currentNS().getMapping(sym);
        if (o == null) {
            return Symbol.intern(Compiler.currentNS().name.name, sym.name);
        }
        if (o instanceof Class) {
            return Symbol.intern(null, ((Class)o).getName());
        }
        if (o instanceof Var) {
            Var v = (Var)o;
            return Symbol.create(v.ns.name.name, v.sym.name);
        }
        return null;
    }

    static Class maybePrimitiveType(Expr e2) {
        try {
            Class c;
            if (e2 instanceof MaybePrimitiveExpr && e2.hasJavaClass() && ((MaybePrimitiveExpr)e2).canEmitPrimitive() && Util.isPrimitive(c = e2.getJavaClass())) {
                return c;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return null;
    }

    public static boolean subsumes(Class[] c1, Class[] c2) {
        Boolean better = false;
        for (int i = 0; i < c1.length; ++i) {
            if (c1[i] == c2[i]) continue;
            if (!c1[i].isPrimitive() && c2[i].isPrimitive() || c2[i].isAssignableFrom(c1[i])) {
                better = true;
                continue;
            }
            return false;
        }
        return better;
    }

    static int getMatchingParams(String methodName, ArrayList<Class[]> paramlists, IPersistentVector argexprs, List<Class> rets) throws Exception {
        int matchIdx = -1;
        boolean tied = false;
        boolean foundExact = false;
        for (int i = 0; i < paramlists.size(); ++i) {
            boolean match = true;
            ISeq aseq = argexprs.seq();
            int exact = 0;
            for (int p = 0; match && p < argexprs.count() && aseq != null; ++p, aseq = aseq.next()) {
                Expr arg = (Expr)aseq.first();
                Class aclass = arg.hasJavaClass() ? arg.getJavaClass() : Object.class;
                Class pclass = paramlists.get(i)[p];
                if (arg.hasJavaClass() && aclass == pclass) {
                    ++exact;
                    continue;
                }
                match = Reflector.paramArgTypeMatch(pclass, aclass);
            }
            if (exact == argexprs.count()) {
                if (!foundExact || matchIdx == -1 || rets.get(matchIdx).isAssignableFrom(rets.get(i))) {
                    matchIdx = i;
                }
                foundExact = true;
                continue;
            }
            if (!match || foundExact) continue;
            if (matchIdx == -1) {
                matchIdx = i;
                continue;
            }
            if (Compiler.subsumes(paramlists.get(i), paramlists.get(matchIdx))) {
                matchIdx = i;
                tied = false;
                continue;
            }
            if (Arrays.equals(paramlists.get(matchIdx), paramlists.get(i))) {
                if (!rets.get(matchIdx).isAssignableFrom(rets.get(i))) continue;
                matchIdx = i;
                continue;
            }
            if (Compiler.subsumes(paramlists.get(matchIdx), paramlists.get(i))) continue;
            tied = true;
        }
        if (tied) {
            throw new IllegalArgumentException("More than one matching method found: " + methodName);
        }
        return matchIdx;
    }

    public static String munge(String name2) {
        StringBuilder sb = new StringBuilder();
        for (char c : name2.toCharArray()) {
            String sub = (String)CHAR_MAP.valAt(Character.valueOf(c));
            if (sub != null) {
                sb.append(sub);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static PathNode clearPathRoot() {
        return (PathNode)CLEAR_ROOT.get();
    }

    private static LocalBinding registerLocal(Symbol sym, Symbol tag, Expr init, boolean isArg) throws Exception {
        int num2 = Compiler.getAndIncLocalNum();
        LocalBinding b = new LocalBinding(num2, sym, tag, init, isArg, Compiler.clearPathRoot());
        IPersistentMap localsMap = (IPersistentMap)LOCAL_ENV.deref();
        LOCAL_ENV.set(RT.assoc(localsMap, b.sym, b));
        ObjMethod method = (ObjMethod)METHOD.deref();
        method.locals = (IPersistentMap)RT.assoc(method.locals, b, b);
        method.indexlocals = (IPersistentMap)RT.assoc(method.indexlocals, num2, b);
        return b;
    }

    private static int getAndIncLocalNum() {
        int num2 = ((Number)NEXT_LOCAL_NUM.deref()).intValue();
        ObjMethod m = (ObjMethod)METHOD.deref();
        if (num2 > m.maxLocal) {
            m.maxLocal = num2;
        }
        NEXT_LOCAL_NUM.set(num2 + 1);
        return num2;
    }

    public static Expr analyze(C context, Object form) throws Exception {
        return Compiler.analyze(context, form, null);
    }

    private static Expr analyze(C context, Object form, String name2) throws Exception {
        try {
            if (form instanceof LazySeq && (form = RT.seq(form)) == null) {
                form = PersistentList.EMPTY;
            }
            if (form == null) {
                return NIL_EXPR;
            }
            if (form == Boolean.TRUE) {
                return TRUE_EXPR;
            }
            if (form == Boolean.FALSE) {
                return FALSE_EXPR;
            }
            Class<?> fclass = form.getClass();
            if (fclass == Symbol.class) {
                return Compiler.analyzeSymbol((Symbol)form);
            }
            if (fclass == Keyword.class) {
                return Compiler.registerKeyword((Keyword)form);
            }
            if (fclass == String.class) {
                return new StringExpr(((String)form).intern());
            }
            if (form instanceof IPersistentCollection && ((IPersistentCollection)form).count() == 0) {
                Expr ret = new EmptyExpr(form);
                if (RT.meta(form) != null) {
                    ret = new MetaExpr(ret, (MapExpr)MapExpr.parse(context == C.EVAL ? context : C.EXPRESSION, ((IObj)form).meta()));
                }
                return ret;
            }
            if (form instanceof ISeq) {
                return Compiler.analyzeSeq(context, (ISeq)form, name2);
            }
            if (form instanceof IPersistentVector) {
                return VectorExpr.parse(context, (IPersistentVector)form);
            }
            if (form instanceof IPersistentMap) {
                return MapExpr.parse(context, (IPersistentMap)form);
            }
            if (form instanceof IPersistentSet) {
                return SetExpr.parse(context, (IPersistentSet)form);
            }
            return new ConstantExpr(form);
        }
        catch (Throwable e2) {
            if (!(e2 instanceof CompilerException)) {
                throw new CompilerException((String)SOURCE_PATH.deref(), (Integer)LINE.deref(), e2);
            }
            throw (CompilerException)e2;
        }
    }

    public static Var isMacro(Object op) throws Exception {
        if (op instanceof Symbol && Compiler.referenceLocal((Symbol)op) != null) {
            return null;
        }
        if (op instanceof Symbol || op instanceof Var) {
            Var v;
            Var var = v = op instanceof Var ? (Var)op : Compiler.lookupVar((Symbol)op, false);
            if (v != null && v.isMacro()) {
                if (v.ns != Compiler.currentNS() && !v.isPublic()) {
                    throw new IllegalStateException("var: " + v + " is not public");
                }
                return v;
            }
        }
        return null;
    }

    public static IFn isInline(Object op, int arity) throws Exception {
        if (op instanceof Symbol && Compiler.referenceLocal((Symbol)op) != null) {
            return null;
        }
        if (op instanceof Symbol || op instanceof Var) {
            Var v;
            Var var = v = op instanceof Var ? (Var)op : Compiler.lookupVar((Symbol)op, false);
            if (v != null) {
                IFn arityPred;
                if (v.ns != Compiler.currentNS() && !v.isPublic()) {
                    throw new IllegalStateException("var: " + v + " is not public");
                }
                IFn ret = (IFn)RT.get(v.meta(), inlineKey);
                if (ret != null && ((arityPred = (IFn)RT.get(v.meta(), inlineAritiesKey)) == null || RT.booleanCast(arityPred.invoke(arity)))) {
                    return ret;
                }
            }
        }
        return null;
    }

    public static boolean namesStaticMember(Symbol sym) {
        return sym.ns != null && Compiler.namespaceFor(sym) == null;
    }

    public static Object preserveTag(ISeq src, Object dst) {
        Symbol tag = Compiler.tagOf(src);
        if (tag != null && dst instanceof IObj) {
            IPersistentMap meta2 = RT.meta(dst);
            return ((IObj)dst).withMeta((IPersistentMap)RT.assoc(meta2, RT.TAG_KEY, tag));
        }
        return dst;
    }

    public static Object macroexpand1(Object x) throws Exception {
        if (x instanceof ISeq) {
            ISeq form = (ISeq)x;
            Object op = RT.first(form);
            if (Compiler.isSpecial(op)) {
                return x;
            }
            Var v = Compiler.isMacro(op);
            if (v != null) {
                return v.applyTo(RT.cons(form, RT.cons(LOCAL_ENV.get(), form.next())));
            }
            if (op instanceof Symbol) {
                Symbol sym = (Symbol)op;
                String sname = sym.name;
                if (sym.name.charAt(0) == '.') {
                    if (RT.length(form) < 2) {
                        throw new IllegalArgumentException("Malformed member expression, expecting (.member target ...)");
                    }
                    Symbol meth = Symbol.intern(sname.substring(1));
                    Object target = RT.second(form);
                    if (HostExpr.maybeClass(target, false) != null) {
                        target = ((IObj)((Object)RT.list(IDENTITY, target))).withMeta(RT.map(RT.TAG_KEY, CLASS));
                    }
                    return Compiler.preserveTag(form, RT.listStar(DOT, target, meth, form.next().next()));
                }
                if (Compiler.namesStaticMember(sym)) {
                    Symbol target = Symbol.intern(sym.ns);
                    Class c = HostExpr.maybeClass(target, false);
                    if (c != null) {
                        Symbol meth = Symbol.intern(sym.name);
                        return Compiler.preserveTag(form, RT.listStar(DOT, target, meth, form.next()));
                    }
                } else {
                    int idx = sname.lastIndexOf(46);
                    if (idx == sname.length() - 1) {
                        return RT.listStar(NEW, Symbol.intern(sname.substring(0, idx)), form.next());
                    }
                }
            }
        }
        return x;
    }

    static Object macroexpand(Object form) throws Exception {
        Object exf = Compiler.macroexpand1(form);
        if (exf != form) {
            return Compiler.macroexpand(exf);
        }
        return form;
    }

    private static Expr analyzeSeq(C context, ISeq form, String name2) throws Exception {
        Integer line = (Integer)LINE.deref();
        if (RT.meta(form) != null && RT.meta(form).containsKey(RT.LINE_KEY)) {
            line = (Integer)RT.meta(form).valAt(RT.LINE_KEY);
        }
        Var.pushThreadBindings(RT.map(LINE, line));
        try {
            Object me = Compiler.macroexpand1(form);
            if (me != form) {
                Expr expr = Compiler.analyze(context, me, name2);
                return expr;
            }
            Object op = RT.first(form);
            if (op == null) {
                throw new IllegalArgumentException("Can't call nil");
            }
            IFn inline = Compiler.isInline(op, RT.count(RT.next(form)));
            if (inline != null) {
                Expr expr = Compiler.analyze(context, Compiler.preserveTag(form, inline.applyTo(RT.next(form))));
                return expr;
            }
            if (op.equals(FN)) {
                Expr expr = FnExpr.parse(context, form, name2);
                return expr;
            }
            IParser p = (IParser)specials.valAt(op);
            if (p != null) {
                Expr expr = p.parse(context, form);
                return expr;
            }
            Expr expr = InvokeExpr.parse(context, form);
            return expr;
        }
        catch (Throwable e2) {
            if (!(e2 instanceof CompilerException)) {
                throw new CompilerException((String)SOURCE_PATH.deref(), (Integer)LINE.deref(), e2);
            }
            throw (CompilerException)e2;
        }
        finally {
            Var.popThreadBindings();
        }
    }

    static String errorMsg(String source2, int line, String s) {
        return String.format("%s (%s:%d)", s, source2, line);
    }

    public static Object eval(Object form) throws Exception {
        return Compiler.eval(form, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object eval(Object form, boolean freshLoader) throws Exception {
        boolean createdLoader = false;
        Var.pushThreadBindings(RT.map(LOADER, RT.makeClassLoader()));
        createdLoader = true;
        try {
            block17: {
                block16: {
                    Object object;
                    Integer line = (Integer)LINE.deref();
                    if (RT.meta(form) != null && RT.meta(form).containsKey(RT.LINE_KEY)) {
                        line = (Integer)RT.meta(form).valAt(RT.LINE_KEY);
                    }
                    Var.pushThreadBindings(RT.map(LINE, line));
                    try {
                        form = Compiler.macroexpand(form);
                        if (!(form instanceof IPersistentCollection) || !Util.equals(RT.first(form), DO)) break block16;
                        ISeq s = RT.next(form);
                        while (RT.next(s) != null) {
                            Compiler.eval(RT.first(s), false);
                            s = RT.next(s);
                        }
                        object = Compiler.eval(RT.first(s), false);
                    }
                    catch (Throwable throwable) {
                        try {
                            Var.popThreadBindings();
                            throw throwable;
                        }
                        catch (Throwable e2) {
                            if (!(e2 instanceof CompilerException)) {
                                throw new CompilerException((String)SOURCE_PATH.deref(), (Integer)LINE.deref(), e2);
                            }
                            throw (CompilerException)e2;
                        }
                    }
                    Var.popThreadBindings();
                    return object;
                }
                if (!(form instanceof IPersistentCollection) || RT.first(form) instanceof Symbol && ((Symbol)RT.first((Object)form)).name.startsWith("def")) break block17;
                ObjExpr fexpr = (ObjExpr)Compiler.analyze(C.EXPRESSION, RT.list(FN, PersistentVector.EMPTY, form), "eval" + RT.nextID());
                IFn fn2 = (IFn)fexpr.eval();
                Object object = fn2.invoke();
                Var.popThreadBindings();
                return object;
            }
            Expr expr = Compiler.analyze(C.EVAL, form);
            Object object = expr.eval();
            Var.popThreadBindings();
            return object;
        }
        finally {
            if (createdLoader) {
                Var.popThreadBindings();
            }
        }
    }

    private static int registerConstant(Object o) {
        if (!CONSTANTS.isBound()) {
            return -1;
        }
        PersistentVector v = (PersistentVector)CONSTANTS.deref();
        IdentityHashMap ids = (IdentityHashMap)CONSTANT_IDS.deref();
        Integer i = (Integer)ids.get(o);
        if (i != null) {
            return i;
        }
        CONSTANTS.set(RT.conj(v, o));
        ids.put(o, v.count());
        return v.count();
    }

    private static KeywordExpr registerKeyword(Keyword keyword2) {
        if (!KEYWORDS.isBound()) {
            return new KeywordExpr(keyword2);
        }
        IPersistentMap keywordsMap = (IPersistentMap)KEYWORDS.deref();
        Object id = RT.get(keywordsMap, keyword2);
        if (id == null) {
            KEYWORDS.set(RT.assoc(keywordsMap, keyword2, Compiler.registerConstant(keyword2)));
        }
        return new KeywordExpr(keyword2);
    }

    private static int registerKeywordCallsite(Keyword keyword2) {
        if (!KEYWORD_CALLSITES.isBound()) {
            throw new IllegalAccessError("KEYWORD_CALLSITES is not bound");
        }
        IPersistentVector keywordCallsites = (IPersistentVector)KEYWORD_CALLSITES.deref();
        keywordCallsites = keywordCallsites.cons(keyword2);
        KEYWORD_CALLSITES.set(keywordCallsites);
        return keywordCallsites.count() - 1;
    }

    private static int registerProtocolCallsite(Var v) {
        if (!PROTOCOL_CALLSITES.isBound()) {
            throw new IllegalAccessError("PROTOCOL_CALLSITES is not bound");
        }
        IPersistentVector protocolCallsites = (IPersistentVector)PROTOCOL_CALLSITES.deref();
        protocolCallsites = protocolCallsites.cons(v);
        PROTOCOL_CALLSITES.set(protocolCallsites);
        return protocolCallsites.count() - 1;
    }

    private static int registerVarCallsite(Var v) {
        if (!VAR_CALLSITES.isBound()) {
            throw new IllegalAccessError("VAR_CALLSITES is not bound");
        }
        IPersistentVector varCallsites = (IPersistentVector)VAR_CALLSITES.deref();
        varCallsites = varCallsites.cons(v);
        VAR_CALLSITES.set(varCallsites);
        return varCallsites.count() - 1;
    }

    static ISeq fwdPath(PathNode p1) {
        ISeq ret = null;
        while (p1 != null) {
            ret = RT.cons(p1, ret);
            p1 = p1.parent;
        }
        return ret;
    }

    static PathNode commonPath(PathNode n1, PathNode n2) {
        ISeq xp = Compiler.fwdPath(n1);
        ISeq yp = Compiler.fwdPath(n2);
        if (RT.first(xp) != RT.first(yp)) {
            return null;
        }
        while (RT.second(xp) != null && RT.second(xp) == RT.second(yp)) {
            xp = xp.next();
            yp = yp.next();
        }
        return (PathNode)RT.first(xp);
    }

    static void addAnnotation(Object visitor, IPersistentMap meta2) {
        try {
            if (meta2 != null && ADD_ANNOTATIONS.isBound()) {
                ADD_ANNOTATIONS.invoke(visitor, meta2);
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    static void addParameterAnnotation(Object visitor, IPersistentMap meta2, int i) {
        try {
            if (meta2 != null && ADD_ANNOTATIONS.isBound()) {
                ADD_ANNOTATIONS.invoke(visitor, meta2, i);
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private static Expr analyzeSymbol(Symbol sym) throws Exception {
        Object o;
        Symbol nsSym;
        Class c;
        Symbol tag = Compiler.tagOf(sym);
        if (sym.ns == null) {
            LocalBinding b = Compiler.referenceLocal(sym);
            if (b != null) {
                return new LocalBindingExpr(b, tag);
            }
        } else if (Compiler.namespaceFor(sym) == null && (c = HostExpr.maybeClass(nsSym = Symbol.create(sym.ns), false)) != null) {
            if (Reflector.getField(c, sym.name, true) != null) {
                return new StaticFieldExpr((Integer)LINE.deref(), c, sym.name, tag);
            }
            throw new Exception("Unable to find static field: " + sym.name + " in " + c);
        }
        if ((o = Compiler.resolve(sym)) instanceof Var) {
            Var v = (Var)o;
            if (Compiler.isMacro(v) != null) {
                throw new Exception("Can't take value of a macro: " + v);
            }
            Compiler.registerVar(v);
            return new VarExpr(v, tag);
        }
        if (o instanceof Class) {
            return new ConstantExpr(o);
        }
        if (o instanceof Symbol) {
            return new UnresolvedVarExpr((Symbol)o);
        }
        throw new Exception("Unable to resolve symbol: " + sym + " in this context");
    }

    static String destubClassName(String className) {
        if (className.startsWith(COMPILE_STUB_PREFIX)) {
            return className.substring(COMPILE_STUB_PREFIX.length() + 1);
        }
        return className;
    }

    static Type getType(Class c) {
        String descriptor2 = Type.getType(c).getDescriptor();
        if (descriptor2.startsWith("L")) {
            descriptor2 = "L" + Compiler.destubClassName(descriptor2.substring(1));
        }
        return Type.getType(descriptor2);
    }

    static Object resolve(Symbol sym, boolean allowPrivate) throws Exception {
        return Compiler.resolveIn(Compiler.currentNS(), sym, allowPrivate);
    }

    static Object resolve(Symbol sym) throws Exception {
        return Compiler.resolveIn(Compiler.currentNS(), sym, false);
    }

    static Namespace namespaceFor(Symbol sym) {
        return Compiler.namespaceFor(Compiler.currentNS(), sym);
    }

    static Namespace namespaceFor(Namespace inns, Symbol sym) {
        Symbol nsSym = Symbol.create(sym.ns);
        Namespace ns2 = inns.lookupAlias(nsSym);
        if (ns2 == null) {
            ns2 = Namespace.find(nsSym);
        }
        return ns2;
    }

    public static Object resolveIn(Namespace n, Symbol sym, boolean allowPrivate) throws Exception {
        if (sym.ns != null) {
            Namespace ns2 = Compiler.namespaceFor(n, sym);
            if (ns2 == null) {
                throw new Exception("No such namespace: " + sym.ns);
            }
            Var v = ns2.findInternedVar(Symbol.create(sym.name));
            if (v == null) {
                throw new Exception("No such var: " + sym);
            }
            if (v.ns != Compiler.currentNS() && !v.isPublic() && !allowPrivate) {
                throw new IllegalStateException("var: " + sym + " is not public");
            }
            return v;
        }
        if (sym.name.indexOf(46) > 0 || sym.name.charAt(0) == '[') {
            return RT.classForName(sym.name);
        }
        if (sym.equals(NS)) {
            return RT.NS_VAR;
        }
        if (sym.equals(IN_NS)) {
            return RT.IN_NS_VAR;
        }
        if (Util.equals(sym, COMPILE_STUB_SYM.get())) {
            return COMPILE_STUB_CLASS.get();
        }
        Object o = n.getMapping(sym);
        if (o == null) {
            if (RT.booleanCast(RT.ALLOW_UNRESOLVED_VARS.deref())) {
                return sym;
            }
            throw new Exception("Unable to resolve symbol: " + sym + " in this context");
        }
        return o;
    }

    public static Object maybeResolveIn(Namespace n, Symbol sym) throws Exception {
        if (sym.ns != null) {
            Namespace ns2 = Compiler.namespaceFor(n, sym);
            if (ns2 == null) {
                return null;
            }
            Var v = ns2.findInternedVar(Symbol.create(sym.name));
            if (v == null) {
                return null;
            }
            return v;
        }
        if (sym.name.indexOf(46) > 0 && !sym.name.endsWith(".") || sym.name.charAt(0) == '[') {
            return RT.classForName(sym.name);
        }
        if (sym.equals(NS)) {
            return RT.NS_VAR;
        }
        if (sym.equals(IN_NS)) {
            return RT.IN_NS_VAR;
        }
        Object o = n.getMapping(sym);
        return o;
    }

    static Var lookupVar(Symbol sym, boolean internNew) throws Exception {
        Var var = null;
        if (sym.ns != null) {
            Namespace ns2 = Compiler.namespaceFor(sym);
            if (ns2 == null) {
                return null;
            }
            Symbol name2 = Symbol.create(sym.name);
            var = internNew && ns2 == Compiler.currentNS() ? Compiler.currentNS().intern(name2) : ns2.findInternedVar(name2);
        } else if (sym.equals(NS)) {
            var = RT.NS_VAR;
        } else if (sym.equals(IN_NS)) {
            var = RT.IN_NS_VAR;
        } else {
            Object o = Compiler.currentNS().getMapping(sym);
            if (o == null) {
                if (internNew) {
                    var = Compiler.currentNS().intern(Symbol.create(sym.name));
                }
            } else if (o instanceof Var) {
                var = (Var)o;
            } else {
                throw new Exception("Expecting var, but " + sym + " is mapped to " + o);
            }
        }
        if (var != null) {
            Compiler.registerVar(var);
        }
        return var;
    }

    private static void registerVar(Var var) throws Exception {
        if (!VARS.isBound()) {
            return;
        }
        IPersistentMap varsMap = (IPersistentMap)VARS.deref();
        Object id = RT.get(varsMap, var);
        if (id == null) {
            VARS.set(RT.assoc(varsMap, var, Compiler.registerConstant(var)));
        }
    }

    static Namespace currentNS() {
        return (Namespace)RT.CURRENT_NS.deref();
    }

    static void closeOver(LocalBinding b, ObjMethod method) {
        if (b != null && method != null) {
            if (RT.get(method.locals, b) == null) {
                method.objx.closes = (IPersistentMap)RT.assoc(method.objx.closes, b, b);
                Compiler.closeOver(b, method.parent);
            } else if (IN_CATCH_FINALLY.deref() != null) {
                method.localsUsedInCatchFinally = (PersistentHashSet)method.localsUsedInCatchFinally.cons(b.idx);
            }
        }
    }

    static LocalBinding referenceLocal(Symbol sym) throws Exception {
        if (!LOCAL_ENV.isBound()) {
            return null;
        }
        LocalBinding b = (LocalBinding)RT.get(LOCAL_ENV.deref(), sym);
        if (b != null) {
            ObjMethod method = (ObjMethod)METHOD.deref();
            Compiler.closeOver(b, method);
        }
        return b;
    }

    private static Symbol tagOf(Object o) {
        Object tag = RT.get(RT.meta(o), RT.TAG_KEY);
        if (tag instanceof Symbol) {
            return (Symbol)tag;
        }
        if (tag instanceof String) {
            return Symbol.intern(null, (String)tag);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object loadFile(String file2) throws Exception {
        FileInputStream f = new FileInputStream(file2);
        try {
            Object object = Compiler.load(new InputStreamReader((InputStream)f, RT.UTF8), new File(file2).getAbsolutePath(), new File(file2).getName());
            return object;
        }
        finally {
            f.close();
        }
    }

    public static Object load(Reader rdr) throws Exception {
        return Compiler.load(rdr, null, "NO_SOURCE_FILE");
    }

    public static Object load(Reader rdr, String sourcePath, String sourceName) throws Exception {
        Object EOF = new Object();
        Object ret = null;
        LineNumberingPushbackReader pushbackReader = rdr instanceof LineNumberingPushbackReader ? (LineNumberingPushbackReader)rdr : new LineNumberingPushbackReader(rdr);
        Var.pushThreadBindings(RT.map(LOADER, RT.makeClassLoader(), SOURCE_PATH, sourcePath, SOURCE, sourceName, METHOD, null, LOCAL_ENV, null, LOOP_LOCALS, null, NEXT_LOCAL_NUM, 0, RT.CURRENT_NS, RT.CURRENT_NS.deref(), LINE_BEFORE, pushbackReader.getLineNumber(), LINE_AFTER, pushbackReader.getLineNumber()));
        try {
            Object r2 = LispReader.read(pushbackReader, false, EOF, false);
            while (r2 != EOF) {
                LINE_AFTER.set(pushbackReader.getLineNumber());
                ret = Compiler.eval(r2, false);
                LINE_BEFORE.set(pushbackReader.getLineNumber());
                r2 = LispReader.read(pushbackReader, false, EOF, false);
            }
        }
        catch (LispReader.ReaderException e2) {
            throw new CompilerException(sourcePath, e2.line, e2.getCause());
        }
        finally {
            Var.popThreadBindings();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeClassFile(String internalName, byte[] bytecode) throws Exception {
        String genPath = (String)COMPILE_PATH.deref();
        if (genPath == null) {
            throw new Exception("*compile-path* not set");
        }
        String[] dirs = internalName.split("/");
        String p = genPath;
        for (int i = 0; i < dirs.length - 1; ++i) {
            p = p + File.separator + dirs[i];
            new File(p).mkdir();
        }
        String path2 = genPath + File.separator + internalName + ".class";
        File cf = new File(path2);
        cf.createNewFile();
        FileOutputStream cfs = new FileOutputStream(cf);
        try {
            cfs.write(bytecode);
            cfs.flush();
            cfs.getFD().sync();
        }
        finally {
            cfs.close();
        }
    }

    public static void pushNS() {
        Var.pushThreadBindings(PersistentHashMap.create(Var.intern(Symbol.create("clojure.core"), Symbol.create("*ns*")), null));
    }

    public static ILookupThunk getLookupThunk(Object target, Keyword k) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void compile1(GeneratorAdapter gen, ObjExpr objx, Object form) throws Exception {
        Integer line = (Integer)LINE.deref();
        if (RT.meta(form) != null && RT.meta(form).containsKey(RT.LINE_KEY)) {
            line = (Integer)RT.meta(form).valAt(RT.LINE_KEY);
        }
        Var.pushThreadBindings(RT.map(LINE, line, LOADER, RT.makeClassLoader()));
        try {
            form = Compiler.macroexpand(form);
            if (form instanceof IPersistentCollection && Util.equals(RT.first(form), DO)) {
                ISeq s = RT.next(form);
                while (s != null) {
                    Compiler.compile1(gen, objx, RT.first(s));
                    s = RT.next(s);
                }
            } else {
                Expr expr = Compiler.analyze(C.EVAL, form);
                objx.keywords = (IPersistentMap)KEYWORDS.deref();
                objx.vars = (IPersistentMap)VARS.deref();
                objx.constants = (PersistentVector)CONSTANTS.deref();
                expr.emit(C.EXPRESSION, objx, gen);
                expr.eval();
            }
        }
        finally {
            Var.popThreadBindings();
        }
    }

    public static Object compile(Reader rdr, String sourcePath, String sourceName) throws Exception {
        if (COMPILE_PATH.deref() == null) {
            throw new Exception("*compile-path* not set");
        }
        Object EOF = new Object();
        Object ret = null;
        LineNumberingPushbackReader pushbackReader = rdr instanceof LineNumberingPushbackReader ? (LineNumberingPushbackReader)rdr : new LineNumberingPushbackReader(rdr);
        Var.pushThreadBindings(RT.map(SOURCE_PATH, sourcePath, SOURCE, sourceName, METHOD, null, LOCAL_ENV, null, LOOP_LOCALS, null, NEXT_LOCAL_NUM, 0, RT.CURRENT_NS, RT.CURRENT_NS.deref(), LINE_BEFORE, pushbackReader.getLineNumber(), LINE_AFTER, pushbackReader.getLineNumber(), CONSTANTS, PersistentVector.EMPTY, CONSTANT_IDS, new IdentityHashMap(), KEYWORDS, PersistentHashMap.EMPTY, VARS, PersistentHashMap.EMPTY));
        try {
            ClassWriter cw;
            ObjExpr objx = new ObjExpr(null);
            objx.internalName = sourcePath.replace(File.separator, "/").substring(0, sourcePath.lastIndexOf(46)) + "__init";
            objx.objtype = Type.getObjectType(objx.internalName);
            ClassWriter cv = cw = new ClassWriter(1);
            cv.visit(49, 33, objx.internalName, null, "java/lang/Object", null);
            GeneratorAdapter gen = new GeneratorAdapter(9, clojure.asm.commons.Method.getMethod("void load ()"), null, null, cv);
            gen.visitCode();
            Object r2 = LispReader.read(pushbackReader, false, EOF, false);
            while (r2 != EOF) {
                LINE_AFTER.set(pushbackReader.getLineNumber());
                Compiler.compile1(gen, objx, r2);
                LINE_BEFORE.set(pushbackReader.getLineNumber());
                r2 = LispReader.read(pushbackReader, false, EOF, false);
            }
            gen.returnValue();
            gen.endMethod();
            for (int i = 0; i < objx.constants.count(); ++i) {
                cv.visitField(25, objx.constantName(i), objx.constantType(i).getDescriptor(), null, null);
            }
            GeneratorAdapter clinitgen = new GeneratorAdapter(9, clojure.asm.commons.Method.getMethod("void <clinit> ()"), null, null, cv);
            clinitgen.visitCode();
            Label startTry = clinitgen.newLabel();
            Label endTry = clinitgen.newLabel();
            Label end = clinitgen.newLabel();
            Label finallyLabel = clinitgen.newLabel();
            if (objx.constants.count() > 0) {
                objx.emitConstants(clinitgen);
            }
            clinitgen.invokeStatic(Type.getType(Compiler.class), clojure.asm.commons.Method.getMethod("void pushNS()"));
            clinitgen.mark(startTry);
            clinitgen.invokeStatic(objx.objtype, clojure.asm.commons.Method.getMethod("void load()"));
            clinitgen.mark(endTry);
            clinitgen.invokeStatic(VAR_TYPE, clojure.asm.commons.Method.getMethod("void popThreadBindings()"));
            clinitgen.goTo(end);
            clinitgen.mark(finallyLabel);
            clinitgen.invokeStatic(VAR_TYPE, clojure.asm.commons.Method.getMethod("void popThreadBindings()"));
            clinitgen.throwException();
            clinitgen.mark(end);
            clinitgen.visitTryCatchBlock(startTry, endTry, finallyLabel, null);
            clinitgen.returnValue();
            clinitgen.endMethod();
            cv.visitEnd();
            Compiler.writeClassFile(objx.internalName, cw.toByteArray());
        }
        catch (LispReader.ReaderException e2) {
            throw new CompilerException(sourcePath, e2.line, e2.getCause());
        }
        finally {
            Var.popThreadBindings();
        }
        return ret;
    }

    static Class primClass(Symbol sym) {
        if (sym == null) {
            return null;
        }
        Class<Object> c = null;
        if (sym.name.equals("int")) {
            c = Integer.TYPE;
        } else if (sym.name.equals("long")) {
            c = Long.TYPE;
        } else if (sym.name.equals("float")) {
            c = Float.TYPE;
        } else if (sym.name.equals("double")) {
            c = Double.TYPE;
        } else if (sym.name.equals("char")) {
            c = Character.TYPE;
        } else if (sym.name.equals("short")) {
            c = Short.TYPE;
        } else if (sym.name.equals("byte")) {
            c = Byte.TYPE;
        } else if (sym.name.equals("boolean")) {
            c = Boolean.TYPE;
        } else if (sym.name.equals("void")) {
            c = Void.TYPE;
        }
        return c;
    }

    static Class tagClass(Object tag) throws Exception {
        if (tag == null) {
            return Object.class;
        }
        Class c = null;
        if (tag instanceof Symbol) {
            c = Compiler.primClass((Symbol)tag);
        }
        if (c == null) {
            c = HostExpr.tagToClass(tag);
        }
        return c;
    }

    static {
        KEYWORD_TYPE = Type.getType(Keyword.class);
        VAR_TYPE = Type.getType(Var.class);
        SYMBOL_TYPE = Type.getType(Symbol.class);
        IFN_TYPE = Type.getType(IFn.class);
        AFUNCTION_TYPE = Type.getType(AFunction.class);
        RT_TYPE = Type.getType(RT.class);
        CLASS_TYPE = Type.getType(Class.class);
        NS_TYPE = Type.getType(Namespace.class);
        UTIL_TYPE = Type.getType(Util.class);
        REFLECTOR_TYPE = Type.getType(Reflector.class);
        THROWABLE_TYPE = Type.getType(Throwable.class);
        BOOLEAN_OBJECT_TYPE = Type.getType(Boolean.class);
        IPERSISTENTMAP_TYPE = Type.getType(IPersistentMap.class);
        IOBJ_TYPE = Type.getType(IObj.class);
        EXCEPTION_TYPES = new Type[]{Type.getType(Exception.class)};
        OBJECT_TYPE = Type.getType(Object.class);
        ARG_TYPES = new Type[22][];
        for (int i = 0; i <= 20; ++i) {
            Type[] a = new Type[i];
            for (int j = 0; j < i; ++j) {
                a[j] = OBJECT_TYPE;
            }
            Compiler.ARG_TYPES[i] = a;
        }
        Type[] a = new Type[21];
        for (int j = 0; j < 20; ++j) {
            a[j] = OBJECT_TYPE;
        }
        a[20] = Type.getType("[Ljava/lang/Object;");
        Compiler.ARG_TYPES[21] = a;
        LOCAL_ENV = Var.create(null);
        LOOP_LOCALS = Var.create();
        LOOP_LABEL = Var.create();
        CONSTANTS = Var.create();
        CONSTANT_IDS = Var.create();
        KEYWORD_CALLSITES = Var.create();
        PROTOCOL_CALLSITES = Var.create();
        VAR_CALLSITES = Var.create();
        KEYWORDS = Var.create();
        VARS = Var.create();
        METHOD = Var.create(null);
        IN_CATCH_FINALLY = Var.create(null);
        LOADER = Var.create();
        SOURCE = Var.intern(Namespace.findOrCreate(Symbol.create("clojure.core")), Symbol.create("*source-path*"), "NO_SOURCE_FILE");
        SOURCE_PATH = Var.intern(Namespace.findOrCreate(Symbol.create("clojure.core")), Symbol.create("*file*"), "NO_SOURCE_PATH");
        COMPILE_PATH = Var.intern(Namespace.findOrCreate(Symbol.create("clojure.core")), Symbol.create("*compile-path*"), null);
        COMPILE_FILES = Var.intern(Namespace.findOrCreate(Symbol.create("clojure.core")), Symbol.create("*compile-files*"), Boolean.FALSE);
        INSTANCE = Var.intern(Namespace.findOrCreate(Symbol.create("clojure.core")), Symbol.create("instance?"));
        ADD_ANNOTATIONS = Var.intern(Namespace.findOrCreate(Symbol.create("clojure.core")), Symbol.create("add-annotations"));
        LINE = Var.create(0);
        LINE_BEFORE = Var.create(0);
        LINE_AFTER = Var.create(0);
        NEXT_LOCAL_NUM = Var.create(0);
        RET_LOCAL_NUM = Var.create();
        COMPILE_STUB_SYM = Var.create(null);
        COMPILE_STUB_CLASS = Var.create(null);
        CLEAR_PATH = Var.create(null);
        CLEAR_ROOT = Var.create(null);
        CLEAR_SITES = Var.create(null);
        NIL_EXPR = new NilExpr();
        TRUE_EXPR = new BooleanExpr(true);
        FALSE_EXPR = new BooleanExpr(false);
        CHAR_MAP = PersistentHashMap.create(Character.valueOf('-'), "_", Character.valueOf(':'), "_COLON_", Character.valueOf('+'), "_PLUS_", Character.valueOf('>'), "_GT_", Character.valueOf('<'), "_LT_", Character.valueOf('='), "_EQ_", Character.valueOf('~'), "_TILDE_", Character.valueOf('!'), "_BANG_", Character.valueOf('@'), "_CIRCA_", Character.valueOf('#'), "_SHARP_", Character.valueOf('$'), "_DOLLARSIGN_", Character.valueOf('%'), "_PERCENT_", Character.valueOf('^'), "_CARET_", Character.valueOf('&'), "_AMPERSAND_", Character.valueOf('*'), "_STAR_", Character.valueOf('|'), "_BAR_", Character.valueOf('{'), "_LBRACE_", Character.valueOf('}'), "_RBRACE_", Character.valueOf('['), "_LBRACK_", Character.valueOf(']'), "_RBRACK_", Character.valueOf('/'), "_SLASH_", Character.valueOf('\\'), "_BSLASH_", Character.valueOf('?'), "_QMARK_");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CaseExpr
    extends UntypedExpr {
        public final LocalBindingExpr expr;
        public final int shift;
        public final int mask;
        public final int low;
        public final int high;
        public final Expr defaultExpr;
        public final HashMap<Integer, Expr> tests;
        public final HashMap<Integer, Expr> thens;
        public final boolean allKeywords;
        public final int line;
        static final clojure.asm.commons.Method hashMethod = clojure.asm.commons.Method.getMethod("int hash(Object)");
        static final clojure.asm.commons.Method hashCodeMethod = clojure.asm.commons.Method.getMethod("int hashCode()");
        static final clojure.asm.commons.Method equalsMethod = clojure.asm.commons.Method.getMethod("boolean equals(Object, Object)");

        public CaseExpr(int line, LocalBindingExpr expr, int shift, int mask, int low, int high, Expr defaultExpr, HashMap<Integer, Expr> tests, HashMap<Integer, Expr> thens, boolean allKeywords) {
            this.expr = expr;
            this.shift = shift;
            this.mask = mask;
            this.low = low;
            this.high = high;
            this.defaultExpr = defaultExpr;
            this.tests = tests;
            this.thens = thens;
            this.line = line;
            this.allKeywords = allKeywords;
        }

        @Override
        public Object eval() throws Exception {
            throw new UnsupportedOperationException("Can't eval case");
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            Label defaultLabel = gen.newLabel();
            Label endLabel = gen.newLabel();
            HashMap<Integer, Label> labels = new HashMap<Integer, Label>();
            for (Integer i : this.tests.keySet()) {
                labels.put(i, gen.newLabel());
            }
            Label[] la = new Label[this.high - this.low + 1];
            for (int i = this.low; i <= this.high; ++i) {
                la[i - this.low] = labels.containsKey(i) ? (Label)labels.get(i) : defaultLabel;
            }
            gen.visitLineNumber(this.line, gen.mark());
            this.expr.emit(C.EXPRESSION, objx, gen);
            gen.invokeStatic(UTIL_TYPE, hashMethod);
            gen.push(this.shift);
            gen.visitInsn(122);
            gen.push(this.mask);
            gen.visitInsn(126);
            gen.visitTableSwitchInsn(this.low, this.high, defaultLabel, la);
            for (Integer i : labels.keySet()) {
                gen.mark((Label)labels.get(i));
                this.expr.emit(C.EXPRESSION, objx, gen);
                this.tests.get(i).emit(C.EXPRESSION, objx, gen);
                if (this.allKeywords) {
                    gen.visitJumpInsn(166, defaultLabel);
                } else {
                    gen.invokeStatic(UTIL_TYPE, equalsMethod);
                    gen.ifZCmp(153, defaultLabel);
                }
                this.thens.get(i).emit(C.EXPRESSION, objx, gen);
                gen.goTo(endLabel);
            }
            gen.mark(defaultLabel);
            this.defaultExpr.emit(C.EXPRESSION, objx, gen);
            gen.mark(endLabel);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Expr parse(C context, Object frm) throws Exception {
                Expr defaultExpr;
                ISeq form = (ISeq)frm;
                if (context == C.EVAL) {
                    return Compiler.analyze(context, RT.list(RT.list(FN, PersistentVector.EMPTY, form)));
                }
                PersistentVector args = PersistentVector.create(form.next());
                HashMap<Integer, Expr> tests = new HashMap<Integer, Expr>();
                HashMap<Integer, Expr> thens = new HashMap<Integer, Expr>();
                LocalBindingExpr testexpr = (LocalBindingExpr)Compiler.analyze(C.EXPRESSION, args.nth(0));
                testexpr.shouldClear = false;
                PathNode branch = new PathNode(PATHTYPE.BRANCH, (PathNode)CLEAR_PATH.get());
                Iterator i$ = ((Map)args.nth(6)).entrySet().iterator();
                while (i$.hasNext()) {
                    Expr thenExpr;
                    Map.Entry o;
                    Map.Entry e2 = o = i$.next();
                    Integer minhash = (Integer)e2.getKey();
                    MapEntry me = (MapEntry)e2.getValue();
                    ConstantExpr testExpr = new ConstantExpr(me.getKey());
                    tests.put(minhash, testExpr);
                    try {
                        Var.pushThreadBindings(RT.map(CLEAR_PATH, new PathNode(PATHTYPE.PATH, branch)));
                        thenExpr = Compiler.analyze(context, me.getValue());
                    }
                    finally {
                        Var.popThreadBindings();
                    }
                    thens.put(minhash, thenExpr);
                }
                try {
                    Var.pushThreadBindings(RT.map(CLEAR_PATH, new PathNode(PATHTYPE.PATH, branch)));
                    defaultExpr = Compiler.analyze(context, args.nth(5));
                }
                finally {
                    Var.popThreadBindings();
                }
                return new CaseExpr((Integer)LINE.deref(), testexpr, (Integer)args.nth(1), (Integer)args.nth(2), (Integer)args.nth(3), (Integer)args.nth(4), defaultExpr, tests, thens, args.nth(7) != RT.F);
            }
        }
    }

    public static class MethodParamExpr
    implements Expr,
    MaybePrimitiveExpr {
        final Class c;

        public MethodParamExpr(Class c) {
            this.c = c;
        }

        public Object eval() throws Exception {
            throw new Exception("Can't eval");
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            throw new RuntimeException("Can't emit");
        }

        public boolean hasJavaClass() throws Exception {
            return this.c != null;
        }

        public Class getJavaClass() throws Exception {
            return this.c;
        }

        public boolean canEmitPrimitive() {
            return Util.isPrimitive(this.c);
        }

        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            throw new RuntimeException("Can't emit");
        }
    }

    public static class NewInstanceMethod
    extends ObjMethod {
        String name;
        Type[] argTypes;
        Type retType;
        Class retClass;
        Class[] exclasses;
        static Symbol dummyThis = Symbol.intern(null, "dummy_this_dlskjsdfower");
        private IPersistentVector parms;

        public NewInstanceMethod(ObjExpr objx, ObjMethod parent) {
            super(objx, parent);
        }

        int numParams() {
            return this.argLocals.count();
        }

        String getMethodName() {
            return this.name;
        }

        Type getReturnType() {
            return this.retType;
        }

        Type[] getArgTypes() {
            return this.argTypes;
        }

        public static IPersistentVector msig(String name2, Class[] paramTypes) {
            return RT.vector(name2, RT.seq(paramTypes));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static NewInstanceMethod parse(ObjExpr objx, ISeq form, Symbol thistag, Map overrideables) throws Exception {
            NewInstanceMethod method = new NewInstanceMethod(objx, (ObjMethod)METHOD.deref());
            Symbol dotname = (Symbol)RT.first(form);
            Symbol name2 = (Symbol)Symbol.intern(null, Compiler.munge(dotname.name)).withMeta(RT.meta(dotname));
            IPersistentVector parms = (IPersistentVector)RT.second(form);
            if (parms.count() == 0) {
                throw new IllegalArgumentException("Must supply at least one argument for 'this' in: " + dotname);
            }
            Symbol thisName = (Symbol)parms.nth(0);
            parms = RT.subvec(parms, 1, parms.count());
            ISeq body = RT.next(RT.next(form));
            try {
                int i;
                method.line = (Integer)LINE.deref();
                PathNode pnode = new PathNode(PATHTYPE.PATH, (PathNode)CLEAR_PATH.get());
                Var.pushThreadBindings(RT.map(METHOD, method, LOCAL_ENV, LOCAL_ENV.deref(), LOOP_LOCALS, null, NEXT_LOCAL_NUM, 0, CLEAR_PATH, pnode, CLEAR_ROOT, pnode, CLEAR_SITES, PersistentHashMap.EMPTY));
                if (thisName != null) {
                    Compiler.registerLocal(thisName == null ? NewInstanceMethod.dummyThis : thisName, thistag, null, false);
                } else {
                    Compiler.getAndIncLocalNum();
                }
                PersistentVector argLocals = PersistentVector.EMPTY;
                method.retClass = Compiler.tagClass(Compiler.tagOf(name2));
                method.argTypes = new Type[parms.count()];
                boolean hinted = Compiler.tagOf(name2) != null;
                Class[] pclasses = new Class[parms.count()];
                Symbol[] psyms = new Symbol[parms.count()];
                for (int i2 = 0; i2 < parms.count(); ++i2) {
                    Class pclass;
                    if (!(parms.nth(i2) instanceof Symbol)) {
                        throw new IllegalArgumentException("params must be Symbols");
                    }
                    Symbol p = (Symbol)parms.nth(i2);
                    Symbol tag = Compiler.tagOf(p);
                    if (tag != null) {
                        hinted = true;
                    }
                    if (p.getNamespace() != null) {
                        p = Symbol.create(p.name);
                    }
                    pclasses[i2] = pclass = Compiler.tagClass(tag);
                    psyms[i2] = p;
                }
                Map matches = NewInstanceMethod.findMethodsWithNameAndArity(name2.name, parms.count(), overrideables);
                IPersistentVector mk = NewInstanceMethod.msig(name2.name, pclasses);
                Method m = null;
                if (matches.size() > 0) {
                    if (matches.size() > 1) {
                        if (!hinted) {
                            throw new IllegalArgumentException("Must hint overloaded method: " + name2.name);
                        }
                        m = (Method)matches.get(mk);
                        if (m == null) {
                            throw new IllegalArgumentException("Can't find matching overloaded method: " + name2.name);
                        }
                        if (m.getReturnType() != method.retClass) {
                            throw new IllegalArgumentException("Mismatched return type: " + name2.name + ", expected: " + m.getReturnType().getName() + ", had: " + method.retClass.getName());
                        }
                    } else if (hinted) {
                        m = (Method)matches.get(mk);
                        if (m == null) {
                            throw new IllegalArgumentException("Can't find matching method: " + name2.name + ", leave off hints for auto match.");
                        }
                        if (m.getReturnType() != method.retClass) {
                            throw new IllegalArgumentException("Mismatched return type: " + name2.name + ", expected: " + m.getReturnType().getName() + ", had: " + method.retClass.getName());
                        }
                    } else {
                        m = (Method)matches.values().iterator().next();
                        method.retClass = m.getReturnType();
                        pclasses = m.getParameterTypes();
                    }
                } else {
                    throw new IllegalArgumentException("Can't define method not in interfaces: " + name2.name);
                }
                method.retType = Type.getType(method.retClass);
                method.exclasses = m.getExceptionTypes();
                for (i = 0; i < parms.count(); ++i) {
                    LocalBinding lb = Compiler.registerLocal(psyms[i], null, new MethodParamExpr(pclasses[i]), true);
                    argLocals = argLocals.assocN(i, lb);
                    method.argTypes[i] = Type.getType(pclasses[i]);
                }
                for (i = 0; i < parms.count(); ++i) {
                    if (pclasses[i] != Long.TYPE && pclasses[i] != Double.TYPE) continue;
                    Compiler.getAndIncLocalNum();
                }
                LOOP_LOCALS.set(argLocals);
                method.name = name2.name;
                method.methodMeta = RT.meta(name2);
                method.parms = parms;
                method.argLocals = argLocals;
                method.body = new BodyExpr.Parser().parse(C.RETURN, body);
                NewInstanceMethod newInstanceMethod = method;
                return newInstanceMethod;
            }
            finally {
                Var.popThreadBindings();
            }
        }

        private static Map findMethodsWithNameAndArity(String name2, int arity, Map mm) {
            HashMap ret = new HashMap();
            for (Map.Entry o : mm.entrySet()) {
                Map.Entry e2 = o;
                Method m = (Method)e2.getValue();
                if (!name2.equals(m.getName()) || m.getParameterTypes().length != arity) continue;
                ret.put(e2.getKey(), e2.getValue());
            }
            return ret;
        }

        private static Map findMethodsWithName(String name2, Map mm) {
            HashMap ret = new HashMap();
            for (Map.Entry o : mm.entrySet()) {
                Map.Entry e2 = o;
                Method m = (Method)e2.getValue();
                if (!name2.equals(m.getName())) continue;
                ret.put(e2.getKey(), e2.getValue());
            }
            return ret;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void emit(ObjExpr obj, ClassVisitor cv) {
            clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.getMethodName(), this.getReturnType(), this.getArgTypes());
            Type[] extypes = null;
            if (this.exclasses.length > 0) {
                extypes = new Type[this.exclasses.length];
                for (int i = 0; i < this.exclasses.length; ++i) {
                    extypes[i] = Type.getType(this.exclasses[i]);
                }
            }
            GeneratorAdapter gen = new GeneratorAdapter(1, m, null, extypes, cv);
            Compiler.addAnnotation(gen, this.methodMeta);
            for (int i = 0; i < this.parms.count(); ++i) {
                IPersistentMap meta2 = RT.meta(this.parms.nth(i));
                Compiler.addParameterAnnotation(gen, meta2, i);
            }
            gen.visitCode();
            Label loopLabel = gen.mark();
            gen.visitLineNumber(this.line, loopLabel);
            try {
                Var.pushThreadBindings(RT.map(LOOP_LABEL, loopLabel, METHOD, this));
                MaybePrimitiveExpr be = (MaybePrimitiveExpr)this.body;
                if (Util.isPrimitive(this.retClass) && be.canEmitPrimitive()) {
                    if (be.getJavaClass() != this.retClass) throw new IllegalArgumentException("Mismatched primitive return, expected: " + this.retClass + ", had: " + be.getJavaClass());
                    be.emitUnboxed(C.RETURN, obj, gen);
                } else {
                    this.body.emit(C.RETURN, obj, gen);
                    if (this.retClass == Void.TYPE) {
                        gen.pop();
                    } else {
                        gen.unbox(this.retType);
                    }
                }
                Label end = gen.mark();
                gen.visitLocalVariable("this", obj.objtype.getDescriptor(), null, loopLabel, end, 0);
                for (ISeq lbs = this.argLocals.seq(); lbs != null; lbs = lbs.next()) {
                    LocalBinding lb = (LocalBinding)lbs.first();
                    gen.visitLocalVariable(lb.name, this.argTypes[lb.idx - 1].getDescriptor(), null, loopLabel, end, lb.idx);
                }
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
            finally {
                Var.popThreadBindings();
            }
            gen.returnValue();
            gen.endMethod();
        }
    }

    public static class NewInstanceExpr
    extends ObjExpr {
        IPersistentCollection methods;
        Map<IPersistentVector, Method> mmap;
        Map<IPersistentVector, Set<Class>> covariants;

        public NewInstanceExpr(Object tag) {
            super(tag);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static ObjExpr build(IPersistentVector interfaceSyms, IPersistentVector fieldSyms, Symbol thisSym, String tagName, Symbol className, Symbol typeTag, ISeq methodForms, Object frm) throws Exception {
            NewInstanceExpr ret = new NewInstanceExpr(null);
            ret.src = frm;
            ret.name = className.toString();
            ret.classMeta = RT.meta(className);
            ret.internalName = ret.name.replace('.', '/');
            ret.objtype = Type.getObjectType(ret.internalName);
            if (thisSym != null) {
                ret.thisName = thisSym.name;
            }
            if (fieldSyms != null) {
                int i;
                IPersistentMap fmap = PersistentHashMap.EMPTY;
                Object[] closesvec = new Object[2 * fieldSyms.count()];
                for (i = 0; i < fieldSyms.count(); ++i) {
                    Symbol sym = (Symbol)fieldSyms.nth(i);
                    LocalBinding lb = new LocalBinding(-1, sym, null, new MethodParamExpr(Compiler.tagClass(Compiler.tagOf(sym))), false, null);
                    fmap = fmap.assoc(sym, lb);
                    closesvec[i * 2] = lb;
                    closesvec[i * 2 + 1] = lb;
                }
                ret.closes = new PersistentArrayMap(closesvec);
                ret.fields = fmap;
                for (i = fieldSyms.count() - 1; i >= 0 && ((Symbol)fieldSyms.nth((int)i)).name.startsWith("__"); --i) {
                    ++ret.altCtorDrops;
                }
            }
            PersistentVector interfaces = PersistentVector.EMPTY;
            for (ISeq s = RT.seq(interfaceSyms); s != null; s = s.next()) {
                Class c = (Class)Compiler.resolve((Symbol)s.first());
                if (!c.isInterface()) {
                    throw new IllegalArgumentException("only interfaces are supported, had: " + c.getName());
                }
                interfaces = interfaces.cons(c);
            }
            Class<Object> superClass = Object.class;
            Map[] mc = NewInstanceExpr.gatherMethods(superClass, RT.seq(interfaces));
            Map overrideables = mc[0];
            Map covariants = mc[1];
            ret.mmap = overrideables;
            ret.covariants = covariants;
            String[] inames = NewInstanceExpr.interfaceNames(interfaces);
            Class stub = NewInstanceExpr.compileStub(NewInstanceExpr.slashname(superClass), ret, inames, frm);
            Symbol thistag = Symbol.intern(null, stub.getName());
            try {
                Var.pushThreadBindings(RT.map(CONSTANTS, PersistentVector.EMPTY, CONSTANT_IDS, new IdentityHashMap(), KEYWORDS, PersistentHashMap.EMPTY, VARS, PersistentHashMap.EMPTY, KEYWORD_CALLSITES, PersistentVector.EMPTY, PROTOCOL_CALLSITES, PersistentVector.EMPTY, VAR_CALLSITES, PersistentVector.EMPTY));
                if (ret.isDeftype()) {
                    Var.pushThreadBindings(RT.map(METHOD, null, LOCAL_ENV, ret.fields, COMPILE_STUB_SYM, Symbol.intern(null, tagName), COMPILE_STUB_CLASS, stub));
                }
                ret.line = (Integer)LINE.deref();
                IPersistentCollection methods2 = null;
                ISeq s = methodForms;
                while (s != null) {
                    NewInstanceMethod m = NewInstanceMethod.parse(ret, (ISeq)RT.first(s), thistag, overrideables);
                    methods2 = RT.conj(methods2, m);
                    s = RT.next(s);
                }
                ret.methods = methods2;
                ret.keywords = (IPersistentMap)KEYWORDS.deref();
                ret.vars = (IPersistentMap)VARS.deref();
                ret.constants = (PersistentVector)CONSTANTS.deref();
                ret.constantsID = RT.nextID();
                ret.keywordCallsites = (IPersistentVector)KEYWORD_CALLSITES.deref();
                ret.protocolCallsites = (IPersistentVector)PROTOCOL_CALLSITES.deref();
                ret.varCallsites = (IPersistentVector)VAR_CALLSITES.deref();
            }
            finally {
                if (ret.isDeftype()) {
                    Var.popThreadBindings();
                }
                Var.popThreadBindings();
            }
            ret.compile(NewInstanceExpr.slashname(superClass), inames, false);
            ret.getCompiledClass();
            return ret;
        }

        static Class compileStub(String superName, NewInstanceExpr ret, String[] interfaceNames, Object frm) {
            ClassWriter cw;
            ClassWriter cv = cw = new ClassWriter(1);
            cv.visit(49, 33, "compile__stub/" + ret.internalName, null, superName, interfaceNames);
            for (ISeq s = RT.keys(ret.closes); s != null; s = s.next()) {
                LocalBinding lb = (LocalBinding)s.first();
                int access = 1 + (ret.isVolatile(lb) ? 64 : (ret.isMutable(lb) ? 0 : 16));
                if (lb.getPrimitiveType() != null) {
                    cv.visitField(access, lb.name, Type.getType(lb.getPrimitiveType()).getDescriptor(), null, null);
                    continue;
                }
                cv.visitField(access, lb.name, OBJECT_TYPE.getDescriptor(), null, null);
            }
            clojure.asm.commons.Method m = new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, ret.ctorTypes());
            GeneratorAdapter ctorgen = new GeneratorAdapter(1, m, null, null, cv);
            ctorgen.visitCode();
            ctorgen.loadThis();
            ctorgen.invokeConstructor(Type.getObjectType(superName), voidctor);
            ctorgen.returnValue();
            ctorgen.endMethod();
            if (ret.altCtorDrops > 0) {
                Type[] ctorTypes = ret.ctorTypes();
                Type[] altCtorTypes = new Type[ctorTypes.length - ret.altCtorDrops];
                for (int i = 0; i < altCtorTypes.length; ++i) {
                    altCtorTypes[i] = ctorTypes[i];
                }
                clojure.asm.commons.Method alt = new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, altCtorTypes);
                ctorgen = new GeneratorAdapter(1, alt, null, null, cv);
                ctorgen.visitCode();
                ctorgen.loadThis();
                ctorgen.loadArgs();
                for (int i = 0; i < ret.altCtorDrops; ++i) {
                    ctorgen.visitInsn(1);
                }
                ctorgen.invokeConstructor(Type.getObjectType("compile__stub/" + ret.internalName), new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, ctorTypes));
                ctorgen.returnValue();
                ctorgen.endMethod();
            }
            cv.visitEnd();
            byte[] bytecode = cw.toByteArray();
            DynamicClassLoader loader = (DynamicClassLoader)LOADER.deref();
            return loader.defineClass("compile__stub." + ret.name, bytecode, frm);
        }

        static String[] interfaceNames(IPersistentVector interfaces) {
            int icnt = interfaces.count();
            String[] inames = icnt > 0 ? new String[icnt] : null;
            for (int i = 0; i < icnt; ++i) {
                inames[i] = NewInstanceExpr.slashname((Class)interfaces.nth(i));
            }
            return inames;
        }

        static String slashname(Class c) {
            return c.getName().replace('.', '/');
        }

        protected void emitMethods(ClassVisitor cv) {
            for (ISeq s = RT.seq(this.methods); s != null; s = s.next()) {
                ObjMethod method = (ObjMethod)s.first();
                method.emit(this, cv);
            }
            for (Map.Entry<IPersistentVector, Set<Class>> e2 : this.covariants.entrySet()) {
                Method m = this.mmap.get(e2.getKey());
                Class<?>[] params = m.getParameterTypes();
                Type[] argTypes = new Type[params.length];
                for (int i = 0; i < params.length; ++i) {
                    argTypes[i] = Type.getType(params[i]);
                }
                clojure.asm.commons.Method target = new clojure.asm.commons.Method(m.getName(), Type.getType(m.getReturnType()), argTypes);
                for (Class retType : e2.getValue()) {
                    clojure.asm.commons.Method meth = new clojure.asm.commons.Method(m.getName(), Type.getType(retType), argTypes);
                    GeneratorAdapter gen = new GeneratorAdapter(65, meth, null, EXCEPTION_TYPES, cv);
                    gen.visitCode();
                    gen.loadThis();
                    gen.loadArgs();
                    gen.invokeInterface(Type.getType(m.getDeclaringClass()), target);
                    gen.returnValue();
                    gen.endMethod();
                }
            }
        }

        public static IPersistentVector msig(Method m) {
            return RT.vector(m.getName(), RT.seq(m.getParameterTypes()), m.getReturnType());
        }

        static void considerMethod(Method m, Map mm) {
            IPersistentVector mk = NewInstanceExpr.msig(m);
            int mods = m.getModifiers();
            if (!(mm.containsKey(mk) || !Modifier.isPublic(mods) && !Modifier.isProtected(mods) || Modifier.isStatic(mods) || Modifier.isFinal(mods))) {
                mm.put(mk, m);
            }
        }

        static void gatherMethods(Class c, Map mm) {
            while (c != null) {
                for (Method m : c.getDeclaredMethods()) {
                    NewInstanceExpr.considerMethod(m, mm);
                }
                for (Method m : c.getMethods()) {
                    NewInstanceExpr.considerMethod(m, mm);
                }
                c = c.getSuperclass();
            }
        }

        public static Map[] gatherMethods(Class sc, ISeq interfaces) {
            HashMap allm = new HashMap();
            NewInstanceExpr.gatherMethods(sc, allm);
            while (interfaces != null) {
                NewInstanceExpr.gatherMethods((Class)interfaces.first(), allm);
                interfaces = interfaces.next();
            }
            HashMap<IPersistentVector, Method> mm = new HashMap<IPersistentVector, Method>();
            HashMap covariants = new HashMap();
            Iterator i$ = allm.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry e2 = o = i$.next();
                IPersistentVector mk = (IPersistentVector)e2.getKey();
                mk = (IPersistentVector)mk.pop();
                Method m = (Method)e2.getValue();
                if (mm.containsKey(mk)) {
                    Method om;
                    HashSet cvs = (HashSet)covariants.get(mk);
                    if (cvs == null) {
                        cvs = new HashSet();
                        covariants.put(mk, cvs);
                    }
                    if ((om = (Method)mm.get(mk)).getReturnType().isAssignableFrom(m.getReturnType())) {
                        cvs.add(om.getReturnType());
                        mm.put(mk, m);
                        continue;
                    }
                    cvs.add(m.getReturnType());
                    continue;
                }
                mm.put(mk, m);
            }
            return new Map[]{mm, covariants};
        }

        static class ReifyParser
        implements IParser {
            ReifyParser() {
            }

            public Expr parse(C context, Object frm) throws Exception {
                ISeq form = (ISeq)frm;
                ObjMethod enclosingMethod = (ObjMethod)METHOD.deref();
                String basename = enclosingMethod != null ? ObjExpr.trimGenID(enclosingMethod.objx.name) + "$" : Compiler.munge(Compiler.currentNS().name.name) + "$";
                String simpleName = "reify__" + RT.nextID();
                String classname = basename + simpleName;
                ISeq rform = RT.next(form);
                IPersistentVector interfaces = ((IPersistentVector)RT.first(rform)).cons(Symbol.intern("clojure.lang.IObj"));
                rform = RT.next(rform);
                ObjExpr ret = NewInstanceExpr.build(interfaces, null, null, classname, Symbol.intern(classname), null, rform, frm);
                if (frm instanceof IObj && ((IObj)frm).meta() != null) {
                    return new MetaExpr(ret, (MapExpr)MapExpr.parse(context == C.EVAL ? context : C.EXPRESSION, ((IObj)frm).meta()));
                }
                return ret;
            }
        }

        static class DeftypeParser
        implements IParser {
            DeftypeParser() {
            }

            public Expr parse(C context, Object frm) throws Exception {
                ISeq rform = (ISeq)frm;
                rform = RT.next(rform);
                String tagname = ((Symbol)rform.first()).toString();
                rform = rform.next();
                Symbol classname = (Symbol)rform.first();
                rform = rform.next();
                IPersistentVector fields = (IPersistentVector)rform.first();
                rform = rform.next();
                IPersistentMap opts = PersistentHashMap.EMPTY;
                while (rform != null && rform.first() instanceof Keyword) {
                    opts = opts.assoc(rform.first(), RT.second(rform));
                    rform = rform.next().next();
                }
                ObjExpr ret = NewInstanceExpr.build((IPersistentVector)RT.get(opts, implementsKey, PersistentVector.EMPTY), fields, null, tagname, classname, (Symbol)RT.get(opts, RT.TAG_KEY), rform, frm);
                return ret;
            }
        }
    }

    public static class CompilerException
    extends Exception {
        public CompilerException(String source2, int line, Throwable cause) {
            super(Compiler.errorMsg(source2, line, cause.toString()), cause);
        }

        public String toString() {
            return this.getMessage();
        }
    }

    public static class RecurExpr
    implements Expr {
        public final IPersistentVector args;
        public final IPersistentVector loopLocals;

        public RecurExpr(IPersistentVector loopLocals, IPersistentVector args) {
            this.loopLocals = loopLocals;
            this.args = args;
        }

        public Object eval() throws Exception {
            throw new UnsupportedOperationException("Can't eval recur");
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            LocalBinding lb;
            int i;
            Label loopLabel = (Label)LOOP_LABEL.deref();
            if (loopLabel == null) {
                throw new IllegalStateException();
            }
            for (i = 0; i < this.loopLocals.count(); ++i) {
                lb = (LocalBinding)this.loopLocals.nth(i);
                Expr arg = (Expr)this.args.nth(i);
                if (lb.getPrimitiveType() != null) {
                    Class primc = lb.getPrimitiveType();
                    try {
                        if (!(arg instanceof MaybePrimitiveExpr) || !arg.hasJavaClass() || arg.getJavaClass() != primc) {
                            throw new IllegalArgumentException("recur arg for primitive local: " + lb.name + " must be matching primitive");
                        }
                    }
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                    ((MaybePrimitiveExpr)arg).emitUnboxed(C.EXPRESSION, objx, gen);
                    continue;
                }
                arg.emit(C.EXPRESSION, objx, gen);
            }
            for (i = this.loopLocals.count() - 1; i >= 0; --i) {
                lb = (LocalBinding)this.loopLocals.nth(i);
                Class primc = lb.getPrimitiveType();
                if (lb.isArg) {
                    gen.storeArg(lb.idx - 1);
                    continue;
                }
                if (primc != null) {
                    gen.visitVarInsn(Type.getType(primc).getOpcode(54), lb.idx);
                    continue;
                }
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), lb.idx);
            }
            gen.goTo(loopLabel);
        }

        public boolean hasJavaClass() throws Exception {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return null;
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object frm) throws Exception {
                ISeq form = (ISeq)frm;
                IPersistentVector loopLocals = (IPersistentVector)LOOP_LOCALS.deref();
                if (context != C.RETURN || loopLocals == null) {
                    throw new UnsupportedOperationException("Can only recur from tail position");
                }
                if (IN_CATCH_FINALLY.deref() != null) {
                    throw new UnsupportedOperationException("Cannot recur from catch/finally");
                }
                PersistentVector args = PersistentVector.EMPTY;
                for (ISeq s = RT.seq(form.next()); s != null; s = s.next()) {
                    args = args.cons(Compiler.analyze(C.EXPRESSION, s.first()));
                }
                if (args.count() != loopLocals.count()) {
                    throw new IllegalArgumentException(String.format("Mismatched argument count to recur, expected: %d args, got: %d", loopLocals.count(), args.count()));
                }
                return new RecurExpr(loopLocals, args);
            }
        }
    }

    public static class LetExpr
    implements Expr,
    MaybePrimitiveExpr {
        public final PersistentVector bindingInits;
        public final Expr body;
        public final boolean isLoop;

        public LetExpr(PersistentVector bindingInits, Expr body, boolean isLoop) {
            this.bindingInits = bindingInits;
            this.body = body;
            this.isLoop = isLoop;
        }

        public Object eval() throws Exception {
            throw new UnsupportedOperationException("Can't eval let/loop");
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.doEmit(context, objx, gen, false);
        }

        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.doEmit(context, objx, gen, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doEmit(C context, ObjExpr objx, GeneratorAdapter gen, boolean emitUnboxed) {
            for (int i = 0; i < this.bindingInits.count(); ++i) {
                BindingInit bi = (BindingInit)this.bindingInits.nth(i);
                Class primc = Compiler.maybePrimitiveType(bi.init);
                if (primc != null) {
                    ((MaybePrimitiveExpr)bi.init).emitUnboxed(C.EXPRESSION, objx, gen);
                    gen.visitVarInsn(Type.getType(primc).getOpcode(54), bi.binding.idx);
                    continue;
                }
                bi.init.emit(C.EXPRESSION, objx, gen);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), bi.binding.idx);
            }
            Label loopLabel = gen.mark();
            if (this.isLoop) {
                try {
                    Var.pushThreadBindings(RT.map(LOOP_LABEL, loopLabel));
                    if (emitUnboxed) {
                        ((MaybePrimitiveExpr)this.body).emitUnboxed(context, objx, gen);
                    }
                    this.body.emit(context, objx, gen);
                }
                finally {
                    Var.popThreadBindings();
                }
            } else if (emitUnboxed) {
                ((MaybePrimitiveExpr)this.body).emitUnboxed(context, objx, gen);
            } else {
                this.body.emit(context, objx, gen);
            }
            Label end = gen.mark();
            for (ISeq bis = this.bindingInits.seq(); bis != null; bis = bis.next()) {
                Class primc;
                BindingInit bi = (BindingInit)bis.first();
                String lname = bi.binding.name;
                if (lname.endsWith("__auto__")) {
                    lname = lname + RT.nextID();
                }
                if ((primc = Compiler.maybePrimitiveType(bi.init)) != null) {
                    gen.visitLocalVariable(lname, Type.getDescriptor(primc), null, loopLabel, end, bi.binding.idx);
                    continue;
                }
                gen.visitLocalVariable(lname, "Ljava/lang/Object;", null, loopLabel, end, bi.binding.idx);
            }
        }

        public boolean hasJavaClass() throws Exception {
            return this.body.hasJavaClass();
        }

        public Class getJavaClass() throws Exception {
            return this.body.getJavaClass();
        }

        public boolean canEmitPrimitive() {
            return this.body instanceof MaybePrimitiveExpr && ((MaybePrimitiveExpr)this.body).canEmitPrimitive();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Expr parse(C context, Object frm) throws Exception {
                ISeq form = (ISeq)frm;
                boolean isLoop = RT.first(form).equals(LOOP);
                if (!(RT.second(form) instanceof IPersistentVector)) {
                    throw new IllegalArgumentException("Bad binding form, expected vector");
                }
                IPersistentVector bindings = (IPersistentVector)RT.second(form);
                if (bindings.count() % 2 != 0) {
                    throw new IllegalArgumentException("Bad binding form, expected matched symbol expression pairs");
                }
                ISeq body = RT.next(RT.next(form));
                if (context == C.EVAL || context == C.EXPRESSION && isLoop) {
                    return Compiler.analyze(context, RT.list(RT.list(FN, PersistentVector.EMPTY, form)));
                }
                IPersistentMap dynamicBindings = RT.map(LOCAL_ENV, LOCAL_ENV.deref(), NEXT_LOCAL_NUM, NEXT_LOCAL_NUM.deref());
                if (isLoop) {
                    dynamicBindings = dynamicBindings.assoc(LOOP_LOCALS, null);
                }
                try {
                    Expr bodyExpr;
                    Var.pushThreadBindings(dynamicBindings);
                    PersistentVector bindingInits = PersistentVector.EMPTY;
                    PersistentVector loopLocals = PersistentVector.EMPTY;
                    for (int i = 0; i < bindings.count(); i += 2) {
                        if (!(bindings.nth(i) instanceof Symbol)) {
                            throw new IllegalArgumentException("Bad binding form, expected symbol, got: " + bindings.nth(i));
                        }
                        Symbol sym = (Symbol)bindings.nth(i);
                        if (sym.getNamespace() != null) {
                            throw new Exception("Can't let qualified name: " + sym);
                        }
                        Expr init = Compiler.analyze(C.EXPRESSION, bindings.nth(i + 1), sym.name);
                        LocalBinding lb = Compiler.registerLocal(sym, Compiler.tagOf(sym), init, false);
                        BindingInit bi = new BindingInit(lb, init);
                        bindingInits = bindingInits.cons(bi);
                        if (!isLoop) continue;
                        loopLocals = loopLocals.cons(lb);
                    }
                    if (isLoop) {
                        LOOP_LOCALS.set(loopLocals);
                    }
                    try {
                        if (isLoop) {
                            PathNode root2 = new PathNode(PATHTYPE.PATH, (PathNode)CLEAR_PATH.get());
                            Var.pushThreadBindings(RT.map(CLEAR_PATH, new PathNode(PATHTYPE.PATH, root2), CLEAR_ROOT, new PathNode(PATHTYPE.PATH, root2)));
                        }
                        bodyExpr = new BodyExpr.Parser().parse(isLoop ? C.RETURN : context, body);
                    }
                    finally {
                        if (isLoop) {
                            Var.popThreadBindings();
                        }
                    }
                    LetExpr letExpr = new LetExpr(bindingInits, bodyExpr, isLoop);
                    return letExpr;
                }
                finally {
                    Var.popThreadBindings();
                }
            }
        }
    }

    public static class LetFnExpr
    implements Expr {
        public final PersistentVector bindingInits;
        public final Expr body;

        public LetFnExpr(PersistentVector bindingInits, Expr body) {
            this.bindingInits = bindingInits;
            this.body = body;
        }

        public Object eval() throws Exception {
            throw new UnsupportedOperationException("Can't eval letfns");
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            BindingInit bi;
            int i;
            for (int i2 = 0; i2 < this.bindingInits.count(); ++i2) {
                BindingInit bi2 = (BindingInit)this.bindingInits.nth(i2);
                gen.visitInsn(1);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), bi2.binding.idx);
            }
            IPersistentSet lbset = PersistentHashSet.EMPTY;
            for (i = 0; i < this.bindingInits.count(); ++i) {
                bi = (BindingInit)this.bindingInits.nth(i);
                lbset = (IPersistentSet)lbset.cons(bi.binding);
                bi.init.emit(C.EXPRESSION, objx, gen);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), bi.binding.idx);
            }
            for (i = 0; i < this.bindingInits.count(); ++i) {
                bi = (BindingInit)this.bindingInits.nth(i);
                ObjExpr fe = (ObjExpr)bi.init;
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(21), bi.binding.idx);
                fe.emitLetFnInits(gen, objx, lbset);
            }
            Label loopLabel = gen.mark();
            this.body.emit(context, objx, gen);
            Label end = gen.mark();
            for (ISeq bis = this.bindingInits.seq(); bis != null; bis = bis.next()) {
                Class primc;
                BindingInit bi3 = (BindingInit)bis.first();
                String lname = bi3.binding.name;
                if (lname.endsWith("__auto__")) {
                    lname = lname + RT.nextID();
                }
                if ((primc = Compiler.maybePrimitiveType(bi3.init)) != null) {
                    gen.visitLocalVariable(lname, Type.getDescriptor(primc), null, loopLabel, end, bi3.binding.idx);
                    continue;
                }
                gen.visitLocalVariable(lname, "Ljava/lang/Object;", null, loopLabel, end, bi3.binding.idx);
            }
        }

        public boolean hasJavaClass() throws Exception {
            return this.body.hasJavaClass();
        }

        public Class getJavaClass() throws Exception {
            return this.body.getJavaClass();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Expr parse(C context, Object frm) throws Exception {
                ISeq form = (ISeq)frm;
                if (!(RT.second(form) instanceof IPersistentVector)) {
                    throw new IllegalArgumentException("Bad binding form, expected vector");
                }
                IPersistentVector bindings = (IPersistentVector)RT.second(form);
                if (bindings.count() % 2 != 0) {
                    throw new IllegalArgumentException("Bad binding form, expected matched symbol expression pairs");
                }
                ISeq body = RT.next(RT.next(form));
                if (context == C.EVAL) {
                    return Compiler.analyze(context, RT.list(RT.list(FN, PersistentVector.EMPTY, form)));
                }
                IPersistentMap dynamicBindings = RT.map(LOCAL_ENV, LOCAL_ENV.deref(), NEXT_LOCAL_NUM, NEXT_LOCAL_NUM.deref());
                try {
                    Var.pushThreadBindings(dynamicBindings);
                    PersistentVector lbs = PersistentVector.EMPTY;
                    for (int i = 0; i < bindings.count(); i += 2) {
                        if (!(bindings.nth(i) instanceof Symbol)) {
                            throw new IllegalArgumentException("Bad binding form, expected symbol, got: " + bindings.nth(i));
                        }
                        Symbol sym = (Symbol)bindings.nth(i);
                        if (sym.getNamespace() != null) {
                            throw new Exception("Can't let qualified name: " + sym);
                        }
                        LocalBinding lb = Compiler.registerLocal(sym, Compiler.tagOf(sym), null, false);
                        lb.canBeCleared = false;
                        lbs = lbs.cons(lb);
                    }
                    PersistentVector bindingInits = PersistentVector.EMPTY;
                    for (int i = 0; i < bindings.count(); i += 2) {
                        Symbol sym = (Symbol)bindings.nth(i);
                        Expr init = Compiler.analyze(C.EXPRESSION, bindings.nth(i + 1), sym.name);
                        LocalBinding lb = (LocalBinding)lbs.nth(i / 2);
                        lb.init = init;
                        BindingInit bi = new BindingInit(lb, init);
                        bindingInits = bindingInits.cons(bi);
                    }
                    LetFnExpr letFnExpr = new LetFnExpr(bindingInits, new BodyExpr.Parser().parse(context, body));
                    return letFnExpr;
                }
                finally {
                    Var.popThreadBindings();
                }
            }
        }
    }

    public static class BindingInit {
        LocalBinding binding;
        Expr init;

        public final LocalBinding binding() {
            return this.binding;
        }

        public final Expr init() {
            return this.init;
        }

        public BindingInit(LocalBinding binding2, Expr init) {
            this.binding = binding2;
            this.init = init;
        }
    }

    public static class BodyExpr
    implements Expr,
    MaybePrimitiveExpr {
        PersistentVector exprs;

        public final PersistentVector exprs() {
            return this.exprs;
        }

        public BodyExpr(PersistentVector exprs) {
            this.exprs = exprs;
        }

        public Object eval() throws Exception {
            Object ret = null;
            for (Object o : this.exprs) {
                Expr e2 = (Expr)o;
                ret = e2.eval();
            }
            return ret;
        }

        public boolean canEmitPrimitive() {
            return this.lastExpr() instanceof MaybePrimitiveExpr && ((MaybePrimitiveExpr)this.lastExpr()).canEmitPrimitive();
        }

        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            for (int i = 0; i < this.exprs.count() - 1; ++i) {
                Expr e2 = (Expr)this.exprs.nth(i);
                e2.emit(C.STATEMENT, objx, gen);
            }
            MaybePrimitiveExpr last2 = (MaybePrimitiveExpr)this.exprs.nth(this.exprs.count() - 1);
            last2.emitUnboxed(context, objx, gen);
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            for (int i = 0; i < this.exprs.count() - 1; ++i) {
                Expr e2 = (Expr)this.exprs.nth(i);
                e2.emit(C.STATEMENT, objx, gen);
            }
            Expr last2 = (Expr)this.exprs.nth(this.exprs.count() - 1);
            last2.emit(context, objx, gen);
        }

        public boolean hasJavaClass() throws Exception {
            return this.lastExpr().hasJavaClass();
        }

        public Class getJavaClass() throws Exception {
            return this.lastExpr().getJavaClass();
        }

        private Expr lastExpr() {
            return (Expr)this.exprs.nth(this.exprs.count() - 1);
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object frms) throws Exception {
                ISeq forms = (ISeq)frms;
                if (Util.equals(RT.first(forms), DO)) {
                    forms = RT.next(forms);
                }
                PersistentVector exprs = PersistentVector.EMPTY;
                while (forms != null) {
                    Expr e2 = context != C.EVAL && (context == C.STATEMENT || forms.next() != null) ? Compiler.analyze(C.STATEMENT, forms.first()) : Compiler.analyze(context, forms.first());
                    exprs = exprs.cons(e2);
                    forms = forms.next();
                }
                if (exprs.count() == 0) {
                    exprs = exprs.cons(NIL_EXPR);
                }
                return new BodyExpr(exprs);
            }
        }
    }

    public static class LocalBindingExpr
    implements Expr,
    MaybePrimitiveExpr,
    AssignableExpr {
        public final LocalBinding b;
        public final Symbol tag;
        public final PathNode clearPath;
        public final PathNode clearRoot;
        public boolean shouldClear = false;

        public LocalBindingExpr(LocalBinding b, Symbol tag) throws Exception {
            if (b.getPrimitiveType() != null && tag != null) {
                throw new UnsupportedOperationException("Can't type hint a primitive local");
            }
            this.b = b;
            this.tag = tag;
            this.clearPath = (PathNode)CLEAR_PATH.get();
            this.clearRoot = (PathNode)CLEAR_ROOT.get();
            IPersistentCollection sites = (IPersistentCollection)RT.get(CLEAR_SITES.get(), b);
            if (b.idx > 0) {
                if (sites != null) {
                    for (ISeq s = sites.seq(); s != null; s = s.next()) {
                        LocalBindingExpr o = (LocalBindingExpr)s.first();
                        PathNode common = Compiler.commonPath(this.clearPath, o.clearPath);
                        if (common == null || common.type != PATHTYPE.PATH) continue;
                        o.shouldClear = false;
                    }
                }
                if (this.clearRoot == b.clearPathRoot) {
                    this.shouldClear = true;
                    sites = RT.conj(sites, this);
                    CLEAR_SITES.set(RT.assoc(CLEAR_SITES.get(), b, sites));
                }
            }
        }

        public Object eval() throws Exception {
            throw new UnsupportedOperationException("Can't eval locals");
        }

        public boolean canEmitPrimitive() {
            return this.b.getPrimitiveType() != null;
        }

        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            objx.emitUnboxedLocal(gen, this.b);
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (context != C.STATEMENT) {
                objx.emitLocal(gen, this.b, this.shouldClear);
            }
        }

        public Object evalAssign(Expr val2) throws Exception {
            throw new UnsupportedOperationException("Can't eval locals");
        }

        public void emitAssign(C context, ObjExpr objx, GeneratorAdapter gen, Expr val2) {
            objx.emitAssignLocal(gen, this.b, val2);
            if (context != C.STATEMENT) {
                objx.emitLocal(gen, this.b, false);
            }
        }

        public boolean hasJavaClass() throws Exception {
            return this.tag != null || this.b.hasJavaClass();
        }

        public Class getJavaClass() throws Exception {
            if (this.tag != null) {
                return HostExpr.tagToClass(this.tag);
            }
            return this.b.getJavaClass();
        }
    }

    public static class LocalBinding {
        public final Symbol sym;
        public final Symbol tag;
        public Expr init;
        public final int idx;
        public final String name;
        public final boolean isArg;
        public final PathNode clearPathRoot;
        public boolean canBeCleared = true;

        public LocalBinding(int num2, Symbol sym, Symbol tag, Expr init, boolean isArg, PathNode clearPathRoot) throws Exception {
            if (Compiler.maybePrimitiveType(init) != null && tag != null) {
                throw new UnsupportedOperationException("Can't type hint a local with a primitive initializer");
            }
            this.idx = num2;
            this.sym = sym;
            this.tag = tag;
            this.init = init;
            this.isArg = isArg;
            this.clearPathRoot = clearPathRoot;
            this.name = Compiler.munge(sym.name);
        }

        public boolean hasJavaClass() throws Exception {
            if (this.init != null && this.init.hasJavaClass() && Util.isPrimitive(this.init.getJavaClass()) && !(this.init instanceof MaybePrimitiveExpr)) {
                return false;
            }
            return this.tag != null || this.init != null && this.init.hasJavaClass();
        }

        public Class getJavaClass() throws Exception {
            return this.tag != null ? HostExpr.tagToClass(this.tag) : this.init.getJavaClass();
        }

        public Class getPrimitiveType() {
            return Compiler.maybePrimitiveType(this.init);
        }
    }

    public static abstract class ObjMethod {
        public final ObjMethod parent;
        IPersistentMap locals = null;
        IPersistentMap indexlocals = null;
        Expr body = null;
        ObjExpr objx;
        PersistentVector argLocals;
        int maxLocal = 0;
        int line;
        PersistentHashSet localsUsedInCatchFinally = PersistentHashSet.EMPTY;
        protected IPersistentMap methodMeta;

        public final IPersistentMap locals() {
            return this.locals;
        }

        public final Expr body() {
            return this.body;
        }

        public final ObjExpr objx() {
            return this.objx;
        }

        public final PersistentVector argLocals() {
            return this.argLocals;
        }

        public final int maxLocal() {
            return this.maxLocal;
        }

        public final int line() {
            return this.line;
        }

        public ObjMethod(ObjExpr objx, ObjMethod parent) {
            this.parent = parent;
            this.objx = objx;
        }

        abstract int numParams();

        abstract String getMethodName();

        abstract Type getReturnType();

        abstract Type[] getArgTypes();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void emit(ObjExpr fn2, ClassVisitor cv) {
            clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.getMethodName(), this.getReturnType(), this.getArgTypes());
            GeneratorAdapter gen = new GeneratorAdapter(1, m, null, EXCEPTION_TYPES, cv);
            gen.visitCode();
            Label loopLabel = gen.mark();
            gen.visitLineNumber(this.line, loopLabel);
            try {
                Var.pushThreadBindings(RT.map(LOOP_LABEL, loopLabel, METHOD, this));
                this.body.emit(C.RETURN, fn2, gen);
                Label end = gen.mark();
                gen.visitLocalVariable("this", "Ljava/lang/Object;", null, loopLabel, end, 0);
                for (ISeq lbs = this.argLocals.seq(); lbs != null; lbs = lbs.next()) {
                    LocalBinding lb = (LocalBinding)lbs.first();
                    gen.visitLocalVariable(lb.name, "Ljava/lang/Object;", null, loopLabel, end, lb.idx);
                }
            }
            finally {
                Var.popThreadBindings();
            }
            gen.returnValue();
            gen.endMethod();
        }

        void emitClearLocals(GeneratorAdapter gen) {
        }

        void emitClearLocalsOld(GeneratorAdapter gen) {
            int i;
            for (i = 0; i < this.argLocals.count(); ++i) {
                LocalBinding lb = (LocalBinding)this.argLocals.nth(i);
                if (this.localsUsedInCatchFinally.contains(lb.idx) || lb.getPrimitiveType() != null) continue;
                gen.visitInsn(1);
                gen.storeArg(lb.idx - 1);
            }
            for (i = this.numParams() + 1; i < this.maxLocal + 1; ++i) {
                LocalBinding b;
                if (this.localsUsedInCatchFinally.contains(i) || (b = (LocalBinding)RT.get(this.indexlocals, i)) != null && Compiler.maybePrimitiveType(b.init) != null) continue;
                gen.visitInsn(1);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), i);
            }
        }
    }

    public static class FnMethod
    extends ObjMethod {
        PersistentVector reqParms = PersistentVector.EMPTY;
        LocalBinding restParm = null;

        public FnMethod(ObjExpr objx, ObjMethod parent) {
            super(objx, parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static FnMethod parse(ObjExpr objx, ISeq form) throws Exception {
            IPersistentVector parms = (IPersistentVector)RT.first(form);
            ISeq body = RT.next(form);
            try {
                FnMethod method = new FnMethod(objx, (ObjMethod)METHOD.deref());
                method.line = (Integer)LINE.deref();
                PathNode pnode = (PathNode)CLEAR_PATH.get();
                if (pnode == null) {
                    pnode = new PathNode(PATHTYPE.PATH, null);
                }
                Var.pushThreadBindings(RT.map(METHOD, method, LOCAL_ENV, LOCAL_ENV.deref(), LOOP_LOCALS, null, NEXT_LOCAL_NUM, 0, CLEAR_PATH, pnode, CLEAR_ROOT, pnode, CLEAR_SITES, PersistentHashMap.EMPTY));
                if (objx.thisName != null) {
                    Compiler.registerLocal(Symbol.intern(objx.thisName), null, null, false);
                } else {
                    Compiler.getAndIncLocalNum();
                }
                PSTATE state = PSTATE.REQ;
                PersistentVector argLocals = PersistentVector.EMPTY;
                block7: for (int i = 0; i < parms.count(); ++i) {
                    if (!(parms.nth(i) instanceof Symbol)) {
                        throw new IllegalArgumentException("fn params must be Symbols");
                    }
                    Symbol p = (Symbol)parms.nth(i);
                    if (p.getNamespace() != null) {
                        throw new Exception("Can't use qualified name as parameter: " + p);
                    }
                    if (p.equals(_AMP_)) {
                        if (state == PSTATE.REQ) {
                            state = PSTATE.REST;
                            continue;
                        }
                        throw new Exception("Invalid parameter list");
                    }
                    LocalBinding lb = Compiler.registerLocal(p, state == PSTATE.REST ? ISEQ : Compiler.tagOf(p), null, true);
                    argLocals = argLocals.cons(lb);
                    switch (state) {
                        case REQ: {
                            method.reqParms = method.reqParms.cons(lb);
                            continue block7;
                        }
                        case REST: {
                            method.restParm = lb;
                            state = PSTATE.DONE;
                            continue block7;
                        }
                        default: {
                            throw new Exception("Unexpected parameter");
                        }
                    }
                }
                if (method.reqParms.count() > 20) {
                    throw new Exception("Can't specify more than 20 params");
                }
                LOOP_LOCALS.set(argLocals);
                method.argLocals = argLocals;
                method.body = new BodyExpr.Parser().parse(C.RETURN, body);
                FnMethod fnMethod = method;
                return fnMethod;
            }
            finally {
                Var.popThreadBindings();
            }
        }

        public final PersistentVector reqParms() {
            return this.reqParms;
        }

        public final LocalBinding restParm() {
            return this.restParm;
        }

        boolean isVariadic() {
            return this.restParm != null;
        }

        int numParams() {
            return this.reqParms.count() + (this.isVariadic() ? 1 : 0);
        }

        String getMethodName() {
            return this.isVariadic() ? "doInvoke" : "invoke";
        }

        Type getReturnType() {
            return OBJECT_TYPE;
        }

        Type[] getArgTypes() {
            if (this.isVariadic() && this.reqParms.count() == 20) {
                Type[] ret = new Type[21];
                for (int i = 0; i < 21; ++i) {
                    ret[i] = OBJECT_TYPE;
                }
                return ret;
            }
            return ARG_TYPES[this.numParams()];
        }

        void emitClearLocals(GeneratorAdapter gen) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PSTATE {
        REQ,
        REST,
        DONE;

    }

    static class PathNode {
        final PATHTYPE type;
        final PathNode parent;

        PathNode(PATHTYPE type2, PathNode parent) {
            this.type = type2;
            this.parent = parent;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PATHTYPE {
        PATH,
        BRANCH;

    }

    public static class ObjExpr
    implements Expr {
        static final String CONST_PREFIX = "const__";
        String name;
        String internalName;
        String thisName;
        Type objtype;
        public final Object tag;
        IPersistentMap closes = PersistentHashMap.EMPTY;
        IPersistentVector closesExprs = PersistentVector.EMPTY;
        IPersistentSet volatiles = PersistentHashSet.EMPTY;
        IPersistentMap fields = null;
        IPersistentMap keywords = PersistentHashMap.EMPTY;
        IPersistentMap vars = PersistentHashMap.EMPTY;
        Class compiledClass;
        int line;
        PersistentVector constants;
        int constantsID;
        int altCtorDrops = 0;
        IPersistentVector keywordCallsites;
        IPersistentVector protocolCallsites;
        IPersistentVector varCallsites;
        boolean onceOnly = false;
        Object src;
        static final clojure.asm.commons.Method voidctor = clojure.asm.commons.Method.getMethod("void <init>()");
        protected IPersistentMap classMeta;
        static final clojure.asm.commons.Method kwintern = clojure.asm.commons.Method.getMethod("clojure.lang.Keyword intern(String, String)");
        static final clojure.asm.commons.Method symcreate = clojure.asm.commons.Method.getMethod("clojure.lang.Symbol create(String)");
        static final clojure.asm.commons.Method varintern = clojure.asm.commons.Method.getMethod("clojure.lang.Var intern(clojure.lang.Symbol, clojure.lang.Symbol)");
        static final Type DYNAMIC_CLASSLOADER_TYPE = Type.getType(DynamicClassLoader.class);
        static final clojure.asm.commons.Method getClassMethod = clojure.asm.commons.Method.getMethod("Class getClass()");
        static final clojure.asm.commons.Method getClassLoaderMethod = clojure.asm.commons.Method.getMethod("ClassLoader getClassLoader()");
        static final clojure.asm.commons.Method getConstantsMethod = clojure.asm.commons.Method.getMethod("Object[] getConstants(int)");
        static final clojure.asm.commons.Method readStringMethod = clojure.asm.commons.Method.getMethod("Object readString(String)");
        static final Type ILOOKUP_SITE_TYPE = Type.getType(ILookupSite.class);
        static final Type ILOOKUP_THUNK_TYPE = Type.getType(ILookupThunk.class);
        static final Type KEYWORD_LOOKUPSITE_TYPE = Type.getType(KeywordLookupSite.class);
        private DynamicClassLoader loader;
        private byte[] bytecode;

        public final String name() {
            return this.name;
        }

        public final String internalName() {
            return this.internalName;
        }

        public final String thisName() {
            return this.thisName;
        }

        public final Type objtype() {
            return this.objtype;
        }

        public final IPersistentMap closes() {
            return this.closes;
        }

        public final IPersistentMap keywords() {
            return this.keywords;
        }

        public final IPersistentMap vars() {
            return this.vars;
        }

        public final Class compiledClass() {
            return this.compiledClass;
        }

        public final int line() {
            return this.line;
        }

        public final PersistentVector constants() {
            return this.constants;
        }

        public final int constantsID() {
            return this.constantsID;
        }

        public ObjExpr(Object tag) {
            this.tag = tag;
        }

        static String trimGenID(String name2) {
            int i = name2.lastIndexOf("__");
            return i == -1 ? name2 : name2.substring(0, i);
        }

        Type[] ctorTypes() {
            IPersistentVector tv = this.isDeftype() ? PersistentVector.EMPTY : RT.vector(IPERSISTENTMAP_TYPE);
            for (ISeq s = RT.keys(this.closes); s != null; s = s.next()) {
                LocalBinding lb = (LocalBinding)s.first();
                tv = lb.getPrimitiveType() != null ? tv.cons(Type.getType(lb.getPrimitiveType())) : tv.cons(OBJECT_TYPE);
            }
            Type[] ret = new Type[tv.count()];
            for (int i = 0; i < tv.count(); ++i) {
                ret[i] = (Type)tv.nth(i);
            }
            return ret;
        }

        void compile(String superName, String[] interfaceNames, boolean oneTimeUse) throws Exception {
            clojure.asm.commons.Method alt;
            Type[] ctorTypes;
            int i;
            ClassWriter cw;
            if (this.keywordCallsites.count() > 0) {
                if (interfaceNames == null) {
                    interfaceNames = new String[]{"clojure/lang/ILookupHost"};
                } else {
                    String[] inames = new String[interfaceNames.length + 1];
                    System.arraycopy(interfaceNames, 0, inames, 0, interfaceNames.length);
                    inames[interfaceNames.length] = "clojure/lang/ILookupHost";
                    interfaceNames = inames;
                }
            }
            ClassWriter cv = cw = new ClassWriter(1);
            cv.visit(49, 49, this.internalName, null, superName, interfaceNames);
            String source2 = (String)SOURCE.deref();
            int lineBefore = (Integer)LINE_BEFORE.deref();
            int lineAfter = (Integer)LINE_AFTER.deref() + 1;
            if (source2 != null && SOURCE_PATH.deref() != null) {
                String smap = "SMAP\n" + (source2.lastIndexOf(46) > 0 ? source2.substring(0, source2.lastIndexOf(46)) : source2) + ".java\n" + "Clojure\n" + "*S Clojure\n" + "*F\n" + "+ 1 " + source2 + "\n" + (String)SOURCE_PATH.deref() + "\n" + "*L\n" + String.format("%d#1,%d:%d\n", lineBefore, lineAfter - lineBefore, lineBefore) + "*E";
                cv.visitSource(source2, smap);
            }
            Compiler.addAnnotation(cv, this.classMeta);
            for (i = 0; i < this.constants.count(); ++i) {
                cv.visitField(25, this.constantName(i), this.constantType(i).getDescriptor(), null, null);
            }
            for (i = 0; i < this.keywordCallsites.count(); ++i) {
                cv.visitField(24, this.siteNameStatic(i), KEYWORD_LOOKUPSITE_TYPE.getDescriptor(), null, null);
                cv.visitField(8, this.thunkNameStatic(i), ILOOKUP_THUNK_TYPE.getDescriptor(), null, null);
            }
            for (i = 0; i < this.varCallsites.count(); ++i) {
                cv.visitField(26, this.varCallsiteName(i), IFN_TYPE.getDescriptor(), null, null);
            }
            GeneratorAdapter clinitgen = new GeneratorAdapter(9, clojure.asm.commons.Method.getMethod("void <clinit> ()"), null, null, cv);
            clinitgen.visitCode();
            clinitgen.visitLineNumber(this.line, clinitgen.mark());
            if (this.constants.count() > 0) {
                this.emitConstants(clinitgen);
            }
            if (this.keywordCallsites.count() > 0) {
                this.emitKeywordCallsites(clinitgen);
            }
            for (int i2 = 0; i2 < this.varCallsites.count(); ++i2) {
                Label skipLabel = clinitgen.newLabel();
                Label endLabel = clinitgen.newLabel();
                Var var = (Var)this.varCallsites.nth(i2);
                clinitgen.push(var.ns.name.toString());
                clinitgen.push(var.sym.toString());
                clinitgen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.Var var(String,String)"));
                clinitgen.dup();
                clinitgen.invokeVirtual(VAR_TYPE, clojure.asm.commons.Method.getMethod("boolean hasRoot()"));
                clinitgen.ifZCmp(153, skipLabel);
                clinitgen.invokeVirtual(VAR_TYPE, clojure.asm.commons.Method.getMethod("Object getRoot()"));
                clinitgen.dup();
                clinitgen.instanceOf(AFUNCTION_TYPE);
                clinitgen.ifZCmp(153, skipLabel);
                clinitgen.checkCast(IFN_TYPE);
                clinitgen.putStatic(this.objtype, this.varCallsiteName(i2), IFN_TYPE);
                clinitgen.goTo(endLabel);
                clinitgen.mark(skipLabel);
                clinitgen.pop();
                clinitgen.mark(endLabel);
            }
            clinitgen.returnValue();
            clinitgen.endMethod();
            if (!this.isDeftype()) {
                cv.visitField(16, "__meta", IPERSISTENTMAP_TYPE.getDescriptor(), null, null);
            }
            for (ISeq s = RT.keys(this.closes); s != null; s = s.next()) {
                LocalBinding lb = (LocalBinding)s.first();
                if (this.isDeftype()) {
                    int access = this.isVolatile(lb) ? 64 : (this.isMutable(lb) ? 0 : 17);
                    FieldVisitor fv = lb.getPrimitiveType() != null ? cv.visitField(access, lb.name, Type.getType(lb.getPrimitiveType()).getDescriptor(), null, null) : cv.visitField(access, lb.name, OBJECT_TYPE.getDescriptor(), null, null);
                    Compiler.addAnnotation(fv, RT.meta(lb.sym));
                    continue;
                }
                if (lb.getPrimitiveType() != null) {
                    cv.visitField(0 + (this.isVolatile(lb) ? 64 : 0), lb.name, Type.getType(lb.getPrimitiveType()).getDescriptor(), null, null);
                    continue;
                }
                cv.visitField(0, lb.name, OBJECT_TYPE.getDescriptor(), null, null);
            }
            for (int i3 = 0; i3 < this.protocolCallsites.count(); ++i3) {
                cv.visitField(2, this.cachedClassName(i3), CLASS_TYPE.getDescriptor(), null, null);
                cv.visitField(2, this.cachedProtoFnName(i3), AFUNCTION_TYPE.getDescriptor(), null, null);
                cv.visitField(2, this.cachedProtoImplName(i3), IFN_TYPE.getDescriptor(), null, null);
            }
            clojure.asm.commons.Method m = new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, this.ctorTypes());
            GeneratorAdapter ctorgen = new GeneratorAdapter(1, m, null, null, cv);
            Label start = ctorgen.newLabel();
            Label end = ctorgen.newLabel();
            ctorgen.visitCode();
            ctorgen.visitLineNumber(this.line, ctorgen.mark());
            ctorgen.visitLabel(start);
            ctorgen.loadThis();
            ctorgen.invokeConstructor(Type.getObjectType(superName), voidctor);
            if (!this.isDeftype()) {
                ctorgen.loadThis();
                ctorgen.visitVarInsn(IPERSISTENTMAP_TYPE.getOpcode(21), 1);
                ctorgen.putField(this.objtype, "__meta", IPERSISTENTMAP_TYPE);
            }
            int a = this.isDeftype() ? 1 : 2;
            ISeq s = RT.keys(this.closes);
            while (s != null) {
                LocalBinding lb = (LocalBinding)s.first();
                ctorgen.loadThis();
                Class primc = lb.getPrimitiveType();
                if (primc != null) {
                    ctorgen.visitVarInsn(Type.getType(primc).getOpcode(21), a);
                    ctorgen.putField(this.objtype, lb.name, Type.getType(primc));
                    if (primc == Long.TYPE || primc == Double.TYPE) {
                        ++a;
                    }
                } else {
                    ctorgen.visitVarInsn(OBJECT_TYPE.getOpcode(21), a);
                    ctorgen.putField(this.objtype, lb.name, OBJECT_TYPE);
                }
                this.closesExprs = this.closesExprs.cons(new LocalBindingExpr(lb, null));
                s = s.next();
                ++a;
            }
            ctorgen.visitLabel(end);
            ctorgen.returnValue();
            ctorgen.endMethod();
            if (this.altCtorDrops > 0) {
                ctorTypes = this.ctorTypes();
                Type[] altCtorTypes = new Type[ctorTypes.length - this.altCtorDrops];
                for (int i4 = 0; i4 < altCtorTypes.length; ++i4) {
                    altCtorTypes[i4] = ctorTypes[i4];
                }
                alt = new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, altCtorTypes);
                ctorgen = new GeneratorAdapter(1, alt, null, null, cv);
                ctorgen.visitCode();
                ctorgen.loadThis();
                ctorgen.loadArgs();
                for (int i5 = 0; i5 < this.altCtorDrops; ++i5) {
                    ctorgen.visitInsn(1);
                }
                ctorgen.invokeConstructor(this.objtype, new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, ctorTypes));
                ctorgen.returnValue();
                ctorgen.endMethod();
            }
            if (!this.isDeftype()) {
                ctorTypes = this.ctorTypes();
                Type[] noMetaCtorTypes = new Type[ctorTypes.length - 1];
                for (int i6 = 1; i6 < ctorTypes.length; ++i6) {
                    noMetaCtorTypes[i6 - 1] = ctorTypes[i6];
                }
                alt = new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, noMetaCtorTypes);
                ctorgen = new GeneratorAdapter(1, alt, null, null, cv);
                ctorgen.visitCode();
                ctorgen.loadThis();
                ctorgen.visitInsn(1);
                ctorgen.loadArgs();
                ctorgen.invokeConstructor(this.objtype, new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, ctorTypes));
                ctorgen.returnValue();
                ctorgen.endMethod();
                clojure.asm.commons.Method meth = clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentMap meta()");
                GeneratorAdapter gen = new GeneratorAdapter(1, meth, null, null, cv);
                gen.visitCode();
                gen.loadThis();
                gen.getField(this.objtype, "__meta", IPERSISTENTMAP_TYPE);
                gen.returnValue();
                gen.endMethod();
                meth = clojure.asm.commons.Method.getMethod("clojure.lang.IObj withMeta(clojure.lang.IPersistentMap)");
                gen = new GeneratorAdapter(1, meth, null, null, cv);
                gen.visitCode();
                gen.newInstance(this.objtype);
                gen.dup();
                gen.loadArg(0);
                ISeq s2 = RT.keys(this.closes);
                while (s2 != null) {
                    LocalBinding lb = (LocalBinding)s2.first();
                    gen.loadThis();
                    Class primc = lb.getPrimitiveType();
                    if (primc != null) {
                        gen.getField(this.objtype, lb.name, Type.getType(primc));
                    } else {
                        gen.getField(this.objtype, lb.name, OBJECT_TYPE);
                    }
                    s2 = s2.next();
                    ++a;
                }
                gen.invokeConstructor(this.objtype, new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, ctorTypes));
                gen.returnValue();
                gen.endMethod();
            }
            this.emitMethods(cv);
            if (this.keywordCallsites.count() > 0) {
                int i7;
                clojure.asm.commons.Method meth = clojure.asm.commons.Method.getMethod("void swapThunk(int,clojure.lang.ILookupThunk)");
                GeneratorAdapter gen = new GeneratorAdapter(1, meth, null, null, cv);
                gen.visitCode();
                Label endLabel = gen.newLabel();
                Label[] labels = new Label[this.keywordCallsites.count()];
                for (i7 = 0; i7 < this.keywordCallsites.count(); ++i7) {
                    labels[i7] = gen.newLabel();
                }
                gen.loadArg(0);
                gen.visitTableSwitchInsn(0, this.keywordCallsites.count() - 1, endLabel, labels);
                for (i7 = 0; i7 < this.keywordCallsites.count(); ++i7) {
                    gen.mark(labels[i7]);
                    gen.loadArg(1);
                    gen.putStatic(this.objtype, this.thunkNameStatic(i7), ILOOKUP_THUNK_TYPE);
                    gen.goTo(endLabel);
                }
                gen.mark(endLabel);
                gen.returnValue();
                gen.endMethod();
            }
            cv.visitEnd();
            this.bytecode = cw.toByteArray();
            if (RT.booleanCast(COMPILE_FILES.deref())) {
                Compiler.writeClassFile(this.internalName, this.bytecode);
            }
        }

        private void emitKeywordCallsites(GeneratorAdapter clinitgen) {
            for (int i = 0; i < this.keywordCallsites.count(); ++i) {
                Keyword k = (Keyword)this.keywordCallsites.nth(i);
                clinitgen.newInstance(KEYWORD_LOOKUPSITE_TYPE);
                clinitgen.dup();
                clinitgen.push(i);
                this.emitValue(k, clinitgen);
                clinitgen.invokeConstructor(KEYWORD_LOOKUPSITE_TYPE, clojure.asm.commons.Method.getMethod("void <init>(int,clojure.lang.Keyword)"));
                clinitgen.dup();
                clinitgen.putStatic(this.objtype, this.siteNameStatic(i), KEYWORD_LOOKUPSITE_TYPE);
                clinitgen.putStatic(this.objtype, this.thunkNameStatic(i), ILOOKUP_THUNK_TYPE);
            }
        }

        protected void emitMethods(ClassVisitor gen) {
        }

        void emitListAsObjectArray(Object value, GeneratorAdapter gen) {
            gen.push(((List)value).size());
            gen.newArray(OBJECT_TYPE);
            int i = 0;
            Iterator it = ((List)value).iterator();
            while (it.hasNext()) {
                gen.dup();
                gen.push(i);
                this.emitValue(it.next(), gen);
                gen.arrayStore(OBJECT_TYPE);
                ++i;
            }
        }

        void emitValue(Object value, GeneratorAdapter gen) {
            boolean partial2 = true;
            if (value instanceof String) {
                gen.push((String)value);
            } else if (value instanceof Integer) {
                gen.push((Integer)value);
                gen.invokeStatic(Type.getType(Integer.class), clojure.asm.commons.Method.getMethod("Integer valueOf(int)"));
            } else if (value instanceof Double) {
                gen.push((Double)value);
                gen.invokeStatic(Type.getType(Double.class), clojure.asm.commons.Method.getMethod("Double valueOf(double)"));
            } else if (value instanceof Character) {
                gen.push(((Character)value).charValue());
                gen.invokeStatic(Type.getType(Character.class), clojure.asm.commons.Method.getMethod("Character valueOf(char)"));
            } else if (value instanceof Class) {
                Class cc = (Class)value;
                if (cc.isPrimitive()) {
                    Type bt;
                    if (cc == Boolean.TYPE) {
                        bt = Type.getType(Boolean.class);
                    } else if (cc == Byte.TYPE) {
                        bt = Type.getType(Byte.class);
                    } else if (cc == Character.TYPE) {
                        bt = Type.getType(Character.class);
                    } else if (cc == Double.TYPE) {
                        bt = Type.getType(Double.class);
                    } else if (cc == Float.TYPE) {
                        bt = Type.getType(Float.class);
                    } else if (cc == Integer.TYPE) {
                        bt = Type.getType(Integer.class);
                    } else if (cc == Long.TYPE) {
                        bt = Type.getType(Long.class);
                    } else if (cc == Short.TYPE) {
                        bt = Type.getType(Short.class);
                    } else {
                        throw new RuntimeException("Can't embed unknown primitive in code: " + value);
                    }
                    gen.getStatic(bt, "TYPE", Type.getType(Class.class));
                } else {
                    gen.push(Compiler.destubClassName(cc.getName()));
                    gen.invokeStatic(Type.getType(Class.class), clojure.asm.commons.Method.getMethod("Class forName(String)"));
                }
            } else if (value instanceof Symbol) {
                gen.push(((Symbol)value).ns);
                gen.push(((Symbol)value).name);
                gen.invokeStatic(Type.getType(Symbol.class), clojure.asm.commons.Method.getMethod("clojure.lang.Symbol create(String,String)"));
            } else if (value instanceof Keyword) {
                this.emitValue(((Keyword)value).sym, gen);
                gen.invokeStatic(Type.getType(Keyword.class), clojure.asm.commons.Method.getMethod("clojure.lang.Keyword intern(clojure.lang.Symbol)"));
            } else if (value instanceof Var) {
                Var var = (Var)value;
                gen.push(var.ns.name.toString());
                gen.push(var.sym.toString());
                gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.Var var(String,String)"));
            } else if (value instanceof IPersistentMap) {
                ArrayList<Object> entries = new ArrayList<Object>();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    entries.add(entry.getKey());
                    entries.add(entry.getValue());
                }
                this.emitListAsObjectArray(entries, gen);
                gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentMap map(Object[])"));
            } else if (value instanceof IPersistentVector) {
                this.emitListAsObjectArray(value, gen);
                gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentVector vector(Object[])"));
            } else if (value instanceof ISeq || value instanceof IPersistentList) {
                this.emitListAsObjectArray(value, gen);
                gen.invokeStatic(Type.getType(Arrays.class), clojure.asm.commons.Method.getMethod("java.util.List asList(Object[])"));
                gen.invokeStatic(Type.getType(PersistentList.class), clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentList create(java.util.List)"));
            } else {
                String cs = null;
                try {
                    cs = RT.printString(value);
                }
                catch (Exception e2) {
                    throw new RuntimeException("Can't embed object in code, maybe print-dup not defined: " + value);
                }
                if (cs.length() == 0) {
                    throw new RuntimeException("Can't embed unreadable object in code: " + value);
                }
                if (cs.startsWith("#<")) {
                    throw new RuntimeException("Can't embed unreadable object in code: " + cs);
                }
                gen.push(cs);
                gen.invokeStatic(RT_TYPE, readStringMethod);
                partial2 = false;
            }
            if (partial2 && value instanceof IObj && RT.count(((IObj)value).meta()) > 0) {
                gen.checkCast(IOBJ_TYPE);
                this.emitValue(((IObj)value).meta(), gen);
                gen.checkCast(IPERSISTENTMAP_TYPE);
                gen.invokeInterface(IOBJ_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.IObj withMeta(clojure.lang.IPersistentMap)"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitConstants(GeneratorAdapter clinitgen) {
            try {
                Var.pushThreadBindings(RT.map(RT.PRINT_DUP, RT.T));
                for (int i = 0; i < this.constants.count(); ++i) {
                    this.emitValue(this.constants.nth(i), clinitgen);
                    clinitgen.checkCast(this.constantType(i));
                    clinitgen.putStatic(this.objtype, this.constantName(i), this.constantType(i));
                }
            }
            finally {
                Var.popThreadBindings();
            }
        }

        boolean isMutable(LocalBinding lb) {
            return this.isVolatile(lb) || RT.booleanCast(RT.contains(this.fields, lb.sym)) && RT.booleanCast(RT.get(lb.sym.meta(), Keyword.intern("unsynchronized-mutable")));
        }

        boolean isVolatile(LocalBinding lb) {
            return RT.booleanCast(RT.contains(this.fields, lb.sym)) && RT.booleanCast(RT.get(lb.sym.meta(), Keyword.intern("volatile-mutable")));
        }

        boolean isDeftype() {
            return this.fields != null;
        }

        void emitClearCloses(GeneratorAdapter gen) {
        }

        synchronized Class getCompiledClass() {
            if (this.compiledClass == null) {
                try {
                    this.loader = (DynamicClassLoader)LOADER.deref();
                    this.compiledClass = this.loader.defineClass(this.name, this.bytecode, this.src);
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
            return this.compiledClass;
        }

        public Object eval() throws Exception {
            if (this.isDeftype()) {
                return null;
            }
            return this.getCompiledClass().newInstance();
        }

        public void emitLetFnInits(GeneratorAdapter gen, ObjExpr objx, IPersistentSet letFnLocals) {
            gen.checkCast(this.objtype);
            for (ISeq s = RT.keys(this.closes); s != null; s = s.next()) {
                LocalBinding lb = (LocalBinding)s.first();
                if (!letFnLocals.contains(lb)) continue;
                Class primc = lb.getPrimitiveType();
                gen.dup();
                if (primc != null) {
                    objx.emitUnboxedLocal(gen, lb);
                    gen.putField(this.objtype, lb.name, Type.getType(primc));
                    continue;
                }
                objx.emitLocal(gen, lb, false);
                gen.putField(this.objtype, lb.name, OBJECT_TYPE);
            }
            gen.pop();
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (this.isDeftype()) {
                gen.visitInsn(1);
            } else {
                gen.newInstance(this.objtype);
                gen.dup();
                gen.visitInsn(1);
                for (ISeq s = RT.seq(this.closesExprs); s != null; s = s.next()) {
                    LocalBindingExpr lbe = (LocalBindingExpr)s.first();
                    LocalBinding lb = lbe.b;
                    if (lb.getPrimitiveType() != null) {
                        objx.emitUnboxedLocal(gen, lb);
                        continue;
                    }
                    objx.emitLocal(gen, lb, lbe.shouldClear);
                }
                gen.invokeConstructor(this.objtype, new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, this.ctorTypes()));
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() throws Exception {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return this.compiledClass != null ? this.compiledClass : (this.tag != null ? HostExpr.tagToClass(this.tag) : IFn.class);
        }

        public void emitAssignLocal(GeneratorAdapter gen, LocalBinding lb, Expr val2) {
            if (!this.isMutable(lb)) {
                throw new IllegalArgumentException("Cannot assign to non-mutable: " + lb.name);
            }
            Class primc = lb.getPrimitiveType();
            gen.loadThis();
            if (primc != null) {
                if (!(val2 instanceof MaybePrimitiveExpr) || !((MaybePrimitiveExpr)val2).canEmitPrimitive()) {
                    throw new IllegalArgumentException("Must assign primitive to primitive mutable: " + lb.name);
                }
                MaybePrimitiveExpr me = (MaybePrimitiveExpr)val2;
                me.emitUnboxed(C.EXPRESSION, this, gen);
                gen.putField(this.objtype, lb.name, Type.getType(primc));
            } else {
                val2.emit(C.EXPRESSION, this, gen);
                gen.putField(this.objtype, lb.name, OBJECT_TYPE);
            }
        }

        private void emitLocal(GeneratorAdapter gen, LocalBinding lb, boolean clear) {
            if (this.closes.containsKey(lb)) {
                Class primc = lb.getPrimitiveType();
                gen.loadThis();
                if (primc != null) {
                    gen.getField(this.objtype, lb.name, Type.getType(primc));
                    HostExpr.emitBoxReturn(this, gen, primc);
                } else {
                    gen.getField(this.objtype, lb.name, OBJECT_TYPE);
                    if (this.onceOnly && clear && lb.canBeCleared) {
                        gen.loadThis();
                        gen.visitInsn(1);
                        gen.putField(this.objtype, lb.name, OBJECT_TYPE);
                    }
                }
            } else {
                Class primc = lb.getPrimitiveType();
                if (lb.isArg) {
                    gen.loadArg(lb.idx - 1);
                    if (primc != null) {
                        HostExpr.emitBoxReturn(this, gen, primc);
                    } else if (clear && lb.canBeCleared) {
                        gen.visitInsn(1);
                        gen.storeArg(lb.idx - 1);
                    }
                } else if (primc != null) {
                    gen.visitVarInsn(Type.getType(primc).getOpcode(21), lb.idx);
                    HostExpr.emitBoxReturn(this, gen, primc);
                } else {
                    gen.visitVarInsn(OBJECT_TYPE.getOpcode(21), lb.idx);
                    if (clear && lb.canBeCleared) {
                        gen.visitInsn(1);
                        gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), lb.idx);
                    }
                }
            }
        }

        private void emitUnboxedLocal(GeneratorAdapter gen, LocalBinding lb) {
            Class primc = lb.getPrimitiveType();
            if (this.closes.containsKey(lb)) {
                gen.loadThis();
                gen.getField(this.objtype, lb.name, Type.getType(primc));
            } else if (lb.isArg) {
                gen.loadArg(lb.idx - 1);
            } else {
                gen.visitVarInsn(Type.getType(primc).getOpcode(21), lb.idx);
            }
        }

        public void emitVar(GeneratorAdapter gen, Var var) {
            Integer i = (Integer)this.vars.valAt(var);
            this.emitConstant(gen, i);
        }

        public void emitKeyword(GeneratorAdapter gen, Keyword k) {
            Integer i = (Integer)this.keywords.valAt(k);
            this.emitConstant(gen, i);
        }

        public void emitConstant(GeneratorAdapter gen, int id) {
            gen.getStatic(this.objtype, this.constantName(id), this.constantType(id));
        }

        String constantName(int id) {
            return CONST_PREFIX + id;
        }

        String siteName(int n) {
            return "__site__" + n;
        }

        String siteNameStatic(int n) {
            return this.siteName(n) + "__";
        }

        String thunkName(int n) {
            return "__thunk__" + n;
        }

        String cachedClassName(int n) {
            return "__cached_class__" + n;
        }

        String cachedProtoFnName(int n) {
            return "__cached_proto_fn__" + n;
        }

        String cachedProtoImplName(int n) {
            return "__cached_proto_impl__" + n;
        }

        String varCallsiteName(int n) {
            return "__var__callsite__" + n;
        }

        String thunkNameStatic(int n) {
            return this.thunkName(n) + "__";
        }

        Type constantType(int id) {
            Object o = this.constants.nth(id);
            Class<?> c = o.getClass();
            if (Modifier.isPublic(c.getModifiers())) {
                if (LazySeq.class.isAssignableFrom(c)) {
                    return Type.getType(ISeq.class);
                }
                if (c == Keyword.class) {
                    return Type.getType(Keyword.class);
                }
                if (RestFn.class.isAssignableFrom(c)) {
                    return Type.getType(RestFn.class);
                }
                if (AFn.class.isAssignableFrom(c)) {
                    return Type.getType(AFn.class);
                }
                if (c == Var.class) {
                    return Type.getType(Var.class);
                }
                if (c == String.class) {
                    return Type.getType(String.class);
                }
            }
            return OBJECT_TYPE;
        }
    }

    public static class FnExpr
    extends ObjExpr {
        static final Type aFnType = Type.getType(AFunction.class);
        static final Type restFnType = Type.getType(RestFn.class);
        FnMethod variadicMethod = null;
        IPersistentCollection methods;

        public FnExpr(Object tag) {
            super(tag);
        }

        public boolean hasJavaClass() throws Exception {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return AFunction.class;
        }

        protected void emitMethods(ClassVisitor cv) {
            for (ISeq s = RT.seq(this.methods); s != null; s = s.next()) {
                ObjMethod method = (ObjMethod)s.first();
                method.emit(this, cv);
            }
            if (this.isVariadic()) {
                GeneratorAdapter gen = new GeneratorAdapter(1, clojure.asm.commons.Method.getMethod("int getRequiredArity()"), null, null, cv);
                gen.visitCode();
                gen.push(this.variadicMethod.reqParms.count());
                gen.returnValue();
                gen.endMethod();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static Expr parse(C context, ISeq form, String name2) throws Exception {
            String basename;
            ISeq origForm = form;
            FnExpr fn2 = new FnExpr(Compiler.tagOf(form));
            fn2.src = form;
            ObjMethod enclosingMethod = (ObjMethod)METHOD.deref();
            if (((IMeta)form.first()).meta() != null) {
                fn2.onceOnly = RT.booleanCast(RT.get(RT.meta(form.first()), Keyword.intern(null, "once")));
            }
            String string2 = basename = enclosingMethod != null ? enclosingMethod.objx.name + "$" : Compiler.munge(Compiler.currentNS().name.name) + "$";
            if (RT.second(form) instanceof Symbol) {
                name2 = ((Symbol)RT.second((Object)form)).name;
            }
            String simpleName = name2 != null ? Compiler.munge(name2).replace(".", "_DOT_") + (enclosingMethod != null ? "__" + RT.nextID() : "") : "fn__" + RT.nextID();
            fn2.name = basename + simpleName;
            fn2.internalName = fn2.name.replace('.', '/');
            fn2.objtype = Type.getObjectType(fn2.internalName);
            try {
                Var.pushThreadBindings(RT.map(CONSTANTS, PersistentVector.EMPTY, CONSTANT_IDS, new IdentityHashMap(), KEYWORDS, PersistentHashMap.EMPTY, VARS, PersistentHashMap.EMPTY, KEYWORD_CALLSITES, PersistentVector.EMPTY, PROTOCOL_CALLSITES, PersistentVector.EMPTY, VAR_CALLSITES, PersistentVector.EMPTY));
                if (RT.second(form) instanceof Symbol) {
                    fn2.thisName = ((Symbol)RT.second((Object)form)).name;
                    form = RT.cons(FN, RT.next(RT.next(form)));
                }
                if (RT.second(form) instanceof IPersistentVector) {
                    form = RT.list(FN, RT.next(form));
                }
                fn2.line = (Integer)LINE.deref();
                FnMethod[] methodArray = new FnMethod[21];
                FnMethod variadicMethod = null;
                ISeq s = RT.next(form);
                while (s != null) {
                    FnMethod f = FnMethod.parse(fn2, (ISeq)RT.first(s));
                    if (f.isVariadic()) {
                        if (variadicMethod != null) throw new Exception("Can't have more than 1 variadic overload");
                        variadicMethod = f;
                    } else {
                        if (methodArray[f.reqParms.count()] != null) throw new Exception("Can't have 2 overloads with same arity");
                        methodArray[f.reqParms.count()] = f;
                    }
                    s = RT.next(s);
                }
                if (variadicMethod != null) {
                    for (int i = variadicMethod.reqParms.count() + 1; i <= 20; ++i) {
                        if (methodArray[i] == null) continue;
                        throw new Exception("Can't have fixed arity function with more params than variadic function");
                    }
                }
                IPersistentCollection methods2 = null;
                for (int i = 0; i < methodArray.length; ++i) {
                    if (methodArray[i] == null) continue;
                    methods2 = RT.conj(methods2, methodArray[i]);
                }
                if (variadicMethod != null) {
                    methods2 = RT.conj(methods2, variadicMethod);
                }
                fn2.methods = methods2;
                fn2.variadicMethod = variadicMethod;
                fn2.keywords = (IPersistentMap)KEYWORDS.deref();
                fn2.vars = (IPersistentMap)VARS.deref();
                fn2.constants = (PersistentVector)CONSTANTS.deref();
                fn2.keywordCallsites = (IPersistentVector)KEYWORD_CALLSITES.deref();
                fn2.protocolCallsites = (IPersistentVector)PROTOCOL_CALLSITES.deref();
                fn2.varCallsites = (IPersistentVector)VAR_CALLSITES.deref();
                fn2.constantsID = RT.nextID();
            }
            finally {
                Var.popThreadBindings();
            }
            fn2.compile(fn2.isVariadic() ? "clojure/lang/RestFn" : "clojure/lang/AFunction", null, fn2.onceOnly);
            fn2.getCompiledClass();
            if (!(origForm instanceof IObj) || ((IObj)((Object)origForm)).meta() == null) return fn2;
            return new MetaExpr(fn2, (MapExpr)MapExpr.parse(context == C.EVAL ? context : C.EXPRESSION, ((IObj)((Object)origForm)).meta()));
        }

        public final ObjMethod variadicMethod() {
            return this.variadicMethod;
        }

        boolean isVariadic() {
            return this.variadicMethod != null;
        }

        public final IPersistentCollection methods() {
            return this.methods;
        }
    }

    static class SourceDebugExtensionAttribute
    extends Attribute {
        public SourceDebugExtensionAttribute() {
            super("SourceDebugExtension");
        }

        void writeSMAP(ClassWriter cw, String smap) {
            ByteVector bv = this.write(cw, null, -1, -1, -1);
            bv.putUTF8(smap);
        }
    }

    static class InvokeExpr
    implements Expr {
        public final Expr fexpr;
        public final Object tag;
        public final IPersistentVector args;
        public final int line;
        public final String source;
        public boolean isProtocol = false;
        public boolean isDirect = false;
        public int siteIndex = -1;
        public Class protocolOn;
        public Method onMethod;
        static Keyword onKey = Keyword.intern("on");
        static Keyword methodMapKey = Keyword.intern("method-map");
        static Keyword dynamicKey = Keyword.intern("dynamic");

        public InvokeExpr(String source2, int line, Symbol tag, Expr fexpr, IPersistentVector args) throws Exception {
            Var fvar;
            Var pvar;
            this.source = source2;
            this.fexpr = fexpr;
            this.args = args;
            this.line = line;
            if (fexpr instanceof VarExpr && (pvar = (Var)RT.get((fvar = ((VarExpr)fexpr).var).meta(), protocolKey)) != null && PROTOCOL_CALLSITES.isBound()) {
                this.isProtocol = true;
                this.siteIndex = Compiler.registerProtocolCallsite(((VarExpr)fexpr).var);
                Object pon = RT.get(pvar.get(), onKey);
                this.protocolOn = HostExpr.maybeClass(pon, false);
                if (this.protocolOn != null) {
                    IPersistentMap mmap = (IPersistentMap)RT.get(pvar.get(), methodMapKey);
                    Keyword mmapVal = (Keyword)mmap.valAt(Keyword.intern(fvar.sym));
                    if (mmapVal == null) {
                        throw new IllegalArgumentException("No method of interface: " + this.protocolOn.getName() + " found for function: " + fvar.sym + " of protocol: " + pvar.sym + " (The protocol method may have been defined before and removed.)");
                    }
                    String mname = Compiler.munge(mmapVal.sym.toString());
                    List methods2 = Reflector.getMethods(this.protocolOn, args.count() - 1, mname, false);
                    if (methods2.size() != 1) {
                        throw new IllegalArgumentException("No single method: " + mname + " of interface: " + this.protocolOn.getName() + " found for function: " + fvar.sym + " of protocol: " + pvar.sym);
                    }
                    this.onMethod = (Method)methods2.get(0);
                }
            }
            this.tag = tag != null ? tag : (fexpr instanceof VarExpr ? ((VarExpr)fexpr).tag : null);
        }

        public Object eval() throws Exception {
            try {
                IFn fn2 = (IFn)this.fexpr.eval();
                PersistentVector argvs = PersistentVector.EMPTY;
                for (int i = 0; i < this.args.count(); ++i) {
                    argvs = argvs.cons(((Expr)this.args.nth(i)).eval());
                }
                return fn2.applyTo(RT.seq(argvs));
            }
            catch (Throwable e2) {
                if (!(e2 instanceof CompilerException)) {
                    throw new CompilerException(this.source, this.line, e2);
                }
                throw (CompilerException)e2;
            }
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            if (this.isProtocol) {
                this.emitProto(context, objx, gen);
            } else if (this.isDirect) {
                Label callLabel = gen.newLabel();
                gen.getStatic(objx.objtype, objx.varCallsiteName(this.siteIndex), IFN_TYPE);
                gen.dup();
                gen.ifNonNull(callLabel);
                gen.pop();
                this.fexpr.emit(C.EXPRESSION, objx, gen);
                gen.checkCast(IFN_TYPE);
                gen.mark(callLabel);
                this.emitArgsAndCall(0, context, objx, gen);
            } else {
                this.fexpr.emit(C.EXPRESSION, objx, gen);
                gen.checkCast(IFN_TYPE);
                this.emitArgsAndCall(0, context, objx, gen);
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public void emitProto(C context, ObjExpr objx, GeneratorAdapter gen) {
            Label onLabel = gen.newLabel();
            Label callLabel = gen.newLabel();
            Label endLabel = gen.newLabel();
            Var v = ((VarExpr)this.fexpr).var;
            Expr e2 = (Expr)this.args.nth(0);
            e2.emit(C.EXPRESSION, objx, gen);
            gen.dup();
            gen.invokeStatic(UTIL_TYPE, clojure.asm.commons.Method.getMethod("Class classOf(Object)"));
            gen.loadThis();
            gen.getField(objx.objtype, objx.cachedClassName(this.siteIndex), CLASS_TYPE);
            gen.visitJumpInsn(165, callLabel);
            if (this.protocolOn != null) {
                gen.dup();
                gen.instanceOf(Type.getType(this.protocolOn));
                gen.ifZCmp(154, onLabel);
            }
            gen.mark(callLabel);
            gen.dup();
            gen.invokeStatic(UTIL_TYPE, clojure.asm.commons.Method.getMethod("Class classOf(Object)"));
            gen.loadThis();
            gen.swap();
            gen.putField(objx.objtype, objx.cachedClassName(this.siteIndex), CLASS_TYPE);
            objx.emitVar(gen, v);
            gen.invokeVirtual(VAR_TYPE, clojure.asm.commons.Method.getMethod("Object getRawRoot()"));
            gen.swap();
            this.emitArgsAndCall(1, context, objx, gen);
            gen.goTo(endLabel);
            gen.mark(onLabel);
            if (this.protocolOn != null) {
                MethodExpr.emitTypedArgs(objx, gen, this.onMethod.getParameterTypes(), RT.subvec(this.args, 1, this.args.count()));
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.onMethod.getName(), Type.getReturnType(this.onMethod), Type.getArgumentTypes(this.onMethod));
                gen.invokeInterface(Type.getType(this.protocolOn), m);
                HostExpr.emitBoxReturn(objx, gen, this.onMethod.getReturnType());
            }
            gen.mark(endLabel);
        }

        void emitArgsAndCall(int firstArgToEmit, C context, ObjExpr objx, GeneratorAdapter gen) {
            for (int i = firstArgToEmit; i < Math.min(20, this.args.count()); ++i) {
                Expr e2 = (Expr)this.args.nth(i);
                e2.emit(C.EXPRESSION, objx, gen);
            }
            if (this.args.count() > 20) {
                PersistentVector restArgs = PersistentVector.EMPTY;
                for (int i = 20; i < this.args.count(); ++i) {
                    restArgs = restArgs.cons(this.args.nth(i));
                }
                MethodExpr.emitArgsAsArray(restArgs, objx, gen);
            }
            if (context == C.RETURN) {
                ObjMethod method = (ObjMethod)METHOD.deref();
                method.emitClearLocals(gen);
            }
            gen.invokeInterface(IFN_TYPE, new clojure.asm.commons.Method("invoke", OBJECT_TYPE, ARG_TYPES[Math.min(21, this.args.count())]));
        }

        public boolean hasJavaClass() throws Exception {
            return this.tag != null;
        }

        public Class getJavaClass() throws Exception {
            return HostExpr.tagToClass(this.tag);
        }

        public static Expr parse(C context, ISeq form) throws Exception {
            Class c;
            Expr fexpr;
            if (context != C.EVAL) {
                context = C.EXPRESSION;
            }
            if ((fexpr = Compiler.analyze(context, form.first())) instanceof VarExpr && ((VarExpr)fexpr).var.equals(INSTANCE) && RT.second(form) instanceof Symbol && (c = HostExpr.maybeClass(RT.second(form), false)) != null) {
                return new InstanceOfExpr(c, Compiler.analyze(context, RT.third(form)));
            }
            if (fexpr instanceof KeywordExpr && RT.count(form) == 2 && KEYWORD_CALLSITES.isBound()) {
                Expr target = Compiler.analyze(context, RT.second(form));
                return new KeywordInvokeExpr((String)SOURCE.deref(), (Integer)LINE.deref(), Compiler.tagOf(form), (KeywordExpr)fexpr, target);
            }
            PersistentVector args = PersistentVector.EMPTY;
            for (ISeq s = RT.seq(form.next()); s != null; s = s.next()) {
                args = args.cons(Compiler.analyze(context, s.first()));
            }
            return new InvokeExpr((String)SOURCE.deref(), (Integer)LINE.deref(), Compiler.tagOf(form), fexpr, args);
        }
    }

    public static class InstanceOfExpr
    implements Expr,
    MaybePrimitiveExpr {
        Expr expr;
        Class c;

        public InstanceOfExpr(Class c, Expr expr) {
            this.expr = expr;
            this.c = c;
        }

        public Object eval() throws Exception {
            if (this.c.isInstance(this.expr.eval())) {
                return RT.T;
            }
            return RT.F;
        }

        public boolean canEmitPrimitive() {
            return true;
        }

        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.expr.emit(C.EXPRESSION, objx, gen);
            gen.instanceOf(Type.getType(this.c));
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.emitUnboxed(context, objx, gen);
            HostExpr.emitBoxReturn(objx, gen, Boolean.TYPE);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() throws Exception {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return Boolean.TYPE;
        }
    }

    static class KeywordInvokeExpr
    implements Expr {
        public final KeywordExpr kw;
        public final Object tag;
        public final Expr target;
        public final int line;
        public final int siteIndex;
        public final String source;
        static Type ILOOKUP_TYPE = Type.getType(ILookup.class);

        public KeywordInvokeExpr(String source2, int line, Symbol tag, KeywordExpr kw, Expr target) {
            this.source = source2;
            this.kw = kw;
            this.target = target;
            this.line = line;
            this.tag = tag;
            this.siteIndex = Compiler.registerKeywordCallsite(kw.k);
        }

        public Object eval() throws Exception {
            try {
                return this.kw.k.invoke(this.target.eval());
            }
            catch (Throwable e2) {
                if (!(e2 instanceof CompilerException)) {
                    throw new CompilerException(this.source, this.line, e2);
                }
                throw (CompilerException)e2;
            }
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            Label endLabel = gen.newLabel();
            Label faultLabel = gen.newLabel();
            gen.visitLineNumber(this.line, gen.mark());
            gen.getStatic(objx.objtype, objx.thunkNameStatic(this.siteIndex), ObjExpr.ILOOKUP_THUNK_TYPE);
            gen.dup();
            this.target.emit(C.EXPRESSION, objx, gen);
            gen.dupX2();
            gen.invokeInterface(ObjExpr.ILOOKUP_THUNK_TYPE, clojure.asm.commons.Method.getMethod("Object get(Object)"));
            gen.dupX2();
            gen.visitJumpInsn(165, faultLabel);
            gen.pop();
            gen.goTo(endLabel);
            gen.mark(faultLabel);
            gen.swap();
            gen.pop();
            gen.getStatic(objx.objtype, objx.siteNameStatic(this.siteIndex), ObjExpr.KEYWORD_LOOKUPSITE_TYPE);
            gen.swap();
            gen.loadThis();
            gen.invokeInterface(ObjExpr.ILOOKUP_SITE_TYPE, clojure.asm.commons.Method.getMethod("Object fault(Object, clojure.lang.ILookupHost)"));
            gen.mark(endLabel);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public void emit2(C context, ObjExpr objx, GeneratorAdapter gen) {
            Label endLabel = gen.newLabel();
            Label faultLabel = gen.newLabel();
            gen.visitLineNumber(this.line, gen.mark());
            this.target.emit(C.EXPRESSION, objx, gen);
            gen.dup();
            gen.getStatic(objx.objtype, objx.thunkNameStatic(this.siteIndex), ObjExpr.ILOOKUP_THUNK_TYPE);
            gen.swap();
            gen.getStatic(objx.objtype, objx.siteNameStatic(this.siteIndex), ObjExpr.KEYWORD_LOOKUPSITE_TYPE);
            gen.invokeInterface(ObjExpr.ILOOKUP_THUNK_TYPE, clojure.asm.commons.Method.getMethod("Object get(Object,clojure.lang.ILookupSite)"));
            gen.dup();
            gen.getStatic(objx.objtype, objx.siteNameStatic(this.siteIndex), ObjExpr.KEYWORD_LOOKUPSITE_TYPE);
            gen.visitJumpInsn(165, faultLabel);
            gen.swap();
            gen.pop();
            gen.goTo(endLabel);
            gen.mark(faultLabel);
            gen.swap();
            gen.loadThis();
            gen.invokeInterface(ObjExpr.ILOOKUP_SITE_TYPE, clojure.asm.commons.Method.getMethod("Object fault(Object, clojure.lang.ILookupHost)"));
            gen.mark(endLabel);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public void emitInstance(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            gen.loadThis();
            gen.getField(objx.objtype, objx.thunkName(this.siteIndex), ObjExpr.ILOOKUP_THUNK_TYPE);
            this.target.emit(C.EXPRESSION, objx, gen);
            gen.loadThis();
            gen.getField(objx.objtype, objx.siteName(this.siteIndex), ObjExpr.ILOOKUP_SITE_TYPE);
            gen.loadThis();
            gen.checkCast(Type.getType(ILookupHost.class));
            gen.invokeInterface(ObjExpr.ILOOKUP_THUNK_TYPE, clojure.asm.commons.Method.getMethod("Object get(Object,clojure.lang.ILookupSite,clojure.lang.ILookupHost)"));
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public void emitNormal(C context, ObjExpr objx, GeneratorAdapter gen) {
            Label slowLabel = gen.newLabel();
            Label endLabel = gen.newLabel();
            gen.visitLineNumber(this.line, gen.mark());
            this.target.emit(C.EXPRESSION, objx, gen);
            gen.dup();
            gen.instanceOf(ILOOKUP_TYPE);
            gen.ifZCmp(153, slowLabel);
            this.kw.emit(C.EXPRESSION, objx, gen);
            gen.invokeInterface(ILOOKUP_TYPE, new clojure.asm.commons.Method("valAt", OBJECT_TYPE, ARG_TYPES[1]));
            gen.goTo(endLabel);
            gen.mark(slowLabel);
            this.kw.emit(C.EXPRESSION, objx, gen);
            gen.invokeStatic(RT_TYPE, new clojure.asm.commons.Method("get", OBJECT_TYPE, ARG_TYPES[2]));
            gen.mark(endLabel);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() throws Exception {
            return this.tag != null;
        }

        public Class getJavaClass() throws Exception {
            return HostExpr.tagToClass(this.tag);
        }
    }

    public static class VectorExpr
    implements Expr {
        public final IPersistentVector args;
        static final clojure.asm.commons.Method vectorMethod = clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentVector vector(Object[])");

        public VectorExpr(IPersistentVector args) {
            this.args = args;
        }

        public Object eval() throws Exception {
            IPersistentVector ret = PersistentVector.EMPTY;
            for (int i = 0; i < this.args.count(); ++i) {
                ret = ret.cons(((Expr)this.args.nth(i)).eval());
            }
            return ret;
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            MethodExpr.emitArgsAsArray(this.args, objx, gen);
            gen.invokeStatic(RT_TYPE, vectorMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() throws Exception {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return IPersistentVector.class;
        }

        public static Expr parse(C context, IPersistentVector form) throws Exception {
            IPersistentVector args = PersistentVector.EMPTY;
            for (int i = 0; i < form.count(); ++i) {
                args = args.cons(Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, form.nth(i)));
            }
            VectorExpr ret = new VectorExpr(args);
            if (form instanceof IObj && ((IObj)((Object)form)).meta() != null) {
                return new MetaExpr(ret, (MapExpr)MapExpr.parse(context == C.EVAL ? context : C.EXPRESSION, ((IObj)((Object)form)).meta()));
            }
            return ret;
        }
    }

    public static class SetExpr
    implements Expr {
        public final IPersistentVector keys;
        static final clojure.asm.commons.Method setMethod = clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentSet set(Object[])");

        public SetExpr(IPersistentVector keys2) {
            this.keys = keys2;
        }

        public Object eval() throws Exception {
            Object[] ret = new Object[this.keys.count()];
            for (int i = 0; i < this.keys.count(); ++i) {
                ret[i] = ((Expr)this.keys.nth(i)).eval();
            }
            return RT.set(ret);
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            MethodExpr.emitArgsAsArray(this.keys, objx, gen);
            gen.invokeStatic(RT_TYPE, setMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() throws Exception {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return IPersistentSet.class;
        }

        public static Expr parse(C context, IPersistentSet form) throws Exception {
            IPersistentVector keys2 = PersistentVector.EMPTY;
            for (ISeq s = RT.seq(form); s != null; s = s.next()) {
                Object e2 = s.first();
                keys2 = keys2.cons(Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, e2));
            }
            SetExpr ret = new SetExpr(keys2);
            if (form instanceof IObj && ((IObj)((Object)form)).meta() != null) {
                return new MetaExpr(ret, (MapExpr)MapExpr.parse(context == C.EVAL ? context : C.EXPRESSION, ((IObj)((Object)form)).meta()));
            }
            return ret;
        }
    }

    public static class MapExpr
    implements Expr {
        public final IPersistentVector keyvals;
        static final clojure.asm.commons.Method mapMethod = clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentMap map(Object[])");

        public MapExpr(IPersistentVector keyvals) {
            this.keyvals = keyvals;
        }

        public Object eval() throws Exception {
            Object[] ret = new Object[this.keyvals.count()];
            for (int i = 0; i < this.keyvals.count(); ++i) {
                ret[i] = ((Expr)this.keyvals.nth(i)).eval();
            }
            return RT.map(ret);
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            MethodExpr.emitArgsAsArray(this.keyvals, objx, gen);
            gen.invokeStatic(RT_TYPE, mapMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() throws Exception {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return IPersistentMap.class;
        }

        public static Expr parse(C context, IPersistentMap form) throws Exception {
            IPersistentVector keyvals = PersistentVector.EMPTY;
            for (ISeq s = RT.seq(form); s != null; s = s.next()) {
                IMapEntry e2 = (IMapEntry)s.first();
                keyvals = keyvals.cons(Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, e2.key()));
                keyvals = keyvals.cons(Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, e2.val()));
            }
            MapExpr ret = new MapExpr(keyvals);
            if (form instanceof IObj && ((IObj)((Object)form)).meta() != null) {
                return new MetaExpr(ret, (MapExpr)MapExpr.parse(context == C.EVAL ? context : C.EXPRESSION, ((IObj)((Object)form)).meta()));
            }
            return ret;
        }
    }

    public static class ListExpr
    implements Expr {
        public final IPersistentVector args;
        static final clojure.asm.commons.Method arrayToListMethod = clojure.asm.commons.Method.getMethod("clojure.lang.ISeq arrayToList(Object[])");

        public ListExpr(IPersistentVector args) {
            this.args = args;
        }

        public Object eval() throws Exception {
            IPersistentVector ret = PersistentVector.EMPTY;
            for (int i = 0; i < this.args.count(); ++i) {
                ret = ret.cons(((Expr)this.args.nth(i)).eval());
            }
            return ret.seq();
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            MethodExpr.emitArgsAsArray(this.args, objx, gen);
            gen.invokeStatic(RT_TYPE, arrayToListMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() throws Exception {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return IPersistentList.class;
        }
    }

    public static class EmptyExpr
    implements Expr {
        public final Object coll;
        static final Type HASHMAP_TYPE = Type.getType(PersistentArrayMap.class);
        static final Type HASHSET_TYPE = Type.getType(PersistentHashSet.class);
        static final Type VECTOR_TYPE = Type.getType(PersistentVector.class);
        static final Type LIST_TYPE = Type.getType(PersistentList.class);
        static final Type EMPTY_LIST_TYPE = Type.getType(PersistentList.EmptyList.class);

        public EmptyExpr(Object coll) {
            this.coll = coll;
        }

        public Object eval() throws Exception {
            return this.coll;
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (this.coll instanceof IPersistentList) {
                gen.getStatic(LIST_TYPE, "EMPTY", EMPTY_LIST_TYPE);
            } else if (this.coll instanceof IPersistentVector) {
                gen.getStatic(VECTOR_TYPE, "EMPTY", VECTOR_TYPE);
            } else if (this.coll instanceof IPersistentMap) {
                gen.getStatic(HASHMAP_TYPE, "EMPTY", HASHMAP_TYPE);
            } else if (this.coll instanceof IPersistentSet) {
                gen.getStatic(HASHSET_TYPE, "EMPTY", HASHSET_TYPE);
            } else {
                throw new UnsupportedOperationException("Unknown Collection type");
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() throws Exception {
            return true;
        }

        public Class getJavaClass() throws Exception {
            if (this.coll instanceof IPersistentList) {
                return IPersistentList.class;
            }
            if (this.coll instanceof IPersistentVector) {
                return IPersistentVector.class;
            }
            if (this.coll instanceof IPersistentMap) {
                return IPersistentMap.class;
            }
            if (this.coll instanceof IPersistentSet) {
                return IPersistentSet.class;
            }
            throw new UnsupportedOperationException("Unknown Collection type");
        }
    }

    public static class IfExpr
    implements Expr,
    MaybePrimitiveExpr {
        public final Expr testExpr;
        public final Expr thenExpr;
        public final Expr elseExpr;
        public final int line;

        public IfExpr(int line, Expr testExpr, Expr thenExpr, Expr elseExpr) {
            this.testExpr = testExpr;
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
            this.line = line;
        }

        public Object eval() throws Exception {
            Object t = this.testExpr.eval();
            if (t != null && t != Boolean.FALSE) {
                return this.thenExpr.eval();
            }
            return this.elseExpr.eval();
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.doEmit(context, objx, gen, false);
        }

        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.doEmit(context, objx, gen, true);
        }

        public void doEmit(C context, ObjExpr objx, GeneratorAdapter gen, boolean emitUnboxed) {
            Label nullLabel = gen.newLabel();
            Label falseLabel = gen.newLabel();
            Label endLabel = gen.newLabel();
            gen.visitLineNumber(this.line, gen.mark());
            try {
                if (Compiler.maybePrimitiveType(this.testExpr) == Boolean.TYPE) {
                    ((MaybePrimitiveExpr)this.testExpr).emitUnboxed(C.EXPRESSION, objx, gen);
                    gen.ifZCmp(153, falseLabel);
                } else {
                    this.testExpr.emit(C.EXPRESSION, objx, gen);
                    gen.dup();
                    gen.ifNull(nullLabel);
                    gen.getStatic(BOOLEAN_OBJECT_TYPE, "FALSE", BOOLEAN_OBJECT_TYPE);
                    gen.visitJumpInsn(165, falseLabel);
                }
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
            if (emitUnboxed) {
                ((MaybePrimitiveExpr)this.thenExpr).emitUnboxed(context, objx, gen);
            } else {
                this.thenExpr.emit(context, objx, gen);
            }
            gen.goTo(endLabel);
            gen.mark(nullLabel);
            gen.pop();
            gen.mark(falseLabel);
            if (emitUnboxed) {
                ((MaybePrimitiveExpr)this.elseExpr).emitUnboxed(context, objx, gen);
            } else {
                this.elseExpr.emit(context, objx, gen);
            }
            gen.mark(endLabel);
        }

        public boolean hasJavaClass() throws Exception {
            return this.thenExpr.hasJavaClass() && this.elseExpr.hasJavaClass() && (this.thenExpr.getJavaClass() == this.elseExpr.getJavaClass() || this.thenExpr.getJavaClass() == null && !this.elseExpr.getJavaClass().isPrimitive() || this.elseExpr.getJavaClass() == null && !this.thenExpr.getJavaClass().isPrimitive());
        }

        public boolean canEmitPrimitive() {
            try {
                return this.thenExpr instanceof MaybePrimitiveExpr && this.elseExpr instanceof MaybePrimitiveExpr && this.thenExpr.getJavaClass() == this.elseExpr.getJavaClass() && ((MaybePrimitiveExpr)this.thenExpr).canEmitPrimitive() && ((MaybePrimitiveExpr)this.elseExpr).canEmitPrimitive();
            }
            catch (Exception e2) {
                return false;
            }
        }

        public Class getJavaClass() throws Exception {
            Class thenClass = this.thenExpr.getJavaClass();
            if (thenClass != null) {
                return thenClass;
            }
            return this.elseExpr.getJavaClass();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Expr parse(C context, Object frm) throws Exception {
                Expr elseexpr;
                Expr thenexpr;
                ISeq form = (ISeq)frm;
                if (form.count() > 4) {
                    throw new Exception("Too many arguments to if");
                }
                if (form.count() < 3) {
                    throw new Exception("Too few arguments to if");
                }
                PathNode branch = new PathNode(PATHTYPE.BRANCH, (PathNode)CLEAR_PATH.get());
                Expr testexpr = Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, RT.second(form));
                try {
                    Var.pushThreadBindings(RT.map(CLEAR_PATH, new PathNode(PATHTYPE.PATH, branch)));
                    thenexpr = Compiler.analyze(context, RT.third(form));
                }
                finally {
                    Var.popThreadBindings();
                }
                try {
                    Var.pushThreadBindings(RT.map(CLEAR_PATH, new PathNode(PATHTYPE.PATH, branch)));
                    elseexpr = Compiler.analyze(context, RT.fourth(form));
                }
                finally {
                    Var.popThreadBindings();
                }
                return new IfExpr((Integer)LINE.deref(), testexpr, thenexpr, elseexpr);
            }
        }
    }

    public static class MetaExpr
    implements Expr {
        public final Expr expr;
        public final MapExpr meta;
        static final Type IOBJ_TYPE = Type.getType(IObj.class);
        static final clojure.asm.commons.Method withMetaMethod = clojure.asm.commons.Method.getMethod("clojure.lang.IObj withMeta(clojure.lang.IPersistentMap)");

        public MetaExpr(Expr expr, MapExpr meta2) {
            this.expr = expr;
            this.meta = meta2;
        }

        public Object eval() throws Exception {
            return ((IObj)this.expr.eval()).withMeta((IPersistentMap)this.meta.eval());
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.expr.emit(C.EXPRESSION, objx, gen);
            gen.checkCast(IOBJ_TYPE);
            this.meta.emit(C.EXPRESSION, objx, gen);
            gen.checkCast(IPERSISTENTMAP_TYPE);
            gen.invokeInterface(IOBJ_TYPE, withMetaMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() throws Exception {
            return this.expr.hasJavaClass();
        }

        public Class getJavaClass() throws Exception {
            return this.expr.getJavaClass();
        }
    }

    public static class NewExpr
    implements Expr {
        public final IPersistentVector args;
        public final Constructor ctor;
        public final Class c;
        static final clojure.asm.commons.Method invokeConstructorMethod = clojure.asm.commons.Method.getMethod("Object invokeConstructor(Class,Object[])");
        static final clojure.asm.commons.Method forNameMethod = clojure.asm.commons.Method.getMethod("Class forName(String)");

        public NewExpr(Class c, IPersistentVector args, int line) throws Exception {
            this.args = args;
            this.c = c;
            Constructor<?>[] allctors = c.getConstructors();
            ArrayList ctors = new ArrayList();
            ArrayList<Class[]> params = new ArrayList<Class[]>();
            ArrayList<Class> rets = new ArrayList<Class>();
            for (int i = 0; i < allctors.length; ++i) {
                Constructor<?> ctor = allctors[i];
                if (ctor.getParameterTypes().length != args.count()) continue;
                ctors.add(ctor);
                params.add(ctor.getParameterTypes());
                rets.add(c);
            }
            if (ctors.isEmpty()) {
                throw new IllegalArgumentException("No matching ctor found for " + c);
            }
            int ctoridx = 0;
            if (ctors.size() > 1) {
                ctoridx = Compiler.getMatchingParams(c.getName(), params, args, rets);
            }
            Constructor constructor = this.ctor = ctoridx >= 0 ? (Constructor)ctors.get(ctoridx) : null;
            if (this.ctor == null && RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                RT.errPrintWriter().format("Reflection warning, %s:%d - call to %s ctor can't be resolved.\n", SOURCE_PATH.deref(), line, c.getName());
            }
        }

        public Object eval() throws Exception {
            Object[] argvals = new Object[this.args.count()];
            for (int i = 0; i < this.args.count(); ++i) {
                argvals[i] = ((Expr)this.args.nth(i)).eval();
            }
            if (this.ctor != null) {
                return this.ctor.newInstance(Reflector.boxArgs(this.ctor.getParameterTypes(), argvals));
            }
            return Reflector.invokeConstructor(this.c, argvals);
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (this.ctor != null) {
                Type type2 = Compiler.getType(this.c);
                gen.newInstance(type2);
                gen.dup();
                MethodExpr.emitTypedArgs(objx, gen, this.ctor.getParameterTypes(), this.args);
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                gen.invokeConstructor(type2, new clojure.asm.commons.Method("<init>", Type.getConstructorDescriptor(this.ctor)));
            } else {
                gen.push(Compiler.destubClassName(this.c.getName()));
                gen.invokeStatic(CLASS_TYPE, forNameMethod);
                MethodExpr.emitArgsAsArray(this.args, objx, gen);
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                gen.invokeStatic(REFLECTOR_TYPE, invokeConstructorMethod);
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return this.c;
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object frm) throws Exception {
                int line = (Integer)LINE.deref();
                ISeq form = (ISeq)frm;
                if (form.count() < 2) {
                    throw new Exception("wrong number of arguments, expecting: (new Classname args...)");
                }
                Class c = HostExpr.maybeClass(RT.second(form), false);
                if (c == null) {
                    throw new IllegalArgumentException("Unable to resolve classname: " + RT.second(form));
                }
                PersistentVector args = PersistentVector.EMPTY;
                for (ISeq s = RT.next(RT.next(form)); s != null; s = s.next()) {
                    args = args.cons(Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, s.first()));
                }
                return new NewExpr(c, args, line);
            }
        }
    }

    static class ThrowExpr
    extends UntypedExpr {
        public final Expr excExpr;

        public ThrowExpr(Expr excExpr) {
            this.excExpr = excExpr;
        }

        public Object eval() throws Exception {
            throw new Exception("Can't eval throw");
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.excExpr.emit(C.EXPRESSION, objx, gen);
            gen.checkCast(THROWABLE_TYPE);
            gen.throwException();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object form) throws Exception {
                if (context == C.EVAL) {
                    return Compiler.analyze(context, RT.list(RT.list(FN, PersistentVector.EMPTY, form)));
                }
                return new ThrowExpr(Compiler.analyze(C.EXPRESSION, RT.second(form)));
            }
        }
    }

    public static class TryExpr
    implements Expr {
        public final Expr tryExpr;
        public final Expr finallyExpr;
        public final PersistentVector catchExprs;
        public final int retLocal;
        public final int finallyLocal;

        public TryExpr(Expr tryExpr, PersistentVector catchExprs, Expr finallyExpr, int retLocal, int finallyLocal) {
            this.tryExpr = tryExpr;
            this.catchExprs = catchExprs;
            this.finallyExpr = finallyExpr;
            this.retLocal = retLocal;
            this.finallyLocal = finallyLocal;
        }

        public Object eval() throws Exception {
            throw new UnsupportedOperationException("Can't eval try");
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            CatchClause clause;
            int i;
            Label startTry = gen.newLabel();
            Label endTry = gen.newLabel();
            Label end = gen.newLabel();
            Label ret = gen.newLabel();
            Label finallyLabel = gen.newLabel();
            for (i = 0; i < this.catchExprs.count(); ++i) {
                clause = (CatchClause)this.catchExprs.nth(i);
                clause.label = gen.newLabel();
                clause.endLabel = gen.newLabel();
            }
            gen.mark(startTry);
            this.tryExpr.emit(context, objx, gen);
            if (context != C.STATEMENT) {
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), this.retLocal);
            }
            gen.mark(endTry);
            if (this.finallyExpr != null) {
                this.finallyExpr.emit(C.STATEMENT, objx, gen);
            }
            gen.goTo(ret);
            for (i = 0; i < this.catchExprs.count(); ++i) {
                clause = (CatchClause)this.catchExprs.nth(i);
                gen.mark(clause.label);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), clause.lb.idx);
                clause.handler.emit(context, objx, gen);
                if (context != C.STATEMENT) {
                    gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), this.retLocal);
                }
                gen.mark(clause.endLabel);
                if (this.finallyExpr != null) {
                    this.finallyExpr.emit(C.STATEMENT, objx, gen);
                }
                gen.goTo(ret);
            }
            if (this.finallyExpr != null) {
                gen.mark(finallyLabel);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), this.finallyLocal);
                this.finallyExpr.emit(C.STATEMENT, objx, gen);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(21), this.finallyLocal);
                gen.throwException();
            }
            gen.mark(ret);
            if (context != C.STATEMENT) {
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(21), this.retLocal);
            }
            gen.mark(end);
            for (i = 0; i < this.catchExprs.count(); ++i) {
                clause = (CatchClause)this.catchExprs.nth(i);
                gen.visitTryCatchBlock(startTry, endTry, clause.label, clause.c.getName().replace('.', '/'));
            }
            if (this.finallyExpr != null) {
                gen.visitTryCatchBlock(startTry, endTry, finallyLabel, null);
                for (i = 0; i < this.catchExprs.count(); ++i) {
                    clause = (CatchClause)this.catchExprs.nth(i);
                    gen.visitTryCatchBlock(clause.label, clause.endLabel, finallyLabel, null);
                }
            }
            for (i = 0; i < this.catchExprs.count(); ++i) {
                clause = (CatchClause)this.catchExprs.nth(i);
                gen.visitLocalVariable(clause.lb.name, "Ljava/lang/Object;", null, clause.label, clause.endLabel, clause.lb.idx);
            }
        }

        public boolean hasJavaClass() throws Exception {
            return this.tryExpr.hasJavaClass();
        }

        public Class getJavaClass() throws Exception {
            return this.tryExpr.getJavaClass();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Expr parse(C context, Object frm) throws Exception {
                ISeq form = (ISeq)frm;
                if (context != C.RETURN) {
                    return Compiler.analyze(context, RT.list(RT.list(FN, PersistentVector.EMPTY, form)));
                }
                PersistentVector body = PersistentVector.EMPTY;
                PersistentVector catches = PersistentVector.EMPTY;
                Expr bodyExpr = null;
                Expr finallyExpr = null;
                boolean caught = false;
                int retLocal = Compiler.getAndIncLocalNum();
                int finallyLocal = Compiler.getAndIncLocalNum();
                for (ISeq fs = form.next(); fs != null; fs = fs.next()) {
                    Object op;
                    Object f = fs.first();
                    Object object = op = f instanceof ISeq ? ((ISeq)f).first() : null;
                    if (!Util.equals(op, CATCH) && !Util.equals(op, FINALLY)) {
                        if (caught) {
                            throw new Exception("Only catch or finally clause can follow catch in try expression");
                        }
                        body = body.cons(f);
                        continue;
                    }
                    if (bodyExpr == null) {
                        bodyExpr = new BodyExpr.Parser().parse(context, RT.seq(body));
                    }
                    if (Util.equals(op, CATCH)) {
                        Class c = HostExpr.maybeClass(RT.second(f), false);
                        if (c == null) {
                            throw new IllegalArgumentException("Unable to resolve classname: " + RT.second(f));
                        }
                        if (!(RT.third(f) instanceof Symbol)) {
                            throw new IllegalArgumentException("Bad binding form, expected symbol, got: " + RT.third(f));
                        }
                        Symbol sym = (Symbol)RT.third(f);
                        if (sym.getNamespace() != null) {
                            throw new Exception("Can't bind qualified name:" + sym);
                        }
                        IPersistentMap dynamicBindings = RT.map(LOCAL_ENV, LOCAL_ENV.deref(), NEXT_LOCAL_NUM, NEXT_LOCAL_NUM.deref(), IN_CATCH_FINALLY, RT.T);
                        try {
                            Var.pushThreadBindings(dynamicBindings);
                            LocalBinding lb = Compiler.registerLocal(sym, (Symbol)(RT.second(f) instanceof Symbol ? RT.second(f) : null), null, false);
                            Expr handler = new BodyExpr.Parser().parse(context, RT.next(RT.next(RT.next(f))));
                            catches = catches.cons(new CatchClause(c, lb, handler));
                        }
                        finally {
                            Var.popThreadBindings();
                        }
                        caught = true;
                        continue;
                    }
                    if (fs.next() != null) {
                        throw new Exception("finally clause must be last in try expression");
                    }
                    try {
                        Var.pushThreadBindings(RT.map(IN_CATCH_FINALLY, RT.T));
                        finallyExpr = new BodyExpr.Parser().parse(C.STATEMENT, RT.next(f));
                        continue;
                    }
                    finally {
                        Var.popThreadBindings();
                    }
                }
                if (bodyExpr == null) {
                    bodyExpr = new BodyExpr.Parser().parse(context, RT.seq(body));
                }
                return new TryExpr(bodyExpr, catches, finallyExpr, retLocal, finallyLocal);
            }
        }

        public static class CatchClause {
            public final Class c;
            public final LocalBinding lb;
            public final Expr handler;
            Label label;
            Label endLabel;

            public CatchClause(Class c, LocalBinding lb, Expr handler) {
                this.c = c;
                this.lb = lb;
                this.handler = handler;
            }
        }
    }

    static class MonitorExitExpr
    extends UntypedExpr {
        final Expr target;

        public MonitorExitExpr(Expr target) {
            this.target = target;
        }

        public Object eval() throws Exception {
            throw new UnsupportedOperationException("Can't eval monitor-exit");
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.target.emit(C.EXPRESSION, objx, gen);
            gen.monitorExit();
            NIL_EXPR.emit(context, objx, gen);
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object form) throws Exception {
                return new MonitorExitExpr(Compiler.analyze(C.EXPRESSION, RT.second(form)));
            }
        }
    }

    static class MonitorEnterExpr
    extends UntypedExpr {
        final Expr target;

        public MonitorEnterExpr(Expr target) {
            this.target = target;
        }

        public Object eval() throws Exception {
            throw new UnsupportedOperationException("Can't eval monitor-enter");
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.target.emit(C.EXPRESSION, objx, gen);
            gen.monitorEnter();
            NIL_EXPR.emit(context, objx, gen);
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object form) throws Exception {
                return new MonitorEnterExpr(Compiler.analyze(C.EXPRESSION, RT.second(form)));
            }
        }
    }

    static class StringExpr
    extends LiteralExpr {
        public final String str;

        public StringExpr(String str2) {
            this.str = str2;
        }

        Object val() {
            return this.str;
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (context != C.STATEMENT) {
                gen.push(this.str);
            }
        }

        public boolean hasJavaClass() {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return String.class;
        }
    }

    static class BooleanExpr
    extends LiteralExpr {
        public final boolean val;

        public BooleanExpr(boolean val2) {
            this.val = val2;
        }

        Object val() {
            return this.val ? RT.T : RT.F;
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (this.val) {
                gen.getStatic(BOOLEAN_OBJECT_TYPE, "TRUE", BOOLEAN_OBJECT_TYPE);
            } else {
                gen.getStatic(BOOLEAN_OBJECT_TYPE, "FALSE", BOOLEAN_OBJECT_TYPE);
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return Boolean.class;
        }
    }

    static class NilExpr
    extends LiteralExpr {
        NilExpr() {
        }

        Object val() {
            return null;
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.visitInsn(1);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return null;
        }
    }

    static class ConstantExpr
    extends LiteralExpr {
        public final Object v;
        public final int id;

        public ConstantExpr(Object v) {
            this.v = v;
            this.id = Compiler.registerConstant(v);
        }

        Object val() {
            return this.v;
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            objx.emitConstant(gen, this.id);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return Modifier.isPublic(this.v.getClass().getModifiers());
        }

        public Class getJavaClass() throws Exception {
            return this.v.getClass();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object form) {
                Object v = RT.second(form);
                if (v == null) {
                    return NIL_EXPR;
                }
                return new ConstantExpr(v);
            }
        }
    }

    static class UnresolvedVarExpr
    implements Expr {
        public final Symbol symbol;

        public UnresolvedVarExpr(Symbol symbol2) {
            this.symbol = symbol2;
        }

        public boolean hasJavaClass() {
            return false;
        }

        public Class getJavaClass() throws Exception {
            throw new IllegalArgumentException("UnresolvedVarExpr has no Java class");
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
        }

        public Object eval() throws Exception {
            throw new IllegalArgumentException("UnresolvedVarExpr cannot be evalled");
        }
    }

    static class StaticMethodExpr
    extends MethodExpr {
        public final Class c;
        public final String methodName;
        public final IPersistentVector args;
        public final String source;
        public final int line;
        public final Method method;
        public final Symbol tag;
        static final clojure.asm.commons.Method forNameMethod = clojure.asm.commons.Method.getMethod("Class forName(String)");
        static final clojure.asm.commons.Method invokeStaticMethodMethod = clojure.asm.commons.Method.getMethod("Object invokeStaticMethod(Class,String,Object[])");

        public StaticMethodExpr(String source2, int line, Symbol tag, Class c, String methodName, IPersistentVector args) throws Exception {
            this.c = c;
            this.methodName = methodName;
            this.args = args;
            this.source = source2;
            this.line = line;
            this.tag = tag;
            List methods2 = Reflector.getMethods(c, args.count(), methodName, true);
            if (methods2.isEmpty()) {
                throw new IllegalArgumentException("No matching method: " + methodName);
            }
            int methodidx = 0;
            if (methods2.size() > 1) {
                ArrayList<Class[]> params = new ArrayList<Class[]>();
                ArrayList<Class> rets = new ArrayList<Class>();
                for (int i = 0; i < methods2.size(); ++i) {
                    Method m = (Method)methods2.get(i);
                    params.add(m.getParameterTypes());
                    rets.add(m.getReturnType());
                }
                methodidx = Compiler.getMatchingParams(methodName, params, args, rets);
            }
            this.method = methodidx >= 0 ? methods2.get(methodidx) : null;
            if (this.method == null && RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                RT.errPrintWriter().format("Reflection warning, %s:%d - call to %s can't be resolved.\n", SOURCE_PATH.deref(), line, methodName);
            }
        }

        public Object eval() throws Exception {
            try {
                Object[] argvals = new Object[this.args.count()];
                for (int i = 0; i < this.args.count(); ++i) {
                    argvals[i] = ((Expr)this.args.nth(i)).eval();
                }
                if (this.method != null) {
                    LinkedList<Method> ms = new LinkedList<Method>();
                    ms.add(this.method);
                    return Reflector.invokeMatchingMethod(this.methodName, ms, null, argvals);
                }
                return Reflector.invokeStaticMethod(this.c, this.methodName, argvals);
            }
            catch (Throwable e2) {
                if (!(e2 instanceof CompilerException)) {
                    throw new CompilerException(this.source, this.line, e2);
                }
                throw (CompilerException)e2;
            }
        }

        public boolean canEmitPrimitive() {
            return this.method != null && Util.isPrimitive(this.method.getReturnType());
        }

        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            if (this.method != null) {
                MethodExpr.emitTypedArgs(objx, gen, this.method.getParameterTypes(), this.args);
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
            } else {
                throw new UnsupportedOperationException("Unboxed emit of unknown member");
            }
            Type type2 = Type.getType(this.c);
            clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.methodName, Type.getReturnType(this.method), Type.getArgumentTypes(this.method));
            gen.invokeStatic(type2, m);
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            if (this.method != null) {
                MethodExpr.emitTypedArgs(objx, gen, this.method.getParameterTypes(), this.args);
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                Type type2 = Type.getType(this.c);
                clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.methodName, Type.getReturnType(this.method), Type.getArgumentTypes(this.method));
                gen.invokeStatic(type2, m);
                HostExpr.emitBoxReturn(objx, gen, this.method.getReturnType());
            } else {
                gen.push(this.c.getName());
                gen.invokeStatic(CLASS_TYPE, forNameMethod);
                gen.push(this.methodName);
                StaticMethodExpr.emitArgsAsArray(this.args, objx, gen);
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                gen.invokeStatic(REFLECTOR_TYPE, invokeStaticMethodMethod);
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return this.method != null || this.tag != null;
        }

        public Class getJavaClass() throws Exception {
            return this.tag != null ? HostExpr.tagToClass(this.tag) : this.method.getReturnType();
        }
    }

    static class InstanceMethodExpr
    extends MethodExpr {
        public final Expr target;
        public final String methodName;
        public final IPersistentVector args;
        public final String source;
        public final int line;
        public final Symbol tag;
        public final Method method;
        static final clojure.asm.commons.Method invokeInstanceMethodMethod = clojure.asm.commons.Method.getMethod("Object invokeInstanceMethod(Object,String,Object[])");

        public InstanceMethodExpr(String source2, int line, Symbol tag, Expr target, String methodName, IPersistentVector args) throws Exception {
            this.source = source2;
            this.line = line;
            this.args = args;
            this.methodName = methodName;
            this.target = target;
            this.tag = tag;
            if (target.hasJavaClass() && target.getJavaClass() != null) {
                List methods2 = Reflector.getMethods(target.getJavaClass(), args.count(), methodName, false);
                if (methods2.isEmpty()) {
                    this.method = null;
                } else {
                    Method m;
                    int methodidx = 0;
                    if (methods2.size() > 1) {
                        ArrayList<Class[]> params = new ArrayList<Class[]>();
                        ArrayList<Class> rets = new ArrayList<Class>();
                        for (int i = 0; i < methods2.size(); ++i) {
                            Method m2 = (Method)methods2.get(i);
                            params.add(m2.getParameterTypes());
                            rets.add(m2.getReturnType());
                        }
                        methodidx = Compiler.getMatchingParams(methodName, params, args, rets);
                    }
                    if ((m = (Method)(methodidx >= 0 ? methods2.get(methodidx) : null)) != null && !Modifier.isPublic(m.getDeclaringClass().getModifiers())) {
                        m = Reflector.getAsMethodOfPublicBase(m.getDeclaringClass(), m);
                    }
                    this.method = m;
                }
            } else {
                this.method = null;
            }
            if (this.method == null && RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                RT.errPrintWriter().format("Reflection warning, %s:%d - call to %s can't be resolved.\n", SOURCE_PATH.deref(), line, methodName);
            }
        }

        public Object eval() throws Exception {
            try {
                Object targetval = this.target.eval();
                Object[] argvals = new Object[this.args.count()];
                for (int i = 0; i < this.args.count(); ++i) {
                    argvals[i] = ((Expr)this.args.nth(i)).eval();
                }
                if (this.method != null) {
                    LinkedList<Method> ms = new LinkedList<Method>();
                    ms.add(this.method);
                    return Reflector.invokeMatchingMethod(this.methodName, ms, targetval, argvals);
                }
                return Reflector.invokeInstanceMethod(targetval, this.methodName, argvals);
            }
            catch (Throwable e2) {
                if (!(e2 instanceof CompilerException)) {
                    throw new CompilerException(this.source, this.line, e2);
                }
                throw (CompilerException)e2;
            }
        }

        public boolean canEmitPrimitive() {
            return this.method != null && Util.isPrimitive(this.method.getReturnType());
        }

        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            if (this.method != null) {
                Type type2 = Type.getType(this.method.getDeclaringClass());
                this.target.emit(C.EXPRESSION, objx, gen);
                gen.checkCast(type2);
                MethodExpr.emitTypedArgs(objx, gen, this.method.getParameterTypes(), this.args);
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.methodName, Type.getReturnType(this.method), Type.getArgumentTypes(this.method));
                if (this.method.getDeclaringClass().isInterface()) {
                    gen.invokeInterface(type2, m);
                } else {
                    gen.invokeVirtual(type2, m);
                }
            } else {
                throw new UnsupportedOperationException("Unboxed emit of unknown member");
            }
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            if (this.method != null) {
                Type type2 = Type.getType(this.method.getDeclaringClass());
                this.target.emit(C.EXPRESSION, objx, gen);
                gen.checkCast(type2);
                MethodExpr.emitTypedArgs(objx, gen, this.method.getParameterTypes(), this.args);
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.methodName, Type.getReturnType(this.method), Type.getArgumentTypes(this.method));
                if (this.method.getDeclaringClass().isInterface()) {
                    gen.invokeInterface(type2, m);
                } else {
                    gen.invokeVirtual(type2, m);
                }
                HostExpr.emitBoxReturn(objx, gen, this.method.getReturnType());
            } else {
                this.target.emit(C.EXPRESSION, objx, gen);
                gen.push(this.methodName);
                InstanceMethodExpr.emitArgsAsArray(this.args, objx, gen);
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                gen.invokeStatic(REFLECTOR_TYPE, invokeInstanceMethodMethod);
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return this.method != null || this.tag != null;
        }

        public Class getJavaClass() throws Exception {
            return this.tag != null ? HostExpr.tagToClass(this.tag) : this.method.getReturnType();
        }
    }

    static abstract class MethodExpr
    extends HostExpr {
        MethodExpr() {
        }

        static void emitArgsAsArray(IPersistentVector args, ObjExpr objx, GeneratorAdapter gen) {
            gen.push(args.count());
            gen.newArray(OBJECT_TYPE);
            for (int i = 0; i < args.count(); ++i) {
                gen.dup();
                gen.push(i);
                ((Expr)args.nth(i)).emit(C.EXPRESSION, objx, gen);
                gen.arrayStore(OBJECT_TYPE);
            }
        }

        public static void emitTypedArgs(ObjExpr objx, GeneratorAdapter gen, Class[] parameterTypes, IPersistentVector args) {
            for (int i = 0; i < parameterTypes.length; ++i) {
                Expr e2 = (Expr)args.nth(i);
                try {
                    if (Compiler.maybePrimitiveType(e2) == parameterTypes[i]) {
                        ((MaybePrimitiveExpr)e2).emitUnboxed(C.EXPRESSION, objx, gen);
                        continue;
                    }
                    e2.emit(C.EXPRESSION, objx, gen);
                    HostExpr.emitUnboxArg(objx, gen, parameterTypes[i]);
                    continue;
                }
                catch (Exception e1) {
                    e1.printStackTrace(RT.errPrintWriter());
                }
            }
        }
    }

    static class StaticFieldExpr
    extends FieldExpr
    implements AssignableExpr {
        public final String fieldName;
        public final Class c;
        public final Field field;
        public final Symbol tag;
        final int line;

        public StaticFieldExpr(int line, Class c, String fieldName, Symbol tag) throws Exception {
            this.fieldName = fieldName;
            this.line = line;
            this.c = c;
            this.field = c.getField(fieldName);
            this.tag = tag;
        }

        public Object eval() throws Exception {
            return Reflector.getStaticField(this.c, this.fieldName);
        }

        public boolean canEmitPrimitive() {
            return Util.isPrimitive(this.field.getType());
        }

        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            gen.getStatic(Type.getType(this.c), this.fieldName, Type.getType(this.field.getType()));
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            gen.getStatic(Type.getType(this.c), this.fieldName, Type.getType(this.field.getType()));
            HostExpr.emitBoxReturn(objx, gen, this.field.getType());
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return this.tag != null ? HostExpr.tagToClass(this.tag) : this.field.getType();
        }

        public Object evalAssign(Expr val2) throws Exception {
            return Reflector.setStaticField(this.c, this.fieldName, val2.eval());
        }

        public void emitAssign(C context, ObjExpr objx, GeneratorAdapter gen, Expr val2) {
            gen.visitLineNumber(this.line, gen.mark());
            val2.emit(C.EXPRESSION, objx, gen);
            gen.dup();
            HostExpr.emitUnboxArg(objx, gen, this.field.getType());
            gen.putStatic(Type.getType(this.c), this.fieldName, Type.getType(this.field.getType()));
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }
    }

    static class InstanceFieldExpr
    extends FieldExpr
    implements AssignableExpr {
        public final Expr target;
        public final Class targetClass;
        public final Field field;
        public final String fieldName;
        public final int line;
        public final Symbol tag;
        static final clojure.asm.commons.Method invokeNoArgInstanceMember = clojure.asm.commons.Method.getMethod("Object invokeNoArgInstanceMember(Object,String)");
        static final clojure.asm.commons.Method setInstanceFieldMethod = clojure.asm.commons.Method.getMethod("Object setInstanceField(Object,String,Object)");

        public InstanceFieldExpr(int line, Expr target, String fieldName, Symbol tag) throws Exception {
            this.target = target;
            this.targetClass = target.hasJavaClass() ? target.getJavaClass() : null;
            this.field = this.targetClass != null ? Reflector.getField(this.targetClass, fieldName, false) : null;
            this.fieldName = fieldName;
            this.line = line;
            this.tag = tag;
            if (this.field == null && RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                RT.errPrintWriter().format("Reflection warning, %s:%d - reference to field %s can't be resolved.\n", SOURCE_PATH.deref(), line, fieldName);
            }
        }

        public Object eval() throws Exception {
            return Reflector.invokeNoArgInstanceMember(this.target.eval(), this.fieldName);
        }

        public boolean canEmitPrimitive() {
            return this.targetClass != null && this.field != null && Util.isPrimitive(this.field.getType());
        }

        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            if (this.targetClass == null || this.field == null) {
                throw new UnsupportedOperationException("Unboxed emit of unknown member");
            }
            this.target.emit(C.EXPRESSION, objx, gen);
            gen.checkCast(Compiler.getType(this.targetClass));
            gen.getField(Compiler.getType(this.targetClass), this.fieldName, Type.getType(this.field.getType()));
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            if (this.targetClass != null && this.field != null) {
                this.target.emit(C.EXPRESSION, objx, gen);
                gen.checkCast(Compiler.getType(this.targetClass));
                gen.getField(Compiler.getType(this.targetClass), this.fieldName, Type.getType(this.field.getType()));
                HostExpr.emitBoxReturn(objx, gen, this.field.getType());
                if (context == C.STATEMENT) {
                    gen.pop();
                }
            } else {
                this.target.emit(C.EXPRESSION, objx, gen);
                gen.push(this.fieldName);
                gen.invokeStatic(REFLECTOR_TYPE, invokeNoArgInstanceMember);
                if (context == C.STATEMENT) {
                    gen.pop();
                }
            }
        }

        public boolean hasJavaClass() throws Exception {
            return this.field != null || this.tag != null;
        }

        public Class getJavaClass() throws Exception {
            return this.tag != null ? HostExpr.tagToClass(this.tag) : this.field.getType();
        }

        public Object evalAssign(Expr val2) throws Exception {
            return Reflector.setInstanceField(this.target.eval(), this.fieldName, val2.eval());
        }

        public void emitAssign(C context, ObjExpr objx, GeneratorAdapter gen, Expr val2) {
            gen.visitLineNumber(this.line, gen.mark());
            if (this.targetClass != null && this.field != null) {
                this.target.emit(C.EXPRESSION, objx, gen);
                gen.checkCast(Type.getType(this.targetClass));
                val2.emit(C.EXPRESSION, objx, gen);
                gen.dupX1();
                HostExpr.emitUnboxArg(objx, gen, this.field.getType());
                gen.putField(Type.getType(this.targetClass), this.fieldName, Type.getType(this.field.getType()));
            } else {
                this.target.emit(C.EXPRESSION, objx, gen);
                gen.push(this.fieldName);
                val2.emit(C.EXPRESSION, objx, gen);
                gen.invokeStatic(REFLECTOR_TYPE, setInstanceFieldMethod);
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }
    }

    static abstract class FieldExpr
    extends HostExpr {
        FieldExpr() {
        }
    }

    public static abstract class HostExpr
    implements Expr,
    MaybePrimitiveExpr {
        static final Type BOOLEAN_TYPE = Type.getType(Boolean.class);
        static final Type CHAR_TYPE = Type.getType(Character.class);
        static final Type INTEGER_TYPE = Type.getType(Integer.class);
        static final Type LONG_TYPE = Type.getType(Long.class);
        static final Type FLOAT_TYPE = Type.getType(Float.class);
        static final Type DOUBLE_TYPE = Type.getType(Double.class);
        static final Type SHORT_TYPE = Type.getType(Short.class);
        static final Type BYTE_TYPE = Type.getType(Byte.class);
        static final Type NUMBER_TYPE = Type.getType(Number.class);
        static final clojure.asm.commons.Method charValueMethod = clojure.asm.commons.Method.getMethod("char charValue()");
        static final clojure.asm.commons.Method booleanValueMethod = clojure.asm.commons.Method.getMethod("boolean booleanValue()");
        static final clojure.asm.commons.Method charValueOfMethod = clojure.asm.commons.Method.getMethod("Character valueOf(char)");
        static final clojure.asm.commons.Method intValueOfMethod = clojure.asm.commons.Method.getMethod("Integer valueOf(int)");
        static final clojure.asm.commons.Method longValueOfMethod = clojure.asm.commons.Method.getMethod("Long valueOf(long)");
        static final clojure.asm.commons.Method floatValueOfMethod = clojure.asm.commons.Method.getMethod("Float valueOf(float)");
        static final clojure.asm.commons.Method doubleValueOfMethod = clojure.asm.commons.Method.getMethod("Double valueOf(double)");
        static final clojure.asm.commons.Method shortValueOfMethod = clojure.asm.commons.Method.getMethod("Short valueOf(short)");
        static final clojure.asm.commons.Method byteValueOfMethod = clojure.asm.commons.Method.getMethod("Byte valueOf(byte)");
        static final clojure.asm.commons.Method intValueMethod = clojure.asm.commons.Method.getMethod("int intValue()");
        static final clojure.asm.commons.Method longValueMethod = clojure.asm.commons.Method.getMethod("long longValue()");
        static final clojure.asm.commons.Method floatValueMethod = clojure.asm.commons.Method.getMethod("float floatValue()");
        static final clojure.asm.commons.Method doubleValueMethod = clojure.asm.commons.Method.getMethod("double doubleValue()");
        static final clojure.asm.commons.Method byteValueMethod = clojure.asm.commons.Method.getMethod("byte byteValue()");
        static final clojure.asm.commons.Method shortValueMethod = clojure.asm.commons.Method.getMethod("short shortValue()");
        static final clojure.asm.commons.Method fromIntMethod = clojure.asm.commons.Method.getMethod("clojure.lang.Num from(int)");
        static final clojure.asm.commons.Method fromLongMethod = clojure.asm.commons.Method.getMethod("clojure.lang.Num from(long)");
        static final clojure.asm.commons.Method fromDoubleMethod = clojure.asm.commons.Method.getMethod("clojure.lang.Num from(double)");

        public static void emitBoxReturn(ObjExpr objx, GeneratorAdapter gen, Class returnType) {
            if (returnType.isPrimitive()) {
                if (returnType == Boolean.TYPE) {
                    Label falseLabel = gen.newLabel();
                    Label endLabel = gen.newLabel();
                    gen.ifZCmp(153, falseLabel);
                    gen.getStatic(BOOLEAN_OBJECT_TYPE, "TRUE", BOOLEAN_OBJECT_TYPE);
                    gen.goTo(endLabel);
                    gen.mark(falseLabel);
                    gen.getStatic(BOOLEAN_OBJECT_TYPE, "FALSE", BOOLEAN_OBJECT_TYPE);
                    gen.mark(endLabel);
                } else if (returnType == Void.TYPE) {
                    NIL_EXPR.emit(C.EXPRESSION, objx, gen);
                } else if (returnType == Character.TYPE) {
                    gen.invokeStatic(CHAR_TYPE, charValueOfMethod);
                } else if (returnType == Integer.TYPE) {
                    gen.invokeStatic(INTEGER_TYPE, intValueOfMethod);
                } else if (returnType == Float.TYPE) {
                    gen.invokeStatic(FLOAT_TYPE, floatValueOfMethod);
                } else if (returnType == Double.TYPE) {
                    gen.invokeStatic(DOUBLE_TYPE, doubleValueOfMethod);
                } else if (returnType == Long.TYPE) {
                    gen.invokeStatic(LONG_TYPE, longValueOfMethod);
                } else if (returnType == Byte.TYPE) {
                    gen.invokeStatic(BYTE_TYPE, byteValueOfMethod);
                } else if (returnType == Short.TYPE) {
                    gen.invokeStatic(SHORT_TYPE, shortValueOfMethod);
                }
            }
        }

        public static void emitUnboxArg(ObjExpr objx, GeneratorAdapter gen, Class paramType) {
            if (paramType.isPrimitive()) {
                if (paramType == Boolean.TYPE) {
                    gen.checkCast(BOOLEAN_TYPE);
                    gen.invokeVirtual(BOOLEAN_TYPE, booleanValueMethod);
                } else if (paramType == Character.TYPE) {
                    gen.checkCast(CHAR_TYPE);
                    gen.invokeVirtual(CHAR_TYPE, charValueMethod);
                } else {
                    clojure.asm.commons.Method m = intValueMethod;
                    gen.checkCast(NUMBER_TYPE);
                    if (paramType == Integer.TYPE) {
                        m = intValueMethod;
                    } else if (paramType == Float.TYPE) {
                        m = floatValueMethod;
                    } else if (paramType == Double.TYPE) {
                        m = doubleValueMethod;
                    } else if (paramType == Long.TYPE) {
                        m = longValueMethod;
                    } else if (paramType == Byte.TYPE) {
                        m = byteValueMethod;
                    } else if (paramType == Short.TYPE) {
                        m = shortValueMethod;
                    }
                    gen.invokeVirtual(NUMBER_TYPE, m);
                }
            } else {
                gen.checkCast(Type.getType(paramType));
            }
        }

        private static Class maybeClass(Object form, boolean stringOk) throws Exception {
            if (form instanceof Class) {
                return (Class)form;
            }
            Class c = null;
            if (form instanceof Symbol) {
                Symbol sym = (Symbol)form;
                if (sym.ns == null) {
                    if (Util.equals(sym, COMPILE_STUB_SYM.get())) {
                        return (Class)COMPILE_STUB_CLASS.get();
                    }
                    if (sym.name.indexOf(46) > 0 || sym.name.charAt(0) == '[') {
                        c = RT.classForName(sym.name);
                    } else {
                        Object o = Compiler.currentNS().getMapping(sym);
                        if (o instanceof Class) {
                            c = (Class)o;
                        }
                    }
                }
            } else if (stringOk && form instanceof String) {
                c = RT.classForName((String)form);
            }
            return c;
        }

        static Class tagToClass(Object tag) throws Exception {
            Class<Object[]> c = HostExpr.maybeClass(tag, true);
            if (tag instanceof Symbol) {
                Symbol sym = (Symbol)tag;
                if (sym.ns == null) {
                    if (sym.name.equals("objects")) {
                        c = Object[].class;
                    } else if (sym.name.equals("ints")) {
                        c = int[].class;
                    } else if (sym.name.equals("longs")) {
                        c = long[].class;
                    } else if (sym.name.equals("floats")) {
                        c = float[].class;
                    } else if (sym.name.equals("doubles")) {
                        c = double[].class;
                    } else if (sym.name.equals("chars")) {
                        c = char[].class;
                    } else if (sym.name.equals("shorts")) {
                        c = short[].class;
                    } else if (sym.name.equals("bytes")) {
                        c = byte[].class;
                    } else if (sym.name.equals("booleans")) {
                        c = boolean[].class;
                    }
                }
            }
            if (c != null) {
                return c;
            }
            throw new IllegalArgumentException("Unable to resolve classname: " + tag);
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object frm) throws Exception {
                Symbol sym;
                boolean maybeField;
                ISeq form = (ISeq)frm;
                if (RT.length(form) < 3) {
                    throw new IllegalArgumentException("Malformed member expression, expecting (. target member ...)");
                }
                int line = (Integer)LINE.deref();
                String source2 = (String)SOURCE.deref();
                Class c = HostExpr.maybeClass(RT.second(form), false);
                Expr instance = null;
                if (c == null) {
                    instance = Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, RT.second(form));
                }
                boolean bl = maybeField = RT.length(form) == 3 && (RT.third(form) instanceof Symbol || RT.third(form) instanceof Keyword);
                if (maybeField && !(RT.third(form) instanceof Keyword)) {
                    sym = (Symbol)RT.third(form);
                    if (c != null) {
                        maybeField = Reflector.getMethods(c, 0, Compiler.munge(sym.name), true).size() == 0;
                    } else if (instance != null && instance.hasJavaClass() && instance.getJavaClass() != null) {
                        boolean bl2 = maybeField = Reflector.getMethods(instance.getJavaClass(), 0, Compiler.munge(sym.name), false).size() == 0;
                    }
                }
                if (maybeField) {
                    sym = RT.third(form) instanceof Keyword ? ((Keyword)RT.third((Object)form)).sym : (Symbol)RT.third(form);
                    Symbol tag = Compiler.tagOf(form);
                    if (c != null) {
                        return new StaticFieldExpr(line, c, Compiler.munge(sym.name), tag);
                    }
                    return new InstanceFieldExpr(line, instance, Compiler.munge(sym.name), tag);
                }
                ISeq call = (ISeq)(RT.third(form) instanceof ISeq ? RT.third(form) : RT.next(RT.next(form)));
                if (!(RT.first(call) instanceof Symbol)) {
                    throw new IllegalArgumentException("Malformed member expression");
                }
                Symbol sym2 = (Symbol)RT.first(call);
                Symbol tag = Compiler.tagOf(form);
                PersistentVector args = PersistentVector.EMPTY;
                for (ISeq s = RT.next(call); s != null; s = s.next()) {
                    args = args.cons(Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, s.first()));
                }
                if (c != null) {
                    return new StaticMethodExpr(source2, line, tag, c, Compiler.munge(sym2.name), args);
                }
                return new InstanceMethodExpr(source2, line, tag, instance, Compiler.munge(sym2.name), args);
            }
        }
    }

    public static interface MaybePrimitiveExpr
    extends Expr {
        public boolean canEmitPrimitive();

        public void emitUnboxed(C var1, ObjExpr var2, GeneratorAdapter var3);
    }

    static interface AssignableExpr {
        public Object evalAssign(Expr var1) throws Exception;

        public void emitAssign(C var1, ObjExpr var2, GeneratorAdapter var3, Expr var4);
    }

    public static abstract class LiteralExpr
    implements Expr {
        abstract Object val();

        public Object eval() {
            return this.val();
        }
    }

    public static class ImportExpr
    implements Expr {
        public final String c;
        static final clojure.asm.commons.Method forNameMethod = clojure.asm.commons.Method.getMethod("Class forName(String)");
        static final clojure.asm.commons.Method importClassMethod = clojure.asm.commons.Method.getMethod("Class importClass(Class)");
        static final clojure.asm.commons.Method derefMethod = clojure.asm.commons.Method.getMethod("Object deref()");

        public ImportExpr(String c) {
            this.c = c;
        }

        public Object eval() throws Exception {
            Namespace ns2 = (Namespace)RT.CURRENT_NS.deref();
            ns2.importClass(RT.classForName(this.c));
            return null;
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.getStatic(RT_TYPE, "CURRENT_NS", VAR_TYPE);
            gen.invokeVirtual(VAR_TYPE, derefMethod);
            gen.checkCast(NS_TYPE);
            gen.push(this.c);
            gen.invokeStatic(CLASS_TYPE, forNameMethod);
            gen.invokeVirtual(NS_TYPE, importClassMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return false;
        }

        public Class getJavaClass() throws ClassNotFoundException {
            throw new IllegalArgumentException("ImportExpr has no Java class");
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object form) throws Exception {
                return new ImportExpr((String)RT.second(form));
            }
        }
    }

    public static class KeywordExpr
    implements Expr {
        public final Keyword k;

        public KeywordExpr(Keyword k) {
            this.k = k;
        }

        public Object eval() throws Exception {
            return this.k;
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            objx.emitKeyword(gen, this.k);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return true;
        }

        public Class getJavaClass() throws ClassNotFoundException {
            return Keyword.class;
        }
    }

    public static class TheVarExpr
    implements Expr {
        public final Var var;

        public TheVarExpr(Var var) {
            this.var = var;
        }

        public Object eval() throws Exception {
            return this.var;
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            objx.emitVar(gen, this.var);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return true;
        }

        public Class getJavaClass() throws ClassNotFoundException {
            return Var.class;
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object form) throws Exception {
                Symbol sym = (Symbol)RT.second(form);
                Var v = Compiler.lookupVar(sym, false);
                if (v != null) {
                    return new TheVarExpr(v);
                }
                throw new Exception("Unable to resolve var: " + sym + " in this context");
            }
        }
    }

    public static class VarExpr
    implements Expr,
    AssignableExpr {
        public final Var var;
        public final Object tag;
        static final clojure.asm.commons.Method getMethod = clojure.asm.commons.Method.getMethod("Object get()");
        static final clojure.asm.commons.Method setMethod = clojure.asm.commons.Method.getMethod("Object set(Object)");

        public VarExpr(Var var, Symbol tag) {
            this.var = var;
            this.tag = tag != null ? tag : var.getTag();
        }

        public Object eval() throws Exception {
            return this.var.deref();
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            objx.emitVar(gen, this.var);
            gen.invokeVirtual(VAR_TYPE, getMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return this.tag != null;
        }

        public Class getJavaClass() throws Exception {
            return HostExpr.tagToClass(this.tag);
        }

        public Object evalAssign(Expr val2) throws Exception {
            return this.var.set(val2.eval());
        }

        public void emitAssign(C context, ObjExpr objx, GeneratorAdapter gen, Expr val2) {
            objx.emitVar(gen, this.var);
            val2.emit(C.EXPRESSION, objx, gen);
            gen.invokeVirtual(VAR_TYPE, setMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }
    }

    public static class AssignExpr
    implements Expr {
        public final AssignableExpr target;
        public final Expr val;

        public AssignExpr(AssignableExpr target, Expr val2) {
            this.target = target;
            this.val = val2;
        }

        public Object eval() throws Exception {
            return this.target.evalAssign(this.val);
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.target.emitAssign(context, objx, gen, this.val);
        }

        public boolean hasJavaClass() throws Exception {
            return this.val.hasJavaClass();
        }

        public Class getJavaClass() throws Exception {
            return this.val.getJavaClass();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object frm) throws Exception {
                ISeq form = (ISeq)frm;
                if (RT.length(form) != 3) {
                    throw new IllegalArgumentException("Malformed assignment, expecting (set! target val)");
                }
                Expr target = Compiler.analyze(C.EXPRESSION, RT.second(form));
                if (!(target instanceof AssignableExpr)) {
                    throw new IllegalArgumentException("Invalid assignment target");
                }
                return new AssignExpr((AssignableExpr)((Object)target), Compiler.analyze(C.EXPRESSION, RT.third(form)));
            }
        }
    }

    static class DefExpr
    implements Expr {
        public final Var var;
        public final Expr init;
        public final Expr meta;
        public final boolean initProvided;
        public final String source;
        public final int line;
        static final clojure.asm.commons.Method bindRootMethod = clojure.asm.commons.Method.getMethod("void bindRoot(Object)");
        static final clojure.asm.commons.Method setTagMethod = clojure.asm.commons.Method.getMethod("void setTag(clojure.lang.Symbol)");
        static final clojure.asm.commons.Method setMetaMethod = clojure.asm.commons.Method.getMethod("void setMeta(clojure.lang.IPersistentMap)");
        static final clojure.asm.commons.Method symcreate = clojure.asm.commons.Method.getMethod("clojure.lang.Symbol create(String, String)");

        public DefExpr(String source2, int line, Var var, Expr init, Expr meta2, boolean initProvided) {
            this.source = source2;
            this.line = line;
            this.var = var;
            this.init = init;
            this.meta = meta2;
            this.initProvided = initProvided;
        }

        private boolean includesExplicitMetadata(MapExpr expr) {
            for (int i = 0; i < expr.keyvals.count(); i += 2) {
                Keyword k = ((KeywordExpr)expr.keyvals.nth((int)i)).k;
                if (k == RT.FILE_KEY || k == RT.DECLARED_KEY || k == RT.LINE_KEY) continue;
                return true;
            }
            return false;
        }

        public Object eval() throws Exception {
            try {
                if (this.initProvided) {
                    this.var.bindRoot(this.init.eval());
                }
                if (this.meta != null) {
                    IPersistentMap metaMap = (IPersistentMap)this.meta.eval();
                    if (this.initProvided || this.includesExplicitMetadata((MapExpr)this.meta)) {
                        this.var.setMeta((IPersistentMap)this.meta.eval());
                    }
                }
                return this.var;
            }
            catch (Throwable e2) {
                if (!(e2 instanceof CompilerException)) {
                    throw new CompilerException(this.source, this.line, e2);
                }
                throw (CompilerException)e2;
            }
        }

        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            objx.emitVar(gen, this.var);
            if (this.meta != null && (this.initProvided || this.includesExplicitMetadata((MapExpr)this.meta))) {
                gen.dup();
                this.meta.emit(C.EXPRESSION, objx, gen);
                gen.checkCast(IPERSISTENTMAP_TYPE);
                gen.invokeVirtual(VAR_TYPE, setMetaMethod);
            }
            if (this.initProvided) {
                gen.dup();
                this.init.emit(C.EXPRESSION, objx, gen);
                gen.invokeVirtual(VAR_TYPE, bindRootMethod);
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return true;
        }

        public Class getJavaClass() {
            return Var.class;
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object form) throws Exception {
                if (RT.count(form) > 3) {
                    throw new Exception("Too many arguments to def");
                }
                if (RT.count(form) < 2) {
                    throw new Exception("Too few arguments to def");
                }
                if (!(RT.second(form) instanceof Symbol)) {
                    throw new Exception("First argument to def must be a Symbol");
                }
                Symbol sym = (Symbol)RT.second(form);
                Var v = Compiler.lookupVar(sym, true);
                if (v == null) {
                    throw new Exception("Can't refer to qualified var that doesn't exist");
                }
                if (!v.ns.equals(Compiler.currentNS())) {
                    if (sym.ns == null) {
                        v = Compiler.currentNS().intern(sym);
                    } else {
                        throw new Exception("Can't create defs outside of current ns");
                    }
                }
                IPersistentMap mm = sym.meta();
                Object source_path = SOURCE_PATH.get();
                source_path = source_path == null ? "NO_SOURCE_FILE" : source_path;
                mm = (IPersistentMap)RT.assoc(mm, RT.LINE_KEY, LINE.get()).assoc(RT.FILE_KEY, source_path);
                Expr meta2 = Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, mm);
                return new DefExpr((String)SOURCE.deref(), (Integer)LINE.deref(), v, Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, RT.third(form), v.sym.name), meta2, RT.count(form) == 3);
            }
        }
    }

    static interface IParser {
        public Expr parse(C var1, Object var2) throws Exception;
    }

    public static abstract class UntypedExpr
    implements Expr {
        public Class getJavaClass() {
            throw new IllegalArgumentException("Has no Java class");
        }

        public boolean hasJavaClass() {
            return false;
        }
    }

    static interface Expr {
        public Object eval() throws Exception;

        public void emit(C var1, ObjExpr var2, GeneratorAdapter var3);

        public boolean hasJavaClass() throws Exception;

        public Class getJavaClass() throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum C {
        STATEMENT,
        EXPRESSION,
        RETURN,
        EVAL;

    }
}

