// Compiled by ClojureScript 1.10.773 {}
goog.provide('planning.core');
goog.require('cljs.core');
goog.require('cljs.pprint');
goog.require('tailrecursion.priority_map');
planning.core.empty_queue = cljs.core.into.call(null,cljs.core.PersistentQueue.EMPTY,cljs.core.PersistentVector.EMPTY);
planning.core.update_frontier = (function planning$core$update_frontier(m,additions){
return cljs.core.update.call(null,m,new cljs.core.Keyword(null,"frontier","frontier",-1129931910),(function (p1__26127_SHARP_){
return cljs.core.into.call(null,cljs.core.pop.call(null,p1__26127_SHARP_),additions);
}));
});
planning.core.update_visited = (function planning$core$update_visited(m,from_state,new_neighbors){
return cljs.core.update.call(null,m,new cljs.core.Keyword(null,"visited","visited",-1610853875),cljs.core.into,cljs.core.zipmap.call(null,new_neighbors,cljs.core.repeat.call(null,from_state)));
});
planning.core.bd_search_step = (function planning$core$bd_search_step(p__26129){
var map__26130 = p__26129;
var map__26130__$1 = (((((!((map__26130 == null))))?(((((map__26130.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26130.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26130):map__26130);
var m = map__26130__$1;
var neighbors_fn = cljs.core.get.call(null,map__26130__$1,new cljs.core.Keyword(null,"neighbors-fn","neighbors-fn",-373853145));
var frontier = cljs.core.get.call(null,map__26130__$1,new cljs.core.Keyword(null,"frontier","frontier",-1129931910));
var visited = cljs.core.get.call(null,map__26130__$1,new cljs.core.Keyword(null,"visited","visited",-1610853875));
var current_state = cljs.core.peek.call(null,frontier);
var new_neighbors = cljs.core.remove.call(null,(function (p1__26128_SHARP_){
return cljs.core.contains_QMARK_.call(null,visited,p1__26128_SHARP_);
}),neighbors_fn.call(null,current_state));
return planning.core.update_visited.call(null,planning.core.update_frontier.call(null,m,new_neighbors),current_state,new_neighbors);
});
planning.core.greedy_breadth_first_step = (function planning$core$greedy_breadth_first_step(p__26133){
var map__26134 = p__26133;
var map__26134__$1 = (((((!((map__26134 == null))))?(((((map__26134.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26134.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26134):map__26134);
var m = map__26134__$1;
var neighbors_fn = cljs.core.get.call(null,map__26134__$1,new cljs.core.Keyword(null,"neighbors-fn","neighbors-fn",-373853145));
var heuristic_fn = cljs.core.get.call(null,map__26134__$1,new cljs.core.Keyword(null,"heuristic-fn","heuristic-fn",-699598101));
var goal = cljs.core.get.call(null,map__26134__$1,new cljs.core.Keyword(null,"goal","goal",-2073396501));
var frontier = cljs.core.get.call(null,map__26134__$1,new cljs.core.Keyword(null,"frontier","frontier",-1129931910));
var visited = cljs.core.get.call(null,map__26134__$1,new cljs.core.Keyword(null,"visited","visited",-1610853875));
var vec__26136 = cljs.core.peek.call(null,frontier);
var current_state = cljs.core.nth.call(null,vec__26136,(0),null);
var new_neighbors = cljs.core.remove.call(null,(function (p1__26132_SHARP_){
return cljs.core.contains_QMARK_.call(null,visited,p1__26132_SHARP_);
}),neighbors_fn.call(null,current_state));
var estimates = (function (){var iter__4529__auto__ = (function planning$core$greedy_breadth_first_step_$_iter__26139(s__26140){
return (new cljs.core.LazySeq(null,(function (){
var s__26140__$1 = s__26140;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__26140__$1);
if(temp__5735__auto__){
var s__26140__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__26140__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__26140__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__26142 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__26141 = (0);
while(true){
if((i__26141 < size__4528__auto__)){
var n = cljs.core._nth.call(null,c__4527__auto__,i__26141);
cljs.core.chunk_append.call(null,b__26142,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [n,heuristic_fn.call(null,goal,n)], null));

var G__26143 = (i__26141 + (1));
i__26141 = G__26143;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26142),planning$core$greedy_breadth_first_step_$_iter__26139.call(null,cljs.core.chunk_rest.call(null,s__26140__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26142),null);
}
} else {
var n = cljs.core.first.call(null,s__26140__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [n,heuristic_fn.call(null,goal,n)], null),planning$core$greedy_breadth_first_step_$_iter__26139.call(null,cljs.core.rest.call(null,s__26140__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,new_neighbors);
})();
return planning.core.update_visited.call(null,planning.core.update_frontier.call(null,m,estimates),current_state,new_neighbors);
});
planning.core.neighbors_with_costs = (function planning$core$neighbors_with_costs(p__26144){
var map__26145 = p__26144;
var map__26145__$1 = (((((!((map__26145 == null))))?(((((map__26145.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26145.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26145):map__26145);
var frontier = cljs.core.get.call(null,map__26145__$1,new cljs.core.Keyword(null,"frontier","frontier",-1129931910));
var neighbors_fn = cljs.core.get.call(null,map__26145__$1,new cljs.core.Keyword(null,"neighbors-fn","neighbors-fn",-373853145));
var cost_fn = cljs.core.get.call(null,map__26145__$1,new cljs.core.Keyword(null,"cost-fn","cost-fn",1972507749));
var costs = cljs.core.get.call(null,map__26145__$1,new cljs.core.Keyword(null,"costs","costs",2093295309));
var visited = cljs.core.get.call(null,map__26145__$1,new cljs.core.Keyword(null,"visited","visited",-1610853875));
var vec__26147 = cljs.core.peek.call(null,frontier);
var current_state = cljs.core.nth.call(null,vec__26147,(0),null);
var iter__4529__auto__ = (function planning$core$neighbors_with_costs_$_iter__26150(s__26151){
return (new cljs.core.LazySeq(null,(function (){
var s__26151__$1 = s__26151;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__26151__$1);
if(temp__5735__auto__){
var s__26151__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__26151__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__26151__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__26153 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__26152 = (0);
while(true){
if((i__26152 < size__4528__auto__)){
var neighbor = cljs.core._nth.call(null,c__4527__auto__,i__26152);
var new_cost = (costs.call(null,current_state) + cost_fn.call(null,current_state,neighbor));
var old_cost = costs.call(null,neighbor,Infinity);
if((new_cost < old_cost)){
cljs.core.chunk_append.call(null,b__26153,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [neighbor,new_cost], null));

var G__26154 = (i__26152 + (1));
i__26152 = G__26154;
continue;
} else {
var G__26155 = (i__26152 + (1));
i__26152 = G__26155;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26153),planning$core$neighbors_with_costs_$_iter__26150.call(null,cljs.core.chunk_rest.call(null,s__26151__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26153),null);
}
} else {
var neighbor = cljs.core.first.call(null,s__26151__$2);
var new_cost = (costs.call(null,current_state) + cost_fn.call(null,current_state,neighbor));
var old_cost = costs.call(null,neighbor,Infinity);
if((new_cost < old_cost)){
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [neighbor,new_cost], null),planning$core$neighbors_with_costs_$_iter__26150.call(null,cljs.core.rest.call(null,s__26151__$2)));
} else {
var G__26156 = cljs.core.rest.call(null,s__26151__$2);
s__26151__$1 = G__26156;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,neighbors_fn.call(null,current_state));
});
planning.core.dijkstra_step = (function planning$core$dijkstra_step(p__26157){
var map__26158 = p__26157;
var map__26158__$1 = (((((!((map__26158 == null))))?(((((map__26158.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26158.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26158):map__26158);
var m = map__26158__$1;
var frontier = cljs.core.get.call(null,map__26158__$1,new cljs.core.Keyword(null,"frontier","frontier",-1129931910));
var vec__26160 = cljs.core.peek.call(null,frontier);
var current_state = cljs.core.nth.call(null,vec__26160,(0),null);
var costs = planning.core.neighbors_with_costs.call(null,m);
return planning.core.update_visited.call(null,cljs.core.update.call(null,planning.core.update_frontier.call(null,m,costs),new cljs.core.Keyword(null,"costs","costs",2093295309),cljs.core.into,costs),current_state,cljs.core.map.call(null,cljs.core.first,costs));
});
planning.core.A_star_step = (function planning$core$A_star_step(p__26163){
var map__26164 = p__26163;
var map__26164__$1 = (((((!((map__26164 == null))))?(((((map__26164.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26164.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26164):map__26164);
var m = map__26164__$1;
var heuristic_fn = cljs.core.get.call(null,map__26164__$1,new cljs.core.Keyword(null,"heuristic-fn","heuristic-fn",-699598101));
var goal = cljs.core.get.call(null,map__26164__$1,new cljs.core.Keyword(null,"goal","goal",-2073396501));
var frontier = cljs.core.get.call(null,map__26164__$1,new cljs.core.Keyword(null,"frontier","frontier",-1129931910));
var vec__26166 = cljs.core.peek.call(null,frontier);
var current_state = cljs.core.nth.call(null,vec__26166,(0),null);
var costs = planning.core.neighbors_with_costs.call(null,m);
var estimates = cljs.core.map.call(null,(function (p__26169){
var vec__26170 = p__26169;
var s = cljs.core.nth.call(null,vec__26170,(0),null);
var c = cljs.core.nth.call(null,vec__26170,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [s,(c + heuristic_fn.call(null,goal,s))], null);
}),costs);
return planning.core.update_visited.call(null,cljs.core.update.call(null,planning.core.update_frontier.call(null,m,estimates),new cljs.core.Keyword(null,"costs","costs",2093295309),cljs.core.into,costs),current_state,cljs.core.map.call(null,cljs.core.first,costs));
});
planning.core.initialize = (function planning$core$initialize(p__26173){
var map__26174 = p__26173;
var map__26174__$1 = (((((!((map__26174 == null))))?(((((map__26174.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26174.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26174):map__26174);
var m = map__26174__$1;
var q = cljs.core.get.call(null,map__26174__$1,new cljs.core.Keyword(null,"q","q",689001697));
var cost_fn = cljs.core.get.call(null,map__26174__$1,new cljs.core.Keyword(null,"cost-fn","cost-fn",1972507749));
var start = cljs.core.get.call(null,map__26174__$1,new cljs.core.Keyword(null,"start","start",-355208981));
var G__26176 = cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"visited","visited",-1610853875),cljs.core.PersistentArrayMap.createAsIfByAssoc([start,null]),new cljs.core.Keyword(null,"frontier","frontier",-1129931910),(cljs.core.truth_(q)?cljs.core.conj.call(null,q,start):tailrecursion.priority_map.priority_map.call(null,start,(0))));
if(cljs.core.truth_(cost_fn)){
return cljs.core.assoc.call(null,G__26176,new cljs.core.Keyword(null,"costs","costs",2093295309),cljs.core.PersistentArrayMap.createAsIfByAssoc([start,(0)]));
} else {
return G__26176;
}
});
planning.core.search_seq = (function planning$core$search_seq(algorithm_step_fn){
return (function (initial_conditions){
return cljs.core.take_while.call(null,cljs.core.comp.call(null,cljs.core.seq,new cljs.core.Keyword(null,"frontier","frontier",-1129931910)),cljs.core.iterate.call(null,algorithm_step_fn,planning.core.initialize.call(null,initial_conditions)));
});
});
planning.core.breadth_first_seq = cljs.core.comp.call(null,planning.core.search_seq.call(null,planning.core.bd_search_step),(function (p1__26177_SHARP_){
return cljs.core.assoc.call(null,p1__26177_SHARP_,new cljs.core.Keyword(null,"q","q",689001697),planning.core.empty_queue);
}));
planning.core.depth_first_seq = cljs.core.comp.call(null,planning.core.search_seq.call(null,planning.core.bd_search_step),(function (p1__26178_SHARP_){
return cljs.core.assoc.call(null,p1__26178_SHARP_,new cljs.core.Keyword(null,"q","q",689001697),cljs.core.PersistentVector.EMPTY);
}));
planning.core.dijkstra_seq = planning.core.search_seq.call(null,planning.core.dijkstra_step);
planning.core.greedy_breadth_first_seq = planning.core.search_seq.call(null,planning.core.greedy_breadth_first_step);
planning.core.A_star_seq = planning.core.search_seq.call(null,planning.core.A_star_step);
planning.core.find_goal_state = (function planning$core$find_goal_state(search_seq){
return cljs.core.first.call(null,cljs.core.filter.call(null,(function (p__26179){
var map__26180 = p__26179;
var map__26180__$1 = (((((!((map__26180 == null))))?(((((map__26180.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26180.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26180):map__26180);
var goal = cljs.core.get.call(null,map__26180__$1,new cljs.core.Keyword(null,"goal","goal",-2073396501));
var visited = cljs.core.get.call(null,map__26180__$1,new cljs.core.Keyword(null,"visited","visited",-1610853875));
return visited.call(null,goal);
}),search_seq));
});
planning.core.breadth_first_terminus = cljs.core.comp.call(null,planning.core.find_goal_state,planning.core.breadth_first_seq);
planning.core.depth_first_terminus = cljs.core.comp.call(null,planning.core.find_goal_state,planning.core.depth_first_seq);
planning.core.dijkstra_terminus = cljs.core.comp.call(null,planning.core.find_goal_state,planning.core.dijkstra_seq);
planning.core.greedy_breadth_first_terminus = cljs.core.comp.call(null,planning.core.find_goal_state,planning.core.greedy_breadth_first_seq);
planning.core.A_star_terminus = cljs.core.comp.call(null,planning.core.find_goal_state,planning.core.A_star_seq);
planning.core.recover_path = (function planning$core$recover_path(p__26182){
var map__26183 = p__26182;
var map__26183__$1 = (((((!((map__26183 == null))))?(((((map__26183.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26183.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26183):map__26183);
var goal = cljs.core.get.call(null,map__26183__$1,new cljs.core.Keyword(null,"goal","goal",-2073396501));
var visited = cljs.core.get.call(null,map__26183__$1,new cljs.core.Keyword(null,"visited","visited",-1610853875));
var temp__5739__auto__ = cljs.core.get.call(null,cljs.core.set.call(null,cljs.core.keys.call(null,visited)),goal);
if((temp__5739__auto__ == null)){
return null;
} else {
var visited_goal = temp__5739__auto__;
return cljs.core.vec.call(null,cljs.core.reverse.call(null,cljs.core.take_while.call(null,cljs.core.some_QMARK_,cljs.core.iterate.call(null,visited,visited_goal))));
}
});
planning.core.breadth_first_search = cljs.core.comp.call(null,planning.core.recover_path,planning.core.breadth_first_terminus);
planning.core.depth_first_search = cljs.core.comp.call(null,planning.core.recover_path,planning.core.depth_first_terminus);
planning.core.dijkstra_search = cljs.core.comp.call(null,planning.core.recover_path,planning.core.dijkstra_terminus);
planning.core.greedy_breadth_first_search = cljs.core.comp.call(null,planning.core.recover_path,planning.core.greedy_breadth_first_terminus);
planning.core.A_star_search = cljs.core.comp.call(null,planning.core.recover_path,planning.core.A_star_terminus);

//# sourceMappingURL=core.js.map?rel=1594010330081
