// Compiled by ClojureScript 1.10.773 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__28763 = arguments.length;
switch (G__28763) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28764 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28764 = (function (f,blockable,meta28765){
this.f = f;
this.blockable = blockable;
this.meta28765 = meta28765;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28764.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28766,meta28765__$1){
var self__ = this;
var _28766__$1 = this;
return (new cljs.core.async.t_cljs$core$async28764(self__.f,self__.blockable,meta28765__$1));
}));

(cljs.core.async.t_cljs$core$async28764.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28766){
var self__ = this;
var _28766__$1 = this;
return self__.meta28765;
}));

(cljs.core.async.t_cljs$core$async28764.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28764.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28764.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async28764.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async28764.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta28765","meta28765",1969521871,null)], null);
}));

(cljs.core.async.t_cljs$core$async28764.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28764.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28764");

(cljs.core.async.t_cljs$core$async28764.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async28764");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28764.
 */
cljs.core.async.__GT_t_cljs$core$async28764 = (function cljs$core$async$__GT_t_cljs$core$async28764(f__$1,blockable__$1,meta28765){
return (new cljs.core.async.t_cljs$core$async28764(f__$1,blockable__$1,meta28765));
});

}

return (new cljs.core.async.t_cljs$core$async28764(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__28770 = arguments.length;
switch (G__28770) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__28773 = arguments.length;
switch (G__28773) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__28776 = arguments.length;
switch (G__28776) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_28778 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_28778);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,val_28778);
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__28780 = arguments.length;
switch (G__28780) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,ret);
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___28782 = n;
var x_28783 = (0);
while(true){
if((x_28783 < n__4613__auto___28782)){
(a[x_28783] = (0));

var G__28784 = (x_28783 + (1));
x_28783 = G__28784;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__28785 = (i + (1));
i = G__28785;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28786 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28786 = (function (flag,meta28787){
this.flag = flag;
this.meta28787 = meta28787;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28786.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28788,meta28787__$1){
var self__ = this;
var _28788__$1 = this;
return (new cljs.core.async.t_cljs$core$async28786(self__.flag,meta28787__$1));
}));

(cljs.core.async.t_cljs$core$async28786.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28788){
var self__ = this;
var _28788__$1 = this;
return self__.meta28787;
}));

(cljs.core.async.t_cljs$core$async28786.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28786.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async28786.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28786.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async28786.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta28787","meta28787",400666858,null)], null);
}));

(cljs.core.async.t_cljs$core$async28786.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28786.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28786");

(cljs.core.async.t_cljs$core$async28786.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async28786");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28786.
 */
cljs.core.async.__GT_t_cljs$core$async28786 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async28786(flag__$1,meta28787){
return (new cljs.core.async.t_cljs$core$async28786(flag__$1,meta28787));
});

}

return (new cljs.core.async.t_cljs$core$async28786(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28789 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28789 = (function (flag,cb,meta28790){
this.flag = flag;
this.cb = cb;
this.meta28790 = meta28790;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28789.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28791,meta28790__$1){
var self__ = this;
var _28791__$1 = this;
return (new cljs.core.async.t_cljs$core$async28789(self__.flag,self__.cb,meta28790__$1));
}));

(cljs.core.async.t_cljs$core$async28789.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28791){
var self__ = this;
var _28791__$1 = this;
return self__.meta28790;
}));

(cljs.core.async.t_cljs$core$async28789.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28789.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async28789.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28789.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async28789.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta28790","meta28790",1606958999,null)], null);
}));

(cljs.core.async.t_cljs$core$async28789.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28789.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28789");

(cljs.core.async.t_cljs$core$async28789.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async28789");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28789.
 */
cljs.core.async.__GT_t_cljs$core$async28789 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async28789(flag__$1,cb__$1,meta28790){
return (new cljs.core.async.t_cljs$core$async28789(flag__$1,cb__$1,meta28790));
});

}

return (new cljs.core.async.t_cljs$core$async28789(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28792_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28792_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28793_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28793_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__28794 = (i + (1));
i = G__28794;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4115__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28800 = arguments.length;
var i__4737__auto___28801 = (0);
while(true){
if((i__4737__auto___28801 < len__4736__auto___28800)){
args__4742__auto__.push((arguments[i__4737__auto___28801]));

var G__28802 = (i__4737__auto___28801 + (1));
i__4737__auto___28801 = G__28802;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__28797){
var map__28798 = p__28797;
var map__28798__$1 = (((((!((map__28798 == null))))?(((((map__28798.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28798.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28798):map__28798);
var opts = map__28798__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq28795){
var G__28796 = cljs.core.first.call(null,seq28795);
var seq28795__$1 = cljs.core.next.call(null,seq28795);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28796,seq28795__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__28804 = arguments.length;
switch (G__28804) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__28703__auto___28850 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_28828){
var state_val_28829 = (state_28828[(1)]);
if((state_val_28829 === (7))){
var inst_28824 = (state_28828[(2)]);
var state_28828__$1 = state_28828;
var statearr_28830_28851 = state_28828__$1;
(statearr_28830_28851[(2)] = inst_28824);

(statearr_28830_28851[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28829 === (1))){
var state_28828__$1 = state_28828;
var statearr_28831_28852 = state_28828__$1;
(statearr_28831_28852[(2)] = null);

(statearr_28831_28852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28829 === (4))){
var inst_28807 = (state_28828[(7)]);
var inst_28807__$1 = (state_28828[(2)]);
var inst_28808 = (inst_28807__$1 == null);
var state_28828__$1 = (function (){var statearr_28832 = state_28828;
(statearr_28832[(7)] = inst_28807__$1);

return statearr_28832;
})();
if(cljs.core.truth_(inst_28808)){
var statearr_28833_28853 = state_28828__$1;
(statearr_28833_28853[(1)] = (5));

} else {
var statearr_28834_28854 = state_28828__$1;
(statearr_28834_28854[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28829 === (13))){
var state_28828__$1 = state_28828;
var statearr_28835_28855 = state_28828__$1;
(statearr_28835_28855[(2)] = null);

(statearr_28835_28855[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28829 === (6))){
var inst_28807 = (state_28828[(7)]);
var state_28828__$1 = state_28828;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28828__$1,(11),to,inst_28807);
} else {
if((state_val_28829 === (3))){
var inst_28826 = (state_28828[(2)]);
var state_28828__$1 = state_28828;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28828__$1,inst_28826);
} else {
if((state_val_28829 === (12))){
var state_28828__$1 = state_28828;
var statearr_28836_28856 = state_28828__$1;
(statearr_28836_28856[(2)] = null);

(statearr_28836_28856[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28829 === (2))){
var state_28828__$1 = state_28828;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28828__$1,(4),from);
} else {
if((state_val_28829 === (11))){
var inst_28817 = (state_28828[(2)]);
var state_28828__$1 = state_28828;
if(cljs.core.truth_(inst_28817)){
var statearr_28837_28857 = state_28828__$1;
(statearr_28837_28857[(1)] = (12));

} else {
var statearr_28838_28858 = state_28828__$1;
(statearr_28838_28858[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28829 === (9))){
var state_28828__$1 = state_28828;
var statearr_28839_28859 = state_28828__$1;
(statearr_28839_28859[(2)] = null);

(statearr_28839_28859[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28829 === (5))){
var state_28828__$1 = state_28828;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28840_28860 = state_28828__$1;
(statearr_28840_28860[(1)] = (8));

} else {
var statearr_28841_28861 = state_28828__$1;
(statearr_28841_28861[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28829 === (14))){
var inst_28822 = (state_28828[(2)]);
var state_28828__$1 = state_28828;
var statearr_28842_28862 = state_28828__$1;
(statearr_28842_28862[(2)] = inst_28822);

(statearr_28842_28862[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28829 === (10))){
var inst_28814 = (state_28828[(2)]);
var state_28828__$1 = state_28828;
var statearr_28843_28863 = state_28828__$1;
(statearr_28843_28863[(2)] = inst_28814);

(statearr_28843_28863[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28829 === (8))){
var inst_28811 = cljs.core.async.close_BANG_.call(null,to);
var state_28828__$1 = state_28828;
var statearr_28844_28864 = state_28828__$1;
(statearr_28844_28864[(2)] = inst_28811);

(statearr_28844_28864[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28609__auto__ = null;
var cljs$core$async$state_machine__28609__auto____0 = (function (){
var statearr_28845 = [null,null,null,null,null,null,null,null];
(statearr_28845[(0)] = cljs$core$async$state_machine__28609__auto__);

(statearr_28845[(1)] = (1));

return statearr_28845;
});
var cljs$core$async$state_machine__28609__auto____1 = (function (state_28828){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_28828);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e28846){if((e28846 instanceof Object)){
var ex__28612__auto__ = e28846;
var statearr_28847_28865 = state_28828;
(statearr_28847_28865[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28828);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28846;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28866 = state_28828;
state_28828 = G__28866;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
cljs$core$async$state_machine__28609__auto__ = function(state_28828){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28609__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28609__auto____1.call(this,state_28828);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28609__auto____0;
cljs$core$async$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28609__auto____1;
return cljs$core$async$state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_28848 = f__28704__auto__.call(null);
(statearr_28848[(6)] = c__28703__auto___28850);

return statearr_28848;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = (function (p__28867){
var vec__28868 = p__28867;
var v = cljs.core.nth.call(null,vec__28868,(0),null);
var p = cljs.core.nth.call(null,vec__28868,(1),null);
var job = vec__28868;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__28703__auto___29039 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_28875){
var state_val_28876 = (state_28875[(1)]);
if((state_val_28876 === (1))){
var state_28875__$1 = state_28875;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28875__$1,(2),res,v);
} else {
if((state_val_28876 === (2))){
var inst_28872 = (state_28875[(2)]);
var inst_28873 = cljs.core.async.close_BANG_.call(null,res);
var state_28875__$1 = (function (){var statearr_28877 = state_28875;
(statearr_28877[(7)] = inst_28872);

return statearr_28877;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28875__$1,inst_28873);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____0 = (function (){
var statearr_28878 = [null,null,null,null,null,null,null,null];
(statearr_28878[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__);

(statearr_28878[(1)] = (1));

return statearr_28878;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____1 = (function (state_28875){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_28875);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e28879){if((e28879 instanceof Object)){
var ex__28612__auto__ = e28879;
var statearr_28880_29040 = state_28875;
(statearr_28880_29040[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28875);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28879;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29041 = state_28875;
state_28875 = G__29041;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__ = function(state_28875){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____1.call(this,state_28875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_28881 = f__28704__auto__.call(null);
(statearr_28881[(6)] = c__28703__auto___29039);

return statearr_28881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var async = (function (p__28882){
var vec__28883 = p__28882;
var v = cljs.core.nth.call(null,vec__28883,(0),null);
var p = cljs.core.nth.call(null,vec__28883,(1),null);
var job = vec__28883;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var n__4613__auto___29042 = n;
var __29043 = (0);
while(true){
if((__29043 < n__4613__auto___29042)){
var G__28886_29044 = type;
var G__28886_29045__$1 = (((G__28886_29044 instanceof cljs.core.Keyword))?G__28886_29044.fqn:null);
switch (G__28886_29045__$1) {
case "compute":
var c__28703__auto___29047 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__29043,c__28703__auto___29047,G__28886_29044,G__28886_29045__$1,n__4613__auto___29042,jobs,results,process,async){
return (function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = ((function (__29043,c__28703__auto___29047,G__28886_29044,G__28886_29045__$1,n__4613__auto___29042,jobs,results,process,async){
return (function (state_28899){
var state_val_28900 = (state_28899[(1)]);
if((state_val_28900 === (1))){
var state_28899__$1 = state_28899;
var statearr_28901_29048 = state_28899__$1;
(statearr_28901_29048[(2)] = null);

(statearr_28901_29048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28900 === (2))){
var state_28899__$1 = state_28899;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28899__$1,(4),jobs);
} else {
if((state_val_28900 === (3))){
var inst_28897 = (state_28899[(2)]);
var state_28899__$1 = state_28899;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28899__$1,inst_28897);
} else {
if((state_val_28900 === (4))){
var inst_28889 = (state_28899[(2)]);
var inst_28890 = process.call(null,inst_28889);
var state_28899__$1 = state_28899;
if(cljs.core.truth_(inst_28890)){
var statearr_28902_29049 = state_28899__$1;
(statearr_28902_29049[(1)] = (5));

} else {
var statearr_28903_29050 = state_28899__$1;
(statearr_28903_29050[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28900 === (5))){
var state_28899__$1 = state_28899;
var statearr_28904_29051 = state_28899__$1;
(statearr_28904_29051[(2)] = null);

(statearr_28904_29051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28900 === (6))){
var state_28899__$1 = state_28899;
var statearr_28905_29052 = state_28899__$1;
(statearr_28905_29052[(2)] = null);

(statearr_28905_29052[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28900 === (7))){
var inst_28895 = (state_28899[(2)]);
var state_28899__$1 = state_28899;
var statearr_28906_29053 = state_28899__$1;
(statearr_28906_29053[(2)] = inst_28895);

(statearr_28906_29053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__29043,c__28703__auto___29047,G__28886_29044,G__28886_29045__$1,n__4613__auto___29042,jobs,results,process,async))
;
return ((function (__29043,switch__28608__auto__,c__28703__auto___29047,G__28886_29044,G__28886_29045__$1,n__4613__auto___29042,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____0 = (function (){
var statearr_28907 = [null,null,null,null,null,null,null];
(statearr_28907[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__);

(statearr_28907[(1)] = (1));

return statearr_28907;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____1 = (function (state_28899){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_28899);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e28908){if((e28908 instanceof Object)){
var ex__28612__auto__ = e28908;
var statearr_28909_29054 = state_28899;
(statearr_28909_29054[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28899);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28908;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29055 = state_28899;
state_28899 = G__29055;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__ = function(state_28899){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____1.call(this,state_28899);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__;
})()
;})(__29043,switch__28608__auto__,c__28703__auto___29047,G__28886_29044,G__28886_29045__$1,n__4613__auto___29042,jobs,results,process,async))
})();
var state__28705__auto__ = (function (){var statearr_28910 = f__28704__auto__.call(null);
(statearr_28910[(6)] = c__28703__auto___29047);

return statearr_28910;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
});})(__29043,c__28703__auto___29047,G__28886_29044,G__28886_29045__$1,n__4613__auto___29042,jobs,results,process,async))
);


break;
case "async":
var c__28703__auto___29056 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__29043,c__28703__auto___29056,G__28886_29044,G__28886_29045__$1,n__4613__auto___29042,jobs,results,process,async){
return (function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = ((function (__29043,c__28703__auto___29056,G__28886_29044,G__28886_29045__$1,n__4613__auto___29042,jobs,results,process,async){
return (function (state_28923){
var state_val_28924 = (state_28923[(1)]);
if((state_val_28924 === (1))){
var state_28923__$1 = state_28923;
var statearr_28925_29057 = state_28923__$1;
(statearr_28925_29057[(2)] = null);

(statearr_28925_29057[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28924 === (2))){
var state_28923__$1 = state_28923;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28923__$1,(4),jobs);
} else {
if((state_val_28924 === (3))){
var inst_28921 = (state_28923[(2)]);
var state_28923__$1 = state_28923;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28923__$1,inst_28921);
} else {
if((state_val_28924 === (4))){
var inst_28913 = (state_28923[(2)]);
var inst_28914 = async.call(null,inst_28913);
var state_28923__$1 = state_28923;
if(cljs.core.truth_(inst_28914)){
var statearr_28926_29058 = state_28923__$1;
(statearr_28926_29058[(1)] = (5));

} else {
var statearr_28927_29059 = state_28923__$1;
(statearr_28927_29059[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28924 === (5))){
var state_28923__$1 = state_28923;
var statearr_28928_29060 = state_28923__$1;
(statearr_28928_29060[(2)] = null);

(statearr_28928_29060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28924 === (6))){
var state_28923__$1 = state_28923;
var statearr_28929_29061 = state_28923__$1;
(statearr_28929_29061[(2)] = null);

(statearr_28929_29061[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28924 === (7))){
var inst_28919 = (state_28923[(2)]);
var state_28923__$1 = state_28923;
var statearr_28930_29062 = state_28923__$1;
(statearr_28930_29062[(2)] = inst_28919);

(statearr_28930_29062[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__29043,c__28703__auto___29056,G__28886_29044,G__28886_29045__$1,n__4613__auto___29042,jobs,results,process,async))
;
return ((function (__29043,switch__28608__auto__,c__28703__auto___29056,G__28886_29044,G__28886_29045__$1,n__4613__auto___29042,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____0 = (function (){
var statearr_28931 = [null,null,null,null,null,null,null];
(statearr_28931[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__);

(statearr_28931[(1)] = (1));

return statearr_28931;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____1 = (function (state_28923){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_28923);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e28932){if((e28932 instanceof Object)){
var ex__28612__auto__ = e28932;
var statearr_28933_29063 = state_28923;
(statearr_28933_29063[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28923);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28932;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29064 = state_28923;
state_28923 = G__29064;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__ = function(state_28923){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____1.call(this,state_28923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__;
})()
;})(__29043,switch__28608__auto__,c__28703__auto___29056,G__28886_29044,G__28886_29045__$1,n__4613__auto___29042,jobs,results,process,async))
})();
var state__28705__auto__ = (function (){var statearr_28934 = f__28704__auto__.call(null);
(statearr_28934[(6)] = c__28703__auto___29056);

return statearr_28934;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
});})(__29043,c__28703__auto___29056,G__28886_29044,G__28886_29045__$1,n__4613__auto___29042,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28886_29045__$1)].join('')));

}

var G__29065 = (__29043 + (1));
__29043 = G__29065;
continue;
} else {
}
break;
}

var c__28703__auto___29066 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_28956){
var state_val_28957 = (state_28956[(1)]);
if((state_val_28957 === (7))){
var inst_28952 = (state_28956[(2)]);
var state_28956__$1 = state_28956;
var statearr_28958_29067 = state_28956__$1;
(statearr_28958_29067[(2)] = inst_28952);

(statearr_28958_29067[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28957 === (1))){
var state_28956__$1 = state_28956;
var statearr_28959_29068 = state_28956__$1;
(statearr_28959_29068[(2)] = null);

(statearr_28959_29068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28957 === (4))){
var inst_28937 = (state_28956[(7)]);
var inst_28937__$1 = (state_28956[(2)]);
var inst_28938 = (inst_28937__$1 == null);
var state_28956__$1 = (function (){var statearr_28960 = state_28956;
(statearr_28960[(7)] = inst_28937__$1);

return statearr_28960;
})();
if(cljs.core.truth_(inst_28938)){
var statearr_28961_29069 = state_28956__$1;
(statearr_28961_29069[(1)] = (5));

} else {
var statearr_28962_29070 = state_28956__$1;
(statearr_28962_29070[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28957 === (6))){
var inst_28937 = (state_28956[(7)]);
var inst_28942 = (state_28956[(8)]);
var inst_28942__$1 = cljs.core.async.chan.call(null,(1));
var inst_28943 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28944 = [inst_28937,inst_28942__$1];
var inst_28945 = (new cljs.core.PersistentVector(null,2,(5),inst_28943,inst_28944,null));
var state_28956__$1 = (function (){var statearr_28963 = state_28956;
(statearr_28963[(8)] = inst_28942__$1);

return statearr_28963;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28956__$1,(8),jobs,inst_28945);
} else {
if((state_val_28957 === (3))){
var inst_28954 = (state_28956[(2)]);
var state_28956__$1 = state_28956;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28956__$1,inst_28954);
} else {
if((state_val_28957 === (2))){
var state_28956__$1 = state_28956;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28956__$1,(4),from);
} else {
if((state_val_28957 === (9))){
var inst_28949 = (state_28956[(2)]);
var state_28956__$1 = (function (){var statearr_28964 = state_28956;
(statearr_28964[(9)] = inst_28949);

return statearr_28964;
})();
var statearr_28965_29071 = state_28956__$1;
(statearr_28965_29071[(2)] = null);

(statearr_28965_29071[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28957 === (5))){
var inst_28940 = cljs.core.async.close_BANG_.call(null,jobs);
var state_28956__$1 = state_28956;
var statearr_28966_29072 = state_28956__$1;
(statearr_28966_29072[(2)] = inst_28940);

(statearr_28966_29072[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28957 === (8))){
var inst_28942 = (state_28956[(8)]);
var inst_28947 = (state_28956[(2)]);
var state_28956__$1 = (function (){var statearr_28967 = state_28956;
(statearr_28967[(10)] = inst_28947);

return statearr_28967;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28956__$1,(9),results,inst_28942);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____0 = (function (){
var statearr_28968 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28968[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__);

(statearr_28968[(1)] = (1));

return statearr_28968;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____1 = (function (state_28956){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_28956);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e28969){if((e28969 instanceof Object)){
var ex__28612__auto__ = e28969;
var statearr_28970_29073 = state_28956;
(statearr_28970_29073[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28956);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28969;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29074 = state_28956;
state_28956 = G__29074;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__ = function(state_28956){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____1.call(this,state_28956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_28971 = f__28704__auto__.call(null);
(statearr_28971[(6)] = c__28703__auto___29066);

return statearr_28971;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));


var c__28703__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_29009){
var state_val_29010 = (state_29009[(1)]);
if((state_val_29010 === (7))){
var inst_29005 = (state_29009[(2)]);
var state_29009__$1 = state_29009;
var statearr_29011_29075 = state_29009__$1;
(statearr_29011_29075[(2)] = inst_29005);

(statearr_29011_29075[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29010 === (20))){
var state_29009__$1 = state_29009;
var statearr_29012_29076 = state_29009__$1;
(statearr_29012_29076[(2)] = null);

(statearr_29012_29076[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29010 === (1))){
var state_29009__$1 = state_29009;
var statearr_29013_29077 = state_29009__$1;
(statearr_29013_29077[(2)] = null);

(statearr_29013_29077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29010 === (4))){
var inst_28974 = (state_29009[(7)]);
var inst_28974__$1 = (state_29009[(2)]);
var inst_28975 = (inst_28974__$1 == null);
var state_29009__$1 = (function (){var statearr_29014 = state_29009;
(statearr_29014[(7)] = inst_28974__$1);

return statearr_29014;
})();
if(cljs.core.truth_(inst_28975)){
var statearr_29015_29078 = state_29009__$1;
(statearr_29015_29078[(1)] = (5));

} else {
var statearr_29016_29079 = state_29009__$1;
(statearr_29016_29079[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29010 === (15))){
var inst_28987 = (state_29009[(8)]);
var state_29009__$1 = state_29009;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29009__$1,(18),to,inst_28987);
} else {
if((state_val_29010 === (21))){
var inst_29000 = (state_29009[(2)]);
var state_29009__$1 = state_29009;
var statearr_29017_29080 = state_29009__$1;
(statearr_29017_29080[(2)] = inst_29000);

(statearr_29017_29080[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29010 === (13))){
var inst_29002 = (state_29009[(2)]);
var state_29009__$1 = (function (){var statearr_29018 = state_29009;
(statearr_29018[(9)] = inst_29002);

return statearr_29018;
})();
var statearr_29019_29081 = state_29009__$1;
(statearr_29019_29081[(2)] = null);

(statearr_29019_29081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29010 === (6))){
var inst_28974 = (state_29009[(7)]);
var state_29009__$1 = state_29009;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29009__$1,(11),inst_28974);
} else {
if((state_val_29010 === (17))){
var inst_28995 = (state_29009[(2)]);
var state_29009__$1 = state_29009;
if(cljs.core.truth_(inst_28995)){
var statearr_29020_29082 = state_29009__$1;
(statearr_29020_29082[(1)] = (19));

} else {
var statearr_29021_29083 = state_29009__$1;
(statearr_29021_29083[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29010 === (3))){
var inst_29007 = (state_29009[(2)]);
var state_29009__$1 = state_29009;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29009__$1,inst_29007);
} else {
if((state_val_29010 === (12))){
var inst_28984 = (state_29009[(10)]);
var state_29009__$1 = state_29009;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29009__$1,(14),inst_28984);
} else {
if((state_val_29010 === (2))){
var state_29009__$1 = state_29009;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29009__$1,(4),results);
} else {
if((state_val_29010 === (19))){
var state_29009__$1 = state_29009;
var statearr_29022_29084 = state_29009__$1;
(statearr_29022_29084[(2)] = null);

(statearr_29022_29084[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29010 === (11))){
var inst_28984 = (state_29009[(2)]);
var state_29009__$1 = (function (){var statearr_29023 = state_29009;
(statearr_29023[(10)] = inst_28984);

return statearr_29023;
})();
var statearr_29024_29085 = state_29009__$1;
(statearr_29024_29085[(2)] = null);

(statearr_29024_29085[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29010 === (9))){
var state_29009__$1 = state_29009;
var statearr_29025_29086 = state_29009__$1;
(statearr_29025_29086[(2)] = null);

(statearr_29025_29086[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29010 === (5))){
var state_29009__$1 = state_29009;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29026_29087 = state_29009__$1;
(statearr_29026_29087[(1)] = (8));

} else {
var statearr_29027_29088 = state_29009__$1;
(statearr_29027_29088[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29010 === (14))){
var inst_28987 = (state_29009[(8)]);
var inst_28987__$1 = (state_29009[(2)]);
var inst_28988 = (inst_28987__$1 == null);
var inst_28989 = cljs.core.not.call(null,inst_28988);
var state_29009__$1 = (function (){var statearr_29028 = state_29009;
(statearr_29028[(8)] = inst_28987__$1);

return statearr_29028;
})();
if(inst_28989){
var statearr_29029_29089 = state_29009__$1;
(statearr_29029_29089[(1)] = (15));

} else {
var statearr_29030_29090 = state_29009__$1;
(statearr_29030_29090[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29010 === (16))){
var state_29009__$1 = state_29009;
var statearr_29031_29091 = state_29009__$1;
(statearr_29031_29091[(2)] = false);

(statearr_29031_29091[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29010 === (10))){
var inst_28981 = (state_29009[(2)]);
var state_29009__$1 = state_29009;
var statearr_29032_29092 = state_29009__$1;
(statearr_29032_29092[(2)] = inst_28981);

(statearr_29032_29092[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29010 === (18))){
var inst_28992 = (state_29009[(2)]);
var state_29009__$1 = state_29009;
var statearr_29033_29093 = state_29009__$1;
(statearr_29033_29093[(2)] = inst_28992);

(statearr_29033_29093[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29010 === (8))){
var inst_28978 = cljs.core.async.close_BANG_.call(null,to);
var state_29009__$1 = state_29009;
var statearr_29034_29094 = state_29009__$1;
(statearr_29034_29094[(2)] = inst_28978);

(statearr_29034_29094[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____0 = (function (){
var statearr_29035 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29035[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__);

(statearr_29035[(1)] = (1));

return statearr_29035;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____1 = (function (state_29009){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_29009);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e29036){if((e29036 instanceof Object)){
var ex__28612__auto__ = e29036;
var statearr_29037_29095 = state_29009;
(statearr_29037_29095[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29009);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29036;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29096 = state_29009;
state_29009 = G__29096;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__ = function(state_29009){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____1.call(this,state_29009);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28609__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_29038 = f__28704__auto__.call(null);
(statearr_29038[(6)] = c__28703__auto__);

return statearr_29038;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));

return c__28703__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__29098 = arguments.length;
switch (G__29098) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__29101 = arguments.length;
switch (G__29101) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__29104 = arguments.length;
switch (G__29104) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__28703__auto___29153 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_29130){
var state_val_29131 = (state_29130[(1)]);
if((state_val_29131 === (7))){
var inst_29126 = (state_29130[(2)]);
var state_29130__$1 = state_29130;
var statearr_29132_29154 = state_29130__$1;
(statearr_29132_29154[(2)] = inst_29126);

(statearr_29132_29154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29131 === (1))){
var state_29130__$1 = state_29130;
var statearr_29133_29155 = state_29130__$1;
(statearr_29133_29155[(2)] = null);

(statearr_29133_29155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29131 === (4))){
var inst_29107 = (state_29130[(7)]);
var inst_29107__$1 = (state_29130[(2)]);
var inst_29108 = (inst_29107__$1 == null);
var state_29130__$1 = (function (){var statearr_29134 = state_29130;
(statearr_29134[(7)] = inst_29107__$1);

return statearr_29134;
})();
if(cljs.core.truth_(inst_29108)){
var statearr_29135_29156 = state_29130__$1;
(statearr_29135_29156[(1)] = (5));

} else {
var statearr_29136_29157 = state_29130__$1;
(statearr_29136_29157[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29131 === (13))){
var state_29130__$1 = state_29130;
var statearr_29137_29158 = state_29130__$1;
(statearr_29137_29158[(2)] = null);

(statearr_29137_29158[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29131 === (6))){
var inst_29107 = (state_29130[(7)]);
var inst_29113 = p.call(null,inst_29107);
var state_29130__$1 = state_29130;
if(cljs.core.truth_(inst_29113)){
var statearr_29138_29159 = state_29130__$1;
(statearr_29138_29159[(1)] = (9));

} else {
var statearr_29139_29160 = state_29130__$1;
(statearr_29139_29160[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29131 === (3))){
var inst_29128 = (state_29130[(2)]);
var state_29130__$1 = state_29130;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29130__$1,inst_29128);
} else {
if((state_val_29131 === (12))){
var state_29130__$1 = state_29130;
var statearr_29140_29161 = state_29130__$1;
(statearr_29140_29161[(2)] = null);

(statearr_29140_29161[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29131 === (2))){
var state_29130__$1 = state_29130;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29130__$1,(4),ch);
} else {
if((state_val_29131 === (11))){
var inst_29107 = (state_29130[(7)]);
var inst_29117 = (state_29130[(2)]);
var state_29130__$1 = state_29130;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29130__$1,(8),inst_29117,inst_29107);
} else {
if((state_val_29131 === (9))){
var state_29130__$1 = state_29130;
var statearr_29141_29162 = state_29130__$1;
(statearr_29141_29162[(2)] = tc);

(statearr_29141_29162[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29131 === (5))){
var inst_29110 = cljs.core.async.close_BANG_.call(null,tc);
var inst_29111 = cljs.core.async.close_BANG_.call(null,fc);
var state_29130__$1 = (function (){var statearr_29142 = state_29130;
(statearr_29142[(8)] = inst_29110);

return statearr_29142;
})();
var statearr_29143_29163 = state_29130__$1;
(statearr_29143_29163[(2)] = inst_29111);

(statearr_29143_29163[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29131 === (14))){
var inst_29124 = (state_29130[(2)]);
var state_29130__$1 = state_29130;
var statearr_29144_29164 = state_29130__$1;
(statearr_29144_29164[(2)] = inst_29124);

(statearr_29144_29164[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29131 === (10))){
var state_29130__$1 = state_29130;
var statearr_29145_29165 = state_29130__$1;
(statearr_29145_29165[(2)] = fc);

(statearr_29145_29165[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29131 === (8))){
var inst_29119 = (state_29130[(2)]);
var state_29130__$1 = state_29130;
if(cljs.core.truth_(inst_29119)){
var statearr_29146_29166 = state_29130__$1;
(statearr_29146_29166[(1)] = (12));

} else {
var statearr_29147_29167 = state_29130__$1;
(statearr_29147_29167[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28609__auto__ = null;
var cljs$core$async$state_machine__28609__auto____0 = (function (){
var statearr_29148 = [null,null,null,null,null,null,null,null,null];
(statearr_29148[(0)] = cljs$core$async$state_machine__28609__auto__);

(statearr_29148[(1)] = (1));

return statearr_29148;
});
var cljs$core$async$state_machine__28609__auto____1 = (function (state_29130){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_29130);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e29149){if((e29149 instanceof Object)){
var ex__28612__auto__ = e29149;
var statearr_29150_29168 = state_29130;
(statearr_29150_29168[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29130);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29149;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29169 = state_29130;
state_29130 = G__29169;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
cljs$core$async$state_machine__28609__auto__ = function(state_29130){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28609__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28609__auto____1.call(this,state_29130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28609__auto____0;
cljs$core$async$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28609__auto____1;
return cljs$core$async$state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_29151 = f__28704__auto__.call(null);
(statearr_29151[(6)] = c__28703__auto___29153);

return statearr_29151;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__28703__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_29190){
var state_val_29191 = (state_29190[(1)]);
if((state_val_29191 === (7))){
var inst_29186 = (state_29190[(2)]);
var state_29190__$1 = state_29190;
var statearr_29192_29210 = state_29190__$1;
(statearr_29192_29210[(2)] = inst_29186);

(statearr_29192_29210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29191 === (1))){
var inst_29170 = init;
var state_29190__$1 = (function (){var statearr_29193 = state_29190;
(statearr_29193[(7)] = inst_29170);

return statearr_29193;
})();
var statearr_29194_29211 = state_29190__$1;
(statearr_29194_29211[(2)] = null);

(statearr_29194_29211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29191 === (4))){
var inst_29173 = (state_29190[(8)]);
var inst_29173__$1 = (state_29190[(2)]);
var inst_29174 = (inst_29173__$1 == null);
var state_29190__$1 = (function (){var statearr_29195 = state_29190;
(statearr_29195[(8)] = inst_29173__$1);

return statearr_29195;
})();
if(cljs.core.truth_(inst_29174)){
var statearr_29196_29212 = state_29190__$1;
(statearr_29196_29212[(1)] = (5));

} else {
var statearr_29197_29213 = state_29190__$1;
(statearr_29197_29213[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29191 === (6))){
var inst_29177 = (state_29190[(9)]);
var inst_29173 = (state_29190[(8)]);
var inst_29170 = (state_29190[(7)]);
var inst_29177__$1 = f.call(null,inst_29170,inst_29173);
var inst_29178 = cljs.core.reduced_QMARK_.call(null,inst_29177__$1);
var state_29190__$1 = (function (){var statearr_29198 = state_29190;
(statearr_29198[(9)] = inst_29177__$1);

return statearr_29198;
})();
if(inst_29178){
var statearr_29199_29214 = state_29190__$1;
(statearr_29199_29214[(1)] = (8));

} else {
var statearr_29200_29215 = state_29190__$1;
(statearr_29200_29215[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29191 === (3))){
var inst_29188 = (state_29190[(2)]);
var state_29190__$1 = state_29190;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29190__$1,inst_29188);
} else {
if((state_val_29191 === (2))){
var state_29190__$1 = state_29190;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29190__$1,(4),ch);
} else {
if((state_val_29191 === (9))){
var inst_29177 = (state_29190[(9)]);
var inst_29170 = inst_29177;
var state_29190__$1 = (function (){var statearr_29201 = state_29190;
(statearr_29201[(7)] = inst_29170);

return statearr_29201;
})();
var statearr_29202_29216 = state_29190__$1;
(statearr_29202_29216[(2)] = null);

(statearr_29202_29216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29191 === (5))){
var inst_29170 = (state_29190[(7)]);
var state_29190__$1 = state_29190;
var statearr_29203_29217 = state_29190__$1;
(statearr_29203_29217[(2)] = inst_29170);

(statearr_29203_29217[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29191 === (10))){
var inst_29184 = (state_29190[(2)]);
var state_29190__$1 = state_29190;
var statearr_29204_29218 = state_29190__$1;
(statearr_29204_29218[(2)] = inst_29184);

(statearr_29204_29218[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29191 === (8))){
var inst_29177 = (state_29190[(9)]);
var inst_29180 = cljs.core.deref.call(null,inst_29177);
var state_29190__$1 = state_29190;
var statearr_29205_29219 = state_29190__$1;
(statearr_29205_29219[(2)] = inst_29180);

(statearr_29205_29219[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__28609__auto__ = null;
var cljs$core$async$reduce_$_state_machine__28609__auto____0 = (function (){
var statearr_29206 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29206[(0)] = cljs$core$async$reduce_$_state_machine__28609__auto__);

(statearr_29206[(1)] = (1));

return statearr_29206;
});
var cljs$core$async$reduce_$_state_machine__28609__auto____1 = (function (state_29190){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_29190);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e29207){if((e29207 instanceof Object)){
var ex__28612__auto__ = e29207;
var statearr_29208_29220 = state_29190;
(statearr_29208_29220[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29190);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29207;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29221 = state_29190;
state_29190 = G__29221;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__28609__auto__ = function(state_29190){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__28609__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__28609__auto____1.call(this,state_29190);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__28609__auto____0;
cljs$core$async$reduce_$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__28609__auto____1;
return cljs$core$async$reduce_$_state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_29209 = f__28704__auto__.call(null);
(statearr_29209[(6)] = c__28703__auto__);

return statearr_29209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));

return c__28703__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__28703__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_29227){
var state_val_29228 = (state_29227[(1)]);
if((state_val_29228 === (1))){
var inst_29222 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_29227__$1 = state_29227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29227__$1,(2),inst_29222);
} else {
if((state_val_29228 === (2))){
var inst_29224 = (state_29227[(2)]);
var inst_29225 = f__$1.call(null,inst_29224);
var state_29227__$1 = state_29227;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29227__$1,inst_29225);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__28609__auto__ = null;
var cljs$core$async$transduce_$_state_machine__28609__auto____0 = (function (){
var statearr_29229 = [null,null,null,null,null,null,null];
(statearr_29229[(0)] = cljs$core$async$transduce_$_state_machine__28609__auto__);

(statearr_29229[(1)] = (1));

return statearr_29229;
});
var cljs$core$async$transduce_$_state_machine__28609__auto____1 = (function (state_29227){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_29227);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e29230){if((e29230 instanceof Object)){
var ex__28612__auto__ = e29230;
var statearr_29231_29233 = state_29227;
(statearr_29231_29233[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29227);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29230;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29234 = state_29227;
state_29227 = G__29234;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__28609__auto__ = function(state_29227){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__28609__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__28609__auto____1.call(this,state_29227);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__28609__auto____0;
cljs$core$async$transduce_$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__28609__auto____1;
return cljs$core$async$transduce_$_state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_29232 = f__28704__auto__.call(null);
(statearr_29232[(6)] = c__28703__auto__);

return statearr_29232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));

return c__28703__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__29236 = arguments.length;
switch (G__29236) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__28703__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_29261){
var state_val_29262 = (state_29261[(1)]);
if((state_val_29262 === (7))){
var inst_29243 = (state_29261[(2)]);
var state_29261__$1 = state_29261;
var statearr_29263_29284 = state_29261__$1;
(statearr_29263_29284[(2)] = inst_29243);

(statearr_29263_29284[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (1))){
var inst_29237 = cljs.core.seq.call(null,coll);
var inst_29238 = inst_29237;
var state_29261__$1 = (function (){var statearr_29264 = state_29261;
(statearr_29264[(7)] = inst_29238);

return statearr_29264;
})();
var statearr_29265_29285 = state_29261__$1;
(statearr_29265_29285[(2)] = null);

(statearr_29265_29285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (4))){
var inst_29238 = (state_29261[(7)]);
var inst_29241 = cljs.core.first.call(null,inst_29238);
var state_29261__$1 = state_29261;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29261__$1,(7),ch,inst_29241);
} else {
if((state_val_29262 === (13))){
var inst_29255 = (state_29261[(2)]);
var state_29261__$1 = state_29261;
var statearr_29266_29286 = state_29261__$1;
(statearr_29266_29286[(2)] = inst_29255);

(statearr_29266_29286[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (6))){
var inst_29246 = (state_29261[(2)]);
var state_29261__$1 = state_29261;
if(cljs.core.truth_(inst_29246)){
var statearr_29267_29287 = state_29261__$1;
(statearr_29267_29287[(1)] = (8));

} else {
var statearr_29268_29288 = state_29261__$1;
(statearr_29268_29288[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (3))){
var inst_29259 = (state_29261[(2)]);
var state_29261__$1 = state_29261;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29261__$1,inst_29259);
} else {
if((state_val_29262 === (12))){
var state_29261__$1 = state_29261;
var statearr_29269_29289 = state_29261__$1;
(statearr_29269_29289[(2)] = null);

(statearr_29269_29289[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (2))){
var inst_29238 = (state_29261[(7)]);
var state_29261__$1 = state_29261;
if(cljs.core.truth_(inst_29238)){
var statearr_29270_29290 = state_29261__$1;
(statearr_29270_29290[(1)] = (4));

} else {
var statearr_29271_29291 = state_29261__$1;
(statearr_29271_29291[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (11))){
var inst_29252 = cljs.core.async.close_BANG_.call(null,ch);
var state_29261__$1 = state_29261;
var statearr_29272_29292 = state_29261__$1;
(statearr_29272_29292[(2)] = inst_29252);

(statearr_29272_29292[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (9))){
var state_29261__$1 = state_29261;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29273_29293 = state_29261__$1;
(statearr_29273_29293[(1)] = (11));

} else {
var statearr_29274_29294 = state_29261__$1;
(statearr_29274_29294[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (5))){
var inst_29238 = (state_29261[(7)]);
var state_29261__$1 = state_29261;
var statearr_29275_29295 = state_29261__$1;
(statearr_29275_29295[(2)] = inst_29238);

(statearr_29275_29295[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (10))){
var inst_29257 = (state_29261[(2)]);
var state_29261__$1 = state_29261;
var statearr_29276_29296 = state_29261__$1;
(statearr_29276_29296[(2)] = inst_29257);

(statearr_29276_29296[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (8))){
var inst_29238 = (state_29261[(7)]);
var inst_29248 = cljs.core.next.call(null,inst_29238);
var inst_29238__$1 = inst_29248;
var state_29261__$1 = (function (){var statearr_29277 = state_29261;
(statearr_29277[(7)] = inst_29238__$1);

return statearr_29277;
})();
var statearr_29278_29297 = state_29261__$1;
(statearr_29278_29297[(2)] = null);

(statearr_29278_29297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28609__auto__ = null;
var cljs$core$async$state_machine__28609__auto____0 = (function (){
var statearr_29279 = [null,null,null,null,null,null,null,null];
(statearr_29279[(0)] = cljs$core$async$state_machine__28609__auto__);

(statearr_29279[(1)] = (1));

return statearr_29279;
});
var cljs$core$async$state_machine__28609__auto____1 = (function (state_29261){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_29261);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e29280){if((e29280 instanceof Object)){
var ex__28612__auto__ = e29280;
var statearr_29281_29298 = state_29261;
(statearr_29281_29298[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29261);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29280;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29299 = state_29261;
state_29261 = G__29299;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
cljs$core$async$state_machine__28609__auto__ = function(state_29261){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28609__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28609__auto____1.call(this,state_29261);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28609__auto____0;
cljs$core$async$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28609__auto____1;
return cljs$core$async$state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_29282 = f__28704__auto__.call(null);
(statearr_29282[(6)] = c__28703__auto__);

return statearr_29282;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));

return c__28703__auto__;
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_29300 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,_);
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_29300.call(null,_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_29301 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_29301.call(null,m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_29302 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_29302.call(null,m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_29303 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m);
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_29303.call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29304 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29304 = (function (ch,cs,meta29305){
this.ch = ch;
this.cs = cs;
this.meta29305 = meta29305;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29304.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29306,meta29305__$1){
var self__ = this;
var _29306__$1 = this;
return (new cljs.core.async.t_cljs$core$async29304(self__.ch,self__.cs,meta29305__$1));
}));

(cljs.core.async.t_cljs$core$async29304.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29306){
var self__ = this;
var _29306__$1 = this;
return self__.meta29305;
}));

(cljs.core.async.t_cljs$core$async29304.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29304.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async29304.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29304.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async29304.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async29304.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async29304.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta29305","meta29305",-268623104,null)], null);
}));

(cljs.core.async.t_cljs$core$async29304.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29304.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29304");

(cljs.core.async.t_cljs$core$async29304.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async29304");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29304.
 */
cljs.core.async.__GT_t_cljs$core$async29304 = (function cljs$core$async$mult_$___GT_t_cljs$core$async29304(ch__$1,cs__$1,meta29305){
return (new cljs.core.async.t_cljs$core$async29304(ch__$1,cs__$1,meta29305));
});

}

return (new cljs.core.async.t_cljs$core$async29304(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});
var c__28703__auto___29526 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_29441){
var state_val_29442 = (state_29441[(1)]);
if((state_val_29442 === (7))){
var inst_29437 = (state_29441[(2)]);
var state_29441__$1 = state_29441;
var statearr_29443_29527 = state_29441__$1;
(statearr_29443_29527[(2)] = inst_29437);

(statearr_29443_29527[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (20))){
var inst_29340 = (state_29441[(7)]);
var inst_29352 = cljs.core.first.call(null,inst_29340);
var inst_29353 = cljs.core.nth.call(null,inst_29352,(0),null);
var inst_29354 = cljs.core.nth.call(null,inst_29352,(1),null);
var state_29441__$1 = (function (){var statearr_29444 = state_29441;
(statearr_29444[(8)] = inst_29353);

return statearr_29444;
})();
if(cljs.core.truth_(inst_29354)){
var statearr_29445_29528 = state_29441__$1;
(statearr_29445_29528[(1)] = (22));

} else {
var statearr_29446_29529 = state_29441__$1;
(statearr_29446_29529[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (27))){
var inst_29382 = (state_29441[(9)]);
var inst_29309 = (state_29441[(10)]);
var inst_29384 = (state_29441[(11)]);
var inst_29389 = (state_29441[(12)]);
var inst_29389__$1 = cljs.core._nth.call(null,inst_29382,inst_29384);
var inst_29390 = cljs.core.async.put_BANG_.call(null,inst_29389__$1,inst_29309,done);
var state_29441__$1 = (function (){var statearr_29447 = state_29441;
(statearr_29447[(12)] = inst_29389__$1);

return statearr_29447;
})();
if(cljs.core.truth_(inst_29390)){
var statearr_29448_29530 = state_29441__$1;
(statearr_29448_29530[(1)] = (30));

} else {
var statearr_29449_29531 = state_29441__$1;
(statearr_29449_29531[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (1))){
var state_29441__$1 = state_29441;
var statearr_29450_29532 = state_29441__$1;
(statearr_29450_29532[(2)] = null);

(statearr_29450_29532[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (24))){
var inst_29340 = (state_29441[(7)]);
var inst_29359 = (state_29441[(2)]);
var inst_29360 = cljs.core.next.call(null,inst_29340);
var inst_29318 = inst_29360;
var inst_29319 = null;
var inst_29320 = (0);
var inst_29321 = (0);
var state_29441__$1 = (function (){var statearr_29451 = state_29441;
(statearr_29451[(13)] = inst_29320);

(statearr_29451[(14)] = inst_29318);

(statearr_29451[(15)] = inst_29321);

(statearr_29451[(16)] = inst_29359);

(statearr_29451[(17)] = inst_29319);

return statearr_29451;
})();
var statearr_29452_29533 = state_29441__$1;
(statearr_29452_29533[(2)] = null);

(statearr_29452_29533[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (39))){
var state_29441__$1 = state_29441;
var statearr_29456_29534 = state_29441__$1;
(statearr_29456_29534[(2)] = null);

(statearr_29456_29534[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (4))){
var inst_29309 = (state_29441[(10)]);
var inst_29309__$1 = (state_29441[(2)]);
var inst_29310 = (inst_29309__$1 == null);
var state_29441__$1 = (function (){var statearr_29457 = state_29441;
(statearr_29457[(10)] = inst_29309__$1);

return statearr_29457;
})();
if(cljs.core.truth_(inst_29310)){
var statearr_29458_29535 = state_29441__$1;
(statearr_29458_29535[(1)] = (5));

} else {
var statearr_29459_29536 = state_29441__$1;
(statearr_29459_29536[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (15))){
var inst_29320 = (state_29441[(13)]);
var inst_29318 = (state_29441[(14)]);
var inst_29321 = (state_29441[(15)]);
var inst_29319 = (state_29441[(17)]);
var inst_29336 = (state_29441[(2)]);
var inst_29337 = (inst_29321 + (1));
var tmp29453 = inst_29320;
var tmp29454 = inst_29318;
var tmp29455 = inst_29319;
var inst_29318__$1 = tmp29454;
var inst_29319__$1 = tmp29455;
var inst_29320__$1 = tmp29453;
var inst_29321__$1 = inst_29337;
var state_29441__$1 = (function (){var statearr_29460 = state_29441;
(statearr_29460[(13)] = inst_29320__$1);

(statearr_29460[(18)] = inst_29336);

(statearr_29460[(14)] = inst_29318__$1);

(statearr_29460[(15)] = inst_29321__$1);

(statearr_29460[(17)] = inst_29319__$1);

return statearr_29460;
})();
var statearr_29461_29537 = state_29441__$1;
(statearr_29461_29537[(2)] = null);

(statearr_29461_29537[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (21))){
var inst_29363 = (state_29441[(2)]);
var state_29441__$1 = state_29441;
var statearr_29465_29538 = state_29441__$1;
(statearr_29465_29538[(2)] = inst_29363);

(statearr_29465_29538[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (31))){
var inst_29389 = (state_29441[(12)]);
var inst_29393 = done.call(null,null);
var inst_29394 = cljs.core.async.untap_STAR_.call(null,m,inst_29389);
var state_29441__$1 = (function (){var statearr_29466 = state_29441;
(statearr_29466[(19)] = inst_29393);

return statearr_29466;
})();
var statearr_29467_29539 = state_29441__$1;
(statearr_29467_29539[(2)] = inst_29394);

(statearr_29467_29539[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (32))){
var inst_29381 = (state_29441[(20)]);
var inst_29383 = (state_29441[(21)]);
var inst_29382 = (state_29441[(9)]);
var inst_29384 = (state_29441[(11)]);
var inst_29396 = (state_29441[(2)]);
var inst_29397 = (inst_29384 + (1));
var tmp29462 = inst_29381;
var tmp29463 = inst_29383;
var tmp29464 = inst_29382;
var inst_29381__$1 = tmp29462;
var inst_29382__$1 = tmp29464;
var inst_29383__$1 = tmp29463;
var inst_29384__$1 = inst_29397;
var state_29441__$1 = (function (){var statearr_29468 = state_29441;
(statearr_29468[(20)] = inst_29381__$1);

(statearr_29468[(21)] = inst_29383__$1);

(statearr_29468[(9)] = inst_29382__$1);

(statearr_29468[(22)] = inst_29396);

(statearr_29468[(11)] = inst_29384__$1);

return statearr_29468;
})();
var statearr_29469_29540 = state_29441__$1;
(statearr_29469_29540[(2)] = null);

(statearr_29469_29540[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (40))){
var inst_29409 = (state_29441[(23)]);
var inst_29413 = done.call(null,null);
var inst_29414 = cljs.core.async.untap_STAR_.call(null,m,inst_29409);
var state_29441__$1 = (function (){var statearr_29470 = state_29441;
(statearr_29470[(24)] = inst_29413);

return statearr_29470;
})();
var statearr_29471_29541 = state_29441__$1;
(statearr_29471_29541[(2)] = inst_29414);

(statearr_29471_29541[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (33))){
var inst_29400 = (state_29441[(25)]);
var inst_29402 = cljs.core.chunked_seq_QMARK_.call(null,inst_29400);
var state_29441__$1 = state_29441;
if(inst_29402){
var statearr_29472_29542 = state_29441__$1;
(statearr_29472_29542[(1)] = (36));

} else {
var statearr_29473_29543 = state_29441__$1;
(statearr_29473_29543[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (13))){
var inst_29330 = (state_29441[(26)]);
var inst_29333 = cljs.core.async.close_BANG_.call(null,inst_29330);
var state_29441__$1 = state_29441;
var statearr_29474_29544 = state_29441__$1;
(statearr_29474_29544[(2)] = inst_29333);

(statearr_29474_29544[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (22))){
var inst_29353 = (state_29441[(8)]);
var inst_29356 = cljs.core.async.close_BANG_.call(null,inst_29353);
var state_29441__$1 = state_29441;
var statearr_29475_29545 = state_29441__$1;
(statearr_29475_29545[(2)] = inst_29356);

(statearr_29475_29545[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (36))){
var inst_29400 = (state_29441[(25)]);
var inst_29404 = cljs.core.chunk_first.call(null,inst_29400);
var inst_29405 = cljs.core.chunk_rest.call(null,inst_29400);
var inst_29406 = cljs.core.count.call(null,inst_29404);
var inst_29381 = inst_29405;
var inst_29382 = inst_29404;
var inst_29383 = inst_29406;
var inst_29384 = (0);
var state_29441__$1 = (function (){var statearr_29476 = state_29441;
(statearr_29476[(20)] = inst_29381);

(statearr_29476[(21)] = inst_29383);

(statearr_29476[(9)] = inst_29382);

(statearr_29476[(11)] = inst_29384);

return statearr_29476;
})();
var statearr_29477_29546 = state_29441__$1;
(statearr_29477_29546[(2)] = null);

(statearr_29477_29546[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (41))){
var inst_29400 = (state_29441[(25)]);
var inst_29416 = (state_29441[(2)]);
var inst_29417 = cljs.core.next.call(null,inst_29400);
var inst_29381 = inst_29417;
var inst_29382 = null;
var inst_29383 = (0);
var inst_29384 = (0);
var state_29441__$1 = (function (){var statearr_29478 = state_29441;
(statearr_29478[(20)] = inst_29381);

(statearr_29478[(21)] = inst_29383);

(statearr_29478[(27)] = inst_29416);

(statearr_29478[(9)] = inst_29382);

(statearr_29478[(11)] = inst_29384);

return statearr_29478;
})();
var statearr_29479_29547 = state_29441__$1;
(statearr_29479_29547[(2)] = null);

(statearr_29479_29547[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (43))){
var state_29441__$1 = state_29441;
var statearr_29480_29548 = state_29441__$1;
(statearr_29480_29548[(2)] = null);

(statearr_29480_29548[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (29))){
var inst_29425 = (state_29441[(2)]);
var state_29441__$1 = state_29441;
var statearr_29481_29549 = state_29441__$1;
(statearr_29481_29549[(2)] = inst_29425);

(statearr_29481_29549[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (44))){
var inst_29434 = (state_29441[(2)]);
var state_29441__$1 = (function (){var statearr_29482 = state_29441;
(statearr_29482[(28)] = inst_29434);

return statearr_29482;
})();
var statearr_29483_29550 = state_29441__$1;
(statearr_29483_29550[(2)] = null);

(statearr_29483_29550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (6))){
var inst_29373 = (state_29441[(29)]);
var inst_29372 = cljs.core.deref.call(null,cs);
var inst_29373__$1 = cljs.core.keys.call(null,inst_29372);
var inst_29374 = cljs.core.count.call(null,inst_29373__$1);
var inst_29375 = cljs.core.reset_BANG_.call(null,dctr,inst_29374);
var inst_29380 = cljs.core.seq.call(null,inst_29373__$1);
var inst_29381 = inst_29380;
var inst_29382 = null;
var inst_29383 = (0);
var inst_29384 = (0);
var state_29441__$1 = (function (){var statearr_29484 = state_29441;
(statearr_29484[(30)] = inst_29375);

(statearr_29484[(20)] = inst_29381);

(statearr_29484[(21)] = inst_29383);

(statearr_29484[(9)] = inst_29382);

(statearr_29484[(29)] = inst_29373__$1);

(statearr_29484[(11)] = inst_29384);

return statearr_29484;
})();
var statearr_29485_29551 = state_29441__$1;
(statearr_29485_29551[(2)] = null);

(statearr_29485_29551[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (28))){
var inst_29381 = (state_29441[(20)]);
var inst_29400 = (state_29441[(25)]);
var inst_29400__$1 = cljs.core.seq.call(null,inst_29381);
var state_29441__$1 = (function (){var statearr_29486 = state_29441;
(statearr_29486[(25)] = inst_29400__$1);

return statearr_29486;
})();
if(inst_29400__$1){
var statearr_29487_29552 = state_29441__$1;
(statearr_29487_29552[(1)] = (33));

} else {
var statearr_29488_29553 = state_29441__$1;
(statearr_29488_29553[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (25))){
var inst_29383 = (state_29441[(21)]);
var inst_29384 = (state_29441[(11)]);
var inst_29386 = (inst_29384 < inst_29383);
var inst_29387 = inst_29386;
var state_29441__$1 = state_29441;
if(cljs.core.truth_(inst_29387)){
var statearr_29489_29554 = state_29441__$1;
(statearr_29489_29554[(1)] = (27));

} else {
var statearr_29490_29555 = state_29441__$1;
(statearr_29490_29555[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (34))){
var state_29441__$1 = state_29441;
var statearr_29491_29556 = state_29441__$1;
(statearr_29491_29556[(2)] = null);

(statearr_29491_29556[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (17))){
var state_29441__$1 = state_29441;
var statearr_29492_29557 = state_29441__$1;
(statearr_29492_29557[(2)] = null);

(statearr_29492_29557[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (3))){
var inst_29439 = (state_29441[(2)]);
var state_29441__$1 = state_29441;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29441__$1,inst_29439);
} else {
if((state_val_29442 === (12))){
var inst_29368 = (state_29441[(2)]);
var state_29441__$1 = state_29441;
var statearr_29493_29558 = state_29441__$1;
(statearr_29493_29558[(2)] = inst_29368);

(statearr_29493_29558[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (2))){
var state_29441__$1 = state_29441;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29441__$1,(4),ch);
} else {
if((state_val_29442 === (23))){
var state_29441__$1 = state_29441;
var statearr_29494_29559 = state_29441__$1;
(statearr_29494_29559[(2)] = null);

(statearr_29494_29559[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (35))){
var inst_29423 = (state_29441[(2)]);
var state_29441__$1 = state_29441;
var statearr_29495_29560 = state_29441__$1;
(statearr_29495_29560[(2)] = inst_29423);

(statearr_29495_29560[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (19))){
var inst_29340 = (state_29441[(7)]);
var inst_29344 = cljs.core.chunk_first.call(null,inst_29340);
var inst_29345 = cljs.core.chunk_rest.call(null,inst_29340);
var inst_29346 = cljs.core.count.call(null,inst_29344);
var inst_29318 = inst_29345;
var inst_29319 = inst_29344;
var inst_29320 = inst_29346;
var inst_29321 = (0);
var state_29441__$1 = (function (){var statearr_29496 = state_29441;
(statearr_29496[(13)] = inst_29320);

(statearr_29496[(14)] = inst_29318);

(statearr_29496[(15)] = inst_29321);

(statearr_29496[(17)] = inst_29319);

return statearr_29496;
})();
var statearr_29497_29561 = state_29441__$1;
(statearr_29497_29561[(2)] = null);

(statearr_29497_29561[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (11))){
var inst_29340 = (state_29441[(7)]);
var inst_29318 = (state_29441[(14)]);
var inst_29340__$1 = cljs.core.seq.call(null,inst_29318);
var state_29441__$1 = (function (){var statearr_29498 = state_29441;
(statearr_29498[(7)] = inst_29340__$1);

return statearr_29498;
})();
if(inst_29340__$1){
var statearr_29499_29562 = state_29441__$1;
(statearr_29499_29562[(1)] = (16));

} else {
var statearr_29500_29563 = state_29441__$1;
(statearr_29500_29563[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (9))){
var inst_29370 = (state_29441[(2)]);
var state_29441__$1 = state_29441;
var statearr_29501_29564 = state_29441__$1;
(statearr_29501_29564[(2)] = inst_29370);

(statearr_29501_29564[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (5))){
var inst_29316 = cljs.core.deref.call(null,cs);
var inst_29317 = cljs.core.seq.call(null,inst_29316);
var inst_29318 = inst_29317;
var inst_29319 = null;
var inst_29320 = (0);
var inst_29321 = (0);
var state_29441__$1 = (function (){var statearr_29502 = state_29441;
(statearr_29502[(13)] = inst_29320);

(statearr_29502[(14)] = inst_29318);

(statearr_29502[(15)] = inst_29321);

(statearr_29502[(17)] = inst_29319);

return statearr_29502;
})();
var statearr_29503_29565 = state_29441__$1;
(statearr_29503_29565[(2)] = null);

(statearr_29503_29565[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (14))){
var state_29441__$1 = state_29441;
var statearr_29504_29566 = state_29441__$1;
(statearr_29504_29566[(2)] = null);

(statearr_29504_29566[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (45))){
var inst_29431 = (state_29441[(2)]);
var state_29441__$1 = state_29441;
var statearr_29505_29567 = state_29441__$1;
(statearr_29505_29567[(2)] = inst_29431);

(statearr_29505_29567[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (26))){
var inst_29373 = (state_29441[(29)]);
var inst_29427 = (state_29441[(2)]);
var inst_29428 = cljs.core.seq.call(null,inst_29373);
var state_29441__$1 = (function (){var statearr_29506 = state_29441;
(statearr_29506[(31)] = inst_29427);

return statearr_29506;
})();
if(inst_29428){
var statearr_29507_29568 = state_29441__$1;
(statearr_29507_29568[(1)] = (42));

} else {
var statearr_29508_29569 = state_29441__$1;
(statearr_29508_29569[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (16))){
var inst_29340 = (state_29441[(7)]);
var inst_29342 = cljs.core.chunked_seq_QMARK_.call(null,inst_29340);
var state_29441__$1 = state_29441;
if(inst_29342){
var statearr_29509_29570 = state_29441__$1;
(statearr_29509_29570[(1)] = (19));

} else {
var statearr_29510_29571 = state_29441__$1;
(statearr_29510_29571[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (38))){
var inst_29420 = (state_29441[(2)]);
var state_29441__$1 = state_29441;
var statearr_29511_29572 = state_29441__$1;
(statearr_29511_29572[(2)] = inst_29420);

(statearr_29511_29572[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (30))){
var state_29441__$1 = state_29441;
var statearr_29512_29573 = state_29441__$1;
(statearr_29512_29573[(2)] = null);

(statearr_29512_29573[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (10))){
var inst_29321 = (state_29441[(15)]);
var inst_29319 = (state_29441[(17)]);
var inst_29329 = cljs.core._nth.call(null,inst_29319,inst_29321);
var inst_29330 = cljs.core.nth.call(null,inst_29329,(0),null);
var inst_29331 = cljs.core.nth.call(null,inst_29329,(1),null);
var state_29441__$1 = (function (){var statearr_29513 = state_29441;
(statearr_29513[(26)] = inst_29330);

return statearr_29513;
})();
if(cljs.core.truth_(inst_29331)){
var statearr_29514_29574 = state_29441__$1;
(statearr_29514_29574[(1)] = (13));

} else {
var statearr_29515_29575 = state_29441__$1;
(statearr_29515_29575[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (18))){
var inst_29366 = (state_29441[(2)]);
var state_29441__$1 = state_29441;
var statearr_29516_29576 = state_29441__$1;
(statearr_29516_29576[(2)] = inst_29366);

(statearr_29516_29576[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (42))){
var state_29441__$1 = state_29441;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29441__$1,(45),dchan);
} else {
if((state_val_29442 === (37))){
var inst_29400 = (state_29441[(25)]);
var inst_29309 = (state_29441[(10)]);
var inst_29409 = (state_29441[(23)]);
var inst_29409__$1 = cljs.core.first.call(null,inst_29400);
var inst_29410 = cljs.core.async.put_BANG_.call(null,inst_29409__$1,inst_29309,done);
var state_29441__$1 = (function (){var statearr_29517 = state_29441;
(statearr_29517[(23)] = inst_29409__$1);

return statearr_29517;
})();
if(cljs.core.truth_(inst_29410)){
var statearr_29518_29577 = state_29441__$1;
(statearr_29518_29577[(1)] = (39));

} else {
var statearr_29519_29578 = state_29441__$1;
(statearr_29519_29578[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29442 === (8))){
var inst_29320 = (state_29441[(13)]);
var inst_29321 = (state_29441[(15)]);
var inst_29323 = (inst_29321 < inst_29320);
var inst_29324 = inst_29323;
var state_29441__$1 = state_29441;
if(cljs.core.truth_(inst_29324)){
var statearr_29520_29579 = state_29441__$1;
(statearr_29520_29579[(1)] = (10));

} else {
var statearr_29521_29580 = state_29441__$1;
(statearr_29521_29580[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__28609__auto__ = null;
var cljs$core$async$mult_$_state_machine__28609__auto____0 = (function (){
var statearr_29522 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29522[(0)] = cljs$core$async$mult_$_state_machine__28609__auto__);

(statearr_29522[(1)] = (1));

return statearr_29522;
});
var cljs$core$async$mult_$_state_machine__28609__auto____1 = (function (state_29441){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_29441);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e29523){if((e29523 instanceof Object)){
var ex__28612__auto__ = e29523;
var statearr_29524_29581 = state_29441;
(statearr_29524_29581[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29441);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29523;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29582 = state_29441;
state_29441 = G__29582;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__28609__auto__ = function(state_29441){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__28609__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__28609__auto____1.call(this,state_29441);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__28609__auto____0;
cljs$core$async$mult_$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__28609__auto____1;
return cljs$core$async$mult_$_state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_29525 = f__28704__auto__.call(null);
(statearr_29525[(6)] = c__28703__auto___29526);

return statearr_29525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__29584 = arguments.length;
switch (G__29584) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_29586 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_29586.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_29587 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_29587.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_29588 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m);
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_29588.call(null,m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_29589 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,state_map);
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_29589.call(null,m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_29590 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,mode);
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_29590.call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___29601 = arguments.length;
var i__4737__auto___29602 = (0);
while(true){
if((i__4737__auto___29602 < len__4736__auto___29601)){
args__4742__auto__.push((arguments[i__4737__auto___29602]));

var G__29603 = (i__4737__auto___29602 + (1));
i__4737__auto___29602 = G__29603;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__29595){
var map__29596 = p__29595;
var map__29596__$1 = (((((!((map__29596 == null))))?(((((map__29596.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29596.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29596):map__29596);
var opts = map__29596__$1;
var statearr_29598_29604 = state;
(statearr_29598_29604[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts.call(null,(function (val){
var statearr_29599_29605 = state;
(statearr_29599_29605[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_29600_29606 = state;
(statearr_29600_29606[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq29591){
var G__29592 = cljs.core.first.call(null,seq29591);
var seq29591__$1 = cljs.core.next.call(null,seq29591);
var G__29593 = cljs.core.first.call(null,seq29591__$1);
var seq29591__$2 = cljs.core.next.call(null,seq29591__$1);
var G__29594 = cljs.core.first.call(null,seq29591__$2);
var seq29591__$3 = cljs.core.next.call(null,seq29591__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29592,G__29593,G__29594,seq29591__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv.call(null,(function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29607 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29607 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta29608){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta29608 = meta29608;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29607.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29609,meta29608__$1){
var self__ = this;
var _29609__$1 = this;
return (new cljs.core.async.t_cljs$core$async29607(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta29608__$1));
}));

(cljs.core.async.t_cljs$core$async29607.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29609){
var self__ = this;
var _29609__$1 = this;
return self__.meta29608;
}));

(cljs.core.async.t_cljs$core$async29607.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29607.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async29607.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29607.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async29607.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async29607.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async29607.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async29607.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async29607.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta29608","meta29608",-2054665485,null)], null);
}));

(cljs.core.async.t_cljs$core$async29607.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29607.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29607");

(cljs.core.async.t_cljs$core$async29607.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async29607");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29607.
 */
cljs.core.async.__GT_t_cljs$core$async29607 = (function cljs$core$async$mix_$___GT_t_cljs$core$async29607(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29608){
return (new cljs.core.async.t_cljs$core$async29607(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29608));
});

}

return (new cljs.core.async.t_cljs$core$async29607(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__28703__auto___29771 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_29711){
var state_val_29712 = (state_29711[(1)]);
if((state_val_29712 === (7))){
var inst_29626 = (state_29711[(2)]);
var state_29711__$1 = state_29711;
var statearr_29713_29772 = state_29711__$1;
(statearr_29713_29772[(2)] = inst_29626);

(statearr_29713_29772[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (20))){
var inst_29638 = (state_29711[(7)]);
var state_29711__$1 = state_29711;
var statearr_29714_29773 = state_29711__$1;
(statearr_29714_29773[(2)] = inst_29638);

(statearr_29714_29773[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (27))){
var state_29711__$1 = state_29711;
var statearr_29715_29774 = state_29711__$1;
(statearr_29715_29774[(2)] = null);

(statearr_29715_29774[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (1))){
var inst_29613 = (state_29711[(8)]);
var inst_29613__$1 = calc_state.call(null);
var inst_29615 = (inst_29613__$1 == null);
var inst_29616 = cljs.core.not.call(null,inst_29615);
var state_29711__$1 = (function (){var statearr_29716 = state_29711;
(statearr_29716[(8)] = inst_29613__$1);

return statearr_29716;
})();
if(inst_29616){
var statearr_29717_29775 = state_29711__$1;
(statearr_29717_29775[(1)] = (2));

} else {
var statearr_29718_29776 = state_29711__$1;
(statearr_29718_29776[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (24))){
var inst_29685 = (state_29711[(9)]);
var inst_29671 = (state_29711[(10)]);
var inst_29662 = (state_29711[(11)]);
var inst_29685__$1 = inst_29662.call(null,inst_29671);
var state_29711__$1 = (function (){var statearr_29719 = state_29711;
(statearr_29719[(9)] = inst_29685__$1);

return statearr_29719;
})();
if(cljs.core.truth_(inst_29685__$1)){
var statearr_29720_29777 = state_29711__$1;
(statearr_29720_29777[(1)] = (29));

} else {
var statearr_29721_29778 = state_29711__$1;
(statearr_29721_29778[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (4))){
var inst_29629 = (state_29711[(2)]);
var state_29711__$1 = state_29711;
if(cljs.core.truth_(inst_29629)){
var statearr_29722_29779 = state_29711__$1;
(statearr_29722_29779[(1)] = (8));

} else {
var statearr_29723_29780 = state_29711__$1;
(statearr_29723_29780[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (15))){
var inst_29656 = (state_29711[(2)]);
var state_29711__$1 = state_29711;
if(cljs.core.truth_(inst_29656)){
var statearr_29724_29781 = state_29711__$1;
(statearr_29724_29781[(1)] = (19));

} else {
var statearr_29725_29782 = state_29711__$1;
(statearr_29725_29782[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (21))){
var inst_29661 = (state_29711[(12)]);
var inst_29661__$1 = (state_29711[(2)]);
var inst_29662 = cljs.core.get.call(null,inst_29661__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29663 = cljs.core.get.call(null,inst_29661__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29664 = cljs.core.get.call(null,inst_29661__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_29711__$1 = (function (){var statearr_29726 = state_29711;
(statearr_29726[(12)] = inst_29661__$1);

(statearr_29726[(13)] = inst_29663);

(statearr_29726[(11)] = inst_29662);

return statearr_29726;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_29711__$1,(22),inst_29664);
} else {
if((state_val_29712 === (31))){
var inst_29693 = (state_29711[(2)]);
var state_29711__$1 = state_29711;
if(cljs.core.truth_(inst_29693)){
var statearr_29727_29783 = state_29711__$1;
(statearr_29727_29783[(1)] = (32));

} else {
var statearr_29728_29784 = state_29711__$1;
(statearr_29728_29784[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (32))){
var inst_29670 = (state_29711[(14)]);
var state_29711__$1 = state_29711;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29711__$1,(35),out,inst_29670);
} else {
if((state_val_29712 === (33))){
var inst_29661 = (state_29711[(12)]);
var inst_29638 = inst_29661;
var state_29711__$1 = (function (){var statearr_29729 = state_29711;
(statearr_29729[(7)] = inst_29638);

return statearr_29729;
})();
var statearr_29730_29785 = state_29711__$1;
(statearr_29730_29785[(2)] = null);

(statearr_29730_29785[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (13))){
var inst_29638 = (state_29711[(7)]);
var inst_29645 = inst_29638.cljs$lang$protocol_mask$partition0$;
var inst_29646 = (inst_29645 & (64));
var inst_29647 = inst_29638.cljs$core$ISeq$;
var inst_29648 = (cljs.core.PROTOCOL_SENTINEL === inst_29647);
var inst_29649 = ((inst_29646) || (inst_29648));
var state_29711__$1 = state_29711;
if(cljs.core.truth_(inst_29649)){
var statearr_29731_29786 = state_29711__$1;
(statearr_29731_29786[(1)] = (16));

} else {
var statearr_29732_29787 = state_29711__$1;
(statearr_29732_29787[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (22))){
var inst_29671 = (state_29711[(10)]);
var inst_29670 = (state_29711[(14)]);
var inst_29669 = (state_29711[(2)]);
var inst_29670__$1 = cljs.core.nth.call(null,inst_29669,(0),null);
var inst_29671__$1 = cljs.core.nth.call(null,inst_29669,(1),null);
var inst_29672 = (inst_29670__$1 == null);
var inst_29673 = cljs.core._EQ_.call(null,inst_29671__$1,change);
var inst_29674 = ((inst_29672) || (inst_29673));
var state_29711__$1 = (function (){var statearr_29733 = state_29711;
(statearr_29733[(10)] = inst_29671__$1);

(statearr_29733[(14)] = inst_29670__$1);

return statearr_29733;
})();
if(cljs.core.truth_(inst_29674)){
var statearr_29734_29788 = state_29711__$1;
(statearr_29734_29788[(1)] = (23));

} else {
var statearr_29735_29789 = state_29711__$1;
(statearr_29735_29789[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (36))){
var inst_29661 = (state_29711[(12)]);
var inst_29638 = inst_29661;
var state_29711__$1 = (function (){var statearr_29736 = state_29711;
(statearr_29736[(7)] = inst_29638);

return statearr_29736;
})();
var statearr_29737_29790 = state_29711__$1;
(statearr_29737_29790[(2)] = null);

(statearr_29737_29790[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (29))){
var inst_29685 = (state_29711[(9)]);
var state_29711__$1 = state_29711;
var statearr_29738_29791 = state_29711__$1;
(statearr_29738_29791[(2)] = inst_29685);

(statearr_29738_29791[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (6))){
var state_29711__$1 = state_29711;
var statearr_29739_29792 = state_29711__$1;
(statearr_29739_29792[(2)] = false);

(statearr_29739_29792[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (28))){
var inst_29681 = (state_29711[(2)]);
var inst_29682 = calc_state.call(null);
var inst_29638 = inst_29682;
var state_29711__$1 = (function (){var statearr_29740 = state_29711;
(statearr_29740[(7)] = inst_29638);

(statearr_29740[(15)] = inst_29681);

return statearr_29740;
})();
var statearr_29741_29793 = state_29711__$1;
(statearr_29741_29793[(2)] = null);

(statearr_29741_29793[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (25))){
var inst_29707 = (state_29711[(2)]);
var state_29711__$1 = state_29711;
var statearr_29742_29794 = state_29711__$1;
(statearr_29742_29794[(2)] = inst_29707);

(statearr_29742_29794[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (34))){
var inst_29705 = (state_29711[(2)]);
var state_29711__$1 = state_29711;
var statearr_29743_29795 = state_29711__$1;
(statearr_29743_29795[(2)] = inst_29705);

(statearr_29743_29795[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (17))){
var state_29711__$1 = state_29711;
var statearr_29744_29796 = state_29711__$1;
(statearr_29744_29796[(2)] = false);

(statearr_29744_29796[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (3))){
var state_29711__$1 = state_29711;
var statearr_29745_29797 = state_29711__$1;
(statearr_29745_29797[(2)] = false);

(statearr_29745_29797[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (12))){
var inst_29709 = (state_29711[(2)]);
var state_29711__$1 = state_29711;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29711__$1,inst_29709);
} else {
if((state_val_29712 === (2))){
var inst_29613 = (state_29711[(8)]);
var inst_29618 = inst_29613.cljs$lang$protocol_mask$partition0$;
var inst_29619 = (inst_29618 & (64));
var inst_29620 = inst_29613.cljs$core$ISeq$;
var inst_29621 = (cljs.core.PROTOCOL_SENTINEL === inst_29620);
var inst_29622 = ((inst_29619) || (inst_29621));
var state_29711__$1 = state_29711;
if(cljs.core.truth_(inst_29622)){
var statearr_29746_29798 = state_29711__$1;
(statearr_29746_29798[(1)] = (5));

} else {
var statearr_29747_29799 = state_29711__$1;
(statearr_29747_29799[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (23))){
var inst_29670 = (state_29711[(14)]);
var inst_29676 = (inst_29670 == null);
var state_29711__$1 = state_29711;
if(cljs.core.truth_(inst_29676)){
var statearr_29748_29800 = state_29711__$1;
(statearr_29748_29800[(1)] = (26));

} else {
var statearr_29749_29801 = state_29711__$1;
(statearr_29749_29801[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (35))){
var inst_29696 = (state_29711[(2)]);
var state_29711__$1 = state_29711;
if(cljs.core.truth_(inst_29696)){
var statearr_29750_29802 = state_29711__$1;
(statearr_29750_29802[(1)] = (36));

} else {
var statearr_29751_29803 = state_29711__$1;
(statearr_29751_29803[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (19))){
var inst_29638 = (state_29711[(7)]);
var inst_29658 = cljs.core.apply.call(null,cljs.core.hash_map,inst_29638);
var state_29711__$1 = state_29711;
var statearr_29752_29804 = state_29711__$1;
(statearr_29752_29804[(2)] = inst_29658);

(statearr_29752_29804[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (11))){
var inst_29638 = (state_29711[(7)]);
var inst_29642 = (inst_29638 == null);
var inst_29643 = cljs.core.not.call(null,inst_29642);
var state_29711__$1 = state_29711;
if(inst_29643){
var statearr_29753_29805 = state_29711__$1;
(statearr_29753_29805[(1)] = (13));

} else {
var statearr_29754_29806 = state_29711__$1;
(statearr_29754_29806[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (9))){
var inst_29613 = (state_29711[(8)]);
var state_29711__$1 = state_29711;
var statearr_29755_29807 = state_29711__$1;
(statearr_29755_29807[(2)] = inst_29613);

(statearr_29755_29807[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (5))){
var state_29711__$1 = state_29711;
var statearr_29756_29808 = state_29711__$1;
(statearr_29756_29808[(2)] = true);

(statearr_29756_29808[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (14))){
var state_29711__$1 = state_29711;
var statearr_29757_29809 = state_29711__$1;
(statearr_29757_29809[(2)] = false);

(statearr_29757_29809[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (26))){
var inst_29671 = (state_29711[(10)]);
var inst_29678 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_29671);
var state_29711__$1 = state_29711;
var statearr_29758_29810 = state_29711__$1;
(statearr_29758_29810[(2)] = inst_29678);

(statearr_29758_29810[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (16))){
var state_29711__$1 = state_29711;
var statearr_29759_29811 = state_29711__$1;
(statearr_29759_29811[(2)] = true);

(statearr_29759_29811[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (38))){
var inst_29701 = (state_29711[(2)]);
var state_29711__$1 = state_29711;
var statearr_29760_29812 = state_29711__$1;
(statearr_29760_29812[(2)] = inst_29701);

(statearr_29760_29812[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (30))){
var inst_29663 = (state_29711[(13)]);
var inst_29671 = (state_29711[(10)]);
var inst_29662 = (state_29711[(11)]);
var inst_29688 = cljs.core.empty_QMARK_.call(null,inst_29662);
var inst_29689 = inst_29663.call(null,inst_29671);
var inst_29690 = cljs.core.not.call(null,inst_29689);
var inst_29691 = ((inst_29688) && (inst_29690));
var state_29711__$1 = state_29711;
var statearr_29761_29813 = state_29711__$1;
(statearr_29761_29813[(2)] = inst_29691);

(statearr_29761_29813[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (10))){
var inst_29613 = (state_29711[(8)]);
var inst_29634 = (state_29711[(2)]);
var inst_29635 = cljs.core.get.call(null,inst_29634,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29636 = cljs.core.get.call(null,inst_29634,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29637 = cljs.core.get.call(null,inst_29634,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_29638 = inst_29613;
var state_29711__$1 = (function (){var statearr_29762 = state_29711;
(statearr_29762[(16)] = inst_29635);

(statearr_29762[(7)] = inst_29638);

(statearr_29762[(17)] = inst_29636);

(statearr_29762[(18)] = inst_29637);

return statearr_29762;
})();
var statearr_29763_29814 = state_29711__$1;
(statearr_29763_29814[(2)] = null);

(statearr_29763_29814[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (18))){
var inst_29653 = (state_29711[(2)]);
var state_29711__$1 = state_29711;
var statearr_29764_29815 = state_29711__$1;
(statearr_29764_29815[(2)] = inst_29653);

(statearr_29764_29815[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (37))){
var state_29711__$1 = state_29711;
var statearr_29765_29816 = state_29711__$1;
(statearr_29765_29816[(2)] = null);

(statearr_29765_29816[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29712 === (8))){
var inst_29613 = (state_29711[(8)]);
var inst_29631 = cljs.core.apply.call(null,cljs.core.hash_map,inst_29613);
var state_29711__$1 = state_29711;
var statearr_29766_29817 = state_29711__$1;
(statearr_29766_29817[(2)] = inst_29631);

(statearr_29766_29817[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__28609__auto__ = null;
var cljs$core$async$mix_$_state_machine__28609__auto____0 = (function (){
var statearr_29767 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29767[(0)] = cljs$core$async$mix_$_state_machine__28609__auto__);

(statearr_29767[(1)] = (1));

return statearr_29767;
});
var cljs$core$async$mix_$_state_machine__28609__auto____1 = (function (state_29711){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_29711);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e29768){if((e29768 instanceof Object)){
var ex__28612__auto__ = e29768;
var statearr_29769_29818 = state_29711;
(statearr_29769_29818[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29711);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29768;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29819 = state_29711;
state_29711 = G__29819;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__28609__auto__ = function(state_29711){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__28609__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__28609__auto____1.call(this,state_29711);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__28609__auto____0;
cljs$core$async$mix_$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__28609__auto____1;
return cljs$core$async$mix_$_state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_29770 = f__28704__auto__.call(null);
(statearr_29770[(6)] = c__28703__auto___29771);

return statearr_29770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_29822 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_29822.call(null,p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_29823 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v,ch);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_29823.call(null,p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_29824 = (function() {
var G__29825 = null;
var G__29825__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
var G__29825__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
G__29825 = function(p,v){
switch(arguments.length){
case 1:
return G__29825__1.call(this,p);
case 2:
return G__29825__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__29825.cljs$core$IFn$_invoke$arity$1 = G__29825__1;
G__29825.cljs$core$IFn$_invoke$arity$2 = G__29825__2;
return G__29825;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__29821 = arguments.length;
switch (G__29821) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_29824.call(null,p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_29824.call(null,p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__29829 = arguments.length;
switch (G__29829) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,(function (p1__29827_SHARP_){
if(cljs.core.truth_(p1__29827_SHARP_.call(null,topic))){
return p1__29827_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__29827_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29830 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29830 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta29831){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta29831 = meta29831;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29830.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29832,meta29831__$1){
var self__ = this;
var _29832__$1 = this;
return (new cljs.core.async.t_cljs$core$async29830(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta29831__$1));
}));

(cljs.core.async.t_cljs$core$async29830.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29832){
var self__ = this;
var _29832__$1 = this;
return self__.meta29831;
}));

(cljs.core.async.t_cljs$core$async29830.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29830.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async29830.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29830.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async29830.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async29830.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async29830.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async29830.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta29831","meta29831",1632427469,null)], null);
}));

(cljs.core.async.t_cljs$core$async29830.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29830.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29830");

(cljs.core.async.t_cljs$core$async29830.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async29830");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29830.
 */
cljs.core.async.__GT_t_cljs$core$async29830 = (function cljs$core$async$__GT_t_cljs$core$async29830(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29831){
return (new cljs.core.async.t_cljs$core$async29830(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29831));
});

}

return (new cljs.core.async.t_cljs$core$async29830(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__28703__auto___29950 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_29904){
var state_val_29905 = (state_29904[(1)]);
if((state_val_29905 === (7))){
var inst_29900 = (state_29904[(2)]);
var state_29904__$1 = state_29904;
var statearr_29906_29951 = state_29904__$1;
(statearr_29906_29951[(2)] = inst_29900);

(statearr_29906_29951[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29905 === (20))){
var state_29904__$1 = state_29904;
var statearr_29907_29952 = state_29904__$1;
(statearr_29907_29952[(2)] = null);

(statearr_29907_29952[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29905 === (1))){
var state_29904__$1 = state_29904;
var statearr_29908_29953 = state_29904__$1;
(statearr_29908_29953[(2)] = null);

(statearr_29908_29953[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29905 === (24))){
var inst_29883 = (state_29904[(7)]);
var inst_29892 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_29883);
var state_29904__$1 = state_29904;
var statearr_29909_29954 = state_29904__$1;
(statearr_29909_29954[(2)] = inst_29892);

(statearr_29909_29954[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29905 === (4))){
var inst_29835 = (state_29904[(8)]);
var inst_29835__$1 = (state_29904[(2)]);
var inst_29836 = (inst_29835__$1 == null);
var state_29904__$1 = (function (){var statearr_29910 = state_29904;
(statearr_29910[(8)] = inst_29835__$1);

return statearr_29910;
})();
if(cljs.core.truth_(inst_29836)){
var statearr_29911_29955 = state_29904__$1;
(statearr_29911_29955[(1)] = (5));

} else {
var statearr_29912_29956 = state_29904__$1;
(statearr_29912_29956[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29905 === (15))){
var inst_29877 = (state_29904[(2)]);
var state_29904__$1 = state_29904;
var statearr_29913_29957 = state_29904__$1;
(statearr_29913_29957[(2)] = inst_29877);

(statearr_29913_29957[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29905 === (21))){
var inst_29897 = (state_29904[(2)]);
var state_29904__$1 = (function (){var statearr_29914 = state_29904;
(statearr_29914[(9)] = inst_29897);

return statearr_29914;
})();
var statearr_29915_29958 = state_29904__$1;
(statearr_29915_29958[(2)] = null);

(statearr_29915_29958[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29905 === (13))){
var inst_29859 = (state_29904[(10)]);
var inst_29861 = cljs.core.chunked_seq_QMARK_.call(null,inst_29859);
var state_29904__$1 = state_29904;
if(inst_29861){
var statearr_29916_29959 = state_29904__$1;
(statearr_29916_29959[(1)] = (16));

} else {
var statearr_29917_29960 = state_29904__$1;
(statearr_29917_29960[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29905 === (22))){
var inst_29889 = (state_29904[(2)]);
var state_29904__$1 = state_29904;
if(cljs.core.truth_(inst_29889)){
var statearr_29918_29961 = state_29904__$1;
(statearr_29918_29961[(1)] = (23));

} else {
var statearr_29919_29962 = state_29904__$1;
(statearr_29919_29962[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29905 === (6))){
var inst_29885 = (state_29904[(11)]);
var inst_29835 = (state_29904[(8)]);
var inst_29883 = (state_29904[(7)]);
var inst_29883__$1 = topic_fn.call(null,inst_29835);
var inst_29884 = cljs.core.deref.call(null,mults);
var inst_29885__$1 = cljs.core.get.call(null,inst_29884,inst_29883__$1);
var state_29904__$1 = (function (){var statearr_29920 = state_29904;
(statearr_29920[(11)] = inst_29885__$1);

(statearr_29920[(7)] = inst_29883__$1);

return statearr_29920;
})();
if(cljs.core.truth_(inst_29885__$1)){
var statearr_29921_29963 = state_29904__$1;
(statearr_29921_29963[(1)] = (19));

} else {
var statearr_29922_29964 = state_29904__$1;
(statearr_29922_29964[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29905 === (25))){
var inst_29894 = (state_29904[(2)]);
var state_29904__$1 = state_29904;
var statearr_29923_29965 = state_29904__$1;
(statearr_29923_29965[(2)] = inst_29894);

(statearr_29923_29965[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29905 === (17))){
var inst_29859 = (state_29904[(10)]);
var inst_29868 = cljs.core.first.call(null,inst_29859);
var inst_29869 = cljs.core.async.muxch_STAR_.call(null,inst_29868);
var inst_29870 = cljs.core.async.close_BANG_.call(null,inst_29869);
var inst_29871 = cljs.core.next.call(null,inst_29859);
var inst_29845 = inst_29871;
var inst_29846 = null;
var inst_29847 = (0);
var inst_29848 = (0);
var state_29904__$1 = (function (){var statearr_29924 = state_29904;
(statearr_29924[(12)] = inst_29848);

(statearr_29924[(13)] = inst_29870);

(statearr_29924[(14)] = inst_29845);

(statearr_29924[(15)] = inst_29847);

(statearr_29924[(16)] = inst_29846);

return statearr_29924;
})();
var statearr_29925_29966 = state_29904__$1;
(statearr_29925_29966[(2)] = null);

(statearr_29925_29966[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29905 === (3))){
var inst_29902 = (state_29904[(2)]);
var state_29904__$1 = state_29904;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29904__$1,inst_29902);
} else {
if((state_val_29905 === (12))){
var inst_29879 = (state_29904[(2)]);
var state_29904__$1 = state_29904;
var statearr_29926_29967 = state_29904__$1;
(statearr_29926_29967[(2)] = inst_29879);

(statearr_29926_29967[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29905 === (2))){
var state_29904__$1 = state_29904;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29904__$1,(4),ch);
} else {
if((state_val_29905 === (23))){
var state_29904__$1 = state_29904;
var statearr_29927_29968 = state_29904__$1;
(statearr_29927_29968[(2)] = null);

(statearr_29927_29968[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29905 === (19))){
var inst_29885 = (state_29904[(11)]);
var inst_29835 = (state_29904[(8)]);
var inst_29887 = cljs.core.async.muxch_STAR_.call(null,inst_29885);
var state_29904__$1 = state_29904;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29904__$1,(22),inst_29887,inst_29835);
} else {
if((state_val_29905 === (11))){
var inst_29859 = (state_29904[(10)]);
var inst_29845 = (state_29904[(14)]);
var inst_29859__$1 = cljs.core.seq.call(null,inst_29845);
var state_29904__$1 = (function (){var statearr_29928 = state_29904;
(statearr_29928[(10)] = inst_29859__$1);

return statearr_29928;
})();
if(inst_29859__$1){
var statearr_29929_29969 = state_29904__$1;
(statearr_29929_29969[(1)] = (13));

} else {
var statearr_29930_29970 = state_29904__$1;
(statearr_29930_29970[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29905 === (9))){
var inst_29881 = (state_29904[(2)]);
var state_29904__$1 = state_29904;
var statearr_29931_29971 = state_29904__$1;
(statearr_29931_29971[(2)] = inst_29881);

(statearr_29931_29971[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29905 === (5))){
var inst_29842 = cljs.core.deref.call(null,mults);
var inst_29843 = cljs.core.vals.call(null,inst_29842);
var inst_29844 = cljs.core.seq.call(null,inst_29843);
var inst_29845 = inst_29844;
var inst_29846 = null;
var inst_29847 = (0);
var inst_29848 = (0);
var state_29904__$1 = (function (){var statearr_29932 = state_29904;
(statearr_29932[(12)] = inst_29848);

(statearr_29932[(14)] = inst_29845);

(statearr_29932[(15)] = inst_29847);

(statearr_29932[(16)] = inst_29846);

return statearr_29932;
})();
var statearr_29933_29972 = state_29904__$1;
(statearr_29933_29972[(2)] = null);

(statearr_29933_29972[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29905 === (14))){
var state_29904__$1 = state_29904;
var statearr_29937_29973 = state_29904__$1;
(statearr_29937_29973[(2)] = null);

(statearr_29937_29973[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29905 === (16))){
var inst_29859 = (state_29904[(10)]);
var inst_29863 = cljs.core.chunk_first.call(null,inst_29859);
var inst_29864 = cljs.core.chunk_rest.call(null,inst_29859);
var inst_29865 = cljs.core.count.call(null,inst_29863);
var inst_29845 = inst_29864;
var inst_29846 = inst_29863;
var inst_29847 = inst_29865;
var inst_29848 = (0);
var state_29904__$1 = (function (){var statearr_29938 = state_29904;
(statearr_29938[(12)] = inst_29848);

(statearr_29938[(14)] = inst_29845);

(statearr_29938[(15)] = inst_29847);

(statearr_29938[(16)] = inst_29846);

return statearr_29938;
})();
var statearr_29939_29974 = state_29904__$1;
(statearr_29939_29974[(2)] = null);

(statearr_29939_29974[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29905 === (10))){
var inst_29848 = (state_29904[(12)]);
var inst_29845 = (state_29904[(14)]);
var inst_29847 = (state_29904[(15)]);
var inst_29846 = (state_29904[(16)]);
var inst_29853 = cljs.core._nth.call(null,inst_29846,inst_29848);
var inst_29854 = cljs.core.async.muxch_STAR_.call(null,inst_29853);
var inst_29855 = cljs.core.async.close_BANG_.call(null,inst_29854);
var inst_29856 = (inst_29848 + (1));
var tmp29934 = inst_29845;
var tmp29935 = inst_29847;
var tmp29936 = inst_29846;
var inst_29845__$1 = tmp29934;
var inst_29846__$1 = tmp29936;
var inst_29847__$1 = tmp29935;
var inst_29848__$1 = inst_29856;
var state_29904__$1 = (function (){var statearr_29940 = state_29904;
(statearr_29940[(12)] = inst_29848__$1);

(statearr_29940[(17)] = inst_29855);

(statearr_29940[(14)] = inst_29845__$1);

(statearr_29940[(15)] = inst_29847__$1);

(statearr_29940[(16)] = inst_29846__$1);

return statearr_29940;
})();
var statearr_29941_29975 = state_29904__$1;
(statearr_29941_29975[(2)] = null);

(statearr_29941_29975[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29905 === (18))){
var inst_29874 = (state_29904[(2)]);
var state_29904__$1 = state_29904;
var statearr_29942_29976 = state_29904__$1;
(statearr_29942_29976[(2)] = inst_29874);

(statearr_29942_29976[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29905 === (8))){
var inst_29848 = (state_29904[(12)]);
var inst_29847 = (state_29904[(15)]);
var inst_29850 = (inst_29848 < inst_29847);
var inst_29851 = inst_29850;
var state_29904__$1 = state_29904;
if(cljs.core.truth_(inst_29851)){
var statearr_29943_29977 = state_29904__$1;
(statearr_29943_29977[(1)] = (10));

} else {
var statearr_29944_29978 = state_29904__$1;
(statearr_29944_29978[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28609__auto__ = null;
var cljs$core$async$state_machine__28609__auto____0 = (function (){
var statearr_29945 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29945[(0)] = cljs$core$async$state_machine__28609__auto__);

(statearr_29945[(1)] = (1));

return statearr_29945;
});
var cljs$core$async$state_machine__28609__auto____1 = (function (state_29904){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_29904);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e29946){if((e29946 instanceof Object)){
var ex__28612__auto__ = e29946;
var statearr_29947_29979 = state_29904;
(statearr_29947_29979[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29904);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29946;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29980 = state_29904;
state_29904 = G__29980;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
cljs$core$async$state_machine__28609__auto__ = function(state_29904){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28609__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28609__auto____1.call(this,state_29904);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28609__auto____0;
cljs$core$async$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28609__auto____1;
return cljs$core$async$state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_29948 = f__28704__auto__.call(null);
(statearr_29948[(6)] = c__28703__auto___29950);

return statearr_29948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__29982 = arguments.length;
switch (G__29982) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__29985 = arguments.length;
switch (G__29985) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__29988 = arguments.length;
switch (G__29988) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,(function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.call(null,cnt));
var c__28703__auto___30055 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_30027){
var state_val_30028 = (state_30027[(1)]);
if((state_val_30028 === (7))){
var state_30027__$1 = state_30027;
var statearr_30029_30056 = state_30027__$1;
(statearr_30029_30056[(2)] = null);

(statearr_30029_30056[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30028 === (1))){
var state_30027__$1 = state_30027;
var statearr_30030_30057 = state_30027__$1;
(statearr_30030_30057[(2)] = null);

(statearr_30030_30057[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30028 === (4))){
var inst_29991 = (state_30027[(7)]);
var inst_29993 = (inst_29991 < cnt);
var state_30027__$1 = state_30027;
if(cljs.core.truth_(inst_29993)){
var statearr_30031_30058 = state_30027__$1;
(statearr_30031_30058[(1)] = (6));

} else {
var statearr_30032_30059 = state_30027__$1;
(statearr_30032_30059[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30028 === (15))){
var inst_30023 = (state_30027[(2)]);
var state_30027__$1 = state_30027;
var statearr_30033_30060 = state_30027__$1;
(statearr_30033_30060[(2)] = inst_30023);

(statearr_30033_30060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30028 === (13))){
var inst_30016 = cljs.core.async.close_BANG_.call(null,out);
var state_30027__$1 = state_30027;
var statearr_30034_30061 = state_30027__$1;
(statearr_30034_30061[(2)] = inst_30016);

(statearr_30034_30061[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30028 === (6))){
var state_30027__$1 = state_30027;
var statearr_30035_30062 = state_30027__$1;
(statearr_30035_30062[(2)] = null);

(statearr_30035_30062[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30028 === (3))){
var inst_30025 = (state_30027[(2)]);
var state_30027__$1 = state_30027;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30027__$1,inst_30025);
} else {
if((state_val_30028 === (12))){
var inst_30013 = (state_30027[(8)]);
var inst_30013__$1 = (state_30027[(2)]);
var inst_30014 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_30013__$1);
var state_30027__$1 = (function (){var statearr_30036 = state_30027;
(statearr_30036[(8)] = inst_30013__$1);

return statearr_30036;
})();
if(cljs.core.truth_(inst_30014)){
var statearr_30037_30063 = state_30027__$1;
(statearr_30037_30063[(1)] = (13));

} else {
var statearr_30038_30064 = state_30027__$1;
(statearr_30038_30064[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30028 === (2))){
var inst_29990 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_29991 = (0);
var state_30027__$1 = (function (){var statearr_30039 = state_30027;
(statearr_30039[(7)] = inst_29991);

(statearr_30039[(9)] = inst_29990);

return statearr_30039;
})();
var statearr_30040_30065 = state_30027__$1;
(statearr_30040_30065[(2)] = null);

(statearr_30040_30065[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30028 === (11))){
var inst_29991 = (state_30027[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_30027,(10),Object,null,(9));
var inst_30000 = chs__$1.call(null,inst_29991);
var inst_30001 = done.call(null,inst_29991);
var inst_30002 = cljs.core.async.take_BANG_.call(null,inst_30000,inst_30001);
var state_30027__$1 = state_30027;
var statearr_30041_30066 = state_30027__$1;
(statearr_30041_30066[(2)] = inst_30002);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30027__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30028 === (9))){
var inst_29991 = (state_30027[(7)]);
var inst_30004 = (state_30027[(2)]);
var inst_30005 = (inst_29991 + (1));
var inst_29991__$1 = inst_30005;
var state_30027__$1 = (function (){var statearr_30042 = state_30027;
(statearr_30042[(7)] = inst_29991__$1);

(statearr_30042[(10)] = inst_30004);

return statearr_30042;
})();
var statearr_30043_30067 = state_30027__$1;
(statearr_30043_30067[(2)] = null);

(statearr_30043_30067[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30028 === (5))){
var inst_30011 = (state_30027[(2)]);
var state_30027__$1 = (function (){var statearr_30044 = state_30027;
(statearr_30044[(11)] = inst_30011);

return statearr_30044;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30027__$1,(12),dchan);
} else {
if((state_val_30028 === (14))){
var inst_30013 = (state_30027[(8)]);
var inst_30018 = cljs.core.apply.call(null,f,inst_30013);
var state_30027__$1 = state_30027;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30027__$1,(16),out,inst_30018);
} else {
if((state_val_30028 === (16))){
var inst_30020 = (state_30027[(2)]);
var state_30027__$1 = (function (){var statearr_30045 = state_30027;
(statearr_30045[(12)] = inst_30020);

return statearr_30045;
})();
var statearr_30046_30068 = state_30027__$1;
(statearr_30046_30068[(2)] = null);

(statearr_30046_30068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30028 === (10))){
var inst_29995 = (state_30027[(2)]);
var inst_29996 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_30027__$1 = (function (){var statearr_30047 = state_30027;
(statearr_30047[(13)] = inst_29995);

return statearr_30047;
})();
var statearr_30048_30069 = state_30027__$1;
(statearr_30048_30069[(2)] = inst_29996);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30027__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30028 === (8))){
var inst_30009 = (state_30027[(2)]);
var state_30027__$1 = state_30027;
var statearr_30049_30070 = state_30027__$1;
(statearr_30049_30070[(2)] = inst_30009);

(statearr_30049_30070[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28609__auto__ = null;
var cljs$core$async$state_machine__28609__auto____0 = (function (){
var statearr_30050 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30050[(0)] = cljs$core$async$state_machine__28609__auto__);

(statearr_30050[(1)] = (1));

return statearr_30050;
});
var cljs$core$async$state_machine__28609__auto____1 = (function (state_30027){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_30027);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e30051){if((e30051 instanceof Object)){
var ex__28612__auto__ = e30051;
var statearr_30052_30071 = state_30027;
(statearr_30052_30071[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30027);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30051;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30072 = state_30027;
state_30027 = G__30072;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
cljs$core$async$state_machine__28609__auto__ = function(state_30027){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28609__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28609__auto____1.call(this,state_30027);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28609__auto____0;
cljs$core$async$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28609__auto____1;
return cljs$core$async$state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_30053 = f__28704__auto__.call(null);
(statearr_30053[(6)] = c__28703__auto___30055);

return statearr_30053;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__30075 = arguments.length;
switch (G__30075) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__28703__auto___30129 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_30107){
var state_val_30108 = (state_30107[(1)]);
if((state_val_30108 === (7))){
var inst_30086 = (state_30107[(7)]);
var inst_30087 = (state_30107[(8)]);
var inst_30086__$1 = (state_30107[(2)]);
var inst_30087__$1 = cljs.core.nth.call(null,inst_30086__$1,(0),null);
var inst_30088 = cljs.core.nth.call(null,inst_30086__$1,(1),null);
var inst_30089 = (inst_30087__$1 == null);
var state_30107__$1 = (function (){var statearr_30109 = state_30107;
(statearr_30109[(7)] = inst_30086__$1);

(statearr_30109[(8)] = inst_30087__$1);

(statearr_30109[(9)] = inst_30088);

return statearr_30109;
})();
if(cljs.core.truth_(inst_30089)){
var statearr_30110_30130 = state_30107__$1;
(statearr_30110_30130[(1)] = (8));

} else {
var statearr_30111_30131 = state_30107__$1;
(statearr_30111_30131[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30108 === (1))){
var inst_30076 = cljs.core.vec.call(null,chs);
var inst_30077 = inst_30076;
var state_30107__$1 = (function (){var statearr_30112 = state_30107;
(statearr_30112[(10)] = inst_30077);

return statearr_30112;
})();
var statearr_30113_30132 = state_30107__$1;
(statearr_30113_30132[(2)] = null);

(statearr_30113_30132[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30108 === (4))){
var inst_30077 = (state_30107[(10)]);
var state_30107__$1 = state_30107;
return cljs.core.async.ioc_alts_BANG_.call(null,state_30107__$1,(7),inst_30077);
} else {
if((state_val_30108 === (6))){
var inst_30103 = (state_30107[(2)]);
var state_30107__$1 = state_30107;
var statearr_30114_30133 = state_30107__$1;
(statearr_30114_30133[(2)] = inst_30103);

(statearr_30114_30133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30108 === (3))){
var inst_30105 = (state_30107[(2)]);
var state_30107__$1 = state_30107;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30107__$1,inst_30105);
} else {
if((state_val_30108 === (2))){
var inst_30077 = (state_30107[(10)]);
var inst_30079 = cljs.core.count.call(null,inst_30077);
var inst_30080 = (inst_30079 > (0));
var state_30107__$1 = state_30107;
if(cljs.core.truth_(inst_30080)){
var statearr_30116_30134 = state_30107__$1;
(statearr_30116_30134[(1)] = (4));

} else {
var statearr_30117_30135 = state_30107__$1;
(statearr_30117_30135[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30108 === (11))){
var inst_30077 = (state_30107[(10)]);
var inst_30096 = (state_30107[(2)]);
var tmp30115 = inst_30077;
var inst_30077__$1 = tmp30115;
var state_30107__$1 = (function (){var statearr_30118 = state_30107;
(statearr_30118[(11)] = inst_30096);

(statearr_30118[(10)] = inst_30077__$1);

return statearr_30118;
})();
var statearr_30119_30136 = state_30107__$1;
(statearr_30119_30136[(2)] = null);

(statearr_30119_30136[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30108 === (9))){
var inst_30087 = (state_30107[(8)]);
var state_30107__$1 = state_30107;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30107__$1,(11),out,inst_30087);
} else {
if((state_val_30108 === (5))){
var inst_30101 = cljs.core.async.close_BANG_.call(null,out);
var state_30107__$1 = state_30107;
var statearr_30120_30137 = state_30107__$1;
(statearr_30120_30137[(2)] = inst_30101);

(statearr_30120_30137[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30108 === (10))){
var inst_30099 = (state_30107[(2)]);
var state_30107__$1 = state_30107;
var statearr_30121_30138 = state_30107__$1;
(statearr_30121_30138[(2)] = inst_30099);

(statearr_30121_30138[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30108 === (8))){
var inst_30086 = (state_30107[(7)]);
var inst_30087 = (state_30107[(8)]);
var inst_30088 = (state_30107[(9)]);
var inst_30077 = (state_30107[(10)]);
var inst_30091 = (function (){var cs = inst_30077;
var vec__30082 = inst_30086;
var v = inst_30087;
var c = inst_30088;
return (function (p1__30073_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__30073_SHARP_);
});
})();
var inst_30092 = cljs.core.filterv.call(null,inst_30091,inst_30077);
var inst_30077__$1 = inst_30092;
var state_30107__$1 = (function (){var statearr_30122 = state_30107;
(statearr_30122[(10)] = inst_30077__$1);

return statearr_30122;
})();
var statearr_30123_30139 = state_30107__$1;
(statearr_30123_30139[(2)] = null);

(statearr_30123_30139[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28609__auto__ = null;
var cljs$core$async$state_machine__28609__auto____0 = (function (){
var statearr_30124 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30124[(0)] = cljs$core$async$state_machine__28609__auto__);

(statearr_30124[(1)] = (1));

return statearr_30124;
});
var cljs$core$async$state_machine__28609__auto____1 = (function (state_30107){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_30107);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e30125){if((e30125 instanceof Object)){
var ex__28612__auto__ = e30125;
var statearr_30126_30140 = state_30107;
(statearr_30126_30140[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30107);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30125;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30141 = state_30107;
state_30107 = G__30141;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
cljs$core$async$state_machine__28609__auto__ = function(state_30107){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28609__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28609__auto____1.call(this,state_30107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28609__auto____0;
cljs$core$async$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28609__auto____1;
return cljs$core$async$state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_30127 = f__28704__auto__.call(null);
(statearr_30127[(6)] = c__28703__auto___30129);

return statearr_30127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__30143 = arguments.length;
switch (G__30143) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__28703__auto___30188 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_30167){
var state_val_30168 = (state_30167[(1)]);
if((state_val_30168 === (7))){
var inst_30149 = (state_30167[(7)]);
var inst_30149__$1 = (state_30167[(2)]);
var inst_30150 = (inst_30149__$1 == null);
var inst_30151 = cljs.core.not.call(null,inst_30150);
var state_30167__$1 = (function (){var statearr_30169 = state_30167;
(statearr_30169[(7)] = inst_30149__$1);

return statearr_30169;
})();
if(inst_30151){
var statearr_30170_30189 = state_30167__$1;
(statearr_30170_30189[(1)] = (8));

} else {
var statearr_30171_30190 = state_30167__$1;
(statearr_30171_30190[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30168 === (1))){
var inst_30144 = (0);
var state_30167__$1 = (function (){var statearr_30172 = state_30167;
(statearr_30172[(8)] = inst_30144);

return statearr_30172;
})();
var statearr_30173_30191 = state_30167__$1;
(statearr_30173_30191[(2)] = null);

(statearr_30173_30191[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30168 === (4))){
var state_30167__$1 = state_30167;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30167__$1,(7),ch);
} else {
if((state_val_30168 === (6))){
var inst_30162 = (state_30167[(2)]);
var state_30167__$1 = state_30167;
var statearr_30174_30192 = state_30167__$1;
(statearr_30174_30192[(2)] = inst_30162);

(statearr_30174_30192[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30168 === (3))){
var inst_30164 = (state_30167[(2)]);
var inst_30165 = cljs.core.async.close_BANG_.call(null,out);
var state_30167__$1 = (function (){var statearr_30175 = state_30167;
(statearr_30175[(9)] = inst_30164);

return statearr_30175;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30167__$1,inst_30165);
} else {
if((state_val_30168 === (2))){
var inst_30144 = (state_30167[(8)]);
var inst_30146 = (inst_30144 < n);
var state_30167__$1 = state_30167;
if(cljs.core.truth_(inst_30146)){
var statearr_30176_30193 = state_30167__$1;
(statearr_30176_30193[(1)] = (4));

} else {
var statearr_30177_30194 = state_30167__$1;
(statearr_30177_30194[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30168 === (11))){
var inst_30144 = (state_30167[(8)]);
var inst_30154 = (state_30167[(2)]);
var inst_30155 = (inst_30144 + (1));
var inst_30144__$1 = inst_30155;
var state_30167__$1 = (function (){var statearr_30178 = state_30167;
(statearr_30178[(10)] = inst_30154);

(statearr_30178[(8)] = inst_30144__$1);

return statearr_30178;
})();
var statearr_30179_30195 = state_30167__$1;
(statearr_30179_30195[(2)] = null);

(statearr_30179_30195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30168 === (9))){
var state_30167__$1 = state_30167;
var statearr_30180_30196 = state_30167__$1;
(statearr_30180_30196[(2)] = null);

(statearr_30180_30196[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30168 === (5))){
var state_30167__$1 = state_30167;
var statearr_30181_30197 = state_30167__$1;
(statearr_30181_30197[(2)] = null);

(statearr_30181_30197[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30168 === (10))){
var inst_30159 = (state_30167[(2)]);
var state_30167__$1 = state_30167;
var statearr_30182_30198 = state_30167__$1;
(statearr_30182_30198[(2)] = inst_30159);

(statearr_30182_30198[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30168 === (8))){
var inst_30149 = (state_30167[(7)]);
var state_30167__$1 = state_30167;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30167__$1,(11),out,inst_30149);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28609__auto__ = null;
var cljs$core$async$state_machine__28609__auto____0 = (function (){
var statearr_30183 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30183[(0)] = cljs$core$async$state_machine__28609__auto__);

(statearr_30183[(1)] = (1));

return statearr_30183;
});
var cljs$core$async$state_machine__28609__auto____1 = (function (state_30167){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_30167);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e30184){if((e30184 instanceof Object)){
var ex__28612__auto__ = e30184;
var statearr_30185_30199 = state_30167;
(statearr_30185_30199[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30167);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30184;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30200 = state_30167;
state_30167 = G__30200;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
cljs$core$async$state_machine__28609__auto__ = function(state_30167){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28609__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28609__auto____1.call(this,state_30167);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28609__auto____0;
cljs$core$async$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28609__auto____1;
return cljs$core$async$state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_30186 = f__28704__auto__.call(null);
(statearr_30186[(6)] = c__28703__auto___30188);

return statearr_30186;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30202 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30202 = (function (f,ch,meta30203){
this.f = f;
this.ch = ch;
this.meta30203 = meta30203;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30202.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30204,meta30203__$1){
var self__ = this;
var _30204__$1 = this;
return (new cljs.core.async.t_cljs$core$async30202(self__.f,self__.ch,meta30203__$1));
}));

(cljs.core.async.t_cljs$core$async30202.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30204){
var self__ = this;
var _30204__$1 = this;
return self__.meta30203;
}));

(cljs.core.async.t_cljs$core$async30202.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30202.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async30202.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async30202.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30202.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30205 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30205 = (function (f,ch,meta30203,_,fn1,meta30206){
this.f = f;
this.ch = ch;
this.meta30203 = meta30203;
this._ = _;
this.fn1 = fn1;
this.meta30206 = meta30206;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30205.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30207,meta30206__$1){
var self__ = this;
var _30207__$1 = this;
return (new cljs.core.async.t_cljs$core$async30205(self__.f,self__.ch,self__.meta30203,self__._,self__.fn1,meta30206__$1));
}));

(cljs.core.async.t_cljs$core$async30205.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30207){
var self__ = this;
var _30207__$1 = this;
return self__.meta30206;
}));

(cljs.core.async.t_cljs$core$async30205.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30205.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
}));

(cljs.core.async.t_cljs$core$async30205.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30205.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return (function (p1__30201_SHARP_){
return f1.call(null,(((p1__30201_SHARP_ == null))?null:self__.f.call(null,p1__30201_SHARP_)));
});
}));

(cljs.core.async.t_cljs$core$async30205.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30203","meta30203",242735663,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async30202","cljs.core.async/t_cljs$core$async30202",-181940630,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta30206","meta30206",-1962671837,null)], null);
}));

(cljs.core.async.t_cljs$core$async30205.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30205.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30205");

(cljs.core.async.t_cljs$core$async30205.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async30205");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30205.
 */
cljs.core.async.__GT_t_cljs$core$async30205 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async30205(f__$1,ch__$1,meta30203__$1,___$2,fn1__$1,meta30206){
return (new cljs.core.async.t_cljs$core$async30205(f__$1,ch__$1,meta30203__$1,___$2,fn1__$1,meta30206));
});

}

return (new cljs.core.async.t_cljs$core$async30205(self__.f,self__.ch,self__.meta30203,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async30202.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30202.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async30202.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30203","meta30203",242735663,null)], null);
}));

(cljs.core.async.t_cljs$core$async30202.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30202.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30202");

(cljs.core.async.t_cljs$core$async30202.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async30202");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30202.
 */
cljs.core.async.__GT_t_cljs$core$async30202 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async30202(f__$1,ch__$1,meta30203){
return (new cljs.core.async.t_cljs$core$async30202(f__$1,ch__$1,meta30203));
});

}

return (new cljs.core.async.t_cljs$core$async30202(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30208 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30208 = (function (f,ch,meta30209){
this.f = f;
this.ch = ch;
this.meta30209 = meta30209;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30208.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30210,meta30209__$1){
var self__ = this;
var _30210__$1 = this;
return (new cljs.core.async.t_cljs$core$async30208(self__.f,self__.ch,meta30209__$1));
}));

(cljs.core.async.t_cljs$core$async30208.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30210){
var self__ = this;
var _30210__$1 = this;
return self__.meta30209;
}));

(cljs.core.async.t_cljs$core$async30208.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30208.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async30208.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30208.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async30208.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30208.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
}));

(cljs.core.async.t_cljs$core$async30208.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30209","meta30209",928436287,null)], null);
}));

(cljs.core.async.t_cljs$core$async30208.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30208.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30208");

(cljs.core.async.t_cljs$core$async30208.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async30208");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30208.
 */
cljs.core.async.__GT_t_cljs$core$async30208 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async30208(f__$1,ch__$1,meta30209){
return (new cljs.core.async.t_cljs$core$async30208(f__$1,ch__$1,meta30209));
});

}

return (new cljs.core.async.t_cljs$core$async30208(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30211 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30211 = (function (p,ch,meta30212){
this.p = p;
this.ch = ch;
this.meta30212 = meta30212;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30211.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30213,meta30212__$1){
var self__ = this;
var _30213__$1 = this;
return (new cljs.core.async.t_cljs$core$async30211(self__.p,self__.ch,meta30212__$1));
}));

(cljs.core.async.t_cljs$core$async30211.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30213){
var self__ = this;
var _30213__$1 = this;
return self__.meta30212;
}));

(cljs.core.async.t_cljs$core$async30211.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30211.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async30211.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async30211.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30211.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async30211.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30211.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async30211.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30212","meta30212",-1879936888,null)], null);
}));

(cljs.core.async.t_cljs$core$async30211.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30211.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30211");

(cljs.core.async.t_cljs$core$async30211.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async30211");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30211.
 */
cljs.core.async.__GT_t_cljs$core$async30211 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async30211(p__$1,ch__$1,meta30212){
return (new cljs.core.async.t_cljs$core$async30211(p__$1,ch__$1,meta30212));
});

}

return (new cljs.core.async.t_cljs$core$async30211(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__30215 = arguments.length;
switch (G__30215) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__28703__auto___30255 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_30236){
var state_val_30237 = (state_30236[(1)]);
if((state_val_30237 === (7))){
var inst_30232 = (state_30236[(2)]);
var state_30236__$1 = state_30236;
var statearr_30238_30256 = state_30236__$1;
(statearr_30238_30256[(2)] = inst_30232);

(statearr_30238_30256[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30237 === (1))){
var state_30236__$1 = state_30236;
var statearr_30239_30257 = state_30236__$1;
(statearr_30239_30257[(2)] = null);

(statearr_30239_30257[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30237 === (4))){
var inst_30218 = (state_30236[(7)]);
var inst_30218__$1 = (state_30236[(2)]);
var inst_30219 = (inst_30218__$1 == null);
var state_30236__$1 = (function (){var statearr_30240 = state_30236;
(statearr_30240[(7)] = inst_30218__$1);

return statearr_30240;
})();
if(cljs.core.truth_(inst_30219)){
var statearr_30241_30258 = state_30236__$1;
(statearr_30241_30258[(1)] = (5));

} else {
var statearr_30242_30259 = state_30236__$1;
(statearr_30242_30259[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30237 === (6))){
var inst_30218 = (state_30236[(7)]);
var inst_30223 = p.call(null,inst_30218);
var state_30236__$1 = state_30236;
if(cljs.core.truth_(inst_30223)){
var statearr_30243_30260 = state_30236__$1;
(statearr_30243_30260[(1)] = (8));

} else {
var statearr_30244_30261 = state_30236__$1;
(statearr_30244_30261[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30237 === (3))){
var inst_30234 = (state_30236[(2)]);
var state_30236__$1 = state_30236;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30236__$1,inst_30234);
} else {
if((state_val_30237 === (2))){
var state_30236__$1 = state_30236;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30236__$1,(4),ch);
} else {
if((state_val_30237 === (11))){
var inst_30226 = (state_30236[(2)]);
var state_30236__$1 = state_30236;
var statearr_30245_30262 = state_30236__$1;
(statearr_30245_30262[(2)] = inst_30226);

(statearr_30245_30262[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30237 === (9))){
var state_30236__$1 = state_30236;
var statearr_30246_30263 = state_30236__$1;
(statearr_30246_30263[(2)] = null);

(statearr_30246_30263[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30237 === (5))){
var inst_30221 = cljs.core.async.close_BANG_.call(null,out);
var state_30236__$1 = state_30236;
var statearr_30247_30264 = state_30236__$1;
(statearr_30247_30264[(2)] = inst_30221);

(statearr_30247_30264[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30237 === (10))){
var inst_30229 = (state_30236[(2)]);
var state_30236__$1 = (function (){var statearr_30248 = state_30236;
(statearr_30248[(8)] = inst_30229);

return statearr_30248;
})();
var statearr_30249_30265 = state_30236__$1;
(statearr_30249_30265[(2)] = null);

(statearr_30249_30265[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30237 === (8))){
var inst_30218 = (state_30236[(7)]);
var state_30236__$1 = state_30236;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30236__$1,(11),out,inst_30218);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28609__auto__ = null;
var cljs$core$async$state_machine__28609__auto____0 = (function (){
var statearr_30250 = [null,null,null,null,null,null,null,null,null];
(statearr_30250[(0)] = cljs$core$async$state_machine__28609__auto__);

(statearr_30250[(1)] = (1));

return statearr_30250;
});
var cljs$core$async$state_machine__28609__auto____1 = (function (state_30236){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_30236);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e30251){if((e30251 instanceof Object)){
var ex__28612__auto__ = e30251;
var statearr_30252_30266 = state_30236;
(statearr_30252_30266[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30236);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30251;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30267 = state_30236;
state_30236 = G__30267;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
cljs$core$async$state_machine__28609__auto__ = function(state_30236){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28609__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28609__auto____1.call(this,state_30236);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28609__auto____0;
cljs$core$async$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28609__auto____1;
return cljs$core$async$state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_30253 = f__28704__auto__.call(null);
(statearr_30253[(6)] = c__28703__auto___30255);

return statearr_30253;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__30269 = arguments.length;
switch (G__30269) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__28703__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_30332){
var state_val_30333 = (state_30332[(1)]);
if((state_val_30333 === (7))){
var inst_30328 = (state_30332[(2)]);
var state_30332__$1 = state_30332;
var statearr_30334_30372 = state_30332__$1;
(statearr_30334_30372[(2)] = inst_30328);

(statearr_30334_30372[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30333 === (20))){
var inst_30298 = (state_30332[(7)]);
var inst_30309 = (state_30332[(2)]);
var inst_30310 = cljs.core.next.call(null,inst_30298);
var inst_30284 = inst_30310;
var inst_30285 = null;
var inst_30286 = (0);
var inst_30287 = (0);
var state_30332__$1 = (function (){var statearr_30335 = state_30332;
(statearr_30335[(8)] = inst_30309);

(statearr_30335[(9)] = inst_30287);

(statearr_30335[(10)] = inst_30285);

(statearr_30335[(11)] = inst_30286);

(statearr_30335[(12)] = inst_30284);

return statearr_30335;
})();
var statearr_30336_30373 = state_30332__$1;
(statearr_30336_30373[(2)] = null);

(statearr_30336_30373[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30333 === (1))){
var state_30332__$1 = state_30332;
var statearr_30337_30374 = state_30332__$1;
(statearr_30337_30374[(2)] = null);

(statearr_30337_30374[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30333 === (4))){
var inst_30273 = (state_30332[(13)]);
var inst_30273__$1 = (state_30332[(2)]);
var inst_30274 = (inst_30273__$1 == null);
var state_30332__$1 = (function (){var statearr_30338 = state_30332;
(statearr_30338[(13)] = inst_30273__$1);

return statearr_30338;
})();
if(cljs.core.truth_(inst_30274)){
var statearr_30339_30375 = state_30332__$1;
(statearr_30339_30375[(1)] = (5));

} else {
var statearr_30340_30376 = state_30332__$1;
(statearr_30340_30376[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30333 === (15))){
var state_30332__$1 = state_30332;
var statearr_30344_30377 = state_30332__$1;
(statearr_30344_30377[(2)] = null);

(statearr_30344_30377[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30333 === (21))){
var state_30332__$1 = state_30332;
var statearr_30345_30378 = state_30332__$1;
(statearr_30345_30378[(2)] = null);

(statearr_30345_30378[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30333 === (13))){
var inst_30287 = (state_30332[(9)]);
var inst_30285 = (state_30332[(10)]);
var inst_30286 = (state_30332[(11)]);
var inst_30284 = (state_30332[(12)]);
var inst_30294 = (state_30332[(2)]);
var inst_30295 = (inst_30287 + (1));
var tmp30341 = inst_30285;
var tmp30342 = inst_30286;
var tmp30343 = inst_30284;
var inst_30284__$1 = tmp30343;
var inst_30285__$1 = tmp30341;
var inst_30286__$1 = tmp30342;
var inst_30287__$1 = inst_30295;
var state_30332__$1 = (function (){var statearr_30346 = state_30332;
(statearr_30346[(9)] = inst_30287__$1);

(statearr_30346[(10)] = inst_30285__$1);

(statearr_30346[(14)] = inst_30294);

(statearr_30346[(11)] = inst_30286__$1);

(statearr_30346[(12)] = inst_30284__$1);

return statearr_30346;
})();
var statearr_30347_30379 = state_30332__$1;
(statearr_30347_30379[(2)] = null);

(statearr_30347_30379[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30333 === (22))){
var state_30332__$1 = state_30332;
var statearr_30348_30380 = state_30332__$1;
(statearr_30348_30380[(2)] = null);

(statearr_30348_30380[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30333 === (6))){
var inst_30273 = (state_30332[(13)]);
var inst_30282 = f.call(null,inst_30273);
var inst_30283 = cljs.core.seq.call(null,inst_30282);
var inst_30284 = inst_30283;
var inst_30285 = null;
var inst_30286 = (0);
var inst_30287 = (0);
var state_30332__$1 = (function (){var statearr_30349 = state_30332;
(statearr_30349[(9)] = inst_30287);

(statearr_30349[(10)] = inst_30285);

(statearr_30349[(11)] = inst_30286);

(statearr_30349[(12)] = inst_30284);

return statearr_30349;
})();
var statearr_30350_30381 = state_30332__$1;
(statearr_30350_30381[(2)] = null);

(statearr_30350_30381[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30333 === (17))){
var inst_30298 = (state_30332[(7)]);
var inst_30302 = cljs.core.chunk_first.call(null,inst_30298);
var inst_30303 = cljs.core.chunk_rest.call(null,inst_30298);
var inst_30304 = cljs.core.count.call(null,inst_30302);
var inst_30284 = inst_30303;
var inst_30285 = inst_30302;
var inst_30286 = inst_30304;
var inst_30287 = (0);
var state_30332__$1 = (function (){var statearr_30351 = state_30332;
(statearr_30351[(9)] = inst_30287);

(statearr_30351[(10)] = inst_30285);

(statearr_30351[(11)] = inst_30286);

(statearr_30351[(12)] = inst_30284);

return statearr_30351;
})();
var statearr_30352_30382 = state_30332__$1;
(statearr_30352_30382[(2)] = null);

(statearr_30352_30382[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30333 === (3))){
var inst_30330 = (state_30332[(2)]);
var state_30332__$1 = state_30332;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30332__$1,inst_30330);
} else {
if((state_val_30333 === (12))){
var inst_30318 = (state_30332[(2)]);
var state_30332__$1 = state_30332;
var statearr_30353_30383 = state_30332__$1;
(statearr_30353_30383[(2)] = inst_30318);

(statearr_30353_30383[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30333 === (2))){
var state_30332__$1 = state_30332;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30332__$1,(4),in$);
} else {
if((state_val_30333 === (23))){
var inst_30326 = (state_30332[(2)]);
var state_30332__$1 = state_30332;
var statearr_30354_30384 = state_30332__$1;
(statearr_30354_30384[(2)] = inst_30326);

(statearr_30354_30384[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30333 === (19))){
var inst_30313 = (state_30332[(2)]);
var state_30332__$1 = state_30332;
var statearr_30355_30385 = state_30332__$1;
(statearr_30355_30385[(2)] = inst_30313);

(statearr_30355_30385[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30333 === (11))){
var inst_30284 = (state_30332[(12)]);
var inst_30298 = (state_30332[(7)]);
var inst_30298__$1 = cljs.core.seq.call(null,inst_30284);
var state_30332__$1 = (function (){var statearr_30356 = state_30332;
(statearr_30356[(7)] = inst_30298__$1);

return statearr_30356;
})();
if(inst_30298__$1){
var statearr_30357_30386 = state_30332__$1;
(statearr_30357_30386[(1)] = (14));

} else {
var statearr_30358_30387 = state_30332__$1;
(statearr_30358_30387[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30333 === (9))){
var inst_30320 = (state_30332[(2)]);
var inst_30321 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_30332__$1 = (function (){var statearr_30359 = state_30332;
(statearr_30359[(15)] = inst_30320);

return statearr_30359;
})();
if(cljs.core.truth_(inst_30321)){
var statearr_30360_30388 = state_30332__$1;
(statearr_30360_30388[(1)] = (21));

} else {
var statearr_30361_30389 = state_30332__$1;
(statearr_30361_30389[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30333 === (5))){
var inst_30276 = cljs.core.async.close_BANG_.call(null,out);
var state_30332__$1 = state_30332;
var statearr_30362_30390 = state_30332__$1;
(statearr_30362_30390[(2)] = inst_30276);

(statearr_30362_30390[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30333 === (14))){
var inst_30298 = (state_30332[(7)]);
var inst_30300 = cljs.core.chunked_seq_QMARK_.call(null,inst_30298);
var state_30332__$1 = state_30332;
if(inst_30300){
var statearr_30363_30391 = state_30332__$1;
(statearr_30363_30391[(1)] = (17));

} else {
var statearr_30364_30392 = state_30332__$1;
(statearr_30364_30392[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30333 === (16))){
var inst_30316 = (state_30332[(2)]);
var state_30332__$1 = state_30332;
var statearr_30365_30393 = state_30332__$1;
(statearr_30365_30393[(2)] = inst_30316);

(statearr_30365_30393[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30333 === (10))){
var inst_30287 = (state_30332[(9)]);
var inst_30285 = (state_30332[(10)]);
var inst_30292 = cljs.core._nth.call(null,inst_30285,inst_30287);
var state_30332__$1 = state_30332;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30332__$1,(13),out,inst_30292);
} else {
if((state_val_30333 === (18))){
var inst_30298 = (state_30332[(7)]);
var inst_30307 = cljs.core.first.call(null,inst_30298);
var state_30332__$1 = state_30332;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30332__$1,(20),out,inst_30307);
} else {
if((state_val_30333 === (8))){
var inst_30287 = (state_30332[(9)]);
var inst_30286 = (state_30332[(11)]);
var inst_30289 = (inst_30287 < inst_30286);
var inst_30290 = inst_30289;
var state_30332__$1 = state_30332;
if(cljs.core.truth_(inst_30290)){
var statearr_30366_30394 = state_30332__$1;
(statearr_30366_30394[(1)] = (10));

} else {
var statearr_30367_30395 = state_30332__$1;
(statearr_30367_30395[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__28609__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__28609__auto____0 = (function (){
var statearr_30368 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30368[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__28609__auto__);

(statearr_30368[(1)] = (1));

return statearr_30368;
});
var cljs$core$async$mapcat_STAR__$_state_machine__28609__auto____1 = (function (state_30332){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_30332);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e30369){if((e30369 instanceof Object)){
var ex__28612__auto__ = e30369;
var statearr_30370_30396 = state_30332;
(statearr_30370_30396[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30332);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30369;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30397 = state_30332;
state_30332 = G__30397;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__28609__auto__ = function(state_30332){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__28609__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__28609__auto____1.call(this,state_30332);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__28609__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__28609__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_30371 = f__28704__auto__.call(null);
(statearr_30371[(6)] = c__28703__auto__);

return statearr_30371;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));

return c__28703__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__30399 = arguments.length;
switch (G__30399) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__30402 = arguments.length;
switch (G__30402) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__30405 = arguments.length;
switch (G__30405) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__28703__auto___30452 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_30429){
var state_val_30430 = (state_30429[(1)]);
if((state_val_30430 === (7))){
var inst_30424 = (state_30429[(2)]);
var state_30429__$1 = state_30429;
var statearr_30431_30453 = state_30429__$1;
(statearr_30431_30453[(2)] = inst_30424);

(statearr_30431_30453[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30430 === (1))){
var inst_30406 = null;
var state_30429__$1 = (function (){var statearr_30432 = state_30429;
(statearr_30432[(7)] = inst_30406);

return statearr_30432;
})();
var statearr_30433_30454 = state_30429__$1;
(statearr_30433_30454[(2)] = null);

(statearr_30433_30454[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30430 === (4))){
var inst_30409 = (state_30429[(8)]);
var inst_30409__$1 = (state_30429[(2)]);
var inst_30410 = (inst_30409__$1 == null);
var inst_30411 = cljs.core.not.call(null,inst_30410);
var state_30429__$1 = (function (){var statearr_30434 = state_30429;
(statearr_30434[(8)] = inst_30409__$1);

return statearr_30434;
})();
if(inst_30411){
var statearr_30435_30455 = state_30429__$1;
(statearr_30435_30455[(1)] = (5));

} else {
var statearr_30436_30456 = state_30429__$1;
(statearr_30436_30456[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30430 === (6))){
var state_30429__$1 = state_30429;
var statearr_30437_30457 = state_30429__$1;
(statearr_30437_30457[(2)] = null);

(statearr_30437_30457[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30430 === (3))){
var inst_30426 = (state_30429[(2)]);
var inst_30427 = cljs.core.async.close_BANG_.call(null,out);
var state_30429__$1 = (function (){var statearr_30438 = state_30429;
(statearr_30438[(9)] = inst_30426);

return statearr_30438;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30429__$1,inst_30427);
} else {
if((state_val_30430 === (2))){
var state_30429__$1 = state_30429;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30429__$1,(4),ch);
} else {
if((state_val_30430 === (11))){
var inst_30409 = (state_30429[(8)]);
var inst_30418 = (state_30429[(2)]);
var inst_30406 = inst_30409;
var state_30429__$1 = (function (){var statearr_30439 = state_30429;
(statearr_30439[(10)] = inst_30418);

(statearr_30439[(7)] = inst_30406);

return statearr_30439;
})();
var statearr_30440_30458 = state_30429__$1;
(statearr_30440_30458[(2)] = null);

(statearr_30440_30458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30430 === (9))){
var inst_30409 = (state_30429[(8)]);
var state_30429__$1 = state_30429;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30429__$1,(11),out,inst_30409);
} else {
if((state_val_30430 === (5))){
var inst_30409 = (state_30429[(8)]);
var inst_30406 = (state_30429[(7)]);
var inst_30413 = cljs.core._EQ_.call(null,inst_30409,inst_30406);
var state_30429__$1 = state_30429;
if(inst_30413){
var statearr_30442_30459 = state_30429__$1;
(statearr_30442_30459[(1)] = (8));

} else {
var statearr_30443_30460 = state_30429__$1;
(statearr_30443_30460[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30430 === (10))){
var inst_30421 = (state_30429[(2)]);
var state_30429__$1 = state_30429;
var statearr_30444_30461 = state_30429__$1;
(statearr_30444_30461[(2)] = inst_30421);

(statearr_30444_30461[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30430 === (8))){
var inst_30406 = (state_30429[(7)]);
var tmp30441 = inst_30406;
var inst_30406__$1 = tmp30441;
var state_30429__$1 = (function (){var statearr_30445 = state_30429;
(statearr_30445[(7)] = inst_30406__$1);

return statearr_30445;
})();
var statearr_30446_30462 = state_30429__$1;
(statearr_30446_30462[(2)] = null);

(statearr_30446_30462[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28609__auto__ = null;
var cljs$core$async$state_machine__28609__auto____0 = (function (){
var statearr_30447 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30447[(0)] = cljs$core$async$state_machine__28609__auto__);

(statearr_30447[(1)] = (1));

return statearr_30447;
});
var cljs$core$async$state_machine__28609__auto____1 = (function (state_30429){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_30429);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e30448){if((e30448 instanceof Object)){
var ex__28612__auto__ = e30448;
var statearr_30449_30463 = state_30429;
(statearr_30449_30463[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30429);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30448;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30464 = state_30429;
state_30429 = G__30464;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
cljs$core$async$state_machine__28609__auto__ = function(state_30429){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28609__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28609__auto____1.call(this,state_30429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28609__auto____0;
cljs$core$async$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28609__auto____1;
return cljs$core$async$state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_30450 = f__28704__auto__.call(null);
(statearr_30450[(6)] = c__28703__auto___30452);

return statearr_30450;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__30466 = arguments.length;
switch (G__30466) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__28703__auto___30532 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_30504){
var state_val_30505 = (state_30504[(1)]);
if((state_val_30505 === (7))){
var inst_30500 = (state_30504[(2)]);
var state_30504__$1 = state_30504;
var statearr_30506_30533 = state_30504__$1;
(statearr_30506_30533[(2)] = inst_30500);

(statearr_30506_30533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30505 === (1))){
var inst_30467 = (new Array(n));
var inst_30468 = inst_30467;
var inst_30469 = (0);
var state_30504__$1 = (function (){var statearr_30507 = state_30504;
(statearr_30507[(7)] = inst_30468);

(statearr_30507[(8)] = inst_30469);

return statearr_30507;
})();
var statearr_30508_30534 = state_30504__$1;
(statearr_30508_30534[(2)] = null);

(statearr_30508_30534[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30505 === (4))){
var inst_30472 = (state_30504[(9)]);
var inst_30472__$1 = (state_30504[(2)]);
var inst_30473 = (inst_30472__$1 == null);
var inst_30474 = cljs.core.not.call(null,inst_30473);
var state_30504__$1 = (function (){var statearr_30509 = state_30504;
(statearr_30509[(9)] = inst_30472__$1);

return statearr_30509;
})();
if(inst_30474){
var statearr_30510_30535 = state_30504__$1;
(statearr_30510_30535[(1)] = (5));

} else {
var statearr_30511_30536 = state_30504__$1;
(statearr_30511_30536[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30505 === (15))){
var inst_30494 = (state_30504[(2)]);
var state_30504__$1 = state_30504;
var statearr_30512_30537 = state_30504__$1;
(statearr_30512_30537[(2)] = inst_30494);

(statearr_30512_30537[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30505 === (13))){
var state_30504__$1 = state_30504;
var statearr_30513_30538 = state_30504__$1;
(statearr_30513_30538[(2)] = null);

(statearr_30513_30538[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30505 === (6))){
var inst_30469 = (state_30504[(8)]);
var inst_30490 = (inst_30469 > (0));
var state_30504__$1 = state_30504;
if(cljs.core.truth_(inst_30490)){
var statearr_30514_30539 = state_30504__$1;
(statearr_30514_30539[(1)] = (12));

} else {
var statearr_30515_30540 = state_30504__$1;
(statearr_30515_30540[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30505 === (3))){
var inst_30502 = (state_30504[(2)]);
var state_30504__$1 = state_30504;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30504__$1,inst_30502);
} else {
if((state_val_30505 === (12))){
var inst_30468 = (state_30504[(7)]);
var inst_30492 = cljs.core.vec.call(null,inst_30468);
var state_30504__$1 = state_30504;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30504__$1,(15),out,inst_30492);
} else {
if((state_val_30505 === (2))){
var state_30504__$1 = state_30504;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30504__$1,(4),ch);
} else {
if((state_val_30505 === (11))){
var inst_30484 = (state_30504[(2)]);
var inst_30485 = (new Array(n));
var inst_30468 = inst_30485;
var inst_30469 = (0);
var state_30504__$1 = (function (){var statearr_30516 = state_30504;
(statearr_30516[(10)] = inst_30484);

(statearr_30516[(7)] = inst_30468);

(statearr_30516[(8)] = inst_30469);

return statearr_30516;
})();
var statearr_30517_30541 = state_30504__$1;
(statearr_30517_30541[(2)] = null);

(statearr_30517_30541[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30505 === (9))){
var inst_30468 = (state_30504[(7)]);
var inst_30482 = cljs.core.vec.call(null,inst_30468);
var state_30504__$1 = state_30504;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30504__$1,(11),out,inst_30482);
} else {
if((state_val_30505 === (5))){
var inst_30472 = (state_30504[(9)]);
var inst_30477 = (state_30504[(11)]);
var inst_30468 = (state_30504[(7)]);
var inst_30469 = (state_30504[(8)]);
var inst_30476 = (inst_30468[inst_30469] = inst_30472);
var inst_30477__$1 = (inst_30469 + (1));
var inst_30478 = (inst_30477__$1 < n);
var state_30504__$1 = (function (){var statearr_30518 = state_30504;
(statearr_30518[(12)] = inst_30476);

(statearr_30518[(11)] = inst_30477__$1);

return statearr_30518;
})();
if(cljs.core.truth_(inst_30478)){
var statearr_30519_30542 = state_30504__$1;
(statearr_30519_30542[(1)] = (8));

} else {
var statearr_30520_30543 = state_30504__$1;
(statearr_30520_30543[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30505 === (14))){
var inst_30497 = (state_30504[(2)]);
var inst_30498 = cljs.core.async.close_BANG_.call(null,out);
var state_30504__$1 = (function (){var statearr_30522 = state_30504;
(statearr_30522[(13)] = inst_30497);

return statearr_30522;
})();
var statearr_30523_30544 = state_30504__$1;
(statearr_30523_30544[(2)] = inst_30498);

(statearr_30523_30544[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30505 === (10))){
var inst_30488 = (state_30504[(2)]);
var state_30504__$1 = state_30504;
var statearr_30524_30545 = state_30504__$1;
(statearr_30524_30545[(2)] = inst_30488);

(statearr_30524_30545[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30505 === (8))){
var inst_30477 = (state_30504[(11)]);
var inst_30468 = (state_30504[(7)]);
var tmp30521 = inst_30468;
var inst_30468__$1 = tmp30521;
var inst_30469 = inst_30477;
var state_30504__$1 = (function (){var statearr_30525 = state_30504;
(statearr_30525[(7)] = inst_30468__$1);

(statearr_30525[(8)] = inst_30469);

return statearr_30525;
})();
var statearr_30526_30546 = state_30504__$1;
(statearr_30526_30546[(2)] = null);

(statearr_30526_30546[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28609__auto__ = null;
var cljs$core$async$state_machine__28609__auto____0 = (function (){
var statearr_30527 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30527[(0)] = cljs$core$async$state_machine__28609__auto__);

(statearr_30527[(1)] = (1));

return statearr_30527;
});
var cljs$core$async$state_machine__28609__auto____1 = (function (state_30504){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_30504);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e30528){if((e30528 instanceof Object)){
var ex__28612__auto__ = e30528;
var statearr_30529_30547 = state_30504;
(statearr_30529_30547[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30504);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30528;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30548 = state_30504;
state_30504 = G__30548;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
cljs$core$async$state_machine__28609__auto__ = function(state_30504){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28609__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28609__auto____1.call(this,state_30504);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28609__auto____0;
cljs$core$async$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28609__auto____1;
return cljs$core$async$state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_30530 = f__28704__auto__.call(null);
(statearr_30530[(6)] = c__28703__auto___30532);

return statearr_30530;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__30550 = arguments.length;
switch (G__30550) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__28703__auto___30620 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_30592){
var state_val_30593 = (state_30592[(1)]);
if((state_val_30593 === (7))){
var inst_30588 = (state_30592[(2)]);
var state_30592__$1 = state_30592;
var statearr_30594_30621 = state_30592__$1;
(statearr_30594_30621[(2)] = inst_30588);

(statearr_30594_30621[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30593 === (1))){
var inst_30551 = [];
var inst_30552 = inst_30551;
var inst_30553 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_30592__$1 = (function (){var statearr_30595 = state_30592;
(statearr_30595[(7)] = inst_30553);

(statearr_30595[(8)] = inst_30552);

return statearr_30595;
})();
var statearr_30596_30622 = state_30592__$1;
(statearr_30596_30622[(2)] = null);

(statearr_30596_30622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30593 === (4))){
var inst_30556 = (state_30592[(9)]);
var inst_30556__$1 = (state_30592[(2)]);
var inst_30557 = (inst_30556__$1 == null);
var inst_30558 = cljs.core.not.call(null,inst_30557);
var state_30592__$1 = (function (){var statearr_30597 = state_30592;
(statearr_30597[(9)] = inst_30556__$1);

return statearr_30597;
})();
if(inst_30558){
var statearr_30598_30623 = state_30592__$1;
(statearr_30598_30623[(1)] = (5));

} else {
var statearr_30599_30624 = state_30592__$1;
(statearr_30599_30624[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30593 === (15))){
var inst_30582 = (state_30592[(2)]);
var state_30592__$1 = state_30592;
var statearr_30600_30625 = state_30592__$1;
(statearr_30600_30625[(2)] = inst_30582);

(statearr_30600_30625[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30593 === (13))){
var state_30592__$1 = state_30592;
var statearr_30601_30626 = state_30592__$1;
(statearr_30601_30626[(2)] = null);

(statearr_30601_30626[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30593 === (6))){
var inst_30552 = (state_30592[(8)]);
var inst_30577 = inst_30552.length;
var inst_30578 = (inst_30577 > (0));
var state_30592__$1 = state_30592;
if(cljs.core.truth_(inst_30578)){
var statearr_30602_30627 = state_30592__$1;
(statearr_30602_30627[(1)] = (12));

} else {
var statearr_30603_30628 = state_30592__$1;
(statearr_30603_30628[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30593 === (3))){
var inst_30590 = (state_30592[(2)]);
var state_30592__$1 = state_30592;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30592__$1,inst_30590);
} else {
if((state_val_30593 === (12))){
var inst_30552 = (state_30592[(8)]);
var inst_30580 = cljs.core.vec.call(null,inst_30552);
var state_30592__$1 = state_30592;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30592__$1,(15),out,inst_30580);
} else {
if((state_val_30593 === (2))){
var state_30592__$1 = state_30592;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30592__$1,(4),ch);
} else {
if((state_val_30593 === (11))){
var inst_30556 = (state_30592[(9)]);
var inst_30560 = (state_30592[(10)]);
var inst_30570 = (state_30592[(2)]);
var inst_30571 = [];
var inst_30572 = inst_30571.push(inst_30556);
var inst_30552 = inst_30571;
var inst_30553 = inst_30560;
var state_30592__$1 = (function (){var statearr_30604 = state_30592;
(statearr_30604[(11)] = inst_30570);

(statearr_30604[(7)] = inst_30553);

(statearr_30604[(8)] = inst_30552);

(statearr_30604[(12)] = inst_30572);

return statearr_30604;
})();
var statearr_30605_30629 = state_30592__$1;
(statearr_30605_30629[(2)] = null);

(statearr_30605_30629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30593 === (9))){
var inst_30552 = (state_30592[(8)]);
var inst_30568 = cljs.core.vec.call(null,inst_30552);
var state_30592__$1 = state_30592;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30592__$1,(11),out,inst_30568);
} else {
if((state_val_30593 === (5))){
var inst_30553 = (state_30592[(7)]);
var inst_30556 = (state_30592[(9)]);
var inst_30560 = (state_30592[(10)]);
var inst_30560__$1 = f.call(null,inst_30556);
var inst_30561 = cljs.core._EQ_.call(null,inst_30560__$1,inst_30553);
var inst_30562 = cljs.core.keyword_identical_QMARK_.call(null,inst_30553,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_30563 = ((inst_30561) || (inst_30562));
var state_30592__$1 = (function (){var statearr_30606 = state_30592;
(statearr_30606[(10)] = inst_30560__$1);

return statearr_30606;
})();
if(cljs.core.truth_(inst_30563)){
var statearr_30607_30630 = state_30592__$1;
(statearr_30607_30630[(1)] = (8));

} else {
var statearr_30608_30631 = state_30592__$1;
(statearr_30608_30631[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30593 === (14))){
var inst_30585 = (state_30592[(2)]);
var inst_30586 = cljs.core.async.close_BANG_.call(null,out);
var state_30592__$1 = (function (){var statearr_30610 = state_30592;
(statearr_30610[(13)] = inst_30585);

return statearr_30610;
})();
var statearr_30611_30632 = state_30592__$1;
(statearr_30611_30632[(2)] = inst_30586);

(statearr_30611_30632[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30593 === (10))){
var inst_30575 = (state_30592[(2)]);
var state_30592__$1 = state_30592;
var statearr_30612_30633 = state_30592__$1;
(statearr_30612_30633[(2)] = inst_30575);

(statearr_30612_30633[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30593 === (8))){
var inst_30556 = (state_30592[(9)]);
var inst_30552 = (state_30592[(8)]);
var inst_30560 = (state_30592[(10)]);
var inst_30565 = inst_30552.push(inst_30556);
var tmp30609 = inst_30552;
var inst_30552__$1 = tmp30609;
var inst_30553 = inst_30560;
var state_30592__$1 = (function (){var statearr_30613 = state_30592;
(statearr_30613[(14)] = inst_30565);

(statearr_30613[(7)] = inst_30553);

(statearr_30613[(8)] = inst_30552__$1);

return statearr_30613;
})();
var statearr_30614_30634 = state_30592__$1;
(statearr_30614_30634[(2)] = null);

(statearr_30614_30634[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28609__auto__ = null;
var cljs$core$async$state_machine__28609__auto____0 = (function (){
var statearr_30615 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30615[(0)] = cljs$core$async$state_machine__28609__auto__);

(statearr_30615[(1)] = (1));

return statearr_30615;
});
var cljs$core$async$state_machine__28609__auto____1 = (function (state_30592){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_30592);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e30616){if((e30616 instanceof Object)){
var ex__28612__auto__ = e30616;
var statearr_30617_30635 = state_30592;
(statearr_30617_30635[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30592);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30616;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30636 = state_30592;
state_30592 = G__30636;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
cljs$core$async$state_machine__28609__auto__ = function(state_30592){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28609__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28609__auto____1.call(this,state_30592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28609__auto____0;
cljs$core$async$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28609__auto____1;
return cljs$core$async$state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_30618 = f__28704__auto__.call(null);
(statearr_30618[(6)] = c__28703__auto___30620);

return statearr_30618;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=async.js.map?rel=1594010334862
