// Compiled by ClojureScript 1.10.773 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.20";
figwheel.client.js_stringify = (((((typeof JSON !== 'undefined')) && ((!((JSON.stringify == null))))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x);
}catch (e37271){if((e37271 instanceof Error)){
var e = e37271;
return "Error: Unable to stringify";
} else {
throw e37271;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__37274 = arguments.length;
switch (G__37274) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__37272_SHARP_){
if(typeof p1__37272_SHARP_ === 'string'){
return p1__37272_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__37272_SHARP_);
}
}),args)], null)], null));

return null;
}));

(figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
}));

(figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2);

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__4742__auto__ = [];
var len__4736__auto___37277 = arguments.length;
var i__4737__auto___37278 = (0);
while(true){
if((i__4737__auto___37278 < len__4736__auto___37277)){
args__4742__auto__.push((arguments[i__4737__auto___37278]));

var G__37279 = (i__4737__auto___37278 + (1));
i__4737__auto___37278 = G__37279;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
}));

(figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq37276){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq37276));
}));

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__4742__auto__ = [];
var len__4736__auto___37281 = arguments.length;
var i__4737__auto___37282 = (0);
while(true){
if((i__4737__auto___37282 < len__4736__auto___37281)){
args__4742__auto__.push((arguments[i__4737__auto___37282]));

var G__37283 = (i__4737__auto___37282 + (1));
i__4737__auto___37282 = G__37283;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
}));

(figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq37280){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq37280));
}));

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
(cljs.core._STAR_print_newline_STAR_ = false);

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),"Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",(cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF")].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if(((b === true) || (b === false))){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if(((b === true) || (b === false))){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__37284){
var map__37285 = p__37284;
var map__37285__$1 = (((((!((map__37285 == null))))?(((((map__37285.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37285.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37285):map__37285);
var message = cljs.core.get.call(null,map__37285__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__37285__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__4126__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
if(cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return false;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return ((cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts))));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__28703__auto___37364 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_37336){
var state_val_37337 = (state_37336[(1)]);
if((state_val_37337 === (7))){
var inst_37332 = (state_37336[(2)]);
var state_37336__$1 = state_37336;
var statearr_37338_37365 = state_37336__$1;
(statearr_37338_37365[(2)] = inst_37332);

(statearr_37338_37365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37337 === (1))){
var state_37336__$1 = state_37336;
var statearr_37339_37366 = state_37336__$1;
(statearr_37339_37366[(2)] = null);

(statearr_37339_37366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37337 === (4))){
var inst_37289 = (state_37336[(7)]);
var inst_37289__$1 = (state_37336[(2)]);
var state_37336__$1 = (function (){var statearr_37340 = state_37336;
(statearr_37340[(7)] = inst_37289__$1);

return statearr_37340;
})();
if(cljs.core.truth_(inst_37289__$1)){
var statearr_37341_37367 = state_37336__$1;
(statearr_37341_37367[(1)] = (5));

} else {
var statearr_37342_37368 = state_37336__$1;
(statearr_37342_37368[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37337 === (15))){
var inst_37296 = (state_37336[(8)]);
var inst_37311 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_37296);
var inst_37312 = cljs.core.first.call(null,inst_37311);
var inst_37313 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_37312);
var inst_37314 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37313)].join('');
var inst_37315 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_37314);
var state_37336__$1 = state_37336;
var statearr_37343_37369 = state_37336__$1;
(statearr_37343_37369[(2)] = inst_37315);

(statearr_37343_37369[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37337 === (13))){
var inst_37320 = (state_37336[(2)]);
var state_37336__$1 = state_37336;
var statearr_37344_37370 = state_37336__$1;
(statearr_37344_37370[(2)] = inst_37320);

(statearr_37344_37370[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37337 === (6))){
var state_37336__$1 = state_37336;
var statearr_37345_37371 = state_37336__$1;
(statearr_37345_37371[(2)] = null);

(statearr_37345_37371[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37337 === (17))){
var inst_37318 = (state_37336[(2)]);
var state_37336__$1 = state_37336;
var statearr_37346_37372 = state_37336__$1;
(statearr_37346_37372[(2)] = inst_37318);

(statearr_37346_37372[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37337 === (3))){
var inst_37334 = (state_37336[(2)]);
var state_37336__$1 = state_37336;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37336__$1,inst_37334);
} else {
if((state_val_37337 === (12))){
var inst_37295 = (state_37336[(9)]);
var inst_37309 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_37295,opts);
var state_37336__$1 = state_37336;
if(inst_37309){
var statearr_37347_37373 = state_37336__$1;
(statearr_37347_37373[(1)] = (15));

} else {
var statearr_37348_37374 = state_37336__$1;
(statearr_37348_37374[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37337 === (2))){
var state_37336__$1 = state_37336;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37336__$1,(4),ch);
} else {
if((state_val_37337 === (11))){
var inst_37296 = (state_37336[(8)]);
var inst_37301 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37302 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_37296);
var inst_37303 = cljs.core.async.timeout.call(null,(1000));
var inst_37304 = [inst_37302,inst_37303];
var inst_37305 = (new cljs.core.PersistentVector(null,2,(5),inst_37301,inst_37304,null));
var state_37336__$1 = state_37336;
return cljs.core.async.ioc_alts_BANG_.call(null,state_37336__$1,(14),inst_37305);
} else {
if((state_val_37337 === (9))){
var inst_37296 = (state_37336[(8)]);
var inst_37322 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_37323 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_37296);
var inst_37324 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_37323);
var inst_37325 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37324)].join('');
var inst_37326 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_37325);
var state_37336__$1 = (function (){var statearr_37349 = state_37336;
(statearr_37349[(10)] = inst_37322);

return statearr_37349;
})();
var statearr_37350_37375 = state_37336__$1;
(statearr_37350_37375[(2)] = inst_37326);

(statearr_37350_37375[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37337 === (5))){
var inst_37289 = (state_37336[(7)]);
var inst_37291 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_37292 = (new cljs.core.PersistentArrayMap(null,2,inst_37291,null));
var inst_37293 = (new cljs.core.PersistentHashSet(null,inst_37292,null));
var inst_37294 = figwheel.client.focus_msgs.call(null,inst_37293,inst_37289);
var inst_37295 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_37294);
var inst_37296 = cljs.core.first.call(null,inst_37294);
var inst_37297 = figwheel.client.autoload_QMARK_.call(null);
var state_37336__$1 = (function (){var statearr_37351 = state_37336;
(statearr_37351[(8)] = inst_37296);

(statearr_37351[(9)] = inst_37295);

return statearr_37351;
})();
if(cljs.core.truth_(inst_37297)){
var statearr_37352_37376 = state_37336__$1;
(statearr_37352_37376[(1)] = (8));

} else {
var statearr_37353_37377 = state_37336__$1;
(statearr_37353_37377[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37337 === (14))){
var inst_37307 = (state_37336[(2)]);
var state_37336__$1 = state_37336;
var statearr_37354_37378 = state_37336__$1;
(statearr_37354_37378[(2)] = inst_37307);

(statearr_37354_37378[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37337 === (16))){
var state_37336__$1 = state_37336;
var statearr_37355_37379 = state_37336__$1;
(statearr_37355_37379[(2)] = null);

(statearr_37355_37379[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37337 === (10))){
var inst_37328 = (state_37336[(2)]);
var state_37336__$1 = (function (){var statearr_37356 = state_37336;
(statearr_37356[(11)] = inst_37328);

return statearr_37356;
})();
var statearr_37357_37380 = state_37336__$1;
(statearr_37357_37380[(2)] = null);

(statearr_37357_37380[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37337 === (8))){
var inst_37295 = (state_37336[(9)]);
var inst_37299 = figwheel.client.reload_file_state_QMARK_.call(null,inst_37295,opts);
var state_37336__$1 = state_37336;
if(cljs.core.truth_(inst_37299)){
var statearr_37358_37381 = state_37336__$1;
(statearr_37358_37381[(1)] = (11));

} else {
var statearr_37359_37382 = state_37336__$1;
(statearr_37359_37382[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__28609__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__28609__auto____0 = (function (){
var statearr_37360 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37360[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__28609__auto__);

(statearr_37360[(1)] = (1));

return statearr_37360;
});
var figwheel$client$file_reloader_plugin_$_state_machine__28609__auto____1 = (function (state_37336){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_37336);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e37361){if((e37361 instanceof Object)){
var ex__28612__auto__ = e37361;
var statearr_37362_37383 = state_37336;
(statearr_37362_37383[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37336);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37361;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37384 = state_37336;
state_37336 = G__37384;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__28609__auto__ = function(state_37336){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__28609__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__28609__auto____1.call(this,state_37336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__28609__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__28609__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_37363 = f__28704__auto__.call(null);
(statearr_37363[(6)] = c__28703__auto___37364);

return statearr_37363;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));


return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__37385_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__37385_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(figwheel.client.utils.node_env_QMARK_.call(null)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(goog.userAgent.product.SAFARI){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(goog.userAgent.product.CHROME){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(goog.userAgent.product.FIREFOX){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(goog.userAgent.product.IE){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_37391 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{var sb = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__37387 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__37388 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__37389 = true;
var _STAR_print_fn_STAR__temp_val__37390 = (function (x){
return sb.append(x);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__37389);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__37390);

try{var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
var result_value__$1 = (((!(typeof result_value === 'string')))?cljs.core.pr_str.call(null,result_value):result_value);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"out","out",-910545517),cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value__$1], null));
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__37388);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__37387);
}}catch (e37386){if((e37386 instanceof Error)){
var e = e37386;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_37391], null));
} else {
var e = e37386;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}});
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return (cljs.user = ({}));
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__37392){
var map__37393 = p__37392;
var map__37393__$1 = (((((!((map__37393 == null))))?(((((map__37393.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37393.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37393):map__37393);
var opts = map__37393__$1;
var build_id = cljs.core.get.call(null,map__37393__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return (function (p__37395){
var vec__37396 = p__37395;
var seq__37397 = cljs.core.seq.call(null,vec__37396);
var first__37398 = cljs.core.first.call(null,seq__37397);
var seq__37397__$1 = cljs.core.next.call(null,seq__37397);
var map__37399 = first__37398;
var map__37399__$1 = (((((!((map__37399 == null))))?(((((map__37399.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37399.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37399):map__37399);
var msg = map__37399__$1;
var msg_name = cljs.core.get.call(null,map__37399__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__37397__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,(function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
}));
} else {
return null;
}
});
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__37401){
var vec__37402 = p__37401;
var seq__37403 = cljs.core.seq.call(null,vec__37402);
var first__37404 = cljs.core.first.call(null,seq__37403);
var seq__37403__$1 = cljs.core.next.call(null,seq__37403);
var map__37405 = first__37404;
var map__37405__$1 = (((((!((map__37405 == null))))?(((((map__37405.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37405.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37405):map__37405);
var msg = map__37405__$1;
var msg_name = cljs.core.get.call(null,map__37405__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__37403__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__37407){
var map__37408 = p__37407;
var map__37408__$1 = (((((!((map__37408 == null))))?(((((map__37408.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37408.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37408):map__37408);
var on_compile_warning = cljs.core.get.call(null,map__37408__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__37408__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return (function (p__37410){
var vec__37411 = p__37410;
var seq__37412 = cljs.core.seq.call(null,vec__37411);
var first__37413 = cljs.core.first.call(null,seq__37412);
var seq__37412__$1 = cljs.core.next.call(null,seq__37412);
var map__37414 = first__37413;
var map__37414__$1 = (((((!((map__37414 == null))))?(((((map__37414.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37414.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37414):map__37414);
var msg = map__37414__$1;
var msg_name = cljs.core.get.call(null,map__37414__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__37412__$1;
var pred__37416 = cljs.core._EQ_;
var expr__37417 = msg_name;
if(cljs.core.truth_(pred__37416.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__37417))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__37416.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__37417))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__28703__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_37506){
var state_val_37507 = (state_37506[(1)]);
if((state_val_37507 === (7))){
var inst_37426 = (state_37506[(2)]);
var state_37506__$1 = state_37506;
if(cljs.core.truth_(inst_37426)){
var statearr_37508_37555 = state_37506__$1;
(statearr_37508_37555[(1)] = (8));

} else {
var statearr_37509_37556 = state_37506__$1;
(statearr_37509_37556[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (20))){
var inst_37500 = (state_37506[(2)]);
var state_37506__$1 = state_37506;
var statearr_37510_37557 = state_37506__$1;
(statearr_37510_37557[(2)] = inst_37500);

(statearr_37510_37557[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (27))){
var inst_37496 = (state_37506[(2)]);
var state_37506__$1 = state_37506;
var statearr_37511_37558 = state_37506__$1;
(statearr_37511_37558[(2)] = inst_37496);

(statearr_37511_37558[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (1))){
var inst_37419 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_37506__$1 = state_37506;
if(cljs.core.truth_(inst_37419)){
var statearr_37512_37559 = state_37506__$1;
(statearr_37512_37559[(1)] = (2));

} else {
var statearr_37513_37560 = state_37506__$1;
(statearr_37513_37560[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (24))){
var inst_37498 = (state_37506[(2)]);
var state_37506__$1 = state_37506;
var statearr_37514_37561 = state_37506__$1;
(statearr_37514_37561[(2)] = inst_37498);

(statearr_37514_37561[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (4))){
var inst_37504 = (state_37506[(2)]);
var state_37506__$1 = state_37506;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37506__$1,inst_37504);
} else {
if((state_val_37507 === (15))){
var inst_37502 = (state_37506[(2)]);
var state_37506__$1 = state_37506;
var statearr_37515_37562 = state_37506__$1;
(statearr_37515_37562[(2)] = inst_37502);

(statearr_37515_37562[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (21))){
var inst_37455 = (state_37506[(2)]);
var inst_37456 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_37457 = figwheel.client.auto_jump_to_error.call(null,opts,inst_37456);
var state_37506__$1 = (function (){var statearr_37516 = state_37506;
(statearr_37516[(7)] = inst_37455);

return statearr_37516;
})();
var statearr_37517_37563 = state_37506__$1;
(statearr_37517_37563[(2)] = inst_37457);

(statearr_37517_37563[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (31))){
var inst_37485 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_37506__$1 = state_37506;
if(inst_37485){
var statearr_37518_37564 = state_37506__$1;
(statearr_37518_37564[(1)] = (34));

} else {
var statearr_37519_37565 = state_37506__$1;
(statearr_37519_37565[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (32))){
var inst_37494 = (state_37506[(2)]);
var state_37506__$1 = state_37506;
var statearr_37520_37566 = state_37506__$1;
(statearr_37520_37566[(2)] = inst_37494);

(statearr_37520_37566[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (33))){
var inst_37481 = (state_37506[(2)]);
var inst_37482 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_37483 = figwheel.client.auto_jump_to_error.call(null,opts,inst_37482);
var state_37506__$1 = (function (){var statearr_37521 = state_37506;
(statearr_37521[(8)] = inst_37481);

return statearr_37521;
})();
var statearr_37522_37567 = state_37506__$1;
(statearr_37522_37567[(2)] = inst_37483);

(statearr_37522_37567[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (13))){
var inst_37440 = figwheel.client.heads_up.clear.call(null);
var state_37506__$1 = state_37506;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37506__$1,(16),inst_37440);
} else {
if((state_val_37507 === (22))){
var inst_37461 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_37462 = figwheel.client.heads_up.append_warning_message.call(null,inst_37461);
var state_37506__$1 = state_37506;
var statearr_37523_37568 = state_37506__$1;
(statearr_37523_37568[(2)] = inst_37462);

(statearr_37523_37568[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (36))){
var inst_37492 = (state_37506[(2)]);
var state_37506__$1 = state_37506;
var statearr_37524_37569 = state_37506__$1;
(statearr_37524_37569[(2)] = inst_37492);

(statearr_37524_37569[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (29))){
var inst_37472 = (state_37506[(2)]);
var inst_37473 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_37474 = figwheel.client.auto_jump_to_error.call(null,opts,inst_37473);
var state_37506__$1 = (function (){var statearr_37525 = state_37506;
(statearr_37525[(9)] = inst_37472);

return statearr_37525;
})();
var statearr_37526_37570 = state_37506__$1;
(statearr_37526_37570[(2)] = inst_37474);

(statearr_37526_37570[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (6))){
var inst_37421 = (state_37506[(10)]);
var state_37506__$1 = state_37506;
var statearr_37527_37571 = state_37506__$1;
(statearr_37527_37571[(2)] = inst_37421);

(statearr_37527_37571[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (28))){
var inst_37468 = (state_37506[(2)]);
var inst_37469 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_37470 = figwheel.client.heads_up.display_warning.call(null,inst_37469);
var state_37506__$1 = (function (){var statearr_37528 = state_37506;
(statearr_37528[(11)] = inst_37468);

return statearr_37528;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37506__$1,(29),inst_37470);
} else {
if((state_val_37507 === (25))){
var inst_37466 = figwheel.client.heads_up.clear.call(null);
var state_37506__$1 = state_37506;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37506__$1,(28),inst_37466);
} else {
if((state_val_37507 === (34))){
var inst_37487 = figwheel.client.heads_up.flash_loaded.call(null);
var state_37506__$1 = state_37506;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37506__$1,(37),inst_37487);
} else {
if((state_val_37507 === (17))){
var inst_37446 = (state_37506[(2)]);
var inst_37447 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_37448 = figwheel.client.auto_jump_to_error.call(null,opts,inst_37447);
var state_37506__$1 = (function (){var statearr_37529 = state_37506;
(statearr_37529[(12)] = inst_37446);

return statearr_37529;
})();
var statearr_37530_37572 = state_37506__$1;
(statearr_37530_37572[(2)] = inst_37448);

(statearr_37530_37572[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (3))){
var inst_37438 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_37506__$1 = state_37506;
if(inst_37438){
var statearr_37531_37573 = state_37506__$1;
(statearr_37531_37573[(1)] = (13));

} else {
var statearr_37532_37574 = state_37506__$1;
(statearr_37532_37574[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (12))){
var inst_37434 = (state_37506[(2)]);
var state_37506__$1 = state_37506;
var statearr_37533_37575 = state_37506__$1;
(statearr_37533_37575[(2)] = inst_37434);

(statearr_37533_37575[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (2))){
var inst_37421 = (state_37506[(10)]);
var inst_37421__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_37506__$1 = (function (){var statearr_37534 = state_37506;
(statearr_37534[(10)] = inst_37421__$1);

return statearr_37534;
})();
if(cljs.core.truth_(inst_37421__$1)){
var statearr_37535_37576 = state_37506__$1;
(statearr_37535_37576[(1)] = (5));

} else {
var statearr_37536_37577 = state_37506__$1;
(statearr_37536_37577[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (23))){
var inst_37464 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_37506__$1 = state_37506;
if(inst_37464){
var statearr_37537_37578 = state_37506__$1;
(statearr_37537_37578[(1)] = (25));

} else {
var statearr_37538_37579 = state_37506__$1;
(statearr_37538_37579[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (35))){
var state_37506__$1 = state_37506;
var statearr_37539_37580 = state_37506__$1;
(statearr_37539_37580[(2)] = null);

(statearr_37539_37580[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (19))){
var inst_37459 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_37506__$1 = state_37506;
if(inst_37459){
var statearr_37540_37581 = state_37506__$1;
(statearr_37540_37581[(1)] = (22));

} else {
var statearr_37541_37582 = state_37506__$1;
(statearr_37541_37582[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (11))){
var inst_37430 = (state_37506[(2)]);
var state_37506__$1 = state_37506;
var statearr_37542_37583 = state_37506__$1;
(statearr_37542_37583[(2)] = inst_37430);

(statearr_37542_37583[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (9))){
var inst_37432 = figwheel.client.heads_up.clear.call(null);
var state_37506__$1 = state_37506;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37506__$1,(12),inst_37432);
} else {
if((state_val_37507 === (5))){
var inst_37423 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_37506__$1 = state_37506;
var statearr_37543_37584 = state_37506__$1;
(statearr_37543_37584[(2)] = inst_37423);

(statearr_37543_37584[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (14))){
var inst_37450 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_37506__$1 = state_37506;
if(inst_37450){
var statearr_37544_37585 = state_37506__$1;
(statearr_37544_37585[(1)] = (18));

} else {
var statearr_37545_37586 = state_37506__$1;
(statearr_37545_37586[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (26))){
var inst_37476 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_37506__$1 = state_37506;
if(inst_37476){
var statearr_37546_37587 = state_37506__$1;
(statearr_37546_37587[(1)] = (30));

} else {
var statearr_37547_37588 = state_37506__$1;
(statearr_37547_37588[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (16))){
var inst_37442 = (state_37506[(2)]);
var inst_37443 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_37444 = figwheel.client.heads_up.display_exception.call(null,inst_37443);
var state_37506__$1 = (function (){var statearr_37548 = state_37506;
(statearr_37548[(13)] = inst_37442);

return statearr_37548;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37506__$1,(17),inst_37444);
} else {
if((state_val_37507 === (30))){
var inst_37478 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_37479 = figwheel.client.heads_up.display_warning.call(null,inst_37478);
var state_37506__$1 = state_37506;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37506__$1,(33),inst_37479);
} else {
if((state_val_37507 === (10))){
var inst_37436 = (state_37506[(2)]);
var state_37506__$1 = state_37506;
var statearr_37549_37589 = state_37506__$1;
(statearr_37549_37589[(2)] = inst_37436);

(statearr_37549_37589[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (18))){
var inst_37452 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_37453 = figwheel.client.heads_up.display_exception.call(null,inst_37452);
var state_37506__$1 = state_37506;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37506__$1,(21),inst_37453);
} else {
if((state_val_37507 === (37))){
var inst_37489 = (state_37506[(2)]);
var state_37506__$1 = state_37506;
var statearr_37550_37590 = state_37506__$1;
(statearr_37550_37590[(2)] = inst_37489);

(statearr_37550_37590[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37507 === (8))){
var inst_37428 = figwheel.client.heads_up.flash_loaded.call(null);
var state_37506__$1 = state_37506;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37506__$1,(11),inst_37428);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__28609__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__28609__auto____0 = (function (){
var statearr_37551 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37551[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__28609__auto__);

(statearr_37551[(1)] = (1));

return statearr_37551;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__28609__auto____1 = (function (state_37506){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_37506);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e37552){if((e37552 instanceof Object)){
var ex__28612__auto__ = e37552;
var statearr_37553_37591 = state_37506;
(statearr_37553_37591[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37506);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37552;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37592 = state_37506;
state_37506 = G__37592;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__28609__auto__ = function(state_37506){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__28609__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__28609__auto____1.call(this,state_37506);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__28609__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__28609__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_37554 = f__28704__auto__.call(null);
(statearr_37554[(6)] = c__28703__auto__);

return statearr_37554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));

return c__28703__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__28703__auto___37621 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_37607){
var state_val_37608 = (state_37607[(1)]);
if((state_val_37608 === (1))){
var state_37607__$1 = state_37607;
var statearr_37609_37622 = state_37607__$1;
(statearr_37609_37622[(2)] = null);

(statearr_37609_37622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37608 === (2))){
var state_37607__$1 = state_37607;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37607__$1,(4),ch);
} else {
if((state_val_37608 === (3))){
var inst_37605 = (state_37607[(2)]);
var state_37607__$1 = state_37607;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37607__$1,inst_37605);
} else {
if((state_val_37608 === (4))){
var inst_37595 = (state_37607[(7)]);
var inst_37595__$1 = (state_37607[(2)]);
var state_37607__$1 = (function (){var statearr_37610 = state_37607;
(statearr_37610[(7)] = inst_37595__$1);

return statearr_37610;
})();
if(cljs.core.truth_(inst_37595__$1)){
var statearr_37611_37623 = state_37607__$1;
(statearr_37611_37623[(1)] = (5));

} else {
var statearr_37612_37624 = state_37607__$1;
(statearr_37612_37624[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37608 === (5))){
var inst_37595 = (state_37607[(7)]);
var inst_37597 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_37595);
var state_37607__$1 = state_37607;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37607__$1,(8),inst_37597);
} else {
if((state_val_37608 === (6))){
var state_37607__$1 = state_37607;
var statearr_37613_37625 = state_37607__$1;
(statearr_37613_37625[(2)] = null);

(statearr_37613_37625[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37608 === (7))){
var inst_37603 = (state_37607[(2)]);
var state_37607__$1 = state_37607;
var statearr_37614_37626 = state_37607__$1;
(statearr_37614_37626[(2)] = inst_37603);

(statearr_37614_37626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37608 === (8))){
var inst_37599 = (state_37607[(2)]);
var state_37607__$1 = (function (){var statearr_37615 = state_37607;
(statearr_37615[(8)] = inst_37599);

return statearr_37615;
})();
var statearr_37616_37627 = state_37607__$1;
(statearr_37616_37627[(2)] = null);

(statearr_37616_37627[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__28609__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__28609__auto____0 = (function (){
var statearr_37617 = [null,null,null,null,null,null,null,null,null];
(statearr_37617[(0)] = figwheel$client$heads_up_plugin_$_state_machine__28609__auto__);

(statearr_37617[(1)] = (1));

return statearr_37617;
});
var figwheel$client$heads_up_plugin_$_state_machine__28609__auto____1 = (function (state_37607){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_37607);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e37618){if((e37618 instanceof Object)){
var ex__28612__auto__ = e37618;
var statearr_37619_37628 = state_37607;
(statearr_37619_37628[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37607);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37618;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37629 = state_37607;
state_37607 = G__37629;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__28609__auto__ = function(state_37607){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__28609__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__28609__auto____1.call(this,state_37607);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__28609__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__28609__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_37620 = f__28704__auto__.call(null);
(statearr_37620[(6)] = c__28703__auto___37621);

return statearr_37620;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));


figwheel.client.heads_up.ensure_container.call(null);

return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__28703__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_37635){
var state_val_37636 = (state_37635[(1)]);
if((state_val_37636 === (1))){
var inst_37630 = cljs.core.async.timeout.call(null,(3000));
var state_37635__$1 = state_37635;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37635__$1,(2),inst_37630);
} else {
if((state_val_37636 === (2))){
var inst_37632 = (state_37635[(2)]);
var inst_37633 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_37635__$1 = (function (){var statearr_37637 = state_37635;
(statearr_37637[(7)] = inst_37632);

return statearr_37637;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37635__$1,inst_37633);
} else {
return null;
}
}
});
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__28609__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__28609__auto____0 = (function (){
var statearr_37638 = [null,null,null,null,null,null,null,null];
(statearr_37638[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__28609__auto__);

(statearr_37638[(1)] = (1));

return statearr_37638;
});
var figwheel$client$enforce_project_plugin_$_state_machine__28609__auto____1 = (function (state_37635){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_37635);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e37639){if((e37639 instanceof Object)){
var ex__28612__auto__ = e37639;
var statearr_37640_37642 = state_37635;
(statearr_37640_37642[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37635);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37639;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37643 = state_37635;
state_37635 = G__37643;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__28609__auto__ = function(state_37635){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__28609__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__28609__auto____1.call(this,state_37635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__28609__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__28609__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_37641 = f__28704__auto__.call(null);
(statearr_37641[(6)] = c__28703__auto__);

return statearr_37641;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));

return c__28703__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__5735__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__5735__auto__)){
var figwheel_version = temp__5735__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__28703__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_37650){
var state_val_37651 = (state_37650[(1)]);
if((state_val_37651 === (1))){
var inst_37644 = cljs.core.async.timeout.call(null,(2000));
var state_37650__$1 = state_37650;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37650__$1,(2),inst_37644);
} else {
if((state_val_37651 === (2))){
var inst_37646 = (state_37650[(2)]);
var inst_37647 = ["Figwheel Client Version <strong>",figwheel.client._figwheel_version_,"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_37648 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_37647);
var state_37650__$1 = (function (){var statearr_37652 = state_37650;
(statearr_37652[(7)] = inst_37646);

return statearr_37652;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37650__$1,inst_37648);
} else {
return null;
}
}
});
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__28609__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__28609__auto____0 = (function (){
var statearr_37653 = [null,null,null,null,null,null,null,null];
(statearr_37653[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__28609__auto__);

(statearr_37653[(1)] = (1));

return statearr_37653;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__28609__auto____1 = (function (state_37650){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_37650);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e37654){if((e37654 instanceof Object)){
var ex__28612__auto__ = e37654;
var statearr_37655_37657 = state_37650;
(statearr_37655_37657[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37650);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37654;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37658 = state_37650;
state_37650 = G__37658;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__28609__auto__ = function(state_37650){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__28609__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__28609__auto____1.call(this,state_37650);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__28609__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__28609__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_37656 = f__28704__auto__.call(null);
(statearr_37656[(6)] = c__28703__auto__);

return statearr_37656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));

return c__28703__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__37659){
var map__37660 = p__37659;
var map__37660__$1 = (((((!((map__37660 == null))))?(((((map__37660.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37660.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37660):map__37660);
var file = cljs.core.get.call(null,map__37660__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__37660__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__37660__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__37662 = "";
var G__37662__$1 = (cljs.core.truth_(file)?[G__37662,"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__37662);
var G__37662__$2 = (cljs.core.truth_(line)?[G__37662__$1," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__37662__$1);
if(cljs.core.truth_((function (){var and__4115__auto__ = line;
if(cljs.core.truth_(and__4115__auto__)){
return column;
} else {
return and__4115__auto__;
}
})())){
return [G__37662__$2,", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__37662__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__37663){
var map__37664 = p__37663;
var map__37664__$1 = (((((!((map__37664 == null))))?(((((map__37664.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37664.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37664):map__37664);
var ed = map__37664__$1;
var exception_data = cljs.core.get.call(null,map__37664__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__37664__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
var message_37667 = (function (){var G__37666 = cljs.core.apply.call(null,cljs.core.str,"Figwheel: Compile Exception ",figwheel.client.format_messages.call(null,exception_data));
if(cljs.core.truth_(new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(exception_data))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__37666)," Error on ",figwheel.client.file_line_column.call(null,exception_data)].join('');
} else {
return G__37666;
}
})();
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),message_37667);

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__37668){
var map__37669 = p__37668;
var map__37669__$1 = (((((!((map__37669 == null))))?(((((map__37669.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37669.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37669):map__37669);
var w = map__37669__$1;
var message = cljs.core.get.call(null,map__37669__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",figwheel.client.file_line_column.call(null,message)].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.config_defaults !== 'undefined')){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/out/figwheel/client.cljs",33,1,362,362,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/out/figwheel/client.cljs",30,1,355,355,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(figwheel.client.utils.html_env_QMARK_.call(null)){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = (((!(figwheel.client.utils.html_env_QMARK_.call(null))))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__4115__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__4115__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__4115__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_json_message_watch = (function figwheel$client$add_json_message_watch(key,callback){
return figwheel.client.add_message_watch.call(null,key,cljs.core.comp.call(null,callback,cljs.core.clj__GT_js));
});
goog.exportSymbol('figwheel.client.add_json_message_watch', figwheel.client.add_json_message_watch);
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__37671 = cljs.core.seq.call(null,plugins);
var chunk__37672 = null;
var count__37673 = (0);
var i__37674 = (0);
while(true){
if((i__37674 < count__37673)){
var vec__37681 = cljs.core._nth.call(null,chunk__37672,i__37674);
var k = cljs.core.nth.call(null,vec__37681,(0),null);
var plugin = cljs.core.nth.call(null,vec__37681,(1),null);
if(cljs.core.truth_(plugin)){
var pl_37687 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__37671,chunk__37672,count__37673,i__37674,pl_37687,vec__37681,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_37687.call(null,msg_hist);
});})(seq__37671,chunk__37672,count__37673,i__37674,pl_37687,vec__37681,k,plugin))
);
} else {
}


var G__37688 = seq__37671;
var G__37689 = chunk__37672;
var G__37690 = count__37673;
var G__37691 = (i__37674 + (1));
seq__37671 = G__37688;
chunk__37672 = G__37689;
count__37673 = G__37690;
i__37674 = G__37691;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__37671);
if(temp__5735__auto__){
var seq__37671__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__37671__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__37671__$1);
var G__37692 = cljs.core.chunk_rest.call(null,seq__37671__$1);
var G__37693 = c__4556__auto__;
var G__37694 = cljs.core.count.call(null,c__4556__auto__);
var G__37695 = (0);
seq__37671 = G__37692;
chunk__37672 = G__37693;
count__37673 = G__37694;
i__37674 = G__37695;
continue;
} else {
var vec__37684 = cljs.core.first.call(null,seq__37671__$1);
var k = cljs.core.nth.call(null,vec__37684,(0),null);
var plugin = cljs.core.nth.call(null,vec__37684,(1),null);
if(cljs.core.truth_(plugin)){
var pl_37696 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__37671,chunk__37672,count__37673,i__37674,pl_37696,vec__37684,k,plugin,seq__37671__$1,temp__5735__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_37696.call(null,msg_hist);
});})(seq__37671,chunk__37672,count__37673,i__37674,pl_37696,vec__37684,k,plugin,seq__37671__$1,temp__5735__auto__))
);
} else {
}


var G__37697 = cljs.core.next.call(null,seq__37671__$1);
var G__37698 = null;
var G__37699 = (0);
var G__37700 = (0);
seq__37671 = G__37697;
chunk__37672 = G__37698;
count__37673 = G__37699;
i__37674 = G__37700;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__37702 = arguments.length;
switch (G__37702) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((((!((goog.dependencies_ == null)))) || ((((!((goog.debugLoader_ == null)))) && ((!((goog.debugLoader_.dependencies_ == null)))))))){
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.__figwheel_start_once__ !== 'undefined')){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
(figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts));

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__37703_37708 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__37704_37709 = null;
var count__37705_37710 = (0);
var i__37706_37711 = (0);
while(true){
if((i__37706_37711 < count__37705_37710)){
var msg_37712 = cljs.core._nth.call(null,chunk__37704_37709,i__37706_37711);
figwheel.client.socket.handle_incoming_message.call(null,msg_37712);


var G__37713 = seq__37703_37708;
var G__37714 = chunk__37704_37709;
var G__37715 = count__37705_37710;
var G__37716 = (i__37706_37711 + (1));
seq__37703_37708 = G__37713;
chunk__37704_37709 = G__37714;
count__37705_37710 = G__37715;
i__37706_37711 = G__37716;
continue;
} else {
var temp__5735__auto___37717 = cljs.core.seq.call(null,seq__37703_37708);
if(temp__5735__auto___37717){
var seq__37703_37718__$1 = temp__5735__auto___37717;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__37703_37718__$1)){
var c__4556__auto___37719 = cljs.core.chunk_first.call(null,seq__37703_37718__$1);
var G__37720 = cljs.core.chunk_rest.call(null,seq__37703_37718__$1);
var G__37721 = c__4556__auto___37719;
var G__37722 = cljs.core.count.call(null,c__4556__auto___37719);
var G__37723 = (0);
seq__37703_37708 = G__37720;
chunk__37704_37709 = G__37721;
count__37705_37710 = G__37722;
i__37706_37711 = G__37723;
continue;
} else {
var msg_37724 = cljs.core.first.call(null,seq__37703_37718__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_37724);


var G__37725 = cljs.core.next.call(null,seq__37703_37718__$1);
var G__37726 = null;
var G__37727 = (0);
var G__37728 = (0);
seq__37703_37708 = G__37725;
chunk__37704_37709 = G__37726;
count__37705_37710 = G__37727;
i__37706_37711 = G__37728;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
} else {
return null;
}
}));

(figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
}));

(figwheel.client.start.cljs$lang$maxFixedArity = 1);

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__4742__auto__ = [];
var len__4736__auto___37733 = arguments.length;
var i__4737__auto___37734 = (0);
while(true){
if((i__4737__auto___37734 < len__4736__auto___37733)){
args__4742__auto__.push((arguments[i__4737__auto___37734]));

var G__37735 = (i__4737__auto___37734 + (1));
i__4737__auto___37734 = G__37735;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__37730){
var map__37731 = p__37730;
var map__37731__$1 = (((((!((map__37731 == null))))?(((((map__37731.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37731.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37731):map__37731);
var opts = map__37731__$1;
return figwheel.client.start.call(null,opts);
}));

(figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq37729){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq37729));
}));

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e37736){if((e37736 instanceof Error)){
var e = e37736;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e37736;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
(goog.dependencies_ = true);
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),(function (p__37737){
var map__37738 = p__37737;
var map__37738__$1 = (((((!((map__37738 == null))))?(((((map__37738.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37738.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37738):map__37738);
var msg_name = cljs.core.get.call(null,map__37738__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return (location.href = location.href);
} else {
return null;
}
}));
});

//# sourceMappingURL=client.js.map?rel=1594010344535
