(ns net.markokrstic.lib.rest)

(defn- error-formatter
  [message body]
  (let [content (merge {:message message} body)]
    {:error content}))

(defn resp
  [status body]
  {:status status :body body})

(defn error
  ([status message]
   (error status message {}))
  ([status message additional-data]
   (resp status (error-formatter message additional-data))))