(ns net.markokrstic.lib.exception
  (:refer-clojure :exclude [ex-message]))

(defn throw-ex
  ([message]
   (throw-ex message :general))
  ([message type & additional-messages]
   (throw (ex-info message {:addition {:type type :messages additional-messages}}))))

(defn- addition
  [ex]
  (:addition (ex-data ex)))

(defn ex-type
  [ex]
  (:type (addition ex)))

(defn ex-additional-messages
  [ex]
  (:messages (addition ex)))

(defn ex-message
  [ex]
  (.getMessage ex))