(ns ^{:doc "Custom implementation of RemoteWebDriver, adding support for screenshots."}
  clj-webdriver.ext.remote.RemoteWebDriverExt
  (:import [org.openqa.selenium.remote DriverCommand RemoteWebDriver])
  (:require [clojure.tools.logging :as lg])
  (:gen-class
   :main false
   :extends org.openqa.selenium.remote.RemoteWebDriver
   :implements [org.openqa.selenium.TakesScreenshot]
   :exposes-methods {init super-init
                     startSession super-start-session
                     execute super-execute}))

(defn -init [this desired-caps required-caps]
  (lg/info "initting")
  (let [re (.super-init this desired-caps required-caps)]
    (lg/info "finished init")
    re))

(defn -startSession [this desired-caps & [required-caps]]
  (lg/info "starting session")
  (let [re (.super-start-session this desired-caps required-caps)]
    (lg/info "started session")
    re))

(defn -execute [this cmd & [options]]
  (if options
    (do (lg/info "running execute" cmd options)
        (let [re (.super-execute this cmd options)]
          (lg/info "ran execute" re)
          re))
    (.super-execute this cmd)))

(defn -log [this session-id command-name to-log when]
  (when (-> (System/getenv "RFZ_QA_SERVER") (= "rfz-selenium"))
    (lg/info "SELENIUM!!!" session-id command-name to-log when)))

(defn -getScreenshotAs
  [this target]
  (let [base64 (->> DriverCommand/SCREENSHOT
                    (.execute this)
                    .getValue
                    str)]
    (.convertFromBase64Png target base64)))








