(ns materia.component.figwheel
  (:require [clojurescript-build.auto :as auto]
            [com.stuartsierra.component :as c]
            [figwheel-sidecar.auto-builder :as fig-auto]
            [figwheel-sidecar.core :as fig]
            [materia.logging :as log]))

(defn builds-conf-map->vector [conf]
  (update-in conf [:builds] (fn [bs]
                              (if (map? bs)
                                (map (fn [[k v]]
                                       (assoc v :id (name k))) bs)
                                bs))))

(defrecord Figwheel [conf]
  c/Lifecycle
  (start [this]
    (if (not (get-in conf [:figwheel :enabled]))
      this
      (do
        (log/info "Starting figwheel server")
        (let [server (fig/start-server (:figwheel conf))
              builder (fig-auto/autobuild* (builds-conf-map->vector
                                            (assoc (:cljsbuld conf {:builds []})
                                                   :figwheel-server server)))]


          (assoc this :figwheel-server server :cljs-builder builder)))))
  (stop [this]
    (log/info "Shutting down figwheel server")
    (let [server (:figwheel-server this)
          builder (:cljs-builder this)]
      (if builder
        (auto/stop-autobuild! builder))
      (if server
        (fig/stop-server server))
      (assoc this :figwheel-server nil :cljs-builder nil))
    this))

(defn new-figwheel [conf]
  (->Figwheel (select-keys conf [:figwheel :cljsbuld])))
