(ns materia.routes
  (:require [clojurewerkz.route-one.compojure :refer :all]
            [compojure.core :as compojure]
            [compojure.route :as route]
            [prone.debug :refer [debug]]))

(compojure/defroutes main-routes
  (route/resources "/react" {:root "reagent"})
  (GET root "/" req (str "<html><head></head><body><pre>" (with-out-str (clojure.pprint/pprint req)) "</pre><script src=\"/js/dist/app.js\"></script></body></html>"))
  (GET cljs "/cljs" req (str "<html><head></head><body><div id=\"app\"></div><script src=\"/js/dist/app.js\"></script></body></html>"))
  (GET hello "/hello/:who" [who] (str "Hello " who "!"))
  (GET prone "/prone" [] (let [v "foo"]
                           (debug)))
  (route/not-found "<h1>Page not found</h1>"))
