(ns materia.config
  (:require [clojure.java.io :as io]
            [materia.utils :as u]
            [nomad :refer [read-config]]
            [puppetlabs.kitchensink.core :refer [deep-merge-with-keys]]
            [puppetlabs.trapperkeeper.config :refer [config-file->map] :as tkc]))

(defmacro with-nomad
  "Replace TrapperKeeper's config loader with nomad."
  [& body]
  `(with-redefs [deep-merge-with-keys (fn [~'_ & vs#]
                                        (apply u/deep-merge vs#))
                 config-file->map (fn [file#]
                                    (read-config (io/file file#)))]
     ~@body))

(defn load-config
  "Load TrapperKeeper's config file with nomad"
  [file]
  (with-nomad
    (tkc/load-config file)))
