(ns materia.services.middleware.service
  (:require [materia.middleware :as middleware]
            [puppetlabs.trapperkeeper.core :refer [defservice]]
            [puppetlabs.trapperkeeper.services :refer [service-context]]
            [ring.middleware.defaults :refer [site-defaults]]
            [taoensso.timbre :as log]))

(defprotocol MiddlewareService
  (add-middleware [this m priority])
  (add-middlewares [this ms])
  (wrap [this handler]))

(defservice middleware-service
  MiddlewareService
  []
  (init [this context]
        (assoc context :middlewares (atom [])))
  (stop [this context]
        (dissoc context :middlewares))
  (add-middleware [this priority m]
                  (let [context (service-context this)]
                    (swap! (:middlewares context) conj [priority m])))
  (add-middlewares [this ms]
                   (doseq [[p m] ms]
                     (add-middleware this p m)))
  (wrap [this handler]
        (let [context (service-context this)]
          (->> @(:middlewares context)
               (sort-by first)
               (reduce (fn [h [p m]]
                         (log/debugf "Applying middleware [%3d] %s" p m)
                         (m h)) handler)))))
