(ns materia.routes
  (:require [clojurewerkz.route-one.compojure :refer :all]
            [compojure.core :as compojure]
            [compojure.route :as route]
            [materia.view :refer [deflayout]]
            [net.cgrand.enlive-html :as html]
            [prone.debug :refer [debug]]))

(deflayout app-layout
  "templates/layouts/application.html"
  [content]
  [:#content] (html/content content))

(compojure/defroutes main-routes
  (route/resources "/react" {:root "reagent"})
  (GET root "/" req (app-layout (html/html [:pre (with-out-str (clojure.pprint/pprint req))])))
  (GET cljs "/cljs" req (app-layout (html/html [:div#app ])))
  (GET hello "/hello/:who" [who] (str "Hello " who "!"))
  (GET prone "/prone" [] (let [v "foo"]
                           (debug)))
  (route/not-found "<h1>Page not found</h1>"))
