(defproject materia/materia-core "0.1.2-SNAPSHOT"
  :description "A collection of reusable components for Clojure web applications"
  :min-lein-version "2.5.1"
  :repl-options {:init-ns materia.repl}
  :dependencies [[org.clojure/clojure "1.6.0"]

                 ;; Web
                 [org.immutant/immutant "2.0.0"]
                 [compojure "1.3.4"]
                 [ring/ring-defaults "0.1.5"]
                 [prone "0.8.1"]
                 [enlive "1.1.5"]

                 ;; Service management
                 [puppetlabs/trapperkeeper "1.1.1"]

                 ;; Logging
                 [com.taoensso/timbre "3.4.0"]

                 ;; DB
                 [mysql/mysql-connector-java "5.1.35"]
                 [clojure.jdbc "0.4.0"]
                 [hikari-cp "1.2.3" :exclusions [com.zaxxer/HikariCP]]
                 [com.zaxxer/HikariCP-java6 "2.3.7"]
                 [stch-library/sql "0.1.1"]
                 [clj-liquibase "0.5.2"]

                 ;; misc
                 [org.clojure/tools.nrepl "0.2.10"] ; required because of leiningen's bug
                 [org.clojure/tools.namespace "0.2.10"]
                 [rkworks/baum "0.2.0"]
                 [environ "1.0.0"]
                 [clj-time "0.9.0"]
                 [inflections "0.9.14"]]
  :plugins [[lein-environ "1.0.0"]
            [lein-modules "0.3.11"]]
  :profiles {:uberjar {:aot [materia.main]}
             :dev {:dependencies [[clj-http "1.1.2"]
                                  [ring/ring-devel "1.3.2"]
                                  [midje "1.6.3"]
                                  [puppetlabs/trapperkeeper "1.1.1" :classifier "test"]
                                  [puppetlabs/kitchensink "1.1.0" :classifier "test"]
                                  [com.h2database/h2 "1.4.187"]]
                   :plugins      [[lein-midje "3.1.3"]]
                   :env          {:dev true}}}
  :aliases {"tk" ["trampoline" "run" "--config" "resources/config/config.edn"]}
  :main materia.main)
