(ns materia.routes
  (:require [materia.view :refer [deflayout]]
            [net.cgrand.enlive-html :as html]
            [prone.debug :refer [debug]]
            [ring.util.response :as res]))

(deflayout app-layout
  "templates/layouts/application.html"
  [content]
  [:#content] (html/content content))

(defn home [req]
  (-> (html/html (list
                  [:div.page-header
                   [:h1 "Welcome to Materia"]]
                  [:pre (with-out-str (clojure.pprint/pprint req))]))
      app-layout
      res/response
      (res/content-type "text/html")))
