(ns materia.services.db.service
  (:require [hikari-cp.core :as pool]
            [materia.services.db.core :as core]
            [puppetlabs.trapperkeeper.core :refer [defservice]]
            [puppetlabs.trapperkeeper.services :refer [service-context]]
            [taoensso.timbre :as log]))

(defprotocol DatabaseService
  (wrap-db [this handler])
  (wrap-with-db [this handler])
  (get-datasource [this]))

;;; TODO: multiple db spec
(defservice db-service
  DatabaseService
  [[:ConfigService get-in-config]]
  (init [this context]
        (log/info "Initializing database")
        (let [spec (get-in-config [:db])
              ds   (pool/make-datasource spec)]
          (alter-var-root #'core/*current-db* (constantly ds)) ; For dev
          (assoc context :db ds)))
  (stop [this context]
        (log/info "Shutting down database")
        (when-let [src (:db context)]
          (.close src)
          (alter-var-root #'core/*current-db* (constantly nil)))
        (dissoc context :db))
  (wrap-db [this handler]
           (let [context (service-context this)
                 db (:db context)]
             (fn [req]
               (handler (assoc req :db db)))))
  (wrap-with-db [this handler]
                (let [context (service-context this)
                      db (:db context)]
                  (fn [req]
                    (core/with-db db
                      (handler req)))))
  (get-datasource [this]
                  (let [context (service-context this)]
                    (:db context))))
