(defproject materia/materia-core "0.3.0-SNAPSHOT"
  :description "A collection of reusable components for Clojure web applications"
  :min-lein-version "2.5.1"
  :repl-options {:init-ns materia.repl}
  :dependencies [[org.clojure/clojure "1.6.0"]

                 ;; Web
                 [org.immutant/immutant "2.0.1"]
                 [ring/ring-defaults "0.1.5"]
                 [ring/ring-core "1.4.0-RC1"]
                 [ring/ring-devel "1.4.0-RC1"]
                 [metosin/ring-http-response "0.6.2"]
                 [ronda/routing "0.2.7"]
                 [ronda/routing-bidi "0.1.1"]
                 [prone "0.8.2"]
                 [enlive "1.1.5"]

                 ;; Service management
                 [com.stuartsierra/component "0.2.3"]

                 ;; Logging
                 [org.clojure/tools.logging "0.3.1"]
                 [org.slf4j/jcl-over-slf4j "1.7.12"]
                 [org.slf4j/jul-to-slf4j "1.7.12"]
                 [org.slf4j/log4j-over-slf4j "1.7.12"]
                 [ch.qos.logback/logback-classic "1.1.3" :exclusions [org.slf4j/slf4j-api]]
                 [io.aviso/pretty "0.1.18"]

                 ;; DB
                 [mysql/mysql-connector-java "5.1.35"]
                 [funcool/clojure.jdbc "0.5.1"]
                 [hikari-cp "1.2.4" :exclusions [com.zaxxer/HikariCP]]
                 [com.zaxxer/HikariCP-java6 "2.3.8"]
                 [stch-library/sql "0.1.1"]
                 [clj-liquibase "0.5.2"]

                 ;; misc
                 [potemkin "0.3.13"]
                 [medley "0.6.0"]
                 [org.clojure/tools.cli "0.3.1"]
                 [org.clojure/tools.namespace "0.2.10"]
                 [org.clojure/tools.nrepl "0.2.10"] ; https://github.com/technomancy/leiningen/issues/1748
                 [rkworks/baum "0.2.0"]
                 [environ "1.0.0"]
                 [clj-time "0.9.0"]
                 [inflections "0.9.14"]]
  :plugins [[lein-environ "1.0.0"]
            [lein-modules "0.3.11"]]
  :profiles {:uberjar {:aot :all}
             :dev {:dependencies [[commons-io "2.4"]
                                  [clj-http "1.1.2"]
                                  [midje "1.6.3"]
                                  [com.h2database/h2 "1.4.187"]]
                   :plugins      [[lein-midje "3.1.3"]]
                   :env          {:dev true}}}
  :aliases {"tk" ["trampoline" "run" "--config" "resources/config/config.edn"]}
  :main materia.main)
