(ns materia.enlive
  (:require [materia.util.namespace :refer [import-ns]]
            [net.cgrand.enlive-html :as html]))

(import-ns net.cgrand.enlive-html)

(defmacro deftemplate
  [layout-name source args & forms]
  `(def ~(vary-meta layout-name assoc :materia/reload true)
     (html/template ~source ~args ~@forms)))

(defmacro defsnippet
  [name source selector args & forms]
  `(def ~(vary-meta name assoc :materia/reload true)
     (html/snippet ~source ~selector ~args ~@forms)))

(defmacro defsnippets
  [source & specs]
  (let [xml-sym (gensym "xml")]
    `(let [~xml-sym (html/html-resource ~source)]
       ~@(for [[name selector args & forms] specs]
           `(def ~(vary-meta name assoc :materia/reload true)
              (html/snippet ~xml-sym ~selector ~args ~@forms))))))
