(ns materia.sql
  (:require [materia.util.namespace :refer [import-ns]]
            [schema.core :as s]
            [stch.sql.format :as fmt]))

(import-ns stch.sql)

(defprotocol ISQLFormat
  (sql-format [this opts]))

(extend-protocol ISQLFormat
  java.lang.String
  (sql-format [this opts] this)

  clojure.lang.IPersistentVector
  (sql-format [this opts] this)

  clojure.lang.IPersistentMap
  (sql-format [this opts]
    (apply fmt/format this (reduce into [] opts))))
