(ns materia.util.cli
  (:require [clojure.java.io :as io]
            [clojure.string :as str]
            [clojure.tools.cli :refer [parse-opts]]))

(def cli-options
  [["-c" "--config CONFIG_FILE" "Config file"
    :parse-fn io/file
    :default (io/resource "config/config.edn")
    :validate [#(and (.exists ^java.io.File %) (.isFile ^java.io.File %)) "No such file"]]
   ["-h" "--help"]])

(defn usage [options-summary]
  (->> ["Usage: lein run -- [options] or java -jar <jar> -- [options]"
        ""
        "Options:"
        options-summary]
       (str/join \newline)))

(defn error-msg [errors]
  (str "The following errors occurred while parsing your command:\n\n"
       (str/join \newline errors)))

(defn exit [status msg]
  (println msg)
  (System/exit status))

(defn handle-options! [args]
  (let [{:keys [options arguments errors summary]} (parse-opts args cli-options)]
    ;; Handle help and error conditions
    (cond
      (:help options) (exit 0 (usage summary))
      (not= (count arguments) 0) (exit 1 (usage summary))
      errors (exit 1 (error-msg errors)))
    options))
