(ns materia.middleware.request
  (:require [clojure.pprint :refer [pprint]]
            [materia.logging :as log]
            [materia.request :refer [*request*]]))

(defn wrap-request-binding [handler]
  (fn [req]
    (binding [*request* req]
      (handler req))))

(defn wrap-request-logger [handler]
  (fn [req]
    (log/info (with-out-str (pprint req)))
    (handler req)))
