(ns materia.component.auto-migrator
  (:require [com.stuartsierra.component :as c]
            [materia.component.migrator :as mig]))

(defrecord AutoMigrator [conf migrator]
  c/Lifecycle
  (start [this]
    (when (:auto-migration conf)
      (mig/migrate migrator))
    this)
  (stop [this]
    this))

(defn new-auto-migrator [conf]
  (map->AutoMigrator {:conf (:migration conf)}))
