(ns materia.sql
  (:refer-clojure :exclude [update])
  (:require [materia.util.namespace :refer [import-ns]]
            [potemkin :refer [import-vars]]
            [schema.core :as s]
            [stch.sql.format :as fmt]
            stch.sql.types))

(import-ns stch.sql)

(import-vars [stch.sql.types
              raw
              call])

(defprotocol ISQLFormat
  (sql-format [this opts]))

(extend-protocol ISQLFormat
  java.lang.String
  (sql-format [this opts] this)

  clojure.lang.IPersistentVector
  (sql-format [this opts] this)

  clojure.lang.IPersistentMap
  (sql-format [this opts]
    (apply fmt/format this (reduce into [] opts))))

(extend-protocol fmt/ToSQL
  clojure.lang.Cons
  (-to-sql [x]
    (fmt/-to-sql (apply list x))))

(defmethod fmt/fn-handler "case-when" [_ test then else]
  (str "CASE WHEN " (fmt/to-sql test)
       " THEN "     (fmt/to-sql then)
       " ELSE "     (fmt/to-sql else)
       " END"))
