(ns materia.preset.routes
  (:require [materia.enlive :as html]
            [materia.handler :refer [defhandler]]
            [materia.response :as res]))

(html/deftemplate app-layout
  "templates/layouts/application.html"
  [content]
  [:#content] (html/content content))

(defhandler home ::default [req]
  (-> (html/html (list
                  [:div.page-header
                   [:h1 "Welcome to Materia"]]
                  [:pre (with-out-str (clojure.pprint/pprint req))]))
      app-layout
      res/ok
      (res/content-type "text/html")))

(def main ["/" ::default])
