(ns materia.handler
  (:require [materia.logging :as log]
            [materia.util.namespace :refer [find-tagged-vars]]))

(defmacro defhandler [name tag & rest-fn-spec]
  `(defn ~(vary-meta name assoc ::handler-tag tag)
     ~@rest-fn-spec))

(defn collect-handlers []
  (find-tagged-vars ::handler-tag))

(defn- collect-conflicted-tags [pairs]
  (->> (group-by first pairs)
       (map (fn [[k v]] [k (map second v)]))
       (filter #(> (count (second %)) 1))))

(defn- warn-conflicted! [pairs]
  (doseq [[tag handlers] (collect-conflicted-tags pairs)]
    (log/warn "Conflicted handler tags:" tag (vec handlers)))
  pairs)

(defn build-handler-dic [handlers]
  (->> handlers
       (map #(vector (get (meta %) ::handler-tag) %))
       warn-conflicted!
       (into {})))

(defn create-handler-resolver []
  (let [handler-dic (build-handler-dic (collect-handlers))]
    (fn handler-resolver [tag]
      (cond
        (keyword? tag) (get handler-dic tag)
        (fn? tag)      tag))))
